#include "stm32f103c8t6.h"
#include "mbed.h"
#include "CAN.h"

#define board_transmitter
Serial pc(USBTX,USBRX,115200);
Ticker ticker;
DigitalOut led1(LED1);
DigitalOut led2(LED2);
#ifdef board_transmitter
CAN transmitter_can(PB_8, PB_9);  // rd, td Transmitter
#else
CAN receiver_can(PB_8, PB_9);  // rd, td Transmitter
#endif

int counter = 0;
char data[8];

//***************void send is the data you are sending**************
#ifdef board_transmitter
void send() {
        data[0] = (char)(0xbf); // NMT Start RemoteNode
        data[1] = (char)(0x00); // Global
        data[2] = (char)(0x00);
        data[3] = (char)(0x00);
        data[4] = (char)(0x00);
        data[5] = (char)(0x00);
        data[6] = (char)(0x00);
        data[7] = (char)(0x00);
        if(transmitter_can.write(CANMessage(0000,data,2))) {
           pc.printf("Startup sent \n");
        }

}
#endif

int main() {
//----------------Initialization-----------------------
#ifdef board_transmitter
    transmitter_can.frequency(500000);
#else
    receiver_can.frequency(500000); //500kbit/s
#endif
    //receiver_can.monitor(1); //Works without this, in my case.
#ifdef board_transmitter
    ticker.attach(&send, 1); //Send every second
#endif
    CANMessage msg;
//-----------------------------------------------------

//---------------The read out----------------------
    while(1) {
        
#ifndef board_transmitter
        if(receiver_can.read(msg)) {
           pc.printf("Message read with ID: %d\n", msg.id);
           pc.printf("Data: %x", msg.data[0]);
           pc.printf(" %x", msg.data[1]);
           pc.printf(" %x", msg.data[2]);
           pc.printf(" %x", msg.data[3]);
           pc.printf(" %x", msg.data[4]);
           pc.printf(" %x", msg.data[5]);
           pc.printf(" %x", msg.data[6]);
           pc.printf(" %x\n", msg.data[7]);
           pc.printf("Length: %d", msg.len);
           pc.printf(", Type: %d", msg.type);
           pc.printf(", Format: %d\n\n", msg.format);
            led2 = !led2;  //Blink!
        }
#endif
    }
//----------------------------------------------------
}
//*********************************************************