/* #############################################################################
**    Archivo        : main.c
**    Proyecto       : STM32F103C8_Hola_Mundo
**    Procesador     : STM32F103C8T6
**    Plataforma     : Blue Pill
**    Herramienta    : Mbed Compiler
**    Version        : Driver 01.01
**    Compilador     : GNU C Compiler
**    Fecha/Hora     : 14-07-2015, 11:48, # CodeGen: 0
**    Descripción    :
**         Este proyecto muestra la configuración y uso de la Terminal Serial
**         This module contains user's application code.
**   Componentes     : Serial, etc .
**   Configuraciones : Se puede seleccionar entre diferentes velocidades de 
**                     transmisión
**   Autores         :
**         ATEAM Development Group:
**          - Antulio Morgado Valle
**
**   Versión        : Beta
**   Revisión       : A
**   Release        : 0
**   Bugs & Fixes   :
**   Date           : 20/10/2019
**                    Adición de secuencias de ESCape
**                    27/09/2010 
**                    Ejemplo del Hola Mundo
**
** ###########################################################################*/
/*
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:  Includes
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/
#include "stm32f103c8t6.h"
#include "mbed.h"
#include "Serial.h"
#include "stdio.h"
/*
:...............................................................................
:  Definiciones
:...............................................................................
*/
#define on              0               // Estado para boton presionado
#define off             1               // Estado para boton sin presionar
#define hold            2               // Estado para boton mantenido
#define release         3               // Estado para boton liberado
#define FALSE           0               // Estado FALSO
#define TRUE            1               // Estado VERDADERO

/*
+-------------------------------------------------------------------------------
|  Configuración de Puertos 
+-------------------------------------------------------------------------------
*/

// *****    Host PC Terminal Communication channels
Serial      terminal (PA_2, PA_3);          // Tx, Rx - Terminal Serial (TTL Level) (Default Rate: 9600)
//Serial      terminal(USBTX, USBRX,115200);  // Tx, Rx, Baud Rate - Terminal Serial por USB @ 115,200 Bauds
//Serial      terminal(PA_9, PA_10);          // Tx, Rx  Using MAX3232 or BlueTooth
/*
+-------------------------------------------------------------------------------
|  Variables Globales de Usuario 
+-------------------------------------------------------------------------------
*/
uint32_t Baud_Rate = 115200;          // Velocidad de Transmisión (Bauds)

/*
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
|  Definición de Funciones Prototipo y Rutinas de los Vectores de Interrupción
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
void Setup(void);   // Función que inicializa la Tarjeta

/* END definitions */ 
/*
#===============================================================================
|
|               P R O G R A M A     P R I N C I P A L
|
#=============================================================================== 
*/
int main()          
{                   // Inicialización de variables, puertos e interrupciones
 confSysClock();     // Configure system clock (72MHz HSE clock, 48MHz USB clock)
 Setup(); 
 terminal.printf ("ESCUELA SUPERIOR DE INGENIERIA MECANICA Y ELECTRICA\n\r");
 printf ("\vHola Mundo!\r");
  printf ("\v\t\vH\ne\nl\nl\no\n \nW\no\nr\nl\nd\n!\r");
 printf ("\n\nPresiona cualquier tecla para continuar...");    
 char opcion = terminal.getc();
     
 while (TRUE)                // El Lazo del Programa principal está aquí !!!
 {          // La secuencia de ESCape puede iniciar con \e ó \033 ó \x1B 
    printf("\n\r\v\tHola \033[1;37;42mESIME\x1B[0m - \e[127;37;41mIPN\033[0m!!!\n\r\v");
    printf ("\033[1;31mEste es un texto rojo.\n\r\033[0m");
    printf ("\x1B[1;32mEste es un texto verde.\n\r\x1B[0m");
    printf ("\e[1;34mEste es un texto azul.\n\r\e[0m");     
//    printf ("\v\tHecho en \033[1;32mMe\033[0mxi\033[1;31mco.\n\r\v\v\033[0m");
    printf ("\v\tHecho en \e[1;32mMe\e[0mxi\e[1;31mco.\e[0m\n\r\v\v\e[0m");
    terminal.printf("\r\t  \e[1m\e[7mby ATEAM R&D\e]0m");   
    printf ("\n\r Pulse cualquier tecla para continuar!\r");   
    opcion = terminal.getc();
    terminal.putc(opcion);
    uint8_t attr;
    uint8_t bg;
    uint8_t fg;
    printf("\n\v\t\t\"ATRIBUTOS DE COLORES\"\r\n");    
    for (attr=0;attr<2;attr++)
    {
        for (bg=30;bg<38;bg++)
        { 
            for (fg=40;fg<48;fg++)
            {
                printf ("\e[%d;%d;%dm%d,%d,%d\e[0m ",attr,bg,fg,attr,bg,fg);
            }
            printf("\r\n");
        }   
    }
//    terminal.printf("\a\f\n\r");      //\e[033c
    terminal.printf("\n\a\f\e[7;5;1mBlinking\e[0m\r\n"); 
    wait(10);
    terminal.printf(" =)\e[2J");      // Clear Screen    
 }
}
/* END main */

/*
................................................................................
:  Rutinas de los Vectores de Interrupción
................................................................................
*/
 
/* END Events */ 
/*
________________________________________________________________________________
|
|  Funciones Prototipo
|_______________________________________________________________________________
*/
                // Las Funciones Prototipo van aquí !
void Setup()
{
  terminal.baud(Baud_Rate);         // Se configura la velocidad de transmisión e inicia la comunicación serial.
  terminal.printf("System is Wake Up!.\n\r"); 
}                

/* END routines */ 
 
/* END program */                

/*+-----------------------------------------------------------------------------  
*+ La documentación va aquí!:
+-------------------------------------------------------------------------------
|                SECUENCIAS DE ESCAPE PARA LA TERMINAL SERIAL
|
| SECUENCIA         VALOR                       DESCRIPCIÓN
|
|   \n              Nueva línea (new line). El cursor pasa a la primera posición
|                                           de la línea siguiente 
|   \r              Retorno de carro (carriage return). El cursor pasa a la 
|                                           primera posición de la línea donde 
|                                           nos encontremos.
|   \t              Tabulador (tab). El cursor pasa a la siguiente posición de 
|                                           tabulación.
|   \a              Alerta (bell). Crea un aviso bien de forma visible o bien 
|                                           mediante sonido.
|   \b              Espacio atrás (backspace). Hace retroceder el cursor una 
|                                           posición a la izquierda.
|   \f              Alimentación de página (form feed). Crea una nueva página.
|   \v              Tabulación vertical (vertical tab).
|   \0              Caracter Nulo (null).
|   \'              Apóstrofo o comilla simple.
|   \”              Muestra la comilla doble.
|   \?              Muestra un interrogante.
|   \\              Muestra la barra invertida.
|   \número_octal   Muestra el carácter ASCII correspondiente según el número 
|                                           octal que se haya especificado.
|   \xnúmero_hexadecimal    Muestra el carácter ASCII correspondiente según el 
|                                           número hexadecimal que se haya 
|                                           especificado.
|   \unnnn          Muestra Caracter en código unicode.
|   \unnnnnnnn      Muestra varios caracteres en código unicode.
|
|  \e[ es para el inicio de una secuencia de caracteres no imprimibles
|  \e] es para el final de una secuencia de caracteres no imprimibles
|
| Consejo: para memorizarlo, primero puede agregar \e[\e] y luego poner su 
| código ANSI entre ellos: 
| – \e[start-ANSI-code\e]
| – \e[end-ANSI-code\e]
|
|  tipo de secuencia de color:
|
|    3/4 bit
|    8 bits
|    24 bits
|
| Antes de sumergirte en estos colores, debes conocer 4 modos con estos códigos:
| 1. modo de color
|
| Modifica el estilo del color NO el texto. Por ejemplo, haz que el color sea más claro o más oscuro.
|
|    0 reinicio
|    1; Más ligero de lo normal
|    2; más oscuro de lo normal
|
| Este modo no es compatible ampliamente. Es totalmente compatible con Gnome-Terminal.
| 2. modo de texto
|
| Este modo es para modificar el estilo del texto NO el color.
|
|    3; itálico
|    4; subrayar
|    5; parpadeando (lento)
|    6; parpadeando (rápido) 
|    7; marcha atrás
|    8; esconder
|    9; tachar
|
| y son casi compatibles.
| Por ejemplo, KDE-Konsole admite 5; pero Gnome-Terminal no lo hace y 
| Gnome es compatible con 8; pero KDE no.
| 3. modo de primer plano
| 
| Este modo es para colorear el primer plano.
| 4. modo de fondo
|
| Este modo es para colorear el fondo. 
|
ECMA-48 Pone modo Gráfico
       La secuencia ECMA-48 SGR  ESC [ <parámetros> m establece los atributos de
       la pantalla.  Se pueden poner varios atributos en la misma secuencia.

       par   resultado
       0     restablece todos los atributos a sus valores predeterminados
       1     pone negrillas
       2     pone medio brillo (simulado con color en una pantalla a color)
       4     pone subrayado (simulado con color en una pantalla a color)
             (los colores para simular disminución o subrayado se ponen con
             ESC ] ...)
       5     pone intermitencia
       7     pone vídeo inverso
       10    restaura asociación seleccionada, indicador de control de
             pantalla y cambia el indicador meta
       11    selecciona no asociación, pone indicador de control de
             pantalla, restaura indicador de cambio meta
       12    selecciona no asociación, pone indicador de control de
             pantalla, pone indicador de cambio meta (que hace que el bit
             más alto de un byte cambie antes de que se haga la traducción
             de la tabla de asociación.)
       21    pone intensidad normal (esto no es compatible con ECMA-48)

       22    pone intensidad normal
       24    quita subrayado
       25    quita intermitencia
       27    quita vídeo inverso
       30    pone negro
       31    pone rojo
       32    pone verde
       33    pone marrón
       34    pone azul
       35    pone rosa
       36    pone celeste
       37    pone blanco
       38    pone subrayado, color predeterminado
       39    quita subrayado, pone color predeterminado
       40    pone negro de fondo
       41    pone rojo de fondo
       42    pone verde de fondo
       43    pone marrón de fondo
       44    pone azul de fondo
       45    pone rosa de fondo
       46    pone celeste de fondo
       47    pone blanco de fondo
       49    pone el color de fondo predeterminado

| Tambien consultar:
| https://en.wikipedia.org/wiki/ANSI_escape_code
| https://es.wikipedia.org/wiki/C%C3%B3digo_escape_ANSI
| http://www.braun-home.net/michael/info/misc/VT100_commands.htm
| https://www.enmimaquinafunciona.com/pregunta/170760/secuencias-de-escape-terminales-en-la-pantalla-gnu
| http://softwarelivre.org/terceiro/blog/a-visual-cheat-sheet-for-ansi-color-codes
+--------------------------------------------------------------------------------
|
|                               EXAMEN
|
| 1.-   Utilizando printf y las secuencias de escape, crear una Carátula de 
|       prentación con los datos personales y escolares. 
|
+--------------------------------------------------------------------------------
|
|                     T H E     A N T U L I U S   T E A M
|  Research, Development, Systems Equipment, Support & Spare Parts    I n c.
|                (C) Copyright 1989-2014, All rigths Reserved
|
| This program is licensed under rules of
| THE BEANERS TECHNOLOGIES PROYECT
+-------------------------------------------------------------------------------
*/

/* END documentation */ 

/* END Mbed */