/* ###########################################################################
**    Archivo        : main.c
**    Proyecto       : STM32-103C8_AdivinaV2
**    Procesador     : STM32F103C8
**    Herramienta    : Mbed
**    Version        : Driver 01.01
**    Compilador     : GNU C Compiler
**    Fecha/Hora     : 13-09-2019 01:30, # CodeGen: 0
**    Descripción    :
**         Este proyecto recibe un numero predefinido por el administrador para 
**         que despues un usuario intente adivinarlo con un limite de intetos
**         los cuales ya estas preestablecidos por el administrador.
**   Componentes     : Timer, etc .
**   Configuraciones : Se puede seleccionar entre diferentes velocodades de 
**                     transmisión
**   Autores         :
**         ATEAM Development Group:
**          - Antulio Morgado Valle.
**          - Marcelo Padron Javier 4CV2.
**
**   Versión        : Beta
**   Revisión       : B
**   Release        : 0
**   Bugs & Fixes   :
**   Date           : 13/09/2019
**                   
**                    
**
** ###########################################################################*/
/*
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:  Includes
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/

#include "stm32f103c8t6.h"
#include "mbed.h"
#include "Serial.h"
#include "stdio.h"
/*
:...............................................................................
:  Definiciones
:...............................................................................
*/
#define on              0               // Estado para boton presionado
#define off             1               // Estado para boton sin presionar
#define hold            2               // Estado para boton mantenido
#define release         3               // Estado para boton liberado
#define FALSE           0               // Estado FALSO
#define TRUE            1               // Estado VERDADERO
/*
+-------------------------------------------------------------------------------
|  Configuración de Puertos 
+-------------------------------------------------------------------------------
*/
DigitalOut verde (LED1);    // PC_13    (Green_Led)
DigitalOut rojo  (PB_1);    // NC       (Red_Led)

// *****    Host PC Terminal Communication channels
Serial      terminal (PA_2, PA_3);          // Inicializa la comunicación serial a la PC (Tx,Rx)
//Serial      terminal(USBTX, USBRX,115200);// Tx, Rx  Baud Rate - Terminal Serial por USB @ 115,200 Bauds

/*
+-------------------------------------------------------------------------------
|  Variables Globales de Usuario 
+-------------------------------------------------------------------------------
*/
//uint32_t Baud_Rate = 9600;                // Velocidad de Transmisión (Bauds)
/*
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
|  Definición de Funciones Prototipo y Rutinas de los Vectores de Interrupción
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
void Setup(void);  
/* END definitions */ 

/*
#===============================================================================
|
|               P R O G R A M A     P R I N C I P A L
|
#=============================================================================== 
*/
int main()          
{                   // Inicialización de variables, puertos e interrupciones
confSysClock();     // Configure system clock (72MHz HSE clock, 48MHz USB clock)
Setup();            // Inicialización del sistema
    while(TRUE) 
    {
Primero:    int numero = 5; //Primero vamos a limitar el numero de intentos
            if( numero > 0) //Colocaremos un condicional al inicio de nuestro programa para que estemos regresando a este punto.
            {
            terminal.printf("\n DIGITE UN NUMERO SECRETO DE 0 A 9 \r\n");
            int secreto = terminal.getc();
            rojo = on;
            verde = on;        
Intenta:    terminal.printf("\n Solo tienes %i intentos para adividnar!\r\n", numero);
            terminal.printf("\nADIVINA EL NUMERO: \r\n");
            int respuesta = terminal.getc();
            terminal.printf("\nEL NUMERO QUE INGRESASTE FUE \r\n"); //Imprimimos la respuesta como parte de las condiciones que nos pide el profesor.
            terminal.putc ( respuesta );
            if( secreto < respuesta  ) 
            {
                terminal.printf(" \n\nEl numero que ingresaste es mas alto!  \r\n");
                rojo = on;
                verde = off;
                numero = numero - 1;               
                goto Intenta;
            }
            if( secreto > respuesta  ) 
            {
                terminal.printf(" \n\nEl numero que ingresaste es mas bajo!  \r\n");
                rojo  = off;
                verde = on;
                numero = numero - 1 ; 
                goto Intenta;
            }
            if( secreto == respuesta ) 
            {
                terminal.printf(" \n\nFelicidades!, La respuesta es: %i \r\n",secreto);
                rojo  = off;
                verde = on;
                wait(1.0);
                rojo  = off;
                verde = off;
                wait(1.0);
                rojo  = off;
                verde = on;
                wait(1.0);
                terminal.printf("Felicidades, realmente eres un genio! \r\n");
                wait(1.0);
                rojo  = on;
                verde = off;
                wait(1.0);
                rojo  = off;
                verde = on;
            }
            
        terminal.printf(" Quieres intentarlo de nuevo?  \r\n");
        terminal.printf(" 0 = No \r\n 1 = Si  \r\n");
            char opcion = terminal.getc();  
            if( opcion == '1' )
            {
                 numero = numero - 1; 
                 goto Primero;
                 }
            else if( opcion == '0' )
            {
                terminal.printf("El numero de intentos realizados fueron %i!\r\n", numero);
                break;
            }
        }
        else if ( numero == 0)
        {
            terminal.printf(" Lo lamento, excediste el numero de intentos!\r\n");
        }
        }
}

/* END main */

/*
................................................................................
:  Rutinas de los Vectores de Interrupción
................................................................................
*/
 
/* END Events */ 
/*
________________________________________________________________________________
|
|  Funciones Prototipo
|_______________________________________________________________________________
*/
                // Las Funciones Prototipo van aquí !
void Setup()
{
//  terminal.baud(Baud_Rate);         // Se configura la velocidad de transmisión e inicia la comunicación serial.    
  terminal.baud(115200);         // Se configura la velocidad de transmisión e inicia la comunicación serial.  
  terminal.printf(" Bienvenido Amo!\n\r");
}              

/* END routines */   
 
/* END program */                

/* END documentation */ 
/*     
+--------------------------------------------------------------------------------
|
|                               EXAMEN
|
| 1.-   Modificar el programa para que despliegue el número de intentos para 
|       adivinar el número secreto.
| 2.-   Modificar el programa para haga eco con la respuesta que le introducimos.
|
| 3.-   Modificar el programa para que te limite el numero de intentos.
| Suerte!
+--------------------------------------------------------------------------------
|
|                     T H E     A N T U L I U S   T E A M
|  Research, Development, Systems Equipment, Support & Spare Parts    I n c.
|                (C) Copyright 1989-2014, All rigths Reserved
|
| This program is licensed under rules of
| THE BEANERS TECHNOLOGIES PROYECT
+-------------------------------------------------------------------------------
*/
/* END Mbed */ 