/* ###########################################################################
**    Archivo        : main.c
**    Proyecto       : STM32-F103C8_Plantilla
**    Procesador     : STM32F103C8
**    Herramienta    : Mbed
**    Version        : Driver 01.01
**    Compilador     : GNU C Compiler
**    Fecha/Hora     : 14-07-2015, 11:48, # CodeGen: 0
**    Descripción    :
**         Este proyecto muestra la configuracion del uso de la terminal serial
**         This module contains user's application code.
**   Componentes     : Serial, etc .
**   Configuraciones : Se puede selecionar entre diferentes  velocidades de transmision
**   Autores         :
**         ATEAM Development Group:
**          - Antulio Morgado Valle
**
**   Versión        : Beta
**   Revisión       : A
**   Release        : 0
**   Bugs & Fixes   :
**   Date           : 20/10/2019
**                    Added support for Led_RGB
**                    22/09/2018 
**                    Added LCD Menu, Beta version (with bugs)
**
** ###########################################################################*/
/*
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:  Includes
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/
#include "mbed.h"
#include "stm32f103c8t6.h"
#include "PinNames.h"
#include "Serial.h"
#include "stdio.h"

/*
:...............................................................................
:  Definiciones
:...............................................................................
*/
#define  on             0               // Estado para boton presionado
#define off             1               // Estado para boton sin presionar
#define hold            2               // Estado para boton mantenido
#define release         3               // Estado para boton liberado
#define FALSE           0               // Estado FASLO
#define TRUE            1               // Estado VERDADERO
/*
+-------------------------------------------------------------------------------
|  Configuración de Puertos 
+-------------------------------------------------------------------------------
*/
// Host Pc terminal Comunication channel
Serial terminal (PA_2,PA_3);  //Inicioaliza la comunicacion serial a la PC(RX,TX)   
//Serial terminal(USBTX,USBRX,1115200);/TX,RX
/*
+-------------------------------------------------------------------------------
|  Variables Globales de Usuario 
+-------------------------------------------------------------------------------
*/
uint32_t Baud_Rate   =  115200 ;           // Velocidad de transmision
/*
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
|  Definición de Funciones Prototipo y Rutinas de los Vectores de Interrupción
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
void Setup(void); //Function que inicializa la tarjeta;
/*
END definitions */  
/*
#===============================================================================
|
|               P R O G R A M A     P R I N C I P A L
|
#=============================================================================== 
*/
int main()          
{
void confSysClock();
void Setup();
terminal.printf("escuela");
int i=0;
do
{
    printf("* ");
    i++;
}while(i<29);
printf("\n*\n*       Instituto Polietecnico Nacional           \t*");
printf("\n* Escuela Superior de Ingenieria Mecanica y Electrica\t*");
printf("\n*\n*              Analisis numerico                  \t*");
printf("\n*\n*          Quintana Malaga Jordi Jasper           \t*");
printf("\n*                  Grupo: 4CV2                       \t\n");
do
{
    printf("* ");
    i++;
}while(i<58);

system("pause");
return 0;
}
/* END main */

/*
................................................................................
:  Rutinas de los Vectores de Interrupción
................................................................................
*/
  
/*
______________________________________________________________________________
|
|  Funciones Prototipo
|_______________________________________________________________________________
*/
                // Las Funciones Prototipo van aquí !
void Setup() 
{
  terminal.baud(Baud_Rate);
  terminal.printf("System is wake up!.\n\t");
}
/* END routines */    
                
/* END program */

/*+-----------------------------------------------------------------------------       
*+  Conexión al Led Testigo:
*+ 
*+  Los leds se pueden conectar a cualquier pin que se declare como DigitalOut. 
*+  El dispositivo puede drenar hasta 20ma por todas sus salidas a un voltaje de 
*+  3.3V, pero se recomienda no exceder de 1mA por salida.
*+  Esto se logra poniendo una resistencia limitadora de mínimo 330 Ohms.
*+  
*+    3.3V o 5V
*+       O
*+       |
*+       |
*+       /
*+       \   1K
*+       /
*+       \                         UTILIZANDO LÓGICA NEGATIVA
*+       |
*+    __|__
*+    \      /
*+     \    /
*+      \  /
*+     _\/_
*+       |
*+       |__________________________  PIN (Digital Out)
*+
*+      
*+      
*+       
*+                    1K
*+                   
*+        ________/\  /\  /\  ____    PIN (Digital Out)
*+       |           \/  \/  \/
*+       |      
*+       |
*+     __|__
*+    \      /
*+     \    /
*+      \  /                       UTILIZANDO LÓGICA POSITIVA
*+      _\/_
*+       |
*+       |
*+       |
*+     __|__
*+      ___
*+       _
*+       _
*+
*+      GND
*+
+----------------------------------------------------------------------------
*+
*+   Powered by
*+
*+          T H E     A N T U L I U ' S   T E A M   R&D  Unltd 
*+
*+  Research, Development, Systems, Equipment, Support & Spare Parts.
*+  (C) Copyright 1989-2019, All Rights Reserved            
*+
*+  Welcome to The Beaners Proyect Community!                   
*+----------------------------------------------------------------------------*/

/* END Mbed */