/* ###########################################################################
**    Archivo        : main.c
**    Proyecto       : STM32-F103C8_Plantilla_USB
**    Procesador     : STM32F103C8
**    Herramienta    : Mbed
**    Version        : Driver 01.01
**    Compilador     : GNU C Compiler
**    Fecha/Hora     : 14-07-2015, 11:48, # CodeGen: 0
**    Descripción    :
**         Este proyecto hace...
**         This module contains user's application code.
**   Componentes     : GPIO, Timer, etc .
**   Configuraciones : Includes, Stacks y Drivers externos
**   Autores         :
**         ATEAM Development Group:
**          - Antulio Morgado Valle
**
**   Versión        : Beta
**   Revisión       : A
**   Release        : 0
**   Bugs & Fixes   :
**   Date           : 20/10/2019
**                    Added support for Led_RGB
**                    22/09/2018 
**                    Added LCD Menu, Beta version (with bugs)
**
** ###########################################################################*/
/*
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:  Includes
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/
#include "stm32f103c8t6.h"
#include "stm32f10x.h"
#include "mbed_lib.h"
#include "mbed.h"
#include "AnalogIn.h"
#include "Ticker.h"
//#include "Led_RGB.h"
#include "Serial.h"
//#include "stdio.h"

/*
:...............................................................................
:  Definiciones
:...............................................................................
*/
#define  on             0               // Estado para boton presionado
#define off             1               // Estado para boton sin presionar
#define hold            2               // Estado para boton mantenido
#define release         3               // Estado para boton liberado
#define FALSE           0               // Estado FALSO
#define TRUE            1               // Estado VERDADERO
#define Ticker_Rate     1000            // Periodo de interrupción (us)
#define Baud_Rate       115200          // Velocidad de Transmisión (bauds)
/*
+-------------------------------------------------------------------------------
|  Configuración de Puertos 
+-------------------------------------------------------------------------------
*/
Ticker      Barrido;                // Inicializa la Interrupción por Timer
DigitalOut  led_monitor(Green_Led);      // Inicializa el LED Monitor
Serial      terminal(PA_2, PA_3);   // Inicializa la Comunicación Serial a la PC
PwmOut      probe(PA_7);            // Inicializa el PWM
AnalogIn    sensor1 (PB_0);         // Inicializa Canal Analógico para sensor 1
/*
+-------------------------------------------------------------------------------
|  Variables Globales de Usuario 
+-------------------------------------------------------------------------------
*/
uint16_t Rate=Ticker_Rate/2;        // Velocidad de barrido (500us = 0.5ms)
uint16_t counter=250;               // Cuenta inicial de 250us

/*
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
|  Definición de Funciones Prototipo y Rutinas de los Vectores de Interrupción
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
void Barrido_OnInterrupt(void);  
void Blinking_Led(void);
/* END definitions */ 
 
/*
#===============================================================================
|
|               P R O G R A M A     P R I N C I P A L
|
#=============================================================================== 
*/
int main()          
{                           // Inicialización de variables, puertos e interrupciones
confSysClock();             // Inicialización del Sistema, Configure system clock (72MHz HSE clock, 48MHz USB clock)
Barrido.attach_us(&Barrido_OnInterrupt, Ticker_Rate);   // Le asigna el periodo de barrido de 1ms (Ticker_Rate =1000)

//terminal.baud(115200);      // Se configura la velocidad de transmisión e inicia la comunicación serial.    
//terminal.printf(" System is Wake Up!.\n\r"); 

    while (true)                // El Lazo del Programa principal está aquí !!!
    {
//        Blinking_Led();             // Parapadeo del LED por Software
        probe = sensor1.read(); 
        terminal.printf("Blink \r\n");                           
    }
}
/* END main */

/*
................................................................................
:  Rutinas de los Vectores de Interrupción
................................................................................
*/
void Barrido_OnInterrupt()          // Rutina de Atención al Ticker
{                                   // Aquí va la Rutina de Servicio !
    counter--;
    if (!counter)
    {
        terminal.printf("Counter Finish! \r\n");
        led_monitor = !led_monitor; // Parapadeo del LED por Interrupción (Toggle the LED)
        counter = Rate;             // Restablece el contador
    } 
}
/* END Events */   
/*
________________________________________________________________________________
|
|  Funciones Prototipo
|_______________________________________________________________________________
*/
                // Las Funciones Prototipo van aquí !
void Blinking_Led()             // Software Blinking routine for LED 
{
        // The on-board LED is connected, via a resistor, to +3.3V (not to GND). 
        // So to turn the LED on or off we have to set it to 0 or 1 respectively
        led_monitor = 0;        // turn the LED on
        wait_ms(200);           // 200 millisecond
        led_monitor = 1;        // turn the LED off
        wait_ms(1000);          // 1000 millisecond
}

void Setup()
{
//  confSysClock();     // Configure system clock (72MHz HSE clock, 48MHz USB clock)
//  terminal.baud(Baud_Rate);         // Se configura la velocidad de transmisión e inicia la comunicación serial.    
  terminal.baud(Baud_Rate);         // Se configura la velocidad de transmisión e inicia la comunicación serial.  
  terminal.printf(" System is Wake Up!.\n\r");
}              
/* END functions */    
                
/* END program */

/* END Mbed */ 