#ifndef ADC_H
#define ADC_H

#define SPI_NO_BITS_PER_FRAME 8

#define SPI_CLOCK_POLARITY    0
#define SPI_PHASE_MODE        0
#define SPI_CLOCK_PHASE   (SPI_CLOCK_POLARITY << 1 | SPI_PHASE_MODE)

#define SPI_FREQUENCY    400000

#define SPI_MAX_SYNC_TRYS    19

#define SPI_CONF_DELAY      0.2

/* Math coefficients. */
#define ADC_R             8.31451
#define ADC_F             96487.0
#define ADC_dEdT -0.0011012283386

#define MAX_CONF_PIN_CHECKS 21
#define MAX_PIN_CHECKS 201

/*
 * Init analog to digital communication and config ADC(analog to digital converter)
*/
void adcInit();

/*
 * Get data from analog to digital converter.
 * For calculation are used the following extern variables:
 * A, B, C, D, PHTEMPF, EOSINGLEPT.
 * All received data will be written to the extern variables:
 * PHTEMP, pH, pHNoGain, pHCorrected, pHT.
*/
void adcGetData();

#endif