#include "cisme.h"
#include "adc.h"
#include "debug.h"

#define SPI_WRITE_DEBUG_RESPONSE(_value)\
{\
    int _spiResponse;\
    _spiResponse = AtoD.write(_value);\
    DEBUG3("SPI returned response %d on ## _value", _spiResponse);\
}

static SPI AtoD(p5,p6,p7);

static void spiWaitPin8(unsigned char maxChecks)
{
    int pin8State;
    int noPinChecks = 0;
    
    do {
        /* Looks like SD0Flag returns(operator (int)) 0 or 1 - pin state. */
        pin8State = SDOFlag;
        noPinChecks++;
        
        if (noPinChecks > maxChecks) {
            DEBUG1("All pin checks are failed. Continue working anyway");
            pin8State = 0;
        }
    }
    while (pin8State == 1);
}

void adcInit()
{
    int syncIx;
    int i;

    AtoD.format(SPI_NO_BITS_PER_FRAME, SPI_CLOCK_PHASE);
    AtoD.frequency(SPI_FREQUENCY);
    
    // Initialize the AtoD to the command mode
    for (syncIx = 0; syncIx < SPI_MAX_SYNC_TRYS; syncIx++) {
        AtoD.write(0xFF);
    }

    SPI_WRITE_DEBUG_RESPONSE(0xFE);
    wait(SPI_CONF_DELAY);

    // Reset the configuration register
    SPI_WRITE_DEBUG_RESPONSE(0x03);
    SPI_WRITE_DEBUG_RESPONSE(0x20);
    SPI_WRITE_DEBUG_RESPONSE(0x00);
    SPI_WRITE_DEBUG_RESPONSE(0x00);
    SPI_WRITE_DEBUG_RESPONSE(0x00);

    wait(SPI_CONF_DELAY);

    // Read the configuration register
    AtoD.write(0x0B);
    SPI_WRITE_DEBUG_RESPONSE(0x00);
    SPI_WRITE_DEBUG_RESPONSE(0x00);
    SPI_WRITE_DEBUG_RESPONSE(0x00);
    SPI_WRITE_DEBUG_RESPONSE(0x00);
    wait(SPI_CONF_DELAY);

    // Enable the device
    AtoD.write(0x03);
    AtoD.write(0x00);
    AtoD.write(0x00);
    AtoD.write(0x00);
    AtoD.write(0x00);
    wait(SPI_CONF_DELAY);
    
    // Read the configuration register
    AtoD.write(0x0B);
    SPI_WRITE_DEBUG_RESPONSE(0x00);
    SPI_WRITE_DEBUG_RESPONSE(0x00);
    SPI_WRITE_DEBUG_RESPONSE(0x00);
    SPI_WRITE_DEBUG_RESPONSE(0x00);
    wait(SPI_CONF_DELAY);

    // Setup the Channel Setup Registers
    AtoD.write(0x05);
    AtoD.write(0x00);
    AtoD.write(0x00);
    AtoD.write(0x40);
    AtoD.write(0x00);

    wait(SPI_CONF_DELAY);

    for (i = 0; i < 4; i++) {
        if (i < 2) {
            AtoD.write(0x80);
        } else {
            AtoD.write(0x88);
        }

        spiWaitPin8(MAX_CONF_PIN_CHECKS);
        wait (0.05);

        SPI_WRITE_DEBUG_RESPONSE(0x00);
        SPI_WRITE_DEBUG_RESPONSE(0xFE);
        SPI_WRITE_DEBUG_RESPONSE(0xFE);
        SPI_WRITE_DEBUG_RESPONSE(0xFE);
        SPI_WRITE_DEBUG_RESPONSE(0xFE);
    }
}

void adcGetData()
{
    int spiResponse;
    int Polarity;

    /* Temporary math variables. */
    int pHInt;
    int pHTInt;
    double Rtherm;
    double E1SINGLEPT, S1SINGLEPT;

    L1 = 1;

    pH = 0;
    pHCorrected = 0;

    NVIC_DisableIRQ(UART2_IRQn);

    AtoD.write(0x80);

    spiWaitPin8(MAX_PIN_CHECKS);
    wait(0.1);

    SPI_WRITE_DEBUG_RESPONSE(0x00);

    spiResponse = AtoD.write(0xFE);
    Polarity    = spiResponse & 0x80;
    pHTInt      = spiResponse & 0x0000007F;

    spiResponse = AtoD.write(0xFE);
    pHTInt = (pHTInt << 8) + (spiResponse & 0xFF);

    spiResponse = AtoD.write(0xFE);
    pHTInt = (pHTInt << 8) + (spiResponse &  0x000000FF);

    SPI_WRITE_DEBUG_RESPONSE(0xFE);

    if (Polarity == 0x80) {
        pHTInt = -((~pHTInt) & 0x007FFFFF) - 1;
    }

    DEBUG1("Received: Polarity=0x%x phTInt=0x%x phTInt=%d", Polarity, pHTInt, pHTInt);

    pHT = (double)(pHTInt/8388608. * 3.0);

    Rtherm = 20000.0 / ((2.5 / pHT) - 1.0);
    DEBUG1("Calculated Rtherm=%1.1f", Rtherm);

    PHTEMP = A + (B * Rtherm) + (C * log10(Rtherm)) + (D * pow(log10(Rtherm), 3));
    DEBUG1("pHT=%1.5f PHTEMP=%1.5f", pHT, PHTEMP);

    L2=1;

    AtoD.write(0x88);

    spiWaitPin8(MAX_PIN_CHECKS);
    wait(0.1);

    SPI_WRITE_DEBUG_RESPONSE(0x00);

    spiResponse = AtoD.write(0xFE);
    Polarity    = spiResponse & 0x80;
    pHInt       = spiResponse & 0x0000007F;

    spiResponse = AtoD.write(0xFE);
    pHInt = (pHInt << 8) + (spiResponse & 0x000000FF);

    spiResponse = AtoD.write(0xFE);
    pHInt = (pHInt << 8) + (spiResponse &  0x000000FF);

    SPI_WRITE_DEBUG_RESPONSE(0xFE);

    if (Polarity==0x80) {
        pHInt = -((~pHInt) & 0x007FFFFF) - 1;
    }

    DEBUG1("Received: Polarity=0x%x pHInt=0x%x pHInt=%d", Polarity, pHInt, pHInt);

    pH = (double)(pHInt/8388608. * 3.0);

    pHNoGain = pH;

    E1SINGLEPT = (double)EOSINGLEPT + (double)ADC_dEdT * ((double)PHTEMP-(double)PHTEMPF);
    S1SINGLEPT = (double)ADC_R * ((double)PHTEMP + 273.15) / (double)ADC_F * 2.302585;

    DEBUG1("E1SINGLEPT=%f S1SINGLEPT=%f", E1SINGLEPT, S1SINGLEPT);

    pHCorrected = ((double)pHNoGain - (double)E1SINGLEPT) / (double)S1SINGLEPT;

    DEBUG1("pHNoGain=%1.6f pHCorrected=%2.3f", pHNoGain, pHCorrected);

    L1=0;
    L2=0;
    
    NVIC_EnableIRQ(UART1_IRQn);
    NVIC_EnableIRQ(UART2_IRQn);
}