#ifndef LIGHT_H
#define LIGHT_H

// Light intensity (0-100%)
// 0% - light is off
// 100% - light is on with max brightness
#define LIGHT_MIN_INTENSITY 0
#define LIGHT_MAX_INTENSITY 100
#define LIGHT_OFF_INTENSITY LIGHT_MIN_INTENSITY

/**
 * Initialize light.
 * Turns light off on the start of the board.
 */
void lightInit(void);

/**
 * Set light intensity.
 *
 * @param intensity Light intensity in percents.
 */
void lightSet(unsigned char intensity);

/**
 * Read light intensity.
 *
 * @return light intensity in percents.
 */
unsigned char lightRead(void);

/**
 * Check light.
 *
 * @return true if light is on, false - otherwise.
 */
bool lightOn(void);

#endif