#ifndef LCD_H
#define LCD_H

#include "cisme.h"

typedef enum {
    JUSTIFICATION_CENTER = 1,
    JUSTIFICATION_ABSOLUTE = 3,
} Justification;

#ifdef USE_LCD

/**
 * Initialize LCD.
 */
void lcdInit(void);

/**
 * Clear LCD screen.
 */
void lcdClear(void);

/**
 * Clear LCD line.
 *
 * @param row LCD row.
 */
void lcdClearLine(unsigned char row);

/**
 * Send command to write text.
 *
 * @param row LCD row.
 * @param col LCD column.
 * @param just Text justification.
 * @param format Text format.
 */
void lcdWrite(unsigned char row, unsigned char col, Justification just, const char* format, ...);


/**
 * Get parameter using LCD.
 *
 * @param min Minimum parameter value.
 * @param max Maximum parameter value.
 * @param row LCD row to write entered value.
 * @param col LCD column to write entered value.
 * @return entered value.
 */
unsigned long lcdGetParam(unsigned long min, unsigned long max, unsigned char row, unsigned char col);

#else // USE_LCD

static inline void lcdInit(void)
{
}

static inline void lcdClear(void)
{
}

static inline void lcdClearLine(unsigned char row)
{
}

static inline void lcdWrite(unsigned char row, unsigned char col, Justification just, const char* format, ...)
{
}

static inline unsigned long lcdGetParam(unsigned long min, unsigned long max, unsigned char row, unsigned char col)
{
    return 0;
}

#endif // USE_LCD

#endif // LCD_H
