#ifndef KEYS_H
#define KEYS_H

// Possible keys
typedef enum {
    KEY_ZERO,
    KEY_ONE,
    KEY_TWO,
    KEY_THREE,
    KEY_FOUR,
    KEY_FIVE,
    KEY_SIX,
    KEY_SEVEN,
    KEY_EIGHT,
    KEY_NINE,
    KEY_ASTERISK,
    KEY_HASH,
    KEY_NONE,
    NUM_KEYS,
    KEY_END = KEY_NONE,
} Key;

// Ranges
const Key rangeOne[] = {KEY_ONE, KEY_END};
const Key rangeOneTwo[] = {KEY_ONE, KEY_TWO, KEY_END};
const Key rangeOneSix[] = {KEY_ONE, KEY_TWO, KEY_THREE, KEY_FOUR, KEY_FIVE, KEY_SIX, KEY_END};
const Key rangeSevenOrNine[] = {KEY_SEVEN, KEY_NINE, KEY_END};
const Key rangeAsteriskHash[] = {KEY_ASTERISK, KEY_HASH, KEY_END};  

/**
 * Propagate key press event.
 *
 * @param byte Received byte of key event.
 */
void keyEvent(char byte);

/**
 * Wait key to be pressed.
 *
 * @return key pressed.
 */
Key keyWait(void);

/**
 * Wait key to be pressed.
 *
 * @param range KEY_END terminated array of keys.
 * @return key pressed.
 */
Key keyWaitInRange(const Key* range);

/**
 * Get key pressed.
 *
 * @return key if key is pressed, KEY_NONE - otherwise.
 */
Key keyGet(void);

#endif
