#ifndef EXPERIMENTS_H
#define EXPERIMENTS_H

#include <stdio.h>

typedef enum {
    R,
    P,
    RP,
    PR,
    PGM
} ExperimentsType;

#define FILE_PREFIX_LENGTH  18
#define FILE_NAME_LENGTH    16 + FILE_PREFIX_LENGTH
/* Length of: /msc/Data/ + FILE_NAME_LENGTH */
#define PATH_TO_FILE_LEN    FILE_NAME_LENGTH + 10

#define MAX_STEPS_NO        99

extern float pgm[MAX_STEPS_NO][20];

/* The both variables are used in lcd_events.c */
extern FILE*  currentFile;
extern char   FileName[FILE_NAME_LENGTH];
extern char   FilePrefix[FILE_PREFIX_LENGTH];
extern int    StartTime;
extern int    SwitchMode;

#ifdef USE_LCD
void readUserPrograms(void);
#else
static inline void readUserPrograms(void)
{
}
#endif

/* Sets module's variables to specific values before the experiment. */
void experimentPrepareDefinedProgram(void);
/* Return true if experiment reached the end. */
bool experimentRunDefinedProgram(void);
void experimentPrepareUserProgram(void);
bool experimentRunUserProgram(void);

void finishExperiment(void);

#endif