#ifndef _MAIN_H
#define _MAIN_H

#include "mbed.h"  // Needed for mbed specific classes like DigitalOut.

// Flag to use LCD instead of Wi-Fi 
//#define USE_LCD
#define DEBUG_TO_FILE

#ifndef USE_LCD
    #define USE_WIFI
#endif

#define FSNAME "msc"

#define INSTRUMENT_ID_LEN 18

/* Many extern variables, which are used in some way in other files. */
extern int    Salinity;
extern double PHTEMP;
extern double pH;
extern double pHCorrected;
extern float  pHT;
extern int    flowintime;
extern int    lightintime;
extern int    minRESP;
extern int    minPHOTO;
extern int    MeasurementFlow;
extern int    MeasurementLight;
extern int    MeasurementTypeVal;
extern int    mtimeRemaining;
extern float  a;
extern float  b;
extern float  c;
extern float  PresCal;
extern float  PhaseCal2;
extern float  TempCal2;
extern float  PhaseCal1;
extern float  TempCal1;
extern float  LEDCurrent;
extern float  UNIT;
extern float  PHBUFFERF;
extern float  PHTEMPF;
extern float  PHTEMPKF;
extern float  PHVOLTSF;
extern float  MSINGLEPT;
extern float  EOSINGLEPT;
extern int    numberofprograms;
extern float  pHNoGain;
extern float  A;
extern float  B;
extern float  C;
extern float  D;
//extern float  lastPercentPump;

extern char instrumentId[INSTRUMENT_ID_LEN];

extern DigitalIn SDOFlag;

extern DigitalOut L1;
extern DigitalOut L2;
extern DigitalOut L3;
extern DigitalOut L4;

extern "C" void mbed_reset();

#endif