#ifndef CALIBRATION_H
#define CALIBRATION_H

/**
 * Calibrate temperature.
 *
 * @param temperature Temperature (C)
 * @return B value.
 */
float calibrationTemperature(float temperature);

/**
 * Save temperature calibration result.
 *
 * @param bValue B value.
 */
void calibrationTemperatureSave(float bValue);

/**
 * Apply O2 calibration parameters.
 */
void calibrationO2(void);

/**
 * Calibrate PH.
 *
 * @param phBuffer PH value
 * @param[out] phTemp Temperature
 * @param[out] slope Slope
 * @param[out] eo Eo
 */
void calibrationPh(float phBuffer, float* phTemp, float* slope, float* eo, float* phVolts);

/**
 * Save PH calibration results and restart board.
 */
void calibrationPhSave(void);

/**
 * Calibrate pump.
 *
 * @param[out] a Calculated polynom coefficient
 * @param[out] b Calculated polynom coefficient
 * @param[out] c Calculated polynom coefficient
 */
void calibrationPump(float* a, float* b, float* c);

#endif
