#ifndef PUMP_H
#define PUMP_H

// Pump PercentPump (0-100%)
// 0% - pump is off
// 100% - pump is on with max speed
#define PUMP_MIN_INTENSITY 2
#define PUMP_MAX_INTENSITY 100
#define PUMP_OFF_INTENSITY 0

/**
 * Initialize pump.
 * Turns pump off on the start of the board.
 */
void pumpInit(void);

/**
 * Set pump PercentPump.
 *
 * @param PercentPump Pump intensity in percents.
 */
void pumpSet(float PercentPump);

/**
 * Check pump.
 *
 * @return true if pump is on, false - otherwise.
 */
bool pumpOn(void);

/**
 * Get pump PercentPump.
 *
 * @return pump PercentPump in percents.
 */
unsigned char pumpCurrentIntensity(void);

/**
 * Calculate current pump speed using RPM feedback.
 *
 * @return current pump speed.
 */
unsigned int pumpSpeed(void);

/**
 * Set pump PercentPump according to desired RPM value.
 *
 * @param rpm Desired RPM value.
 */
void pumpSetRpm(int rpm);
 
/**
 * Get pump polynom coefficients.
 *
 * @param[out] aValue Polynom coefficient
 * @param[out] bValue Polynom coefficient
 * @param[out] cValue Polynom coefficient
 */
void pumpGetParams(float* aValue, float* bValue, float* cValue);
 
/**
 * Set pump polynom coefficients.
 *
 * @param aValue Polynom coefficient
 * @param bValue Polynom coefficient
 * @param cValue Polynom coefficient
 */
void pumpSetParams(float aValue, float bValue, float cValue);

#endif
