#ifndef PRESENS_H
#define PRESENS_H

//#include "SerialBuffered.h"

#define PRESENS_BAUD                            19200
/* The number of bits in a word (5-8; default = 8) */
#define PRESENS_NO_BITS                             8
/* parity - The parity used (Serial::None, Serial::Odd, Serial::Even, Serial::Forced1, Serial::Forced0; default = Serial::None) */
#define PRESENS_PARITY                   Serial::None
/* stop - The number of stop bits (1 or 2; default = 1) */
#define PRESENS_NO_STOP_BITS                        1

#define PRESENS_CONFIG_DELAY                      0.3
#define PRESENS_LED_DEFAULT                     150.0

#define PRESENS_RES_LENGTH                          3
#define PRESENS_SALINITY                           20

/* MACRO for config of PRESENS. */
#define PRESENS_SET_SACU(_newSacu)   presenseComm.printf("sacu%-.4d\r", (int)_newSacu);

extern Serial presenseComm;
//extern SerialBuffered presenseComm;

void presensInit(void);
void presensConfig(float ledCurrent);
void presensGetData(float* result);

#endif