#include "cisme.h"
#include "presens.h"
#include "OxygenSensor.h"
#include "debug.h"
#include "adc.h"


/* Due to unknown reason in old version presens was 6 symbol long. */

//#define PRESENS_FLOAT_LENGTH  6

Serial presenseComm(p9,p10);

static float presensReadFloat(int PRESENS_FLOAT_LENGTH)
{
    double val_double;
    float val_float;
    char buf[PRESENS_FLOAT_LENGTH];
    for(int i=0;i<PRESENS_FLOAT_LENGTH;i++){
        buf[i]='0';
        }

    char charIx = 0;

    while (charIx < PRESENS_FLOAT_LENGTH) {
        buf[charIx++] = presenseComm.getc();
    }
 
   buf[PRESENS_FLOAT_LENGTH]=0;

    DEBUG1("recieved characters=%s\r", buf);

    val_double=atof(buf);
    val_float= (float)val_double;

    return val_float;
}


void presensInit(void)
{
    //set the baud rate for the PreSense
    presenseComm.baud(PRESENS_BAUD);

    //set the Serial parameters for the PreSense
    presenseComm.format(PRESENS_NO_BITS, PRESENS_PARITY, PRESENS_NO_STOP_BITS);

    wait(PRESENS_CONFIG_DELAY);
}


void presensConfig(float ledCurrent)
{

    wait(PRESENS_CONFIG_DELAY);

    presenseComm.printf("");

    if (ledCurrent > 255 || ledCurrent < 0) {
        ERROR("Too big ledCurrent=%f, it should be not less than 0 and not greater than 255. Using default ledCurrent=%f", ledCurrent, PRESENS_LED_DEFAULT);
        ledCurrent = PRESENS_LED_DEFAULT;
    }


    presenseComm.printf("sacu%-.4d\r", (int)ledCurrent);

    presenseComm.printf("mode0001\r");
    wait(PRESENS_CONFIG_DELAY);
    
    presenseComm.printf("avrg0009\r");
    wait(PRESENS_CONFIG_DELAY);
    
    presenseComm.printf("view0005\r");
    wait(PRESENS_CONFIG_DELAY);
    
    presenseComm.printf("tmpc2000\r");
    wait(PRESENS_CONFIG_DELAY);

  //  presenseComm.printf("mode0000\r");
  //  wait(PRESENS_CONFIG_DELAY);

}


void presensGetData(float* result)
{
    float amplitude = 0;
    float phase     = 0;
    int PRESENS_FLOAT_LENGTH = 7;

    presenseComm.printf("data\r");
    wait(0.2);
    adcGetData();
    wait(0.1);

    const OxygenSensor oxsense(TempCal1, TempCal2, PhaseCal1, PhaseCal2, PresCal, PRESENS_SALINITY);

    if (result == NULL) {
        ERROR("Result array is null");
        return;
    }


    L3 = 1;

    
    // read the each data packet

    while (presenseComm.readable() != 1);

    //waiting until letter 'A' is read 
    //presens amp get

    while (presenseComm.getc() != 65);

    amplitude = presensReadFloat(PRESENS_FLOAT_LENGTH);

    /* skip the characters semicolon ":" and letter "P" */
    //while (presenseComm.getc() != 80);
    presenseComm.getc();
    presenseComm.getc();

    //this wait seems to cure the chart stutter that was happening with the new Presens board
    wait(0.55);

    L4=1;
  
//    wait(0.05);
  
    PRESENS_FLOAT_LENGTH = 4;

    phase = presensReadFloat(PRESENS_FLOAT_LENGTH) / 100;

    L3 = 0;
  

    // read through the rest of packet to empty out the buffer

    while(presenseComm.readable()) {
        presenseComm.getc();
    }
    wait(0.05);

    // end of the data extraction


//    L3=1;


    DEBUG1("Amplitude=%5.0f Phase=%5.2f", amplitude, phase);


    result[0] = amplitude;
    result[1] = phase;
    result[2] = oxsense.calculate(PHTEMP, phase);


    if (amplitude < 600) {
       result[2] = 999.99;
    }


    DEBUG1("Result array:amplitude=%5.0f, phase=%2.2f, OxsenseData=%3.3f", amplitude, phase, result[2]);


//    L3=0;
    L4=0;

}

