#include "mbed.h"
#include "cisme.h"
#include "keys.h"
#include "lcd.h"
#include "lcd_events.h"
#include "wifi_events.h"
#include "wifi.h"
#include "MSCFileSystem.h"
#include "debug.h"
#include "pump.h"
#include "light.h"
#include "buzzer.h"
#include "presens.h"
#include "adc.h"
#include "experiments.h"

MSCFileSystem msc(FSNAME);

int    Salinity           = 36;
double PHTEMP             = 0.0;
double pH                 = 0.0;
double pHCorrected        = 0.0;
float  pHT                = 0.0;
int    flowintime         = 0;
int    lightintime        = 0;
int    minRESP            = 0;
int    minPHOTO           = 0;
int    MeasurementFlow    = 0;
int    MeasurementLight   = 0;
int    MeasurementTypeVal = 0;
int    mtimeRemaining     = 0;
// a, b and c variables are used for example in file lcd_events.c in function phCal in fprintf.
float  a                  = 0.0;
float  b                  = 2.8;
float  c                  = 0.0;
float  PresCal            = 1.0;
float  PhaseCal2          = 1.0;
float  TempCal2           = 1.0;
float  PhaseCal1          = 1.0;
float  TempCal1           = 1.0;
float  LEDCurrent         = 150.0;
float  UNIT               = 0;
float  PHBUFFERF          = 0.0;
float  PHTEMPF            = 0.0;
float  PHTEMPKF           = 0.0;
float  PHVOLTSF           = 0.0;
float  MSINGLEPT          = 0.0;
float  EOSINGLEPT         = 0.0;
int    numberofprograms   = 0;
float  pHNoGain           = 0.0;
float  A                  = 0.0;
float  B                  = 0.0;
float  C                  = 0.0;
float  D                  = 0.0;
//float  lastPercentPump    = 45.0;

char instrumentId[INSTRUMENT_ID_LEN] = "C1";

DigitalOut L1(LED1);
DigitalOut L2(LED2);
DigitalOut L3(LED3);
DigitalOut L4(LED4);

// Configure Analog Input
DigitalIn SDOFlag(p8);


/******************************************************************************\
**    main
\******************************************************************************/
int main()
{
    FILE *paramFile;
    FILE *isFetFile;

    int DebugFlag = 0;

    debugInit(DEBUG_LEVEL_INFO);
    SDOFlag.mode(OpenDrain);
    buzzerInit();

    L1 = 0;
    L2 = 0;
    L3 = 0;
    L4 = 0;

    presensInit();
    lcdInit();

    lcdEventSplash();

    opendir("/" FSNAME);

    isFetFile = fopen("/" FSNAME "/Parameters/isfet.sys","r");

    if (isFetFile == NULL) {
        lcdClear();
        ERROR("Could not open file for write /" FSNAME "/Parameters/isfet.sys");
        lcdWrite(4, 0, JUSTIFICATION_CENTER, "isfet File Missing");
        ADD_START_ERROR(ERROR_MISSED_ISFET);
    } else {
        fscanf(isFetFile, "%f,%f,%f,%f", &A, &B, &C, &D);
        fclose(isFetFile);
    }

    // Read default parameters from file
    paramFile = fopen("/" FSNAME "/Parameters/dsparams.sys", "r");

    if (paramFile == NULL) {
        lcdClear();
        lcdWrite(4, 0, JUSTIFICATION_CENTER, "Dsprams File Missing");
        ERROR("Dsparams file missing.");
        ADD_START_ERROR(ERROR_MISSED_DSPARAMS);
    } else {
        fscanf(paramFile, "%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%d",
               &a, &b, &c, &PresCal, &PhaseCal2, &TempCal2, &PhaseCal1,
               &TempCal1, &LEDCurrent, &PHBUFFERF, &PHTEMPF, &PHTEMPKF,
               &PHVOLTSF, &MSINGLEPT, &EOSINGLEPT, &UNIT, &DebugFlag);
        fclose(paramFile);
    }

    debugSetLvl(DebugFlag);
    INFO("Debug level set to %s", debugFormatTraceLevel(DebugFlag));

    DEBUG1("Debug Mode active: A=%F, B=%F, C=%F, D=%F, a=%F, b=%F, c=%F",
           A, B, C, D, a, b, c);

    readUserPrograms();

    pumpInit();
    lightInit();

    L1=1;

    adcInit();

    DEBUG2("PHBUFFERF=%2.6f, PHTEMPF=%2.6f, PHTEMPKF=%2.6f, PHVOLTSF=%2.6f, MSINGLEPT=%2.6f, EOSINGLEPT=%2.6f",
           PHBUFFERF, PHTEMPF, PHTEMPKF, PHVOLTSF, MSINGLEPT, EOSINGLEPT);
    DEBUG2("PresCal=%2.6f, PhaseCal2=%2.6f, TempCal2=%2.6f, PhaseCal1=%2.6f, TempCal1=%2.6f, LEDCurrent=%2.6f",
           PresCal, PhaseCal2, TempCal2, PhaseCal1, TempCal1, LEDCurrent);

    wait(0.3);

    presensConfig(LEDCurrent);

    L2=1;

    MeasurementTypeVal = 1;
    MeasurementFlow    = 0;
    MeasurementLight   = 0;

    L3=1;

    wifiInit();
    
    L4=1;
 //   L1=0;
 //   L2=0;
 //   L3=0;
 //   wait(0.5);
 //   L1=1;
 //   L2=1;
 //   L3=1;

    buzzerBeep(0.2);
    wait(0.2);
    buzzerBeep(0.2);
    wait(0.2);
    buzzerBeep(0.2);
    wait(0.2);
    buzzerBeep(0.2);
    wait(0.2);
    
    INFO("Done startup. Enter event loop");

    // Go to main event loop
    lcdEventsStart();
    wifiEventsStart();
}
