#ifndef DEBUG_H
#define DEBUG_H

/* Debug comm settings. */
#define DEBUG_BAUD                 9600
/* The number of bits in a word (5-8; default = 8) */
#define DEBUG_NO_BITS                 8
/* parity - The parity used (Serial::None, Serial::Odd, Serial::Even, Serial::Forced1, Serial::Forced0; default = Serial::None) */
#define DEBUG_PARITY       Serial::None
/* stop - The number of stop bits (1 or 2; default = 1) */
#define DEBUG_NO_STOP_BITS            1

#define DEBUG_MAX_TRACE_LENGTH 256

#define INFO(  _formatStr, ...) debugPrintf(__FILE__, __LINE__, __func__,  DEBUG_LEVEL_INFO, _formatStr, ##__VA_ARGS__)
#define ERROR( _formatStr, ...) debugPrintf(__FILE__, __LINE__, __func__, DEBUG_LEVEL_ERROR, _formatStr, ##__VA_ARGS__)
#define DEBUG1(_formatStr, ...) debugPrintf(__FILE__, __LINE__, __func__,     DEBUG_LEVEL_1, _formatStr, ##__VA_ARGS__)
#define DEBUG2(_formatStr, ...) debugPrintf(__FILE__, __LINE__, __func__,     DEBUG_LEVEL_2, _formatStr, ##__VA_ARGS__)
#define DEBUG3(_formatStr, ...) debugPrintf(__FILE__, __LINE__, __func__,     DEBUG_LEVEL_3, _formatStr, ##__VA_ARGS__)
#define DEBUG4(_formatStr, ...) debugPrintf(__FILE__, __LINE__, __func__,     DEBUG_LEVEL_4, _formatStr, ##__VA_ARGS__)
#define DEBUG5(_formatStr, ...) debugPrintf(__FILE__, __LINE__, __func__,     DEBUG_LEVEL_5, _formatStr, ##__VA_ARGS__)

typedef enum
{
    DEBUG_LEVEL_DISABLED = -2,
    DEBUG_LEVEL_ERROR    = -1,
    DEBUG_LEVEL_INFO     =  0,
    DEBUG_LEVEL_1        =  1,
    DEBUG_LEVEL_2        =  2,
    DEBUG_LEVEL_3        =  3,
    DEBUG_LEVEL_4        =  4,
    DEBUG_LEVEL_5        =  5
} DebugLevel;

void debugInit(int initDebugLvl);

void debugSetLvl(int newDebugLvl);

int debugGetCurrLvl();

void debugPrintf(char* file, int line, const char* func, int debugLvl, char* format, ...);

const char* debugFormatTraceLevel(int val);

#endif //DEBUG_H
