#include <stdarg.h>
#include "mbed.h"
#include "cisme.h"
#include "debug.h"

#define DEBUG_OUTPUT_FILE_NAME "/"FSNAME"/debug.log"


static int debugLvl = DEBUG_LEVEL_INFO;
/* Main debug port. */
static Serial debugComm(USBTX,USBRX);

void debugInit(int initDebugLvl)
{
    /* Actually this baud rate is used by default according to the documentation. */
    debugComm.baud(DEBUG_BAUD);
    /* Set the communication settings. */
    debugComm.format(DEBUG_NO_BITS, DEBUG_PARITY, DEBUG_NO_STOP_BITS);

    debugLvl = initDebugLvl;
}

void debugSetLvl(int newDebugLvl)
{
    debugLvl = newDebugLvl;
}

int debugGetCurrLvl()
{
    return debugLvl;
}

void debugPrintf(char* file, int line, const char* func, int traceLvl, char* formatStr, ...)
{
    static char traceBuffer[DEBUG_MAX_TRACE_LENGTH];
    va_list params;
    time_t  seconds;

    if (traceLvl > debugLvl) {
        return;
    }

    va_start(params, formatStr);

    vsprintf(traceBuffer, formatStr, params);

    va_end(params);

    seconds = time(NULL);

    debugComm.printf("[%.24s]:%s:%s%d:%s %s\n\r", ctime(&seconds), debugFormatTraceLevel(traceLvl), file, line, func, traceBuffer);
    
#ifdef DEBUG_TO_FILE
    static FILE* debugOutFile_p = NULL;
    debugOutFile_p = fopen(DEBUG_OUTPUT_FILE_NAME, "a");

    if (debugOutFile_p != NULL) {
        fprintf(debugOutFile_p, "[%.24s]:%s:%s:%d:%s %s\n", ctime(&seconds), debugFormatTraceLevel(traceLvl), file, line, func, traceBuffer);
        fclose(debugOutFile_p);
        debugOutFile_p = NULL;
    }
#endif
}

const char* debugFormatTraceLevel(int val)
{
    switch (val) {
        case DEBUG_LEVEL_ERROR:
            return "ERROR";
        case DEBUG_LEVEL_INFO:
            return "INFO";
        case DEBUG_LEVEL_1:
            return "LEVEL1";
        case DEBUG_LEVEL_2:
            return "LEVEL2";
        case DEBUG_LEVEL_3:
            return "LEVEL3";
        case DEBUG_LEVEL_4:
            return "LEVEL4";
        case DEBUG_LEVEL_5:
            return "LEVEL5";
        default:
            return "Unknown";
    }
}