#include "ui.h"

UI::UI()
:   lcd(PB_9, PB_8),
    b0_(PC_3),
    tgl1(PA_9),
    tgl2(PB_10),
    tgl3(PB_5),
    buzz(PC_7)
{
    team = 0;//初期化
    algorithm = 0;
    displayst = 0;
    mode = 0;
    name1 = name2 = NULL;
    for (int i = 0; i < 4; i++) b[i] = b_[i] = 0;
    UIthread.start(callback(this,&UI::display));
}

void UI::updatebt()
{
    b0 = b0_ * 10;
    for(int i = 0; i < 4; i++){
        if((b0 > (2*i + 3)) && (b0 < (2*i + 5))) b[i] = 1;
        else b[i] = 0;
        if(b[i] && (!b_[i])) flag[i] = 1;
        else flag[i] = 0;
    }
    
    if (mode == 0) {
        if(flag[0]){
            team = !team;
        }
        if(flag[1]){
            ++algorithm %= 5;
        }
        if(flag[2]){
            ++displayst %= 6;
        }
        if(flag[3]){
            start = !start;
        }
    }
    for(int i = 0; i < 4; i++) b_[i] = b[i];
    mode = (4*!tgl1)+(2*!tgl2)+(!tgl3);
}

void UI::change(char *valname1_, char *valname2_, int *dispvalue_)
{
    name1 = valname1_;
    name2 = valname2_;
    dispvalue[0] = dispvalue_[0];
    dispvalue[1] = dispvalue_[1];
}

void UI::display()
{
    while(1) {
        updatebt();
        lcd.clear();
        
        lcd.setCursor(0,0);
        lcd.print(algorithm);
        
        lcd.setCursor(0,0);
        lcd.print(algorithm);
        lcd.print(displayst);
        lcd.print(name1);
        lcd.print(dispvalue[0]);
        lcd.setCursor(0,1);
        lcd.print(team);
        lcd.print(mode);
        lcd.print(name2);
        lcd.print(dispvalue[1]);
        ThisThread::sleep_for(10);
    }
}

void UI::returnchar(char *buf)
{
    for(int i = 0; i < 4; i++)
    {
        buf[i] = name1[i];
    }
}

void UI::returnbt(uint8_t *mainbt)
{
    for(int i = 0; i < 4; i++){
        mainbt[i] = b[i];
    }
}