#include "solenoid.h"

Solenoid::Solenoid(PinName solenoiPin):sorenoidOutPut(solenoiPin)
{
    kickperiod = DEFAULT_KICK_PERIOD;
    outputtime = DEFAULT_KICK_OUTPUT_TIME;
    timer.start();
    rhythm.start();
}

void Solenoid::setkickperiod(double kickperiod_)
{
    kickperiod = kickperiod_;
}

void Solenoid::setoutputtime(double outputtime_)
{
    outputtime = outputtime_;
}

void Solenoid::outPut()
{
    now = timer.read();
    thread.start(callback(this, &Solenoid::assemble));
}

void Solenoid::assemble()
{
    if(0.5 < outputtime) outputtime = 0.5;
    while(true) {
        if((now - lastkikkertime)> kickperiod) {
            lastkikkertime = now;
            rhythm.reset();
        }
        outputnowtime = rhythm.read();
        if(outputnowtime > outputtime) {
            sorenoidOutPut = 0;
        } else {
            sorenoidOutPut = 1;
        }
    }
}

