#ifndef LINE_H
#define LINE_H

#include "mbed.h"

#define DEFAULT_LINESENSOR_JUDGVALUE 400

/**
 * ラインセンサ用クラス
 */
class Line{
public:
    /**
     * デフォルトコンストラクタ
     */
    Line(PinName line_);
    
    Line(PinName line_, float border_);
    
    /**
    *ラインとの境目の位置
    */
     void border(float border_);
     
     
    /**
    *ラインの判別表示
    *1だとライン踏んでいる
    *0だとラインを踏んでいない
    */
    bool judg();
    
    /**
    *センサの値表示
    */
    float value();
    
    operator bool();

private:
//    AnalogIn linesensor;
    DigitalIn linesensor;
    float linevalue, lineborder;
    Thread thread;
    void lineassemble();
    bool judgvalue;

};



#endif
