#include "jy901.h"

JY901::JY901(PinName sda, PinName scl) : I2C(sda, scl)
{
}

void JY901::calibrateGyroAccel()
{
    char calibrationRegistar[3]= {CALSW,0x01,0x00};
    write(IICADDR,calibrationRegistar,3,false);
}

void JY901::calibrateMagnetic()
{
    char calibrationRegistar[3]= {CALSW,0x02,0x00};
    write(IICADDR,calibrationRegistar,3,false);
}

void JY901::calibrateHeight()
{
    char calibrationRegistar[3]= {CALSW,0x03,0x00};
    write(IICADDR,calibrationRegistar,3,false);
}

void JY901::endCalibrate()
{
    char calibrationRegistar[3]= {CALSW,0x00,0x00};
    write(IICADDR,calibrationRegistar,3,false);
}

void JY901::yawcalibrate()
{
    char calibrationRegistar[3]= {CALSW,0x04,0x00};
    write(IICADDR,calibrationRegistar,3,false);
}

void JY901::algorithmtrasition()
{
    char calibrationRegistar[3]= {0x24,0x01,0x00};
    write(IICADDR,calibrationRegistar,3,false);
}

void JY901::calibrateAll(int time_ms)
{
    calibrateGyroAccel();
    thread_sleep_for(time_ms);
    calibrateMagnetic();
    thread_sleep_for(time_ms);
    calibrateHeight();
    thread_sleep_for(time_ms);
    endCalibrate();
    thread_sleep_for(time_ms);
    algorithmtrasition();
    thread_sleep_for(time_ms);
    yawcalibrate();
    
}

float JY901::getXaxisAcceleration()
{
    char *data = getdata(AX);
    return (float)((*(data+1) << 8) | *data) / 32768 * 16 * g;
}

float JY901::getYaxisAcceleration()
{
    char *data = getdata(AY);
    return (float)((*(data+1) << 8) | *data) / 32768 * 16 * g;
}

float JY901::getZaxisAcceleration()
{
    char *data = getdata(AZ);
    return (float)((*(data+1) << 8) | *data) / 32768 * 16 * g;
}

float JY901::getXaxisAngularVelocity()
{
    char *data = getdata(GX);
    return (float)((*(data+1) << 8 ) | *data) / 32768 * 2000;
}

float JY901::getYaxisAngularVelocity()
{
    char *data = getdata(GY);
    return (float)((*(data+1) << 8 ) | *data) / 32768 * 2000;
}

float JY901::getZaxisAngularVelocity()
{
    char *data = getdata(GZ);
    return (float)((*(data+1) << 8 ) | *data) / 32768 * 2000;
}

float JY901::getXaxisMagnetic()
{
    char *data = getdata(HX);
    return (float)((*(data+1) << 8) | *data);
}

float JY901::getYaxisMagnetic()
{
    char *data = getdata(HY);
    return (float)((*(data+1) << 8) | *data);
}

float JY901::getZaxisMagnetic()
{
    char *data = getdata(HZ);
    return (float)((*(data+1) << 8) | *data);
}

float JY901::getXaxisAngle()
{
    char *data = getdata(Roll);
    return (float)((*(data+1) << 8) | *data) / 32768 * 180;
}

float JY901::getYaxisAngle()
{
    char *data = getdata(Pitch);
    return (float)((*(data+1) << 8) | *data) / 32768 * 180;
}

float JY901::getZaxisAngle()
{
    char *data = getdata(Yaw);
    return (float)((*(data+1) << 8) | *data) / 32768 * 180;
}

char *JY901::getdata(char registar)
{
    char data[2] = {};
    write(IICADDR,&registar,1,true);
    read(IICADDR,data,2,false);
    return data;
}
