#ifndef CAMERA_H
#define CAMERA_H

#include "mbed.h"
#include "lpf.h"

class Cam
{
public:
    Cam(PinName mosi_sda_tx, PinName miso_scl_rx, PinName sclk);
    void SPIloop();
    
    uint16_t ballX();
    uint16_t ballY();
    uint16_t ballWidth();
    uint16_t ballHeight();
    
    uint16_t blueX();
    uint16_t blueY();
    uint16_t blueWidth();
    uint16_t blueHeight();
    
    uint16_t yellowX();
    uint16_t yellowY();
    uint16_t yellowWidth();
    uint16_t yellowHeight();
    
    uint16_t getData(int i);
//    uint16_t rawBallCenterX();
//    uint16_t rawBallCenterY();
//    uint16_t rawBallWidth();
//    uint16_t rawBallHeight();
//    uint16_t rawBlueCenterX();
//    uint16_t rawBlueCenterY();
//    uint16_t rawBlueWidth();
//    uint16_t rawBlueHeight();
//    uint16_t rawYellowCenterX();
//    uint16_t rawYellowCenterY();
//    uint16_t rawYellowWidth();
//    uint16_t rawYellowHeight();
    
    bool ballSignal();
    bool blueSignal();
    bool yellowSignal();
     
    uint8_t pixydata[14+42];
private:
    SPI spi;
    Thread thread;
    uint8_t sendData[6];
    uint16_t data[24];
    uint16_t ballData[7];
    uint16_t blueData[7];
    uint16_t yellowData[7];
    bool ballSig,blueSig,yellowSig;
    lpf *ball[4],*blue[4],*yellow[4];
};
#endif