#ifndef SA_H
#define SA_H

#include "mbed.h"

class SerialArduino
{
public:
    SerialArduino(PinName TX, PinName RX, int baud);
//attachの関数　使用の必要なし
    void serialLoop();
//debug用　ヘッダー1を返す
    uint8_t getHedder1();
//debug用　ヘッダー1を返す
    uint8_t getHedder2();
//ボタンを返す 引数0から11
    bool getButton(int num);
//トリガーを返す 引数0から1
    uint8_t getTrigger(int num);
//スティックを返す 引数0から3
    uint8_t getStick(int num);
//タイムアウトカウントを返す
    uint16_t getTimeoutCount();
//通信確認兼更新　毎ループ処理すること 通信できてれば1を返す
    bool getState();
    
private:
//    uint8_t buff[3];
    bool state;
    const bool high=1;
    uint8_t hedder1;
    uint8_t hedder2;
    uint8_t b0;
    uint8_t b1;
    uint16_t button;
    uint8_t timeout;
    int past,timeoutCount;
    bool b[12]={0};
    uint8_t trigger[2]={0};
    uint8_t stick[4]={0};

    char CRLF[3] = "\r\n";
//    uint16_t checkSum;
    int i;
    UnbufferedSerial mini;
    
    Thread thread;
    
};



#endif