#include "SerialArduino.h"

SerialArduino::SerialArduino(PinName TX,PinName RX, int baud)
: mini(TX,RX,baud)
{
//    mini.attach(callback(this,&SerialArduino::serialLoop), SerialBase::RxIrq);
    state=0;
    thread.start(callback(this, &SerialArduino::serialLoop));
}

void SerialArduino::serialLoop()
{
    while (1) {
        mini.read(&hedder1,1);
        mini.read(&hedder2,1);
    //    mini.read(buff,1);
    //    checkSum = atoi(&buff[2]);
        if(hedder1==0xff 
        && hedder2==0xee 
        )
        {
    //        mini.read(&button,2);
            mini.read(&b0,1);
            mini.read(&b1,1);
            mini.read(&trigger[0],1);
            mini.read(&trigger[1],1);
            mini.read(&stick[0],1);
            mini.read(&stick[1],1);
            mini.read(&stick[2],1);
            mini.read(&stick[3],1);
    //        mini.read(&checkSum,1);
            mini.read(&timeout,1);
    
        }
//        mini.write(CRLF,2);
//        ThisThread::sleep_for(1);
    }

}

bool SerialArduino::getState()
{

    //button
    button = b0 << 8 | b1;
    for(i=11;i>=0;i--)
    {
        b[i] = button & high;
        button = button >> 1;
    }
    //timeout    
    if(timeout == past)
    {
        if(state) timeoutCount++;    
    }
    else
    {
        timeoutCount = 0;
        state=1;
    }
    if(timeoutCount > 20)
    {
        state=0;
    }
    past = timeout;

    return(state);
}

uint8_t SerialArduino::getHedder1()
{
    return(hedder1);
}

uint8_t SerialArduino::getHedder2()
{
    return(hedder2);
}

bool SerialArduino::getButton(int num)
{
    return(b[num]);
}

uint8_t SerialArduino::getTrigger(int num)
{
    return(trigger[num]);
}

uint8_t SerialArduino::getStick(int num)
{
    return(stick[num]);
}

uint16_t SerialArduino::getTimeoutCount()
{
    return(timeout);
}


