#ifndef ROBOT_H
#define ROBOT_H

#include "main.h"
#include "sensorGen.h"
#include "robo_config.h"
#include "kohiMD.h"
#include "solenoid.h"
#include "esc.h"
#include "omni_wheel.h"
#include "PID.h"

class Robot
{
public :
    /**コンストラクタ
     * ピン設定
     */
    Robot();
    
    /**ボールが見えてる時用だよ
     */
    void chaseBall();
    
    /**ボールを見失ってる時だよ
     */
    void lostBall();
    
    /**強いよ
     */
    void start(uint8_t Team, uint8_t Algorithm);
    
    /**PIDだけだよ
     */
    void pidtest();
    
    /**モーターチェック
     */
    void motorCheck(int motorNumber, float power);
    
    /**モーター以外のチェックをしてる時にモーターを止める関数だよ
     */
    void motorStop(double pwm);
    
    /**キッカーチェックだよ
     */
    void kickCheck();
    
    /**ドリブラーチェックだよ
     */
    void dribbleCheck(float power);
    
    /**回り込みだよ
     */
    void moveTest();
    
    /**jyリセットだよ
     */
    
    sensorgen sensor_;
    OmniWheel      omni;
    
private :
    KohiMD         *motor[4];
    Solenoid       shot;
    RCJESC         drib;
    PID            spin,sgoal;
    BufferedSerial pc;
    Timer          tim;
    Timer          lineOut;

    float   theta;
    float   towardAngle;
    float   omni2wheel,omni3wheel;
    float   spin_power, motorSpeed, thisSpeed[4];
    bool    startb=false,lineflag=0;
    uint8_t i,_motorNumber;
};

#endif