#ifndef MASTER_H
#define MASTER_H

#include "main.h"
#include "kohiMD.h"
#include "solenoid.h"
#include "esc.h"

class Master
{
public :
    ///
    /// @fn Master()
    /// @brief コンストラクター
    /// @detail ピンはmain.hで定義
    ///
    Master();
    
    ///
    /// @fn Shot()
    /// @brief ソレノイドを駆動させる
    /// @detail ソレノイドのパワーはmain.hで定義
    ///
    void Shot();
    
    ///
    /// @fn Dribble(float power)
    /// @brief ドリブラーを回す
    /// @param power ドリブラの回転速度
    ///
    void Dribble(float power);
    
    ///
    /// @fn SetValueMotor(int num, double val)
    /// @brief 足回りモーターを回す
    /// @param num 回すモーターの番号
    /// @param val 速度(-1 ~ 1)
    ///
    void SetValueMotor(int num, double val);
    
private :
    BufferedSerial pc;
    KohiMD         *motor[4];
    Solenoid       shot;
    RCJESC         drib;
};

#endif