#include "../QMRemote.h"

/*
 * black remote
 *
 * PROTOCOL: NEC
 * BITCOUNT: 32
 *
 * FRAME:
 *  <    8-bit    > <    8-bit    > <    8-bit    > <    8-bit    >
 *  |   ADDRESS1  | |   ADDRESS2  | |   COMMAND1  | |   COMMAND2  |
 * LSB          MSB LSB         MSB LSB         MSB LSB         MSB
 * ADDRESS2 is logical inversion of ADDRESS1
 * COMMAND2 is logical inversion of COMMAND1
 *
 * reference: http://www.sbprojects.com/knowledge/ir/nec.php
 */

struct QMRemote::ir_codes remote_1_codes[] = {
    { "power",0x80/*,0b10000000*/,0x7f/*,0b01111111*/,0x51/*,0b01010001*/,0xae/*,0b10101110*/,},
    {  "mute",0x80/*,0b10000000*/,0x7f/*,0b01111111*/,0x4d/*,0b01001101*/,0xb2/*,0b10110010*/,},
    { "media",0x80/*,0b10000000*/,0x7f/*,0b01111111*/,0x09/*,0b00001001*/,0xf6/*,0b11110110*/,},
    { "music",0x80/*,0b10000000*/,0x7f/*,0b01111111*/,0x11/*,0b00010001*/,0xee/*,0b11101110*/,},
    {   "web",0x80/*,0b10000000*/,0x7f/*,0b01111111*/,0x54/*,0b01010100*/,0xab/*,0b10101011*/,},
    {   "app",0x80/*,0b10000000*/,0x7f/*,0b01111111*/,0x4f/*,0b01001111*/,0xb0/*,0b10110000*/,},
    {  "vol-",0x80/*,0b10000000*/,0x7f/*,0b01111111*/,0x56/*,0b01010110*/,0xa9/*,0b10101001*/,},
    {"rewind",0x80/*,0b10000000*/,0x7f/*,0b01111111*/,0xbd/*,0b10111101*/,0x42/*,0b01000010*/,},
    {  "ffwd",0x80/*,0b10000000*/,0x7f/*,0b01111111*/,0xbb/*,0b10111011*/,0x44/*,0b01000100*/,},
    {  "vol+",0x80/*,0b10000000*/,0x7f/*,0b01111111*/,0x4e/*,0b01001110*/,0xb1/*,0b10110001*/,},
    {  "home",0x80/*,0b10000000*/,0x7f/*,0b01111111*/,0x53/*,0b01010011*/,0xac/*,0b10101100*/,},
    {"return",0x80/*,0b10000000*/,0x7f/*,0b01111111*/,0x1b/*,0b00011011*/,0xe4/*,0b11100100*/,},
    {  "left",0x80/*,0b10000000*/,0x7f/*,0b01111111*/,0x25/*,0b00100101*/,0xda/*,0b11011010*/,},
    {    "up",0x80/*,0b10000000*/,0x7f/*,0b01111111*/,0x26/*,0b00100110*/,0xd9/*,0b11011001*/,},
    { "right",0x80/*,0b10000000*/,0x7f/*,0b01111111*/,0x27/*,0b00100111*/,0xd8/*,0b11011000*/,},
    {  "down",0x80/*,0b10000000*/,0x7f/*,0b01111111*/,0x28/*,0b00101000*/,0xd7/*,0b11010111*/,},
    {  "menu",0x80/*,0b10000000*/,0x7f/*,0b01111111*/,0x49/*,0b01001001*/,0xb6/*,0b10110110*/,},
    { "mouse",0x80/*,0b10000000*/,0x7f/*,0b01111111*/,0x52/*,0b01010010*/,0xad/*,0b10101101*/,},
    {   "one",0x80/*,0b10000000*/,0x7f/*,0b01111111*/,0x31/*,0b00110001*/,0xce/*,0b11001110*/,},
    {   "two",0x80/*,0b10000000*/,0x7f/*,0b01111111*/,0x32/*,0b00110010*/,0xcd/*,0b11001101*/,},
    { "three",0x80/*,0b10000000*/,0x7f/*,0b01111111*/,0x33/*,0b00110011*/,0xcc/*,0b11001100*/,},
    {  "four",0x80/*,0b10000000*/,0x7f/*,0b01111111*/,0x34/*,0b00110100*/,0xcb/*,0b11001011*/,},
    {  "five",0x80/*,0b10000000*/,0x7f/*,0b01111111*/,0x35/*,0b00110101*/,0xca/*,0b11001010*/,},
    {   "six",0x80/*,0b10000000*/,0x7f/*,0b01111111*/,0x36/*,0b00110110*/,0xc9/*,0b11001001*/,},
    { "seven",0x80/*,0b10000000*/,0x7f/*,0b01111111*/,0x37/*,0b00110111*/,0xc8/*,0b11001000*/,},
    { "eight",0x80/*,0b10000000*/,0x7f/*,0b01111111*/,0x38/*,0b00111000*/,0xc7/*,0b11000111*/,},
    {  "nine",0x80/*,0b10000000*/,0x7f/*,0b01111111*/,0x39/*,0b00111001*/,0xc6/*,0b11000110*/,},
    { "one_a",0x80/*,0b10000000*/,0x7f/*,0b01111111*/,0x58/*,0b01011000*/,0xa7/*,0b10100111*/,},
    {  "zero",0x80/*,0b10000000*/,0x7f/*,0b01111111*/,0x30/*,0b00110000*/,0xcf/*,0b11001111*/,},
    {"delete",0x80/*,0b10000000*/,0x7f/*,0b01111111*/,0x44/*,0b01000100*/,0xbb/*,0b10111011*/,},
    {    "ok",0x80/*,0b10000000*/,0x7f/*,0b01111111*/,0x0d/*,0b00001101*/,0xf2/*,0b11110010*/,},

};

const struct QMRemote::ir_remote remote_1 = {
    "remote-black",
    QMRemote::NEC,
    32,
    ARRAY_SIZE(remote_1_codes),
    remote_1_codes,
};