#include "mbed.h"
#include "rtos.h"
#include "ReceiverIR.h"
#include "Pump.h"

ReceiverIR ir_rx(PA_0);
//////////////////PUMP
DigitalOut  my_led(LED1);
InterruptIn my_button(USER_BUTTON);
PwmOut      my_pwm(PB_5);
unsigned long pump=0,pc1=0,pc2=0;
////////////////stepper
DigitalOut  DIRE(A1);//00=FULL STEP,01=HALF,2=WAVE DRIVE
DigitalOut  SM1(A2);
DigitalOut  SM0(A4);
DigitalOut  STEP(A3);
unsigned long Stepper_dir=0,sc1=0,sc2=0;


//void pressed() {
//    if (my_pwm.read() == 0.25) {
//        my_pwm.write(0.75);
//    }
//    else {
//        my_pwm.write(0.25);
//    }
//}//void pressed() {
//    if (my_pwm.read() == 0.25) {
//        my_pwm.write(0.75);
//    }
//    else {
//        my_pwm.write(0.25);
//    }
//}
/////////////////PWM


void bin2hex(uint8_t c, unsigned length)
{
    const char* quads[] = 
    {
        "0000", "0001", "0010", "0011", "0100", "0101",
        "0110", "0111", "1000", "1001", "1010", "1011",
        "1100", "1101", "1110", "1111"
    };

    if (length == 8) 
    {
        uint8_t ch = ((c & 0xF0) >> 4);
        uint8_t cl = (c & 0x0F);
        printf("0x%02x,%s%s,", c, quads[ch], quads[cl]);
    } else 
    {
        while (length--) 
            {
                uint8_t b = (c & 0x80);
                c <<= 1;
                printf("%c", b ? '1' : '0');
            }
    }
}

#include "remote-1.h"
struct QMRemote::ir_remote supported_remotes[] = 
{
    remote_1,
};
unsigned supported_remotes_size = ARRAY_SIZE(supported_remotes);

uint8_t matchRemote(RemoteIR::Format format, uint8_t *buf, int bitcount)
{
    size_t i;
    QMRemote::ir_remote* remote;
    QMRemote::ir_codes* code;
    for (i = 0; i < supported_remotes_size; i++) 
    {
        remote = &supported_remotes[i];
        if (!( (format == remote->format) && (bitcount == remote->bitcount) )) 
        {
            continue;
        }

        if (!remote->codes_size) 
        {
            return false; // should never get here
        }

        code = &remote->codes[0];
        if (buf[0] != code->buf[0])
        {
            continue;
        }

        for(i = 0; i < remote->codes_size; i++) 
        {
            code = &remote->codes[i];
            if ( memcmp ( buf, code->buf, ((bitcount / 8) + (bitcount % 8 == 0 ? 0 : 1)) ) == 0 ) 
            {
               // printf("remote: %s; button***: %s\n", remote->remote_name, code->code_name);
               // printf("buffer buf[50]: 0x%2x\n",code->buf[50]);
                if(code->buf[2]==0x51)
                    {
                         printf("devide on power");
                    }     
                    
                else if(code->buf[2]==0x31)
                    {
                         printf("devide ONE pressed");
                    } 
                else if(code->buf[2]==0x31)
                    {
                         printf("devide ONE pressed");
                    } 
                    ///////////////////////
                else if(code->buf[2]==0x25)
                    {
                         printf("left key");
                         pump=0;
                         //my_pwm.write(0.10);
                    } 
                else if(code->buf[2]==0x27)
                    {
                         printf("right key");
                         pump=1;
                         //my_pwm.write(0.99);
                    } 
                else if(code->buf[2]==0x26)
                    {
                         //printf("up");
                         Stepper_dir=1;
                    } 
                else if(code->buf[2]==0x28)
                    {
                        // printf("down");
                         Stepper_dir=0;
                    } 

                   
                return true;
            }
        } // for codes
    } // for remotes

    return false;
}

int main()
{
    /////////////////////////stepper
    SM0=1;
    SM1=0;
    DIRE=0;
    ////////////////////////////pump
    my_pwm.period_ms(10);
    my_pwm.write(0.50);
    //////////////////////////REMOTE START
    RemoteIR::Format format;
    uint8_t buf[32];
    int bitcount;
    int n;
    int i;

    printf("START\n");
    fflush(stdout);

    while (1) {
        if (ir_rx.getState() == ReceiverIR::Received) 
        {
            bitcount = ir_rx.getData(&format, buf, sizeof(buf) * 8);
            if (bitcount) 
            {
                if (!matchRemote(format, buf, bitcount)) 
                {
                    printf("remote: UNKNOWN; button: UNKNOWN\n");
                }
//#if 0
#if 1
                switch(format) 
                {
                    case RemoteIR::NEC:
                        printf("NEC,");
                        break;
                    case RemoteIR::NEC_REPEAT:
                        printf("NEC_REPEAT,");
                        break;
                    case RemoteIR::AEHA:
                        printf("AEHA,");
                        break;
                    case RemoteIR::AEHA_REPEAT:
                        printf("AEHA_REPEAT,");
                        break;
                    case RemoteIR::SONY:
                        printf("SONY,");
                        break;
                    case RemoteIR::UNKNOWN:
                    default:
                        printf("UNKNOWN,");
                } // format
                n = bitcount / 8;
                {
                    bin2hex(buf[i], 8);
                }
                if ((bitcount % 8) != 0) 
                {
                    bin2hex(buf[i], (bitcount % 8));
                }
                printf("\n");
#endif
            } // if bitcount > 0
            fflush(stdout);
        }
        ////////////////////////////////////////////REMOTE OVER
     if(pump==0)
      {  
         wait_ms(10);
         pc1++;
        if(pc1>=1000)
        {
            pc1=0;
            pump=2;
        }
         my_pwm.write(0.40);
      }
     else if(pump==1)
     {
         wait_ms(10);
         pc2++;
        if(pc2>=1000)
        {
            pc2=0;
            pump=2;
        }
         my_pwm.write(0.99);
        // printf("\nhigh pwm");
     }
     else
     {
         my_pwm.write(0.00);
     }
     ////////////////////////////////stepper
      if(Stepper_dir==0)
      {  
         DIRE=0;
         STEP=1;
         wait_ms(10);
         STEP=0;
         sc1++;
        if(sc1>=100)
        {
            sc1=0;
            Stepper_dir=2;
        }
      }
     else if(Stepper_dir==1)
     {
         DIRE=1;
         STEP=1;
         wait_ms(10);
         STEP=0;;
         sc2++;
        if(sc2>=100)
        {
            sc2=0;
            Stepper_dir=2;
        }

     }

      
        
    }
}