
/* ****************************************************************************************************

                                OBD - ACCELEROMETER INTERFACE
                                
**************************************************************************************************** */

/*

NOTE :
This program aims at interfacing both the OBD scan tool and ADXL345 Accelerometer
Testing the combined application of both in progress
Code is subjected to modification

Date : 25 - Feb - 2017 (Saturday)
Author : BALA

*/

#include "mbed.h"
#include "accelerometer.h"
#include "obd_libraries.h"
#include "common_definitions.h"

//--------------------------------------------------------------------------------------------------------

I2C i2cm(PB_9, PB_8);
Serial pcm(USBTX, USBRX);
Serial OBD_UARTm(PA_0, PA_1);

//DigitalOut led(LED1);

//InterruptIn double_tap(PC_1);               // Pin assignment may vary
//InterruptIn activity_inactivity(PC_0);      // Pin assignment may vary

//--------------------------------------------------------------------------------------------------------

/* THE FOLLOWING DECLARATIONS ARE GLOBAL VARIABLES */

extern char current_speed, previous_speed;
//extern char speed_threshold = 10;

extern float car_battery_voltage;
extern long vehicle_speed;

extern char OBD_UART_RX_Buffer[50];
char OBD_RxBuffer_End_Pos = 0;
char OBD_UART_RX_Size = 50;

//extern const int slave_address_acc = 0xA6;
//extern char interrupt_source[2];
//extern char intr_source_address[2] = {0x30, 0};
//extern char all_interrupt_clear_command[2] = {0x2E, 0x00};
//extern char all_interrupt_enable_command[2] = {0x2E, 0x18};
//extern char activity_interrupt_disable_command[2] = {0x2E, 0x28};
//extern char inactivity_interrupt_disable_command[2] = {0x2E, 0x30};
//extern unsigned int interrupt_source_duplicate;

extern char obd_reset_cmd[];

extern char no_of_stored_dtc;

extern void OBD_onDataRx();
extern void interrupt_sudden_jerk();
extern void interrupt_activity_inactivity();


//*********************************************************************************************************


/* THE FOLLOWING CODE BLOCK IS THE INTERRUPT SERVICE ROTUINE FOR OBD DATA RECEIVE */

//void OBD_onDataRx()
//{
//    pcm.printf("\r\n ENTERED \r\n");
//     if(OBD_UARTm.readable()) {
//       
//        pcm.putc(OBD_UART_RX_Buffer[OBD_RxBuffer_End_Pos++] = OBD_UARTm.getc());
//        /*
//        if(OBD_RxBuffer_End_Pos >= OBD_UART_RX_Size) {
//            // BUFFER OVERFLOW. What goes here depends on how you want to cope with that situation.
//            // For now just throw everything away.
//            OBD_RxBuffer_End_Pos  = 0;
//        }
//        */
//    }
//}

//*********************************************************************************************************


/* THE FOLLOWING SET OF CODE BLOCKS ARE INTERRUPT SERVICE ROTUINES OF ACCELEROMETER */


//*********************************************************************************************************

// THE FOLLOWING CODE BLOCK IS THE ISR FOR SUDDEN JERK CONDITION

//void interrupt_sudden_jerk() 
//{
//    char count;
//    
//    i2cm.write(slave_address_acc, all_interrupt_clear_command, 2); 
//    pcm.printf("~~~ ENTERED SUDDEN JERK CONDITION ~~~\r\n\r\n");
///*
//        for(count = 0; count < 2; count++)
//        {
//            led = 1;
//            wait(2);
//            led = 0;
//            wait(1);   
//        }
//*/
//    i2cm.write(slave_address_acc, all_interrupt_enable_command, 2);
//    
//}

//*********************************************************************************************************
//
//// THE FOLLWOING CODE BLOCK IS THE MULITIPLEXED ISR FOR BOTH ACTIVITY & INACTIVITY INTERRUPT
//
//void interrupt_activity_inactivity() 
//{  
//    char count;
//    
//    // The following statement disables all interrupts since no other interrupts must disturb at this point
//    
//    i2cm.write(slave_address_acc, all_interrupt_clear_command, 2); 
//    
//    i2cm.write(slave_address_acc, intr_source_address, 1);
//    i2cm.read(slave_address_acc, interrupt_source, 1);
//    
//    char_to_int(interrupt_source[0]);   // Coverts intr_source(char) to int & stores in intr_source_d
//    
//    pcm.printf("INT Source = ");
//    print_data_bits((interrupt_source_duplicate));
//
////--------------------------------------------------------------------------------------------------------
//        
//        /* VERIFY WHETHER THE INTERRUPT IS BECAUSE OF ACTIVITY */
//
//    //if((((int)intr_source) & 0x10) == 0x10)  
//    if(interrupt_source_duplicate & 0x10)
//    {
//        /* THE FOLLOWING BLOCK IS USED JUST FOR VERIFICATION PURPOSE AND ARE NOT MANDATORY */        
///*        
//        pcm.printf("ENTERED ACTIVITY CONDITION\r\n\r\n");
//        for(count = 0; count < 10; count++)
//        {
//            led = !led;
//            wait(0.05);   
//        }
//*/       
//        fetch_vehicle_speed();
//        previous_speed = vehicle_speed;
//        wait(5);
//        fetch_vehicle_speed();
//        current_speed = vehicle_speed;
//        
//        //if((current_speed > previous_speed) && (current_speed > speed_threshold))   // Decision making regarding vehicle's current state
//        if(current_speed == 79)
//        {
//            i2cm.write(slave_address_acc, activity_interrupt_disable_command, 2); // Disables Activity interrupt & enables Inactivity interrupt
//            pcm.printf("\r\n>>> VEHICLE HAS STARTED FROM STOP <<<");
//        }
//    }
//
////--------------------------------------------------------------------------------------------------------
//    
//      /* VERIFY WHETHER THE INTERRUPT IS BECAUSE OF INACTIVITY */
//
//    //if((((int)intr_source) & 0x08) == 0x08) // Verify whether it is inactivity interrupt
//    if(interrupt_source_duplicate & 0x08)
//    {
//        /* THE FOLLOWING BLOCK IS USED JUST FOR VERIFICATION PURPOSE AND ARE NOT MANDATORY */
///*
//        pcm.printf("ENTERED INACTIVITY CONDITION \r\n\r\n");
//        for(count = 0; count < 10; count++)
//        {
//            led = !led;
//            wait(0.2);
//        }  
//*/
//        fetch_vehicle_speed();
//        
//        if(vehicle_speed == 0)  // Decision making regarding vehicle's current state
//        {
//            i2cm.write(slave_address_acc, inactivity_interrupt_disable_command, 2);  // Disables Inactivity interrupt & enables Activity interrupt
//            pcm.printf("\r\n>>> VEHICLE HAS STOPPED FROM START <<<");
//        }     
//    }
//}


//*********************************************************************************************************

int main(void)
{
    //OBD_UARTm.attach(&OBD_onDataRx);
    //activity_inactivity.rise(interrupt_activity_inactivity); // Attach the address of interrupt_activity_inactivity function to rising edge
    //double_tap.rise(interrupt_sudden_jerk);
    
    pcm.baud(9600);
    OBD_UARTm.baud(9600);
    
    
    pcm.printf("\r\n\r\n\t\t>>>>>------>> OBD - ACCELEROMETER INTERFACE <<------<<<<<\r\n\r\n");
    
    initialize_obd();                   // OBD- scan tool initialization would be done here
    
    fetch_battery_voltage();            // OBD - section
    
    fetch_vin_number();
    
    fetch_vehicle_speed();
    
    fetch_engine_rpm();
    
    //rpm_padding_for_comm_test();
    
    
    check_for_MIL();
    
    check_for_dtc();
    
    
    
    
    
    //if(no_of_stored_dtc > 0)
        //check_for_dtc();
    //check_for_dtc();
    
    
    //initialize_accelerometer();         // All Accerometer configurations will be done here
    
    //while(1);                           // Wait forever, let the ISR do the rest
    
 
    return 0;
    
}

//*********************************************************************************************************