
/*
_____________________________________________________________________________________________________

>>> ACTIVITY & INACTIVITY Interrupts to be configured on INT1 pin
>>> CLICK & DOUBLE CLICK Interrupt to be configured on INT2 pin

NOTE :
-----
Leave the SA0 pin as it is and fix the slave address 32h
__________29/7/17
now via interrupt we can read SRC

_____________________________________________________________________________________________________

LAST UPDATED : 15-JUN-2017 (WEDNESDAY)

____________________

Author : >> BALA <<
____________________
_____________________________________________________________________________________________________

*/

/*
*****************************************************************************************************
REFRENCES :
----------
>>> SLAVE ADDRESS : 1001 A2 A1 A0 R/W   : Page : 7 (Datasheet)
>>> TEMPERATURE OVERSHOOT SHUTDOWN REG CONFIGURATION : Page : 10 (Datasheet)

*****************************************************************************************************
*/


#include "mbed.h"
#include "main.h"
#include "OBD.h"
#include "ACCELEROMETER.h"



InterruptIn change(PC_6);  // INT1
InterruptIn jerk(PB_15);   //INT2
DigitalOut  ACC_LED(PC_10);
I2C i2c(PB_14, PB_13); 

#define     acc_address             0x32       
int TIMING_M;
float speed_m=1;
Serial pc(PC_0, NC,115200);
char JERK_FLAG=0,MOVEMENT_FLAG=0,MOTION=0,START_TO_MOVING=0,MOVING_TO_STOP=0,PRE_MOVING=0,MOTION_FIRST_STEP=0;
float TIMING=0,FIRST_TIME=0,CURRENT_TIME=0;


void movement_inertia()
{ 
pc.printf("\nmvmnt");
    MOVEMENT_FLAG=1;
   if(fetch_vehicle_speed()>speed_m) //after interrupt comes and speed is there 
    {
        MOTION=1;
        MOTION_FIRST_STEP=1;         //local flag for main
       
    }
//    else if(MOVING_FLAG)
//    {
//         pc.printf("MOVING_TO_STOP");
//         ACC_LED=0;
//         MOVING_FLAG=0;
//    }
    else
    {
        MOVING_TO_STOP=0;
        START_TO_MOVING=0;        
        ACC_LED=0;
    }
}

//____________________________________________________________________________________________________

void sudden_jerk()
{
   pc.printf("\njerk");
   JERK_FLAG=1;             //now nowere it is clearing once it is set
}
//____________________________________________________________________________________________________
int main()
{
    change.rise(&movement_inertia);
    jerk.rise(&sudden_jerk);  
    initialize_obd();
    initialise_configure_accelerometer();  
   
 
        while(1)
        {
            if(MOTION_FIRST_STEP) //if movement interrupt comes 
            {
                MOTION_FIRST_STEP=0;
                process_accelerometer();
            }
            if((PRE_MOVING)&&(fetch_vehicle_speed()<1))//for ensuring stop if there is no movement interrupt during sudden stop
            {   
                stopped();
            }
//////////////////////////////////////////////////////////
//if in motion no interrupt comes it will ckeck after 2s// 
//            if(TIMER_RUNNING)
//            {
//                CURRENT_TIME=t.read();
//                pc.printf("\nTIMER_RUNNING");
//                if((CURRENT_TIME-FIRST_TIME)>2)
//                {
//                    process_accelerometer();
//                    TIMER_RUNNING=0;
//                    FIRST=1;
//                }
//            }
////////////////////////////////////////////////////////
            
       }
  return 0;
}
 
//____________________________________________________________________________________________________