


/*
______________________________________________________________________________________________________________________

//                                  <<<<<<<<< OBD LIBRARIES >>>>>>>>>

CHIP : STN1110 / ELM327
-----

NOTE :
-----
THESE CODE BLOCKS ARE TESTED IN REAL TIME BY COMMUNICATING DIRECTLY WITH CAR OBD PORT
THERE ARE SOME UNTESTED PORTIONS IN THE CAR
>>> VIN NUMBER
>>> DTC
VIN NUMBER PID NOT SUPPORTED IN THE CAR TESTED
THE CAR DOESN'T HAVE ANY DTC AND THIS IS ALSO LEFT UNTESTED

>>> THIS PARTICULAR SOURCE CODE IS COMPILED AND FOUND WITH ZERO ERRORS 
>>> DATE : 29-MAR-2017
>>> TIME : 1.00 PM

>>> THIS PARTICULAR SOURCE CODE HAS BEEN TESTED SUCCESSFULLY
>>> DATE : 10-APR-2017
>>> TIME : 7:00 PM

___________________

Author : >> BALA <<
___________________

______________________________________________________________________________________________________________________

*/

#include "mbed.h"
#include "OBD.h"
#include "ACCELEROMETER.h"
//#include "main.h"
//#include "Common_Defs.h"
//#include "Lora.h"


RawSerial OBD_UART(PA_0, PA_1);
Serial DEBUG_UART(USBTX, USBRX);

char pass                       =   0;
char reception_complete         =   0;
AnalogIn   ain(PA_7);

/*
__________________________________________________________________________________________________

     THE FOLLWOING ARE THE OBD COMMAND SET FOR THE STN1110 / ELM327 OBD - UART INTERPRETER
__________________________________________________________________________________________________

*/


char obd_reset_cmd[]            =   {"ATZ\r"};
char battery_voltage_cmd[]      =   "ATRV\r";
char protocol_auto_detect_cmd[] =   "ATSP0\r";
char read_CAN_protocol_cmd[]    =   "ATDPN\r";
char allow_long_cmd[]           =   "ATAL\r";
char engine_rpm_cmd[]           =   "010C\r";
char vehicle_speed_cmd[]        =   "010D\r";
char vin_number_cmd[]           =   "0902 5\r";
char check_dtc_cmd[]            =   "03\r";
char check_mil_cmd[]            =   "0101\r";


/*
__________________________________________________________________________________________________

     THE FOLLOWING ARE GLOBAL VARIABLES WHICH CAN BE ACCESSED FOR FURTHER DATA PROCESSING
__________________________________________________________________________________________________

*/

float   car_battery_voltage;
long    rpm;
float   speed1,speed2;
long    vehicle_speed;
char    vin_number[17];
char    mil;
char    no_of_stored_dtc;

//_________________________________________________________________________________________________

// THE FOLLWOING VARIABLES ARE GLOBAL BUT ARE USED ONLY FOR IN-LIBRARY PROCESSING

char OBD_UART_RX_Buffer[100];
char OBD_RxBuffer_End_Pos;
char OBD_UART_RX_Size = 50;

//_________________________________________________________________________________________________



//*********************************************************************************************************************************************************************************

// FUNCTION CALLED BY PARENT FUNCTION
// THE FOLLOWING CODE BLOCK IS USED TO VERIFY THE RECEIVED DATA

void received_data_verification(char *rcv_data_pointer, char *ref_data_pointer, char num)
{
    char dummy_data[num], count;
    for(count = 0; count < num; count++)
    {
        //OBD_UART.putc(*rcv_data_pointer);
        if(*rcv_data_pointer++ == *ref_data_pointer++)
            pass = 1;
        else   
        {
            pass = 0;
            return;
        }
    } 
}

//*********************************************************************************************************************************************************************************

void rpm_padding_for_comm_test()
{

    char count;
    char virtual_engine_rpm[] = "010C\r41 0C 0E A2 \r\r>";
    char engine_rpm[4];     // Vehicle speed data is returned by a 4 byte value
    char *rpm_data_pointer;
    char internal_count = 0;
    char padded_rpm_17_bytes[17];
    OBD_UART.printf("RPM Data\r\n");
    
    for(count = 0; count < strlen(engine_rpm_cmd); count ++)
        OBD_UART.putc(engine_rpm_cmd[count]);
    wait(1);
    while(!(OBD_UART_RX_Buffer[OBD_RxBuffer_End_Pos-1] == '>'));        // Waits here until the reception complete flag has been enabled
    
    received_data_verification(OBD_UART_RX_Buffer, engine_rpm_cmd, (strlen(engine_rpm_cmd)-1));
    for(count = 0; count < 5; count++)
        OBD_UART.printf("0x%2x ",OBD_UART_RX_Buffer[count]);
        process_engine_rpm(OBD_UART_RX_Buffer);
    DEBUG_UART.printf("RPM Received\r\n");
    rpm_data_pointer = virtual_engine_rpm;
    rpm_data_pointer += 11;
    
    for(count = 0; count < 5; count++)
    {
        if(*rpm_data_pointer == ' ') {        // Negate the spaces added in between
            rpm_data_pointer++;
            continue; }
        else {
            engine_rpm[internal_count] = *rpm_data_pointer++;
            internal_count++; }
    }
    
    //OBD_UART.printf("\r\n%s", engine_rpm);
    //OBD_UART.printf("\r\nRPMMMMMM = ");
    for(count = 0; count < strlen(engine_rpm); count++)
        OBD_UART.putc(engine_rpm[count]);
    
    for(count = 0; count < 4; count++){
        DEBUG_UART.printf("\r\nPadded = ");
        for(internal_count = 0; internal_count < strlen(padded_rpm_17_bytes); internal_count++)
            OBD_UART.putc(padded_rpm_17_bytes[internal_count]);
        //OBD_UART.printf("\r\nPadded RPM = %s", padded_rpm_17_bytes);
        strcat(padded_rpm_17_bytes, engine_rpm); 
    }
        
    strcat(padded_rpm_17_bytes, "0");
    DEBUG_UART.printf("\r\n\r\n PADDED RPM = %s",padded_rpm_17_bytes);
    DEBUG_UART.putc('\r');
    for(count = 0; count < strlen(padded_rpm_17_bytes); count++){
        DEBUG_UART.putc(padded_rpm_17_bytes[count]);
        //Misc_Packet_Data.VIN[count] = padded_rpm_17_bytes[count];
    }
}
//*********************************************************************************************************************************************************************************
// FUNCTION CALLED FROM PARENT FUNCTION
// THE FOLLOWING CODE BLOCK IS USED TO PROCESS THE DTC DATA FETCHED FROM THE OBD PORT OF THE CAR

   
/*
|______________________________________________________________________________________________|

FORMULA:
-------
t = total bytes of returned data
n = no of dtc

t = 2n + (n -1) , where (n-1) indicates the added spaces between two bytes
t = 3n -1

Therefore, n = (t + 1) / 3

|______________________________________________________________________________________________|

*/ 

void process_dtc_data(char *dtc_data_pointer)   // Incomplete Code block
{     
    // char virtual_dtc_buffer[] = "03\r43 00 85\r\r>";
    char count;
    char internal_count;
    char dtc_data[(4*(no_of_stored_dtc))];
    char dtc_codes[(6*(no_of_stored_dtc))];            // Refer below 
    
    /*
    _____________________________________________
    
    NOTE :
    -----
    DTC CODE ARRAY SPACE ALLOCATION
    
    ONE DTC CONTAINS 5 CHARACTERS
    '\r' IS USED AS SEPARATOR (END BYTE)
    TOTALLY TO STORE ONE DTC 6 BYTES ARE USED
    _____________________________________________
    
    */
    
    dtc_data_pointer += 6;

    // THE FOLLOWING LINES OF CODE COPIES THE DTC DATA IN A VARIABLE AND ELIMINATES THE SPACE CHARACTER
    
    for(count = 0; count < ((5*no_of_stored_dtc) + (no_of_stored_dtc - 1)); count++)
    { 
        if((*dtc_data_pointer) == '\r')
            break;
            
        if((*dtc_data_pointer) == ' ')
        {
            dtc_data_pointer++;
            continue;
        }
        
        else
        {
            if((*dtc_data_pointer - 0x30) <= 9)
                dtc_data[internal_count] = (*dtc_data_pointer) - 0x30;
            else
            {
                dtc_data[internal_count] = (*dtc_data_pointer) - 0x37;
            }
            internal_count++;              
            dtc_data_pointer++;
        }
    }   
       
    internal_count = 0;

    char dtc_data_merged[((4*(no_of_stored_dtc)) / 2)];
      
    for(count = 0; count < ((4*no_of_stored_dtc)); count += 2)
    {
        dtc_data_merged[internal_count] = ((dtc_data[count] << 4) | dtc_data[count + 1]);
        internal_count++;
    }
    
    internal_count = 0;
        
    for(count = 0; count < (2*(no_of_stored_dtc)); count += 2)
    {
        switch(dtc_data_merged[count] & 0b11000000)
        {
            case 0:
                dtc_codes[internal_count] = 'P';
                break;
            case 1:
                dtc_codes[internal_count] = 'C';
                break;
            case 2:
                dtc_codes[internal_count] = 'B';
                break;
            case 3:
                dtc_codes[internal_count] = 'U';
                break;
        }
        
        internal_count++;
            
        dtc_codes[internal_count] = ((dtc_data_merged[count] & 0b00110000) + 0x30); 
        internal_count++;
        dtc_codes[internal_count] = ((dtc_data_merged[count] & 0b00001111) + 0x30);
        internal_count++;
        dtc_codes[internal_count] = (((dtc_data_merged[count + 1] & 0b11110000) >> 4) + 0x30);
        internal_count++;
        dtc_codes[internal_count] = ((dtc_data_merged[count + 1] & 0b00001111) + 0x30);
        internal_count++;
        dtc_codes[internal_count] = '\r';
            
        DEBUG_UART.printf("\r\nDTC CODES :");
        DEBUG_UART.printf("\r\n%s", dtc_codes);
    }
}

//*********************************************************************************************************************************************************************************

// FUNCTION CALLED FROM PARENT FUNCTION
// THE FOLLOWING CODE BLOCK IS USED TO PROCESS MIL DATA FETCHED FROM THE OBD PORT OF THE CAR

void process_mil_data(char *mil_data_pointer)
{
    DEBUG_UART.printf("\r\n\r\nENTERED PROCESS MIL DATA FUNCTION");
    char mil_data[2], mil_data_converted;
    char count;
    
    // char virtual_mil_buffer = "0101\r41 01 00 04 60 00 \r\r";
    mil_data_pointer += 11;
    
    for(count = 0; count < 2; count++)
    {
        mil_data[count] = *mil_data_pointer++;
    }
    
    // THE FOLLOWING LINES OF CODE CONVERTS THE ASCII DATA TO THE HEX DATA  
    
    if((((mil_data[0] - 0x30) & 0x7F) <= 9) && (((mil_data[1] - 0x30) & 0x7F) <= 9))
        mil_data_converted = (((mil_data[0] - 0x30)<<4) + (mil_data[1] - 0x30)); // Converting the ASCII data to the Hex data
    
    else if((((mil_data[0] - 0x30) & 0x7F) <= 9))
        mil_data_converted = (((mil_data[0] - 0x30)<<4) + (mil_data[1] - 0x37)); // Converting the ASCII data to the Hex data
    
    else if((((mil_data[1] - 0x30) & 0x7F) <= 9))
        mil_data_converted = (((mil_data[0] - 0x37)<<4) + (mil_data[1] - 0x30)); // Converting the ASCII data to the Hex data
        
    else
            mil_data_converted = (((mil_data[0] - 0x37)<<4) + (mil_data[1] - 0x37)); // Converting the ASCII data to the Hex data
    
    // The following code lines checks for the number of Mal function indicator lamp enabled by tghe CAN ECU
    
    if(mil_data_converted & 0x80) // Checks for the MSB bit enabled or not which inc=dicates that the MIL is On or NOT
    {
        mil = 1;                // Setting the MIL flag
        DEBUG_UART.printf("\r\nMIL (MALFUNCTION INDICATOR LAMP) IS ON");
        no_of_stored_dtc = (mil_data_converted & 0b01111111);
        DEBUG_UART.printf("\r\n NO OF STORED DYNAMIC TROUBLE CODE = %d", no_of_stored_dtc);
    }
    else {
        mil = 0;                // Clearing the MIL flag
        DEBUG_UART.printf("\r\nMIL (MALFUNCTION INDICATOR LAMP) IS OFF"); }
}

//*********************************************************************************************************************************************************************************

// FUNCTION CALLED FROM PARENT FUNCTION
// THE FOLLWOING CODE BLOCK IS USED TO PROCESS THE VEHICLE SPEED DATA FETCHED FROM THE OBD PORT OF THE CAR

float process_vehicle_speed(char *vehicle_speed_pointer)
{
    char vehicle_speed_data[2];     // Vehicle speed data is returned by a 2 byte value
    char *strtol_pointer;
    char count;
    //"010D\r41 0D 4F\r\r>"
    vehicle_speed_pointer += 11;
    //for(count = 0; count < 2; count++)
    {
        //vehicle_speed_data[count] = *vehicle_speed_pointer++;
       // vehicle_speed_data[count] = 5;
    }
    
    vehicle_speed =  strtol(vehicle_speed_data, &strtol_pointer, 16);
    //speed1=0;
    speed1=ain.read()*100.0f;///*************************adc value for tesing need to load actual speed********************************************
    
    DEBUG_UART.printf("\r\nVEHICLE SPEED = %ld", vehicle_speed);
    return(speed1);
}

//*********************************************************************************************************************************************************************************

// FUNCTION CALLED BY PARENT FUCTION
// THE FOLLWOING CODE BLOCK IS USED TO PROCESS THE ENGINE RPM FETCHED FROM THE OBD PORT OF THE CAR

unsigned int process_engine_rpm(char *rpm_data_pointer)
{
    //char virtual_engine_rpm[] = "010C\r41 0C 00 00 \r\r>";
    char engine_rpm[4];     // Vehicle speed data is returned by a 4 byte value
    char *strtol_pointer;
    char count;
    char internal_count = 0;
    
    rpm_data_pointer += 11;
    
    for(count = 0; count < 5; count++)
    {
        if(*rpm_data_pointer == ' ') {        // Negate the spaces added in between
            rpm_data_pointer++;
            continue; }
        else {
            engine_rpm[internal_count] = *rpm_data_pointer++;
            internal_count++; }
    }
    
    DEBUG_UART.printf("\r\n%s", engine_rpm);
    
    rpm =  ((strtol(engine_rpm, &strtol_pointer, 16)) / 4);
    
    DEBUG_UART.printf("\r\nENGINE RPM = %ld", rpm);
    return(rpm);
}

//*********************************************************************************************************************************************************************************

// FUNCTION CALLED BY PARENT FUNCTION
// THE FOLLOWING CODE BLOCK IS USED TO PROCESS THE BATTERY VOLTAGE FETCHED FROM THE OBD PORT OF THE CAR

void process_battery_voltage(char *battery_voltage_pointer)
{
    char battery_voltage_data[4];   // One decimal point precision ( For ex : 12.5 )
    char count;
    battery_voltage_pointer += 5;   // ATRV<CR> counts to 5
    for(count = 0; count < 4; count++)
    {
        battery_voltage_data[count] = *battery_voltage_pointer++;
    }
    car_battery_voltage = atof(battery_voltage_data);   // Converts the Battery Volatge from String to Float data type
    //Misc_Packet_Data.Car_Battery_Voltage = (car_battery_voltage * 100);
    DEBUG_UART.printf("\r\nCAR BATTERY VOLTAGE = %f",car_battery_voltage);
}

 
//*********************************************************************************************************************************************************************************

/*
_______________________________________________________________________________________________________________________

NOTE :
-----
THE FOLLOWING CODE O DETERMINE THE DIAGNOSTIC TROUBLE CODE (DTC) IS BASED ON THE INTERPRETATION GIVEN IN WIKIPEDIA
FOR THE  ISO 15765-2 PROTOCOL
DIFFERENT INTERPRETATION METHODOLOGY IS GIVEN IN THE ELM327 DATASHEET FOR SAE PROTOCOL
SO THESE THINGS ARE SUBJECTED TO MODIFICATION AND HAVE NOT BEEN CONFIRMED WITH THE REAL TIME DATA 
_______________________________________________________________________________________________________________________

*/

// FUNCTION WILL BE CALLED ON REQUEST
// THE FOLLOWING CODE BLOCK WILL FETCH THE DTC DATA FROM THE OBD PORT OF THE CAR AND SENDS THE SAME FOR PROCESSING

void check_for_dtc()
{
    char virtual_dtc_buffer[] = "03\r43 00 85\r\r>";
    
    OBD_UART.printf(check_dtc_cmd);
    wait(1);
    while(!(OBD_UART_RX_Buffer[OBD_RxBuffer_End_Pos-1] == '>'));        // Waits here until the reception complete flag has been enabled
    DEBUG_UART.printf("Reception Complete\r\n");
    received_data_verification(OBD_UART_RX_Buffer, check_dtc_cmd, (strlen(check_dtc_cmd)-1));
    
    //process_dtc_data(virtual_dtc_buffer);
    
    
    if(pass == 1) {
        process_dtc_data(OBD_UART_RX_Buffer);
        DEBUG_UART.printf("\r\VEHICLE DIAGNOSTIC TROUBLE CODE RECEIVED SUCCESSFULLY \r\n\r\n"); }
    else
        DEBUG_UART.printf("\r\nVEHICLE DIAGNOSTIC TROUBLE CODE DATA RECEPTION FAILED\r\n\r\n");
    reception_complete = 0;     // Disabling the reception complete flag
    OBD_RxBuffer_End_Pos = 0;   // Rx Buffer will be overwritten in the next data reception

}

//*********************************************************************************************************************************************************************************

// FUNCTION WILL BE CALLED ON REQUEST
// THE FOLLOWING CODE BLOCK WILL FETCH THE MIL DATA FROM THE OBD PORT OF THE CAR

void check_for_MIL()
{
    
    DEBUG_UART.printf("\r\n\r\nENTERED CHECK FOR MIL FUNCTION");
    char count;
    char virtual_mil_buffer[] = "0101\r41 01 82 04 60 00 \r\r";
    
    /*
    OBD_UART.printf(check_mil_cmd);
    
    for(count = 0; count < strlen(check_mil_cmd); count++)
        OBD_UART.putc(check_mil_cmd[count]);
    wait(1);
    while(!(OBD_UART_RX_Buffer[OBD_RxBuffer_End_Pos-1] == '>'));        // Waits here until the reception complete flag has been enabled
    OBD_UART.printf("Reception Complete\r\n");
    received_data_verification(OBD_UART_RX_Buffer, check_mil_cmd, (strlen(check_mil_cmd)-1));
    */
    
    process_mil_data(virtual_mil_buffer);
    
    
    if(pass == 1) {
        process_mil_data(OBD_UART_RX_Buffer);
        DEBUG_UART.printf("\r\nVEHICLE MIL DATA RECEIVED SUCCESSFULLY \r\n\r\n");}
    else
        DEBUG_UART.printf("\r\nVEHICLE MIL DATA RECEPTION FAILED\r\n\r\n");
    reception_complete = 0;     // Disabling the reception complete flag
    OBD_RxBuffer_End_Pos = 0;   // Rx Buffer will be overwritten in the next data reception
    
}


//*********************************************************************************************************************************************************************************

char fetch_vin_number()
{
    char count;
    //char virtual_rx_vin_buffer[] = "3147 43\r314b \r58: 43 38 01 54 4D 42 \r1: 46 4B 4A 35 4A 32 43 \r2: 47 30 31 34 37 33 33 \r\r>"; 
    char virtual_rx_vin_buffer[] = "0902 5\r014 \r0: 49 02 01 54 4D 42 \r1: 40 41 42 35 4A 32 43 \r2: 47 30 31 34 37 33 33 \r\r>"; 
    //char virtual_rx_vin_buffer[] = "0902 5\r014 \r0: 49 02 01 54 4D 42 \r1: 46 4B 4A 35 4A 32 43 \r2: 47 30 31 34 37 33 33 \r\r>"; 
    //char virtual_rx_vin_buffer[] = "0902 5\r014 \r0: 49 02 01 54 4D 42 \r1: 46 4B 4A 35 4A 32 43 \r2: 47 30 31 34 37 33 33 \r\r>"; 
//    1GC1KXC82BF134775->31 47 43 31 4b 58 43 38 32 42 46 31 33 34 37 37 35
//    1G1PC5SB0E7341780->31 47 31 50 43 35 53 42 30 45 37 33 34 31 37 38 30
//    1G1RD6S56GU125328->31 47 31 52 44 36 53 35 36 47 55 31 32 35 33 32 38
    char vin_number_cmd1[]           =   "0902 5\r";
    OBD_UART.printf("VIN Reception Started24432\r\n");
    
    
    char vin_buffer[100];
    char *vin_data_pointer;
    char internal_counter = 0;
    char small_buffer[2];
    long ascii_converted_data;
    char *vin_conv_pointer;
    char vin_number[17];
    wait(1);
    OBD_RxBuffer_End_Pos = 0;
    //for(count = 0; count < strlen(vin_number_cmd1); count++)
      //  OBD_UART.putc(vin_number_cmd[count]);
    OBD_UART.putc(0x30);
    OBD_UART.putc(0x39);
    OBD_UART.putc(0x30);
    OBD_UART.putc(0x32);
    OBD_UART.putc(0x20);
    OBD_UART.putc(0x35);
    OBD_UART.putc(0x0D);
    
    OBD_UART.printf("VIN Reception Started   %d\r\n",strlen(virtual_rx_vin_buffer));
    
    vin_data_pointer = virtual_rx_vin_buffer;
    vin_data_pointer += 23;
    while(!(OBD_UART_RX_Buffer[OBD_RxBuffer_End_Pos-1] == '>'))        // Waits here until the reception complete flag has been enabled
    {
        if(OBD_RxBuffer_End_Pos >=6)
            break;
    }
    for(count = 0; count < 86; count++)
       OBD_UART.putc(OBD_UART_RX_Buffer[count]);
    //OBD_UART.printf("VIN Reception Complete\r\n");
    //return(1);
    vin_data_pointer = OBD_UART_RX_Buffer;
    vin_data_pointer += 23;
    
    int length;
    for(count = 0; count < (strlen(virtual_rx_vin_buffer) - 1); count++)
    {
        if((*vin_data_pointer == '\r') | (*vin_data_pointer == ' ') | (*vin_data_pointer == '>'))
        {
            vin_data_pointer++;
            continue;
        }
        else if(*(vin_data_pointer + 1) == ':')
        {
            vin_data_pointer += 2;
            continue;
        }
        else
        {
            //printf("\r\ncount2 = %d", count); 
            vin_buffer[internal_counter] = *vin_data_pointer;
            internal_counter++;
        }
        vin_data_pointer++;
    }
    
    length = strlen(vin_buffer);
    DEBUG_UART.printf("\r\n VIN BUFFER LENGTH = %d", length);
    
    DEBUG_UART.printf("\r\n VIN NUMBER : %s", vin_buffer);
    
    internal_counter = 0;
    
    for(count = 0; count < strlen(vin_buffer); count+=2)
    {
        small_buffer[0] = vin_buffer[count];
        small_buffer[1] = vin_buffer[count+1];
        ascii_converted_data =  strtol(small_buffer, &vin_conv_pointer, 16);
        vin_number[internal_counter] = ascii_converted_data;
        //Misc_Packet_Data.VIN[internal_counter] = ascii_converted_data;
        internal_counter++;
    }
    DEBUG_UART.printf("\r\n\r\nVEHICLE CHASSIS NUMBER : %s", vin_number);

}

//*********************************************************************************************************************************************************************************


// FUNCTION WILL BE CALLED ON REQUEST
// THE FOLLOWING CODE BLOCK FETCHES THE VEHICLE SPEED DATA FROM THE OBD PORT OF THE CAR AND SENDS THE SAME FOR PROCESSING

float fetch_vehicle_speed()
{
    char virtual_rx_speed_buffer[] = "010D\r41 0D 4F \r\r>";     
    char count;
    //OBD_UART.printf(vehicle_speed_cmd);
    
    //for(count = 0; count < strlen(vehicle_speed_cmd); count++)
       // OBD_UART.putc(vehicle_speed_cmd[count]);
    //wait(1);
   // while(!(OBD_UART_RX_Buffer[OBD_RxBuffer_End_Pos-1] == '>'));        // Waits here until the reception complete flag has been enabled
   // DEBUG_UART.printf("Reception Complete\r\n");
    //received_data_verification(OBD_UART_RX_Buffer, vehicle_speed_cmd, (strlen(vehicle_speed_cmd)-1));
    
    //
    speed2=process_vehicle_speed(virtual_rx_speed_buffer);
    
    if(pass == 1) {
       speed2= process_vehicle_speed(OBD_UART_RX_Buffer);
        DEBUG_UART.printf("\r\nVEHICLE SPEED DATA RECEIVED SUCCESSFULLY \r\n\r\n"); }
    else
        DEBUG_UART.printf("\r\nVEHICLE SPEED DATA RECEPTION FAILED\r\n\r\n");
    reception_complete = 0;     // Disabling the reception complete flag
    OBD_RxBuffer_End_Pos = 0;   // Rx Buffer will be overwritten in the next data reception
    return(speed2);
    
}  

//*********************************************************************************************************************************************************************************

// FUNCITON WILL BE CALLED  ON REQUEST
// THE FOLLOWING CODE BLOCK FETCHES THE RPM DATA FROM THE OBD PORT OF THE CAR AND WILL SEND THE SAME FOR PROCESSING

unsigned int fetch_engine_rpm()
{
    char count;
    unsigned int RPM;
    OBD_RxBuffer_End_Pos = 0;
   
    char virtual_engine_rpm[] = "010C\r41 0C 0E A2 \r\r>";
    DEBUG_UART.printf("rpm Reception Start\r\n");
//    for(count = 0; count < strlen(engine_rpm_cmd); count ++)
//        OBD_UART.putc(engine_rpm_cmd[count]);
//    wait(1);
//    while(!(OBD_UART_RX_Buffer[OBD_RxBuffer_End_Pos-1] == '>'));        // Waits here until the reception complete flag has been enabled
//    OBD_UART.printf("Reception Complete\r\n");
//    received_data_verification(OBD_UART_RX_Buffer, engine_rpm_cmd, (strlen(engine_rpm_cmd)-1));
//    
    
    //process_engine_rpm(virtual_engine_rpm);
    if(pass == 1) {
        RPM = process_engine_rpm(virtual_engine_rpm);
        DEBUG_UART.printf("\r\nVEHICLE SPEED DATA RECEIVED SUCCESSFULLY \r\n\r\n"); }
    else
        DEBUG_UART.printf("\r\nVEHICLE SPEED DATA RECEPTION FAILED\r\n\r\n");
    reception_complete = 0;     // Disabling the reception complete flag
    OBD_RxBuffer_End_Pos = 0;   // Rx Buffer will be overwritten in the next data reception
    return(RPM);
}
 
//*********************************************************************************************************************************************************************************

// FUNCTION WILL BE CALLED ON REQUEST
// THE FOLLOWING CODE BLOCK FETCHED THE BATTERY VOLTAGE DATA FROM THE OBD PORT AND PASSES THE SAME DATA FOR PROCESSING

void fetch_battery_voltage()
{
    char count;
    //OBD_UART.printf(battery_voltage_cmd);
    OBD_UART.printf("Battery Voltage\r\n");
    for(count = 0; count < strlen(battery_voltage_cmd); count++){
        OBD_UART.putc(battery_voltage_cmd[count]);
        OBD_UART.printf("0x%2x ",battery_voltage_cmd[count]);
    }
    wait(1);
    
    while(!(OBD_UART_RX_Buffer[OBD_RxBuffer_End_Pos-1] == '>'));        // Waits here until the reception complete flag has been enabled
    DEBUG_UART.printf("Reception Complete\r\n");
    received_data_verification(OBD_UART_RX_Buffer, battery_voltage_cmd, (strlen(battery_voltage_cmd)-1));
    

    if(pass == 1) {
        DEBUG_UART.printf("\r\nOBD READ BATTERY VOLTAGE SUCCESSFUL");
        process_battery_voltage(OBD_UART_RX_Buffer); }
    else
        DEBUG_UART.printf("\r\nOBD READ BATTERY VOLTAGE FAILED");
    reception_complete = 0;     // Disabling the reception complete flag
    OBD_RxBuffer_End_Pos = 0;   // Rx Buffer will be overwritten in the next data reception
}
  
    
//*********************************************************************************************************************************************************************************

// FUNCTION WILL BE CALLED ON REQUEST
// TYHE FOLLOWING CODE BLOXK INITIALIZES THE OBD INTERFACE
// IT IS MANDATORY TO CALL THIS FUNCTION BEFORE USING ANY OF THE OTHER FUNCTIONS INCLUDED IN THIS PARTICULAR LIBRARY

void initialize_obd()
{
    char count;
    char data[3];
    char *data_pointer;  

    data_pointer = data;
    
    //OBD_UART.baud(9600);
//    OBD_UART.attach(&OBD_onDataRx);
    
    DEBUG_UART.printf("Reception Started\r\n");
    
 //--------------------------------------------------------------------------------------------------------------------------     
    //for(Misc_Count=0; Misc_Count < 5; Misc_Count++) {
//        OBD_UART.putc(battery_voltage_cmd[Misc_Count]);
//    }
    OBD_UART.printf(obd_reset_cmd);

    wait(1);
    
  //~sbn~   while(!(OBD_UART_RX_Buffer[OBD_RxBuffer_End_Pos-1] == '>'));        // Waits here until the reception complete flag has been enabled
    DEBUG_UART.printf("Reception Complete\r\n");
    received_data_verification(OBD_UART_RX_Buffer, obd_reset_cmd, (strlen(obd_reset_cmd)-1));

    if(pass == 1)
        DEBUG_UART.printf("\r\nOBD RESET SUCCESSFUL \r\n\r\n");
    else
        DEBUG_UART.printf("\r\nOBD RESET FAILED \r\n\r\n");
   // fetch_battery_voltage();        
    reception_complete = 0;     // Disabling the reception complete flag
    OBD_RxBuffer_End_Pos = 0;   // Rx Buffer will be overwritten in the next data reception
    
//--------------------------------------------------------------------------------------------------------------------------  

    //OBD_UART.printf(allow_long_cmd);
    for(count = 0; count < strlen(allow_long_cmd); count++)
        OBD_UART.putc(allow_long_cmd[count]);
    wait(1);
//~sbn~  while(!(OBD_UART_RX_Buffer[OBD_RxBuffer_End_Pos-1] == '>'));        // Waits here until the reception complete flag has been enabled
    DEBUG_UART.printf("Reception Complete\r\n");
    received_data_verification(OBD_UART_RX_Buffer, allow_long_cmd, (strlen(allow_long_cmd)-1));

    if(pass == 1)
        DEBUG_UART.printf("\r\nLONG DATA RECEPTION ENABLED SUCCESSFULLY \r\n\r\n");
    else
        DEBUG_UART.printf("\r\nLONG DATA RECEPTION ENABLING FAILED\r\n\r\n");
    reception_complete = 0;     // Disabling the reception complete flag
    OBD_RxBuffer_End_Pos = 0;   // Rx Buffer will be overwritten in the next data reception
    
}
 /*********************************************************************************************************************************************************************************/