#ifndef QQQCAM_H
#define QQQCAM_H

/*
Raspberry Piに接続したカメラは毎秒1回撮影を行い，画像の赤い部分の割合を"$CAM,d.ddd\r\n"のフォーマットで送信する．
このライブラリは，シリアル受信割り込みを利用して内部のパラメータを更新する．

#include "mbed.h"
#include "QQQCAM.h"

Serial pc(USBTX, USBRX, 115200);
Serial cam_serial(p28, p27, 115200);

QQQCAM cam(cam_serial);

int main()
{
    while(1) {
        pc.printf("rate:%.3f\r\n", cam.get_rate());
    }
}
*/
class QQQCAM{
private:
    Serial *_serial;
    char rx_buf[256];
    int index;
    int flag;
    float rate;
    
public:
    QQQCAM(Serial &cam);
    
private:
    void receive();

public:
    float get_rate();
};

#endif