#include "mbed.h"
#include "QQQCAM.h"

QQQCAM::QQQCAM(Serial &cam_serial)
{
    _serial = &cam_serial;
    _serial->attach(callback(this, &QQQCAM::receive), Serial::RxIrq);
}

void QQQCAM::receive()
{
    char c = _serial->getc();
    if(c == '$') {
        index = 0;
        flag = 1;
    }
    if(flag == 1) {
        rx_buf[index] = c;
        if(c == '\n') {
            rx_buf[index + 1] = '\0';
            flag = 2;
        } else {
            index++;
        }
    }
    if(flag == 2) {
        sscanf(rx_buf, "$CAM,%f", &rate);
        flag = 0;
    }
}

float QQQCAM::get_rate(){
    return rate;
}