#include "mbed.h"
#include "PololuLedStrip.h"

PololuLedStrip ledStrip1(PB_1);
PololuLedStrip ledStrip2(PB_0);
PololuLedStrip ledStrip3(PA_11);
PololuLedStrip ledStrip4(PA_7);

#define LED_COUNT 37 //LEDの数
rgb_color colors[LED_COUNT];
rgb_color colors2[LED_COUNT];
rgb_color colors3[LED_COUNT];
rgb_color colors4[LED_COUNT];

Serial Xbee(PA_9,PA_10,19200); //TX,RX,クロックレート
Serial pc(SERIAL_TX,SERIAL_RX); //pc(USBTX,USBRX)
unsigned char RX_data;

DigitalOut LED(PA_3);
AnalogIn FT(PA_4);

Ticker flipper; //タイマー

//RS-555 rpm == 3610
//rad/s  == 378.0383159819718
//ギア比は１：２だから上の2倍のはず

//フォトリフレクタ
double fot;
int h = 0;
int b = 0;
//↓LED色
int R = 1;
int G = 2;
int B = 3;
int Y = 4;
int L = 5;
int P = 6;
int W = 7;
int O = 8;

int LED_CON = 1;
int con = 0;
int FT_con = 0;

void Xbee_RX(){
    RX_data = Xbee.getc(); //Xbeeから送られてきた文字Zに代入
    pc.putc(RX_data); //値をpcに表示
}

rgb_color COLOR(float H,int n){

    float r = 0, g = 0, b = 0;
    H = 100; //光の強さ
    switch (n){
        case 1:r = H; g = 0; b = 0; break; //赤
        case 2:r = 0; g = H; b = 0; break; //緑
        case 3:r = 0; g = 0; b = H; break; //青
        case 4:r = H; g = H; b = 0; break; //黄色
        case 5:r = 0; g = H; b = H; break; //水色
        case 6:r = H; g = 0; b = H; break; //紫
        case 7:r = H; g = H; b = H; break; //白
        case 8:r = H; g = H * 0.5; b = 0; break; //オレンジ
        }
    return (rgb_color){r,g,b};
}

//タイマー処理
void LED_not(){
    for(h = 0; h < LED_COUNT; h++){
        uint8_t phase =(h << 1);
        colors[h] = COLOR(phase, 0); 
        ledStrip1.write(colors, LED_COUNT);
    }
}




int main(){
    Xbee.attach(&Xbee_RX, Serial::RxIrq); //割り込み
    pc.baud(115200); //pcクロックレート

    while(1){
//        if(RX_data == 'A'){
            
        if(FT < 0.8){
            FT_con++;
            //Xbee.printf("%f",FT);
            while(FT < 0.8){
                //Xbee.printf("%f",FT);
            }
        }
//        if(RX_data == 'A' && con == 0){
//            con = 1;
//        }
        if(con == 0){
            if(10 <= FT_con && FT_con < 20){
                for(h = 0; h < LED_COUNT; h++){
                    uint8_t phase =(h << 1);
                    colors[1] = COLOR(phase, B);
                    ledStrip1.write(colors, LED_COUNT);
                    
                }
                LED_not();
            }
       }
                
                
            
    }
}