/**
  ******************************************************************************
  * @file    stm32f334x8.h
  * @author  MCD Application Team
  * @version V2.3.0
  * @date    29-April-2015
  * @brief   CMSIS STM32F334x8 Devices Peripheral Access Layer Header File.
  *
  *          This file contains:
  *           - Data structures and the address mapping for all peripherals
  *           - Peripheral's registers declarations and bits definition
  *           - Macros to access peripherals registers hardware
  *
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; COPYRIGHT(c) 2016 STMicroelectronics</center></h2>
  *
  * Redistribution and use in source and binary forms, with or without modification,
  * are permitted provided that the following conditions are met:
  *   1. Redistributions of source code must retain the above copyright notice,
  *      this list of conditions and the following disclaimer.
  *   2. Redistributions in binary form must reproduce the above copyright notice,
  *      this list of conditions and the following disclaimer in the documentation
  *      and/or other materials provided with the distribution.
  *   3. Neither the name of STMicroelectronics nor the names of its contributors
  *      may be used to endorse or promote products derived from this software
  *      without specific prior written permission.
  *
  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
  * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
  * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  *
  ******************************************************************************
  */

/** @addtogroup CMSIS_Device
  * @{
  */

/** @addtogroup stm32f334x8
  * @{
  */

#ifndef __STM32F334x8_H
#define __STM32F334x8_H

#ifdef __cplusplus
 extern "C" {
#endif /* __cplusplus */

/** @addtogroup Configuration_section_for_CMSIS
  * @{
  */

/**
 * @brief Configuration of the Cortex-M4 Processor and Core Peripherals
 */
#define __CM4_REV                 0x0001U  /*!< Core revision r0p1                            */
#define __MPU_PRESENT             0U       /*!< STM32F334x8 devices do not provide an MPU */
#define __NVIC_PRIO_BITS          4U       /*!< STM32F334x8 devices use 4 Bits for the Priority Levels */
#define __Vendor_SysTickConfig    0U       /*!< Set to 1 if different SysTick Config is used */
#ifndef __FPU_PRESENT
#define __FPU_PRESENT             1U       /*!< STM32F334x8 devices provide an FPU */
#endif
/**
  * @}
  */
   
/** @addtogroup Peripheral_interrupt_number_definition
  * @{
  */

/**
 * @brief STM32F334x8 devices Interrupt Number Definition, according to the selected device
 *        in @ref Library_configuration_section
 */
typedef enum
{
/******  Cortex-M4 Processor Exceptions Numbers ****************************************************************/
  NonMaskableInt_IRQn         = -14,    /*!< 2 Non Maskable Interrupt                                          */
  HardFault_IRQn              = -13,    /*!< 3 Cortex-M4 Hard Fault Interrupt                                  */
  MemoryManagement_IRQn       = -12,    /*!< 4 Cortex-M4 Memory Management Interrupt                           */
  BusFault_IRQn               = -11,    /*!< 5 Cortex-M4 Bus Fault Interrupt                                   */
  UsageFault_IRQn             = -10,    /*!< 6 Cortex-M4 Usage Fault Interrupt                                 */
  SVCall_IRQn                 = -5,     /*!< 11 Cortex-M4 SV Call Interrupt                                    */
  DebugMonitor_IRQn           = -4,     /*!< 12 Cortex-M4 Debug Monitor Interrupt                              */
  PendSV_IRQn                 = -2,     /*!< 14 Cortex-M4 Pend SV Interrupt                                    */
  SysTick_IRQn                = -1,     /*!< 15 Cortex-M4 System Tick Interrupt                                */
/******  STM32 specific Interrupt Numbers **********************************************************************/
  WWDG_IRQn                   = 0,      /*!< Window WatchDog Interrupt                                         */
  PVD_IRQn                    = 1,      /*!< PVD through EXTI Line detection Interrupt                         */
  TAMP_STAMP_IRQn             = 2,      /*!< Tamper and TimeStamp interrupts through the EXTI line 19          */
  RTC_WKUP_IRQn               = 3,      /*!< RTC Wakeup interrupt through the EXTI line 20                     */
  FLASH_IRQn                  = 4,      /*!< FLASH global Interrupt                                            */
  RCC_IRQn                    = 5,      /*!< RCC global Interrupt                                              */
  EXTI0_IRQn                  = 6,      /*!< EXTI Line0 Interrupt                                              */
  EXTI1_IRQn                  = 7,      /*!< EXTI Line1 Interrupt                                              */
  EXTI2_TSC_IRQn              = 8,      /*!< EXTI Line2 Interrupt and Touch Sense Controller Interrupt         */
  EXTI3_IRQn                  = 9,      /*!< EXTI Line3 Interrupt                                              */
  EXTI4_IRQn                  = 10,     /*!< EXTI Line4 Interrupt                                              */
  DMA1_Channel1_IRQn          = 11,     /*!< DMA1 Channel 1 Interrupt                                          */
  DMA1_Channel2_IRQn          = 12,     /*!< DMA1 Channel 2 Interrupt                                          */
  DMA1_Channel3_IRQn          = 13,     /*!< DMA1 Channel 3 Interrupt                                          */
  DMA1_Channel4_IRQn          = 14,     /*!< DMA1 Channel 4 Interrupt                                          */
  DMA1_Channel5_IRQn          = 15,     /*!< DMA1 Channel 5 Interrupt                                          */
  DMA1_Channel6_IRQn          = 16,     /*!< DMA1 Channel 6 Interrupt                                          */
  DMA1_Channel7_IRQn          = 17,     /*!< DMA1 Channel 7 Interrupt                                          */
  ADC1_2_IRQn                 = 18,     /*!< ADC1 & ADC2 Interrupts                                            */
  CAN_TX_IRQn                 = 19,     /*!< CAN TX Interrupt                                                  */
  CAN_RX0_IRQn                = 20,     /*!< CAN RX0 Interrupt                                                 */
  CAN_RX1_IRQn                = 21,     /*!< CAN RX1 Interrupt                                                 */
  CAN_SCE_IRQn                = 22,     /*!< CAN SCE Interrupt                                                 */
  EXTI9_5_IRQn                = 23,     /*!< External Line[9:5] Interrupts                                     */
  TIM1_BRK_TIM15_IRQn         = 24,     /*!< TIM1 Break and TIM15 Interrupts                                   */
  TIM1_UP_TIM16_IRQn          = 25,     /*!< TIM1 Update and TIM16 Interrupts                                  */
  TIM1_TRG_COM_TIM17_IRQn     = 26,     /*!< TIM1 Trigger and Commutation and TIM17 Interrupt                  */
  TIM1_CC_IRQn                = 27,     /*!< TIM1 Capture Compare Interrupt                                    */
  TIM2_IRQn                   = 28,     /*!< TIM2 global Interrupt                                             */
  TIM3_IRQn                   = 29,     /*!< TIM3 global Interrupt                                             */
  I2C1_EV_IRQn                = 31,     /*!< I2C1 Event Interrupt & EXTI Line23 Interrupt (I2C1 wakeup)        */
  I2C1_ER_IRQn                = 32,     /*!< I2C1 Error Interrupt                                              */
  SPI1_IRQn                   = 35,     /*!< SPI1 global Interrupt                                             */
  USART1_IRQn                 = 37,     /*!< USART1 global Interrupt & EXTI Line25 Interrupt (USART1 wakeup)   */
  USART2_IRQn                 = 38,     /*!< USART2 global Interrupt & EXTI Line26 Interrupt (USART2 wakeup)   */
  USART3_IRQn                 = 39,     /*!< USART3 global Interrupt & EXTI Line28 Interrupt (USART3 wakeup)   */
  EXTI15_10_IRQn              = 40,     /*!< External Line[15:10] Interrupts                                   */
  RTC_Alarm_IRQn              = 41,     /*!< RTC Alarm (A and B) through EXTI Line 17 Interrupt                 */
  TIM6_DAC1_IRQn              = 54,     /*!< TIM6 global and DAC1 underrun error Interrupts*/
  TIM7_DAC2_IRQn              = 55,     /*!< TIM7 global and DAC2 channel1 underrun error Interrupt            */
  COMP2_IRQn                  = 64,     /*!< COMP2 global Interrupt via EXTI Line22                            */
  COMP4_6_IRQn                = 65,     /*!< COMP4 and COMP6 global Interrupt via EXTI Line30 and 32           */
  HRTIM1_Master_IRQn          = 67,     /*!< HRTIM Master Timer global Interrupts                              */
  HRTIM1_TIMA_IRQn            = 68,     /*!< HRTIM Timer A global Interrupt                                    */
  HRTIM1_TIMB_IRQn            = 69,     /*!< HRTIM Timer B global Interrupt                                    */
  HRTIM1_TIMC_IRQn            = 70,     /*!< HRTIM Timer C global Interrupt                                    */
  HRTIM1_TIMD_IRQn            = 71,     /*!< HRTIM Timer D global Interrupt                                    */
  HRTIM1_TIME_IRQn            = 72,     /*!< HRTIM Timer E global Interrupt                                    */
  HRTIM1_FLT_IRQn             = 73,     /*!< HRTIM Fault global Interrupt                                      */
  FPU_IRQn                    = 81,      /*!< Floating point Interrupt                                          */
} IRQn_Type;

/**
  * @}
  */

#include "core_cm4.h"            /* Cortex-M4 processor and core peripherals */
#include "system_stm32f3xx.h"    /* STM32F3xx System Header */
#include <stdint.h>

/** @addtogroup Peripheral_registers_structures
  * @{
  */

/**
  * @brief Analog to Digital Converter
  */

typedef struct
{
  __IO uint32_t ISR;              /*!< ADC Interrupt and Status Register,                 Address offset: 0x00 */
  __IO uint32_t IER;              /*!< ADC Interrupt Enable Register,                     Address offset: 0x04 */
  __IO uint32_t CR;               /*!< ADC control register,                              Address offset: 0x08 */
  __IO uint32_t CFGR;             /*!< ADC Configuration register,                        Address offset: 0x0C */
  uint32_t      RESERVED0;        /*!< Reserved, 0x010                                                         */
  __IO uint32_t SMPR1;            /*!< ADC sample time register 1,                        Address offset: 0x14 */
  __IO uint32_t SMPR2;            /*!< ADC sample time register 2,                        Address offset: 0x18 */
  uint32_t      RESERVED1;        /*!< Reserved, 0x01C                                                         */
  __IO uint32_t TR1;              /*!< ADC watchdog threshold register 1,                 Address offset: 0x20 */
  __IO uint32_t TR2;              /*!< ADC watchdog threshold register 2,                 Address offset: 0x24 */
  __IO uint32_t TR3;              /*!< ADC watchdog threshold register 3,                 Address offset: 0x28 */
  uint32_t      RESERVED2;        /*!< Reserved, 0x02C                                                         */
  __IO uint32_t SQR1;             /*!< ADC regular sequence register 1,                   Address offset: 0x30 */
  __IO uint32_t SQR2;             /*!< ADC regular sequence register 2,                   Address offset: 0x34 */
  __IO uint32_t SQR3;             /*!< ADC regular sequence register 3,                   Address offset: 0x38 */
  __IO uint32_t SQR4;             /*!< ADC regular sequence register 4,                   Address offset: 0x3C */
  __IO uint32_t DR;               /*!< ADC regular data register,                         Address offset: 0x40 */
  uint32_t      RESERVED3;        /*!< Reserved, 0x044                                                         */
  uint32_t      RESERVED4;        /*!< Reserved, 0x048                                                         */
  __IO uint32_t JSQR;             /*!< ADC injected sequence register,                    Address offset: 0x4C */
  uint32_t      RESERVED5[4];     /*!< Reserved, 0x050 - 0x05C                                                 */
  __IO uint32_t OFR1;             /*!< ADC offset register 1,                             Address offset: 0x60 */
  __IO uint32_t OFR2;             /*!< ADC offset register 2,                             Address offset: 0x64 */
  __IO uint32_t OFR3;             /*!< ADC offset register 3,                             Address offset: 0x68 */
  __IO uint32_t OFR4;             /*!< ADC offset register 4,                             Address offset: 0x6C */
  uint32_t      RESERVED6[4];     /*!< Reserved, 0x070 - 0x07C                                                 */
  __IO uint32_t JDR1;             /*!< ADC injected data register 1,                      Address offset: 0x80 */
  __IO uint32_t JDR2;             /*!< ADC injected data register 2,                      Address offset: 0x84 */
  __IO uint32_t JDR3;             /*!< ADC injected data register 3,                      Address offset: 0x88 */
  __IO uint32_t JDR4;             /*!< ADC injected data register 4,                      Address offset: 0x8C */
  uint32_t      RESERVED7[4];     /*!< Reserved, 0x090 - 0x09C                                                 */
  __IO uint32_t AWD2CR;           /*!< ADC  Analog Watchdog 2 Configuration Register,     Address offset: 0xA0 */
  __IO uint32_t AWD3CR;           /*!< ADC  Analog Watchdog 3 Configuration Register,     Address offset: 0xA4 */
  uint32_t      RESERVED8;        /*!< Reserved, 0x0A8                                                         */
  uint32_t      RESERVED9;        /*!< Reserved, 0x0AC                                                         */
  __IO uint32_t DIFSEL;           /*!< ADC  Differential Mode Selection Register,         Address offset: 0xB0 */
  __IO uint32_t CALFACT;          /*!< ADC  Calibration Factors,                          Address offset: 0xB4 */

} ADC_TypeDef;

typedef struct
{
  __IO uint32_t CSR;            /*!< ADC Common status register,                  Address offset: ADC1/3 base address + 0x300 */
  uint32_t      RESERVED;       /*!< Reserved, ADC1/3 base address + 0x304                                                    */
  __IO uint32_t CCR;            /*!< ADC common control register,                 Address offset: ADC1/3 base address + 0x308 */
  __IO uint32_t CDR;            /*!< ADC common regular data register for dual
                                     AND triple modes,                            Address offset: ADC1/3 base address + 0x30C */
} ADC_Common_TypeDef;

/**
  * @brief Controller Area Network TxMailBox
  */
typedef struct
{
  __IO uint32_t TIR;  /*!< CAN TX mailbox identifier register */
  __IO uint32_t TDTR; /*!< CAN mailbox data length control and time stamp register */
  __IO uint32_t TDLR; /*!< CAN mailbox data low register */
  __IO uint32_t TDHR; /*!< CAN mailbox data high register */
} CAN_TxMailBox_TypeDef;

/**
  * @brief Controller Area Network FIFOMailBox
  */
typedef struct
{
  __IO uint32_t RIR;  /*!< CAN receive FIFO mailbox identifier register */
  __IO uint32_t RDTR; /*!< CAN receive FIFO mailbox data length control and time stamp register */
  __IO uint32_t RDLR; /*!< CAN receive FIFO mailbox data low register */
  __IO uint32_t RDHR; /*!< CAN receive FIFO mailbox data high register */
} CAN_FIFOMailBox_TypeDef;

/**
  * @brief Controller Area Network FilterRegister
  */
typedef struct
{
  __IO uint32_t FR1; /*!< CAN Filter bank register 1 */
  __IO uint32_t FR2; /*!< CAN Filter bank register 1 */
} CAN_FilterRegister_TypeDef;

/**
  * @brief Controller Area Network
  */
typedef struct
{
  __IO uint32_t              MCR;                 /*!< CAN master control register,         Address offset: 0x00          */
  __IO uint32_t              MSR;                 /*!< CAN master status register,          Address offset: 0x04          */
  __IO uint32_t              TSR;                 /*!< CAN transmit status register,        Address offset: 0x08          */
  __IO uint32_t              RF0R;                /*!< CAN receive FIFO 0 register,         Address offset: 0x0C          */
  __IO uint32_t              RF1R;                /*!< CAN receive FIFO 1 register,         Address offset: 0x10          */
  __IO uint32_t              IER;                 /*!< CAN interrupt enable register,       Address offset: 0x14          */
  __IO uint32_t              ESR;                 /*!< CAN error status register,           Address offset: 0x18          */
  __IO uint32_t              BTR;                 /*!< CAN bit timing register,             Address offset: 0x1C          */
  uint32_t                   RESERVED0[88];       /*!< Reserved, 0x020 - 0x17F                                            */
  CAN_TxMailBox_TypeDef      sTxMailBox[3];       /*!< CAN Tx MailBox,                      Address offset: 0x180 - 0x1AC */
  CAN_FIFOMailBox_TypeDef    sFIFOMailBox[2];     /*!< CAN FIFO MailBox,                    Address offset: 0x1B0 - 0x1CC */
  uint32_t                   RESERVED1[12];       /*!< Reserved, 0x1D0 - 0x1FF                                            */
  __IO uint32_t              FMR;                 /*!< CAN filter master register,          Address offset: 0x200         */
  __IO uint32_t              FM1R;                /*!< CAN filter mode register,            Address offset: 0x204         */
  uint32_t                   RESERVED2;           /*!< Reserved, 0x208                                                    */
  __IO uint32_t              FS1R;                /*!< CAN filter scale register,           Address offset: 0x20C         */
  uint32_t                   RESERVED3;           /*!< Reserved, 0x210                                                    */
  __IO uint32_t              FFA1R;               /*!< CAN filter FIFO assignment register, Address offset: 0x214         */
  uint32_t                   RESERVED4;           /*!< Reserved, 0x218                                                    */
  __IO uint32_t              FA1R;                /*!< CAN filter activation register,      Address offset: 0x21C         */
  uint32_t                   RESERVED5[8];        /*!< Reserved, 0x220-0x23F                                              */
  CAN_FilterRegister_TypeDef sFilterRegister[28]; /*!< CAN Filter Register,                 Address offset: 0x240-0x31C   */
} CAN_TypeDef;

/**
  * @brief Analog Comparators
  */
typedef struct
{
  __IO uint32_t CSR;         /*!< COMP control and status register, Address offset: 0x00 */
} COMP_TypeDef;

typedef struct
{
  __IO uint32_t CSR;         /*!< COMP control and status register, used for bits common to several COMP instances, Address offset: 0x00 */
} COMP_Common_TypeDef;

/**
  * @brief CRC calculation unit
  */

typedef struct
{
  __IO uint32_t DR;          /*!< CRC Data register,                           Address offset: 0x00 */
  __IO uint8_t  IDR;         /*!< CRC Independent data register,               Address offset: 0x04 */
  uint8_t       RESERVED0;   /*!< Reserved,                                                    0x05 */
  uint16_t      RESERVED1;   /*!< Reserved,                                                    0x06 */
  __IO uint32_t CR;          /*!< CRC Control register,                        Address offset: 0x08 */
  uint32_t      RESERVED2;   /*!< Reserved,                                                    0x0C */
  __IO uint32_t INIT;        /*!< Initial CRC value register,                  Address offset: 0x10 */
  __IO uint32_t POL;         /*!< CRC polynomial register,                     Address offset: 0x14 */
} CRC_TypeDef;

/**
  * @brief Digital to Analog Converter
  */

typedef struct
{
  __IO uint32_t CR;       /*!< DAC control register,                                    Address offset: 0x00 */
  __IO uint32_t SWTRIGR;  /*!< DAC software trigger register,                           Address offset: 0x04 */
  __IO uint32_t DHR12R1;  /*!< DAC channel1 12-bit right-aligned data holding register, Address offset: 0x08 */
  __IO uint32_t DHR12L1;  /*!< DAC channel1 12-bit left aligned data holding register,  Address offset: 0x0C */
  __IO uint32_t DHR8R1;   /*!< DAC channel1 8-bit right aligned data holding register,  Address offset: 0x10 */
  __IO uint32_t DHR12R2;  /*!< DAC channel2 12-bit right aligned data holding register, Address offset: 0x14 */
  __IO uint32_t DHR12L2;  /*!< DAC channel2 12-bit left aligned data holding register,  Address offset: 0x18 */
  __IO uint32_t DHR8R2;   /*!< DAC channel2 8-bit right-aligned data holding register,  Address offset: 0x1C */
  __IO uint32_t DHR12RD;  /*!< Dual DAC 12-bit right-aligned data holding register,     Address offset: 0x20 */
  __IO uint32_t DHR12LD;  /*!< DUAL DAC 12-bit left aligned data holding register,      Address offset: 0x24 */
  __IO uint32_t DHR8RD;   /*!< DUAL DAC 8-bit right aligned data holding register,      Address offset: 0x28 */
  __IO uint32_t DOR1;     /*!< DAC channel1 data output register,                       Address offset: 0x2C */
  __IO uint32_t DOR2;     /*!< DAC channel2 data output register,                       Address offset: 0x30 */
  __IO uint32_t SR;       /*!< DAC status register,                                     Address offset: 0x34 */
} DAC_TypeDef;

/**
  * @brief Debug MCU
  */

typedef struct
{
  __IO uint32_t IDCODE;  /*!< MCU device ID code,               Address offset: 0x00 */
  __IO uint32_t CR;      /*!< Debug MCU configuration register, Address offset: 0x04 */
  __IO uint32_t APB1FZ;  /*!< Debug MCU APB1 freeze register,   Address offset: 0x08 */
  __IO uint32_t APB2FZ;  /*!< Debug MCU APB2 freeze register,   Address offset: 0x0C */
}DBGMCU_TypeDef;

/**
  * @brief DMA Controller
  */

typedef struct
{
  __IO uint32_t CCR;          /*!< DMA channel x configuration register                                           */
  __IO uint32_t CNDTR;        /*!< DMA channel x number of data register                                          */
  __IO uint32_t CPAR;         /*!< DMA channel x peripheral address register                                      */
  __IO uint32_t CMAR;         /*!< DMA channel x memory address register                                          */
} DMA_Channel_TypeDef;

typedef struct
{
  __IO uint32_t ISR;          /*!< DMA interrupt status register,                            Address offset: 0x00 */
  __IO uint32_t IFCR;         /*!< DMA interrupt flag clear register,                        Address offset: 0x04 */
} DMA_TypeDef;

/**
  * @brief External Interrupt/Event Controller
  */

typedef struct
{
  __IO uint32_t IMR;          /*!<EXTI Interrupt mask register,                             Address offset: 0x00 */
  __IO uint32_t EMR;          /*!<EXTI Event mask register,                                 Address offset: 0x04 */
  __IO uint32_t RTSR;         /*!<EXTI Rising trigger selection register ,                  Address offset: 0x08 */
  __IO uint32_t FTSR;         /*!<EXTI Falling trigger selection register,                  Address offset: 0x0C */
  __IO uint32_t SWIER;        /*!<EXTI Software interrupt event register,                   Address offset: 0x10 */
  __IO uint32_t PR;           /*!<EXTI Pending register,                                    Address offset: 0x14 */
  uint32_t      RESERVED1;    /*!< Reserved, 0x18                                                                */
  uint32_t      RESERVED2;    /*!< Reserved, 0x1C                                                                */
  __IO uint32_t IMR2;         /*!< EXTI Interrupt mask register,                            Address offset: 0x20 */
  __IO uint32_t EMR2;         /*!< EXTI Event mask register,                                Address offset: 0x24 */
  __IO uint32_t RTSR2;        /*!< EXTI Rising trigger selection register,                  Address offset: 0x28 */
  __IO uint32_t FTSR2;        /*!< EXTI Falling trigger selection register,                 Address offset: 0x2C */
  __IO uint32_t SWIER2;       /*!< EXTI Software interrupt event register,                  Address offset: 0x30 */
  __IO uint32_t PR2;          /*!< EXTI Pending register,                                   Address offset: 0x34 */
}EXTI_TypeDef;

/**
  * @brief FLASH Registers
  */

typedef struct
{
  __IO uint32_t ACR;          /*!< FLASH access control register,              Address offset: 0x00 */
  __IO uint32_t KEYR;         /*!< FLASH key register,                         Address offset: 0x04 */
  __IO uint32_t OPTKEYR;      /*!< FLASH option key register,                  Address offset: 0x08 */
  __IO uint32_t SR;           /*!< FLASH status register,                      Address offset: 0x0C */
  __IO uint32_t CR;           /*!< FLASH control register,                     Address offset: 0x10 */
  __IO uint32_t AR;           /*!< FLASH address register,                     Address offset: 0x14 */
  uint32_t      RESERVED;     /*!< Reserved, 0x18                                                   */
  __IO uint32_t OBR;          /*!< FLASH Option byte register,                 Address offset: 0x1C */
  __IO uint32_t WRPR;         /*!< FLASH Write register,                       Address offset: 0x20 */

} FLASH_TypeDef;

/**
  * @brief Option Bytes Registers
  */
typedef struct
{
  __IO uint16_t RDP;          /*!<FLASH option byte Read protection,             Address offset: 0x00 */
  __IO uint16_t USER;         /*!<FLASH option byte user options,                Address offset: 0x02 */
  uint16_t RESERVED0;         /*!< Reserved,                                                     0x04 */
  uint16_t RESERVED1;         /*!< Reserved,                                                     0x06 */
  __IO uint16_t WRP0;         /*!<FLASH option byte write protection 0,          Address offset: 0x08 */
  __IO uint16_t WRP1;         /*!<FLASH option byte write protection 1,          Address offset: 0x0C */
  __IO uint16_t WRP2;         /*!<FLASH option byte write protection 2,          Address offset: 0x10 */
  __IO uint16_t WRP3;         /*!<FLASH option byte write protection 3,          Address offset: 0x12 */
} OB_TypeDef;

/**
  * @brief General Purpose I/O
  */

typedef struct
{
  __IO uint32_t MODER;        /*!< GPIO port mode register,               Address offset: 0x00      */
  __IO uint32_t OTYPER;       /*!< GPIO port output type register,        Address offset: 0x04      */
  __IO uint32_t OSPEEDR;      /*!< GPIO port output speed register,       Address offset: 0x08      */
  __IO uint32_t PUPDR;        /*!< GPIO port pull-up/pull-down register,  Address offset: 0x0C      */
  __IO uint32_t IDR;          /*!< GPIO port input data register,         Address offset: 0x10      */
  __IO uint32_t ODR;          /*!< GPIO port output data register,        Address offset: 0x14      */
  __IO uint32_t BSRR;         /*!< GPIO port bit set/reset register,      Address offset: 0x1A */
  __IO uint32_t LCKR;         /*!< GPIO port configuration lock register, Address offset: 0x1C      */
  __IO uint32_t AFR[2];       /*!< GPIO alternate function registers,     Address offset: 0x20-0x24 */
  __IO uint32_t BRR;          /*!< GPIO bit reset register,               Address offset: 0x28 */
}GPIO_TypeDef;

/**
  * @brief Operational Amplifier (OPAMP)
  */

typedef struct
{
  __IO uint32_t CSR;        /*!< OPAMP control and status register,            Address offset: 0x00 */
} OPAMP_TypeDef;

/**
  * @brief High resolution Timer (HRTIM)
  */
/* HRTIM master registers definition */
typedef struct
{
  __IO uint32_t MCR;            /*!< HRTIM Master Timer control register,                     Address offset: 0x00 */
  __IO uint32_t MISR;           /*!< HRTIM Master Timer interrupt status register,            Address offset: 0x04 */
  __IO uint32_t MICR;           /*!< HRTIM Master Timer interupt clear register,              Address offset: 0x08 */
  __IO uint32_t MDIER;          /*!< HRTIM Master Timer DMA/interrupt enable register         Address offset: 0x0C */
  __IO uint32_t MCNTR;          /*!< HRTIM Master Timer counter register,                     Address offset: 0x10 */
  __IO uint32_t MPER;           /*!< HRTIM Master Timer period register,                      Address offset: 0x14 */
  __IO uint32_t MREP;           /*!< HRTIM Master Timer repetition register,                  Address offset: 0x18 */
  __IO uint32_t MCMP1R;         /*!< HRTIM Master Timer compare 1 register,                   Address offset: 0x1C */
  uint32_t      RESERVED0;     /*!< Reserved,                                                                0x20 */
  __IO uint32_t MCMP2R;         /*!< HRTIM Master Timer compare 2 register,                   Address offset: 0x24 */
  __IO uint32_t MCMP3R;         /*!< HRTIM Master Timer compare 3 register,                   Address offset: 0x28 */
  __IO uint32_t MCMP4R;         /*!< HRTIM Master Timer compare 4 register,                   Address offset: 0x2C */
  uint32_t      RESERVED1[20];  /*!< Reserved,                                                          0x30..0x7C */
}HRTIM_Master_TypeDef; 
 
/* HRTIM Timer A to E registers definition */
typedef struct
{
  __IO uint32_t TIMxCR;     /*!< HRTIM Timerx control register,                              Address offset: 0x00  */
  __IO uint32_t TIMxISR;    /*!< HRTIM Timerx interrupt status register,                     Address offset: 0x04  */
  __IO uint32_t TIMxICR;    /*!< HRTIM Timerx interrupt clear register,                      Address offset: 0x08  */
  __IO uint32_t TIMxDIER;   /*!< HRTIM Timerx DMA/interrupt enable register,                 Address offset: 0x0C  */
  __IO uint32_t CNTxR;      /*!< HRTIM Timerx counter register,                              Address offset: 0x10  */
  __IO uint32_t PERxR;      /*!< HRTIM Timerx period register,                               Address offset: 0x14  */
  __IO uint32_t REPxR;      /*!< HRTIM Timerx repetition register,                           Address offset: 0x18  */
  __IO uint32_t CMP1xR;     /*!< HRTIM Timerx compare 1 register,                            Address offset: 0x1C  */
  __IO uint32_t CMP1CxR;    /*!< HRTIM Timerx compare 1 compound register,                   Address offset: 0x20  */
  __IO uint32_t CMP2xR;     /*!< HRTIM Timerx compare 2 register,                            Address offset: 0x24  */
  __IO uint32_t CMP3xR;     /*!< HRTIM Timerx compare 3 register,                            Address offset: 0x28  */
  __IO uint32_t CMP4xR;     /*!< HRTIM Timerx compare 4 register,                            Address offset: 0x2C  */
  __IO uint32_t CPT1xR;     /*!< HRTIM Timerx capture 1 register,                            Address offset: 0x30  */
  __IO uint32_t CPT2xR;     /*!< HRTIM Timerx capture 2 register,                            Address offset: 0x34 */
  __IO uint32_t DTxR;       /*!< HRTIM Timerx dead time register,                            Address offset: 0x38 */
  __IO uint32_t SETx1R;     /*!< HRTIM Timerx output 1 set register,                         Address offset: 0x3C */
  __IO uint32_t RSTx1R;     /*!< HRTIM Timerx output 1 reset register,                       Address offset: 0x40 */
  __IO uint32_t SETx2R;     /*!< HRTIM Timerx output 2 set register,                         Address offset: 0x44 */
  __IO uint32_t RSTx2R;     /*!< HRTIM Timerx output 2 reset register,                       Address offset: 0x48 */
  __IO uint32_t EEFxR1;     /*!< HRTIM Timerx external event filtering 1 register,           Address offset: 0x4C */
  __IO uint32_t EEFxR2;     /*!< HRTIM Timerx external event filtering 2 register,           Address offset: 0x50 */
  __IO uint32_t RSTxR;      /*!< HRTIM Timerx Reset register,                                Address offset: 0x54 */
  __IO uint32_t CHPxR;      /*!< HRTIM Timerx Chopper register,                              Address offset: 0x58 */
  __IO uint32_t CPT1xCR;    /*!< HRTIM Timerx Capture 1 register,                            Address offset: 0x5C */
  __IO uint32_t CPT2xCR;    /*!< HRTIM Timerx Capture 2 register,                            Address offset: 0x60 */
  __IO uint32_t OUTxR;      /*!< HRTIM Timerx Output register,                               Address offset: 0x64 */
  __IO uint32_t FLTxR;      /*!< HRTIM Timerx Fault register,                                Address offset: 0x68 */
  uint32_t      RESERVED0[5];  /*!< Reserved,                                                              0x6C..0x7C */
}HRTIM_Timerx_TypeDef;

/* HRTIM common register definition */
typedef struct
{
  __IO uint32_t CR1;        /*!< HRTIM control register1,                                    Address offset: 0x00 */
  __IO uint32_t CR2;        /*!< HRTIM control register2,                                    Address offset: 0x04 */
  __IO uint32_t ISR;        /*!< HRTIM interrupt status register,                            Address offset: 0x08 */
  __IO uint32_t ICR;        /*!< HRTIM interrupt clear register,                             Address offset: 0x0C */
  __IO uint32_t IER;        /*!< HRTIM interrupt enable register,                            Address offset: 0x10 */
  __IO uint32_t OENR;       /*!< HRTIM Output enable register,                               Address offset: 0x14 */
  __IO uint32_t ODISR;      /*!< HRTIM Output disable register,                              Address offset: 0x18 */
  __IO uint32_t ODSR;       /*!< HRTIM Output disable status register,                       Address offset: 0x1C */
  __IO uint32_t BMCR;       /*!< HRTIM Burst mode control register,                          Address offset: 0x20 */
  __IO uint32_t BMTRGR;     /*!< HRTIM Busrt mode trigger register,                          Address offset: 0x24 */
  __IO uint32_t BMCMPR;     /*!< HRTIM Burst mode compare register,                          Address offset: 0x28 */
  __IO uint32_t BMPER;      /*!< HRTIM Burst mode period register,                           Address offset: 0x2C */
  __IO uint32_t EECR1;      /*!< HRTIM Timer external event control register1,               Address offset: 0x30 */
  __IO uint32_t EECR2;      /*!< HRTIM Timer external event control register2,               Address offset: 0x34 */
  __IO uint32_t EECR3;      /*!< HRTIM Timer external event control register3,               Address offset: 0x38 */
  __IO uint32_t ADC1R;      /*!< HRTIM ADC Trigger 1 register,                               Address offset: 0x3C */
  __IO uint32_t ADC2R;      /*!< HRTIM ADC Trigger 2 register,                               Address offset: 0x40 */
  __IO uint32_t ADC3R;      /*!< HRTIM ADC Trigger 3 register,                               Address offset: 0x44 */
  __IO uint32_t ADC4R;      /*!< HRTIM ADC Trigger 4 register,                               Address offset: 0x48 */
  __IO uint32_t DLLCR;      /*!< HRTIM DLL control register,                                 Address offset: 0x4C */
  __IO uint32_t FLTINR1;    /*!< HRTIM Fault input register1,                                Address offset: 0x50 */
  __IO uint32_t FLTINR2;    /*!< HRTIM Fault input register2,                                Address offset: 0x54 */
  __IO uint32_t BDMUPR;     /*!< HRTIM Burst DMA Master Timer update register,               Address offset: 0x58 */
  __IO uint32_t BDTAUPR;    /*!< HRTIM Burst DMA Timerx update register,                     Address offset: 0x5C */
  __IO uint32_t BDTBUPR;    /*!< HRTIM Burst DMA Timerx update register,                     Address offset: 0x60 */
  __IO uint32_t BDTCUPR;    /*!< HRTIM Burst DMA Timerx update register,                     Address offset: 0x64 */
  __IO uint32_t BDTDUPR;    /*!< HRTIM Burst DMA Timerx update register,                     Address offset: 0x68 */  
  __IO uint32_t BDTEUPR;    /*!< HRTIM Burst DMA Timerx update register,                     Address offset: 0x6C */  
  __IO uint32_t BDMADR;     /*!< HRTIM Burst DMA Master Data register,                       Address offset: 0x70 */
}HRTIM_Common_TypeDef;

/* HRTIM  register definition */
typedef struct {
  HRTIM_Master_TypeDef sMasterRegs;
  HRTIM_Timerx_TypeDef sTimerxRegs[5];
  uint32_t             RESERVED0[32];
  HRTIM_Common_TypeDef sCommonRegs;
}HRTIM_TypeDef;

/**
  * @brief System configuration controller
  */

typedef struct
{
  __IO uint32_t CFGR1;       /*!< SYSCFG configuration register 1,                      Address offset: 0x00 */
  __IO uint32_t RCR;        /*!< SYSCFG CCM SRAM protection register,               Address offset: 0x04 */
  __IO uint32_t EXTICR[4];   /*!< SYSCFG external interrupt configuration registers, Address offset: 0x14-0x08 */
  __IO uint32_t CFGR2;       /*!< SYSCFG configuration register 2,                      Address offset: 0x18 */
  __IO uint32_t RESERVED0;   /*!< Reserved,                                                           0x1C */
  __IO uint32_t RESERVED1;   /*!< Reserved,                                                          0x20 */
  __IO uint32_t RESERVED2;   /*!< Reserved,                                                          0x24 */
  __IO uint32_t RESERVED4;   /*!< Reserved,                                                          0x28 */
  __IO uint32_t RESERVED5;  /*!< Reserved,                                                          0x2C */
  __IO uint32_t RESERVED6;   /*!< Reserved,                                                          0x30 */
  __IO uint32_t RESERVED7;  /*!< Reserved,                                                          0x34 */
  __IO uint32_t RESERVED8;  /*!< Reserved,                                                          0x38 */
  __IO uint32_t RESERVED9;   /*!< Reserved,                                                          0x3C */
  __IO uint32_t RESERVED10;  /*!< Reserved,                                                          0x40 */
  __IO uint32_t RESERVED11;  /*!< Reserved,                                                          0x44 */
  __IO uint32_t RESERVED12;  /*!< Reserved,                                                          0x48 */
  __IO uint32_t RESERVED13;  /*!< Reserved,                                                          0x4C */
  __IO uint32_t CFGR3;      /*!< SYSCFG configuration register 3,                    Address offset: 0x50 */
} SYSCFG_TypeDef;

/**
  * @brief Inter-integrated Circuit Interface
  */

typedef struct
{
  __IO uint32_t CR1;      /*!< I2C Control register 1,            Address offset: 0x00 */
  __IO uint32_t CR2;      /*!< I2C Control register 2,            Address offset: 0x04 */
  __IO uint32_t OAR1;     /*!< I2C Own address 1 register,        Address offset: 0x08 */
  __IO uint32_t OAR2;     /*!< I2C Own address 2 register,        Address offset: 0x0C */
  __IO uint32_t TIMINGR;  /*!< I2C Timing register,               Address offset: 0x10 */
  __IO uint32_t TIMEOUTR; /*!< I2C Timeout register,              Address offset: 0x14 */
  __IO uint32_t ISR;      /*!< I2C Interrupt and status register, Address offset: 0x18 */
  __IO uint32_t ICR;      /*!< I2C Interrupt clear register,      Address offset: 0x1C */
  __IO uint32_t PECR;     /*!< I2C PEC register,                  Address offset: 0x20 */
  __IO uint32_t RXDR;     /*!< I2C Receive data register,         Address offset: 0x24 */
  __IO uint32_t TXDR;     /*!< I2C Transmit data register,        Address offset: 0x28 */
}I2C_TypeDef;

/**
  * @brief Independent WATCHDOG
  */

typedef struct
{
  __IO uint32_t KR;   /*!< IWDG Key register,       Address offset: 0x00 */
  __IO uint32_t PR;   /*!< IWDG Prescaler register, Address offset: 0x04 */
  __IO uint32_t RLR;  /*!< IWDG Reload register,    Address offset: 0x08 */
  __IO uint32_t SR;   /*!< IWDG Status register,    Address offset: 0x0C */
  __IO uint32_t WINR; /*!< IWDG Window register,    Address offset: 0x10 */
} IWDG_TypeDef;

/**
  * @brief Power Control
  */

typedef struct
{
  __IO uint32_t CR;   /*!< PWR power control register,        Address offset: 0x00 */
  __IO uint32_t CSR;  /*!< PWR power control/status register, Address offset: 0x04 */
} PWR_TypeDef;

/**
  * @brief Reset and Clock Control
  */
typedef struct
{
  __IO uint32_t CR;         /*!< RCC clock control register,                                  Address offset: 0x00 */
  __IO uint32_t CFGR;       /*!< RCC clock configuration register,                            Address offset: 0x04 */
  __IO uint32_t CIR;        /*!< RCC clock interrupt register,                                Address offset: 0x08 */
  __IO uint32_t APB2RSTR;   /*!< RCC APB2 peripheral reset register,                          Address offset: 0x0C */
  __IO uint32_t APB1RSTR;   /*!< RCC APB1 peripheral reset register,                          Address offset: 0x10 */
  __IO uint32_t AHBENR;     /*!< RCC AHB peripheral clock register,                           Address offset: 0x14 */
  __IO uint32_t APB2ENR;    /*!< RCC APB2 peripheral clock enable register,                   Address offset: 0x18 */
  __IO uint32_t APB1ENR;    /*!< RCC APB1 peripheral clock enable register,                   Address offset: 0x1C */
  __IO uint32_t BDCR;       /*!< RCC Backup domain control register,                          Address offset: 0x20 */
  __IO uint32_t CSR;        /*!< RCC clock control & status register,                         Address offset: 0x24 */
  __IO uint32_t AHBRSTR;    /*!< RCC AHB peripheral reset register,                           Address offset: 0x28 */
  __IO uint32_t CFGR2;      /*!< RCC clock configuration register 2,                          Address offset: 0x2C */
  __IO uint32_t CFGR3;      /*!< RCC clock configuration register 3,                          Address offset: 0x30 */
} RCC_TypeDef;

/**
  * @brief Real-Time Clock
  */

typedef struct
{
  __IO uint32_t TR;         /*!< RTC time register,                                        Address offset: 0x00 */
  __IO uint32_t DR;         /*!< RTC date register,                                        Address offset: 0x04 */
  __IO uint32_t CR;         /*!< RTC control register,                                     Address offset: 0x08 */
  __IO uint32_t ISR;        /*!< RTC initialization and status register,                   Address offset: 0x0C */
  __IO uint32_t PRER;       /*!< RTC prescaler register,                                   Address offset: 0x10 */
  __IO uint32_t WUTR;       /*!< RTC wakeup timer register,                                Address offset: 0x14 */
  uint32_t RESERVED0;       /*!< Reserved, 0x18                                                                 */
  __IO uint32_t ALRMAR;     /*!< RTC alarm A register,                                     Address offset: 0x1C */
  __IO uint32_t ALRMBR;     /*!< RTC alarm B register,                                     Address offset: 0x20 */
  __IO uint32_t WPR;        /*!< RTC write protection register,                            Address offset: 0x24 */
  __IO uint32_t SSR;        /*!< RTC sub second register,                                  Address offset: 0x28 */
  __IO uint32_t SHIFTR;     /*!< RTC shift control register,                               Address offset: 0x2C */
  __IO uint32_t TSTR;       /*!< RTC time stamp time register,                             Address offset: 0x30 */
  __IO uint32_t TSDR;       /*!< RTC time stamp date register,                             Address offset: 0x34 */
  __IO uint32_t TSSSR;      /*!< RTC time-stamp sub second register,                       Address offset: 0x38 */
  __IO uint32_t CALR;       /*!< RTC calibration register,                                 Address offset: 0x3C */
  __IO uint32_t TAFCR;      /*!< RTC tamper and alternate function configuration register, Address offset: 0x40 */
  __IO uint32_t ALRMASSR;   /*!< RTC alarm A sub second register,                          Address offset: 0x44 */
  __IO uint32_t ALRMBSSR;   /*!< RTC alarm B sub second register,                          Address offset: 0x48 */
  uint32_t RESERVED7;       /*!< Reserved, 0x4C                                                                 */
  __IO uint32_t BKP0R;      /*!< RTC backup register 0,                                    Address offset: 0x50 */
  __IO uint32_t BKP1R;      /*!< RTC backup register 1,                                    Address offset: 0x54 */
  __IO uint32_t BKP2R;      /*!< RTC backup register 2,                                    Address offset: 0x58 */
  __IO uint32_t BKP3R;      /*!< RTC backup register 3,                                    Address offset: 0x5C */
  __IO uint32_t BKP4R;      /*!< RTC backup register 4,                                    Address offset: 0x60 */
} RTC_TypeDef;


/**
  * @brief Serial Peripheral Interface
  */

typedef struct
{
  __IO uint32_t CR1;      /*!< SPI Control register 1,                              Address offset: 0x00 */
  __IO uint32_t CR2;      /*!< SPI Control register 2,                              Address offset: 0x04 */
  __IO uint32_t SR;       /*!< SPI Status register,                                 Address offset: 0x08 */
  __IO uint32_t DR;       /*!< SPI data register,                                   Address offset: 0x0C */
  __IO uint32_t CRCPR;    /*!< SPI CRC polynomial register,                         Address offset: 0x10 */
  __IO uint32_t RXCRCR;   /*!< SPI Rx CRC register,                                 Address offset: 0x14 */
  __IO uint32_t TXCRCR;   /*!< SPI Tx CRC register,                                 Address offset: 0x18 */
} SPI_TypeDef;

/**
  * @brief TIM
  */
typedef struct
{
  __IO uint32_t CR1;         /*!< TIM control register 1,              Address offset: 0x00 */
  __IO uint32_t CR2;         /*!< TIM control register 2,              Address offset: 0x04 */
  __IO uint32_t SMCR;        /*!< TIM slave mode control register,     Address offset: 0x08 */
  __IO uint32_t DIER;        /*!< TIM DMA/interrupt enable register,   Address offset: 0x0C */
  __IO uint32_t SR;          /*!< TIM status register,                 Address offset: 0x10 */
  __IO uint32_t EGR;         /*!< TIM event generation register,       Address offset: 0x14 */
  __IO uint32_t CCMR1;       /*!< TIM capture/compare mode register 1, Address offset: 0x18 */
  __IO uint32_t CCMR2;       /*!< TIM capture/compare mode register 2, Address offset: 0x1C */
  __IO uint32_t CCER;        /*!< TIM capture/compare enable register, Address offset: 0x20 */
  __IO uint32_t CNT;         /*!< TIM counter register,                Address offset: 0x24 */
  __IO uint32_t PSC;         /*!< TIM prescaler,                       Address offset: 0x28 */
  __IO uint32_t ARR;         /*!< TIM auto-reload register,            Address offset: 0x2C */
  __IO uint32_t RCR;         /*!< TIM repetition counter register,     Address offset: 0x30 */
  __IO uint32_t CCR1;        /*!< TIM capture/compare register 1,      Address offset: 0x34 */
  __IO uint32_t CCR2;        /*!< TIM capture/compare register 2,      Address offset: 0x38 */
  __IO uint32_t CCR3;        /*!< TIM capture/compare register 3,      Address offset: 0x3C */
  __IO uint32_t CCR4;        /*!< TIM capture/compare register 4,      Address offset: 0x40 */
  __IO uint32_t BDTR;        /*!< TIM break and dead-time register,    Address offset: 0x44 */
  __IO uint32_t DCR;         /*!< TIM DMA control register,            Address offset: 0x48 */
  __IO uint32_t DMAR;        /*!< TIM DMA address for full transfer,   Address offset: 0x4C */
  __IO uint32_t OR;          /*!< TIM option register,                 Address offset: 0x50 */
  __IO uint32_t CCMR3;       /*!< TIM capture/compare mode register 3, Address offset: 0x54 */
  __IO uint32_t CCR5;        /*!< TIM capture/compare register5,       Address offset: 0x58 */
  __IO uint32_t CCR6;        /*!< TIM capture/compare register 4,      Address offset: 0x5C */
} TIM_TypeDef;

/**
  * @brief Touch Sensing Controller (TSC)
  */
typedef struct
{
  __IO uint32_t CR;            /*!< TSC control register,                                     Address offset: 0x00 */
  __IO uint32_t IER;           /*!< TSC interrupt enable register,                            Address offset: 0x04 */
  __IO uint32_t ICR;           /*!< TSC interrupt clear register,                             Address offset: 0x08 */
  __IO uint32_t ISR;           /*!< TSC interrupt status register,                            Address offset: 0x0C */
  __IO uint32_t IOHCR;         /*!< TSC I/O hysteresis control register,                      Address offset: 0x10 */
  uint32_t      RESERVED1;     /*!< Reserved,                                                 Address offset: 0x14 */
  __IO uint32_t IOASCR;        /*!< TSC I/O analog switch control register,                   Address offset: 0x18 */
  uint32_t      RESERVED2;     /*!< Reserved,                                                 Address offset: 0x1C */
  __IO uint32_t IOSCR;         /*!< TSC I/O sampling control register,                        Address offset: 0x20 */
  uint32_t      RESERVED3;     /*!< Reserved,                                                 Address offset: 0x24 */
  __IO uint32_t IOCCR;         /*!< TSC I/O channel control register,                         Address offset: 0x28 */
  uint32_t      RESERVED4;     /*!< Reserved,                                                 Address offset: 0x2C */
  __IO uint32_t IOGCSR;        /*!< TSC I/O group control status register,                    Address offset: 0x30 */
  __IO uint32_t IOGXCR[8];     /*!< TSC I/O group x counter register,                         Address offset: 0x34-50 */
} TSC_TypeDef;

/**
  * @brief Universal Synchronous Asynchronous Receiver Transmitter
  */

typedef struct
{
  __IO uint32_t CR1;    /*!< USART Control register 1,                 Address offset: 0x00 */
  __IO uint32_t CR2;    /*!< USART Control register 2,                 Address offset: 0x04 */
  __IO uint32_t CR3;    /*!< USART Control register 3,                 Address offset: 0x08 */
  __IO uint32_t BRR;    /*!< USART Baud rate register,                 Address offset: 0x0C */
  __IO uint32_t GTPR;   /*!< USART Guard time and prescaler register,  Address offset: 0x10 */
  __IO uint32_t RTOR;   /*!< USART Receiver Time Out register,         Address offset: 0x14 */
  __IO uint32_t RQR;    /*!< USART Request register,                   Address offset: 0x18 */
  __IO uint32_t ISR;    /*!< USART Interrupt and status register,      Address offset: 0x1C */
  __IO uint32_t ICR;    /*!< USART Interrupt flag Clear register,      Address offset: 0x20 */
  __IO uint16_t RDR;    /*!< USART Receive Data register,              Address offset: 0x24 */
  uint16_t  RESERVED1;  /*!< Reserved, 0x26                                                 */
  __IO uint16_t TDR;    /*!< USART Transmit Data register,             Address offset: 0x28 */
  uint16_t  RESERVED2;  /*!< Reserved, 0x2A                                                 */
} USART_TypeDef;

/**
  * @brief Window WATCHDOG
  */
typedef struct
{
  __IO uint32_t CR;   /*!< WWDG Control register,       Address offset: 0x00 */
  __IO uint32_t CFR;  /*!< WWDG Configuration register, Address offset: 0x04 */
  __IO uint32_t SR;   /*!< WWDG Status register,        Address offset: 0x08 */
} WWDG_TypeDef;

/** @addtogroup Peripheral_memory_map
  * @{
  */

#define FLASH_BASE            ((uint32_t)0x08000000U) /*!< FLASH base address in the alias region */
#define CCMDATARAM_BASE       ((uint32_t)0x10000000U) /*!< CCM(core coupled memory) data RAM base address in the alias region     */
#define SRAM_BASE             ((uint32_t)0x20000000U) /*!< SRAM base address in the alias region */
#define PERIPH_BASE           ((uint32_t)0x40000000U) /*!< Peripheral base address in the alias region */
#define SRAM_BB_BASE          ((uint32_t)0x22000000U) /*!< SRAM base address in the bit-band region */
#define PERIPH_BB_BASE        ((uint32_t)0x42000000U) /*!< Peripheral base address in the bit-band region */


/*!< Peripheral memory map */
#define APB1PERIPH_BASE       PERIPH_BASE
#define APB2PERIPH_BASE       (PERIPH_BASE + 0x00010000U)
#define AHB1PERIPH_BASE       (PERIPH_BASE + 0x00020000U)
#define AHB2PERIPH_BASE       (PERIPH_BASE + 0x08000000U)
#define AHB3PERIPH_BASE       (PERIPH_BASE + 0x10000000U)

/*!< APB1 peripherals */
#define TIM2_BASE             (APB1PERIPH_BASE + 0x00000000U)
#define TIM3_BASE             (APB1PERIPH_BASE + 0x00000400U)
#define TIM6_BASE             (APB1PERIPH_BASE + 0x00001000U)
#define TIM7_BASE             (APB1PERIPH_BASE + 0x00001400U)
#define RTC_BASE              (APB1PERIPH_BASE + 0x00002800U)
#define WWDG_BASE             (APB1PERIPH_BASE + 0x00002C00U)
#define IWDG_BASE             (APB1PERIPH_BASE + 0x00003000U)
#define USART2_BASE           (APB1PERIPH_BASE + 0x00004400U)
#define USART3_BASE           (APB1PERIPH_BASE + 0x00004800U)
#define I2C1_BASE             (APB1PERIPH_BASE + 0x00005400U)
#define CAN_BASE              (APB1PERIPH_BASE + 0x00006400U)
#define PWR_BASE              (APB1PERIPH_BASE + 0x00007000U)
#define DAC1_BASE             (APB1PERIPH_BASE + 0x00007400U)
#define DAC2_BASE             (APB1PERIPH_BASE + 0x00009800U)
#define DAC_BASE               DAC1_BASE

/*!< APB2 peripherals */
#define SYSCFG_BASE           (APB2PERIPH_BASE + 0x00000000U)
#define COMP2_BASE            (APB2PERIPH_BASE + 0x00000020U)
#define COMP4_BASE            (APB2PERIPH_BASE + 0x00000028U)
#define COMP6_BASE            (APB2PERIPH_BASE + 0x00000030U)
#define COMP_BASE             COMP2_BASE
#define OPAMP2_BASE           (APB2PERIPH_BASE + 0x0000003CU)
#define OPAMP_BASE            OPAMP2_BASE
#define EXTI_BASE             (APB2PERIPH_BASE + 0x00000400U)
#define TIM1_BASE             (APB2PERIPH_BASE + 0x00002C00U)
#define SPI1_BASE             (APB2PERIPH_BASE + 0x00003000U)
#define USART1_BASE           (APB2PERIPH_BASE + 0x00003800U)
#define TIM15_BASE            (APB2PERIPH_BASE + 0x00004000U)
#define TIM16_BASE            (APB2PERIPH_BASE + 0x00004400U)
#define TIM17_BASE            (APB2PERIPH_BASE + 0x00004800U)
#define HRTIM1_BASE           (APB2PERIPH_BASE + 0x00007400U)
#define HRTIM1_TIMA_BASE      (HRTIM1_BASE + 0x00000080U)
#define HRTIM1_TIMB_BASE      (HRTIM1_BASE + 0x00000100U)
#define HRTIM1_TIMC_BASE      (HRTIM1_BASE + 0x00000180U)
#define HRTIM1_TIMD_BASE      (HRTIM1_BASE + 0x00000200U)
#define HRTIM1_TIME_BASE      (HRTIM1_BASE + 0x00000280U)
#define HRTIM1_COMMON_BASE    (HRTIM1_BASE + 0x00000380U)

/*!< AHB1 peripherals */
#define DMA1_BASE             (AHB1PERIPH_BASE + 0x00000000U)
#define DMA1_Channel1_BASE    (AHB1PERIPH_BASE + 0x00000008U)
#define DMA1_Channel2_BASE    (AHB1PERIPH_BASE + 0x0000001CU)
#define DMA1_Channel3_BASE    (AHB1PERIPH_BASE + 0x00000030U)
#define DMA1_Channel4_BASE    (AHB1PERIPH_BASE + 0x00000044U)
#define DMA1_Channel5_BASE    (AHB1PERIPH_BASE + 0x00000058U)
#define DMA1_Channel6_BASE    (AHB1PERIPH_BASE + 0x0000006CU)
#define DMA1_Channel7_BASE    (AHB1PERIPH_BASE + 0x00000080U)
#define RCC_BASE              (AHB1PERIPH_BASE + 0x00001000U)
#define FLASH_R_BASE          (AHB1PERIPH_BASE + 0x00002000U) /*!< Flash registers base address */
#define OB_BASE               ((uint32_t)0x1FFFF800U)         /*!< Flash Option Bytes base address */
#define FLASHSIZE_BASE        ((uint32_t)0x1FFFF7CCU)         /*!< FLASH Size register base address */
#define UID_BASE              ((uint32_t)0x1FFFF7ACU)         /*!< Unique device ID register base address */
#define CRC_BASE              (AHB1PERIPH_BASE + 0x00003000U)
#define TSC_BASE              (AHB1PERIPH_BASE + 0x00004000U)

/*!< AHB2 peripherals */
#define GPIOA_BASE            (AHB2PERIPH_BASE + 0x00000000U)
#define GPIOB_BASE            (AHB2PERIPH_BASE + 0x00000400U)
#define GPIOC_BASE            (AHB2PERIPH_BASE + 0x00000800U)
#define GPIOD_BASE            (AHB2PERIPH_BASE + 0x00000C00U)
#define GPIOF_BASE            (AHB2PERIPH_BASE + 0x00001400U)

/*!< AHB3 peripherals */
#define ADC1_BASE             (AHB3PERIPH_BASE + 0x00000000U)
#define ADC2_BASE             (AHB3PERIPH_BASE + 0x00000100U)
#define ADC1_2_COMMON_BASE    (AHB3PERIPH_BASE + 0x00000300U)

#define DBGMCU_BASE          ((uint32_t)0xE0042000U) /*!< Debug MCU registers base address */
/**
  * @}
  */

/** @addtogroup Peripheral_declaration
  * @{
  */
#define HRTIM1              ((HRTIM_TypeDef *) HRTIM1_BASE)
#define HRTIM1_TIMA         ((HRTIM_TIM_TypeDef *) HRTIM1_TIMA_BASE)
#define HRTIM1_TIMB         ((HRTIM_TIM_TypeDef *) HRTIM1_TIMB_BASE)
#define HRTIM1_TIMC         ((HRTIM_TIM_TypeDef *) HRTIM1_TIMC_BASE)
#define HRTIM1_TIMD         ((HRTIM_TIM_TypeDef *) HRTIM1_TIMD_BASE)
#define HRTIM1_TIME         ((HRTIM_TIM_TypeDef *) HRTIM1_TIME_BASE)
#define HRTIM1_COMMON       ((HRTIM_Common_TypeDef *) HRTIM1_COMMON_BASE)
#define TIM2                ((TIM_TypeDef *) TIM2_BASE)
#define TIM3                ((TIM_TypeDef *) TIM3_BASE)
#define TIM6                ((TIM_TypeDef *) TIM6_BASE)
#define TIM7                ((TIM_TypeDef *) TIM7_BASE)
#define RTC                 ((RTC_TypeDef *) RTC_BASE)
#define WWDG                ((WWDG_TypeDef *) WWDG_BASE)
#define IWDG                ((IWDG_TypeDef *) IWDG_BASE)
#define USART2              ((USART_TypeDef *) USART2_BASE)
#define USART3              ((USART_TypeDef *) USART3_BASE)
#define I2C1                ((I2C_TypeDef *) I2C1_BASE)
#define CAN1                ((CAN_TypeDef *) CAN_BASE)
#define PWR                 ((PWR_TypeDef *) PWR_BASE)
#define DAC                 ((DAC_TypeDef *) DAC_BASE)
#define DAC1                ((DAC_TypeDef *) DAC1_BASE)
#define DAC2                ((DAC_TypeDef *) DAC2_BASE)
#define COMP2               ((COMP_TypeDef *) COMP2_BASE)
#define COMP4               ((COMP_TypeDef *) COMP4_BASE)
#define COMP6               ((COMP_TypeDef *) COMP6_BASE)
/* Legacy define */
#define COMP                ((COMP_TypeDef *) COMP_BASE)
#define OPAMP               ((OPAMP_TypeDef *) OPAMP_BASE)
#define OPAMP2              ((OPAMP_TypeDef *) OPAMP2_BASE)
#define SYSCFG              ((SYSCFG_TypeDef *) SYSCFG_BASE)
#define EXTI                ((EXTI_TypeDef *) EXTI_BASE)
#define TIM1                ((TIM_TypeDef *) TIM1_BASE)
#define SPI1                ((SPI_TypeDef *) SPI1_BASE)
#define USART1              ((USART_TypeDef *) USART1_BASE)
#define TIM15               ((TIM_TypeDef *) TIM15_BASE)
#define TIM16               ((TIM_TypeDef *) TIM16_BASE)
#define TIM17               ((TIM_TypeDef *) TIM17_BASE)
#define DBGMCU              ((DBGMCU_TypeDef *) DBGMCU_BASE)
#define DMA1                ((DMA_TypeDef *) DMA1_BASE)
#define DMA1_Channel1       ((DMA_Channel_TypeDef *) DMA1_Channel1_BASE)
#define DMA1_Channel2       ((DMA_Channel_TypeDef *) DMA1_Channel2_BASE)
#define DMA1_Channel3       ((DMA_Channel_TypeDef *) DMA1_Channel3_BASE)
#define DMA1_Channel4       ((DMA_Channel_TypeDef *) DMA1_Channel4_BASE)
#define DMA1_Channel5       ((DMA_Channel_TypeDef *) DMA1_Channel5_BASE)
#define DMA1_Channel6       ((DMA_Channel_TypeDef *) DMA1_Channel6_BASE)
#define DMA1_Channel7       ((DMA_Channel_TypeDef *) DMA1_Channel7_BASE)
#define RCC                 ((RCC_TypeDef *) RCC_BASE)
#define FLASH               ((FLASH_TypeDef *) FLASH_R_BASE)
#define OB                  ((OB_TypeDef *) OB_BASE)
#define CRC                 ((CRC_TypeDef *) CRC_BASE)
#define TSC                 ((TSC_TypeDef *) TSC_BASE)
#define GPIOA               ((GPIO_TypeDef *) GPIOA_BASE)
#define GPIOB               ((GPIO_TypeDef *) GPIOB_BASE)
#define GPIOC               ((GPIO_TypeDef *) GPIOC_BASE)
#define GPIOD               ((GPIO_TypeDef *) GPIOD_BASE)
#define GPIOF               ((GPIO_TypeDef *) GPIOF_BASE)
#define ADC1                ((ADC_TypeDef *) ADC1_BASE)
#define ADC2                ((ADC_TypeDef *) ADC2_BASE)
#define ADC12_COMMON        ((ADC_Common_TypeDef *) ADC1_2_COMMON_BASE)
/* Legacy defines */
#define ADC1_2_COMMON       ADC12_COMMON

/**
  * @}
  */

/** @addtogroup Exported_constants
  * @{
  */

  /** @addtogroup Peripheral_Registers_Bits_Definition
  * @{
  */

/******************************************************************************/
/*                         Peripheral Registers_Bits_Definition               */
/******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*                        Analog to Digital Converter SAR (ADC)               */
/*                                                                            */
/******************************************************************************/

#define ADC5_V1_1                                      /*!< ADC IP version */

/*
 * @brief Specific device feature definitions (not present on all devices in the STM32F3 serie)
 */
#define ADC_MULTIMODE_SUPPORT                          /*!< ADC feature available only on specific devices: multimode available on devices with several ADC instances */

/********************  Bit definition for ADC_ISR register  ********************/
#define ADC_ISR_ADRDY_Pos              (0U)                                    
#define ADC_ISR_ADRDY_Msk              (0x1U << ADC_ISR_ADRDY_Pos)             /*!< 0x00000001 */
#define ADC_ISR_ADRDY                  ADC_ISR_ADRDY_Msk                       /*!< ADC ready flag */
#define ADC_ISR_EOSMP_Pos              (1U)                                    
#define ADC_ISR_EOSMP_Msk              (0x1U << ADC_ISR_EOSMP_Pos)             /*!< 0x00000002 */
#define ADC_ISR_EOSMP                  ADC_ISR_EOSMP_Msk                       /*!< ADC group regular end of sampling flag */
#define ADC_ISR_EOC_Pos                (2U)                                    
#define ADC_ISR_EOC_Msk                (0x1U << ADC_ISR_EOC_Pos)               /*!< 0x00000004 */
#define ADC_ISR_EOC                    ADC_ISR_EOC_Msk                         /*!< ADC group regular end of unitary conversion flag */
#define ADC_ISR_EOS_Pos                (3U)                                    
#define ADC_ISR_EOS_Msk                (0x1U << ADC_ISR_EOS_Pos)               /*!< 0x00000008 */
#define ADC_ISR_EOS                    ADC_ISR_EOS_Msk                         /*!< ADC group regular end of sequence conversions flag */
#define ADC_ISR_OVR_Pos                (4U)                                    
#define ADC_ISR_OVR_Msk                (0x1U << ADC_ISR_OVR_Pos)               /*!< 0x00000010 */
#define ADC_ISR_OVR                    ADC_ISR_OVR_Msk                         /*!< ADC group regular overrun flag */
#define ADC_ISR_JEOC_Pos               (5U)                                    
#define ADC_ISR_JEOC_Msk               (0x1U << ADC_ISR_JEOC_Pos)              /*!< 0x00000020 */
#define ADC_ISR_JEOC                   ADC_ISR_JEOC_Msk                        /*!< ADC group injected end of unitary conversion flag */
#define ADC_ISR_JEOS_Pos               (6U)                                    
#define ADC_ISR_JEOS_Msk               (0x1U << ADC_ISR_JEOS_Pos)              /*!< 0x00000040 */
#define ADC_ISR_JEOS                   ADC_ISR_JEOS_Msk                        /*!< ADC group injected end of sequence conversions flag */
#define ADC_ISR_AWD1_Pos               (7U)                                    
#define ADC_ISR_AWD1_Msk               (0x1U << ADC_ISR_AWD1_Pos)              /*!< 0x00000080 */
#define ADC_ISR_AWD1                   ADC_ISR_AWD1_Msk                        /*!< ADC analog watchdog 1 flag */
#define ADC_ISR_AWD2_Pos               (8U)                                    
#define ADC_ISR_AWD2_Msk               (0x1U << ADC_ISR_AWD2_Pos)              /*!< 0x00000100 */
#define ADC_ISR_AWD2                   ADC_ISR_AWD2_Msk                        /*!< ADC analog watchdog 2 flag */
#define ADC_ISR_AWD3_Pos               (9U)                                    
#define ADC_ISR_AWD3_Msk               (0x1U << ADC_ISR_AWD3_Pos)              /*!< 0x00000200 */
#define ADC_ISR_AWD3                   ADC_ISR_AWD3_Msk                        /*!< ADC analog watchdog 3 flag */
#define ADC_ISR_JQOVF_Pos              (10U)                                   
#define ADC_ISR_JQOVF_Msk              (0x1U << ADC_ISR_JQOVF_Pos)             /*!< 0x00000400 */
#define ADC_ISR_JQOVF                  ADC_ISR_JQOVF_Msk                       /*!< ADC group injected contexts queue overflow flag */

/* Legacy defines */
#define ADC_ISR_ADRD            (ADC_ISR_ADRDY)

/********************  Bit definition for ADC_IER register  ********************/
#define ADC_IER_ADRDYIE_Pos            (0U)                                    
#define ADC_IER_ADRDYIE_Msk            (0x1U << ADC_IER_ADRDYIE_Pos)           /*!< 0x00000001 */
#define ADC_IER_ADRDYIE                ADC_IER_ADRDYIE_Msk                     /*!< ADC ready interrupt */
#define ADC_IER_EOSMPIE_Pos            (1U)                                    
#define ADC_IER_EOSMPIE_Msk            (0x1U << ADC_IER_EOSMPIE_Pos)           /*!< 0x00000002 */
#define ADC_IER_EOSMPIE                ADC_IER_EOSMPIE_Msk                     /*!< ADC group regular end of sampling interrupt */
#define ADC_IER_EOCIE_Pos              (2U)                                    
#define ADC_IER_EOCIE_Msk              (0x1U << ADC_IER_EOCIE_Pos)             /*!< 0x00000004 */
#define ADC_IER_EOCIE                  ADC_IER_EOCIE_Msk                       /*!< ADC group regular end of unitary conversion interrupt */
#define ADC_IER_EOSIE_Pos              (3U)                                    
#define ADC_IER_EOSIE_Msk              (0x1U << ADC_IER_EOSIE_Pos)             /*!< 0x00000008 */
#define ADC_IER_EOSIE                  ADC_IER_EOSIE_Msk                       /*!< ADC group regular end of sequence conversions interrupt */
#define ADC_IER_OVRIE_Pos              (4U)                                    
#define ADC_IER_OVRIE_Msk              (0x1U << ADC_IER_OVRIE_Pos)             /*!< 0x00000010 */
#define ADC_IER_OVRIE                  ADC_IER_OVRIE_Msk                       /*!< ADC group regular overrun interrupt */
#define ADC_IER_JEOCIE_Pos             (5U)                                    
#define ADC_IER_JEOCIE_Msk             (0x1U << ADC_IER_JEOCIE_Pos)            /*!< 0x00000020 */
#define ADC_IER_JEOCIE                 ADC_IER_JEOCIE_Msk                      /*!< ADC group injected end of unitary conversion interrupt */
#define ADC_IER_JEOSIE_Pos             (6U)                                    
#define ADC_IER_JEOSIE_Msk             (0x1U << ADC_IER_JEOSIE_Pos)            /*!< 0x00000040 */
#define ADC_IER_JEOSIE                 ADC_IER_JEOSIE_Msk                      /*!< ADC group injected end of sequence conversions interrupt */
#define ADC_IER_AWD1IE_Pos             (7U)                                    
#define ADC_IER_AWD1IE_Msk             (0x1U << ADC_IER_AWD1IE_Pos)            /*!< 0x00000080 */
#define ADC_IER_AWD1IE                 ADC_IER_AWD1IE_Msk                      /*!< ADC analog watchdog 1 interrupt */
#define ADC_IER_AWD2IE_Pos             (8U)                                    
#define ADC_IER_AWD2IE_Msk             (0x1U << ADC_IER_AWD2IE_Pos)            /*!< 0x00000100 */
#define ADC_IER_AWD2IE                 ADC_IER_AWD2IE_Msk                      /*!< ADC analog watchdog 2 interrupt */
#define ADC_IER_AWD3IE_Pos             (9U)                                    
#define ADC_IER_AWD3IE_Msk             (0x1U << ADC_IER_AWD3IE_Pos)            /*!< 0x00000200 */
#define ADC_IER_AWD3IE                 ADC_IER_AWD3IE_Msk                      /*!< ADC analog watchdog 3 interrupt */
#define ADC_IER_JQOVFIE_Pos            (10U)                                   
#define ADC_IER_JQOVFIE_Msk            (0x1U << ADC_IER_JQOVFIE_Pos)           /*!< 0x00000400 */
#define ADC_IER_JQOVFIE                ADC_IER_JQOVFIE_Msk                     /*!< ADC group injected contexts queue overflow interrupt */

/* Legacy defines */
#define ADC_IER_RDY             (ADC_IER_ADRDYIE)
#define ADC_IER_EOSMP           (ADC_IER_EOSMPIE)
#define ADC_IER_EOC             (ADC_IER_EOCIE)
#define ADC_IER_EOS             (ADC_IER_EOSIE)
#define ADC_IER_OVR             (ADC_IER_OVRIE)
#define ADC_IER_JEOC            (ADC_IER_JEOCIE)
#define ADC_IER_JEOS            (ADC_IER_JEOSIE)
#define ADC_IER_AWD1            (ADC_IER_AWD1IE)
#define ADC_IER_AWD2            (ADC_IER_AWD2IE)
#define ADC_IER_AWD3            (ADC_IER_AWD3IE)
#define ADC_IER_JQOVF           (ADC_IER_JQOVFIE)

/********************  Bit definition for ADC_CR register  ********************/
#define ADC_CR_ADEN_Pos                (0U)                                    
#define ADC_CR_ADEN_Msk                (0x1U << ADC_CR_ADEN_Pos)               /*!< 0x00000001 */
#define ADC_CR_ADEN                    ADC_CR_ADEN_Msk                         /*!< ADC enable */
#define ADC_CR_ADDIS_Pos               (1U)                                    
#define ADC_CR_ADDIS_Msk               (0x1U << ADC_CR_ADDIS_Pos)              /*!< 0x00000002 */
#define ADC_CR_ADDIS                   ADC_CR_ADDIS_Msk                        /*!< ADC disable */
#define ADC_CR_ADSTART_Pos             (2U)                                    
#define ADC_CR_ADSTART_Msk             (0x1U << ADC_CR_ADSTART_Pos)            /*!< 0x00000004 */
#define ADC_CR_ADSTART                 ADC_CR_ADSTART_Msk                      /*!< ADC group regular conversion start */
#define ADC_CR_JADSTART_Pos            (3U)                                    
#define ADC_CR_JADSTART_Msk            (0x1U << ADC_CR_JADSTART_Pos)           /*!< 0x00000008 */
#define ADC_CR_JADSTART                ADC_CR_JADSTART_Msk                     /*!< ADC group injected conversion start */
#define ADC_CR_ADSTP_Pos               (4U)                                    
#define ADC_CR_ADSTP_Msk               (0x1U << ADC_CR_ADSTP_Pos)              /*!< 0x00000010 */
#define ADC_CR_ADSTP                   ADC_CR_ADSTP_Msk                        /*!< ADC group regular conversion stop */
#define ADC_CR_JADSTP_Pos              (5U)                                    
#define ADC_CR_JADSTP_Msk              (0x1U << ADC_CR_JADSTP_Pos)             /*!< 0x00000020 */
#define ADC_CR_JADSTP                  ADC_CR_JADSTP_Msk                       /*!< ADC group injected conversion stop */
#define ADC_CR_ADVREGEN_Pos            (28U)                                   
#define ADC_CR_ADVREGEN_Msk            (0x3U << ADC_CR_ADVREGEN_Pos)           /*!< 0x30000000 */
#define ADC_CR_ADVREGEN                ADC_CR_ADVREGEN_Msk                     /*!< ADC voltage regulator enable */
#define ADC_CR_ADVREGEN_0              (0x1U << ADC_CR_ADVREGEN_Pos)           /*!< 0x10000000 */
#define ADC_CR_ADVREGEN_1              (0x2U << ADC_CR_ADVREGEN_Pos)           /*!< 0x20000000 */
#define ADC_CR_ADCALDIF_Pos            (30U)                                   
#define ADC_CR_ADCALDIF_Msk            (0x1U << ADC_CR_ADCALDIF_Pos)           /*!< 0x40000000 */
#define ADC_CR_ADCALDIF                ADC_CR_ADCALDIF_Msk                     /*!< ADC differential mode for calibration */
#define ADC_CR_ADCAL_Pos               (31U)                                   
#define ADC_CR_ADCAL_Msk               (0x1U << ADC_CR_ADCAL_Pos)              /*!< 0x80000000 */
#define ADC_CR_ADCAL                   ADC_CR_ADCAL_Msk                        /*!< ADC calibration */

/********************  Bit definition for ADC_CFGR register  ******************/
#define ADC_CFGR_DMAEN_Pos             (0U)                                    
#define ADC_CFGR_DMAEN_Msk             (0x1U << ADC_CFGR_DMAEN_Pos)            /*!< 0x00000001 */
#define ADC_CFGR_DMAEN                 ADC_CFGR_DMAEN_Msk                      /*!< ADC DMA enable */
#define ADC_CFGR_DMACFG_Pos            (1U)                                    
#define ADC_CFGR_DMACFG_Msk            (0x1U << ADC_CFGR_DMACFG_Pos)           /*!< 0x00000002 */
#define ADC_CFGR_DMACFG                ADC_CFGR_DMACFG_Msk                     /*!< ADC DMA configuration */

#define ADC_CFGR_RES_Pos               (3U)                                    
#define ADC_CFGR_RES_Msk               (0x3U << ADC_CFGR_RES_Pos)              /*!< 0x00000018 */
#define ADC_CFGR_RES                   ADC_CFGR_RES_Msk                        /*!< ADC data resolution */
#define ADC_CFGR_RES_0                 (0x1U << ADC_CFGR_RES_Pos)              /*!< 0x00000008 */
#define ADC_CFGR_RES_1                 (0x2U << ADC_CFGR_RES_Pos)              /*!< 0x00000010 */

#define ADC_CFGR_ALIGN_Pos             (5U)                                    
#define ADC_CFGR_ALIGN_Msk             (0x1U << ADC_CFGR_ALIGN_Pos)            /*!< 0x00000020 */
#define ADC_CFGR_ALIGN                 ADC_CFGR_ALIGN_Msk                      /*!< ADC data alignement */

#define ADC_CFGR_EXTSEL_Pos            (6U)                                    
#define ADC_CFGR_EXTSEL_Msk            (0xFU << ADC_CFGR_EXTSEL_Pos)           /*!< 0x000003C0 */
#define ADC_CFGR_EXTSEL                ADC_CFGR_EXTSEL_Msk                     /*!< ADC group regular external trigger source */
#define ADC_CFGR_EXTSEL_0              (0x1U << ADC_CFGR_EXTSEL_Pos)           /*!< 0x00000040 */
#define ADC_CFGR_EXTSEL_1              (0x2U << ADC_CFGR_EXTSEL_Pos)           /*!< 0x00000080 */
#define ADC_CFGR_EXTSEL_2              (0x4U << ADC_CFGR_EXTSEL_Pos)           /*!< 0x00000100 */
#define ADC_CFGR_EXTSEL_3              (0x8U << ADC_CFGR_EXTSEL_Pos)           /*!< 0x00000200 */

#define ADC_CFGR_EXTEN_Pos             (10U)                                   
#define ADC_CFGR_EXTEN_Msk             (0x3U << ADC_CFGR_EXTEN_Pos)            /*!< 0x00000C00 */
#define ADC_CFGR_EXTEN                 ADC_CFGR_EXTEN_Msk                      /*!< ADC group regular external trigger polarity */
#define ADC_CFGR_EXTEN_0               (0x1U << ADC_CFGR_EXTEN_Pos)            /*!< 0x00000400 */
#define ADC_CFGR_EXTEN_1               (0x2U << ADC_CFGR_EXTEN_Pos)            /*!< 0x00000800 */

#define ADC_CFGR_OVRMOD_Pos            (12U)                                   
#define ADC_CFGR_OVRMOD_Msk            (0x1U << ADC_CFGR_OVRMOD_Pos)           /*!< 0x00001000 */
#define ADC_CFGR_OVRMOD                ADC_CFGR_OVRMOD_Msk                     /*!< ADC group regular overrun configuration */
#define ADC_CFGR_CONT_Pos              (13U)                                   
#define ADC_CFGR_CONT_Msk              (0x1U << ADC_CFGR_CONT_Pos)             /*!< 0x00002000 */
#define ADC_CFGR_CONT                  ADC_CFGR_CONT_Msk                       /*!< ADC group regular continuous conversion mode */
#define ADC_CFGR_AUTDLY_Pos            (14U)                                   
#define ADC_CFGR_AUTDLY_Msk            (0x1U << ADC_CFGR_AUTDLY_Pos)           /*!< 0x00004000 */
#define ADC_CFGR_AUTDLY                ADC_CFGR_AUTDLY_Msk                     /*!< ADC low power auto wait */

#define ADC_CFGR_DISCEN_Pos            (16U)                                   
#define ADC_CFGR_DISCEN_Msk            (0x1U << ADC_CFGR_DISCEN_Pos)           /*!< 0x00010000 */
#define ADC_CFGR_DISCEN                ADC_CFGR_DISCEN_Msk                     /*!< ADC group regular sequencer discontinuous mode */

#define ADC_CFGR_DISCNUM_Pos           (17U)                                   
#define ADC_CFGR_DISCNUM_Msk           (0x7U << ADC_CFGR_DISCNUM_Pos)          /*!< 0x000E0000 */
#define ADC_CFGR_DISCNUM               ADC_CFGR_DISCNUM_Msk                    /*!< ADC Discontinuous mode channel count */
#define ADC_CFGR_DISCNUM_0             (0x1U << ADC_CFGR_DISCNUM_Pos)          /*!< 0x00020000 */
#define ADC_CFGR_DISCNUM_1             (0x2U << ADC_CFGR_DISCNUM_Pos)          /*!< 0x00040000 */
#define ADC_CFGR_DISCNUM_2             (0x4U << ADC_CFGR_DISCNUM_Pos)          /*!< 0x00080000 */

#define ADC_CFGR_JDISCEN_Pos           (20U)                                   
#define ADC_CFGR_JDISCEN_Msk           (0x1U << ADC_CFGR_JDISCEN_Pos)          /*!< 0x00100000 */
#define ADC_CFGR_JDISCEN               ADC_CFGR_JDISCEN_Msk                    /*!< ADC Discontinuous mode on injected channels */
#define ADC_CFGR_JQM_Pos               (21U)                                   
#define ADC_CFGR_JQM_Msk               (0x1U << ADC_CFGR_JQM_Pos)              /*!< 0x00200000 */
#define ADC_CFGR_JQM                   ADC_CFGR_JQM_Msk                        /*!< ADC group injected contexts queue mode */
#define ADC_CFGR_AWD1SGL_Pos           (22U)                                   
#define ADC_CFGR_AWD1SGL_Msk           (0x1U << ADC_CFGR_AWD1SGL_Pos)          /*!< 0x00400000 */
#define ADC_CFGR_AWD1SGL               ADC_CFGR_AWD1SGL_Msk                    /*!< ADC analog watchdog 1 monitoring a single channel or all channels */
#define ADC_CFGR_AWD1EN_Pos            (23U)                                   
#define ADC_CFGR_AWD1EN_Msk            (0x1U << ADC_CFGR_AWD1EN_Pos)           /*!< 0x00800000 */
#define ADC_CFGR_AWD1EN                ADC_CFGR_AWD1EN_Msk                     /*!< ADC analog watchdog 1 enable on scope ADC group regular */
#define ADC_CFGR_JAWD1EN_Pos           (24U)                                   
#define ADC_CFGR_JAWD1EN_Msk           (0x1U << ADC_CFGR_JAWD1EN_Pos)          /*!< 0x01000000 */
#define ADC_CFGR_JAWD1EN               ADC_CFGR_JAWD1EN_Msk                    /*!< ADC analog watchdog 1 enable on scope ADC group injected */
#define ADC_CFGR_JAUTO_Pos             (25U)                                   
#define ADC_CFGR_JAUTO_Msk             (0x1U << ADC_CFGR_JAUTO_Pos)            /*!< 0x02000000 */
#define ADC_CFGR_JAUTO                 ADC_CFGR_JAUTO_Msk                      /*!< ADC group injected automatic trigger mode */

#define ADC_CFGR_AWD1CH_Pos            (26U)                                   
#define ADC_CFGR_AWD1CH_Msk            (0x1FU << ADC_CFGR_AWD1CH_Pos)          /*!< 0x7C000000 */
#define ADC_CFGR_AWD1CH                ADC_CFGR_AWD1CH_Msk                     /*!< ADC analog watchdog 1 monitored channel selection */
#define ADC_CFGR_AWD1CH_0              (0x01U << ADC_CFGR_AWD1CH_Pos)          /*!< 0x04000000 */
#define ADC_CFGR_AWD1CH_1              (0x02U << ADC_CFGR_AWD1CH_Pos)          /*!< 0x08000000 */
#define ADC_CFGR_AWD1CH_2              (0x04U << ADC_CFGR_AWD1CH_Pos)          /*!< 0x10000000 */
#define ADC_CFGR_AWD1CH_3              (0x08U << ADC_CFGR_AWD1CH_Pos)          /*!< 0x20000000 */
#define ADC_CFGR_AWD1CH_4              (0x10U << ADC_CFGR_AWD1CH_Pos)          /*!< 0x40000000 */

/* Legacy defines */
#define ADC_CFGR_AUTOFF_Pos            (15U)                                   
#define ADC_CFGR_AUTOFF_Msk            (0x1U << ADC_CFGR_AUTOFF_Pos)           /*!< 0x00008000 */
#define ADC_CFGR_AUTOFF                ADC_CFGR_AUTOFF_Msk                     /*!< ADC low power auto power off */

/********************  Bit definition for ADC_SMPR1 register  *****************/
#define ADC_SMPR1_SMP0_Pos             (0U)                                    
#define ADC_SMPR1_SMP0_Msk             (0x7U << ADC_SMPR1_SMP0_Pos)            /*!< 0x00000007 */
#define ADC_SMPR1_SMP0                 ADC_SMPR1_SMP0_Msk                      /*!< ADC channel 0 sampling time selection  */
#define ADC_SMPR1_SMP0_0               (0x1U << ADC_SMPR1_SMP0_Pos)            /*!< 0x00000001 */
#define ADC_SMPR1_SMP0_1               (0x2U << ADC_SMPR1_SMP0_Pos)            /*!< 0x00000002 */
#define ADC_SMPR1_SMP0_2               (0x4U << ADC_SMPR1_SMP0_Pos)            /*!< 0x00000004 */

#define ADC_SMPR1_SMP1_Pos             (3U)                                    
#define ADC_SMPR1_SMP1_Msk             (0x7U << ADC_SMPR1_SMP1_Pos)            /*!< 0x00000038 */
#define ADC_SMPR1_SMP1                 ADC_SMPR1_SMP1_Msk                      /*!< ADC channel 1 sampling time selection  */
#define ADC_SMPR1_SMP1_0               (0x1U << ADC_SMPR1_SMP1_Pos)            /*!< 0x00000008 */
#define ADC_SMPR1_SMP1_1               (0x2U << ADC_SMPR1_SMP1_Pos)            /*!< 0x00000010 */
#define ADC_SMPR1_SMP1_2               (0x4U << ADC_SMPR1_SMP1_Pos)            /*!< 0x00000020 */

#define ADC_SMPR1_SMP2_Pos             (6U)                                    
#define ADC_SMPR1_SMP2_Msk             (0x7U << ADC_SMPR1_SMP2_Pos)            /*!< 0x000001C0 */
#define ADC_SMPR1_SMP2                 ADC_SMPR1_SMP2_Msk                      /*!< ADC channel 2 sampling time selection  */
#define ADC_SMPR1_SMP2_0               (0x1U << ADC_SMPR1_SMP2_Pos)            /*!< 0x00000040 */
#define ADC_SMPR1_SMP2_1               (0x2U << ADC_SMPR1_SMP2_Pos)            /*!< 0x00000080 */
#define ADC_SMPR1_SMP2_2               (0x4U << ADC_SMPR1_SMP2_Pos)            /*!< 0x00000100 */

#define ADC_SMPR1_SMP3_Pos             (9U)                                    
#define ADC_SMPR1_SMP3_Msk             (0x7U << ADC_SMPR1_SMP3_Pos)            /*!< 0x00000E00 */
#define ADC_SMPR1_SMP3                 ADC_SMPR1_SMP3_Msk                      /*!< ADC channel 3 sampling time selection  */
#define ADC_SMPR1_SMP3_0               (0x1U << ADC_SMPR1_SMP3_Pos)            /*!< 0x00000200 */
#define ADC_SMPR1_SMP3_1               (0x2U << ADC_SMPR1_SMP3_Pos)            /*!< 0x00000400 */
#define ADC_SMPR1_SMP3_2               (0x4U << ADC_SMPR1_SMP3_Pos)            /*!< 0x00000800 */

#define ADC_SMPR1_SMP4_Pos             (12U)                                   
#define ADC_SMPR1_SMP4_Msk             (0x7U << ADC_SMPR1_SMP4_Pos)            /*!< 0x00007000 */
#define ADC_SMPR1_SMP4                 ADC_SMPR1_SMP4_Msk                      /*!< ADC channel 4 sampling time selection  */
#define ADC_SMPR1_SMP4_0               (0x1U << ADC_SMPR1_SMP4_Pos)            /*!< 0x00001000 */
#define ADC_SMPR1_SMP4_1               (0x2U << ADC_SMPR1_SMP4_Pos)            /*!< 0x00002000 */
#define ADC_SMPR1_SMP4_2               (0x4U << ADC_SMPR1_SMP4_Pos)            /*!< 0x00004000 */

#define ADC_SMPR1_SMP5_Pos             (15U)                                   
#define ADC_SMPR1_SMP5_Msk             (0x7U << ADC_SMPR1_SMP5_Pos)            /*!< 0x00038000 */
#define ADC_SMPR1_SMP5                 ADC_SMPR1_SMP5_Msk                      /*!< ADC channel 5 sampling time selection  */
#define ADC_SMPR1_SMP5_0               (0x1U << ADC_SMPR1_SMP5_Pos)            /*!< 0x00008000 */
#define ADC_SMPR1_SMP5_1               (0x2U << ADC_SMPR1_SMP5_Pos)            /*!< 0x00010000 */
#define ADC_SMPR1_SMP5_2               (0x4U << ADC_SMPR1_SMP5_Pos)            /*!< 0x00020000 */

#define ADC_SMPR1_SMP6_Pos             (18U)                                   
#define ADC_SMPR1_SMP6_Msk             (0x7U << ADC_SMPR1_SMP6_Pos)            /*!< 0x001C0000 */
#define ADC_SMPR1_SMP6                 ADC_SMPR1_SMP6_Msk                      /*!< ADC channel 6 sampling time selection  */
#define ADC_SMPR1_SMP6_0               (0x1U << ADC_SMPR1_SMP6_Pos)            /*!< 0x00040000 */
#define ADC_SMPR1_SMP6_1               (0x2U << ADC_SMPR1_SMP6_Pos)            /*!< 0x00080000 */
#define ADC_SMPR1_SMP6_2               (0x4U << ADC_SMPR1_SMP6_Pos)            /*!< 0x00100000 */

#define ADC_SMPR1_SMP7_Pos             (21U)                                   
#define ADC_SMPR1_SMP7_Msk             (0x7U << ADC_SMPR1_SMP7_Pos)            /*!< 0x00E00000 */
#define ADC_SMPR1_SMP7                 ADC_SMPR1_SMP7_Msk                      /*!< ADC channel 7 sampling time selection  */
#define ADC_SMPR1_SMP7_0               (0x1U << ADC_SMPR1_SMP7_Pos)            /*!< 0x00200000 */
#define ADC_SMPR1_SMP7_1               (0x2U << ADC_SMPR1_SMP7_Pos)            /*!< 0x00400000 */
#define ADC_SMPR1_SMP7_2               (0x4U << ADC_SMPR1_SMP7_Pos)            /*!< 0x00800000 */

#define ADC_SMPR1_SMP8_Pos             (24U)                                   
#define ADC_SMPR1_SMP8_Msk             (0x7U << ADC_SMPR1_SMP8_Pos)            /*!< 0x07000000 */
#define ADC_SMPR1_SMP8                 ADC_SMPR1_SMP8_Msk                      /*!< ADC channel 8 sampling time selection  */
#define ADC_SMPR1_SMP8_0               (0x1U << ADC_SMPR1_SMP8_Pos)            /*!< 0x01000000 */
#define ADC_SMPR1_SMP8_1               (0x2U << ADC_SMPR1_SMP8_Pos)            /*!< 0x02000000 */
#define ADC_SMPR1_SMP8_2               (0x4U << ADC_SMPR1_SMP8_Pos)            /*!< 0x04000000 */

#define ADC_SMPR1_SMP9_Pos             (27U)                                   
#define ADC_SMPR1_SMP9_Msk             (0x7U << ADC_SMPR1_SMP9_Pos)            /*!< 0x38000000 */
#define ADC_SMPR1_SMP9                 ADC_SMPR1_SMP9_Msk                      /*!< ADC channel 9 sampling time selection  */
#define ADC_SMPR1_SMP9_0               (0x1U << ADC_SMPR1_SMP9_Pos)            /*!< 0x08000000 */
#define ADC_SMPR1_SMP9_1               (0x2U << ADC_SMPR1_SMP9_Pos)            /*!< 0x10000000 */
#define ADC_SMPR1_SMP9_2               (0x4U << ADC_SMPR1_SMP9_Pos)            /*!< 0x20000000 */

/********************  Bit definition for ADC_SMPR2 register  *****************/
#define ADC_SMPR2_SMP10_Pos            (0U)                                    
#define ADC_SMPR2_SMP10_Msk            (0x7U << ADC_SMPR2_SMP10_Pos)           /*!< 0x00000007 */
#define ADC_SMPR2_SMP10                ADC_SMPR2_SMP10_Msk                     /*!< ADC channel 10 sampling time selection  */
#define ADC_SMPR2_SMP10_0              (0x1U << ADC_SMPR2_SMP10_Pos)           /*!< 0x00000001 */
#define ADC_SMPR2_SMP10_1              (0x2U << ADC_SMPR2_SMP10_Pos)           /*!< 0x00000002 */
#define ADC_SMPR2_SMP10_2              (0x4U << ADC_SMPR2_SMP10_Pos)           /*!< 0x00000004 */

#define ADC_SMPR2_SMP11_Pos            (3U)                                    
#define ADC_SMPR2_SMP11_Msk            (0x7U << ADC_SMPR2_SMP11_Pos)           /*!< 0x00000038 */
#define ADC_SMPR2_SMP11                ADC_SMPR2_SMP11_Msk                     /*!< ADC channel 11 sampling time selection  */
#define ADC_SMPR2_SMP11_0              (0x1U << ADC_SMPR2_SMP11_Pos)           /*!< 0x00000008 */
#define ADC_SMPR2_SMP11_1              (0x2U << ADC_SMPR2_SMP11_Pos)           /*!< 0x00000010 */
#define ADC_SMPR2_SMP11_2              (0x4U << ADC_SMPR2_SMP11_Pos)           /*!< 0x00000020 */

#define ADC_SMPR2_SMP12_Pos            (6U)                                    
#define ADC_SMPR2_SMP12_Msk            (0x7U << ADC_SMPR2_SMP12_Pos)           /*!< 0x000001C0 */
#define ADC_SMPR2_SMP12                ADC_SMPR2_SMP12_Msk                     /*!< ADC channel 12 sampling time selection  */
#define ADC_SMPR2_SMP12_0              (0x1U << ADC_SMPR2_SMP12_Pos)           /*!< 0x00000040 */
#define ADC_SMPR2_SMP12_1              (0x2U << ADC_SMPR2_SMP12_Pos)           /*!< 0x00000080 */
#define ADC_SMPR2_SMP12_2              (0x4U << ADC_SMPR2_SMP12_Pos)           /*!< 0x00000100 */

#define ADC_SMPR2_SMP13_Pos            (9U)                                    
#define ADC_SMPR2_SMP13_Msk            (0x7U << ADC_SMPR2_SMP13_Pos)           /*!< 0x00000E00 */
#define ADC_SMPR2_SMP13                ADC_SMPR2_SMP13_Msk                     /*!< ADC channel 13 sampling time selection  */
#define ADC_SMPR2_SMP13_0              (0x1U << ADC_SMPR2_SMP13_Pos)           /*!< 0x00000200 */
#define ADC_SMPR2_SMP13_1              (0x2U << ADC_SMPR2_SMP13_Pos)           /*!< 0x00000400 */
#define ADC_SMPR2_SMP13_2              (0x4U << ADC_SMPR2_SMP13_Pos)           /*!< 0x00000800 */

#define ADC_SMPR2_SMP14_Pos            (12U)                                   
#define ADC_SMPR2_SMP14_Msk            (0x7U << ADC_SMPR2_SMP14_Pos)           /*!< 0x00007000 */
#define ADC_SMPR2_SMP14                ADC_SMPR2_SMP14_Msk                     /*!< ADC channel 14 sampling time selection  */
#define ADC_SMPR2_SMP14_0              (0x1U << ADC_SMPR2_SMP14_Pos)           /*!< 0x00001000 */
#define ADC_SMPR2_SMP14_1              (0x2U << ADC_SMPR2_SMP14_Pos)           /*!< 0x00002000 */
#define ADC_SMPR2_SMP14_2              (0x4U << ADC_SMPR2_SMP14_Pos)           /*!< 0x00004000 */

#define ADC_SMPR2_SMP15_Pos            (15U)                                   
#define ADC_SMPR2_SMP15_Msk            (0x7U << ADC_SMPR2_SMP15_Pos)           /*!< 0x00038000 */
#define ADC_SMPR2_SMP15                ADC_SMPR2_SMP15_Msk                     /*!< ADC channel 15 sampling time selection  */
#define ADC_SMPR2_SMP15_0              (0x1U << ADC_SMPR2_SMP15_Pos)           /*!< 0x00008000 */
#define ADC_SMPR2_SMP15_1              (0x2U << ADC_SMPR2_SMP15_Pos)           /*!< 0x00010000 */
#define ADC_SMPR2_SMP15_2              (0x4U << ADC_SMPR2_SMP15_Pos)           /*!< 0x00020000 */

#define ADC_SMPR2_SMP16_Pos            (18U)                                   
#define ADC_SMPR2_SMP16_Msk            (0x7U << ADC_SMPR2_SMP16_Pos)           /*!< 0x001C0000 */
#define ADC_SMPR2_SMP16                ADC_SMPR2_SMP16_Msk                     /*!< ADC channel 16 sampling time selection  */
#define ADC_SMPR2_SMP16_0              (0x1U << ADC_SMPR2_SMP16_Pos)           /*!< 0x00040000 */
#define ADC_SMPR2_SMP16_1              (0x2U << ADC_SMPR2_SMP16_Pos)           /*!< 0x00080000 */
#define ADC_SMPR2_SMP16_2              (0x4U << ADC_SMPR2_SMP16_Pos)           /*!< 0x00100000 */

#define ADC_SMPR2_SMP17_Pos            (21U)                                   
#define ADC_SMPR2_SMP17_Msk            (0x7U << ADC_SMPR2_SMP17_Pos)           /*!< 0x00E00000 */
#define ADC_SMPR2_SMP17                ADC_SMPR2_SMP17_Msk                     /*!< ADC channel 17 sampling time selection  */
#define ADC_SMPR2_SMP17_0              (0x1U << ADC_SMPR2_SMP17_Pos)           /*!< 0x00200000 */
#define ADC_SMPR2_SMP17_1              (0x2U << ADC_SMPR2_SMP17_Pos)           /*!< 0x00400000 */
#define ADC_SMPR2_SMP17_2              (0x4U << ADC_SMPR2_SMP17_Pos)           /*!< 0x00800000 */

#define ADC_SMPR2_SMP18_Pos            (24U)                                   
#define ADC_SMPR2_SMP18_Msk            (0x7U << ADC_SMPR2_SMP18_Pos)           /*!< 0x07000000 */
#define ADC_SMPR2_SMP18                ADC_SMPR2_SMP18_Msk                     /*!< ADC channel 18 sampling time selection  */
#define ADC_SMPR2_SMP18_0              (0x1U << ADC_SMPR2_SMP18_Pos)           /*!< 0x01000000 */
#define ADC_SMPR2_SMP18_1              (0x2U << ADC_SMPR2_SMP18_Pos)           /*!< 0x02000000 */
#define ADC_SMPR2_SMP18_2              (0x4U << ADC_SMPR2_SMP18_Pos)           /*!< 0x04000000 */

/********************  Bit definition for ADC_TR1 register  *******************/
#define ADC_TR1_LT1_Pos                (0U)                                    
#define ADC_TR1_LT1_Msk                (0xFFFU << ADC_TR1_LT1_Pos)             /*!< 0x00000FFF */
#define ADC_TR1_LT1                    ADC_TR1_LT1_Msk                         /*!< ADC analog watchdog 1 threshold low */
#define ADC_TR1_LT1_0                  (0x001U << ADC_TR1_LT1_Pos)             /*!< 0x00000001 */
#define ADC_TR1_LT1_1                  (0x002U << ADC_TR1_LT1_Pos)             /*!< 0x00000002 */
#define ADC_TR1_LT1_2                  (0x004U << ADC_TR1_LT1_Pos)             /*!< 0x00000004 */
#define ADC_TR1_LT1_3                  (0x008U << ADC_TR1_LT1_Pos)             /*!< 0x00000008 */
#define ADC_TR1_LT1_4                  (0x010U << ADC_TR1_LT1_Pos)             /*!< 0x00000010 */
#define ADC_TR1_LT1_5                  (0x020U << ADC_TR1_LT1_Pos)             /*!< 0x00000020 */
#define ADC_TR1_LT1_6                  (0x040U << ADC_TR1_LT1_Pos)             /*!< 0x00000040 */
#define ADC_TR1_LT1_7                  (0x080U << ADC_TR1_LT1_Pos)             /*!< 0x00000080 */
#define ADC_TR1_LT1_8                  (0x100U << ADC_TR1_LT1_Pos)             /*!< 0x00000100 */
#define ADC_TR1_LT1_9                  (0x200U << ADC_TR1_LT1_Pos)             /*!< 0x00000200 */
#define ADC_TR1_LT1_10                 (0x400U << ADC_TR1_LT1_Pos)             /*!< 0x00000400 */
#define ADC_TR1_LT1_11                 (0x800U << ADC_TR1_LT1_Pos)             /*!< 0x00000800 */

#define ADC_TR1_HT1_Pos                (16U)                                   
#define ADC_TR1_HT1_Msk                (0xFFFU << ADC_TR1_HT1_Pos)             /*!< 0x0FFF0000 */
#define ADC_TR1_HT1                    ADC_TR1_HT1_Msk                         /*!< ADC Analog watchdog 1 threshold high */
#define ADC_TR1_HT1_0                  (0x001U << ADC_TR1_HT1_Pos)             /*!< 0x00010000 */
#define ADC_TR1_HT1_1                  (0x002U << ADC_TR1_HT1_Pos)             /*!< 0x00020000 */
#define ADC_TR1_HT1_2                  (0x004U << ADC_TR1_HT1_Pos)             /*!< 0x00040000 */
#define ADC_TR1_HT1_3                  (0x008U << ADC_TR1_HT1_Pos)             /*!< 0x00080000 */
#define ADC_TR1_HT1_4                  (0x010U << ADC_TR1_HT1_Pos)             /*!< 0x00100000 */
#define ADC_TR1_HT1_5                  (0x020U << ADC_TR1_HT1_Pos)             /*!< 0x00200000 */
#define ADC_TR1_HT1_6                  (0x040U << ADC_TR1_HT1_Pos)             /*!< 0x00400000 */
#define ADC_TR1_HT1_7                  (0x080U << ADC_TR1_HT1_Pos)             /*!< 0x00800000 */
#define ADC_TR1_HT1_8                  (0x100U << ADC_TR1_HT1_Pos)             /*!< 0x01000000 */
#define ADC_TR1_HT1_9                  (0x200U << ADC_TR1_HT1_Pos)             /*!< 0x02000000 */
#define ADC_TR1_HT1_10                 (0x400U << ADC_TR1_HT1_Pos)             /*!< 0x04000000 */
#define ADC_TR1_HT1_11                 (0x800U << ADC_TR1_HT1_Pos)             /*!< 0x08000000 */

/********************  Bit definition for ADC_TR2 register  *******************/
#define ADC_TR2_LT2_Pos                (0U)                                    
#define ADC_TR2_LT2_Msk                (0xFFU << ADC_TR2_LT2_Pos)              /*!< 0x000000FF */
#define ADC_TR2_LT2                    ADC_TR2_LT2_Msk                         /*!< ADC analog watchdog 2 threshold low */
#define ADC_TR2_LT2_0                  (0x01U << ADC_TR2_LT2_Pos)              /*!< 0x00000001 */
#define ADC_TR2_LT2_1                  (0x02U << ADC_TR2_LT2_Pos)              /*!< 0x00000002 */
#define ADC_TR2_LT2_2                  (0x04U << ADC_TR2_LT2_Pos)              /*!< 0x00000004 */
#define ADC_TR2_LT2_3                  (0x08U << ADC_TR2_LT2_Pos)              /*!< 0x00000008 */
#define ADC_TR2_LT2_4                  (0x10U << ADC_TR2_LT2_Pos)              /*!< 0x00000010 */
#define ADC_TR2_LT2_5                  (0x20U << ADC_TR2_LT2_Pos)              /*!< 0x00000020 */
#define ADC_TR2_LT2_6                  (0x40U << ADC_TR2_LT2_Pos)              /*!< 0x00000040 */
#define ADC_TR2_LT2_7                  (0x80U << ADC_TR2_LT2_Pos)              /*!< 0x00000080 */

#define ADC_TR2_HT2_Pos                (16U)                                   
#define ADC_TR2_HT2_Msk                (0xFFU << ADC_TR2_HT2_Pos)              /*!< 0x00FF0000 */
#define ADC_TR2_HT2                    ADC_TR2_HT2_Msk                         /*!< ADC analog watchdog 2 threshold high */
#define ADC_TR2_HT2_0                  (0x01U << ADC_TR2_HT2_Pos)              /*!< 0x00010000 */
#define ADC_TR2_HT2_1                  (0x02U << ADC_TR2_HT2_Pos)              /*!< 0x00020000 */
#define ADC_TR2_HT2_2                  (0x04U << ADC_TR2_HT2_Pos)              /*!< 0x00040000 */
#define ADC_TR2_HT2_3                  (0x08U << ADC_TR2_HT2_Pos)              /*!< 0x00080000 */
#define ADC_TR2_HT2_4                  (0x10U << ADC_TR2_HT2_Pos)              /*!< 0x00100000 */
#define ADC_TR2_HT2_5                  (0x20U << ADC_TR2_HT2_Pos)              /*!< 0x00200000 */
#define ADC_TR2_HT2_6                  (0x40U << ADC_TR2_HT2_Pos)              /*!< 0x00400000 */
#define ADC_TR2_HT2_7                  (0x80U << ADC_TR2_HT2_Pos)              /*!< 0x00800000 */

/********************  Bit definition for ADC_TR3 register  *******************/
#define ADC_TR3_LT3_Pos                (0U)                                    
#define ADC_TR3_LT3_Msk                (0xFFU << ADC_TR3_LT3_Pos)              /*!< 0x000000FF */
#define ADC_TR3_LT3                    ADC_TR3_LT3_Msk                         /*!< ADC analog watchdog 3 threshold low */
#define ADC_TR3_LT3_0                  (0x01U << ADC_TR3_LT3_Pos)              /*!< 0x00000001 */
#define ADC_TR3_LT3_1                  (0x02U << ADC_TR3_LT3_Pos)              /*!< 0x00000002 */
#define ADC_TR3_LT3_2                  (0x04U << ADC_TR3_LT3_Pos)              /*!< 0x00000004 */
#define ADC_TR3_LT3_3                  (0x08U << ADC_TR3_LT3_Pos)              /*!< 0x00000008 */
#define ADC_TR3_LT3_4                  (0x10U << ADC_TR3_LT3_Pos)              /*!< 0x00000010 */
#define ADC_TR3_LT3_5                  (0x20U << ADC_TR3_LT3_Pos)              /*!< 0x00000020 */
#define ADC_TR3_LT3_6                  (0x40U << ADC_TR3_LT3_Pos)              /*!< 0x00000040 */
#define ADC_TR3_LT3_7                  (0x80U << ADC_TR3_LT3_Pos)              /*!< 0x00000080 */

#define ADC_TR3_HT3_Pos                (16U)                                   
#define ADC_TR3_HT3_Msk                (0xFFU << ADC_TR3_HT3_Pos)              /*!< 0x00FF0000 */
#define ADC_TR3_HT3                    ADC_TR3_HT3_Msk                         /*!< ADC analog watchdog 3 threshold high */
#define ADC_TR3_HT3_0                  (0x01U << ADC_TR3_HT3_Pos)              /*!< 0x00010000 */
#define ADC_TR3_HT3_1                  (0x02U << ADC_TR3_HT3_Pos)              /*!< 0x00020000 */
#define ADC_TR3_HT3_2                  (0x04U << ADC_TR3_HT3_Pos)              /*!< 0x00040000 */
#define ADC_TR3_HT3_3                  (0x08U << ADC_TR3_HT3_Pos)              /*!< 0x00080000 */
#define ADC_TR3_HT3_4                  (0x10U << ADC_TR3_HT3_Pos)              /*!< 0x00100000 */
#define ADC_TR3_HT3_5                  (0x20U << ADC_TR3_HT3_Pos)              /*!< 0x00200000 */
#define ADC_TR3_HT3_6                  (0x40U << ADC_TR3_HT3_Pos)              /*!< 0x00400000 */
#define ADC_TR3_HT3_7                  (0x80U << ADC_TR3_HT3_Pos)              /*!< 0x00800000 */

/********************  Bit definition for ADC_SQR1 register  ******************/
#define ADC_SQR1_L_Pos                 (0U)                                    
#define ADC_SQR1_L_Msk                 (0xFU << ADC_SQR1_L_Pos)                /*!< 0x0000000F */
#define ADC_SQR1_L                     ADC_SQR1_L_Msk                          /*!< ADC group regular sequencer scan length */
#define ADC_SQR1_L_0                   (0x1U << ADC_SQR1_L_Pos)                /*!< 0x00000001 */
#define ADC_SQR1_L_1                   (0x2U << ADC_SQR1_L_Pos)                /*!< 0x00000002 */
#define ADC_SQR1_L_2                   (0x4U << ADC_SQR1_L_Pos)                /*!< 0x00000004 */
#define ADC_SQR1_L_3                   (0x8U << ADC_SQR1_L_Pos)                /*!< 0x00000008 */

#define ADC_SQR1_SQ1_Pos               (6U)                                    
#define ADC_SQR1_SQ1_Msk               (0x1FU << ADC_SQR1_SQ1_Pos)             /*!< 0x000007C0 */
#define ADC_SQR1_SQ1                   ADC_SQR1_SQ1_Msk                        /*!< ADC group regular sequencer rank 1 */
#define ADC_SQR1_SQ1_0                 (0x01U << ADC_SQR1_SQ1_Pos)             /*!< 0x00000040 */
#define ADC_SQR1_SQ1_1                 (0x02U << ADC_SQR1_SQ1_Pos)             /*!< 0x00000080 */
#define ADC_SQR1_SQ1_2                 (0x04U << ADC_SQR1_SQ1_Pos)             /*!< 0x00000100 */
#define ADC_SQR1_SQ1_3                 (0x08U << ADC_SQR1_SQ1_Pos)             /*!< 0x00000200 */
#define ADC_SQR1_SQ1_4                 (0x10U << ADC_SQR1_SQ1_Pos)             /*!< 0x00000400 */

#define ADC_SQR1_SQ2_Pos               (12U)                                   
#define ADC_SQR1_SQ2_Msk               (0x1FU << ADC_SQR1_SQ2_Pos)             /*!< 0x0001F000 */
#define ADC_SQR1_SQ2                   ADC_SQR1_SQ2_Msk                        /*!< ADC group regular sequencer rank 2 */
#define ADC_SQR1_SQ2_0                 (0x01U << ADC_SQR1_SQ2_Pos)             /*!< 0x00001000 */
#define ADC_SQR1_SQ2_1                 (0x02U << ADC_SQR1_SQ2_Pos)             /*!< 0x00002000 */
#define ADC_SQR1_SQ2_2                 (0x04U << ADC_SQR1_SQ2_Pos)             /*!< 0x00004000 */
#define ADC_SQR1_SQ2_3                 (0x08U << ADC_SQR1_SQ2_Pos)             /*!< 0x00008000 */
#define ADC_SQR1_SQ2_4                 (0x10U << ADC_SQR1_SQ2_Pos)             /*!< 0x00010000 */

#define ADC_SQR1_SQ3_Pos               (18U)                                   
#define ADC_SQR1_SQ3_Msk               (0x1FU << ADC_SQR1_SQ3_Pos)             /*!< 0x007C0000 */
#define ADC_SQR1_SQ3                   ADC_SQR1_SQ3_Msk                        /*!< ADC group regular sequencer rank 3 */
#define ADC_SQR1_SQ3_0                 (0x01U << ADC_SQR1_SQ3_Pos)             /*!< 0x00040000 */
#define ADC_SQR1_SQ3_1                 (0x02U << ADC_SQR1_SQ3_Pos)             /*!< 0x00080000 */
#define ADC_SQR1_SQ3_2                 (0x04U << ADC_SQR1_SQ3_Pos)             /*!< 0x00100000 */
#define ADC_SQR1_SQ3_3                 (0x08U << ADC_SQR1_SQ3_Pos)             /*!< 0x00200000 */
#define ADC_SQR1_SQ3_4                 (0x10U << ADC_SQR1_SQ3_Pos)             /*!< 0x00400000 */

#define ADC_SQR1_SQ4_Pos               (24U)                                   
#define ADC_SQR1_SQ4_Msk               (0x1FU << ADC_SQR1_SQ4_Pos)             /*!< 0x1F000000 */
#define ADC_SQR1_SQ4                   ADC_SQR1_SQ4_Msk                        /*!< ADC group regular sequencer rank 4 */
#define ADC_SQR1_SQ4_0                 (0x01U << ADC_SQR1_SQ4_Pos)             /*!< 0x01000000 */
#define ADC_SQR1_SQ4_1                 (0x02U << ADC_SQR1_SQ4_Pos)             /*!< 0x02000000 */
#define ADC_SQR1_SQ4_2                 (0x04U << ADC_SQR1_SQ4_Pos)             /*!< 0x04000000 */
#define ADC_SQR1_SQ4_3                 (0x08U << ADC_SQR1_SQ4_Pos)             /*!< 0x08000000 */
#define ADC_SQR1_SQ4_4                 (0x10U << ADC_SQR1_SQ4_Pos)             /*!< 0x10000000 */

/********************  Bit definition for ADC_SQR2 register  ******************/
#define ADC_SQR2_SQ5_Pos               (0U)                                    
#define ADC_SQR2_SQ5_Msk               (0x1FU << ADC_SQR2_SQ5_Pos)             /*!< 0x0000001F */
#define ADC_SQR2_SQ5                   ADC_SQR2_SQ5_Msk                        /*!< ADC group regular sequencer rank 5 */
#define ADC_SQR2_SQ5_0                 (0x01U << ADC_SQR2_SQ5_Pos)             /*!< 0x00000001 */
#define ADC_SQR2_SQ5_1                 (0x02U << ADC_SQR2_SQ5_Pos)             /*!< 0x00000002 */
#define ADC_SQR2_SQ5_2                 (0x04U << ADC_SQR2_SQ5_Pos)             /*!< 0x00000004 */
#define ADC_SQR2_SQ5_3                 (0x08U << ADC_SQR2_SQ5_Pos)             /*!< 0x00000008 */
#define ADC_SQR2_SQ5_4                 (0x10U << ADC_SQR2_SQ5_Pos)             /*!< 0x00000010 */

#define ADC_SQR2_SQ6_Pos               (6U)                                    
#define ADC_SQR2_SQ6_Msk               (0x1FU << ADC_SQR2_SQ6_Pos)             /*!< 0x000007C0 */
#define ADC_SQR2_SQ6                   ADC_SQR2_SQ6_Msk                        /*!< ADC group regular sequencer rank 6 */
#define ADC_SQR2_SQ6_0                 (0x01U << ADC_SQR2_SQ6_Pos)             /*!< 0x00000040 */
#define ADC_SQR2_SQ6_1                 (0x02U << ADC_SQR2_SQ6_Pos)             /*!< 0x00000080 */
#define ADC_SQR2_SQ6_2                 (0x04U << ADC_SQR2_SQ6_Pos)             /*!< 0x00000100 */
#define ADC_SQR2_SQ6_3                 (0x08U << ADC_SQR2_SQ6_Pos)             /*!< 0x00000200 */
#define ADC_SQR2_SQ6_4                 (0x10U << ADC_SQR2_SQ6_Pos)             /*!< 0x00000400 */

#define ADC_SQR2_SQ7_Pos               (12U)                                   
#define ADC_SQR2_SQ7_Msk               (0x1FU << ADC_SQR2_SQ7_Pos)             /*!< 0x0001F000 */
#define ADC_SQR2_SQ7                   ADC_SQR2_SQ7_Msk                        /*!< ADC group regular sequencer rank 7 */
#define ADC_SQR2_SQ7_0                 (0x01U << ADC_SQR2_SQ7_Pos)             /*!< 0x00001000 */
#define ADC_SQR2_SQ7_1                 (0x02U << ADC_SQR2_SQ7_Pos)             /*!< 0x00002000 */
#define ADC_SQR2_SQ7_2                 (0x04U << ADC_SQR2_SQ7_Pos)             /*!< 0x00004000 */
#define ADC_SQR2_SQ7_3                 (0x08U << ADC_SQR2_SQ7_Pos)             /*!< 0x00008000 */
#define ADC_SQR2_SQ7_4                 (0x10U << ADC_SQR2_SQ7_Pos)             /*!< 0x00010000 */

#define ADC_SQR2_SQ8_Pos               (18U)                                   
#define ADC_SQR2_SQ8_Msk               (0x1FU << ADC_SQR2_SQ8_Pos)             /*!< 0x007C0000 */
#define ADC_SQR2_SQ8                   ADC_SQR2_SQ8_Msk                        /*!< ADC group regular sequencer rank 8 */
#define ADC_SQR2_SQ8_0                 (0x01U << ADC_SQR2_SQ8_Pos)             /*!< 0x00040000 */
#define ADC_SQR2_SQ8_1                 (0x02U << ADC_SQR2_SQ8_Pos)             /*!< 0x00080000 */
#define ADC_SQR2_SQ8_2                 (0x04U << ADC_SQR2_SQ8_Pos)             /*!< 0x00100000 */
#define ADC_SQR2_SQ8_3                 (0x08U << ADC_SQR2_SQ8_Pos)             /*!< 0x00200000 */
#define ADC_SQR2_SQ8_4                 (0x10U << ADC_SQR2_SQ8_Pos)             /*!< 0x00400000 */

#define ADC_SQR2_SQ9_Pos               (24U)                                   
#define ADC_SQR2_SQ9_Msk               (0x1FU << ADC_SQR2_SQ9_Pos)             /*!< 0x1F000000 */
#define ADC_SQR2_SQ9                   ADC_SQR2_SQ9_Msk                        /*!< ADC group regular sequencer rank 9 */
#define ADC_SQR2_SQ9_0                 (0x01U << ADC_SQR2_SQ9_Pos)             /*!< 0x01000000 */
#define ADC_SQR2_SQ9_1                 (0x02U << ADC_SQR2_SQ9_Pos)             /*!< 0x02000000 */
#define ADC_SQR2_SQ9_2                 (0x04U << ADC_SQR2_SQ9_Pos)             /*!< 0x04000000 */
#define ADC_SQR2_SQ9_3                 (0x08U << ADC_SQR2_SQ9_Pos)             /*!< 0x08000000 */
#define ADC_SQR2_SQ9_4                 (0x10U << ADC_SQR2_SQ9_Pos)             /*!< 0x10000000 */

/********************  Bit definition for ADC_SQR3 register  ******************/
#define ADC_SQR3_SQ10_Pos              (0U)                                    
#define ADC_SQR3_SQ10_Msk              (0x1FU << ADC_SQR3_SQ10_Pos)            /*!< 0x0000001F */
#define ADC_SQR3_SQ10                  ADC_SQR3_SQ10_Msk                       /*!< ADC group regular sequencer rank 10 */
#define ADC_SQR3_SQ10_0                (0x01U << ADC_SQR3_SQ10_Pos)            /*!< 0x00000001 */
#define ADC_SQR3_SQ10_1                (0x02U << ADC_SQR3_SQ10_Pos)            /*!< 0x00000002 */
#define ADC_SQR3_SQ10_2                (0x04U << ADC_SQR3_SQ10_Pos)            /*!< 0x00000004 */
#define ADC_SQR3_SQ10_3                (0x08U << ADC_SQR3_SQ10_Pos)            /*!< 0x00000008 */
#define ADC_SQR3_SQ10_4                (0x10U << ADC_SQR3_SQ10_Pos)            /*!< 0x00000010 */

#define ADC_SQR3_SQ11_Pos              (6U)                                    
#define ADC_SQR3_SQ11_Msk              (0x1FU << ADC_SQR3_SQ11_Pos)            /*!< 0x000007C0 */
#define ADC_SQR3_SQ11                  ADC_SQR3_SQ11_Msk                       /*!< ADC group regular sequencer rank 11 */
#define ADC_SQR3_SQ11_0                (0x01U << ADC_SQR3_SQ11_Pos)            /*!< 0x00000040 */
#define ADC_SQR3_SQ11_1                (0x02U << ADC_SQR3_SQ11_Pos)            /*!< 0x00000080 */
#define ADC_SQR3_SQ11_2                (0x04U << ADC_SQR3_SQ11_Pos)            /*!< 0x00000100 */
#define ADC_SQR3_SQ11_3                (0x08U << ADC_SQR3_SQ11_Pos)            /*!< 0x00000200 */
#define ADC_SQR3_SQ11_4                (0x10U << ADC_SQR3_SQ11_Pos)            /*!< 0x00000400 */

#define ADC_SQR3_SQ12_Pos              (12U)                                   
#define ADC_SQR3_SQ12_Msk              (0x1FU << ADC_SQR3_SQ12_Pos)            /*!< 0x0001F000 */
#define ADC_SQR3_SQ12                  ADC_SQR3_SQ12_Msk                       /*!< ADC group regular sequencer rank 12 */
#define ADC_SQR3_SQ12_0                (0x01U << ADC_SQR3_SQ12_Pos)            /*!< 0x00001000 */
#define ADC_SQR3_SQ12_1                (0x02U << ADC_SQR3_SQ12_Pos)            /*!< 0x00002000 */
#define ADC_SQR3_SQ12_2                (0x04U << ADC_SQR3_SQ12_Pos)            /*!< 0x00004000 */
#define ADC_SQR3_SQ12_3                (0x08U << ADC_SQR3_SQ12_Pos)            /*!< 0x00008000 */
#define ADC_SQR3_SQ12_4                (0x10U << ADC_SQR3_SQ12_Pos)            /*!< 0x00010000 */

#define ADC_SQR3_SQ13_Pos              (18U)                                   
#define ADC_SQR3_SQ13_Msk              (0x1FU << ADC_SQR3_SQ13_Pos)            /*!< 0x007C0000 */
#define ADC_SQR3_SQ13                  ADC_SQR3_SQ13_Msk                       /*!< ADC group regular sequencer rank 13 */
#define ADC_SQR3_SQ13_0                (0x01U << ADC_SQR3_SQ13_Pos)            /*!< 0x00040000 */
#define ADC_SQR3_SQ13_1                (0x02U << ADC_SQR3_SQ13_Pos)            /*!< 0x00080000 */
#define ADC_SQR3_SQ13_2                (0x04U << ADC_SQR3_SQ13_Pos)            /*!< 0x00100000 */
#define ADC_SQR3_SQ13_3                (0x08U << ADC_SQR3_SQ13_Pos)            /*!< 0x00200000 */
#define ADC_SQR3_SQ13_4                (0x10U << ADC_SQR3_SQ13_Pos)            /*!< 0x00400000 */

#define ADC_SQR3_SQ14_Pos              (24U)                                   
#define ADC_SQR3_SQ14_Msk              (0x1FU << ADC_SQR3_SQ14_Pos)            /*!< 0x1F000000 */
#define ADC_SQR3_SQ14                  ADC_SQR3_SQ14_Msk                       /*!< ADC group regular sequencer rank 14 */
#define ADC_SQR3_SQ14_0                (0x01U << ADC_SQR3_SQ14_Pos)            /*!< 0x01000000 */
#define ADC_SQR3_SQ14_1                (0x02U << ADC_SQR3_SQ14_Pos)            /*!< 0x02000000 */
#define ADC_SQR3_SQ14_2                (0x04U << ADC_SQR3_SQ14_Pos)            /*!< 0x04000000 */
#define ADC_SQR3_SQ14_3                (0x08U << ADC_SQR3_SQ14_Pos)            /*!< 0x08000000 */
#define ADC_SQR3_SQ14_4                (0x10U << ADC_SQR3_SQ14_Pos)            /*!< 0x10000000 */

/********************  Bit definition for ADC_SQR4 register  ******************/
#define ADC_SQR4_SQ15_Pos              (0U)                                    
#define ADC_SQR4_SQ15_Msk              (0x1FU << ADC_SQR4_SQ15_Pos)            /*!< 0x0000001F */
#define ADC_SQR4_SQ15                  ADC_SQR4_SQ15_Msk                       /*!< ADC group regular sequencer rank 15 */
#define ADC_SQR4_SQ15_0                (0x01U << ADC_SQR4_SQ15_Pos)            /*!< 0x00000001 */
#define ADC_SQR4_SQ15_1                (0x02U << ADC_SQR4_SQ15_Pos)            /*!< 0x00000002 */
#define ADC_SQR4_SQ15_2                (0x04U << ADC_SQR4_SQ15_Pos)            /*!< 0x00000004 */
#define ADC_SQR4_SQ15_3                (0x08U << ADC_SQR4_SQ15_Pos)            /*!< 0x00000008 */
#define ADC_SQR4_SQ15_4                (0x10U << ADC_SQR4_SQ15_Pos)            /*!< 0x00000010 */

#define ADC_SQR4_SQ16_Pos              (6U)                                    
#define ADC_SQR4_SQ16_Msk              (0x1FU << ADC_SQR4_SQ16_Pos)            /*!< 0x000007C0 */
#define ADC_SQR4_SQ16                  ADC_SQR4_SQ16_Msk                       /*!< ADC group regular sequencer rank 16 */
#define ADC_SQR4_SQ16_0                (0x01U << ADC_SQR4_SQ16_Pos)            /*!< 0x00000040 */
#define ADC_SQR4_SQ16_1                (0x02U << ADC_SQR4_SQ16_Pos)            /*!< 0x00000080 */
#define ADC_SQR4_SQ16_2                (0x04U << ADC_SQR4_SQ16_Pos)            /*!< 0x00000100 */
#define ADC_SQR4_SQ16_3                (0x08U << ADC_SQR4_SQ16_Pos)            /*!< 0x00000200 */
#define ADC_SQR4_SQ16_4                (0x10U << ADC_SQR4_SQ16_Pos)            /*!< 0x00000400 */

/********************  Bit definition for ADC_DR register  ********************/
#define ADC_DR_RDATA_Pos               (0U)                                    
#define ADC_DR_RDATA_Msk               (0xFFFFU << ADC_DR_RDATA_Pos)           /*!< 0x0000FFFF */
#define ADC_DR_RDATA                   ADC_DR_RDATA_Msk                        /*!< ADC group regular conversion data */
#define ADC_DR_RDATA_0                 (0x0001U << ADC_DR_RDATA_Pos)           /*!< 0x00000001 */
#define ADC_DR_RDATA_1                 (0x0002U << ADC_DR_RDATA_Pos)           /*!< 0x00000002 */
#define ADC_DR_RDATA_2                 (0x0004U << ADC_DR_RDATA_Pos)           /*!< 0x00000004 */
#define ADC_DR_RDATA_3                 (0x0008U << ADC_DR_RDATA_Pos)           /*!< 0x00000008 */
#define ADC_DR_RDATA_4                 (0x0010U << ADC_DR_RDATA_Pos)           /*!< 0x00000010 */
#define ADC_DR_RDATA_5                 (0x0020U << ADC_DR_RDATA_Pos)           /*!< 0x00000020 */
#define ADC_DR_RDATA_6                 (0x0040U << ADC_DR_RDATA_Pos)           /*!< 0x00000040 */
#define ADC_DR_RDATA_7                 (0x0080U << ADC_DR_RDATA_Pos)           /*!< 0x00000080 */
#define ADC_DR_RDATA_8                 (0x0100U << ADC_DR_RDATA_Pos)           /*!< 0x00000100 */
#define ADC_DR_RDATA_9                 (0x0200U << ADC_DR_RDATA_Pos)           /*!< 0x00000200 */
#define ADC_DR_RDATA_10                (0x0400U << ADC_DR_RDATA_Pos)           /*!< 0x00000400 */
#define ADC_DR_RDATA_11                (0x0800U << ADC_DR_RDATA_Pos)           /*!< 0x00000800 */
#define ADC_DR_RDATA_12                (0x1000U << ADC_DR_RDATA_Pos)           /*!< 0x00001000 */
#define ADC_DR_RDATA_13                (0x2000U << ADC_DR_RDATA_Pos)           /*!< 0x00002000 */
#define ADC_DR_RDATA_14                (0x4000U << ADC_DR_RDATA_Pos)           /*!< 0x00004000 */
#define ADC_DR_RDATA_15                (0x8000U << ADC_DR_RDATA_Pos)           /*!< 0x00008000 */

/********************  Bit definition for ADC_JSQR register  ******************/
#define ADC_JSQR_JL_Pos                (0U)                                    
#define ADC_JSQR_JL_Msk                (0x3U << ADC_JSQR_JL_Pos)               /*!< 0x00000003 */
#define ADC_JSQR_JL                    ADC_JSQR_JL_Msk                         /*!< ADC group injected sequencer scan length */
#define ADC_JSQR_JL_0                  (0x1U << ADC_JSQR_JL_Pos)               /*!< 0x00000001 */
#define ADC_JSQR_JL_1                  (0x2U << ADC_JSQR_JL_Pos)               /*!< 0x00000002 */

#define ADC_JSQR_JEXTSEL_Pos           (2U)                                    
#define ADC_JSQR_JEXTSEL_Msk           (0xFU << ADC_JSQR_JEXTSEL_Pos)          /*!< 0x0000003C */
#define ADC_JSQR_JEXTSEL               ADC_JSQR_JEXTSEL_Msk                    /*!< ADC group injected external trigger source */
#define ADC_JSQR_JEXTSEL_0             (0x1U << ADC_JSQR_JEXTSEL_Pos)          /*!< 0x00000004 */
#define ADC_JSQR_JEXTSEL_1             (0x2U << ADC_JSQR_JEXTSEL_Pos)          /*!< 0x00000008 */
#define ADC_JSQR_JEXTSEL_2             (0x4U << ADC_JSQR_JEXTSEL_Pos)          /*!< 0x00000010 */
#define ADC_JSQR_JEXTSEL_3             (0x8U << ADC_JSQR_JEXTSEL_Pos)          /*!< 0x00000020 */

#define ADC_JSQR_JEXTEN_Pos            (6U)                                    
#define ADC_JSQR_JEXTEN_Msk            (0x3U << ADC_JSQR_JEXTEN_Pos)           /*!< 0x000000C0 */
#define ADC_JSQR_JEXTEN                ADC_JSQR_JEXTEN_Msk                     /*!< ADC group injected external trigger polarity */
#define ADC_JSQR_JEXTEN_0              (0x1U << ADC_JSQR_JEXTEN_Pos)           /*!< 0x00000040 */
#define ADC_JSQR_JEXTEN_1              (0x2U << ADC_JSQR_JEXTEN_Pos)           /*!< 0x00000080 */

#define ADC_JSQR_JSQ1_Pos              (8U)                                    
#define ADC_JSQR_JSQ1_Msk              (0x1FU << ADC_JSQR_JSQ1_Pos)            /*!< 0x00001F00 */
#define ADC_JSQR_JSQ1                  ADC_JSQR_JSQ1_Msk                       /*!< ADC group injected sequencer rank 1 */
#define ADC_JSQR_JSQ1_0                (0x01U << ADC_JSQR_JSQ1_Pos)            /*!< 0x00000100 */
#define ADC_JSQR_JSQ1_1                (0x02U << ADC_JSQR_JSQ1_Pos)            /*!< 0x00000200 */
#define ADC_JSQR_JSQ1_2                (0x04U << ADC_JSQR_JSQ1_Pos)            /*!< 0x00000400 */
#define ADC_JSQR_JSQ1_3                (0x08U << ADC_JSQR_JSQ1_Pos)            /*!< 0x00000800 */
#define ADC_JSQR_JSQ1_4                (0x10U << ADC_JSQR_JSQ1_Pos)            /*!< 0x00001000 */

#define ADC_JSQR_JSQ2_Pos              (14U)                                   
#define ADC_JSQR_JSQ2_Msk              (0x1FU << ADC_JSQR_JSQ2_Pos)            /*!< 0x0007C000 */
#define ADC_JSQR_JSQ2                  ADC_JSQR_JSQ2_Msk                       /*!< ADC group injected sequencer rank 2 */
#define ADC_JSQR_JSQ2_0                (0x01U << ADC_JSQR_JSQ2_Pos)            /*!< 0x00004000 */
#define ADC_JSQR_JSQ2_1                (0x02U << ADC_JSQR_JSQ2_Pos)            /*!< 0x00008000 */
#define ADC_JSQR_JSQ2_2                (0x04U << ADC_JSQR_JSQ2_Pos)            /*!< 0x00010000 */
#define ADC_JSQR_JSQ2_3                (0x08U << ADC_JSQR_JSQ2_Pos)            /*!< 0x00020000 */
#define ADC_JSQR_JSQ2_4                (0x10U << ADC_JSQR_JSQ2_Pos)            /*!< 0x00040000 */

#define ADC_JSQR_JSQ3_Pos              (20U)                                   
#define ADC_JSQR_JSQ3_Msk              (0x1FU << ADC_JSQR_JSQ3_Pos)            /*!< 0x01F00000 */
#define ADC_JSQR_JSQ3                  ADC_JSQR_JSQ3_Msk                       /*!< ADC group injected sequencer rank 3 */
#define ADC_JSQR_JSQ3_0                (0x01U << ADC_JSQR_JSQ3_Pos)            /*!< 0x00100000 */
#define ADC_JSQR_JSQ3_1                (0x02U << ADC_JSQR_JSQ3_Pos)            /*!< 0x00200000 */
#define ADC_JSQR_JSQ3_2                (0x04U << ADC_JSQR_JSQ3_Pos)            /*!< 0x00400000 */
#define ADC_JSQR_JSQ3_3                (0x08U << ADC_JSQR_JSQ3_Pos)            /*!< 0x00800000 */
#define ADC_JSQR_JSQ3_4                (0x10U << ADC_JSQR_JSQ3_Pos)            /*!< 0x01000000 */

#define ADC_JSQR_JSQ4_Pos              (26U)                                   
#define ADC_JSQR_JSQ4_Msk              (0x1FU << ADC_JSQR_JSQ4_Pos)            /*!< 0x7C000000 */
#define ADC_JSQR_JSQ4                  ADC_JSQR_JSQ4_Msk                       /*!< ADC group injected sequencer rank 4 */
#define ADC_JSQR_JSQ4_0                (0x01U << ADC_JSQR_JSQ4_Pos)            /*!< 0x04000000 */
#define ADC_JSQR_JSQ4_1                (0x02U << ADC_JSQR_JSQ4_Pos)            /*!< 0x08000000 */
#define ADC_JSQR_JSQ4_2                (0x04U << ADC_JSQR_JSQ4_Pos)            /*!< 0x10000000 */
#define ADC_JSQR_JSQ4_3                (0x08U << ADC_JSQR_JSQ4_Pos)            /*!< 0x20000000 */
#define ADC_JSQR_JSQ4_4                (0x10U << ADC_JSQR_JSQ4_Pos)            /*!< 0x40000000 */


/********************  Bit definition for ADC_OFR1 register  ******************/
#define ADC_OFR1_OFFSET1_Pos           (0U)                                    
#define ADC_OFR1_OFFSET1_Msk           (0xFFFU << ADC_OFR1_OFFSET1_Pos)        /*!< 0x00000FFF */
#define ADC_OFR1_OFFSET1               ADC_OFR1_OFFSET1_Msk                    /*!< ADC offset number 1 offset level */
#define ADC_OFR1_OFFSET1_0             (0x001U << ADC_OFR1_OFFSET1_Pos)        /*!< 0x00000001 */
#define ADC_OFR1_OFFSET1_1             (0x002U << ADC_OFR1_OFFSET1_Pos)        /*!< 0x00000002 */
#define ADC_OFR1_OFFSET1_2             (0x004U << ADC_OFR1_OFFSET1_Pos)        /*!< 0x00000004 */
#define ADC_OFR1_OFFSET1_3             (0x008U << ADC_OFR1_OFFSET1_Pos)        /*!< 0x00000008 */
#define ADC_OFR1_OFFSET1_4             (0x010U << ADC_OFR1_OFFSET1_Pos)        /*!< 0x00000010 */
#define ADC_OFR1_OFFSET1_5             (0x020U << ADC_OFR1_OFFSET1_Pos)        /*!< 0x00000020 */
#define ADC_OFR1_OFFSET1_6             (0x040U << ADC_OFR1_OFFSET1_Pos)        /*!< 0x00000040 */
#define ADC_OFR1_OFFSET1_7             (0x080U << ADC_OFR1_OFFSET1_Pos)        /*!< 0x00000080 */
#define ADC_OFR1_OFFSET1_8             (0x100U << ADC_OFR1_OFFSET1_Pos)        /*!< 0x00000100 */
#define ADC_OFR1_OFFSET1_9             (0x200U << ADC_OFR1_OFFSET1_Pos)        /*!< 0x00000200 */
#define ADC_OFR1_OFFSET1_10            (0x400U << ADC_OFR1_OFFSET1_Pos)        /*!< 0x00000400 */
#define ADC_OFR1_OFFSET1_11            (0x800U << ADC_OFR1_OFFSET1_Pos)        /*!< 0x00000800 */

#define ADC_OFR1_OFFSET1_CH_Pos        (26U)                                   
#define ADC_OFR1_OFFSET1_CH_Msk        (0x1FU << ADC_OFR1_OFFSET1_CH_Pos)      /*!< 0x7C000000 */
#define ADC_OFR1_OFFSET1_CH            ADC_OFR1_OFFSET1_CH_Msk                 /*!< ADC offset number 1 channel selection */
#define ADC_OFR1_OFFSET1_CH_0          (0x01U << ADC_OFR1_OFFSET1_CH_Pos)      /*!< 0x04000000 */
#define ADC_OFR1_OFFSET1_CH_1          (0x02U << ADC_OFR1_OFFSET1_CH_Pos)      /*!< 0x08000000 */
#define ADC_OFR1_OFFSET1_CH_2          (0x04U << ADC_OFR1_OFFSET1_CH_Pos)      /*!< 0x10000000 */
#define ADC_OFR1_OFFSET1_CH_3          (0x08U << ADC_OFR1_OFFSET1_CH_Pos)      /*!< 0x20000000 */
#define ADC_OFR1_OFFSET1_CH_4          (0x10U << ADC_OFR1_OFFSET1_CH_Pos)      /*!< 0x40000000 */

#define ADC_OFR1_OFFSET1_EN_Pos        (31U)                                   
#define ADC_OFR1_OFFSET1_EN_Msk        (0x1U << ADC_OFR1_OFFSET1_EN_Pos)       /*!< 0x80000000 */
#define ADC_OFR1_OFFSET1_EN            ADC_OFR1_OFFSET1_EN_Msk                 /*!< ADC offset number 1 enable */

/********************  Bit definition for ADC_OFR2 register  ******************/
#define ADC_OFR2_OFFSET2_Pos           (0U)                                    
#define ADC_OFR2_OFFSET2_Msk           (0xFFFU << ADC_OFR2_OFFSET2_Pos)        /*!< 0x00000FFF */
#define ADC_OFR2_OFFSET2               ADC_OFR2_OFFSET2_Msk                    /*!< ADC offset number 2 offset level */
#define ADC_OFR2_OFFSET2_0             (0x001U << ADC_OFR2_OFFSET2_Pos)        /*!< 0x00000001 */
#define ADC_OFR2_OFFSET2_1             (0x002U << ADC_OFR2_OFFSET2_Pos)        /*!< 0x00000002 */
#define ADC_OFR2_OFFSET2_2             (0x004U << ADC_OFR2_OFFSET2_Pos)        /*!< 0x00000004 */
#define ADC_OFR2_OFFSET2_3             (0x008U << ADC_OFR2_OFFSET2_Pos)        /*!< 0x00000008 */
#define ADC_OFR2_OFFSET2_4             (0x010U << ADC_OFR2_OFFSET2_Pos)        /*!< 0x00000010 */
#define ADC_OFR2_OFFSET2_5             (0x020U << ADC_OFR2_OFFSET2_Pos)        /*!< 0x00000020 */
#define ADC_OFR2_OFFSET2_6             (0x040U << ADC_OFR2_OFFSET2_Pos)        /*!< 0x00000040 */
#define ADC_OFR2_OFFSET2_7             (0x080U << ADC_OFR2_OFFSET2_Pos)        /*!< 0x00000080 */
#define ADC_OFR2_OFFSET2_8             (0x100U << ADC_OFR2_OFFSET2_Pos)        /*!< 0x00000100 */
#define ADC_OFR2_OFFSET2_9             (0x200U << ADC_OFR2_OFFSET2_Pos)        /*!< 0x00000200 */
#define ADC_OFR2_OFFSET2_10            (0x400U << ADC_OFR2_OFFSET2_Pos)        /*!< 0x00000400 */
#define ADC_OFR2_OFFSET2_11            (0x800U << ADC_OFR2_OFFSET2_Pos)        /*!< 0x00000800 */

#define ADC_OFR2_OFFSET2_CH_Pos        (26U)                                   
#define ADC_OFR2_OFFSET2_CH_Msk        (0x1FU << ADC_OFR2_OFFSET2_CH_Pos)      /*!< 0x7C000000 */
#define ADC_OFR2_OFFSET2_CH            ADC_OFR2_OFFSET2_CH_Msk                 /*!< ADC offset number 2 channel selection */
#define ADC_OFR2_OFFSET2_CH_0          (0x01U << ADC_OFR2_OFFSET2_CH_Pos)      /*!< 0x04000000 */
#define ADC_OFR2_OFFSET2_CH_1          (0x02U << ADC_OFR2_OFFSET2_CH_Pos)      /*!< 0x08000000 */
#define ADC_OFR2_OFFSET2_CH_2          (0x04U << ADC_OFR2_OFFSET2_CH_Pos)      /*!< 0x10000000 */
#define ADC_OFR2_OFFSET2_CH_3          (0x08U << ADC_OFR2_OFFSET2_CH_Pos)      /*!< 0x20000000 */
#define ADC_OFR2_OFFSET2_CH_4          (0x10U << ADC_OFR2_OFFSET2_CH_Pos)      /*!< 0x40000000 */

#define ADC_OFR2_OFFSET2_EN_Pos        (31U)                                   
#define ADC_OFR2_OFFSET2_EN_Msk        (0x1U << ADC_OFR2_OFFSET2_EN_Pos)       /*!< 0x80000000 */
#define ADC_OFR2_OFFSET2_EN            ADC_OFR2_OFFSET2_EN_Msk                 /*!< ADC offset number 2 enable */

/********************  Bit definition for ADC_OFR3 register  ******************/
#define ADC_OFR3_OFFSET3_Pos           (0U)                                    
#define ADC_OFR3_OFFSET3_Msk           (0xFFFU << ADC_OFR3_OFFSET3_Pos)        /*!< 0x00000FFF */
#define ADC_OFR3_OFFSET3               ADC_OFR3_OFFSET3_Msk                    /*!< ADC offset number 3 offset level */
#define ADC_OFR3_OFFSET3_0             (0x001U << ADC_OFR3_OFFSET3_Pos)        /*!< 0x00000001 */
#define ADC_OFR3_OFFSET3_1             (0x002U << ADC_OFR3_OFFSET3_Pos)        /*!< 0x00000002 */
#define ADC_OFR3_OFFSET3_2             (0x004U << ADC_OFR3_OFFSET3_Pos)        /*!< 0x00000004 */
#define ADC_OFR3_OFFSET3_3             (0x008U << ADC_OFR3_OFFSET3_Pos)        /*!< 0x00000008 */
#define ADC_OFR3_OFFSET3_4             (0x010U << ADC_OFR3_OFFSET3_Pos)        /*!< 0x00000010 */
#define ADC_OFR3_OFFSET3_5             (0x020U << ADC_OFR3_OFFSET3_Pos)        /*!< 0x00000020 */
#define ADC_OFR3_OFFSET3_6             (0x040U << ADC_OFR3_OFFSET3_Pos)        /*!< 0x00000040 */
#define ADC_OFR3_OFFSET3_7             (0x080U << ADC_OFR3_OFFSET3_Pos)        /*!< 0x00000080 */
#define ADC_OFR3_OFFSET3_8             (0x100U << ADC_OFR3_OFFSET3_Pos)        /*!< 0x00000100 */
#define ADC_OFR3_OFFSET3_9             (0x200U << ADC_OFR3_OFFSET3_Pos)        /*!< 0x00000200 */
#define ADC_OFR3_OFFSET3_10            (0x400U << ADC_OFR3_OFFSET3_Pos)        /*!< 0x00000400 */
#define ADC_OFR3_OFFSET3_11            (0x800U << ADC_OFR3_OFFSET3_Pos)        /*!< 0x00000800 */

#define ADC_OFR3_OFFSET3_CH_Pos        (26U)                                   
#define ADC_OFR3_OFFSET3_CH_Msk        (0x1FU << ADC_OFR3_OFFSET3_CH_Pos)      /*!< 0x7C000000 */
#define ADC_OFR3_OFFSET3_CH            ADC_OFR3_OFFSET3_CH_Msk                 /*!< ADC offset number 3 channel selection */
#define ADC_OFR3_OFFSET3_CH_0          (0x01U << ADC_OFR3_OFFSET3_CH_Pos)      /*!< 0x04000000 */
#define ADC_OFR3_OFFSET3_CH_1          (0x02U << ADC_OFR3_OFFSET3_CH_Pos)      /*!< 0x08000000 */
#define ADC_OFR3_OFFSET3_CH_2          (0x04U << ADC_OFR3_OFFSET3_CH_Pos)      /*!< 0x10000000 */
#define ADC_OFR3_OFFSET3_CH_3          (0x08U << ADC_OFR3_OFFSET3_CH_Pos)      /*!< 0x20000000 */
#define ADC_OFR3_OFFSET3_CH_4          (0x10U << ADC_OFR3_OFFSET3_CH_Pos)      /*!< 0x40000000 */

#define ADC_OFR3_OFFSET3_EN_Pos        (31U)                                   
#define ADC_OFR3_OFFSET3_EN_Msk        (0x1U << ADC_OFR3_OFFSET3_EN_Pos)       /*!< 0x80000000 */
#define ADC_OFR3_OFFSET3_EN            ADC_OFR3_OFFSET3_EN_Msk                 /*!< ADC offset number 3 enable */

/********************  Bit definition for ADC_OFR4 register  ******************/
#define ADC_OFR4_OFFSET4_Pos           (0U)                                    
#define ADC_OFR4_OFFSET4_Msk           (0xFFFU << ADC_OFR4_OFFSET4_Pos)        /*!< 0x00000FFF */
#define ADC_OFR4_OFFSET4               ADC_OFR4_OFFSET4_Msk                    /*!< ADC offset number 4 offset level */
#define ADC_OFR4_OFFSET4_0             (0x001U << ADC_OFR4_OFFSET4_Pos)        /*!< 0x00000001 */
#define ADC_OFR4_OFFSET4_1             (0x002U << ADC_OFR4_OFFSET4_Pos)        /*!< 0x00000002 */
#define ADC_OFR4_OFFSET4_2             (0x004U << ADC_OFR4_OFFSET4_Pos)        /*!< 0x00000004 */
#define ADC_OFR4_OFFSET4_3             (0x008U << ADC_OFR4_OFFSET4_Pos)        /*!< 0x00000008 */
#define ADC_OFR4_OFFSET4_4             (0x010U << ADC_OFR4_OFFSET4_Pos)        /*!< 0x00000010 */
#define ADC_OFR4_OFFSET4_5             (0x020U << ADC_OFR4_OFFSET4_Pos)        /*!< 0x00000020 */
#define ADC_OFR4_OFFSET4_6             (0x040U << ADC_OFR4_OFFSET4_Pos)        /*!< 0x00000040 */
#define ADC_OFR4_OFFSET4_7             (0x080U << ADC_OFR4_OFFSET4_Pos)        /*!< 0x00000080 */
#define ADC_OFR4_OFFSET4_8             (0x100U << ADC_OFR4_OFFSET4_Pos)        /*!< 0x00000100 */
#define ADC_OFR4_OFFSET4_9             (0x200U << ADC_OFR4_OFFSET4_Pos)        /*!< 0x00000200 */
#define ADC_OFR4_OFFSET4_10            (0x400U << ADC_OFR4_OFFSET4_Pos)        /*!< 0x00000400 */
#define ADC_OFR4_OFFSET4_11            (0x800U << ADC_OFR4_OFFSET4_Pos)        /*!< 0x00000800 */

#define ADC_OFR4_OFFSET4_CH_Pos        (26U)                                   
#define ADC_OFR4_OFFSET4_CH_Msk        (0x1FU << ADC_OFR4_OFFSET4_CH_Pos)      /*!< 0x7C000000 */
#define ADC_OFR4_OFFSET4_CH            ADC_OFR4_OFFSET4_CH_Msk                 /*!< ADC offset number 4 channel selection */
#define ADC_OFR4_OFFSET4_CH_0          (0x01U << ADC_OFR4_OFFSET4_CH_Pos)      /*!< 0x04000000 */
#define ADC_OFR4_OFFSET4_CH_1          (0x02U << ADC_OFR4_OFFSET4_CH_Pos)      /*!< 0x08000000 */
#define ADC_OFR4_OFFSET4_CH_2          (0x04U << ADC_OFR4_OFFSET4_CH_Pos)      /*!< 0x10000000 */
#define ADC_OFR4_OFFSET4_CH_3          (0x08U << ADC_OFR4_OFFSET4_CH_Pos)      /*!< 0x20000000 */
#define ADC_OFR4_OFFSET4_CH_4          (0x10U << ADC_OFR4_OFFSET4_CH_Pos)      /*!< 0x40000000 */

#define ADC_OFR4_OFFSET4_EN_Pos        (31U)                                   
#define ADC_OFR4_OFFSET4_EN_Msk        (0x1U << ADC_OFR4_OFFSET4_EN_Pos)       /*!< 0x80000000 */
#define ADC_OFR4_OFFSET4_EN            ADC_OFR4_OFFSET4_EN_Msk                 /*!< ADC offset number 4 enable */

/********************  Bit definition for ADC_JDR1 register  ******************/
#define ADC_JDR1_JDATA_Pos             (0U)                                    
#define ADC_JDR1_JDATA_Msk             (0xFFFFU << ADC_JDR1_JDATA_Pos)         /*!< 0x0000FFFF */
#define ADC_JDR1_JDATA                 ADC_JDR1_JDATA_Msk                      /*!< ADC group injected sequencer rank 1 conversion data */
#define ADC_JDR1_JDATA_0               (0x0001U << ADC_JDR1_JDATA_Pos)         /*!< 0x00000001 */
#define ADC_JDR1_JDATA_1               (0x0002U << ADC_JDR1_JDATA_Pos)         /*!< 0x00000002 */
#define ADC_JDR1_JDATA_2               (0x0004U << ADC_JDR1_JDATA_Pos)         /*!< 0x00000004 */
#define ADC_JDR1_JDATA_3               (0x0008U << ADC_JDR1_JDATA_Pos)         /*!< 0x00000008 */
#define ADC_JDR1_JDATA_4               (0x0010U << ADC_JDR1_JDATA_Pos)         /*!< 0x00000010 */
#define ADC_JDR1_JDATA_5               (0x0020U << ADC_JDR1_JDATA_Pos)         /*!< 0x00000020 */
#define ADC_JDR1_JDATA_6               (0x0040U << ADC_JDR1_JDATA_Pos)         /*!< 0x00000040 */
#define ADC_JDR1_JDATA_7               (0x0080U << ADC_JDR1_JDATA_Pos)         /*!< 0x00000080 */
#define ADC_JDR1_JDATA_8               (0x0100U << ADC_JDR1_JDATA_Pos)         /*!< 0x00000100 */
#define ADC_JDR1_JDATA_9               (0x0200U << ADC_JDR1_JDATA_Pos)         /*!< 0x00000200 */
#define ADC_JDR1_JDATA_10              (0x0400U << ADC_JDR1_JDATA_Pos)         /*!< 0x00000400 */
#define ADC_JDR1_JDATA_11              (0x0800U << ADC_JDR1_JDATA_Pos)         /*!< 0x00000800 */
#define ADC_JDR1_JDATA_12              (0x1000U << ADC_JDR1_JDATA_Pos)         /*!< 0x00001000 */
#define ADC_JDR1_JDATA_13              (0x2000U << ADC_JDR1_JDATA_Pos)         /*!< 0x00002000 */
#define ADC_JDR1_JDATA_14              (0x4000U << ADC_JDR1_JDATA_Pos)         /*!< 0x00004000 */
#define ADC_JDR1_JDATA_15              (0x8000U << ADC_JDR1_JDATA_Pos)         /*!< 0x00008000 */

/********************  Bit definition for ADC_JDR2 register  ******************/
#define ADC_JDR2_JDATA_Pos             (0U)                                    
#define ADC_JDR2_JDATA_Msk             (0xFFFFU << ADC_JDR2_JDATA_Pos)         /*!< 0x0000FFFF */
#define ADC_JDR2_JDATA                 ADC_JDR2_JDATA_Msk                      /*!< ADC group injected sequencer rank 2 conversion data */
#define ADC_JDR2_JDATA_0               (0x0001U << ADC_JDR2_JDATA_Pos)         /*!< 0x00000001 */
#define ADC_JDR2_JDATA_1               (0x0002U << ADC_JDR2_JDATA_Pos)         /*!< 0x00000002 */
#define ADC_JDR2_JDATA_2               (0x0004U << ADC_JDR2_JDATA_Pos)         /*!< 0x00000004 */
#define ADC_JDR2_JDATA_3               (0x0008U << ADC_JDR2_JDATA_Pos)         /*!< 0x00000008 */
#define ADC_JDR2_JDATA_4               (0x0010U << ADC_JDR2_JDATA_Pos)         /*!< 0x00000010 */
#define ADC_JDR2_JDATA_5               (0x0020U << ADC_JDR2_JDATA_Pos)         /*!< 0x00000020 */
#define ADC_JDR2_JDATA_6               (0x0040U << ADC_JDR2_JDATA_Pos)         /*!< 0x00000040 */
#define ADC_JDR2_JDATA_7               (0x0080U << ADC_JDR2_JDATA_Pos)         /*!< 0x00000080 */
#define ADC_JDR2_JDATA_8               (0x0100U << ADC_JDR2_JDATA_Pos)         /*!< 0x00000100 */
#define ADC_JDR2_JDATA_9               (0x0200U << ADC_JDR2_JDATA_Pos)         /*!< 0x00000200 */
#define ADC_JDR2_JDATA_10              (0x0400U << ADC_JDR2_JDATA_Pos)         /*!< 0x00000400 */
#define ADC_JDR2_JDATA_11              (0x0800U << ADC_JDR2_JDATA_Pos)         /*!< 0x00000800 */
#define ADC_JDR2_JDATA_12              (0x1000U << ADC_JDR2_JDATA_Pos)         /*!< 0x00001000 */
#define ADC_JDR2_JDATA_13              (0x2000U << ADC_JDR2_JDATA_Pos)         /*!< 0x00002000 */
#define ADC_JDR2_JDATA_14              (0x4000U << ADC_JDR2_JDATA_Pos)         /*!< 0x00004000 */
#define ADC_JDR2_JDATA_15              (0x8000U << ADC_JDR2_JDATA_Pos)         /*!< 0x00008000 */

/********************  Bit definition for ADC_JDR3 register  ******************/
#define ADC_JDR3_JDATA_Pos             (0U)                                    
#define ADC_JDR3_JDATA_Msk             (0xFFFFU << ADC_JDR3_JDATA_Pos)         /*!< 0x0000FFFF */
#define ADC_JDR3_JDATA                 ADC_JDR3_JDATA_Msk                      /*!< ADC group injected sequencer rank 3 conversion data */
#define ADC_JDR3_JDATA_0               (0x0001U << ADC_JDR3_JDATA_Pos)         /*!< 0x00000001 */
#define ADC_JDR3_JDATA_1               (0x0002U << ADC_JDR3_JDATA_Pos)         /*!< 0x00000002 */
#define ADC_JDR3_JDATA_2               (0x0004U << ADC_JDR3_JDATA_Pos)         /*!< 0x00000004 */
#define ADC_JDR3_JDATA_3               (0x0008U << ADC_JDR3_JDATA_Pos)         /*!< 0x00000008 */
#define ADC_JDR3_JDATA_4               (0x0010U << ADC_JDR3_JDATA_Pos)         /*!< 0x00000010 */
#define ADC_JDR3_JDATA_5               (0x0020U << ADC_JDR3_JDATA_Pos)         /*!< 0x00000020 */
#define ADC_JDR3_JDATA_6               (0x0040U << ADC_JDR3_JDATA_Pos)         /*!< 0x00000040 */
#define ADC_JDR3_JDATA_7               (0x0080U << ADC_JDR3_JDATA_Pos)         /*!< 0x00000080 */
#define ADC_JDR3_JDATA_8               (0x0100U << ADC_JDR3_JDATA_Pos)         /*!< 0x00000100 */
#define ADC_JDR3_JDATA_9               (0x0200U << ADC_JDR3_JDATA_Pos)         /*!< 0x00000200 */
#define ADC_JDR3_JDATA_10              (0x0400U << ADC_JDR3_JDATA_Pos)         /*!< 0x00000400 */
#define ADC_JDR3_JDATA_11              (0x0800U << ADC_JDR3_JDATA_Pos)         /*!< 0x00000800 */
#define ADC_JDR3_JDATA_12              (0x1000U << ADC_JDR3_JDATA_Pos)         /*!< 0x00001000 */
#define ADC_JDR3_JDATA_13              (0x2000U << ADC_JDR3_JDATA_Pos)         /*!< 0x00002000 */
#define ADC_JDR3_JDATA_14              (0x4000U << ADC_JDR3_JDATA_Pos)         /*!< 0x00004000 */
#define ADC_JDR3_JDATA_15              (0x8000U << ADC_JDR3_JDATA_Pos)         /*!< 0x00008000 */

/********************  Bit definition for ADC_JDR4 register  ******************/
#define ADC_JDR4_JDATA_Pos             (0U)                                    
#define ADC_JDR4_JDATA_Msk             (0xFFFFU << ADC_JDR4_JDATA_Pos)         /*!< 0x0000FFFF */
#define ADC_JDR4_JDATA                 ADC_JDR4_JDATA_Msk                      /*!< ADC group injected sequencer rank 4 conversion data */
#define ADC_JDR4_JDATA_0               (0x0001U << ADC_JDR4_JDATA_Pos)         /*!< 0x00000001 */
#define ADC_JDR4_JDATA_1               (0x0002U << ADC_JDR4_JDATA_Pos)         /*!< 0x00000002 */
#define ADC_JDR4_JDATA_2               (0x0004U << ADC_JDR4_JDATA_Pos)         /*!< 0x00000004 */
#define ADC_JDR4_JDATA_3               (0x0008U << ADC_JDR4_JDATA_Pos)         /*!< 0x00000008 */
#define ADC_JDR4_JDATA_4               (0x0010U << ADC_JDR4_JDATA_Pos)         /*!< 0x00000010 */
#define ADC_JDR4_JDATA_5               (0x0020U << ADC_JDR4_JDATA_Pos)         /*!< 0x00000020 */
#define ADC_JDR4_JDATA_6               (0x0040U << ADC_JDR4_JDATA_Pos)         /*!< 0x00000040 */
#define ADC_JDR4_JDATA_7               (0x0080U << ADC_JDR4_JDATA_Pos)         /*!< 0x00000080 */
#define ADC_JDR4_JDATA_8               (0x0100U << ADC_JDR4_JDATA_Pos)         /*!< 0x00000100 */
#define ADC_JDR4_JDATA_9               (0x0200U << ADC_JDR4_JDATA_Pos)         /*!< 0x00000200 */
#define ADC_JDR4_JDATA_10              (0x0400U << ADC_JDR4_JDATA_Pos)         /*!< 0x00000400 */
#define ADC_JDR4_JDATA_11              (0x0800U << ADC_JDR4_JDATA_Pos)         /*!< 0x00000800 */
#define ADC_JDR4_JDATA_12              (0x1000U << ADC_JDR4_JDATA_Pos)         /*!< 0x00001000 */
#define ADC_JDR4_JDATA_13              (0x2000U << ADC_JDR4_JDATA_Pos)         /*!< 0x00002000 */
#define ADC_JDR4_JDATA_14              (0x4000U << ADC_JDR4_JDATA_Pos)         /*!< 0x00004000 */
#define ADC_JDR4_JDATA_15              (0x8000U << ADC_JDR4_JDATA_Pos)         /*!< 0x00008000 */

/********************  Bit definition for ADC_AWD2CR register  ****************/
#define ADC_AWD2CR_AWD2CH_Pos          (0U)                                    
#define ADC_AWD2CR_AWD2CH_Msk          (0x7FFFFU << ADC_AWD2CR_AWD2CH_Pos)     /*!< 0x0007FFFF */
#define ADC_AWD2CR_AWD2CH              ADC_AWD2CR_AWD2CH_Msk                   /*!< ADC analog watchdog 2 monitored channel selection */
#define ADC_AWD2CR_AWD2CH_0            (0x00001U << ADC_AWD2CR_AWD2CH_Pos)     /*!< 0x00000001 */
#define ADC_AWD2CR_AWD2CH_1            (0x00002U << ADC_AWD2CR_AWD2CH_Pos)     /*!< 0x00000002 */
#define ADC_AWD2CR_AWD2CH_2            (0x00004U << ADC_AWD2CR_AWD2CH_Pos)     /*!< 0x00000004 */
#define ADC_AWD2CR_AWD2CH_3            (0x00008U << ADC_AWD2CR_AWD2CH_Pos)     /*!< 0x00000008 */
#define ADC_AWD2CR_AWD2CH_4            (0x00010U << ADC_AWD2CR_AWD2CH_Pos)     /*!< 0x00000010 */
#define ADC_AWD2CR_AWD2CH_5            (0x00020U << ADC_AWD2CR_AWD2CH_Pos)     /*!< 0x00000020 */
#define ADC_AWD2CR_AWD2CH_6            (0x00040U << ADC_AWD2CR_AWD2CH_Pos)     /*!< 0x00000040 */
#define ADC_AWD2CR_AWD2CH_7            (0x00080U << ADC_AWD2CR_AWD2CH_Pos)     /*!< 0x00000080 */
#define ADC_AWD2CR_AWD2CH_8            (0x00100U << ADC_AWD2CR_AWD2CH_Pos)     /*!< 0x00000100 */
#define ADC_AWD2CR_AWD2CH_9            (0x00200U << ADC_AWD2CR_AWD2CH_Pos)     /*!< 0x00000200 */
#define ADC_AWD2CR_AWD2CH_10           (0x00400U << ADC_AWD2CR_AWD2CH_Pos)     /*!< 0x00000400 */
#define ADC_AWD2CR_AWD2CH_11           (0x00800U << ADC_AWD2CR_AWD2CH_Pos)     /*!< 0x00000800 */
#define ADC_AWD2CR_AWD2CH_12           (0x01000U << ADC_AWD2CR_AWD2CH_Pos)     /*!< 0x00001000 */
#define ADC_AWD2CR_AWD2CH_13           (0x02000U << ADC_AWD2CR_AWD2CH_Pos)     /*!< 0x00002000 */
#define ADC_AWD2CR_AWD2CH_14           (0x04000U << ADC_AWD2CR_AWD2CH_Pos)     /*!< 0x00004000 */
#define ADC_AWD2CR_AWD2CH_15           (0x08000U << ADC_AWD2CR_AWD2CH_Pos)     /*!< 0x00008000 */
#define ADC_AWD2CR_AWD2CH_16           (0x10000U << ADC_AWD2CR_AWD2CH_Pos)     /*!< 0x00010000 */
#define ADC_AWD2CR_AWD2CH_17           (0x20000U << ADC_AWD2CR_AWD2CH_Pos)     /*!< 0x00020000 */
#define ADC_AWD2CR_AWD2CH_18           (0x40000U << ADC_AWD2CR_AWD2CH_Pos)     /*!< 0x00040000 */

/********************  Bit definition for ADC_AWD3CR register  ****************/
#define ADC_AWD3CR_AWD3CH_Pos          (0U)                                    
#define ADC_AWD3CR_AWD3CH_Msk          (0x7FFFFU << ADC_AWD3CR_AWD3CH_Pos)     /*!< 0x0007FFFF */
#define ADC_AWD3CR_AWD3CH              ADC_AWD3CR_AWD3CH_Msk                   /*!< ADC analog watchdog 3 monitored channel selection */
#define ADC_AWD3CR_AWD3CH_0            (0x00001U << ADC_AWD3CR_AWD3CH_Pos)     /*!< 0x00000001 */
#define ADC_AWD3CR_AWD3CH_1            (0x00002U << ADC_AWD3CR_AWD3CH_Pos)     /*!< 0x00000002 */
#define ADC_AWD3CR_AWD3CH_2            (0x00004U << ADC_AWD3CR_AWD3CH_Pos)     /*!< 0x00000004 */
#define ADC_AWD3CR_AWD3CH_3            (0x00008U << ADC_AWD3CR_AWD3CH_Pos)     /*!< 0x00000008 */
#define ADC_AWD3CR_AWD3CH_4            (0x00010U << ADC_AWD3CR_AWD3CH_Pos)     /*!< 0x00000010 */
#define ADC_AWD3CR_AWD3CH_5            (0x00020U << ADC_AWD3CR_AWD3CH_Pos)     /*!< 0x00000020 */
#define ADC_AWD3CR_AWD3CH_6            (0x00040U << ADC_AWD3CR_AWD3CH_Pos)     /*!< 0x00000040 */
#define ADC_AWD3CR_AWD3CH_7            (0x00080U << ADC_AWD3CR_AWD3CH_Pos)     /*!< 0x00000080 */
#define ADC_AWD3CR_AWD3CH_8            (0x00100U << ADC_AWD3CR_AWD3CH_Pos)     /*!< 0x00000100 */
#define ADC_AWD3CR_AWD3CH_9            (0x00200U << ADC_AWD3CR_AWD3CH_Pos)     /*!< 0x00000200 */
#define ADC_AWD3CR_AWD3CH_10           (0x00400U << ADC_AWD3CR_AWD3CH_Pos)     /*!< 0x00000400 */
#define ADC_AWD3CR_AWD3CH_11           (0x00800U << ADC_AWD3CR_AWD3CH_Pos)     /*!< 0x00000800 */
#define ADC_AWD3CR_AWD3CH_12           (0x01000U << ADC_AWD3CR_AWD3CH_Pos)     /*!< 0x00001000 */
#define ADC_AWD3CR_AWD3CH_13           (0x02000U << ADC_AWD3CR_AWD3CH_Pos)     /*!< 0x00002000 */
#define ADC_AWD3CR_AWD3CH_14           (0x04000U << ADC_AWD3CR_AWD3CH_Pos)     /*!< 0x00004000 */
#define ADC_AWD3CR_AWD3CH_15           (0x08000U << ADC_AWD3CR_AWD3CH_Pos)     /*!< 0x00008000 */
#define ADC_AWD3CR_AWD3CH_16           (0x10000U << ADC_AWD3CR_AWD3CH_Pos)     /*!< 0x00010000 */
#define ADC_AWD3CR_AWD3CH_17           (0x20000U << ADC_AWD3CR_AWD3CH_Pos)     /*!< 0x00020000 */
#define ADC_AWD3CR_AWD3CH_18           (0x40000U << ADC_AWD3CR_AWD3CH_Pos)     /*!< 0x00040000 */

/********************  Bit definition for ADC_DIFSEL register  ****************/
#define ADC_DIFSEL_DIFSEL_Pos          (0U)                                    
#define ADC_DIFSEL_DIFSEL_Msk          (0x7FFFFU << ADC_DIFSEL_DIFSEL_Pos)     /*!< 0x0007FFFF */
#define ADC_DIFSEL_DIFSEL              ADC_DIFSEL_DIFSEL_Msk                   /*!< ADC channel differential or single-ended mode */
#define ADC_DIFSEL_DIFSEL_0            (0x00001U << ADC_DIFSEL_DIFSEL_Pos)     /*!< 0x00000001 */
#define ADC_DIFSEL_DIFSEL_1            (0x00002U << ADC_DIFSEL_DIFSEL_Pos)     /*!< 0x00000002 */
#define ADC_DIFSEL_DIFSEL_2            (0x00004U << ADC_DIFSEL_DIFSEL_Pos)     /*!< 0x00000004 */
#define ADC_DIFSEL_DIFSEL_3            (0x00008U << ADC_DIFSEL_DIFSEL_Pos)     /*!< 0x00000008 */
#define ADC_DIFSEL_DIFSEL_4            (0x00010U << ADC_DIFSEL_DIFSEL_Pos)     /*!< 0x00000010 */
#define ADC_DIFSEL_DIFSEL_5            (0x00020U << ADC_DIFSEL_DIFSEL_Pos)     /*!< 0x00000020 */
#define ADC_DIFSEL_DIFSEL_6            (0x00040U << ADC_DIFSEL_DIFSEL_Pos)     /*!< 0x00000040 */
#define ADC_DIFSEL_DIFSEL_7            (0x00080U << ADC_DIFSEL_DIFSEL_Pos)     /*!< 0x00000080 */
#define ADC_DIFSEL_DIFSEL_8            (0x00100U << ADC_DIFSEL_DIFSEL_Pos)     /*!< 0x00000100 */
#define ADC_DIFSEL_DIFSEL_9            (0x00200U << ADC_DIFSEL_DIFSEL_Pos)     /*!< 0x00000200 */
#define ADC_DIFSEL_DIFSEL_10           (0x00400U << ADC_DIFSEL_DIFSEL_Pos)     /*!< 0x00000400 */
#define ADC_DIFSEL_DIFSEL_11           (0x00800U << ADC_DIFSEL_DIFSEL_Pos)     /*!< 0x00000800 */
#define ADC_DIFSEL_DIFSEL_12           (0x01000U << ADC_DIFSEL_DIFSEL_Pos)     /*!< 0x00001000 */
#define ADC_DIFSEL_DIFSEL_13           (0x02000U << ADC_DIFSEL_DIFSEL_Pos)     /*!< 0x00002000 */
#define ADC_DIFSEL_DIFSEL_14           (0x04000U << ADC_DIFSEL_DIFSEL_Pos)     /*!< 0x00004000 */
#define ADC_DIFSEL_DIFSEL_15           (0x08000U << ADC_DIFSEL_DIFSEL_Pos)     /*!< 0x00008000 */
#define ADC_DIFSEL_DIFSEL_16           (0x10000U << ADC_DIFSEL_DIFSEL_Pos)     /*!< 0x00010000 */
#define ADC_DIFSEL_DIFSEL_17           (0x20000U << ADC_DIFSEL_DIFSEL_Pos)     /*!< 0x00020000 */
#define ADC_DIFSEL_DIFSEL_18           (0x40000U << ADC_DIFSEL_DIFSEL_Pos)     /*!< 0x00040000 */

/********************  Bit definition for ADC_CALFACT register  ***************/
#define ADC_CALFACT_CALFACT_S_Pos      (0U)                                    
#define ADC_CALFACT_CALFACT_S_Msk      (0x7FU << ADC_CALFACT_CALFACT_S_Pos)    /*!< 0x0000007F */
#define ADC_CALFACT_CALFACT_S          ADC_CALFACT_CALFACT_S_Msk               /*!< ADC calibration factor in single-ended mode */
#define ADC_CALFACT_CALFACT_S_0        (0x01U << ADC_CALFACT_CALFACT_S_Pos)    /*!< 0x00000001 */
#define ADC_CALFACT_CALFACT_S_1        (0x02U << ADC_CALFACT_CALFACT_S_Pos)    /*!< 0x00000002 */
#define ADC_CALFACT_CALFACT_S_2        (0x04U << ADC_CALFACT_CALFACT_S_Pos)    /*!< 0x00000004 */
#define ADC_CALFACT_CALFACT_S_3        (0x08U << ADC_CALFACT_CALFACT_S_Pos)    /*!< 0x00000008 */
#define ADC_CALFACT_CALFACT_S_4        (0x10U << ADC_CALFACT_CALFACT_S_Pos)    /*!< 0x00000010 */
#define ADC_CALFACT_CALFACT_S_5        (0x20U << ADC_CALFACT_CALFACT_S_Pos)    /*!< 0x00000020 */
#define ADC_CALFACT_CALFACT_S_6        (0x40U << ADC_CALFACT_CALFACT_S_Pos)    /*!< 0x00000040 */

#define ADC_CALFACT_CALFACT_D_Pos      (16U)                                   
#define ADC_CALFACT_CALFACT_D_Msk      (0x7FU << ADC_CALFACT_CALFACT_D_Pos)    /*!< 0x007F0000 */
#define ADC_CALFACT_CALFACT_D          ADC_CALFACT_CALFACT_D_Msk               /*!< ADC calibration factor in differential mode */
#define ADC_CALFACT_CALFACT_D_0        (0x01U << ADC_CALFACT_CALFACT_D_Pos)    /*!< 0x00010000 */
#define ADC_CALFACT_CALFACT_D_1        (0x02U << ADC_CALFACT_CALFACT_D_Pos)    /*!< 0x00020000 */
#define ADC_CALFACT_CALFACT_D_2        (0x04U << ADC_CALFACT_CALFACT_D_Pos)    /*!< 0x00040000 */
#define ADC_CALFACT_CALFACT_D_3        (0x08U << ADC_CALFACT_CALFACT_D_Pos)    /*!< 0x00080000 */
#define ADC_CALFACT_CALFACT_D_4        (0x10U << ADC_CALFACT_CALFACT_D_Pos)    /*!< 0x00100000 */
#define ADC_CALFACT_CALFACT_D_5        (0x20U << ADC_CALFACT_CALFACT_D_Pos)    /*!< 0x00200000 */
#define ADC_CALFACT_CALFACT_D_6        (0x40U << ADC_CALFACT_CALFACT_D_Pos)    /*!< 0x00400000 */

/*************************  ADC Common registers  *****************************/
/***************  Bit definition for ADC12_COMMON_CSR register  ***************/
#define ADC12_CSR_ADRDY_MST_Pos          (0U)                                  
#define ADC12_CSR_ADRDY_MST_Msk          (0x1U << ADC12_CSR_ADRDY_MST_Pos)     /*!< 0x00000001 */
#define ADC12_CSR_ADRDY_MST              ADC12_CSR_ADRDY_MST_Msk               /*!< Master ADC ready */
#define ADC12_CSR_ADRDY_EOSMP_MST_Pos    (1U)                                  
#define ADC12_CSR_ADRDY_EOSMP_MST_Msk    (0x1U << ADC12_CSR_ADRDY_EOSMP_MST_Pos) /*!< 0x00000002 */
#define ADC12_CSR_ADRDY_EOSMP_MST        ADC12_CSR_ADRDY_EOSMP_MST_Msk         /*!< End of sampling phase flag of the master ADC */
#define ADC12_CSR_ADRDY_EOC_MST_Pos      (2U)                                  
#define ADC12_CSR_ADRDY_EOC_MST_Msk      (0x1U << ADC12_CSR_ADRDY_EOC_MST_Pos) /*!< 0x00000004 */
#define ADC12_CSR_ADRDY_EOC_MST          ADC12_CSR_ADRDY_EOC_MST_Msk           /*!< End of regular conversion of the master ADC */
#define ADC12_CSR_ADRDY_EOS_MST_Pos      (3U)                                  
#define ADC12_CSR_ADRDY_EOS_MST_Msk      (0x1U << ADC12_CSR_ADRDY_EOS_MST_Pos) /*!< 0x00000008 */
#define ADC12_CSR_ADRDY_EOS_MST          ADC12_CSR_ADRDY_EOS_MST_Msk           /*!< End of regular sequence flag of the master ADC */
#define ADC12_CSR_ADRDY_OVR_MST_Pos      (4U)                                  
#define ADC12_CSR_ADRDY_OVR_MST_Msk      (0x1U << ADC12_CSR_ADRDY_OVR_MST_Pos) /*!< 0x00000010 */
#define ADC12_CSR_ADRDY_OVR_MST          ADC12_CSR_ADRDY_OVR_MST_Msk           /*!< Overrun flag of the master ADC */
#define ADC12_CSR_ADRDY_JEOC_MST_Pos     (5U)                                  
#define ADC12_CSR_ADRDY_JEOC_MST_Msk     (0x1U << ADC12_CSR_ADRDY_JEOC_MST_Pos) /*!< 0x00000020 */
#define ADC12_CSR_ADRDY_JEOC_MST         ADC12_CSR_ADRDY_JEOC_MST_Msk          /*!< End of injected conversion of the master ADC */
#define ADC12_CSR_ADRDY_JEOS_MST_Pos     (6U)                                  
#define ADC12_CSR_ADRDY_JEOS_MST_Msk     (0x1U << ADC12_CSR_ADRDY_JEOS_MST_Pos) /*!< 0x00000040 */
#define ADC12_CSR_ADRDY_JEOS_MST         ADC12_CSR_ADRDY_JEOS_MST_Msk          /*!< End of injected sequence flag of the master ADC */
#define ADC12_CSR_AWD1_MST_Pos           (7U)                                  
#define ADC12_CSR_AWD1_MST_Msk           (0x1U << ADC12_CSR_AWD1_MST_Pos)      /*!< 0x00000080 */
#define ADC12_CSR_AWD1_MST               ADC12_CSR_AWD1_MST_Msk                /*!< Analog watchdog 1 flag of the master ADC */
#define ADC12_CSR_AWD2_MST_Pos           (8U)                                  
#define ADC12_CSR_AWD2_MST_Msk           (0x1U << ADC12_CSR_AWD2_MST_Pos)      /*!< 0x00000100 */
#define ADC12_CSR_AWD2_MST               ADC12_CSR_AWD2_MST_Msk                /*!< Analog watchdog 2 flag of the master ADC */
#define ADC12_CSR_AWD3_MST_Pos           (9U)                                  
#define ADC12_CSR_AWD3_MST_Msk           (0x1U << ADC12_CSR_AWD3_MST_Pos)      /*!< 0x00000200 */
#define ADC12_CSR_AWD3_MST               ADC12_CSR_AWD3_MST_Msk                /*!< Analog watchdog 3 flag of the master ADC */
#define ADC12_CSR_JQOVF_MST_Pos          (10U)                                 
#define ADC12_CSR_JQOVF_MST_Msk          (0x1U << ADC12_CSR_JQOVF_MST_Pos)     /*!< 0x00000400 */
#define ADC12_CSR_JQOVF_MST              ADC12_CSR_JQOVF_MST_Msk               /*!< Injected context queue overflow flag of the master ADC */
#define ADC12_CSR_ADRDY_SLV_Pos          (16U)                                 
#define ADC12_CSR_ADRDY_SLV_Msk          (0x1U << ADC12_CSR_ADRDY_SLV_Pos)     /*!< 0x00010000 */
#define ADC12_CSR_ADRDY_SLV              ADC12_CSR_ADRDY_SLV_Msk               /*!< Slave ADC ready */
#define ADC12_CSR_ADRDY_EOSMP_SLV_Pos    (17U)                                 
#define ADC12_CSR_ADRDY_EOSMP_SLV_Msk    (0x1U << ADC12_CSR_ADRDY_EOSMP_SLV_Pos) /*!< 0x00020000 */
#define ADC12_CSR_ADRDY_EOSMP_SLV        ADC12_CSR_ADRDY_EOSMP_SLV_Msk         /*!< End of sampling phase flag of the slave ADC */
#define ADC12_CSR_ADRDY_EOC_SLV_Pos      (18U)                                 
#define ADC12_CSR_ADRDY_EOC_SLV_Msk      (0x1U << ADC12_CSR_ADRDY_EOC_SLV_Pos) /*!< 0x00040000 */
#define ADC12_CSR_ADRDY_EOC_SLV          ADC12_CSR_ADRDY_EOC_SLV_Msk           /*!< End of regular conversion of the slave ADC */
#define ADC12_CSR_ADRDY_EOS_SLV_Pos      (19U)                                 
#define ADC12_CSR_ADRDY_EOS_SLV_Msk      (0x1U << ADC12_CSR_ADRDY_EOS_SLV_Pos) /*!< 0x00080000 */
#define ADC12_CSR_ADRDY_EOS_SLV          ADC12_CSR_ADRDY_EOS_SLV_Msk           /*!< End of regular sequence flag of the slave ADC */
#define ADC12_CSR_ADRDY_OVR_SLV_Pos      (20U)                                 
#define ADC12_CSR_ADRDY_OVR_SLV_Msk      (0x1U << ADC12_CSR_ADRDY_OVR_SLV_Pos) /*!< 0x00100000 */
#define ADC12_CSR_ADRDY_OVR_SLV          ADC12_CSR_ADRDY_OVR_SLV_Msk           /*!< Overrun flag of the slave ADC */
#define ADC12_CSR_ADRDY_JEOC_SLV_Pos     (21U)                                 
#define ADC12_CSR_ADRDY_JEOC_SLV_Msk     (0x1U << ADC12_CSR_ADRDY_JEOC_SLV_Pos) /*!< 0x00200000 */
#define ADC12_CSR_ADRDY_JEOC_SLV         ADC12_CSR_ADRDY_JEOC_SLV_Msk          /*!< End of injected conversion of the slave ADC */
#define ADC12_CSR_ADRDY_JEOS_SLV_Pos     (22U)                                 
#define ADC12_CSR_ADRDY_JEOS_SLV_Msk     (0x1U << ADC12_CSR_ADRDY_JEOS_SLV_Pos) /*!< 0x00400000 */
#define ADC12_CSR_ADRDY_JEOS_SLV         ADC12_CSR_ADRDY_JEOS_SLV_Msk          /*!< End of injected sequence flag of the slave ADC */
#define ADC12_CSR_AWD1_SLV_Pos           (23U)                                 
#define ADC12_CSR_AWD1_SLV_Msk           (0x1U << ADC12_CSR_AWD1_SLV_Pos)      /*!< 0x00800000 */
#define ADC12_CSR_AWD1_SLV               ADC12_CSR_AWD1_SLV_Msk                /*!< Analog watchdog 1 flag of the slave ADC */
#define ADC12_CSR_AWD2_SLV_Pos           (24U)                                 
#define ADC12_CSR_AWD2_SLV_Msk           (0x1U << ADC12_CSR_AWD2_SLV_Pos)      /*!< 0x01000000 */
#define ADC12_CSR_AWD2_SLV               ADC12_CSR_AWD2_SLV_Msk                /*!< Analog watchdog 2 flag of the slave ADC */
#define ADC12_CSR_AWD3_SLV_Pos           (25U)                                 
#define ADC12_CSR_AWD3_SLV_Msk           (0x1U << ADC12_CSR_AWD3_SLV_Pos)      /*!< 0x02000000 */
#define ADC12_CSR_AWD3_SLV               ADC12_CSR_AWD3_SLV_Msk                /*!< Analog watchdog 3 flag of the slave ADC */
#define ADC12_CSR_JQOVF_SLV_Pos          (26U)                                 
#define ADC12_CSR_JQOVF_SLV_Msk          (0x1U << ADC12_CSR_JQOVF_SLV_Pos)     /*!< 0x04000000 */
#define ADC12_CSR_JQOVF_SLV              ADC12_CSR_JQOVF_SLV_Msk               /*!< Injected context queue overflow flag of the slave ADC */

/***************  Bit definition for ADC34_COMMON_CSR register  ***************/
#define ADC34_CSR_ADRDY_MST_Pos          (0U)                                  
#define ADC34_CSR_ADRDY_MST_Msk          (0x1U << ADC34_CSR_ADRDY_MST_Pos)     /*!< 0x00000001 */
#define ADC34_CSR_ADRDY_MST              ADC34_CSR_ADRDY_MST_Msk               /*!< Master ADC ready */
#define ADC34_CSR_ADRDY_EOSMP_MST_Pos    (1U)                                  
#define ADC34_CSR_ADRDY_EOSMP_MST_Msk    (0x1U << ADC34_CSR_ADRDY_EOSMP_MST_Pos) /*!< 0x00000002 */
#define ADC34_CSR_ADRDY_EOSMP_MST        ADC34_CSR_ADRDY_EOSMP_MST_Msk         /*!< End of sampling phase flag of the master ADC */
#define ADC34_CSR_ADRDY_EOC_MST_Pos      (2U)                                  
#define ADC34_CSR_ADRDY_EOC_MST_Msk      (0x1U << ADC34_CSR_ADRDY_EOC_MST_Pos) /*!< 0x00000004 */
#define ADC34_CSR_ADRDY_EOC_MST          ADC34_CSR_ADRDY_EOC_MST_Msk           /*!< End of regular conversion of the master ADC */
#define ADC34_CSR_ADRDY_EOS_MST_Pos      (3U)                                  
#define ADC34_CSR_ADRDY_EOS_MST_Msk      (0x1U << ADC34_CSR_ADRDY_EOS_MST_Pos) /*!< 0x00000008 */
#define ADC34_CSR_ADRDY_EOS_MST          ADC34_CSR_ADRDY_EOS_MST_Msk           /*!< End of regular sequence flag of the master ADC */
#define ADC34_CSR_ADRDY_OVR_MST_Pos      (4U)                                  
#define ADC34_CSR_ADRDY_OVR_MST_Msk      (0x1U << ADC34_CSR_ADRDY_OVR_MST_Pos) /*!< 0x00000010 */
#define ADC34_CSR_ADRDY_OVR_MST          ADC34_CSR_ADRDY_OVR_MST_Msk           /*!< Overrun flag of the master ADC */
#define ADC34_CSR_ADRDY_JEOC_MST_Pos     (5U)                                  
#define ADC34_CSR_ADRDY_JEOC_MST_Msk     (0x1U << ADC34_CSR_ADRDY_JEOC_MST_Pos) /*!< 0x00000020 */
#define ADC34_CSR_ADRDY_JEOC_MST         ADC34_CSR_ADRDY_JEOC_MST_Msk          /*!< End of injected conversion of the master ADC */
#define ADC34_CSR_ADRDY_JEOS_MST_Pos     (6U)                                  
#define ADC34_CSR_ADRDY_JEOS_MST_Msk     (0x1U << ADC34_CSR_ADRDY_JEOS_MST_Pos) /*!< 0x00000040 */
#define ADC34_CSR_ADRDY_JEOS_MST         ADC34_CSR_ADRDY_JEOS_MST_Msk          /*!< End of injected sequence flag of the master ADC */
#define ADC34_CSR_AWD1_MST_Pos           (7U)                                  
#define ADC34_CSR_AWD1_MST_Msk           (0x1U << ADC34_CSR_AWD1_MST_Pos)      /*!< 0x00000080 */
#define ADC34_CSR_AWD1_MST               ADC34_CSR_AWD1_MST_Msk                /*!< Analog watchdog 1 flag of the master ADC */
#define ADC34_CSR_AWD2_MST_Pos           (8U)                                  
#define ADC34_CSR_AWD2_MST_Msk           (0x1U << ADC34_CSR_AWD2_MST_Pos)      /*!< 0x00000100 */
#define ADC34_CSR_AWD2_MST               ADC34_CSR_AWD2_MST_Msk                /*!< Analog watchdog 2 flag of the master ADC */
#define ADC34_CSR_AWD3_MST_Pos           (9U)                                  
#define ADC34_CSR_AWD3_MST_Msk           (0x1U << ADC34_CSR_AWD3_MST_Pos)      /*!< 0x00000200 */
#define ADC34_CSR_AWD3_MST               ADC34_CSR_AWD3_MST_Msk                /*!< Analog watchdog 3 flag of the master ADC */
#define ADC34_CSR_JQOVF_MST_Pos          (10U)                                 
#define ADC34_CSR_JQOVF_MST_Msk          (0x1U << ADC34_CSR_JQOVF_MST_Pos)     /*!< 0x00000400 */
#define ADC34_CSR_JQOVF_MST              ADC34_CSR_JQOVF_MST_Msk               /*!< Injected context queue overflow flag of the master ADC */
#define ADC34_CSR_ADRDY_SLV_Pos          (16U)                                 
#define ADC34_CSR_ADRDY_SLV_Msk          (0x1U << ADC34_CSR_ADRDY_SLV_Pos)     /*!< 0x00010000 */
#define ADC34_CSR_ADRDY_SLV              ADC34_CSR_ADRDY_SLV_Msk               /*!< Slave ADC ready */
#define ADC34_CSR_ADRDY_EOSMP_SLV_Pos    (17U)                                 
#define ADC34_CSR_ADRDY_EOSMP_SLV_Msk    (0x1U << ADC34_CSR_ADRDY_EOSMP_SLV_Pos) /*!< 0x00020000 */
#define ADC34_CSR_ADRDY_EOSMP_SLV        ADC34_CSR_ADRDY_EOSMP_SLV_Msk         /*!< End of sampling phase flag of the slave ADC */
#define ADC34_CSR_ADRDY_EOC_SLV_Pos      (18U)                                 
#define ADC34_CSR_ADRDY_EOC_SLV_Msk      (0x1U << ADC34_CSR_ADRDY_EOC_SLV_Pos) /*!< 0x00040000 */
#define ADC34_CSR_ADRDY_EOC_SLV          ADC34_CSR_ADRDY_EOC_SLV_Msk           /*!< End of regular conversion of the slave ADC */
#define ADC34_CSR_ADRDY_EOS_SLV_Pos      (19U)                                 
#define ADC34_CSR_ADRDY_EOS_SLV_Msk      (0x1U << ADC34_CSR_ADRDY_EOS_SLV_Pos) /*!< 0x00080000 */
#define ADC34_CSR_ADRDY_EOS_SLV          ADC34_CSR_ADRDY_EOS_SLV_Msk           /*!< End of regular sequence flag of the slave ADC */
#define ADC12_CSR_ADRDY_OVR_SLV_Pos      (20U)                                 
#define ADC12_CSR_ADRDY_OVR_SLV_Msk      (0x1U << ADC12_CSR_ADRDY_OVR_SLV_Pos) /*!< 0x00100000 */
#define ADC12_CSR_ADRDY_OVR_SLV          ADC12_CSR_ADRDY_OVR_SLV_Msk           /*!< Overrun flag of the slave ADC */
#define ADC34_CSR_ADRDY_JEOC_SLV_Pos     (21U)                                 
#define ADC34_CSR_ADRDY_JEOC_SLV_Msk     (0x1U << ADC34_CSR_ADRDY_JEOC_SLV_Pos) /*!< 0x00200000 */
#define ADC34_CSR_ADRDY_JEOC_SLV         ADC34_CSR_ADRDY_JEOC_SLV_Msk          /*!< End of injected conversion of the slave ADC */
#define ADC34_CSR_ADRDY_JEOS_SLV_Pos     (22U)                                 
#define ADC34_CSR_ADRDY_JEOS_SLV_Msk     (0x1U << ADC34_CSR_ADRDY_JEOS_SLV_Pos) /*!< 0x00400000 */
#define ADC34_CSR_ADRDY_JEOS_SLV         ADC34_CSR_ADRDY_JEOS_SLV_Msk          /*!< End of injected sequence flag of the slave ADC */
#define ADC34_CSR_AWD1_SLV_Pos           (23U)                                 
#define ADC34_CSR_AWD1_SLV_Msk           (0x1U << ADC34_CSR_AWD1_SLV_Pos)      /*!< 0x00800000 */
#define ADC34_CSR_AWD1_SLV               ADC34_CSR_AWD1_SLV_Msk                /*!< Analog watchdog 1 flag of the slave ADC */
#define ADC34_CSR_AWD2_SLV_Pos           (24U)                                 
#define ADC34_CSR_AWD2_SLV_Msk           (0x1U << ADC34_CSR_AWD2_SLV_Pos)      /*!< 0x01000000 */
#define ADC34_CSR_AWD2_SLV               ADC34_CSR_AWD2_SLV_Msk                /*!< Analog watchdog 2 flag of the slave ADC */
#define ADC34_CSR_AWD3_SLV_Pos           (25U)                                 
#define ADC34_CSR_AWD3_SLV_Msk           (0x1U << ADC34_CSR_AWD3_SLV_Pos)      /*!< 0x02000000 */
#define ADC34_CSR_AWD3_SLV               ADC34_CSR_AWD3_SLV_Msk                /*!< Analog watchdog 3 flag of the slave ADC */
#define ADC34_CSR_JQOVF_SLV_Pos          (26U)                                 
#define ADC34_CSR_JQOVF_SLV_Msk          (0x1U << ADC34_CSR_JQOVF_SLV_Pos)     /*!< 0x04000000 */
#define ADC34_CSR_JQOVF_SLV              ADC34_CSR_JQOVF_SLV_Msk               /*!< Injected context queue overflow flag of the slave ADC */

/***************  Bit definition for ADC12_COMMON_CCR register  ***************/
#define ADC12_CCR_MULTI_Pos              (0U)                                  
#define ADC12_CCR_MULTI_Msk              (0x1FU << ADC12_CCR_MULTI_Pos)        /*!< 0x0000001F */
#define ADC12_CCR_MULTI                  ADC12_CCR_MULTI_Msk                   /*!< Multi ADC mode selection */
#define ADC12_CCR_MULTI_0                (0x01U << ADC12_CCR_MULTI_Pos)        /*!< 0x00000001 */
#define ADC12_CCR_MULTI_1                (0x02U << ADC12_CCR_MULTI_Pos)        /*!< 0x00000002 */
#define ADC12_CCR_MULTI_2                (0x04U << ADC12_CCR_MULTI_Pos)        /*!< 0x00000004 */
#define ADC12_CCR_MULTI_3                (0x08U << ADC12_CCR_MULTI_Pos)        /*!< 0x00000008 */
#define ADC12_CCR_MULTI_4                (0x10U << ADC12_CCR_MULTI_Pos)        /*!< 0x00000010 */
#define ADC12_CCR_DELAY_Pos              (8U)                                  
#define ADC12_CCR_DELAY_Msk              (0xFU << ADC12_CCR_DELAY_Pos)         /*!< 0x00000F00 */
#define ADC12_CCR_DELAY                  ADC12_CCR_DELAY_Msk                   /*!< Delay between 2 sampling phases */
#define ADC12_CCR_DELAY_0                (0x1U << ADC12_CCR_DELAY_Pos)         /*!< 0x00000100 */
#define ADC12_CCR_DELAY_1                (0x2U << ADC12_CCR_DELAY_Pos)         /*!< 0x00000200 */
#define ADC12_CCR_DELAY_2                (0x4U << ADC12_CCR_DELAY_Pos)         /*!< 0x00000400 */
#define ADC12_CCR_DELAY_3                (0x8U << ADC12_CCR_DELAY_Pos)         /*!< 0x00000800 */
#define ADC12_CCR_DMACFG_Pos             (13U)                                 
#define ADC12_CCR_DMACFG_Msk             (0x1U << ADC12_CCR_DMACFG_Pos)        /*!< 0x00002000 */
#define ADC12_CCR_DMACFG                 ADC12_CCR_DMACFG_Msk                  /*!< DMA configuration for multi-ADC mode */
#define ADC12_CCR_MDMA_Pos               (14U)                                 
#define ADC12_CCR_MDMA_Msk               (0x3U << ADC12_CCR_MDMA_Pos)          /*!< 0x0000C000 */
#define ADC12_CCR_MDMA                   ADC12_CCR_MDMA_Msk                    /*!< DMA mode for multi-ADC mode */
#define ADC12_CCR_MDMA_0                 (0x1U << ADC12_CCR_MDMA_Pos)          /*!< 0x00004000 */
#define ADC12_CCR_MDMA_1                 (0x2U << ADC12_CCR_MDMA_Pos)          /*!< 0x00008000 */
#define ADC12_CCR_CKMODE_Pos             (16U)                                 
#define ADC12_CCR_CKMODE_Msk             (0x3U << ADC12_CCR_CKMODE_Pos)        /*!< 0x00030000 */
#define ADC12_CCR_CKMODE                 ADC12_CCR_CKMODE_Msk                  /*!< ADC clock mode */
#define ADC12_CCR_CKMODE_0               (0x1U << ADC12_CCR_CKMODE_Pos)        /*!< 0x00010000 */
#define ADC12_CCR_CKMODE_1               (0x2U << ADC12_CCR_CKMODE_Pos)        /*!< 0x00020000 */
#define ADC12_CCR_VREFEN_Pos             (22U)                                 
#define ADC12_CCR_VREFEN_Msk             (0x1U << ADC12_CCR_VREFEN_Pos)        /*!< 0x00400000 */
#define ADC12_CCR_VREFEN                 ADC12_CCR_VREFEN_Msk                  /*!< VREFINT enable */
#define ADC12_CCR_TSEN_Pos               (23U)                                 
#define ADC12_CCR_TSEN_Msk               (0x1U << ADC12_CCR_TSEN_Pos)          /*!< 0x00800000 */
#define ADC12_CCR_TSEN                   ADC12_CCR_TSEN_Msk                    /*!< Temperature sensor enable */
#define ADC12_CCR_VBATEN_Pos             (24U)                                 
#define ADC12_CCR_VBATEN_Msk             (0x1U << ADC12_CCR_VBATEN_Pos)        /*!< 0x01000000 */
#define ADC12_CCR_VBATEN                 ADC12_CCR_VBATEN_Msk                  /*!< VBAT enable */

/***************  Bit definition for ADC12_COMMON_CDR register  ***************/
#define ADC12_CDR_RDATA_MST_Pos          (0U)                                  
#define ADC12_CDR_RDATA_MST_Msk          (0xFFFFU << ADC12_CDR_RDATA_MST_Pos)  /*!< 0x0000FFFF */
#define ADC12_CDR_RDATA_MST              ADC12_CDR_RDATA_MST_Msk               /*!< Regular Data of the master ADC */
#define ADC12_CDR_RDATA_MST_0            (0x0001U << ADC12_CDR_RDATA_MST_Pos)  /*!< 0x00000001 */
#define ADC12_CDR_RDATA_MST_1            (0x0002U << ADC12_CDR_RDATA_MST_Pos)  /*!< 0x00000002 */
#define ADC12_CDR_RDATA_MST_2            (0x0004U << ADC12_CDR_RDATA_MST_Pos)  /*!< 0x00000004 */
#define ADC12_CDR_RDATA_MST_3            (0x0008U << ADC12_CDR_RDATA_MST_Pos)  /*!< 0x00000008 */
#define ADC12_CDR_RDATA_MST_4            (0x0010U << ADC12_CDR_RDATA_MST_Pos)  /*!< 0x00000010 */
#define ADC12_CDR_RDATA_MST_5            (0x0020U << ADC12_CDR_RDATA_MST_Pos)  /*!< 0x00000020 */
#define ADC12_CDR_RDATA_MST_6            (0x0040U << ADC12_CDR_RDATA_MST_Pos)  /*!< 0x00000040 */
#define ADC12_CDR_RDATA_MST_7            (0x0080U << ADC12_CDR_RDATA_MST_Pos)  /*!< 0x00000080 */
#define ADC12_CDR_RDATA_MST_8            (0x0100U << ADC12_CDR_RDATA_MST_Pos)  /*!< 0x00000100 */
#define ADC12_CDR_RDATA_MST_9            (0x0200U << ADC12_CDR_RDATA_MST_Pos)  /*!< 0x00000200 */
#define ADC12_CDR_RDATA_MST_10           (0x0400U << ADC12_CDR_RDATA_MST_Pos)  /*!< 0x00000400 */
#define ADC12_CDR_RDATA_MST_11           (0x0800U << ADC12_CDR_RDATA_MST_Pos)  /*!< 0x00000800 */
#define ADC12_CDR_RDATA_MST_12           (0x1000U << ADC12_CDR_RDATA_MST_Pos)  /*!< 0x00001000 */
#define ADC12_CDR_RDATA_MST_13           (0x2000U << ADC12_CDR_RDATA_MST_Pos)  /*!< 0x00002000 */
#define ADC12_CDR_RDATA_MST_14           (0x4000U << ADC12_CDR_RDATA_MST_Pos)  /*!< 0x00004000 */
#define ADC12_CDR_RDATA_MST_15           (0x8000U << ADC12_CDR_RDATA_MST_Pos)  /*!< 0x00008000 */

#define ADC12_CDR_RDATA_SLV_Pos          (16U)                                 
#define ADC12_CDR_RDATA_SLV_Msk          (0xFFFFU << ADC12_CDR_RDATA_SLV_Pos)  /*!< 0xFFFF0000 */
#define ADC12_CDR_RDATA_SLV              ADC12_CDR_RDATA_SLV_Msk               /*!< Regular Data of the master ADC */
#define ADC12_CDR_RDATA_SLV_0            (0x0001U << ADC12_CDR_RDATA_SLV_Pos)  /*!< 0x00010000 */
#define ADC12_CDR_RDATA_SLV_1            (0x0002U << ADC12_CDR_RDATA_SLV_Pos)  /*!< 0x00020000 */
#define ADC12_CDR_RDATA_SLV_2            (0x0004U << ADC12_CDR_RDATA_SLV_Pos)  /*!< 0x00040000 */
#define ADC12_CDR_RDATA_SLV_3            (0x0008U << ADC12_CDR_RDATA_SLV_Pos)  /*!< 0x00080000 */
#define ADC12_CDR_RDATA_SLV_4            (0x0010U << ADC12_CDR_RDATA_SLV_Pos)  /*!< 0x00100000 */
#define ADC12_CDR_RDATA_SLV_5            (0x0020U << ADC12_CDR_RDATA_SLV_Pos)  /*!< 0x00200000 */
#define ADC12_CDR_RDATA_SLV_6            (0x0040U << ADC12_CDR_RDATA_SLV_Pos)  /*!< 0x00400000 */
#define ADC12_CDR_RDATA_SLV_7            (0x0080U << ADC12_CDR_RDATA_SLV_Pos)  /*!< 0x00800000 */
#define ADC12_CDR_RDATA_SLV_8            (0x0100U << ADC12_CDR_RDATA_SLV_Pos)  /*!< 0x01000000 */
#define ADC12_CDR_RDATA_SLV_9            (0x0200U << ADC12_CDR_RDATA_SLV_Pos)  /*!< 0x02000000 */
#define ADC12_CDR_RDATA_SLV_10           (0x0400U << ADC12_CDR_RDATA_SLV_Pos)  /*!< 0x04000000 */
#define ADC12_CDR_RDATA_SLV_11           (0x0800U << ADC12_CDR_RDATA_SLV_Pos)  /*!< 0x08000000 */
#define ADC12_CDR_RDATA_SLV_12           (0x1000U << ADC12_CDR_RDATA_SLV_Pos)  /*!< 0x10000000 */
#define ADC12_CDR_RDATA_SLV_13           (0x2000U << ADC12_CDR_RDATA_SLV_Pos)  /*!< 0x20000000 */
#define ADC12_CDR_RDATA_SLV_14           (0x4000U << ADC12_CDR_RDATA_SLV_Pos)  /*!< 0x40000000 */
#define ADC12_CDR_RDATA_SLV_15           (0x8000U << ADC12_CDR_RDATA_SLV_Pos)  /*!< 0x80000000 */

/********************  Bit definition for ADC_CSR register  *******************/
#define ADC_CSR_ADRDY_MST_Pos          (0U)                                    
#define ADC_CSR_ADRDY_MST_Msk          (0x1U << ADC_CSR_ADRDY_MST_Pos)         /*!< 0x00000001 */
#define ADC_CSR_ADRDY_MST              ADC_CSR_ADRDY_MST_Msk                   /*!< ADC multimode master ready flag */
#define ADC_CSR_EOSMP_MST_Pos          (1U)                                    
#define ADC_CSR_EOSMP_MST_Msk          (0x1U << ADC_CSR_EOSMP_MST_Pos)         /*!< 0x00000002 */
#define ADC_CSR_EOSMP_MST              ADC_CSR_EOSMP_MST_Msk                   /*!< ADC multimode master group regular end of sampling flag */
#define ADC_CSR_EOC_MST_Pos            (2U)                                    
#define ADC_CSR_EOC_MST_Msk            (0x1U << ADC_CSR_EOC_MST_Pos)           /*!< 0x00000004 */
#define ADC_CSR_EOC_MST                ADC_CSR_EOC_MST_Msk                     /*!< ADC multimode master group regular end of unitary conversion flag */
#define ADC_CSR_EOS_MST_Pos            (3U)                                    
#define ADC_CSR_EOS_MST_Msk            (0x1U << ADC_CSR_EOS_MST_Pos)           /*!< 0x00000008 */
#define ADC_CSR_EOS_MST                ADC_CSR_EOS_MST_Msk                     /*!< ADC multimode master group regular end of sequence conversions flag */
#define ADC_CSR_OVR_MST_Pos            (4U)                                    
#define ADC_CSR_OVR_MST_Msk            (0x1U << ADC_CSR_OVR_MST_Pos)           /*!< 0x00000010 */
#define ADC_CSR_OVR_MST                ADC_CSR_OVR_MST_Msk                     /*!< ADC multimode master group regular overrun flag */
#define ADC_CSR_JEOC_MST_Pos           (5U)                                    
#define ADC_CSR_JEOC_MST_Msk           (0x1U << ADC_CSR_JEOC_MST_Pos)          /*!< 0x00000020 */
#define ADC_CSR_JEOC_MST               ADC_CSR_JEOC_MST_Msk                    /*!< ADC multimode master group injected end of unitary conversion flag */
#define ADC_CSR_JEOS_MST_Pos           (6U)                                    
#define ADC_CSR_JEOS_MST_Msk           (0x1U << ADC_CSR_JEOS_MST_Pos)          /*!< 0x00000040 */
#define ADC_CSR_JEOS_MST               ADC_CSR_JEOS_MST_Msk                    /*!< ADC multimode master group injected end of sequence conversions flag */
#define ADC_CSR_AWD1_MST_Pos           (7U)                                    
#define ADC_CSR_AWD1_MST_Msk           (0x1U << ADC_CSR_AWD1_MST_Pos)          /*!< 0x00000080 */
#define ADC_CSR_AWD1_MST               ADC_CSR_AWD1_MST_Msk                    /*!< ADC multimode master analog watchdog 1 flag */
#define ADC_CSR_AWD2_MST_Pos           (8U)                                    
#define ADC_CSR_AWD2_MST_Msk           (0x1U << ADC_CSR_AWD2_MST_Pos)          /*!< 0x00000100 */
#define ADC_CSR_AWD2_MST               ADC_CSR_AWD2_MST_Msk                    /*!< ADC multimode master analog watchdog 2 flag */
#define ADC_CSR_AWD3_MST_Pos           (9U)                                    
#define ADC_CSR_AWD3_MST_Msk           (0x1U << ADC_CSR_AWD3_MST_Pos)          /*!< 0x00000200 */
#define ADC_CSR_AWD3_MST               ADC_CSR_AWD3_MST_Msk                    /*!< ADC multimode master analog watchdog 3 flag */
#define ADC_CSR_JQOVF_MST_Pos          (10U)                                   
#define ADC_CSR_JQOVF_MST_Msk          (0x1U << ADC_CSR_JQOVF_MST_Pos)         /*!< 0x00000400 */
#define ADC_CSR_JQOVF_MST              ADC_CSR_JQOVF_MST_Msk                   /*!< ADC multimode master group injected contexts queue overflow flag */

#define ADC_CSR_ADRDY_SLV_Pos          (16U)                                   
#define ADC_CSR_ADRDY_SLV_Msk          (0x1U << ADC_CSR_ADRDY_SLV_Pos)         /*!< 0x00010000 */
#define ADC_CSR_ADRDY_SLV              ADC_CSR_ADRDY_SLV_Msk                   /*!< ADC multimode slave ready flag */
#define ADC_CSR_EOSMP_SLV_Pos          (17U)                                   
#define ADC_CSR_EOSMP_SLV_Msk          (0x1U << ADC_CSR_EOSMP_SLV_Pos)         /*!< 0x00020000 */
#define ADC_CSR_EOSMP_SLV              ADC_CSR_EOSMP_SLV_Msk                   /*!< ADC multimode slave group regular end of sampling flag */
#define ADC_CSR_EOC_SLV_Pos            (18U)                                   
#define ADC_CSR_EOC_SLV_Msk            (0x1U << ADC_CSR_EOC_SLV_Pos)           /*!< 0x00040000 */
#define ADC_CSR_EOC_SLV                ADC_CSR_EOC_SLV_Msk                     /*!< ADC multimode slave group regular end of unitary conversion flag */
#define ADC_CSR_EOS_SLV_Pos            (19U)                                   
#define ADC_CSR_EOS_SLV_Msk            (0x1U << ADC_CSR_EOS_SLV_Pos)           /*!< 0x00080000 */
#define ADC_CSR_EOS_SLV                ADC_CSR_EOS_SLV_Msk                     /*!< ADC multimode slave group regular end of sequence conversions flag */
#define ADC_CSR_OVR_SLV_Pos            (20U)                                   
#define ADC_CSR_OVR_SLV_Msk            (0x1U << ADC_CSR_OVR_SLV_Pos)           /*!< 0x00100000 */
#define ADC_CSR_OVR_SLV                ADC_CSR_OVR_SLV_Msk                     /*!< ADC multimode slave group regular overrun flag */
#define ADC_CSR_JEOC_SLV_Pos           (21U)                                   
#define ADC_CSR_JEOC_SLV_Msk           (0x1U << ADC_CSR_JEOC_SLV_Pos)          /*!< 0x00200000 */
#define ADC_CSR_JEOC_SLV               ADC_CSR_JEOC_SLV_Msk                    /*!< ADC multimode slave group injected end of unitary conversion flag */
#define ADC_CSR_JEOS_SLV_Pos           (22U)                                   
#define ADC_CSR_JEOS_SLV_Msk           (0x1U << ADC_CSR_JEOS_SLV_Pos)          /*!< 0x00400000 */
#define ADC_CSR_JEOS_SLV               ADC_CSR_JEOS_SLV_Msk                    /*!< ADC multimode slave group injected end of sequence conversions flag */
#define ADC_CSR_AWD1_SLV_Pos           (23U)                                   
#define ADC_CSR_AWD1_SLV_Msk           (0x1U << ADC_CSR_AWD1_SLV_Pos)          /*!< 0x00800000 */
#define ADC_CSR_AWD1_SLV               ADC_CSR_AWD1_SLV_Msk                    /*!< ADC multimode slave analog watchdog 1 flag */
#define ADC_CSR_AWD2_SLV_Pos           (24U)                                   
#define ADC_CSR_AWD2_SLV_Msk           (0x1U << ADC_CSR_AWD2_SLV_Pos)          /*!< 0x01000000 */
#define ADC_CSR_AWD2_SLV               ADC_CSR_AWD2_SLV_Msk                    /*!< ADC multimode slave analog watchdog 2 flag */
#define ADC_CSR_AWD3_SLV_Pos           (25U)                                   
#define ADC_CSR_AWD3_SLV_Msk           (0x1U << ADC_CSR_AWD3_SLV_Pos)          /*!< 0x02000000 */
#define ADC_CSR_AWD3_SLV               ADC_CSR_AWD3_SLV_Msk                    /*!< ADC multimode slave analog watchdog 3 flag */
#define ADC_CSR_JQOVF_SLV_Pos          (26U)                                   
#define ADC_CSR_JQOVF_SLV_Msk          (0x1U << ADC_CSR_JQOVF_SLV_Pos)         /*!< 0x04000000 */
#define ADC_CSR_JQOVF_SLV              ADC_CSR_JQOVF_SLV_Msk                   /*!< ADC multimode slave group injected contexts queue overflow flag */

/* Legacy defines */
#define ADC_CSR_ADRDY_EOSMP_MST   ADC_CSR_EOSMP_MST
#define ADC_CSR_ADRDY_EOC_MST     ADC_CSR_EOC_MST
#define ADC_CSR_ADRDY_EOS_MST     ADC_CSR_EOS_MST
#define ADC_CSR_ADRDY_OVR_MST     ADC_CSR_OVR_MST
#define ADC_CSR_ADRDY_JEOC_MST    ADC_CSR_JEOC_MST
#define ADC_CSR_ADRDY_JEOS_MST    ADC_CSR_JEOS_MST

#define ADC_CSR_ADRDY_EOSMP_SLV   ADC_CSR_EOSMP_SLV
#define ADC_CSR_ADRDY_EOC_SLV     ADC_CSR_EOC_SLV
#define ADC_CSR_ADRDY_EOS_SLV     ADC_CSR_EOS_SLV
#define ADC_CSR_ADRDY_OVR_SLV     ADC_CSR_OVR_SLV
#define ADC_CSR_ADRDY_JEOC_SLV    ADC_CSR_JEOC_SLV
#define ADC_CSR_ADRDY_JEOS_SLV    ADC_CSR_JEOS_SLV

/********************  Bit definition for ADC_CCR register  *******************/
#define ADC_CCR_DUAL_Pos               (0U)                                    
#define ADC_CCR_DUAL_Msk               (0x1FU << ADC_CCR_DUAL_Pos)             /*!< 0x0000001F */
#define ADC_CCR_DUAL                   ADC_CCR_DUAL_Msk                        /*!< ADC multimode mode selection */
#define ADC_CCR_DUAL_0                 (0x01U << ADC_CCR_DUAL_Pos)             /*!< 0x00000001 */
#define ADC_CCR_DUAL_1                 (0x02U << ADC_CCR_DUAL_Pos)             /*!< 0x00000002 */
#define ADC_CCR_DUAL_2                 (0x04U << ADC_CCR_DUAL_Pos)             /*!< 0x00000004 */
#define ADC_CCR_DUAL_3                 (0x08U << ADC_CCR_DUAL_Pos)             /*!< 0x00000008 */
#define ADC_CCR_DUAL_4                 (0x10U << ADC_CCR_DUAL_Pos)             /*!< 0x00000010 */

#define ADC_CCR_DELAY_Pos              (8U)                                    
#define ADC_CCR_DELAY_Msk              (0xFU << ADC_CCR_DELAY_Pos)             /*!< 0x00000F00 */
#define ADC_CCR_DELAY                  ADC_CCR_DELAY_Msk                       /*!< ADC multimode delay between 2 sampling phases */
#define ADC_CCR_DELAY_0                (0x1U << ADC_CCR_DELAY_Pos)             /*!< 0x00000100 */
#define ADC_CCR_DELAY_1                (0x2U << ADC_CCR_DELAY_Pos)             /*!< 0x00000200 */
#define ADC_CCR_DELAY_2                (0x4U << ADC_CCR_DELAY_Pos)             /*!< 0x00000400 */
#define ADC_CCR_DELAY_3                (0x8U << ADC_CCR_DELAY_Pos)             /*!< 0x00000800 */

#define ADC_CCR_DMACFG_Pos             (13U)                                   
#define ADC_CCR_DMACFG_Msk             (0x1U << ADC_CCR_DMACFG_Pos)            /*!< 0x00002000 */
#define ADC_CCR_DMACFG                 ADC_CCR_DMACFG_Msk                      /*!< ADC multimode DMA transfer configuration */

#define ADC_CCR_MDMA_Pos               (14U)                                   
#define ADC_CCR_MDMA_Msk               (0x3U << ADC_CCR_MDMA_Pos)              /*!< 0x0000C000 */
#define ADC_CCR_MDMA                   ADC_CCR_MDMA_Msk                        /*!< ADC multimode DMA transfer enable */
#define ADC_CCR_MDMA_0                 (0x1U << ADC_CCR_MDMA_Pos)              /*!< 0x00004000 */
#define ADC_CCR_MDMA_1                 (0x2U << ADC_CCR_MDMA_Pos)              /*!< 0x00008000 */

#define ADC_CCR_CKMODE_Pos             (16U)                                   
#define ADC_CCR_CKMODE_Msk             (0x3U << ADC_CCR_CKMODE_Pos)            /*!< 0x00030000 */
#define ADC_CCR_CKMODE                 ADC_CCR_CKMODE_Msk                      /*!< ADC common clock source and prescaler (prescaler only for clock source synchronous) */
#define ADC_CCR_CKMODE_0               (0x1U << ADC_CCR_CKMODE_Pos)            /*!< 0x00010000 */
#define ADC_CCR_CKMODE_1               (0x2U << ADC_CCR_CKMODE_Pos)            /*!< 0x00020000 */

#define ADC_CCR_VREFEN_Pos             (22U)                                   
#define ADC_CCR_VREFEN_Msk             (0x1U << ADC_CCR_VREFEN_Pos)            /*!< 0x00400000 */
#define ADC_CCR_VREFEN                 ADC_CCR_VREFEN_Msk                      /*!< ADC internal path to VrefInt enable */
#define ADC_CCR_TSEN_Pos               (23U)                                   
#define ADC_CCR_TSEN_Msk               (0x1U << ADC_CCR_TSEN_Pos)              /*!< 0x00800000 */
#define ADC_CCR_TSEN                   ADC_CCR_TSEN_Msk                        /*!< ADC internal path to temperature sensor enable */
#define ADC_CCR_VBATEN_Pos             (24U)                                   
#define ADC_CCR_VBATEN_Msk             (0x1U << ADC_CCR_VBATEN_Pos)            /*!< 0x01000000 */
#define ADC_CCR_VBATEN                 ADC_CCR_VBATEN_Msk                      /*!< ADC internal path to battery voltage enable */

/* Legacy defines */
#define ADC_CCR_MULTI           (ADC_CCR_DUAL)
#define ADC_CCR_MULTI_0         (ADC_CCR_DUAL_0)
#define ADC_CCR_MULTI_1         (ADC_CCR_DUAL_1)
#define ADC_CCR_MULTI_2         (ADC_CCR_DUAL_2)
#define ADC_CCR_MULTI_3         (ADC_CCR_DUAL_3)
#define ADC_CCR_MULTI_4         (ADC_CCR_DUAL_4)

/********************  Bit definition for ADC_CDR register  *******************/
#define ADC_CDR_RDATA_MST_Pos          (0U)                                    
#define ADC_CDR_RDATA_MST_Msk          (0xFFFFU << ADC_CDR_RDATA_MST_Pos)      /*!< 0x0000FFFF */
#define ADC_CDR_RDATA_MST              ADC_CDR_RDATA_MST_Msk                   /*!< ADC multimode master group regular conversion data */
#define ADC_CDR_RDATA_MST_0            (0x0001U << ADC_CDR_RDATA_MST_Pos)      /*!< 0x00000001 */
#define ADC_CDR_RDATA_MST_1            (0x0002U << ADC_CDR_RDATA_MST_Pos)      /*!< 0x00000002 */
#define ADC_CDR_RDATA_MST_2            (0x0004U << ADC_CDR_RDATA_MST_Pos)      /*!< 0x00000004 */
#define ADC_CDR_RDATA_MST_3            (0x0008U << ADC_CDR_RDATA_MST_Pos)      /*!< 0x00000008 */
#define ADC_CDR_RDATA_MST_4            (0x0010U << ADC_CDR_RDATA_MST_Pos)      /*!< 0x00000010 */
#define ADC_CDR_RDATA_MST_5            (0x0020U << ADC_CDR_RDATA_MST_Pos)      /*!< 0x00000020 */
#define ADC_CDR_RDATA_MST_6            (0x0040U << ADC_CDR_RDATA_MST_Pos)      /*!< 0x00000040 */
#define ADC_CDR_RDATA_MST_7            (0x0080U << ADC_CDR_RDATA_MST_Pos)      /*!< 0x00000080 */
#define ADC_CDR_RDATA_MST_8            (0x0100U << ADC_CDR_RDATA_MST_Pos)      /*!< 0x00000100 */
#define ADC_CDR_RDATA_MST_9            (0x0200U << ADC_CDR_RDATA_MST_Pos)      /*!< 0x00000200 */
#define ADC_CDR_RDATA_MST_10           (0x0400U << ADC_CDR_RDATA_MST_Pos)      /*!< 0x00000400 */
#define ADC_CDR_RDATA_MST_11           (0x0800U << ADC_CDR_RDATA_MST_Pos)      /*!< 0x00000800 */
#define ADC_CDR_RDATA_MST_12           (0x1000U << ADC_CDR_RDATA_MST_Pos)      /*!< 0x00001000 */
#define ADC_CDR_RDATA_MST_13           (0x2000U << ADC_CDR_RDATA_MST_Pos)      /*!< 0x00002000 */
#define ADC_CDR_RDATA_MST_14           (0x4000U << ADC_CDR_RDATA_MST_Pos)      /*!< 0x00004000 */
#define ADC_CDR_RDATA_MST_15           (0x8000U << ADC_CDR_RDATA_MST_Pos)      /*!< 0x00008000 */

#define ADC_CDR_RDATA_SLV_Pos          (16U)                                   
#define ADC_CDR_RDATA_SLV_Msk          (0xFFFFU << ADC_CDR_RDATA_SLV_Pos)      /*!< 0xFFFF0000 */
#define ADC_CDR_RDATA_SLV              ADC_CDR_RDATA_SLV_Msk                   /*!< ADC multimode slave group regular conversion data */
#define ADC_CDR_RDATA_SLV_0            (0x0001U << ADC_CDR_RDATA_SLV_Pos)      /*!< 0x00010000 */
#define ADC_CDR_RDATA_SLV_1            (0x0002U << ADC_CDR_RDATA_SLV_Pos)      /*!< 0x00020000 */
#define ADC_CDR_RDATA_SLV_2            (0x0004U << ADC_CDR_RDATA_SLV_Pos)      /*!< 0x00040000 */
#define ADC_CDR_RDATA_SLV_3            (0x0008U << ADC_CDR_RDATA_SLV_Pos)      /*!< 0x00080000 */
#define ADC_CDR_RDATA_SLV_4            (0x0010U << ADC_CDR_RDATA_SLV_Pos)      /*!< 0x00100000 */
#define ADC_CDR_RDATA_SLV_5            (0x0020U << ADC_CDR_RDATA_SLV_Pos)      /*!< 0x00200000 */
#define ADC_CDR_RDATA_SLV_6            (0x0040U << ADC_CDR_RDATA_SLV_Pos)      /*!< 0x00400000 */
#define ADC_CDR_RDATA_SLV_7            (0x0080U << ADC_CDR_RDATA_SLV_Pos)      /*!< 0x00800000 */
#define ADC_CDR_RDATA_SLV_8            (0x0100U << ADC_CDR_RDATA_SLV_Pos)      /*!< 0x01000000 */
#define ADC_CDR_RDATA_SLV_9            (0x0200U << ADC_CDR_RDATA_SLV_Pos)      /*!< 0x02000000 */
#define ADC_CDR_RDATA_SLV_10           (0x0400U << ADC_CDR_RDATA_SLV_Pos)      /*!< 0x04000000 */
#define ADC_CDR_RDATA_SLV_11           (0x0800U << ADC_CDR_RDATA_SLV_Pos)      /*!< 0x08000000 */
#define ADC_CDR_RDATA_SLV_12           (0x1000U << ADC_CDR_RDATA_SLV_Pos)      /*!< 0x10000000 */
#define ADC_CDR_RDATA_SLV_13           (0x2000U << ADC_CDR_RDATA_SLV_Pos)      /*!< 0x20000000 */
#define ADC_CDR_RDATA_SLV_14           (0x4000U << ADC_CDR_RDATA_SLV_Pos)      /*!< 0x40000000 */
#define ADC_CDR_RDATA_SLV_15           (0x8000U << ADC_CDR_RDATA_SLV_Pos)      /*!< 0x80000000 */

/******************************************************************************/
/*                                                                            */
/*                      Analog Comparators (COMP)                             */
/*                                                                            */
/******************************************************************************/

#define COMP_V1_3_0_0                                  /*!< Comparator IP version */

/**********************  Bit definition for COMP2_CSR register  ***************/
#define COMP2_CSR_COMP2EN_Pos            (0U)                                  
#define COMP2_CSR_COMP2EN_Msk            (0x1U << COMP2_CSR_COMP2EN_Pos)       /*!< 0x00000001 */
#define COMP2_CSR_COMP2EN                COMP2_CSR_COMP2EN_Msk                 /*!< COMP2 enable */
#define COMP2_CSR_COMP2INSEL_Pos         (4U)                                  
#define COMP2_CSR_COMP2INSEL_Msk         (0x40007U << COMP2_CSR_COMP2INSEL_Pos) /*!< 0x00400070 */
#define COMP2_CSR_COMP2INSEL             COMP2_CSR_COMP2INSEL_Msk              /*!< COMP2 inverting input select */
#define COMP2_CSR_COMP2INSEL_0           (0x00000010U)                         /*!< COMP2 inverting input select bit 0 */
#define COMP2_CSR_COMP2INSEL_1           (0x00000020U)                         /*!< COMP2 inverting input select bit 1 */
#define COMP2_CSR_COMP2INSEL_2           (0x00000040U)                         /*!< COMP2 inverting input select bit 2 */
#define COMP2_CSR_COMP2INSEL_3           (0x00400000U)                         /*!< COMP2 inverting input select bit 3 */
#define COMP2_CSR_COMP2OUTSEL_Pos        (10U)                                 
#define COMP2_CSR_COMP2OUTSEL_Msk        (0xFU << COMP2_CSR_COMP2OUTSEL_Pos)   /*!< 0x00003C00 */
#define COMP2_CSR_COMP2OUTSEL            COMP2_CSR_COMP2OUTSEL_Msk             /*!< COMP2 output select */
#define COMP2_CSR_COMP2OUTSEL_0          (0x1U << COMP2_CSR_COMP2OUTSEL_Pos)   /*!< 0x00000400 */
#define COMP2_CSR_COMP2OUTSEL_1          (0x2U << COMP2_CSR_COMP2OUTSEL_Pos)   /*!< 0x00000800 */
#define COMP2_CSR_COMP2OUTSEL_2          (0x4U << COMP2_CSR_COMP2OUTSEL_Pos)   /*!< 0x00001000 */
#define COMP2_CSR_COMP2OUTSEL_3          (0x8U << COMP2_CSR_COMP2OUTSEL_Pos)   /*!< 0x00002000 */
#define COMP2_CSR_COMP2POL_Pos           (15U)                                 
#define COMP2_CSR_COMP2POL_Msk           (0x1U << COMP2_CSR_COMP2POL_Pos)      /*!< 0x00008000 */
#define COMP2_CSR_COMP2POL               COMP2_CSR_COMP2POL_Msk                /*!< COMP2 output polarity */
#define COMP2_CSR_COMP2BLANKING_Pos      (18U)                                 
#define COMP2_CSR_COMP2BLANKING_Msk      (0x3U << COMP2_CSR_COMP2BLANKING_Pos) /*!< 0x000C0000 */
#define COMP2_CSR_COMP2BLANKING          COMP2_CSR_COMP2BLANKING_Msk           /*!< COMP2 blanking */
#define COMP2_CSR_COMP2BLANKING_0        (0x1U << COMP2_CSR_COMP2BLANKING_Pos) /*!< 0x00040000 */
#define COMP2_CSR_COMP2BLANKING_1        (0x2U << COMP2_CSR_COMP2BLANKING_Pos) /*!< 0x00080000 */
#define COMP2_CSR_COMP2BLANKING_2        (0x4U << COMP2_CSR_COMP2BLANKING_Pos) /*!< 0x00100000 */
#define COMP2_CSR_COMP2OUT_Pos           (30U)                                 
#define COMP2_CSR_COMP2OUT_Msk           (0x1U << COMP2_CSR_COMP2OUT_Pos)      /*!< 0x40000000 */
#define COMP2_CSR_COMP2OUT               COMP2_CSR_COMP2OUT_Msk                /*!< COMP2 output level */
#define COMP2_CSR_COMP2LOCK_Pos          (31U)                                 
#define COMP2_CSR_COMP2LOCK_Msk          (0x1U << COMP2_CSR_COMP2LOCK_Pos)     /*!< 0x80000000 */
#define COMP2_CSR_COMP2LOCK              COMP2_CSR_COMP2LOCK_Msk               /*!< COMP2 lock */

/**********************  Bit definition for COMP4_CSR register  ***************/
#define COMP4_CSR_COMP4EN_Pos            (0U)                                  
#define COMP4_CSR_COMP4EN_Msk            (0x1U << COMP4_CSR_COMP4EN_Pos)       /*!< 0x00000001 */
#define COMP4_CSR_COMP4EN                COMP4_CSR_COMP4EN_Msk                 /*!< COMP4 enable */
#define COMP4_CSR_COMP4INSEL_Pos         (4U)                                  
#define COMP4_CSR_COMP4INSEL_Msk         (0x40007U << COMP4_CSR_COMP4INSEL_Pos) /*!< 0x00400070 */
#define COMP4_CSR_COMP4INSEL             COMP4_CSR_COMP4INSEL_Msk              /*!< COMP4 inverting input select */
#define COMP4_CSR_COMP4INSEL_0           (0x00000010U)                         /*!< COMP4 inverting input select bit 0 */
#define COMP4_CSR_COMP4INSEL_1           (0x00000020U)                         /*!< COMP4 inverting input select bit 1 */
#define COMP4_CSR_COMP4INSEL_2           (0x00000040U)                         /*!< COMP4 inverting input select bit 2 */
#define COMP4_CSR_COMP4INSEL_3           (0x00400000U)                         /*!< COMP4 inverting input select bit 3 */
#define COMP4_CSR_COMP4OUTSEL_Pos        (10U)                                 
#define COMP4_CSR_COMP4OUTSEL_Msk        (0xFU << COMP4_CSR_COMP4OUTSEL_Pos)   /*!< 0x00003C00 */
#define COMP4_CSR_COMP4OUTSEL            COMP4_CSR_COMP4OUTSEL_Msk             /*!< COMP4 output select */
#define COMP4_CSR_COMP4OUTSEL_0          (0x1U << COMP4_CSR_COMP4OUTSEL_Pos)   /*!< 0x00000400 */
#define COMP4_CSR_COMP4OUTSEL_1          (0x2U << COMP4_CSR_COMP4OUTSEL_Pos)   /*!< 0x00000800 */
#define COMP4_CSR_COMP4OUTSEL_2          (0x4U << COMP4_CSR_COMP4OUTSEL_Pos)   /*!< 0x00001000 */
#define COMP4_CSR_COMP4OUTSEL_3          (0x8U << COMP4_CSR_COMP4OUTSEL_Pos)   /*!< 0x00002000 */
#define COMP4_CSR_COMP4POL_Pos           (15U)                                 
#define COMP4_CSR_COMP4POL_Msk           (0x1U << COMP4_CSR_COMP4POL_Pos)      /*!< 0x00008000 */
#define COMP4_CSR_COMP4POL               COMP4_CSR_COMP4POL_Msk                /*!< COMP4 output polarity */
#define COMP4_CSR_COMP4BLANKING_Pos      (18U)                                 
#define COMP4_CSR_COMP4BLANKING_Msk      (0x3U << COMP4_CSR_COMP4BLANKING_Pos) /*!< 0x000C0000 */
#define COMP4_CSR_COMP4BLANKING          COMP4_CSR_COMP4BLANKING_Msk           /*!< COMP4 blanking */
#define COMP4_CSR_COMP4BLANKING_0        (0x1U << COMP4_CSR_COMP4BLANKING_Pos) /*!< 0x00040000 */
#define COMP4_CSR_COMP4BLANKING_1        (0x2U << COMP4_CSR_COMP4BLANKING_Pos) /*!< 0x00080000 */
#define COMP4_CSR_COMP4BLANKING_2        (0x4U << COMP4_CSR_COMP4BLANKING_Pos) /*!< 0x00100000 */
#define COMP4_CSR_COMP4OUT_Pos           (30U)                                 
#define COMP4_CSR_COMP4OUT_Msk           (0x1U << COMP4_CSR_COMP4OUT_Pos)      /*!< 0x40000000 */
#define COMP4_CSR_COMP4OUT               COMP4_CSR_COMP4OUT_Msk                /*!< COMP4 output level */
#define COMP4_CSR_COMP4LOCK_Pos          (31U)                                 
#define COMP4_CSR_COMP4LOCK_Msk          (0x1U << COMP4_CSR_COMP4LOCK_Pos)     /*!< 0x80000000 */
#define COMP4_CSR_COMP4LOCK              COMP4_CSR_COMP4LOCK_Msk               /*!< COMP4 lock */

/**********************  Bit definition for COMP6_CSR register  ***************/
#define COMP6_CSR_COMP6EN_Pos            (0U)                                  
#define COMP6_CSR_COMP6EN_Msk            (0x1U << COMP6_CSR_COMP6EN_Pos)       /*!< 0x00000001 */
#define COMP6_CSR_COMP6EN                COMP6_CSR_COMP6EN_Msk                 /*!< COMP6 enable */
#define COMP6_CSR_COMP6INSEL_Pos         (4U)                                  
#define COMP6_CSR_COMP6INSEL_Msk         (0x40007U << COMP6_CSR_COMP6INSEL_Pos) /*!< 0x00400070 */
#define COMP6_CSR_COMP6INSEL             COMP6_CSR_COMP6INSEL_Msk              /*!< COMP6 inverting input select */
#define COMP6_CSR_COMP6INSEL_0           (0x00000010U)                         /*!< COMP6 inverting input select bit 0 */
#define COMP6_CSR_COMP6INSEL_1           (0x00000020U)                         /*!< COMP6 inverting input select bit 1 */
#define COMP6_CSR_COMP6INSEL_2           (0x00000040U)                         /*!< COMP6 inverting input select bit 2 */
#define COMP6_CSR_COMP6INSEL_3           (0x00400000U)                         /*!< COMP6 inverting input select bit 3 */
#define COMP6_CSR_COMP6OUTSEL_Pos        (10U)                                 
#define COMP6_CSR_COMP6OUTSEL_Msk        (0xFU << COMP6_CSR_COMP6OUTSEL_Pos)   /*!< 0x00003C00 */
#define COMP6_CSR_COMP6OUTSEL            COMP6_CSR_COMP6OUTSEL_Msk             /*!< COMP6 output select */
#define COMP6_CSR_COMP6OUTSEL_0          (0x1U << COMP6_CSR_COMP6OUTSEL_Pos)   /*!< 0x00000400 */
#define COMP6_CSR_COMP6OUTSEL_1          (0x2U << COMP6_CSR_COMP6OUTSEL_Pos)   /*!< 0x00000800 */
#define COMP6_CSR_COMP6OUTSEL_2          (0x4U << COMP6_CSR_COMP6OUTSEL_Pos)   /*!< 0x00001000 */
#define COMP6_CSR_COMP6OUTSEL_3          (0x8U << COMP6_CSR_COMP6OUTSEL_Pos)   /*!< 0x00002000 */
#define COMP6_CSR_COMP6POL_Pos           (15U)                                 
#define COMP6_CSR_COMP6POL_Msk           (0x1U << COMP6_CSR_COMP6POL_Pos)      /*!< 0x00008000 */
#define COMP6_CSR_COMP6POL               COMP6_CSR_COMP6POL_Msk                /*!< COMP6 output polarity */
#define COMP6_CSR_COMP6BLANKING_Pos      (18U)                                 
#define COMP6_CSR_COMP6BLANKING_Msk      (0x3U << COMP6_CSR_COMP6BLANKING_Pos) /*!< 0x000C0000 */
#define COMP6_CSR_COMP6BLANKING          COMP6_CSR_COMP6BLANKING_Msk           /*!< COMP6 blanking */
#define COMP6_CSR_COMP6BLANKING_0        (0x1U << COMP6_CSR_COMP6BLANKING_Pos) /*!< 0x00040000 */
#define COMP6_CSR_COMP6BLANKING_1        (0x2U << COMP6_CSR_COMP6BLANKING_Pos) /*!< 0x00080000 */
#define COMP6_CSR_COMP6BLANKING_2        (0x4U << COMP6_CSR_COMP6BLANKING_Pos) /*!< 0x00100000 */
#define COMP6_CSR_COMP6OUT_Pos           (30U)                                 
#define COMP6_CSR_COMP6OUT_Msk           (0x1U << COMP6_CSR_COMP6OUT_Pos)      /*!< 0x40000000 */
#define COMP6_CSR_COMP6OUT               COMP6_CSR_COMP6OUT_Msk                /*!< COMP6 output level */
#define COMP6_CSR_COMP6LOCK_Pos          (31U)                                 
#define COMP6_CSR_COMP6LOCK_Msk          (0x1U << COMP6_CSR_COMP6LOCK_Pos)     /*!< 0x80000000 */
#define COMP6_CSR_COMP6LOCK              COMP6_CSR_COMP6LOCK_Msk               /*!< COMP6 lock */

/**********************  Bit definition for COMP_CSR register  ****************/
#define COMP_CSR_COMPxEN_Pos            (0U)                                   
#define COMP_CSR_COMPxEN_Msk            (0x1U << COMP_CSR_COMPxEN_Pos)         /*!< 0x00000001 */
#define COMP_CSR_COMPxEN                COMP_CSR_COMPxEN_Msk                   /*!< COMPx enable */
#define COMP_CSR_COMPxINSEL_Pos         (4U)                                   
#define COMP_CSR_COMPxINSEL_Msk         (0x40007U << COMP_CSR_COMPxINSEL_Pos)  /*!< 0x00400070 */
#define COMP_CSR_COMPxINSEL             COMP_CSR_COMPxINSEL_Msk                /*!< COMPx inverting input select */
#define COMP_CSR_COMPxINSEL_0           (0x00000010U)                          /*!< COMPx inverting input select bit 0 */
#define COMP_CSR_COMPxINSEL_1           (0x00000020U)                          /*!< COMPx inverting input select bit 1 */
#define COMP_CSR_COMPxINSEL_2           (0x00000040U)                          /*!< COMPx inverting input select bit 2 */
#define COMP_CSR_COMPxINSEL_3           (0x00400000U)                          /*!< COMPx inverting input select bit 3 */
#define COMP_CSR_COMPxOUTSEL_Pos        (10U)                                  
#define COMP_CSR_COMPxOUTSEL_Msk        (0xFU << COMP_CSR_COMPxOUTSEL_Pos)     /*!< 0x00003C00 */
#define COMP_CSR_COMPxOUTSEL            COMP_CSR_COMPxOUTSEL_Msk               /*!< COMPx output select */
#define COMP_CSR_COMPxOUTSEL_0          (0x1U << COMP_CSR_COMPxOUTSEL_Pos)     /*!< 0x00000400 */
#define COMP_CSR_COMPxOUTSEL_1          (0x2U << COMP_CSR_COMPxOUTSEL_Pos)     /*!< 0x00000800 */
#define COMP_CSR_COMPxOUTSEL_2          (0x4U << COMP_CSR_COMPxOUTSEL_Pos)     /*!< 0x00001000 */
#define COMP_CSR_COMPxOUTSEL_3          (0x8U << COMP_CSR_COMPxOUTSEL_Pos)     /*!< 0x00002000 */
#define COMP_CSR_COMPxPOL_Pos           (15U)                                  
#define COMP_CSR_COMPxPOL_Msk           (0x1U << COMP_CSR_COMPxPOL_Pos)        /*!< 0x00008000 */
#define COMP_CSR_COMPxPOL               COMP_CSR_COMPxPOL_Msk                  /*!< COMPx output polarity */
#define COMP_CSR_COMPxBLANKING_Pos      (18U)                                  
#define COMP_CSR_COMPxBLANKING_Msk      (0x3U << COMP_CSR_COMPxBLANKING_Pos)   /*!< 0x000C0000 */
#define COMP_CSR_COMPxBLANKING          COMP_CSR_COMPxBLANKING_Msk             /*!< COMPx blanking */
#define COMP_CSR_COMPxBLANKING_0        (0x1U << COMP_CSR_COMPxBLANKING_Pos)   /*!< 0x00040000 */
#define COMP_CSR_COMPxBLANKING_1        (0x2U << COMP_CSR_COMPxBLANKING_Pos)   /*!< 0x00080000 */
#define COMP_CSR_COMPxBLANKING_2        (0x4U << COMP_CSR_COMPxBLANKING_Pos)   /*!< 0x00100000 */
#define COMP_CSR_COMPxOUT_Pos           (30U)                                  
#define COMP_CSR_COMPxOUT_Msk           (0x1U << COMP_CSR_COMPxOUT_Pos)        /*!< 0x40000000 */
#define COMP_CSR_COMPxOUT               COMP_CSR_COMPxOUT_Msk                  /*!< COMPx output level */
#define COMP_CSR_COMPxLOCK_Pos          (31U)                                  
#define COMP_CSR_COMPxLOCK_Msk          (0x1U << COMP_CSR_COMPxLOCK_Pos)       /*!< 0x80000000 */
#define COMP_CSR_COMPxLOCK              COMP_CSR_COMPxLOCK_Msk                 /*!< COMPx lock */

/******************************************************************************/
/*                                                                            */
/*                     Operational Amplifier (OPAMP)                          */
/*                                                                            */
/******************************************************************************/
/*********************  Bit definition for OPAMP2_CSR register  ***************/
#define OPAMP2_CSR_OPAMP2EN_Pos       (0U)                                     
#define OPAMP2_CSR_OPAMP2EN_Msk       (0x1U << OPAMP2_CSR_OPAMP2EN_Pos)        /*!< 0x00000001 */
#define OPAMP2_CSR_OPAMP2EN           OPAMP2_CSR_OPAMP2EN_Msk                  /*!< OPAMP2 enable */
#define OPAMP2_CSR_FORCEVP_Pos        (1U)                                     
#define OPAMP2_CSR_FORCEVP_Msk        (0x1U << OPAMP2_CSR_FORCEVP_Pos)         /*!< 0x00000002 */
#define OPAMP2_CSR_FORCEVP            OPAMP2_CSR_FORCEVP_Msk                   /*!< Connect the internal references to the plus input of the OPAMPX */
#define OPAMP2_CSR_VPSEL_Pos          (2U)                                     
#define OPAMP2_CSR_VPSEL_Msk          (0x3U << OPAMP2_CSR_VPSEL_Pos)           /*!< 0x0000000C */
#define OPAMP2_CSR_VPSEL              OPAMP2_CSR_VPSEL_Msk                     /*!< Non inverting input selection */
#define OPAMP2_CSR_VPSEL_0            (0x1U << OPAMP2_CSR_VPSEL_Pos)           /*!< 0x00000004 */
#define OPAMP2_CSR_VPSEL_1            (0x2U << OPAMP2_CSR_VPSEL_Pos)           /*!< 0x00000008 */
#define OPAMP2_CSR_VMSEL_Pos          (5U)                                     
#define OPAMP2_CSR_VMSEL_Msk          (0x3U << OPAMP2_CSR_VMSEL_Pos)           /*!< 0x00000060 */
#define OPAMP2_CSR_VMSEL              OPAMP2_CSR_VMSEL_Msk                     /*!< Inverting input selection */
#define OPAMP2_CSR_VMSEL_0            (0x1U << OPAMP2_CSR_VMSEL_Pos)           /*!< 0x00000020 */
#define OPAMP2_CSR_VMSEL_1            (0x2U << OPAMP2_CSR_VMSEL_Pos)           /*!< 0x00000040 */
#define OPAMP2_CSR_TCMEN_Pos          (7U)                                     
#define OPAMP2_CSR_TCMEN_Msk          (0x1U << OPAMP2_CSR_TCMEN_Pos)           /*!< 0x00000080 */
#define OPAMP2_CSR_TCMEN              OPAMP2_CSR_TCMEN_Msk                     /*!< Timer-Controlled Mux mode enable */
#define OPAMP2_CSR_VMSSEL_Pos         (8U)                                     
#define OPAMP2_CSR_VMSSEL_Msk         (0x1U << OPAMP2_CSR_VMSSEL_Pos)          /*!< 0x00000100 */
#define OPAMP2_CSR_VMSSEL             OPAMP2_CSR_VMSSEL_Msk                    /*!< Inverting input secondary selection */
#define OPAMP2_CSR_VPSSEL_Pos         (9U)                                     
#define OPAMP2_CSR_VPSSEL_Msk         (0x3U << OPAMP2_CSR_VPSSEL_Pos)          /*!< 0x00000600 */
#define OPAMP2_CSR_VPSSEL             OPAMP2_CSR_VPSSEL_Msk                    /*!< Non inverting input secondary selection */
#define OPAMP2_CSR_VPSSEL_0           (0x1U << OPAMP2_CSR_VPSSEL_Pos)          /*!< 0x00000200 */
#define OPAMP2_CSR_VPSSEL_1           (0x2U << OPAMP2_CSR_VPSSEL_Pos)          /*!< 0x00000400 */
#define OPAMP2_CSR_CALON_Pos          (11U)                                    
#define OPAMP2_CSR_CALON_Msk          (0x1U << OPAMP2_CSR_CALON_Pos)           /*!< 0x00000800 */
#define OPAMP2_CSR_CALON              OPAMP2_CSR_CALON_Msk                     /*!< Calibration mode enable */
#define OPAMP2_CSR_CALSEL_Pos         (12U)                                    
#define OPAMP2_CSR_CALSEL_Msk         (0x3U << OPAMP2_CSR_CALSEL_Pos)          /*!< 0x00003000 */
#define OPAMP2_CSR_CALSEL             OPAMP2_CSR_CALSEL_Msk                    /*!< Calibration selection */
#define OPAMP2_CSR_CALSEL_0           (0x1U << OPAMP2_CSR_CALSEL_Pos)          /*!< 0x00001000 */
#define OPAMP2_CSR_CALSEL_1           (0x2U << OPAMP2_CSR_CALSEL_Pos)          /*!< 0x00002000 */
#define OPAMP2_CSR_PGGAIN_Pos         (14U)                                    
#define OPAMP2_CSR_PGGAIN_Msk         (0xFU << OPAMP2_CSR_PGGAIN_Pos)          /*!< 0x0003C000 */
#define OPAMP2_CSR_PGGAIN             OPAMP2_CSR_PGGAIN_Msk                    /*!< Gain in PGA mode */
#define OPAMP2_CSR_PGGAIN_0           (0x1U << OPAMP2_CSR_PGGAIN_Pos)          /*!< 0x00004000 */
#define OPAMP2_CSR_PGGAIN_1           (0x2U << OPAMP2_CSR_PGGAIN_Pos)          /*!< 0x00008000 */
#define OPAMP2_CSR_PGGAIN_2           (0x4U << OPAMP2_CSR_PGGAIN_Pos)          /*!< 0x00010000 */
#define OPAMP2_CSR_PGGAIN_3           (0x8U << OPAMP2_CSR_PGGAIN_Pos)          /*!< 0x00020000 */
#define OPAMP2_CSR_USERTRIM_Pos       (18U)                                    
#define OPAMP2_CSR_USERTRIM_Msk       (0x1U << OPAMP2_CSR_USERTRIM_Pos)        /*!< 0x00040000 */
#define OPAMP2_CSR_USERTRIM           OPAMP2_CSR_USERTRIM_Msk                  /*!< User trimming enable */
#define OPAMP2_CSR_TRIMOFFSETP_Pos    (19U)                                    
#define OPAMP2_CSR_TRIMOFFSETP_Msk    (0x1FU << OPAMP2_CSR_TRIMOFFSETP_Pos)    /*!< 0x00F80000 */
#define OPAMP2_CSR_TRIMOFFSETP        OPAMP2_CSR_TRIMOFFSETP_Msk               /*!< Offset trimming value (PMOS) */
#define OPAMP2_CSR_TRIMOFFSETN_Pos    (24U)                                    
#define OPAMP2_CSR_TRIMOFFSETN_Msk    (0x1FU << OPAMP2_CSR_TRIMOFFSETN_Pos)    /*!< 0x1F000000 */
#define OPAMP2_CSR_TRIMOFFSETN        OPAMP2_CSR_TRIMOFFSETN_Msk               /*!< Offset trimming value (NMOS) */
#define OPAMP2_CSR_TSTREF_Pos         (29U)                                    
#define OPAMP2_CSR_TSTREF_Msk         (0x1U << OPAMP2_CSR_TSTREF_Pos)          /*!< 0x20000000 */
#define OPAMP2_CSR_TSTREF             OPAMP2_CSR_TSTREF_Msk                    /*!< It enables the switch to put out the internal reference */
#define OPAMP2_CSR_OUTCAL_Pos         (30U)                                    
#define OPAMP2_CSR_OUTCAL_Msk         (0x1U << OPAMP2_CSR_OUTCAL_Pos)          /*!< 0x40000000 */
#define OPAMP2_CSR_OUTCAL             OPAMP2_CSR_OUTCAL_Msk                    /*!< OPAMP ouput status flag */
#define OPAMP2_CSR_LOCK_Pos           (31U)                                    
#define OPAMP2_CSR_LOCK_Msk           (0x1U << OPAMP2_CSR_LOCK_Pos)            /*!< 0x80000000 */
#define OPAMP2_CSR_LOCK               OPAMP2_CSR_LOCK_Msk                      /*!< OPAMP lock */

/*********************  Bit definition for OPAMPx_CSR register  ***************/
#define OPAMP_CSR_OPAMPxEN_Pos       (0U)                                      
#define OPAMP_CSR_OPAMPxEN_Msk       (0x1U << OPAMP_CSR_OPAMPxEN_Pos)          /*!< 0x00000001 */
#define OPAMP_CSR_OPAMPxEN           OPAMP_CSR_OPAMPxEN_Msk                    /*!< OPAMP enable */
#define OPAMP_CSR_FORCEVP_Pos        (1U)                                      
#define OPAMP_CSR_FORCEVP_Msk        (0x1U << OPAMP_CSR_FORCEVP_Pos)           /*!< 0x00000002 */
#define OPAMP_CSR_FORCEVP            OPAMP_CSR_FORCEVP_Msk                     /*!< Connect the internal references to the plus input of the OPAMPX */
#define OPAMP_CSR_VPSEL_Pos          (2U)                                      
#define OPAMP_CSR_VPSEL_Msk          (0x3U << OPAMP_CSR_VPSEL_Pos)             /*!< 0x0000000C */
#define OPAMP_CSR_VPSEL              OPAMP_CSR_VPSEL_Msk                       /*!< Non inverting input selection */
#define OPAMP_CSR_VPSEL_0            (0x1U << OPAMP_CSR_VPSEL_Pos)             /*!< 0x00000004 */
#define OPAMP_CSR_VPSEL_1            (0x2U << OPAMP_CSR_VPSEL_Pos)             /*!< 0x00000008 */
#define OPAMP_CSR_VMSEL_Pos          (5U)                                      
#define OPAMP_CSR_VMSEL_Msk          (0x3U << OPAMP_CSR_VMSEL_Pos)             /*!< 0x00000060 */
#define OPAMP_CSR_VMSEL              OPAMP_CSR_VMSEL_Msk                       /*!< Inverting input selection */
#define OPAMP_CSR_VMSEL_0            (0x1U << OPAMP_CSR_VMSEL_Pos)             /*!< 0x00000020 */
#define OPAMP_CSR_VMSEL_1            (0x2U << OPAMP_CSR_VMSEL_Pos)             /*!< 0x00000040 */
#define OPAMP_CSR_TCMEN_Pos          (7U)                                      
#define OPAMP_CSR_TCMEN_Msk          (0x1U << OPAMP_CSR_TCMEN_Pos)             /*!< 0x00000080 */
#define OPAMP_CSR_TCMEN              OPAMP_CSR_TCMEN_Msk                       /*!< Timer-Controlled Mux mode enable */
#define OPAMP_CSR_VMSSEL_Pos         (8U)                                      
#define OPAMP_CSR_VMSSEL_Msk         (0x1U << OPAMP_CSR_VMSSEL_Pos)            /*!< 0x00000100 */
#define OPAMP_CSR_VMSSEL             OPAMP_CSR_VMSSEL_Msk                      /*!< Inverting input secondary selection */
#define OPAMP_CSR_VPSSEL_Pos         (9U)                                      
#define OPAMP_CSR_VPSSEL_Msk         (0x3U << OPAMP_CSR_VPSSEL_Pos)            /*!< 0x00000600 */
#define OPAMP_CSR_VPSSEL             OPAMP_CSR_VPSSEL_Msk                      /*!< Non inverting input secondary selection */
#define OPAMP_CSR_VPSSEL_0           (0x1U << OPAMP_CSR_VPSSEL_Pos)            /*!< 0x00000200 */
#define OPAMP_CSR_VPSSEL_1           (0x2U << OPAMP_CSR_VPSSEL_Pos)            /*!< 0x00000400 */
#define OPAMP_CSR_CALON_Pos          (11U)                                     
#define OPAMP_CSR_CALON_Msk          (0x1U << OPAMP_CSR_CALON_Pos)             /*!< 0x00000800 */
#define OPAMP_CSR_CALON              OPAMP_CSR_CALON_Msk                       /*!< Calibration mode enable */
#define OPAMP_CSR_CALSEL_Pos         (12U)                                     
#define OPAMP_CSR_CALSEL_Msk         (0x3U << OPAMP_CSR_CALSEL_Pos)            /*!< 0x00003000 */
#define OPAMP_CSR_CALSEL             OPAMP_CSR_CALSEL_Msk                      /*!< Calibration selection */
#define OPAMP_CSR_CALSEL_0           (0x1U << OPAMP_CSR_CALSEL_Pos)            /*!< 0x00001000 */
#define OPAMP_CSR_CALSEL_1           (0x2U << OPAMP_CSR_CALSEL_Pos)            /*!< 0x00002000 */
#define OPAMP_CSR_PGGAIN_Pos         (14U)                                     
#define OPAMP_CSR_PGGAIN_Msk         (0xFU << OPAMP_CSR_PGGAIN_Pos)            /*!< 0x0003C000 */
#define OPAMP_CSR_PGGAIN             OPAMP_CSR_PGGAIN_Msk                      /*!< Gain in PGA mode */
#define OPAMP_CSR_PGGAIN_0           (0x1U << OPAMP_CSR_PGGAIN_Pos)            /*!< 0x00004000 */
#define OPAMP_CSR_PGGAIN_1           (0x2U << OPAMP_CSR_PGGAIN_Pos)            /*!< 0x00008000 */
#define OPAMP_CSR_PGGAIN_2           (0x4U << OPAMP_CSR_PGGAIN_Pos)            /*!< 0x00010000 */
#define OPAMP_CSR_PGGAIN_3           (0x8U << OPAMP_CSR_PGGAIN_Pos)            /*!< 0x00020000 */
#define OPAMP_CSR_USERTRIM_Pos       (18U)                                     
#define OPAMP_CSR_USERTRIM_Msk       (0x1U << OPAMP_CSR_USERTRIM_Pos)          /*!< 0x00040000 */
#define OPAMP_CSR_USERTRIM           OPAMP_CSR_USERTRIM_Msk                    /*!< User trimming enable */
#define OPAMP_CSR_TRIMOFFSETP_Pos    (19U)                                     
#define OPAMP_CSR_TRIMOFFSETP_Msk    (0x1FU << OPAMP_CSR_TRIMOFFSETP_Pos)      /*!< 0x00F80000 */
#define OPAMP_CSR_TRIMOFFSETP        OPAMP_CSR_TRIMOFFSETP_Msk                 /*!< Offset trimming value (PMOS) */
#define OPAMP_CSR_TRIMOFFSETN_Pos    (24U)                                     
#define OPAMP_CSR_TRIMOFFSETN_Msk    (0x1FU << OPAMP_CSR_TRIMOFFSETN_Pos)      /*!< 0x1F000000 */
#define OPAMP_CSR_TRIMOFFSETN        OPAMP_CSR_TRIMOFFSETN_Msk                 /*!< Offset trimming value (NMOS) */
#define OPAMP_CSR_TSTREF_Pos         (29U)                                     
#define OPAMP_CSR_TSTREF_Msk         (0x1U << OPAMP_CSR_TSTREF_Pos)            /*!< 0x20000000 */
#define OPAMP_CSR_TSTREF             OPAMP_CSR_TSTREF_Msk                      /*!< It enables the switch to put out the internal reference */
#define OPAMP_CSR_OUTCAL_Pos         (30U)                                     
#define OPAMP_CSR_OUTCAL_Msk         (0x1U << OPAMP_CSR_OUTCAL_Pos)            /*!< 0x40000000 */
#define OPAMP_CSR_OUTCAL             OPAMP_CSR_OUTCAL_Msk                      /*!< OPAMP ouput status flag */
#define OPAMP_CSR_LOCK_Pos           (31U)                                     
#define OPAMP_CSR_LOCK_Msk           (0x1U << OPAMP_CSR_LOCK_Pos)              /*!< 0x80000000 */
#define OPAMP_CSR_LOCK               OPAMP_CSR_LOCK_Msk                        /*!< OPAMP lock */

/******************************************************************************/
/*                                                                            */
/*                   Controller Area Network (CAN )                           */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for CAN_MCR register  ********************/
#define CAN_MCR_INRQ_Pos       (0U)                                            
#define CAN_MCR_INRQ_Msk       (0x1U << CAN_MCR_INRQ_Pos)                      /*!< 0x00000001 */
#define CAN_MCR_INRQ           CAN_MCR_INRQ_Msk                                /*!<Initialization Request */
#define CAN_MCR_SLEEP_Pos      (1U)                                            
#define CAN_MCR_SLEEP_Msk      (0x1U << CAN_MCR_SLEEP_Pos)                     /*!< 0x00000002 */
#define CAN_MCR_SLEEP          CAN_MCR_SLEEP_Msk                               /*!<Sleep Mode Request */
#define CAN_MCR_TXFP_Pos       (2U)                                            
#define CAN_MCR_TXFP_Msk       (0x1U << CAN_MCR_TXFP_Pos)                      /*!< 0x00000004 */
#define CAN_MCR_TXFP           CAN_MCR_TXFP_Msk                                /*!<Transmit FIFO Priority */
#define CAN_MCR_RFLM_Pos       (3U)                                            
#define CAN_MCR_RFLM_Msk       (0x1U << CAN_MCR_RFLM_Pos)                      /*!< 0x00000008 */
#define CAN_MCR_RFLM           CAN_MCR_RFLM_Msk                                /*!<Receive FIFO Locked Mode */
#define CAN_MCR_NART_Pos       (4U)                                            
#define CAN_MCR_NART_Msk       (0x1U << CAN_MCR_NART_Pos)                      /*!< 0x00000010 */
#define CAN_MCR_NART           CAN_MCR_NART_Msk                                /*!<No Automatic Retransmission */
#define CAN_MCR_AWUM_Pos       (5U)                                            
#define CAN_MCR_AWUM_Msk       (0x1U << CAN_MCR_AWUM_Pos)                      /*!< 0x00000020 */
#define CAN_MCR_AWUM           CAN_MCR_AWUM_Msk                                /*!<Automatic Wakeup Mode */
#define CAN_MCR_ABOM_Pos       (6U)                                            
#define CAN_MCR_ABOM_Msk       (0x1U << CAN_MCR_ABOM_Pos)                      /*!< 0x00000040 */
#define CAN_MCR_ABOM           CAN_MCR_ABOM_Msk                                /*!<Automatic Bus-Off Management */
#define CAN_MCR_TTCM_Pos       (7U)                                            
#define CAN_MCR_TTCM_Msk       (0x1U << CAN_MCR_TTCM_Pos)                      /*!< 0x00000080 */
#define CAN_MCR_TTCM           CAN_MCR_TTCM_Msk                                /*!<Time Triggered Communication Mode */
#define CAN_MCR_RESET_Pos      (15U)                                           
#define CAN_MCR_RESET_Msk      (0x1U << CAN_MCR_RESET_Pos)                     /*!< 0x00008000 */
#define CAN_MCR_RESET          CAN_MCR_RESET_Msk                               /*!<bxCAN software master reset */

/*******************  Bit definition for CAN_MSR register  ********************/
#define CAN_MSR_INAK_Pos       (0U)                                            
#define CAN_MSR_INAK_Msk       (0x1U << CAN_MSR_INAK_Pos)                      /*!< 0x00000001 */
#define CAN_MSR_INAK           CAN_MSR_INAK_Msk                                /*!<Initialization Acknowledge */
#define CAN_MSR_SLAK_Pos       (1U)                                            
#define CAN_MSR_SLAK_Msk       (0x1U << CAN_MSR_SLAK_Pos)                      /*!< 0x00000002 */
#define CAN_MSR_SLAK           CAN_MSR_SLAK_Msk                                /*!<Sleep Acknowledge */
#define CAN_MSR_ERRI_Pos       (2U)                                            
#define CAN_MSR_ERRI_Msk       (0x1U << CAN_MSR_ERRI_Pos)                      /*!< 0x00000004 */
#define CAN_MSR_ERRI           CAN_MSR_ERRI_Msk                                /*!<Error Interrupt */
#define CAN_MSR_WKUI_Pos       (3U)                                            
#define CAN_MSR_WKUI_Msk       (0x1U << CAN_MSR_WKUI_Pos)                      /*!< 0x00000008 */
#define CAN_MSR_WKUI           CAN_MSR_WKUI_Msk                                /*!<Wakeup Interrupt */
#define CAN_MSR_SLAKI_Pos      (4U)                                            
#define CAN_MSR_SLAKI_Msk      (0x1U << CAN_MSR_SLAKI_Pos)                     /*!< 0x00000010 */
#define CAN_MSR_SLAKI          CAN_MSR_SLAKI_Msk                               /*!<Sleep Acknowledge Interrupt */
#define CAN_MSR_TXM_Pos        (8U)                                            
#define CAN_MSR_TXM_Msk        (0x1U << CAN_MSR_TXM_Pos)                       /*!< 0x00000100 */
#define CAN_MSR_TXM            CAN_MSR_TXM_Msk                                 /*!<Transmit Mode */
#define CAN_MSR_RXM_Pos        (9U)                                            
#define CAN_MSR_RXM_Msk        (0x1U << CAN_MSR_RXM_Pos)                       /*!< 0x00000200 */
#define CAN_MSR_RXM            CAN_MSR_RXM_Msk                                 /*!<Receive Mode */
#define CAN_MSR_SAMP_Pos       (10U)                                           
#define CAN_MSR_SAMP_Msk       (0x1U << CAN_MSR_SAMP_Pos)                      /*!< 0x00000400 */
#define CAN_MSR_SAMP           CAN_MSR_SAMP_Msk                                /*!<Last Sample Point */
#define CAN_MSR_RX_Pos         (11U)                                           
#define CAN_MSR_RX_Msk         (0x1U << CAN_MSR_RX_Pos)                        /*!< 0x00000800 */
#define CAN_MSR_RX             CAN_MSR_RX_Msk                                  /*!<CAN Rx Signal */

/*******************  Bit definition for CAN_TSR register  ********************/
#define CAN_TSR_RQCP0_Pos      (0U)                                            
#define CAN_TSR_RQCP0_Msk      (0x1U << CAN_TSR_RQCP0_Pos)                     /*!< 0x00000001 */
#define CAN_TSR_RQCP0          CAN_TSR_RQCP0_Msk                               /*!<Request Completed Mailbox0 */
#define CAN_TSR_TXOK0_Pos      (1U)                                            
#define CAN_TSR_TXOK0_Msk      (0x1U << CAN_TSR_TXOK0_Pos)                     /*!< 0x00000002 */
#define CAN_TSR_TXOK0          CAN_TSR_TXOK0_Msk                               /*!<Transmission OK of Mailbox0 */
#define CAN_TSR_ALST0_Pos      (2U)                                            
#define CAN_TSR_ALST0_Msk      (0x1U << CAN_TSR_ALST0_Pos)                     /*!< 0x00000004 */
#define CAN_TSR_ALST0          CAN_TSR_ALST0_Msk                               /*!<Arbitration Lost for Mailbox0 */
#define CAN_TSR_TERR0_Pos      (3U)                                            
#define CAN_TSR_TERR0_Msk      (0x1U << CAN_TSR_TERR0_Pos)                     /*!< 0x00000008 */
#define CAN_TSR_TERR0          CAN_TSR_TERR0_Msk                               /*!<Transmission Error of Mailbox0 */
#define CAN_TSR_ABRQ0_Pos      (7U)                                            
#define CAN_TSR_ABRQ0_Msk      (0x1U << CAN_TSR_ABRQ0_Pos)                     /*!< 0x00000080 */
#define CAN_TSR_ABRQ0          CAN_TSR_ABRQ0_Msk                               /*!<Abort Request for Mailbox0 */
#define CAN_TSR_RQCP1_Pos      (8U)                                            
#define CAN_TSR_RQCP1_Msk      (0x1U << CAN_TSR_RQCP1_Pos)                     /*!< 0x00000100 */
#define CAN_TSR_RQCP1          CAN_TSR_RQCP1_Msk                               /*!<Request Completed Mailbox1 */
#define CAN_TSR_TXOK1_Pos      (9U)                                            
#define CAN_TSR_TXOK1_Msk      (0x1U << CAN_TSR_TXOK1_Pos)                     /*!< 0x00000200 */
#define CAN_TSR_TXOK1          CAN_TSR_TXOK1_Msk                               /*!<Transmission OK of Mailbox1 */
#define CAN_TSR_ALST1_Pos      (10U)                                           
#define CAN_TSR_ALST1_Msk      (0x1U << CAN_TSR_ALST1_Pos)                     /*!< 0x00000400 */
#define CAN_TSR_ALST1          CAN_TSR_ALST1_Msk                               /*!<Arbitration Lost for Mailbox1 */
#define CAN_TSR_TERR1_Pos      (11U)                                           
#define CAN_TSR_TERR1_Msk      (0x1U << CAN_TSR_TERR1_Pos)                     /*!< 0x00000800 */
#define CAN_TSR_TERR1          CAN_TSR_TERR1_Msk                               /*!<Transmission Error of Mailbox1 */
#define CAN_TSR_ABRQ1_Pos      (15U)                                           
#define CAN_TSR_ABRQ1_Msk      (0x1U << CAN_TSR_ABRQ1_Pos)                     /*!< 0x00008000 */
#define CAN_TSR_ABRQ1          CAN_TSR_ABRQ1_Msk                               /*!<Abort Request for Mailbox 1 */
#define CAN_TSR_RQCP2_Pos      (16U)                                           
#define CAN_TSR_RQCP2_Msk      (0x1U << CAN_TSR_RQCP2_Pos)                     /*!< 0x00010000 */
#define CAN_TSR_RQCP2          CAN_TSR_RQCP2_Msk                               /*!<Request Completed Mailbox2 */
#define CAN_TSR_TXOK2_Pos      (17U)                                           
#define CAN_TSR_TXOK2_Msk      (0x1U << CAN_TSR_TXOK2_Pos)                     /*!< 0x00020000 */
#define CAN_TSR_TXOK2          CAN_TSR_TXOK2_Msk                               /*!<Transmission OK of Mailbox 2 */
#define CAN_TSR_ALST2_Pos      (18U)                                           
#define CAN_TSR_ALST2_Msk      (0x1U << CAN_TSR_ALST2_Pos)                     /*!< 0x00040000 */
#define CAN_TSR_ALST2          CAN_TSR_ALST2_Msk                               /*!<Arbitration Lost for mailbox 2 */
#define CAN_TSR_TERR2_Pos      (19U)                                           
#define CAN_TSR_TERR2_Msk      (0x1U << CAN_TSR_TERR2_Pos)                     /*!< 0x00080000 */
#define CAN_TSR_TERR2          CAN_TSR_TERR2_Msk                               /*!<Transmission Error of Mailbox 2 */
#define CAN_TSR_ABRQ2_Pos      (23U)                                           
#define CAN_TSR_ABRQ2_Msk      (0x1U << CAN_TSR_ABRQ2_Pos)                     /*!< 0x00800000 */
#define CAN_TSR_ABRQ2          CAN_TSR_ABRQ2_Msk                               /*!<Abort Request for Mailbox 2 */
#define CAN_TSR_CODE_Pos       (24U)                                           
#define CAN_TSR_CODE_Msk       (0x3U << CAN_TSR_CODE_Pos)                      /*!< 0x03000000 */
#define CAN_TSR_CODE           CAN_TSR_CODE_Msk                                /*!<Mailbox Code */

#define CAN_TSR_TME_Pos        (26U)                                           
#define CAN_TSR_TME_Msk        (0x7U << CAN_TSR_TME_Pos)                       /*!< 0x1C000000 */
#define CAN_TSR_TME            CAN_TSR_TME_Msk                                 /*!<TME[2:0] bits */
#define CAN_TSR_TME0_Pos       (26U)                                           
#define CAN_TSR_TME0_Msk       (0x1U << CAN_TSR_TME0_Pos)                      /*!< 0x04000000 */
#define CAN_TSR_TME0           CAN_TSR_TME0_Msk                                /*!<Transmit Mailbox 0 Empty */
#define CAN_TSR_TME1_Pos       (27U)                                           
#define CAN_TSR_TME1_Msk       (0x1U << CAN_TSR_TME1_Pos)                      /*!< 0x08000000 */
#define CAN_TSR_TME1           CAN_TSR_TME1_Msk                                /*!<Transmit Mailbox 1 Empty */
#define CAN_TSR_TME2_Pos       (28U)                                           
#define CAN_TSR_TME2_Msk       (0x1U << CAN_TSR_TME2_Pos)                      /*!< 0x10000000 */
#define CAN_TSR_TME2           CAN_TSR_TME2_Msk                                /*!<Transmit Mailbox 2 Empty */

#define CAN_TSR_LOW_Pos        (29U)                                           
#define CAN_TSR_LOW_Msk        (0x7U << CAN_TSR_LOW_Pos)                       /*!< 0xE0000000 */
#define CAN_TSR_LOW            CAN_TSR_LOW_Msk                                 /*!<LOW[2:0] bits */
#define CAN_TSR_LOW0_Pos       (29U)                                           
#define CAN_TSR_LOW0_Msk       (0x1U << CAN_TSR_LOW0_Pos)                      /*!< 0x20000000 */
#define CAN_TSR_LOW0           CAN_TSR_LOW0_Msk                                /*!<Lowest Priority Flag for Mailbox 0 */
#define CAN_TSR_LOW1_Pos       (30U)                                           
#define CAN_TSR_LOW1_Msk       (0x1U << CAN_TSR_LOW1_Pos)                      /*!< 0x40000000 */
#define CAN_TSR_LOW1           CAN_TSR_LOW1_Msk                                /*!<Lowest Priority Flag for Mailbox 1 */
#define CAN_TSR_LOW2_Pos       (31U)                                           
#define CAN_TSR_LOW2_Msk       (0x1U << CAN_TSR_LOW2_Pos)                      /*!< 0x80000000 */
#define CAN_TSR_LOW2           CAN_TSR_LOW2_Msk                                /*!<Lowest Priority Flag for Mailbox 2 */

/*******************  Bit definition for CAN_RF0R register  *******************/
#define CAN_RF0R_FMP0_Pos      (0U)                                            
#define CAN_RF0R_FMP0_Msk      (0x3U << CAN_RF0R_FMP0_Pos)                     /*!< 0x00000003 */
#define CAN_RF0R_FMP0          CAN_RF0R_FMP0_Msk                               /*!<FIFO 0 Message Pending */
#define CAN_RF0R_FULL0_Pos     (3U)                                            
#define CAN_RF0R_FULL0_Msk     (0x1U << CAN_RF0R_FULL0_Pos)                    /*!< 0x00000008 */
#define CAN_RF0R_FULL0         CAN_RF0R_FULL0_Msk                              /*!<FIFO 0 Full */
#define CAN_RF0R_FOVR0_Pos     (4U)                                            
#define CAN_RF0R_FOVR0_Msk     (0x1U << CAN_RF0R_FOVR0_Pos)                    /*!< 0x00000010 */
#define CAN_RF0R_FOVR0         CAN_RF0R_FOVR0_Msk                              /*!<FIFO 0 Overrun */
#define CAN_RF0R_RFOM0_Pos     (5U)                                            
#define CAN_RF0R_RFOM0_Msk     (0x1U << CAN_RF0R_RFOM0_Pos)                    /*!< 0x00000020 */
#define CAN_RF0R_RFOM0         CAN_RF0R_RFOM0_Msk                              /*!<Release FIFO 0 Output Mailbox */

/*******************  Bit definition for CAN_RF1R register  *******************/
#define CAN_RF1R_FMP1_Pos      (0U)                                            
#define CAN_RF1R_FMP1_Msk      (0x3U << CAN_RF1R_FMP1_Pos)                     /*!< 0x00000003 */
#define CAN_RF1R_FMP1          CAN_RF1R_FMP1_Msk                               /*!<FIFO 1 Message Pending */
#define CAN_RF1R_FULL1_Pos     (3U)                                            
#define CAN_RF1R_FULL1_Msk     (0x1U << CAN_RF1R_FULL1_Pos)                    /*!< 0x00000008 */
#define CAN_RF1R_FULL1         CAN_RF1R_FULL1_Msk                              /*!<FIFO 1 Full */
#define CAN_RF1R_FOVR1_Pos     (4U)                                            
#define CAN_RF1R_FOVR1_Msk     (0x1U << CAN_RF1R_FOVR1_Pos)                    /*!< 0x00000010 */
#define CAN_RF1R_FOVR1         CAN_RF1R_FOVR1_Msk                              /*!<FIFO 1 Overrun */
#define CAN_RF1R_RFOM1_Pos     (5U)                                            
#define CAN_RF1R_RFOM1_Msk     (0x1U << CAN_RF1R_RFOM1_Pos)                    /*!< 0x00000020 */
#define CAN_RF1R_RFOM1         CAN_RF1R_RFOM1_Msk                              /*!<Release FIFO 1 Output Mailbox */

/********************  Bit definition for CAN_IER register  *******************/
#define CAN_IER_TMEIE_Pos      (0U)                                            
#define CAN_IER_TMEIE_Msk      (0x1U << CAN_IER_TMEIE_Pos)                     /*!< 0x00000001 */
#define CAN_IER_TMEIE          CAN_IER_TMEIE_Msk                               /*!<Transmit Mailbox Empty Interrupt Enable */
#define CAN_IER_FMPIE0_Pos     (1U)                                            
#define CAN_IER_FMPIE0_Msk     (0x1U << CAN_IER_FMPIE0_Pos)                    /*!< 0x00000002 */
#define CAN_IER_FMPIE0         CAN_IER_FMPIE0_Msk                              /*!<FIFO Message Pending Interrupt Enable */
#define CAN_IER_FFIE0_Pos      (2U)                                            
#define CAN_IER_FFIE0_Msk      (0x1U << CAN_IER_FFIE0_Pos)                     /*!< 0x00000004 */
#define CAN_IER_FFIE0          CAN_IER_FFIE0_Msk                               /*!<FIFO Full Interrupt Enable */
#define CAN_IER_FOVIE0_Pos     (3U)                                            
#define CAN_IER_FOVIE0_Msk     (0x1U << CAN_IER_FOVIE0_Pos)                    /*!< 0x00000008 */
#define CAN_IER_FOVIE0         CAN_IER_FOVIE0_Msk                              /*!<FIFO Overrun Interrupt Enable */
#define CAN_IER_FMPIE1_Pos     (4U)                                            
#define CAN_IER_FMPIE1_Msk     (0x1U << CAN_IER_FMPIE1_Pos)                    /*!< 0x00000010 */
#define CAN_IER_FMPIE1         CAN_IER_FMPIE1_Msk                              /*!<FIFO Message Pending Interrupt Enable */
#define CAN_IER_FFIE1_Pos      (5U)                                            
#define CAN_IER_FFIE1_Msk      (0x1U << CAN_IER_FFIE1_Pos)                     /*!< 0x00000020 */
#define CAN_IER_FFIE1          CAN_IER_FFIE1_Msk                               /*!<FIFO Full Interrupt Enable */
#define CAN_IER_FOVIE1_Pos     (6U)                                            
#define CAN_IER_FOVIE1_Msk     (0x1U << CAN_IER_FOVIE1_Pos)                    /*!< 0x00000040 */
#define CAN_IER_FOVIE1         CAN_IER_FOVIE1_Msk                              /*!<FIFO Overrun Interrupt Enable */
#define CAN_IER_EWGIE_Pos      (8U)                                            
#define CAN_IER_EWGIE_Msk      (0x1U << CAN_IER_EWGIE_Pos)                     /*!< 0x00000100 */
#define CAN_IER_EWGIE          CAN_IER_EWGIE_Msk                               /*!<Error Warning Interrupt Enable */
#define CAN_IER_EPVIE_Pos      (9U)                                            
#define CAN_IER_EPVIE_Msk      (0x1U << CAN_IER_EPVIE_Pos)                     /*!< 0x00000200 */
#define CAN_IER_EPVIE          CAN_IER_EPVIE_Msk                               /*!<Error Passive Interrupt Enable */
#define CAN_IER_BOFIE_Pos      (10U)                                           
#define CAN_IER_BOFIE_Msk      (0x1U << CAN_IER_BOFIE_Pos)                     /*!< 0x00000400 */
#define CAN_IER_BOFIE          CAN_IER_BOFIE_Msk                               /*!<Bus-Off Interrupt Enable */
#define CAN_IER_LECIE_Pos      (11U)                                           
#define CAN_IER_LECIE_Msk      (0x1U << CAN_IER_LECIE_Pos)                     /*!< 0x00000800 */
#define CAN_IER_LECIE          CAN_IER_LECIE_Msk                               /*!<Last Error Code Interrupt Enable */
#define CAN_IER_ERRIE_Pos      (15U)                                           
#define CAN_IER_ERRIE_Msk      (0x1U << CAN_IER_ERRIE_Pos)                     /*!< 0x00008000 */
#define CAN_IER_ERRIE          CAN_IER_ERRIE_Msk                               /*!<Error Interrupt Enable */
#define CAN_IER_WKUIE_Pos      (16U)                                           
#define CAN_IER_WKUIE_Msk      (0x1U << CAN_IER_WKUIE_Pos)                     /*!< 0x00010000 */
#define CAN_IER_WKUIE          CAN_IER_WKUIE_Msk                               /*!<Wakeup Interrupt Enable */
#define CAN_IER_SLKIE_Pos      (17U)                                           
#define CAN_IER_SLKIE_Msk      (0x1U << CAN_IER_SLKIE_Pos)                     /*!< 0x00020000 */
#define CAN_IER_SLKIE          CAN_IER_SLKIE_Msk                               /*!<Sleep Interrupt Enable */

/********************  Bit definition for CAN_ESR register  *******************/
#define CAN_ESR_EWGF_Pos       (0U)                                            
#define CAN_ESR_EWGF_Msk       (0x1U << CAN_ESR_EWGF_Pos)                      /*!< 0x00000001 */
#define CAN_ESR_EWGF           CAN_ESR_EWGF_Msk                                /*!<Error Warning Flag */
#define CAN_ESR_EPVF_Pos       (1U)                                            
#define CAN_ESR_EPVF_Msk       (0x1U << CAN_ESR_EPVF_Pos)                      /*!< 0x00000002 */
#define CAN_ESR_EPVF           CAN_ESR_EPVF_Msk                                /*!<Error Passive Flag */
#define CAN_ESR_BOFF_Pos       (2U)                                            
#define CAN_ESR_BOFF_Msk       (0x1U << CAN_ESR_BOFF_Pos)                      /*!< 0x00000004 */
#define CAN_ESR_BOFF           CAN_ESR_BOFF_Msk                                /*!<Bus-Off Flag */

#define CAN_ESR_LEC_Pos        (4U)                                            
#define CAN_ESR_LEC_Msk        (0x7U << CAN_ESR_LEC_Pos)                       /*!< 0x00000070 */
#define CAN_ESR_LEC            CAN_ESR_LEC_Msk                                 /*!<LEC[2:0] bits (Last Error Code) */
#define CAN_ESR_LEC_0          (0x1U << CAN_ESR_LEC_Pos)                       /*!< 0x00000010 */
#define CAN_ESR_LEC_1          (0x2U << CAN_ESR_LEC_Pos)                       /*!< 0x00000020 */
#define CAN_ESR_LEC_2          (0x4U << CAN_ESR_LEC_Pos)                       /*!< 0x00000040 */

#define CAN_ESR_TEC_Pos        (16U)                                           
#define CAN_ESR_TEC_Msk        (0xFFU << CAN_ESR_TEC_Pos)                      /*!< 0x00FF0000 */
#define CAN_ESR_TEC            CAN_ESR_TEC_Msk                                 /*!<Least significant byte of the 9-bit Transmit Error Counter */
#define CAN_ESR_REC_Pos        (24U)                                           
#define CAN_ESR_REC_Msk        (0xFFU << CAN_ESR_REC_Pos)                      /*!< 0xFF000000 */
#define CAN_ESR_REC            CAN_ESR_REC_Msk                                 /*!<Receive Error Counter */

/*******************  Bit definition for CAN_BTR register  ********************/
#define CAN_BTR_BRP_Pos        (0U)                                            
#define CAN_BTR_BRP_Msk        (0x3FFU << CAN_BTR_BRP_Pos)                     /*!< 0x000003FF */
#define CAN_BTR_BRP            CAN_BTR_BRP_Msk                                 /*!<Baud Rate Prescaler */
#define CAN_BTR_TS1_Pos        (16U)                                           
#define CAN_BTR_TS1_Msk        (0xFU << CAN_BTR_TS1_Pos)                       /*!< 0x000F0000 */
#define CAN_BTR_TS1            CAN_BTR_TS1_Msk                                 /*!<Time Segment 1 */
#define CAN_BTR_TS1_0          (0x1U << CAN_BTR_TS1_Pos)                       /*!< 0x00010000 */
#define CAN_BTR_TS1_1          (0x2U << CAN_BTR_TS1_Pos)                       /*!< 0x00020000 */
#define CAN_BTR_TS1_2          (0x4U << CAN_BTR_TS1_Pos)                       /*!< 0x00040000 */
#define CAN_BTR_TS1_3          (0x8U << CAN_BTR_TS1_Pos)                       /*!< 0x00080000 */
#define CAN_BTR_TS2_Pos        (20U)                                           
#define CAN_BTR_TS2_Msk        (0x7U << CAN_BTR_TS2_Pos)                       /*!< 0x00700000 */
#define CAN_BTR_TS2            CAN_BTR_TS2_Msk                                 /*!<Time Segment 2 */
#define CAN_BTR_TS2_0          (0x1U << CAN_BTR_TS2_Pos)                       /*!< 0x00100000 */
#define CAN_BTR_TS2_1          (0x2U << CAN_BTR_TS2_Pos)                       /*!< 0x00200000 */
#define CAN_BTR_TS2_2          (0x4U << CAN_BTR_TS2_Pos)                       /*!< 0x00400000 */
#define CAN_BTR_SJW_Pos        (24U)                                           
#define CAN_BTR_SJW_Msk        (0x3U << CAN_BTR_SJW_Pos)                       /*!< 0x03000000 */
#define CAN_BTR_SJW            CAN_BTR_SJW_Msk                                 /*!<Resynchronization Jump Width */
#define CAN_BTR_SJW_0          (0x1U << CAN_BTR_SJW_Pos)                       /*!< 0x01000000 */
#define CAN_BTR_SJW_1          (0x2U << CAN_BTR_SJW_Pos)                       /*!< 0x02000000 */
#define CAN_BTR_LBKM_Pos       (30U)                                           
#define CAN_BTR_LBKM_Msk       (0x1U << CAN_BTR_LBKM_Pos)                      /*!< 0x40000000 */
#define CAN_BTR_LBKM           CAN_BTR_LBKM_Msk                                /*!<Loop Back Mode (Debug) */
#define CAN_BTR_SILM_Pos       (31U)                                           
#define CAN_BTR_SILM_Msk       (0x1U << CAN_BTR_SILM_Pos)                      /*!< 0x80000000 */
#define CAN_BTR_SILM           CAN_BTR_SILM_Msk                                /*!<Silent Mode */

/*!<Mailbox registers */
/******************  Bit definition for CAN_TI0R register  ********************/
#define CAN_TI0R_TXRQ_Pos      (0U)                                            
#define CAN_TI0R_TXRQ_Msk      (0x1U << CAN_TI0R_TXRQ_Pos)                     /*!< 0x00000001 */
#define CAN_TI0R_TXRQ          CAN_TI0R_TXRQ_Msk                               /*!<Transmit Mailbox Request */
#define CAN_TI0R_RTR_Pos       (1U)                                            
#define CAN_TI0R_RTR_Msk       (0x1U << CAN_TI0R_RTR_Pos)                      /*!< 0x00000002 */
#define CAN_TI0R_RTR           CAN_TI0R_RTR_Msk                                /*!<Remote Transmission Request */
#define CAN_TI0R_IDE_Pos       (2U)                                            
#define CAN_TI0R_IDE_Msk       (0x1U << CAN_TI0R_IDE_Pos)                      /*!< 0x00000004 */
#define CAN_TI0R_IDE           CAN_TI0R_IDE_Msk                                /*!<Identifier Extension */
#define CAN_TI0R_EXID_Pos      (3U)                                            
#define CAN_TI0R_EXID_Msk      (0x3FFFFU << CAN_TI0R_EXID_Pos)                 /*!< 0x001FFFF8 */
#define CAN_TI0R_EXID          CAN_TI0R_EXID_Msk                               /*!<Extended Identifier */
#define CAN_TI0R_STID_Pos      (21U)                                           
#define CAN_TI0R_STID_Msk      (0x7FFU << CAN_TI0R_STID_Pos)                   /*!< 0xFFE00000 */
#define CAN_TI0R_STID          CAN_TI0R_STID_Msk                               /*!<Standard Identifier or Extended Identifier */

/******************  Bit definition for CAN_TDT0R register  *******************/
#define CAN_TDT0R_DLC_Pos      (0U)                                            
#define CAN_TDT0R_DLC_Msk      (0xFU << CAN_TDT0R_DLC_Pos)                     /*!< 0x0000000F */
#define CAN_TDT0R_DLC          CAN_TDT0R_DLC_Msk                               /*!<Data Length Code */
#define CAN_TDT0R_TGT_Pos      (8U)                                            
#define CAN_TDT0R_TGT_Msk      (0x1U << CAN_TDT0R_TGT_Pos)                     /*!< 0x00000100 */
#define CAN_TDT0R_TGT          CAN_TDT0R_TGT_Msk                               /*!<Transmit Global Time */
#define CAN_TDT0R_TIME_Pos     (16U)                                           
#define CAN_TDT0R_TIME_Msk     (0xFFFFU << CAN_TDT0R_TIME_Pos)                 /*!< 0xFFFF0000 */
#define CAN_TDT0R_TIME         CAN_TDT0R_TIME_Msk                              /*!<Message Time Stamp */

/******************  Bit definition for CAN_TDL0R register  *******************/
#define CAN_TDL0R_DATA0_Pos    (0U)                                            
#define CAN_TDL0R_DATA0_Msk    (0xFFU << CAN_TDL0R_DATA0_Pos)                  /*!< 0x000000FF */
#define CAN_TDL0R_DATA0        CAN_TDL0R_DATA0_Msk                             /*!<Data byte 0 */
#define CAN_TDL0R_DATA1_Pos    (8U)                                            
#define CAN_TDL0R_DATA1_Msk    (0xFFU << CAN_TDL0R_DATA1_Pos)                  /*!< 0x0000FF00 */
#define CAN_TDL0R_DATA1        CAN_TDL0R_DATA1_Msk                             /*!<Data byte 1 */
#define CAN_TDL0R_DATA2_Pos    (16U)                                           
#define CAN_TDL0R_DATA2_Msk    (0xFFU << CAN_TDL0R_DATA2_Pos)                  /*!< 0x00FF0000 */
#define CAN_TDL0R_DATA2        CAN_TDL0R_DATA2_Msk                             /*!<Data byte 2 */
#define CAN_TDL0R_DATA3_Pos    (24U)                                           
#define CAN_TDL0R_DATA3_Msk    (0xFFU << CAN_TDL0R_DATA3_Pos)                  /*!< 0xFF000000 */
#define CAN_TDL0R_DATA3        CAN_TDL0R_DATA3_Msk                             /*!<Data byte 3 */

/******************  Bit definition for CAN_TDH0R register  *******************/
#define CAN_TDH0R_DATA4_Pos    (0U)                                            
#define CAN_TDH0R_DATA4_Msk    (0xFFU << CAN_TDH0R_DATA4_Pos)                  /*!< 0x000000FF */
#define CAN_TDH0R_DATA4        CAN_TDH0R_DATA4_Msk                             /*!<Data byte 4 */
#define CAN_TDH0R_DATA5_Pos    (8U)                                            
#define CAN_TDH0R_DATA5_Msk    (0xFFU << CAN_TDH0R_DATA5_Pos)                  /*!< 0x0000FF00 */
#define CAN_TDH0R_DATA5        CAN_TDH0R_DATA5_Msk                             /*!<Data byte 5 */
#define CAN_TDH0R_DATA6_Pos    (16U)                                           
#define CAN_TDH0R_DATA6_Msk    (0xFFU << CAN_TDH0R_DATA6_Pos)                  /*!< 0x00FF0000 */
#define CAN_TDH0R_DATA6        CAN_TDH0R_DATA6_Msk                             /*!<Data byte 6 */
#define CAN_TDH0R_DATA7_Pos    (24U)                                           
#define CAN_TDH0R_DATA7_Msk    (0xFFU << CAN_TDH0R_DATA7_Pos)                  /*!< 0xFF000000 */
#define CAN_TDH0R_DATA7        CAN_TDH0R_DATA7_Msk                             /*!<Data byte 7 */

/*******************  Bit definition for CAN_TI1R register  *******************/
#define CAN_TI1R_TXRQ_Pos      (0U)                                            
#define CAN_TI1R_TXRQ_Msk      (0x1U << CAN_TI1R_TXRQ_Pos)                     /*!< 0x00000001 */
#define CAN_TI1R_TXRQ          CAN_TI1R_TXRQ_Msk                               /*!<Transmit Mailbox Request */
#define CAN_TI1R_RTR_Pos       (1U)                                            
#define CAN_TI1R_RTR_Msk       (0x1U << CAN_TI1R_RTR_Pos)                      /*!< 0x00000002 */
#define CAN_TI1R_RTR           CAN_TI1R_RTR_Msk                                /*!<Remote Transmission Request */
#define CAN_TI1R_IDE_Pos       (2U)                                            
#define CAN_TI1R_IDE_Msk       (0x1U << CAN_TI1R_IDE_Pos)                      /*!< 0x00000004 */
#define CAN_TI1R_IDE           CAN_TI1R_IDE_Msk                                /*!<Identifier Extension */
#define CAN_TI1R_EXID_Pos      (3U)                                            
#define CAN_TI1R_EXID_Msk      (0x3FFFFU << CAN_TI1R_EXID_Pos)                 /*!< 0x001FFFF8 */
#define CAN_TI1R_EXID          CAN_TI1R_EXID_Msk                               /*!<Extended Identifier */
#define CAN_TI1R_STID_Pos      (21U)                                           
#define CAN_TI1R_STID_Msk      (0x7FFU << CAN_TI1R_STID_Pos)                   /*!< 0xFFE00000 */
#define CAN_TI1R_STID          CAN_TI1R_STID_Msk                               /*!<Standard Identifier or Extended Identifier */

/*******************  Bit definition for CAN_TDT1R register  ******************/
#define CAN_TDT1R_DLC_Pos      (0U)                                            
#define CAN_TDT1R_DLC_Msk      (0xFU << CAN_TDT1R_DLC_Pos)                     /*!< 0x0000000F */
#define CAN_TDT1R_DLC          CAN_TDT1R_DLC_Msk                               /*!<Data Length Code */
#define CAN_TDT1R_TGT_Pos      (8U)                                            
#define CAN_TDT1R_TGT_Msk      (0x1U << CAN_TDT1R_TGT_Pos)                     /*!< 0x00000100 */
#define CAN_TDT1R_TGT          CAN_TDT1R_TGT_Msk                               /*!<Transmit Global Time */
#define CAN_TDT1R_TIME_Pos     (16U)                                           
#define CAN_TDT1R_TIME_Msk     (0xFFFFU << CAN_TDT1R_TIME_Pos)                 /*!< 0xFFFF0000 */
#define CAN_TDT1R_TIME         CAN_TDT1R_TIME_Msk                              /*!<Message Time Stamp */

/*******************  Bit definition for CAN_TDL1R register  ******************/
#define CAN_TDL1R_DATA0_Pos    (0U)                                            
#define CAN_TDL1R_DATA0_Msk    (0xFFU << CAN_TDL1R_DATA0_Pos)                  /*!< 0x000000FF */
#define CAN_TDL1R_DATA0        CAN_TDL1R_DATA0_Msk                             /*!<Data byte 0 */
#define CAN_TDL1R_DATA1_Pos    (8U)                                            
#define CAN_TDL1R_DATA1_Msk    (0xFFU << CAN_TDL1R_DATA1_Pos)                  /*!< 0x0000FF00 */
#define CAN_TDL1R_DATA1        CAN_TDL1R_DATA1_Msk                             /*!<Data byte 1 */
#define CAN_TDL1R_DATA2_Pos    (16U)                                           
#define CAN_TDL1R_DATA2_Msk    (0xFFU << CAN_TDL1R_DATA2_Pos)                  /*!< 0x00FF0000 */
#define CAN_TDL1R_DATA2        CAN_TDL1R_DATA2_Msk                             /*!<Data byte 2 */
#define CAN_TDL1R_DATA3_Pos    (24U)                                           
#define CAN_TDL1R_DATA3_Msk    (0xFFU << CAN_TDL1R_DATA3_Pos)                  /*!< 0xFF000000 */
#define CAN_TDL1R_DATA3        CAN_TDL1R_DATA3_Msk                             /*!<Data byte 3 */

/*******************  Bit definition for CAN_TDH1R register  ******************/
#define CAN_TDH1R_DATA4_Pos    (0U)                                            
#define CAN_TDH1R_DATA4_Msk    (0xFFU << CAN_TDH1R_DATA4_Pos)                  /*!< 0x000000FF */
#define CAN_TDH1R_DATA4        CAN_TDH1R_DATA4_Msk                             /*!<Data byte 4 */
#define CAN_TDH1R_DATA5_Pos    (8U)                                            
#define CAN_TDH1R_DATA5_Msk    (0xFFU << CAN_TDH1R_DATA5_Pos)                  /*!< 0x0000FF00 */
#define CAN_TDH1R_DATA5        CAN_TDH1R_DATA5_Msk                             /*!<Data byte 5 */
#define CAN_TDH1R_DATA6_Pos    (16U)                                           
#define CAN_TDH1R_DATA6_Msk    (0xFFU << CAN_TDH1R_DATA6_Pos)                  /*!< 0x00FF0000 */
#define CAN_TDH1R_DATA6        CAN_TDH1R_DATA6_Msk                             /*!<Data byte 6 */
#define CAN_TDH1R_DATA7_Pos    (24U)                                           
#define CAN_TDH1R_DATA7_Msk    (0xFFU << CAN_TDH1R_DATA7_Pos)                  /*!< 0xFF000000 */
#define CAN_TDH1R_DATA7        CAN_TDH1R_DATA7_Msk                             /*!<Data byte 7 */

/*******************  Bit definition for CAN_TI2R register  *******************/
#define CAN_TI2R_TXRQ_Pos      (0U)                                            
#define CAN_TI2R_TXRQ_Msk      (0x1U << CAN_TI2R_TXRQ_Pos)                     /*!< 0x00000001 */
#define CAN_TI2R_TXRQ          CAN_TI2R_TXRQ_Msk                               /*!<Transmit Mailbox Request */
#define CAN_TI2R_RTR_Pos       (1U)                                            
#define CAN_TI2R_RTR_Msk       (0x1U << CAN_TI2R_RTR_Pos)                      /*!< 0x00000002 */
#define CAN_TI2R_RTR           CAN_TI2R_RTR_Msk                                /*!<Remote Transmission Request */
#define CAN_TI2R_IDE_Pos       (2U)                                            
#define CAN_TI2R_IDE_Msk       (0x1U << CAN_TI2R_IDE_Pos)                      /*!< 0x00000004 */
#define CAN_TI2R_IDE           CAN_TI2R_IDE_Msk                                /*!<Identifier Extension */
#define CAN_TI2R_EXID_Pos      (3U)                                            
#define CAN_TI2R_EXID_Msk      (0x3FFFFU << CAN_TI2R_EXID_Pos)                 /*!< 0x001FFFF8 */
#define CAN_TI2R_EXID          CAN_TI2R_EXID_Msk                               /*!<Extended identifier */
#define CAN_TI2R_STID_Pos      (21U)                                           
#define CAN_TI2R_STID_Msk      (0x7FFU << CAN_TI2R_STID_Pos)                   /*!< 0xFFE00000 */
#define CAN_TI2R_STID          CAN_TI2R_STID_Msk                               /*!<Standard Identifier or Extended Identifier */

/*******************  Bit definition for CAN_TDT2R register  ******************/
#define CAN_TDT2R_DLC_Pos      (0U)                                            
#define CAN_TDT2R_DLC_Msk      (0xFU << CAN_TDT2R_DLC_Pos)                     /*!< 0x0000000F */
#define CAN_TDT2R_DLC          CAN_TDT2R_DLC_Msk                               /*!<Data Length Code */
#define CAN_TDT2R_TGT_Pos      (8U)                                            
#define CAN_TDT2R_TGT_Msk      (0x1U << CAN_TDT2R_TGT_Pos)                     /*!< 0x00000100 */
#define CAN_TDT2R_TGT          CAN_TDT2R_TGT_Msk                               /*!<Transmit Global Time */
#define CAN_TDT2R_TIME_Pos     (16U)                                           
#define CAN_TDT2R_TIME_Msk     (0xFFFFU << CAN_TDT2R_TIME_Pos)                 /*!< 0xFFFF0000 */
#define CAN_TDT2R_TIME         CAN_TDT2R_TIME_Msk                              /*!<Message Time Stamp */

/*******************  Bit definition for CAN_TDL2R register  ******************/
#define CAN_TDL2R_DATA0_Pos    (0U)                                            
#define CAN_TDL2R_DATA0_Msk    (0xFFU << CAN_TDL2R_DATA0_Pos)                  /*!< 0x000000FF */
#define CAN_TDL2R_DATA0        CAN_TDL2R_DATA0_Msk                             /*!<Data byte 0 */
#define CAN_TDL2R_DATA1_Pos    (8U)                                            
#define CAN_TDL2R_DATA1_Msk    (0xFFU << CAN_TDL2R_DATA1_Pos)                  /*!< 0x0000FF00 */
#define CAN_TDL2R_DATA1        CAN_TDL2R_DATA1_Msk                             /*!<Data byte 1 */
#define CAN_TDL2R_DATA2_Pos    (16U)                                           
#define CAN_TDL2R_DATA2_Msk    (0xFFU << CAN_TDL2R_DATA2_Pos)                  /*!< 0x00FF0000 */
#define CAN_TDL2R_DATA2        CAN_TDL2R_DATA2_Msk                             /*!<Data byte 2 */
#define CAN_TDL2R_DATA3_Pos    (24U)                                           
#define CAN_TDL2R_DATA3_Msk    (0xFFU << CAN_TDL2R_DATA3_Pos)                  /*!< 0xFF000000 */
#define CAN_TDL2R_DATA3        CAN_TDL2R_DATA3_Msk                             /*!<Data byte 3 */

/*******************  Bit definition for CAN_TDH2R register  ******************/
#define CAN_TDH2R_DATA4_Pos    (0U)                                            
#define CAN_TDH2R_DATA4_Msk    (0xFFU << CAN_TDH2R_DATA4_Pos)                  /*!< 0x000000FF */
#define CAN_TDH2R_DATA4        CAN_TDH2R_DATA4_Msk                             /*!<Data byte 4 */
#define CAN_TDH2R_DATA5_Pos    (8U)                                            
#define CAN_TDH2R_DATA5_Msk    (0xFFU << CAN_TDH2R_DATA5_Pos)                  /*!< 0x0000FF00 */
#define CAN_TDH2R_DATA5        CAN_TDH2R_DATA5_Msk                             /*!<Data byte 5 */
#define CAN_TDH2R_DATA6_Pos    (16U)                                           
#define CAN_TDH2R_DATA6_Msk    (0xFFU << CAN_TDH2R_DATA6_Pos)                  /*!< 0x00FF0000 */
#define CAN_TDH2R_DATA6        CAN_TDH2R_DATA6_Msk                             /*!<Data byte 6 */
#define CAN_TDH2R_DATA7_Pos    (24U)                                           
#define CAN_TDH2R_DATA7_Msk    (0xFFU << CAN_TDH2R_DATA7_Pos)                  /*!< 0xFF000000 */
#define CAN_TDH2R_DATA7        CAN_TDH2R_DATA7_Msk                             /*!<Data byte 7 */

/*******************  Bit definition for CAN_RI0R register  *******************/
#define CAN_RI0R_RTR_Pos       (1U)                                            
#define CAN_RI0R_RTR_Msk       (0x1U << CAN_RI0R_RTR_Pos)                      /*!< 0x00000002 */
#define CAN_RI0R_RTR           CAN_RI0R_RTR_Msk                                /*!<Remote Transmission Request */
#define CAN_RI0R_IDE_Pos       (2U)                                            
#define CAN_RI0R_IDE_Msk       (0x1U << CAN_RI0R_IDE_Pos)                      /*!< 0x00000004 */
#define CAN_RI0R_IDE           CAN_RI0R_IDE_Msk                                /*!<Identifier Extension */
#define CAN_RI0R_EXID_Pos      (3U)                                            
#define CAN_RI0R_EXID_Msk      (0x3FFFFU << CAN_RI0R_EXID_Pos)                 /*!< 0x001FFFF8 */
#define CAN_RI0R_EXID          CAN_RI0R_EXID_Msk                               /*!<Extended Identifier */
#define CAN_RI0R_STID_Pos      (21U)                                           
#define CAN_RI0R_STID_Msk      (0x7FFU << CAN_RI0R_STID_Pos)                   /*!< 0xFFE00000 */
#define CAN_RI0R_STID          CAN_RI0R_STID_Msk                               /*!<Standard Identifier or Extended Identifier */

/*******************  Bit definition for CAN_RDT0R register  ******************/
#define CAN_RDT0R_DLC_Pos      (0U)                                            
#define CAN_RDT0R_DLC_Msk      (0xFU << CAN_RDT0R_DLC_Pos)                     /*!< 0x0000000F */
#define CAN_RDT0R_DLC          CAN_RDT0R_DLC_Msk                               /*!<Data Length Code */
#define CAN_RDT0R_FMI_Pos      (8U)                                            
#define CAN_RDT0R_FMI_Msk      (0xFFU << CAN_RDT0R_FMI_Pos)                    /*!< 0x0000FF00 */
#define CAN_RDT0R_FMI          CAN_RDT0R_FMI_Msk                               /*!<Filter Match Index */
#define CAN_RDT0R_TIME_Pos     (16U)                                           
#define CAN_RDT0R_TIME_Msk     (0xFFFFU << CAN_RDT0R_TIME_Pos)                 /*!< 0xFFFF0000 */
#define CAN_RDT0R_TIME         CAN_RDT0R_TIME_Msk                              /*!<Message Time Stamp */

/*******************  Bit definition for CAN_RDL0R register  ******************/
#define CAN_RDL0R_DATA0_Pos    (0U)                                            
#define CAN_RDL0R_DATA0_Msk    (0xFFU << CAN_RDL0R_DATA0_Pos)                  /*!< 0x000000FF */
#define CAN_RDL0R_DATA0        CAN_RDL0R_DATA0_Msk                             /*!<Data byte 0 */
#define CAN_RDL0R_DATA1_Pos    (8U)                                            
#define CAN_RDL0R_DATA1_Msk    (0xFFU << CAN_RDL0R_DATA1_Pos)                  /*!< 0x0000FF00 */
#define CAN_RDL0R_DATA1        CAN_RDL0R_DATA1_Msk                             /*!<Data byte 1 */
#define CAN_RDL0R_DATA2_Pos    (16U)                                           
#define CAN_RDL0R_DATA2_Msk    (0xFFU << CAN_RDL0R_DATA2_Pos)                  /*!< 0x00FF0000 */
#define CAN_RDL0R_DATA2        CAN_RDL0R_DATA2_Msk                             /*!<Data byte 2 */
#define CAN_RDL0R_DATA3_Pos    (24U)                                           
#define CAN_RDL0R_DATA3_Msk    (0xFFU << CAN_RDL0R_DATA3_Pos)                  /*!< 0xFF000000 */
#define CAN_RDL0R_DATA3        CAN_RDL0R_DATA3_Msk                             /*!<Data byte 3 */

/*******************  Bit definition for CAN_RDH0R register  ******************/
#define CAN_RDH0R_DATA4_Pos    (0U)                                            
#define CAN_RDH0R_DATA4_Msk    (0xFFU << CAN_RDH0R_DATA4_Pos)                  /*!< 0x000000FF */
#define CAN_RDH0R_DATA4        CAN_RDH0R_DATA4_Msk                             /*!<Data byte 4 */
#define CAN_RDH0R_DATA5_Pos    (8U)                                            
#define CAN_RDH0R_DATA5_Msk    (0xFFU << CAN_RDH0R_DATA5_Pos)                  /*!< 0x0000FF00 */
#define CAN_RDH0R_DATA5        CAN_RDH0R_DATA5_Msk                             /*!<Data byte 5 */
#define CAN_RDH0R_DATA6_Pos    (16U)                                           
#define CAN_RDH0R_DATA6_Msk    (0xFFU << CAN_RDH0R_DATA6_Pos)                  /*!< 0x00FF0000 */
#define CAN_RDH0R_DATA6        CAN_RDH0R_DATA6_Msk                             /*!<Data byte 6 */
#define CAN_RDH0R_DATA7_Pos    (24U)                                           
#define CAN_RDH0R_DATA7_Msk    (0xFFU << CAN_RDH0R_DATA7_Pos)                  /*!< 0xFF000000 */
#define CAN_RDH0R_DATA7        CAN_RDH0R_DATA7_Msk                             /*!<Data byte 7 */

/*******************  Bit definition for CAN_RI1R register  *******************/
#define CAN_RI1R_RTR_Pos       (1U)                                            
#define CAN_RI1R_RTR_Msk       (0x1U << CAN_RI1R_RTR_Pos)                      /*!< 0x00000002 */
#define CAN_RI1R_RTR           CAN_RI1R_RTR_Msk                                /*!<Remote Transmission Request */
#define CAN_RI1R_IDE_Pos       (2U)                                            
#define CAN_RI1R_IDE_Msk       (0x1U << CAN_RI1R_IDE_Pos)                      /*!< 0x00000004 */
#define CAN_RI1R_IDE           CAN_RI1R_IDE_Msk                                /*!<Identifier Extension */
#define CAN_RI1R_EXID_Pos      (3U)                                            
#define CAN_RI1R_EXID_Msk      (0x3FFFFU << CAN_RI1R_EXID_Pos)                 /*!< 0x001FFFF8 */
#define CAN_RI1R_EXID          CAN_RI1R_EXID_Msk                               /*!<Extended identifier */
#define CAN_RI1R_STID_Pos      (21U)                                           
#define CAN_RI1R_STID_Msk      (0x7FFU << CAN_RI1R_STID_Pos)                   /*!< 0xFFE00000 */
#define CAN_RI1R_STID          CAN_RI1R_STID_Msk                               /*!<Standard Identifier or Extended Identifier */

/*******************  Bit definition for CAN_RDT1R register  ******************/
#define CAN_RDT1R_DLC_Pos      (0U)                                            
#define CAN_RDT1R_DLC_Msk      (0xFU << CAN_RDT1R_DLC_Pos)                     /*!< 0x0000000F */
#define CAN_RDT1R_DLC          CAN_RDT1R_DLC_Msk                               /*!<Data Length Code */
#define CAN_RDT1R_FMI_Pos      (8U)                                            
#define CAN_RDT1R_FMI_Msk      (0xFFU << CAN_RDT1R_FMI_Pos)                    /*!< 0x0000FF00 */
#define CAN_RDT1R_FMI          CAN_RDT1R_FMI_Msk                               /*!<Filter Match Index */
#define CAN_RDT1R_TIME_Pos     (16U)                                           
#define CAN_RDT1R_TIME_Msk     (0xFFFFU << CAN_RDT1R_TIME_Pos)                 /*!< 0xFFFF0000 */
#define CAN_RDT1R_TIME         CAN_RDT1R_TIME_Msk                              /*!<Message Time Stamp */

/*******************  Bit definition for CAN_RDL1R register  ******************/
#define CAN_RDL1R_DATA0_Pos    (0U)                                            
#define CAN_RDL1R_DATA0_Msk    (0xFFU << CAN_RDL1R_DATA0_Pos)                  /*!< 0x000000FF */
#define CAN_RDL1R_DATA0        CAN_RDL1R_DATA0_Msk                             /*!<Data byte 0 */
#define CAN_RDL1R_DATA1_Pos    (8U)                                            
#define CAN_RDL1R_DATA1_Msk    (0xFFU << CAN_RDL1R_DATA1_Pos)                  /*!< 0x0000FF00 */
#define CAN_RDL1R_DATA1        CAN_RDL1R_DATA1_Msk                             /*!<Data byte 1 */
#define CAN_RDL1R_DATA2_Pos    (16U)                                           
#define CAN_RDL1R_DATA2_Msk    (0xFFU << CAN_RDL1R_DATA2_Pos)                  /*!< 0x00FF0000 */
#define CAN_RDL1R_DATA2        CAN_RDL1R_DATA2_Msk                             /*!<Data byte 2 */
#define CAN_RDL1R_DATA3_Pos    (24U)                                           
#define CAN_RDL1R_DATA3_Msk    (0xFFU << CAN_RDL1R_DATA3_Pos)                  /*!< 0xFF000000 */
#define CAN_RDL1R_DATA3        CAN_RDL1R_DATA3_Msk                             /*!<Data byte 3 */

/*******************  Bit definition for CAN_RDH1R register  ******************/
#define CAN_RDH1R_DATA4_Pos    (0U)                                            
#define CAN_RDH1R_DATA4_Msk    (0xFFU << CAN_RDH1R_DATA4_Pos)                  /*!< 0x000000FF */
#define CAN_RDH1R_DATA4        CAN_RDH1R_DATA4_Msk                             /*!<Data byte 4 */
#define CAN_RDH1R_DATA5_Pos    (8U)                                            
#define CAN_RDH1R_DATA5_Msk    (0xFFU << CAN_RDH1R_DATA5_Pos)                  /*!< 0x0000FF00 */
#define CAN_RDH1R_DATA5        CAN_RDH1R_DATA5_Msk                             /*!<Data byte 5 */
#define CAN_RDH1R_DATA6_Pos    (16U)                                           
#define CAN_RDH1R_DATA6_Msk    (0xFFU << CAN_RDH1R_DATA6_Pos)                  /*!< 0x00FF0000 */
#define CAN_RDH1R_DATA6        CAN_RDH1R_DATA6_Msk                             /*!<Data byte 6 */
#define CAN_RDH1R_DATA7_Pos    (24U)                                           
#define CAN_RDH1R_DATA7_Msk    (0xFFU << CAN_RDH1R_DATA7_Pos)                  /*!< 0xFF000000 */
#define CAN_RDH1R_DATA7        CAN_RDH1R_DATA7_Msk                             /*!<Data byte 7 */

/*!<CAN filter registers */
/*******************  Bit definition for CAN_FMR register  ********************/
#define CAN_FMR_FINIT_Pos      (0U)                                            
#define CAN_FMR_FINIT_Msk      (0x1U << CAN_FMR_FINIT_Pos)                     /*!< 0x00000001 */
#define CAN_FMR_FINIT          CAN_FMR_FINIT_Msk                               /*!<Filter Init Mode */

/*******************  Bit definition for CAN_FM1R register  *******************/
#define CAN_FM1R_FBM_Pos       (0U)                                            
#define CAN_FM1R_FBM_Msk       (0x3FFFU << CAN_FM1R_FBM_Pos)                   /*!< 0x00003FFF */
#define CAN_FM1R_FBM           CAN_FM1R_FBM_Msk                                /*!<Filter Mode */
#define CAN_FM1R_FBM0_Pos      (0U)                                            
#define CAN_FM1R_FBM0_Msk      (0x1U << CAN_FM1R_FBM0_Pos)                     /*!< 0x00000001 */
#define CAN_FM1R_FBM0          CAN_FM1R_FBM0_Msk                               /*!<Filter Init Mode bit 0 */
#define CAN_FM1R_FBM1_Pos      (1U)                                            
#define CAN_FM1R_FBM1_Msk      (0x1U << CAN_FM1R_FBM1_Pos)                     /*!< 0x00000002 */
#define CAN_FM1R_FBM1          CAN_FM1R_FBM1_Msk                               /*!<Filter Init Mode bit 1 */
#define CAN_FM1R_FBM2_Pos      (2U)                                            
#define CAN_FM1R_FBM2_Msk      (0x1U << CAN_FM1R_FBM2_Pos)                     /*!< 0x00000004 */
#define CAN_FM1R_FBM2          CAN_FM1R_FBM2_Msk                               /*!<Filter Init Mode bit 2 */
#define CAN_FM1R_FBM3_Pos      (3U)                                            
#define CAN_FM1R_FBM3_Msk      (0x1U << CAN_FM1R_FBM3_Pos)                     /*!< 0x00000008 */
#define CAN_FM1R_FBM3          CAN_FM1R_FBM3_Msk                               /*!<Filter Init Mode bit 3 */
#define CAN_FM1R_FBM4_Pos      (4U)                                            
#define CAN_FM1R_FBM4_Msk      (0x1U << CAN_FM1R_FBM4_Pos)                     /*!< 0x00000010 */
#define CAN_FM1R_FBM4          CAN_FM1R_FBM4_Msk                               /*!<Filter Init Mode bit 4 */
#define CAN_FM1R_FBM5_Pos      (5U)                                            
#define CAN_FM1R_FBM5_Msk      (0x1U << CAN_FM1R_FBM5_Pos)                     /*!< 0x00000020 */
#define CAN_FM1R_FBM5          CAN_FM1R_FBM5_Msk                               /*!<Filter Init Mode bit 5 */
#define CAN_FM1R_FBM6_Pos      (6U)                                            
#define CAN_FM1R_FBM6_Msk      (0x1U << CAN_FM1R_FBM6_Pos)                     /*!< 0x00000040 */
#define CAN_FM1R_FBM6          CAN_FM1R_FBM6_Msk                               /*!<Filter Init Mode bit 6 */
#define CAN_FM1R_FBM7_Pos      (7U)                                            
#define CAN_FM1R_FBM7_Msk      (0x1U << CAN_FM1R_FBM7_Pos)                     /*!< 0x00000080 */
#define CAN_FM1R_FBM7          CAN_FM1R_FBM7_Msk                               /*!<Filter Init Mode bit 7 */
#define CAN_FM1R_FBM8_Pos      (8U)                                            
#define CAN_FM1R_FBM8_Msk      (0x1U << CAN_FM1R_FBM8_Pos)                     /*!< 0x00000100 */
#define CAN_FM1R_FBM8          CAN_FM1R_FBM8_Msk                               /*!<Filter Init Mode bit 8 */
#define CAN_FM1R_FBM9_Pos      (9U)                                            
#define CAN_FM1R_FBM9_Msk      (0x1U << CAN_FM1R_FBM9_Pos)                     /*!< 0x00000200 */
#define CAN_FM1R_FBM9          CAN_FM1R_FBM9_Msk                               /*!<Filter Init Mode bit 9 */
#define CAN_FM1R_FBM10_Pos     (10U)                                           
#define CAN_FM1R_FBM10_Msk     (0x1U << CAN_FM1R_FBM10_Pos)                    /*!< 0x00000400 */
#define CAN_FM1R_FBM10         CAN_FM1R_FBM10_Msk                              /*!<Filter Init Mode bit 10 */
#define CAN_FM1R_FBM11_Pos     (11U)                                           
#define CAN_FM1R_FBM11_Msk     (0x1U << CAN_FM1R_FBM11_Pos)                    /*!< 0x00000800 */
#define CAN_FM1R_FBM11         CAN_FM1R_FBM11_Msk                              /*!<Filter Init Mode bit 11 */
#define CAN_FM1R_FBM12_Pos     (12U)                                           
#define CAN_FM1R_FBM12_Msk     (0x1U << CAN_FM1R_FBM12_Pos)                    /*!< 0x00001000 */
#define CAN_FM1R_FBM12         CAN_FM1R_FBM12_Msk                              /*!<Filter Init Mode bit 12 */
#define CAN_FM1R_FBM13_Pos     (13U)                                           
#define CAN_FM1R_FBM13_Msk     (0x1U << CAN_FM1R_FBM13_Pos)                    /*!< 0x00002000 */
#define CAN_FM1R_FBM13         CAN_FM1R_FBM13_Msk                              /*!<Filter Init Mode bit 13 */

/*******************  Bit definition for CAN_FS1R register  *******************/
#define CAN_FS1R_FSC_Pos       (0U)                                            
#define CAN_FS1R_FSC_Msk       (0x3FFFU << CAN_FS1R_FSC_Pos)                   /*!< 0x00003FFF */
#define CAN_FS1R_FSC           CAN_FS1R_FSC_Msk                                /*!<Filter Scale Configuration */
#define CAN_FS1R_FSC0_Pos      (0U)                                            
#define CAN_FS1R_FSC0_Msk      (0x1U << CAN_FS1R_FSC0_Pos)                     /*!< 0x00000001 */
#define CAN_FS1R_FSC0          CAN_FS1R_FSC0_Msk                               /*!<Filter Scale Configuration bit 0 */
#define CAN_FS1R_FSC1_Pos      (1U)                                            
#define CAN_FS1R_FSC1_Msk      (0x1U << CAN_FS1R_FSC1_Pos)                     /*!< 0x00000002 */
#define CAN_FS1R_FSC1          CAN_FS1R_FSC1_Msk                               /*!<Filter Scale Configuration bit 1 */
#define CAN_FS1R_FSC2_Pos      (2U)                                            
#define CAN_FS1R_FSC2_Msk      (0x1U << CAN_FS1R_FSC2_Pos)                     /*!< 0x00000004 */
#define CAN_FS1R_FSC2          CAN_FS1R_FSC2_Msk                               /*!<Filter Scale Configuration bit 2 */
#define CAN_FS1R_FSC3_Pos      (3U)                                            
#define CAN_FS1R_FSC3_Msk      (0x1U << CAN_FS1R_FSC3_Pos)                     /*!< 0x00000008 */
#define CAN_FS1R_FSC3          CAN_FS1R_FSC3_Msk                               /*!<Filter Scale Configuration bit 3 */
#define CAN_FS1R_FSC4_Pos      (4U)                                            
#define CAN_FS1R_FSC4_Msk      (0x1U << CAN_FS1R_FSC4_Pos)                     /*!< 0x00000010 */
#define CAN_FS1R_FSC4          CAN_FS1R_FSC4_Msk                               /*!<Filter Scale Configuration bit 4 */
#define CAN_FS1R_FSC5_Pos      (5U)                                            
#define CAN_FS1R_FSC5_Msk      (0x1U << CAN_FS1R_FSC5_Pos)                     /*!< 0x00000020 */
#define CAN_FS1R_FSC5          CAN_FS1R_FSC5_Msk                               /*!<Filter Scale Configuration bit 5 */
#define CAN_FS1R_FSC6_Pos      (6U)                                            
#define CAN_FS1R_FSC6_Msk      (0x1U << CAN_FS1R_FSC6_Pos)                     /*!< 0x00000040 */
#define CAN_FS1R_FSC6          CAN_FS1R_FSC6_Msk                               /*!<Filter Scale Configuration bit 6 */
#define CAN_FS1R_FSC7_Pos      (7U)                                            
#define CAN_FS1R_FSC7_Msk      (0x1U << CAN_FS1R_FSC7_Pos)                     /*!< 0x00000080 */
#define CAN_FS1R_FSC7          CAN_FS1R_FSC7_Msk                               /*!<Filter Scale Configuration bit 7 */
#define CAN_FS1R_FSC8_Pos      (8U)                                            
#define CAN_FS1R_FSC8_Msk      (0x1U << CAN_FS1R_FSC8_Pos)                     /*!< 0x00000100 */
#define CAN_FS1R_FSC8          CAN_FS1R_FSC8_Msk                               /*!<Filter Scale Configuration bit 8 */
#define CAN_FS1R_FSC9_Pos      (9U)                                            
#define CAN_FS1R_FSC9_Msk      (0x1U << CAN_FS1R_FSC9_Pos)                     /*!< 0x00000200 */
#define CAN_FS1R_FSC9          CAN_FS1R_FSC9_Msk                               /*!<Filter Scale Configuration bit 9 */
#define CAN_FS1R_FSC10_Pos     (10U)                                           
#define CAN_FS1R_FSC10_Msk     (0x1U << CAN_FS1R_FSC10_Pos)                    /*!< 0x00000400 */
#define CAN_FS1R_FSC10         CAN_FS1R_FSC10_Msk                              /*!<Filter Scale Configuration bit 10 */
#define CAN_FS1R_FSC11_Pos     (11U)                                           
#define CAN_FS1R_FSC11_Msk     (0x1U << CAN_FS1R_FSC11_Pos)                    /*!< 0x00000800 */
#define CAN_FS1R_FSC11         CAN_FS1R_FSC11_Msk                              /*!<Filter Scale Configuration bit 11 */
#define CAN_FS1R_FSC12_Pos     (12U)                                           
#define CAN_FS1R_FSC12_Msk     (0x1U << CAN_FS1R_FSC12_Pos)                    /*!< 0x00001000 */
#define CAN_FS1R_FSC12         CAN_FS1R_FSC12_Msk                              /*!<Filter Scale Configuration bit 12 */
#define CAN_FS1R_FSC13_Pos     (13U)                                           
#define CAN_FS1R_FSC13_Msk     (0x1U << CAN_FS1R_FSC13_Pos)                    /*!< 0x00002000 */
#define CAN_FS1R_FSC13         CAN_FS1R_FSC13_Msk                              /*!<Filter Scale Configuration bit 13 */

/******************  Bit definition for CAN_FFA1R register  *******************/
#define CAN_FFA1R_FFA_Pos      (0U)                                            
#define CAN_FFA1R_FFA_Msk      (0x3FFFU << CAN_FFA1R_FFA_Pos)                  /*!< 0x00003FFF */
#define CAN_FFA1R_FFA          CAN_FFA1R_FFA_Msk                               /*!<Filter FIFO Assignment */
#define CAN_FFA1R_FFA0_Pos     (0U)                                            
#define CAN_FFA1R_FFA0_Msk     (0x1U << CAN_FFA1R_FFA0_Pos)                    /*!< 0x00000001 */
#define CAN_FFA1R_FFA0         CAN_FFA1R_FFA0_Msk                              /*!<Filter FIFO Assignment for Filter 0 */
#define CAN_FFA1R_FFA1_Pos     (1U)                                            
#define CAN_FFA1R_FFA1_Msk     (0x1U << CAN_FFA1R_FFA1_Pos)                    /*!< 0x00000002 */
#define CAN_FFA1R_FFA1         CAN_FFA1R_FFA1_Msk                              /*!<Filter FIFO Assignment for Filter 1 */
#define CAN_FFA1R_FFA2_Pos     (2U)                                            
#define CAN_FFA1R_FFA2_Msk     (0x1U << CAN_FFA1R_FFA2_Pos)                    /*!< 0x00000004 */
#define CAN_FFA1R_FFA2         CAN_FFA1R_FFA2_Msk                              /*!<Filter FIFO Assignment for Filter 2 */
#define CAN_FFA1R_FFA3_Pos     (3U)                                            
#define CAN_FFA1R_FFA3_Msk     (0x1U << CAN_FFA1R_FFA3_Pos)                    /*!< 0x00000008 */
#define CAN_FFA1R_FFA3         CAN_FFA1R_FFA3_Msk                              /*!<Filter FIFO Assignment for Filter 3 */
#define CAN_FFA1R_FFA4_Pos     (4U)                                            
#define CAN_FFA1R_FFA4_Msk     (0x1U << CAN_FFA1R_FFA4_Pos)                    /*!< 0x00000010 */
#define CAN_FFA1R_FFA4         CAN_FFA1R_FFA4_Msk                              /*!<Filter FIFO Assignment for Filter 4 */
#define CAN_FFA1R_FFA5_Pos     (5U)                                            
#define CAN_FFA1R_FFA5_Msk     (0x1U << CAN_FFA1R_FFA5_Pos)                    /*!< 0x00000020 */
#define CAN_FFA1R_FFA5         CAN_FFA1R_FFA5_Msk                              /*!<Filter FIFO Assignment for Filter 5 */
#define CAN_FFA1R_FFA6_Pos     (6U)                                            
#define CAN_FFA1R_FFA6_Msk     (0x1U << CAN_FFA1R_FFA6_Pos)                    /*!< 0x00000040 */
#define CAN_FFA1R_FFA6         CAN_FFA1R_FFA6_Msk                              /*!<Filter FIFO Assignment for Filter 6 */
#define CAN_FFA1R_FFA7_Pos     (7U)                                            
#define CAN_FFA1R_FFA7_Msk     (0x1U << CAN_FFA1R_FFA7_Pos)                    /*!< 0x00000080 */
#define CAN_FFA1R_FFA7         CAN_FFA1R_FFA7_Msk                              /*!<Filter FIFO Assignment for Filter 7 */
#define CAN_FFA1R_FFA8_Pos     (8U)                                            
#define CAN_FFA1R_FFA8_Msk     (0x1U << CAN_FFA1R_FFA8_Pos)                    /*!< 0x00000100 */
#define CAN_FFA1R_FFA8         CAN_FFA1R_FFA8_Msk                              /*!<Filter FIFO Assignment for Filter 8 */
#define CAN_FFA1R_FFA9_Pos     (9U)                                            
#define CAN_FFA1R_FFA9_Msk     (0x1U << CAN_FFA1R_FFA9_Pos)                    /*!< 0x00000200 */
#define CAN_FFA1R_FFA9         CAN_FFA1R_FFA9_Msk                              /*!<Filter FIFO Assignment for Filter 9 */
#define CAN_FFA1R_FFA10_Pos    (10U)                                           
#define CAN_FFA1R_FFA10_Msk    (0x1U << CAN_FFA1R_FFA10_Pos)                   /*!< 0x00000400 */
#define CAN_FFA1R_FFA10        CAN_FFA1R_FFA10_Msk                             /*!<Filter FIFO Assignment for Filter 10 */
#define CAN_FFA1R_FFA11_Pos    (11U)                                           
#define CAN_FFA1R_FFA11_Msk    (0x1U << CAN_FFA1R_FFA11_Pos)                   /*!< 0x00000800 */
#define CAN_FFA1R_FFA11        CAN_FFA1R_FFA11_Msk                             /*!<Filter FIFO Assignment for Filter 11 */
#define CAN_FFA1R_FFA12_Pos    (12U)                                           
#define CAN_FFA1R_FFA12_Msk    (0x1U << CAN_FFA1R_FFA12_Pos)                   /*!< 0x00001000 */
#define CAN_FFA1R_FFA12        CAN_FFA1R_FFA12_Msk                             /*!<Filter FIFO Assignment for Filter 12 */
#define CAN_FFA1R_FFA13_Pos    (13U)                                           
#define CAN_FFA1R_FFA13_Msk    (0x1U << CAN_FFA1R_FFA13_Pos)                   /*!< 0x00002000 */
#define CAN_FFA1R_FFA13        CAN_FFA1R_FFA13_Msk                             /*!<Filter FIFO Assignment for Filter 13 */

/*******************  Bit definition for CAN_FA1R register  *******************/
#define CAN_FA1R_FACT_Pos      (0U)                                            
#define CAN_FA1R_FACT_Msk      (0x3FFFU << CAN_FA1R_FACT_Pos)                  /*!< 0x00003FFF */
#define CAN_FA1R_FACT          CAN_FA1R_FACT_Msk                               /*!<Filter Active */
#define CAN_FA1R_FACT0_Pos     (0U)                                            
#define CAN_FA1R_FACT0_Msk     (0x1U << CAN_FA1R_FACT0_Pos)                    /*!< 0x00000001 */
#define CAN_FA1R_FACT0         CAN_FA1R_FACT0_Msk                              /*!<Filter 0 Active */
#define CAN_FA1R_FACT1_Pos     (1U)                                            
#define CAN_FA1R_FACT1_Msk     (0x1U << CAN_FA1R_FACT1_Pos)                    /*!< 0x00000002 */
#define CAN_FA1R_FACT1         CAN_FA1R_FACT1_Msk                              /*!<Filter 1 Active */
#define CAN_FA1R_FACT2_Pos     (2U)                                            
#define CAN_FA1R_FACT2_Msk     (0x1U << CAN_FA1R_FACT2_Pos)                    /*!< 0x00000004 */
#define CAN_FA1R_FACT2         CAN_FA1R_FACT2_Msk                              /*!<Filter 2 Active */
#define CAN_FA1R_FACT3_Pos     (3U)                                            
#define CAN_FA1R_FACT3_Msk     (0x1U << CAN_FA1R_FACT3_Pos)                    /*!< 0x00000008 */
#define CAN_FA1R_FACT3         CAN_FA1R_FACT3_Msk                              /*!<Filter 3 Active */
#define CAN_FA1R_FACT4_Pos     (4U)                                            
#define CAN_FA1R_FACT4_Msk     (0x1U << CAN_FA1R_FACT4_Pos)                    /*!< 0x00000010 */
#define CAN_FA1R_FACT4         CAN_FA1R_FACT4_Msk                              /*!<Filter 4 Active */
#define CAN_FA1R_FACT5_Pos     (5U)                                            
#define CAN_FA1R_FACT5_Msk     (0x1U << CAN_FA1R_FACT5_Pos)                    /*!< 0x00000020 */
#define CAN_FA1R_FACT5         CAN_FA1R_FACT5_Msk                              /*!<Filter 5 Active */
#define CAN_FA1R_FACT6_Pos     (6U)                                            
#define CAN_FA1R_FACT6_Msk     (0x1U << CAN_FA1R_FACT6_Pos)                    /*!< 0x00000040 */
#define CAN_FA1R_FACT6         CAN_FA1R_FACT6_Msk                              /*!<Filter 6 Active */
#define CAN_FA1R_FACT7_Pos     (7U)                                            
#define CAN_FA1R_FACT7_Msk     (0x1U << CAN_FA1R_FACT7_Pos)                    /*!< 0x00000080 */
#define CAN_FA1R_FACT7         CAN_FA1R_FACT7_Msk                              /*!<Filter 7 Active */
#define CAN_FA1R_FACT8_Pos     (8U)                                            
#define CAN_FA1R_FACT8_Msk     (0x1U << CAN_FA1R_FACT8_Pos)                    /*!< 0x00000100 */
#define CAN_FA1R_FACT8         CAN_FA1R_FACT8_Msk                              /*!<Filter 8 Active */
#define CAN_FA1R_FACT9_Pos     (9U)                                            
#define CAN_FA1R_FACT9_Msk     (0x1U << CAN_FA1R_FACT9_Pos)                    /*!< 0x00000200 */
#define CAN_FA1R_FACT9         CAN_FA1R_FACT9_Msk                              /*!<Filter 9 Active */
#define CAN_FA1R_FACT10_Pos    (10U)                                           
#define CAN_FA1R_FACT10_Msk    (0x1U << CAN_FA1R_FACT10_Pos)                   /*!< 0x00000400 */
#define CAN_FA1R_FACT10        CAN_FA1R_FACT10_Msk                             /*!<Filter 10 Active */
#define CAN_FA1R_FACT11_Pos    (11U)                                           
#define CAN_FA1R_FACT11_Msk    (0x1U << CAN_FA1R_FACT11_Pos)                   /*!< 0x00000800 */
#define CAN_FA1R_FACT11        CAN_FA1R_FACT11_Msk                             /*!<Filter 11 Active */
#define CAN_FA1R_FACT12_Pos    (12U)                                           
#define CAN_FA1R_FACT12_Msk    (0x1U << CAN_FA1R_FACT12_Pos)                   /*!< 0x00001000 */
#define CAN_FA1R_FACT12        CAN_FA1R_FACT12_Msk                             /*!<Filter 12 Active */
#define CAN_FA1R_FACT13_Pos    (13U)                                           
#define CAN_FA1R_FACT13_Msk    (0x1U << CAN_FA1R_FACT13_Pos)                   /*!< 0x00002000 */
#define CAN_FA1R_FACT13        CAN_FA1R_FACT13_Msk                             /*!<Filter 13 Active */

/*******************  Bit definition for CAN_F0R1 register  *******************/
#define CAN_F0R1_FB0_Pos       (0U)                                            
#define CAN_F0R1_FB0_Msk       (0x1U << CAN_F0R1_FB0_Pos)                      /*!< 0x00000001 */
#define CAN_F0R1_FB0           CAN_F0R1_FB0_Msk                                /*!<Filter bit 0 */
#define CAN_F0R1_FB1_Pos       (1U)                                            
#define CAN_F0R1_FB1_Msk       (0x1U << CAN_F0R1_FB1_Pos)                      /*!< 0x00000002 */
#define CAN_F0R1_FB1           CAN_F0R1_FB1_Msk                                /*!<Filter bit 1 */
#define CAN_F0R1_FB2_Pos       (2U)                                            
#define CAN_F0R1_FB2_Msk       (0x1U << CAN_F0R1_FB2_Pos)                      /*!< 0x00000004 */
#define CAN_F0R1_FB2           CAN_F0R1_FB2_Msk                                /*!<Filter bit 2 */
#define CAN_F0R1_FB3_Pos       (3U)                                            
#define CAN_F0R1_FB3_Msk       (0x1U << CAN_F0R1_FB3_Pos)                      /*!< 0x00000008 */
#define CAN_F0R1_FB3           CAN_F0R1_FB3_Msk                                /*!<Filter bit 3 */
#define CAN_F0R1_FB4_Pos       (4U)                                            
#define CAN_F0R1_FB4_Msk       (0x1U << CAN_F0R1_FB4_Pos)                      /*!< 0x00000010 */
#define CAN_F0R1_FB4           CAN_F0R1_FB4_Msk                                /*!<Filter bit 4 */
#define CAN_F0R1_FB5_Pos       (5U)                                            
#define CAN_F0R1_FB5_Msk       (0x1U << CAN_F0R1_FB5_Pos)                      /*!< 0x00000020 */
#define CAN_F0R1_FB5           CAN_F0R1_FB5_Msk                                /*!<Filter bit 5 */
#define CAN_F0R1_FB6_Pos       (6U)                                            
#define CAN_F0R1_FB6_Msk       (0x1U << CAN_F0R1_FB6_Pos)                      /*!< 0x00000040 */
#define CAN_F0R1_FB6           CAN_F0R1_FB6_Msk                                /*!<Filter bit 6 */
#define CAN_F0R1_FB7_Pos       (7U)                                            
#define CAN_F0R1_FB7_Msk       (0x1U << CAN_F0R1_FB7_Pos)                      /*!< 0x00000080 */
#define CAN_F0R1_FB7           CAN_F0R1_FB7_Msk                                /*!<Filter bit 7 */
#define CAN_F0R1_FB8_Pos       (8U)                                            
#define CAN_F0R1_FB8_Msk       (0x1U << CAN_F0R1_FB8_Pos)                      /*!< 0x00000100 */
#define CAN_F0R1_FB8           CAN_F0R1_FB8_Msk                                /*!<Filter bit 8 */
#define CAN_F0R1_FB9_Pos       (9U)                                            
#define CAN_F0R1_FB9_Msk       (0x1U << CAN_F0R1_FB9_Pos)                      /*!< 0x00000200 */
#define CAN_F0R1_FB9           CAN_F0R1_FB9_Msk                                /*!<Filter bit 9 */
#define CAN_F0R1_FB10_Pos      (10U)                                           
#define CAN_F0R1_FB10_Msk      (0x1U << CAN_F0R1_FB10_Pos)                     /*!< 0x00000400 */
#define CAN_F0R1_FB10          CAN_F0R1_FB10_Msk                               /*!<Filter bit 10 */
#define CAN_F0R1_FB11_Pos      (11U)                                           
#define CAN_F0R1_FB11_Msk      (0x1U << CAN_F0R1_FB11_Pos)                     /*!< 0x00000800 */
#define CAN_F0R1_FB11          CAN_F0R1_FB11_Msk                               /*!<Filter bit 11 */
#define CAN_F0R1_FB12_Pos      (12U)                                           
#define CAN_F0R1_FB12_Msk      (0x1U << CAN_F0R1_FB12_Pos)                     /*!< 0x00001000 */
#define CAN_F0R1_FB12          CAN_F0R1_FB12_Msk                               /*!<Filter bit 12 */
#define CAN_F0R1_FB13_Pos      (13U)                                           
#define CAN_F0R1_FB13_Msk      (0x1U << CAN_F0R1_FB13_Pos)                     /*!< 0x00002000 */
#define CAN_F0R1_FB13          CAN_F0R1_FB13_Msk                               /*!<Filter bit 13 */
#define CAN_F0R1_FB14_Pos      (14U)                                           
#define CAN_F0R1_FB14_Msk      (0x1U << CAN_F0R1_FB14_Pos)                     /*!< 0x00004000 */
#define CAN_F0R1_FB14          CAN_F0R1_FB14_Msk                               /*!<Filter bit 14 */
#define CAN_F0R1_FB15_Pos      (15U)                                           
#define CAN_F0R1_FB15_Msk      (0x1U << CAN_F0R1_FB15_Pos)                     /*!< 0x00008000 */
#define CAN_F0R1_FB15          CAN_F0R1_FB15_Msk                               /*!<Filter bit 15 */
#define CAN_F0R1_FB16_Pos      (16U)                                           
#define CAN_F0R1_FB16_Msk      (0x1U << CAN_F0R1_FB16_Pos)                     /*!< 0x00010000 */
#define CAN_F0R1_FB16          CAN_F0R1_FB16_Msk                               /*!<Filter bit 16 */
#define CAN_F0R1_FB17_Pos      (17U)                                           
#define CAN_F0R1_FB17_Msk      (0x1U << CAN_F0R1_FB17_Pos)                     /*!< 0x00020000 */
#define CAN_F0R1_FB17          CAN_F0R1_FB17_Msk                               /*!<Filter bit 17 */
#define CAN_F0R1_FB18_Pos      (18U)                                           
#define CAN_F0R1_FB18_Msk      (0x1U << CAN_F0R1_FB18_Pos)                     /*!< 0x00040000 */
#define CAN_F0R1_FB18          CAN_F0R1_FB18_Msk                               /*!<Filter bit 18 */
#define CAN_F0R1_FB19_Pos      (19U)                                           
#define CAN_F0R1_FB19_Msk      (0x1U << CAN_F0R1_FB19_Pos)                     /*!< 0x00080000 */
#define CAN_F0R1_FB19          CAN_F0R1_FB19_Msk                               /*!<Filter bit 19 */
#define CAN_F0R1_FB20_Pos      (20U)                                           
#define CAN_F0R1_FB20_Msk      (0x1U << CAN_F0R1_FB20_Pos)                     /*!< 0x00100000 */
#define CAN_F0R1_FB20          CAN_F0R1_FB20_Msk                               /*!<Filter bit 20 */
#define CAN_F0R1_FB21_Pos      (21U)                                           
#define CAN_F0R1_FB21_Msk      (0x1U << CAN_F0R1_FB21_Pos)                     /*!< 0x00200000 */
#define CAN_F0R1_FB21          CAN_F0R1_FB21_Msk                               /*!<Filter bit 21 */
#define CAN_F0R1_FB22_Pos      (22U)                                           
#define CAN_F0R1_FB22_Msk      (0x1U << CAN_F0R1_FB22_Pos)                     /*!< 0x00400000 */
#define CAN_F0R1_FB22          CAN_F0R1_FB22_Msk                               /*!<Filter bit 22 */
#define CAN_F0R1_FB23_Pos      (23U)                                           
#define CAN_F0R1_FB23_Msk      (0x1U << CAN_F0R1_FB23_Pos)                     /*!< 0x00800000 */
#define CAN_F0R1_FB23          CAN_F0R1_FB23_Msk                               /*!<Filter bit 23 */
#define CAN_F0R1_FB24_Pos      (24U)                                           
#define CAN_F0R1_FB24_Msk      (0x1U << CAN_F0R1_FB24_Pos)                     /*!< 0x01000000 */
#define CAN_F0R1_FB24          CAN_F0R1_FB24_Msk                               /*!<Filter bit 24 */
#define CAN_F0R1_FB25_Pos      (25U)                                           
#define CAN_F0R1_FB25_Msk      (0x1U << CAN_F0R1_FB25_Pos)                     /*!< 0x02000000 */
#define CAN_F0R1_FB25          CAN_F0R1_FB25_Msk                               /*!<Filter bit 25 */
#define CAN_F0R1_FB26_Pos      (26U)                                           
#define CAN_F0R1_FB26_Msk      (0x1U << CAN_F0R1_FB26_Pos)                     /*!< 0x04000000 */
#define CAN_F0R1_FB26          CAN_F0R1_FB26_Msk                               /*!<Filter bit 26 */
#define CAN_F0R1_FB27_Pos      (27U)                                           
#define CAN_F0R1_FB27_Msk      (0x1U << CAN_F0R1_FB27_Pos)                     /*!< 0x08000000 */
#define CAN_F0R1_FB27          CAN_F0R1_FB27_Msk                               /*!<Filter bit 27 */
#define CAN_F0R1_FB28_Pos      (28U)                                           
#define CAN_F0R1_FB28_Msk      (0x1U << CAN_F0R1_FB28_Pos)                     /*!< 0x10000000 */
#define CAN_F0R1_FB28          CAN_F0R1_FB28_Msk                               /*!<Filter bit 28 */
#define CAN_F0R1_FB29_Pos      (29U)                                           
#define CAN_F0R1_FB29_Msk      (0x1U << CAN_F0R1_FB29_Pos)                     /*!< 0x20000000 */
#define CAN_F0R1_FB29          CAN_F0R1_FB29_Msk                               /*!<Filter bit 29 */
#define CAN_F0R1_FB30_Pos      (30U)                                           
#define CAN_F0R1_FB30_Msk      (0x1U << CAN_F0R1_FB30_Pos)                     /*!< 0x40000000 */
#define CAN_F0R1_FB30          CAN_F0R1_FB30_Msk                               /*!<Filter bit 30 */
#define CAN_F0R1_FB31_Pos      (31U)                                           
#define CAN_F0R1_FB31_Msk      (0x1U << CAN_F0R1_FB31_Pos)                     /*!< 0x80000000 */
#define CAN_F0R1_FB31          CAN_F0R1_FB31_Msk                               /*!<Filter bit 31 */

/*******************  Bit definition for CAN_F1R1 register  *******************/
#define CAN_F1R1_FB0_Pos       (0U)                                            
#define CAN_F1R1_FB0_Msk       (0x1U << CAN_F1R1_FB0_Pos)                      /*!< 0x00000001 */
#define CAN_F1R1_FB0           CAN_F1R1_FB0_Msk                                /*!<Filter bit 0 */
#define CAN_F1R1_FB1_Pos       (1U)                                            
#define CAN_F1R1_FB1_Msk       (0x1U << CAN_F1R1_FB1_Pos)                      /*!< 0x00000002 */
#define CAN_F1R1_FB1           CAN_F1R1_FB1_Msk                                /*!<Filter bit 1 */
#define CAN_F1R1_FB2_Pos       (2U)                                            
#define CAN_F1R1_FB2_Msk       (0x1U << CAN_F1R1_FB2_Pos)                      /*!< 0x00000004 */
#define CAN_F1R1_FB2           CAN_F1R1_FB2_Msk                                /*!<Filter bit 2 */
#define CAN_F1R1_FB3_Pos       (3U)                                            
#define CAN_F1R1_FB3_Msk       (0x1U << CAN_F1R1_FB3_Pos)                      /*!< 0x00000008 */
#define CAN_F1R1_FB3           CAN_F1R1_FB3_Msk                                /*!<Filter bit 3 */
#define CAN_F1R1_FB4_Pos       (4U)                                            
#define CAN_F1R1_FB4_Msk       (0x1U << CAN_F1R1_FB4_Pos)                      /*!< 0x00000010 */
#define CAN_F1R1_FB4           CAN_F1R1_FB4_Msk                                /*!<Filter bit 4 */
#define CAN_F1R1_FB5_Pos       (5U)                                            
#define CAN_F1R1_FB5_Msk       (0x1U << CAN_F1R1_FB5_Pos)                      /*!< 0x00000020 */
#define CAN_F1R1_FB5           CAN_F1R1_FB5_Msk                                /*!<Filter bit 5 */
#define CAN_F1R1_FB6_Pos       (6U)                                            
#define CAN_F1R1_FB6_Msk       (0x1U << CAN_F1R1_FB6_Pos)                      /*!< 0x00000040 */
#define CAN_F1R1_FB6           CAN_F1R1_FB6_Msk                                /*!<Filter bit 6 */
#define CAN_F1R1_FB7_Pos       (7U)                                            
#define CAN_F1R1_FB7_Msk       (0x1U << CAN_F1R1_FB7_Pos)                      /*!< 0x00000080 */
#define CAN_F1R1_FB7           CAN_F1R1_FB7_Msk                                /*!<Filter bit 7 */
#define CAN_F1R1_FB8_Pos       (8U)                                            
#define CAN_F1R1_FB8_Msk       (0x1U << CAN_F1R1_FB8_Pos)                      /*!< 0x00000100 */
#define CAN_F1R1_FB8           CAN_F1R1_FB8_Msk                                /*!<Filter bit 8 */
#define CAN_F1R1_FB9_Pos       (9U)                                            
#define CAN_F1R1_FB9_Msk       (0x1U << CAN_F1R1_FB9_Pos)                      /*!< 0x00000200 */
#define CAN_F1R1_FB9           CAN_F1R1_FB9_Msk                                /*!<Filter bit 9 */
#define CAN_F1R1_FB10_Pos      (10U)                                           
#define CAN_F1R1_FB10_Msk      (0x1U << CAN_F1R1_FB10_Pos)                     /*!< 0x00000400 */
#define CAN_F1R1_FB10          CAN_F1R1_FB10_Msk                               /*!<Filter bit 10 */
#define CAN_F1R1_FB11_Pos      (11U)                                           
#define CAN_F1R1_FB11_Msk      (0x1U << CAN_F1R1_FB11_Pos)                     /*!< 0x00000800 */
#define CAN_F1R1_FB11          CAN_F1R1_FB11_Msk                               /*!<Filter bit 11 */
#define CAN_F1R1_FB12_Pos      (12U)                                           
#define CAN_F1R1_FB12_Msk      (0x1U << CAN_F1R1_FB12_Pos)                     /*!< 0x00001000 */
#define CAN_F1R1_FB12          CAN_F1R1_FB12_Msk                               /*!<Filter bit 12 */
#define CAN_F1R1_FB13_Pos      (13U)                                           
#define CAN_F1R1_FB13_Msk      (0x1U << CAN_F1R1_FB13_Pos)                     /*!< 0x00002000 */
#define CAN_F1R1_FB13          CAN_F1R1_FB13_Msk                               /*!<Filter bit 13 */
#define CAN_F1R1_FB14_Pos      (14U)                                           
#define CAN_F1R1_FB14_Msk      (0x1U << CAN_F1R1_FB14_Pos)                     /*!< 0x00004000 */
#define CAN_F1R1_FB14          CAN_F1R1_FB14_Msk                               /*!<Filter bit 14 */
#define CAN_F1R1_FB15_Pos      (15U)                                           
#define CAN_F1R1_FB15_Msk      (0x1U << CAN_F1R1_FB15_Pos)                     /*!< 0x00008000 */
#define CAN_F1R1_FB15          CAN_F1R1_FB15_Msk                               /*!<Filter bit 15 */
#define CAN_F1R1_FB16_Pos      (16U)                                           
#define CAN_F1R1_FB16_Msk      (0x1U << CAN_F1R1_FB16_Pos)                     /*!< 0x00010000 */
#define CAN_F1R1_FB16          CAN_F1R1_FB16_Msk                               /*!<Filter bit 16 */
#define CAN_F1R1_FB17_Pos      (17U)                                           
#define CAN_F1R1_FB17_Msk      (0x1U << CAN_F1R1_FB17_Pos)                     /*!< 0x00020000 */
#define CAN_F1R1_FB17          CAN_F1R1_FB17_Msk                               /*!<Filter bit 17 */
#define CAN_F1R1_FB18_Pos      (18U)                                           
#define CAN_F1R1_FB18_Msk      (0x1U << CAN_F1R1_FB18_Pos)                     /*!< 0x00040000 */
#define CAN_F1R1_FB18          CAN_F1R1_FB18_Msk                               /*!<Filter bit 18 */
#define CAN_F1R1_FB19_Pos      (19U)                                           
#define CAN_F1R1_FB19_Msk      (0x1U << CAN_F1R1_FB19_Pos)                     /*!< 0x00080000 */
#define CAN_F1R1_FB19          CAN_F1R1_FB19_Msk                               /*!<Filter bit 19 */
#define CAN_F1R1_FB20_Pos      (20U)                                           
#define CAN_F1R1_FB20_Msk      (0x1U << CAN_F1R1_FB20_Pos)                     /*!< 0x00100000 */
#define CAN_F1R1_FB20          CAN_F1R1_FB20_Msk                               /*!<Filter bit 20 */
#define CAN_F1R1_FB21_Pos      (21U)                                           
#define CAN_F1R1_FB21_Msk      (0x1U << CAN_F1R1_FB21_Pos)                     /*!< 0x00200000 */
#define CAN_F1R1_FB21          CAN_F1R1_FB21_Msk                               /*!<Filter bit 21 */
#define CAN_F1R1_FB22_Pos      (22U)                                           
#define CAN_F1R1_FB22_Msk      (0x1U << CAN_F1R1_FB22_Pos)                     /*!< 0x00400000 */
#define CAN_F1R1_FB22          CAN_F1R1_FB22_Msk                               /*!<Filter bit 22 */
#define CAN_F1R1_FB23_Pos      (23U)                                           
#define CAN_F1R1_FB23_Msk      (0x1U << CAN_F1R1_FB23_Pos)                     /*!< 0x00800000 */
#define CAN_F1R1_FB23          CAN_F1R1_FB23_Msk                               /*!<Filter bit 23 */
#define CAN_F1R1_FB24_Pos      (24U)                                           
#define CAN_F1R1_FB24_Msk      (0x1U << CAN_F1R1_FB24_Pos)                     /*!< 0x01000000 */
#define CAN_F1R1_FB24          CAN_F1R1_FB24_Msk                               /*!<Filter bit 24 */
#define CAN_F1R1_FB25_Pos      (25U)                                           
#define CAN_F1R1_FB25_Msk      (0x1U << CAN_F1R1_FB25_Pos)                     /*!< 0x02000000 */
#define CAN_F1R1_FB25          CAN_F1R1_FB25_Msk                               /*!<Filter bit 25 */
#define CAN_F1R1_FB26_Pos      (26U)                                           
#define CAN_F1R1_FB26_Msk      (0x1U << CAN_F1R1_FB26_Pos)                     /*!< 0x04000000 */
#define CAN_F1R1_FB26          CAN_F1R1_FB26_Msk                               /*!<Filter bit 26 */
#define CAN_F1R1_FB27_Pos      (27U)                                           
#define CAN_F1R1_FB27_Msk      (0x1U << CAN_F1R1_FB27_Pos)                     /*!< 0x08000000 */
#define CAN_F1R1_FB27          CAN_F1R1_FB27_Msk                               /*!<Filter bit 27 */
#define CAN_F1R1_FB28_Pos      (28U)                                           
#define CAN_F1R1_FB28_Msk      (0x1U << CAN_F1R1_FB28_Pos)                     /*!< 0x10000000 */
#define CAN_F1R1_FB28          CAN_F1R1_FB28_Msk                               /*!<Filter bit 28 */
#define CAN_F1R1_FB29_Pos      (29U)                                           
#define CAN_F1R1_FB29_Msk      (0x1U << CAN_F1R1_FB29_Pos)                     /*!< 0x20000000 */
#define CAN_F1R1_FB29          CAN_F1R1_FB29_Msk                               /*!<Filter bit 29 */
#define CAN_F1R1_FB30_Pos      (30U)                                           
#define CAN_F1R1_FB30_Msk      (0x1U << CAN_F1R1_FB30_Pos)                     /*!< 0x40000000 */
#define CAN_F1R1_FB30          CAN_F1R1_FB30_Msk                               /*!<Filter bit 30 */
#define CAN_F1R1_FB31_Pos      (31U)                                           
#define CAN_F1R1_FB31_Msk      (0x1U << CAN_F1R1_FB31_Pos)                     /*!< 0x80000000 */
#define CAN_F1R1_FB31          CAN_F1R1_FB31_Msk                               /*!<Filter bit 31 */

/*******************  Bit definition for CAN_F2R1 register  *******************/
#define CAN_F2R1_FB0_Pos       (0U)                                            
#define CAN_F2R1_FB0_Msk       (0x1U << CAN_F2R1_FB0_Pos)                      /*!< 0x00000001 */
#define CAN_F2R1_FB0           CAN_F2R1_FB0_Msk                                /*!<Filter bit 0 */
#define CAN_F2R1_FB1_Pos       (1U)                                            
#define CAN_F2R1_FB1_Msk       (0x1U << CAN_F2R1_FB1_Pos)                      /*!< 0x00000002 */
#define CAN_F2R1_FB1           CAN_F2R1_FB1_Msk                                /*!<Filter bit 1 */
#define CAN_F2R1_FB2_Pos       (2U)                                            
#define CAN_F2R1_FB2_Msk       (0x1U << CAN_F2R1_FB2_Pos)                      /*!< 0x00000004 */
#define CAN_F2R1_FB2           CAN_F2R1_FB2_Msk                                /*!<Filter bit 2 */
#define CAN_F2R1_FB3_Pos       (3U)                                            
#define CAN_F2R1_FB3_Msk       (0x1U << CAN_F2R1_FB3_Pos)                      /*!< 0x00000008 */
#define CAN_F2R1_FB3           CAN_F2R1_FB3_Msk                                /*!<Filter bit 3 */
#define CAN_F2R1_FB4_Pos       (4U)                                            
#define CAN_F2R1_FB4_Msk       (0x1U << CAN_F2R1_FB4_Pos)                      /*!< 0x00000010 */
#define CAN_F2R1_FB4           CAN_F2R1_FB4_Msk                                /*!<Filter bit 4 */
#define CAN_F2R1_FB5_Pos       (5U)                                            
#define CAN_F2R1_FB5_Msk       (0x1U << CAN_F2R1_FB5_Pos)                      /*!< 0x00000020 */
#define CAN_F2R1_FB5           CAN_F2R1_FB5_Msk                                /*!<Filter bit 5 */
#define CAN_F2R1_FB6_Pos       (6U)                                            
#define CAN_F2R1_FB6_Msk       (0x1U << CAN_F2R1_FB6_Pos)                      /*!< 0x00000040 */
#define CAN_F2R1_FB6           CAN_F2R1_FB6_Msk                                /*!<Filter bit 6 */
#define CAN_F2R1_FB7_Pos       (7U)                                            
#define CAN_F2R1_FB7_Msk       (0x1U << CAN_F2R1_FB7_Pos)                      /*!< 0x00000080 */
#define CAN_F2R1_FB7           CAN_F2R1_FB7_Msk                                /*!<Filter bit 7 */
#define CAN_F2R1_FB8_Pos       (8U)                                            
#define CAN_F2R1_FB8_Msk       (0x1U << CAN_F2R1_FB8_Pos)                      /*!< 0x00000100 */
#define CAN_F2R1_FB8           CAN_F2R1_FB8_Msk                                /*!<Filter bit 8 */
#define CAN_F2R1_FB9_Pos       (9U)                                            
#define CAN_F2R1_FB9_Msk       (0x1U << CAN_F2R1_FB9_Pos)                      /*!< 0x00000200 */
#define CAN_F2R1_FB9           CAN_F2R1_FB9_Msk                                /*!<Filter bit 9 */
#define CAN_F2R1_FB10_Pos      (10U)                                           
#define CAN_F2R1_FB10_Msk      (0x1U << CAN_F2R1_FB10_Pos)                     /*!< 0x00000400 */
#define CAN_F2R1_FB10          CAN_F2R1_FB10_Msk                               /*!<Filter bit 10 */
#define CAN_F2R1_FB11_Pos      (11U)                                           
#define CAN_F2R1_FB11_Msk      (0x1U << CAN_F2R1_FB11_Pos)                     /*!< 0x00000800 */
#define CAN_F2R1_FB11          CAN_F2R1_FB11_Msk                               /*!<Filter bit 11 */
#define CAN_F2R1_FB12_Pos      (12U)                                           
#define CAN_F2R1_FB12_Msk      (0x1U << CAN_F2R1_FB12_Pos)                     /*!< 0x00001000 */
#define CAN_F2R1_FB12          CAN_F2R1_FB12_Msk                               /*!<Filter bit 12 */
#define CAN_F2R1_FB13_Pos      (13U)                                           
#define CAN_F2R1_FB13_Msk      (0x1U << CAN_F2R1_FB13_Pos)                     /*!< 0x00002000 */
#define CAN_F2R1_FB13          CAN_F2R1_FB13_Msk                               /*!<Filter bit 13 */
#define CAN_F2R1_FB14_Pos      (14U)                                           
#define CAN_F2R1_FB14_Msk      (0x1U << CAN_F2R1_FB14_Pos)                     /*!< 0x00004000 */
#define CAN_F2R1_FB14          CAN_F2R1_FB14_Msk                               /*!<Filter bit 14 */
#define CAN_F2R1_FB15_Pos      (15U)                                           
#define CAN_F2R1_FB15_Msk      (0x1U << CAN_F2R1_FB15_Pos)                     /*!< 0x00008000 */
#define CAN_F2R1_FB15          CAN_F2R1_FB15_Msk                               /*!<Filter bit 15 */
#define CAN_F2R1_FB16_Pos      (16U)                                           
#define CAN_F2R1_FB16_Msk      (0x1U << CAN_F2R1_FB16_Pos)                     /*!< 0x00010000 */
#define CAN_F2R1_FB16          CAN_F2R1_FB16_Msk                               /*!<Filter bit 16 */
#define CAN_F2R1_FB17_Pos      (17U)                                           
#define CAN_F2R1_FB17_Msk      (0x1U << CAN_F2R1_FB17_Pos)                     /*!< 0x00020000 */
#define CAN_F2R1_FB17          CAN_F2R1_FB17_Msk                               /*!<Filter bit 17 */
#define CAN_F2R1_FB18_Pos      (18U)                                           
#define CAN_F2R1_FB18_Msk      (0x1U << CAN_F2R1_FB18_Pos)                     /*!< 0x00040000 */
#define CAN_F2R1_FB18          CAN_F2R1_FB18_Msk                               /*!<Filter bit 18 */
#define CAN_F2R1_FB19_Pos      (19U)                                           
#define CAN_F2R1_FB19_Msk      (0x1U << CAN_F2R1_FB19_Pos)                     /*!< 0x00080000 */
#define CAN_F2R1_FB19          CAN_F2R1_FB19_Msk                               /*!<Filter bit 19 */
#define CAN_F2R1_FB20_Pos      (20U)                                           
#define CAN_F2R1_FB20_Msk      (0x1U << CAN_F2R1_FB20_Pos)                     /*!< 0x00100000 */
#define CAN_F2R1_FB20          CAN_F2R1_FB20_Msk                               /*!<Filter bit 20 */
#define CAN_F2R1_FB21_Pos      (21U)                                           
#define CAN_F2R1_FB21_Msk      (0x1U << CAN_F2R1_FB21_Pos)                     /*!< 0x00200000 */
#define CAN_F2R1_FB21          CAN_F2R1_FB21_Msk                               /*!<Filter bit 21 */
#define CAN_F2R1_FB22_Pos      (22U)                                           
#define CAN_F2R1_FB22_Msk      (0x1U << CAN_F2R1_FB22_Pos)                     /*!< 0x00400000 */
#define CAN_F2R1_FB22          CAN_F2R1_FB22_Msk                               /*!<Filter bit 22 */
#define CAN_F2R1_FB23_Pos      (23U)                                           
#define CAN_F2R1_FB23_Msk      (0x1U << CAN_F2R1_FB23_Pos)                     /*!< 0x00800000 */
#define CAN_F2R1_FB23          CAN_F2R1_FB23_Msk                               /*!<Filter bit 23 */
#define CAN_F2R1_FB24_Pos      (24U)                                           
#define CAN_F2R1_FB24_Msk      (0x1U << CAN_F2R1_FB24_Pos)                     /*!< 0x01000000 */
#define CAN_F2R1_FB24          CAN_F2R1_FB24_Msk                               /*!<Filter bit 24 */
#define CAN_F2R1_FB25_Pos      (25U)                                           
#define CAN_F2R1_FB25_Msk      (0x1U << CAN_F2R1_FB25_Pos)                     /*!< 0x02000000 */
#define CAN_F2R1_FB25          CAN_F2R1_FB25_Msk                               /*!<Filter bit 25 */
#define CAN_F2R1_FB26_Pos      (26U)                                           
#define CAN_F2R1_FB26_Msk      (0x1U << CAN_F2R1_FB26_Pos)                     /*!< 0x04000000 */
#define CAN_F2R1_FB26          CAN_F2R1_FB26_Msk                               /*!<Filter bit 26 */
#define CAN_F2R1_FB27_Pos      (27U)                                           
#define CAN_F2R1_FB27_Msk      (0x1U << CAN_F2R1_FB27_Pos)                     /*!< 0x08000000 */
#define CAN_F2R1_FB27          CAN_F2R1_FB27_Msk                               /*!<Filter bit 27 */
#define CAN_F2R1_FB28_Pos      (28U)                                           
#define CAN_F2R1_FB28_Msk      (0x1U << CAN_F2R1_FB28_Pos)                     /*!< 0x10000000 */
#define CAN_F2R1_FB28          CAN_F2R1_FB28_Msk                               /*!<Filter bit 28 */
#define CAN_F2R1_FB29_Pos      (29U)                                           
#define CAN_F2R1_FB29_Msk      (0x1U << CAN_F2R1_FB29_Pos)                     /*!< 0x20000000 */
#define CAN_F2R1_FB29          CAN_F2R1_FB29_Msk                               /*!<Filter bit 29 */
#define CAN_F2R1_FB30_Pos      (30U)                                           
#define CAN_F2R1_FB30_Msk      (0x1U << CAN_F2R1_FB30_Pos)                     /*!< 0x40000000 */
#define CAN_F2R1_FB30          CAN_F2R1_FB30_Msk                               /*!<Filter bit 30 */
#define CAN_F2R1_FB31_Pos      (31U)                                           
#define CAN_F2R1_FB31_Msk      (0x1U << CAN_F2R1_FB31_Pos)                     /*!< 0x80000000 */
#define CAN_F2R1_FB31          CAN_F2R1_FB31_Msk                               /*!<Filter bit 31 */

/*******************  Bit definition for CAN_F3R1 register  *******************/
#define CAN_F3R1_FB0_Pos       (0U)                                            
#define CAN_F3R1_FB0_Msk       (0x1U << CAN_F3R1_FB0_Pos)                      /*!< 0x00000001 */
#define CAN_F3R1_FB0           CAN_F3R1_FB0_Msk                                /*!<Filter bit 0 */
#define CAN_F3R1_FB1_Pos       (1U)                                            
#define CAN_F3R1_FB1_Msk       (0x1U << CAN_F3R1_FB1_Pos)                      /*!< 0x00000002 */
#define CAN_F3R1_FB1           CAN_F3R1_FB1_Msk                                /*!<Filter bit 1 */
#define CAN_F3R1_FB2_Pos       (2U)                                            
#define CAN_F3R1_FB2_Msk       (0x1U << CAN_F3R1_FB2_Pos)                      /*!< 0x00000004 */
#define CAN_F3R1_FB2           CAN_F3R1_FB2_Msk                                /*!<Filter bit 2 */
#define CAN_F3R1_FB3_Pos       (3U)                                            
#define CAN_F3R1_FB3_Msk       (0x1U << CAN_F3R1_FB3_Pos)                      /*!< 0x00000008 */
#define CAN_F3R1_FB3           CAN_F3R1_FB3_Msk                                /*!<Filter bit 3 */
#define CAN_F3R1_FB4_Pos       (4U)                                            
#define CAN_F3R1_FB4_Msk       (0x1U << CAN_F3R1_FB4_Pos)                      /*!< 0x00000010 */
#define CAN_F3R1_FB4           CAN_F3R1_FB4_Msk                                /*!<Filter bit 4 */
#define CAN_F3R1_FB5_Pos       (5U)                                            
#define CAN_F3R1_FB5_Msk       (0x1U << CAN_F3R1_FB5_Pos)                      /*!< 0x00000020 */
#define CAN_F3R1_FB5           CAN_F3R1_FB5_Msk                                /*!<Filter bit 5 */
#define CAN_F3R1_FB6_Pos       (6U)                                            
#define CAN_F3R1_FB6_Msk       (0x1U << CAN_F3R1_FB6_Pos)                      /*!< 0x00000040 */
#define CAN_F3R1_FB6           CAN_F3R1_FB6_Msk                                /*!<Filter bit 6 */
#define CAN_F3R1_FB7_Pos       (7U)                                            
#define CAN_F3R1_FB7_Msk       (0x1U << CAN_F3R1_FB7_Pos)                      /*!< 0x00000080 */
#define CAN_F3R1_FB7           CAN_F3R1_FB7_Msk                                /*!<Filter bit 7 */
#define CAN_F3R1_FB8_Pos       (8U)                                            
#define CAN_F3R1_FB8_Msk       (0x1U << CAN_F3R1_FB8_Pos)                      /*!< 0x00000100 */
#define CAN_F3R1_FB8           CAN_F3R1_FB8_Msk                                /*!<Filter bit 8 */
#define CAN_F3R1_FB9_Pos       (9U)                                            
#define CAN_F3R1_FB9_Msk       (0x1U << CAN_F3R1_FB9_Pos)                      /*!< 0x00000200 */
#define CAN_F3R1_FB9           CAN_F3R1_FB9_Msk                                /*!<Filter bit 9 */
#define CAN_F3R1_FB10_Pos      (10U)                                           
#define CAN_F3R1_FB10_Msk      (0x1U << CAN_F3R1_FB10_Pos)                     /*!< 0x00000400 */
#define CAN_F3R1_FB10          CAN_F3R1_FB10_Msk                               /*!<Filter bit 10 */
#define CAN_F3R1_FB11_Pos      (11U)                                           
#define CAN_F3R1_FB11_Msk      (0x1U << CAN_F3R1_FB11_Pos)                     /*!< 0x00000800 */
#define CAN_F3R1_FB11          CAN_F3R1_FB11_Msk                               /*!<Filter bit 11 */
#define CAN_F3R1_FB12_Pos      (12U)                                           
#define CAN_F3R1_FB12_Msk      (0x1U << CAN_F3R1_FB12_Pos)                     /*!< 0x00001000 */
#define CAN_F3R1_FB12          CAN_F3R1_FB12_Msk                               /*!<Filter bit 12 */
#define CAN_F3R1_FB13_Pos      (13U)                                           
#define CAN_F3R1_FB13_Msk      (0x1U << CAN_F3R1_FB13_Pos)                     /*!< 0x00002000 */
#define CAN_F3R1_FB13          CAN_F3R1_FB13_Msk                               /*!<Filter bit 13 */
#define CAN_F3R1_FB14_Pos      (14U)                                           
#define CAN_F3R1_FB14_Msk      (0x1U << CAN_F3R1_FB14_Pos)                     /*!< 0x00004000 */
#define CAN_F3R1_FB14          CAN_F3R1_FB14_Msk                               /*!<Filter bit 14 */
#define CAN_F3R1_FB15_Pos      (15U)                                           
#define CAN_F3R1_FB15_Msk      (0x1U << CAN_F3R1_FB15_Pos)                     /*!< 0x00008000 */
#define CAN_F3R1_FB15          CAN_F3R1_FB15_Msk                               /*!<Filter bit 15 */
#define CAN_F3R1_FB16_Pos      (16U)                                           
#define CAN_F3R1_FB16_Msk      (0x1U << CAN_F3R1_FB16_Pos)                     /*!< 0x00010000 */
#define CAN_F3R1_FB16          CAN_F3R1_FB16_Msk                               /*!<Filter bit 16 */
#define CAN_F3R1_FB17_Pos      (17U)                                           
#define CAN_F3R1_FB17_Msk      (0x1U << CAN_F3R1_FB17_Pos)                     /*!< 0x00020000 */
#define CAN_F3R1_FB17          CAN_F3R1_FB17_Msk                               /*!<Filter bit 17 */
#define CAN_F3R1_FB18_Pos      (18U)                                           
#define CAN_F3R1_FB18_Msk      (0x1U << CAN_F3R1_FB18_Pos)                     /*!< 0x00040000 */
#define CAN_F3R1_FB18          CAN_F3R1_FB18_Msk                               /*!<Filter bit 18 */
#define CAN_F3R1_FB19_Pos      (19U)                                           
#define CAN_F3R1_FB19_Msk      (0x1U << CAN_F3R1_FB19_Pos)                     /*!< 0x00080000 */
#define CAN_F3R1_FB19          CAN_F3R1_FB19_Msk                               /*!<Filter bit 19 */
#define CAN_F3R1_FB20_Pos      (20U)                                           
#define CAN_F3R1_FB20_Msk      (0x1U << CAN_F3R1_FB20_Pos)                     /*!< 0x00100000 */
#define CAN_F3R1_FB20          CAN_F3R1_FB20_Msk                               /*!<Filter bit 20 */
#define CAN_F3R1_FB21_Pos      (21U)                                           
#define CAN_F3R1_FB21_Msk      (0x1U << CAN_F3R1_FB21_Pos)                     /*!< 0x00200000 */
#define CAN_F3R1_FB21          CAN_F3R1_FB21_Msk                               /*!<Filter bit 21 */
#define CAN_F3R1_FB22_Pos      (22U)                                           
#define CAN_F3R1_FB22_Msk      (0x1U << CAN_F3R1_FB22_Pos)                     /*!< 0x00400000 */
#define CAN_F3R1_FB22          CAN_F3R1_FB22_Msk                               /*!<Filter bit 22 */
#define CAN_F3R1_FB23_Pos      (23U)                                           
#define CAN_F3R1_FB23_Msk      (0x1U << CAN_F3R1_FB23_Pos)                     /*!< 0x00800000 */
#define CAN_F3R1_FB23          CAN_F3R1_FB23_Msk                               /*!<Filter bit 23 */
#define CAN_F3R1_FB24_Pos      (24U)                                           
#define CAN_F3R1_FB24_Msk      (0x1U << CAN_F3R1_FB24_Pos)                     /*!< 0x01000000 */
#define CAN_F3R1_FB24          CAN_F3R1_FB24_Msk                               /*!<Filter bit 24 */
#define CAN_F3R1_FB25_Pos      (25U)                                           
#define CAN_F3R1_FB25_Msk      (0x1U << CAN_F3R1_FB25_Pos)                     /*!< 0x02000000 */
#define CAN_F3R1_FB25          CAN_F3R1_FB25_Msk                               /*!<Filter bit 25 */
#define CAN_F3R1_FB26_Pos      (26U)                                           
#define CAN_F3R1_FB26_Msk      (0x1U << CAN_F3R1_FB26_Pos)                     /*!< 0x04000000 */
#define CAN_F3R1_FB26          CAN_F3R1_FB26_Msk                               /*!<Filter bit 26 */
#define CAN_F3R1_FB27_Pos      (27U)                                           
#define CAN_F3R1_FB27_Msk      (0x1U << CAN_F3R1_FB27_Pos)                     /*!< 0x08000000 */
#define CAN_F3R1_FB27          CAN_F3R1_FB27_Msk                               /*!<Filter bit 27 */
#define CAN_F3R1_FB28_Pos      (28U)                                           
#define CAN_F3R1_FB28_Msk      (0x1U << CAN_F3R1_FB28_Pos)                     /*!< 0x10000000 */
#define CAN_F3R1_FB28          CAN_F3R1_FB28_Msk                               /*!<Filter bit 28 */
#define CAN_F3R1_FB29_Pos      (29U)                                           
#define CAN_F3R1_FB29_Msk      (0x1U << CAN_F3R1_FB29_Pos)                     /*!< 0x20000000 */
#define CAN_F3R1_FB29          CAN_F3R1_FB29_Msk                               /*!<Filter bit 29 */
#define CAN_F3R1_FB30_Pos      (30U)                                           
#define CAN_F3R1_FB30_Msk      (0x1U << CAN_F3R1_FB30_Pos)                     /*!< 0x40000000 */
#define CAN_F3R1_FB30          CAN_F3R1_FB30_Msk                               /*!<Filter bit 30 */
#define CAN_F3R1_FB31_Pos      (31U)                                           
#define CAN_F3R1_FB31_Msk      (0x1U << CAN_F3R1_FB31_Pos)                     /*!< 0x80000000 */
#define CAN_F3R1_FB31          CAN_F3R1_FB31_Msk                               /*!<Filter bit 31 */

/*******************  Bit definition for CAN_F4R1 register  *******************/
#define CAN_F4R1_FB0_Pos       (0U)                                            
#define CAN_F4R1_FB0_Msk       (0x1U << CAN_F4R1_FB0_Pos)                      /*!< 0x00000001 */
#define CAN_F4R1_FB0           CAN_F4R1_FB0_Msk                                /*!<Filter bit 0 */
#define CAN_F4R1_FB1_Pos       (1U)                                            
#define CAN_F4R1_FB1_Msk       (0x1U << CAN_F4R1_FB1_Pos)                      /*!< 0x00000002 */
#define CAN_F4R1_FB1           CAN_F4R1_FB1_Msk                                /*!<Filter bit 1 */
#define CAN_F4R1_FB2_Pos       (2U)                                            
#define CAN_F4R1_FB2_Msk       (0x1U << CAN_F4R1_FB2_Pos)                      /*!< 0x00000004 */
#define CAN_F4R1_FB2           CAN_F4R1_FB2_Msk                                /*!<Filter bit 2 */
#define CAN_F4R1_FB3_Pos       (3U)                                            
#define CAN_F4R1_FB3_Msk       (0x1U << CAN_F4R1_FB3_Pos)                      /*!< 0x00000008 */
#define CAN_F4R1_FB3           CAN_F4R1_FB3_Msk                                /*!<Filter bit 3 */
#define CAN_F4R1_FB4_Pos       (4U)                                            
#define CAN_F4R1_FB4_Msk       (0x1U << CAN_F4R1_FB4_Pos)                      /*!< 0x00000010 */
#define CAN_F4R1_FB4           CAN_F4R1_FB4_Msk                                /*!<Filter bit 4 */
#define CAN_F4R1_FB5_Pos       (5U)                                            
#define CAN_F4R1_FB5_Msk       (0x1U << CAN_F4R1_FB5_Pos)                      /*!< 0x00000020 */
#define CAN_F4R1_FB5           CAN_F4R1_FB5_Msk                                /*!<Filter bit 5 */
#define CAN_F4R1_FB6_Pos       (6U)                                            
#define CAN_F4R1_FB6_Msk       (0x1U << CAN_F4R1_FB6_Pos)                      /*!< 0x00000040 */
#define CAN_F4R1_FB6           CAN_F4R1_FB6_Msk                                /*!<Filter bit 6 */
#define CAN_F4R1_FB7_Pos       (7U)                                            
#define CAN_F4R1_FB7_Msk       (0x1U << CAN_F4R1_FB7_Pos)                      /*!< 0x00000080 */
#define CAN_F4R1_FB7           CAN_F4R1_FB7_Msk                                /*!<Filter bit 7 */
#define CAN_F4R1_FB8_Pos       (8U)                                            
#define CAN_F4R1_FB8_Msk       (0x1U << CAN_F4R1_FB8_Pos)                      /*!< 0x00000100 */
#define CAN_F4R1_FB8           CAN_F4R1_FB8_Msk                                /*!<Filter bit 8 */
#define CAN_F4R1_FB9_Pos       (9U)                                            
#define CAN_F4R1_FB9_Msk       (0x1U << CAN_F4R1_FB9_Pos)                      /*!< 0x00000200 */
#define CAN_F4R1_FB9           CAN_F4R1_FB9_Msk                                /*!<Filter bit 9 */
#define CAN_F4R1_FB10_Pos      (10U)                                           
#define CAN_F4R1_FB10_Msk      (0x1U << CAN_F4R1_FB10_Pos)                     /*!< 0x00000400 */
#define CAN_F4R1_FB10          CAN_F4R1_FB10_Msk                               /*!<Filter bit 10 */
#define CAN_F4R1_FB11_Pos      (11U)                                           
#define CAN_F4R1_FB11_Msk      (0x1U << CAN_F4R1_FB11_Pos)                     /*!< 0x00000800 */
#define CAN_F4R1_FB11          CAN_F4R1_FB11_Msk                               /*!<Filter bit 11 */
#define CAN_F4R1_FB12_Pos      (12U)                                           
#define CAN_F4R1_FB12_Msk      (0x1U << CAN_F4R1_FB12_Pos)                     /*!< 0x00001000 */
#define CAN_F4R1_FB12          CAN_F4R1_FB12_Msk                               /*!<Filter bit 12 */
#define CAN_F4R1_FB13_Pos      (13U)                                           
#define CAN_F4R1_FB13_Msk      (0x1U << CAN_F4R1_FB13_Pos)                     /*!< 0x00002000 */
#define CAN_F4R1_FB13          CAN_F4R1_FB13_Msk                               /*!<Filter bit 13 */
#define CAN_F4R1_FB14_Pos      (14U)                                           
#define CAN_F4R1_FB14_Msk      (0x1U << CAN_F4R1_FB14_Pos)                     /*!< 0x00004000 */
#define CAN_F4R1_FB14          CAN_F4R1_FB14_Msk                               /*!<Filter bit 14 */
#define CAN_F4R1_FB15_Pos      (15U)                                           
#define CAN_F4R1_FB15_Msk      (0x1U << CAN_F4R1_FB15_Pos)                     /*!< 0x00008000 */
#define CAN_F4R1_FB15          CAN_F4R1_FB15_Msk                               /*!<Filter bit 15 */
#define CAN_F4R1_FB16_Pos      (16U)                                           
#define CAN_F4R1_FB16_Msk      (0x1U << CAN_F4R1_FB16_Pos)                     /*!< 0x00010000 */
#define CAN_F4R1_FB16          CAN_F4R1_FB16_Msk                               /*!<Filter bit 16 */
#define CAN_F4R1_FB17_Pos      (17U)                                           
#define CAN_F4R1_FB17_Msk      (0x1U << CAN_F4R1_FB17_Pos)                     /*!< 0x00020000 */
#define CAN_F4R1_FB17          CAN_F4R1_FB17_Msk                               /*!<Filter bit 17 */
#define CAN_F4R1_FB18_Pos      (18U)                                           
#define CAN_F4R1_FB18_Msk      (0x1U << CAN_F4R1_FB18_Pos)                     /*!< 0x00040000 */
#define CAN_F4R1_FB18          CAN_F4R1_FB18_Msk                               /*!<Filter bit 18 */
#define CAN_F4R1_FB19_Pos      (19U)                                           
#define CAN_F4R1_FB19_Msk      (0x1U << CAN_F4R1_FB19_Pos)                     /*!< 0x00080000 */
#define CAN_F4R1_FB19          CAN_F4R1_FB19_Msk                               /*!<Filter bit 19 */
#define CAN_F4R1_FB20_Pos      (20U)                                           
#define CAN_F4R1_FB20_Msk      (0x1U << CAN_F4R1_FB20_Pos)                     /*!< 0x00100000 */
#define CAN_F4R1_FB20          CAN_F4R1_FB20_Msk                               /*!<Filter bit 20 */
#define CAN_F4R1_FB21_Pos      (21U)                                           
#define CAN_F4R1_FB21_Msk      (0x1U << CAN_F4R1_FB21_Pos)                     /*!< 0x00200000 */
#define CAN_F4R1_FB21          CAN_F4R1_FB21_Msk                               /*!<Filter bit 21 */
#define CAN_F4R1_FB22_Pos      (22U)                                           
#define CAN_F4R1_FB22_Msk      (0x1U << CAN_F4R1_FB22_Pos)                     /*!< 0x00400000 */
#define CAN_F4R1_FB22          CAN_F4R1_FB22_Msk                               /*!<Filter bit 22 */
#define CAN_F4R1_FB23_Pos      (23U)                                           
#define CAN_F4R1_FB23_Msk      (0x1U << CAN_F4R1_FB23_Pos)                     /*!< 0x00800000 */
#define CAN_F4R1_FB23          CAN_F4R1_FB23_Msk                               /*!<Filter bit 23 */
#define CAN_F4R1_FB24_Pos      (24U)                                           
#define CAN_F4R1_FB24_Msk      (0x1U << CAN_F4R1_FB24_Pos)                     /*!< 0x01000000 */
#define CAN_F4R1_FB24          CAN_F4R1_FB24_Msk                               /*!<Filter bit 24 */
#define CAN_F4R1_FB25_Pos      (25U)                                           
#define CAN_F4R1_FB25_Msk      (0x1U << CAN_F4R1_FB25_Pos)                     /*!< 0x02000000 */
#define CAN_F4R1_FB25          CAN_F4R1_FB25_Msk                               /*!<Filter bit 25 */
#define CAN_F4R1_FB26_Pos      (26U)                                           
#define CAN_F4R1_FB26_Msk      (0x1U << CAN_F4R1_FB26_Pos)                     /*!< 0x04000000 */
#define CAN_F4R1_FB26          CAN_F4R1_FB26_Msk                               /*!<Filter bit 26 */
#define CAN_F4R1_FB27_Pos      (27U)                                           
#define CAN_F4R1_FB27_Msk      (0x1U << CAN_F4R1_FB27_Pos)                     /*!< 0x08000000 */
#define CAN_F4R1_FB27          CAN_F4R1_FB27_Msk                               /*!<Filter bit 27 */
#define CAN_F4R1_FB28_Pos      (28U)                                           
#define CAN_F4R1_FB28_Msk      (0x1U << CAN_F4R1_FB28_Pos)                     /*!< 0x10000000 */
#define CAN_F4R1_FB28          CAN_F4R1_FB28_Msk                               /*!<Filter bit 28 */
#define CAN_F4R1_FB29_Pos      (29U)                                           
#define CAN_F4R1_FB29_Msk      (0x1U << CAN_F4R1_FB29_Pos)                     /*!< 0x20000000 */
#define CAN_F4R1_FB29          CAN_F4R1_FB29_Msk                               /*!<Filter bit 29 */
#define CAN_F4R1_FB30_Pos      (30U)                                           
#define CAN_F4R1_FB30_Msk      (0x1U << CAN_F4R1_FB30_Pos)                     /*!< 0x40000000 */
#define CAN_F4R1_FB30          CAN_F4R1_FB30_Msk                               /*!<Filter bit 30 */
#define CAN_F4R1_FB31_Pos      (31U)                                           
#define CAN_F4R1_FB31_Msk      (0x1U << CAN_F4R1_FB31_Pos)                     /*!< 0x80000000 */
#define CAN_F4R1_FB31          CAN_F4R1_FB31_Msk                               /*!<Filter bit 31 */

/*******************  Bit definition for CAN_F5R1 register  *******************/
#define CAN_F5R1_FB0_Pos       (0U)                                            
#define CAN_F5R1_FB0_Msk       (0x1U << CAN_F5R1_FB0_Pos)                      /*!< 0x00000001 */
#define CAN_F5R1_FB0           CAN_F5R1_FB0_Msk                                /*!<Filter bit 0 */
#define CAN_F5R1_FB1_Pos       (1U)                                            
#define CAN_F5R1_FB1_Msk       (0x1U << CAN_F5R1_FB1_Pos)                      /*!< 0x00000002 */
#define CAN_F5R1_FB1           CAN_F5R1_FB1_Msk                                /*!<Filter bit 1 */
#define CAN_F5R1_FB2_Pos       (2U)                                            
#define CAN_F5R1_FB2_Msk       (0x1U << CAN_F5R1_FB2_Pos)                      /*!< 0x00000004 */
#define CAN_F5R1_FB2           CAN_F5R1_FB2_Msk                                /*!<Filter bit 2 */
#define CAN_F5R1_FB3_Pos       (3U)                                            
#define CAN_F5R1_FB3_Msk       (0x1U << CAN_F5R1_FB3_Pos)                      /*!< 0x00000008 */
#define CAN_F5R1_FB3           CAN_F5R1_FB3_Msk                                /*!<Filter bit 3 */
#define CAN_F5R1_FB4_Pos       (4U)                                            
#define CAN_F5R1_FB4_Msk       (0x1U << CAN_F5R1_FB4_Pos)                      /*!< 0x00000010 */
#define CAN_F5R1_FB4           CAN_F5R1_FB4_Msk                                /*!<Filter bit 4 */
#define CAN_F5R1_FB5_Pos       (5U)                                            
#define CAN_F5R1_FB5_Msk       (0x1U << CAN_F5R1_FB5_Pos)                      /*!< 0x00000020 */
#define CAN_F5R1_FB5           CAN_F5R1_FB5_Msk                                /*!<Filter bit 5 */
#define CAN_F5R1_FB6_Pos       (6U)                                            
#define CAN_F5R1_FB6_Msk       (0x1U << CAN_F5R1_FB6_Pos)                      /*!< 0x00000040 */
#define CAN_F5R1_FB6           CAN_F5R1_FB6_Msk                                /*!<Filter bit 6 */
#define CAN_F5R1_FB7_Pos       (7U)                                            
#define CAN_F5R1_FB7_Msk       (0x1U << CAN_F5R1_FB7_Pos)                      /*!< 0x00000080 */
#define CAN_F5R1_FB7           CAN_F5R1_FB7_Msk                                /*!<Filter bit 7 */
#define CAN_F5R1_FB8_Pos       (8U)                                            
#define CAN_F5R1_FB8_Msk       (0x1U << CAN_F5R1_FB8_Pos)                      /*!< 0x00000100 */
#define CAN_F5R1_FB8           CAN_F5R1_FB8_Msk                                /*!<Filter bit 8 */
#define CAN_F5R1_FB9_Pos       (9U)                                            
#define CAN_F5R1_FB9_Msk       (0x1U << CAN_F5R1_FB9_Pos)                      /*!< 0x00000200 */
#define CAN_F5R1_FB9           CAN_F5R1_FB9_Msk                                /*!<Filter bit 9 */
#define CAN_F5R1_FB10_Pos      (10U)                                           
#define CAN_F5R1_FB10_Msk      (0x1U << CAN_F5R1_FB10_Pos)                     /*!< 0x00000400 */
#define CAN_F5R1_FB10          CAN_F5R1_FB10_Msk                               /*!<Filter bit 10 */
#define CAN_F5R1_FB11_Pos      (11U)                                           
#define CAN_F5R1_FB11_Msk      (0x1U << CAN_F5R1_FB11_Pos)                     /*!< 0x00000800 */
#define CAN_F5R1_FB11          CAN_F5R1_FB11_Msk                               /*!<Filter bit 11 */
#define CAN_F5R1_FB12_Pos      (12U)                                           
#define CAN_F5R1_FB12_Msk      (0x1U << CAN_F5R1_FB12_Pos)                     /*!< 0x00001000 */
#define CAN_F5R1_FB12          CAN_F5R1_FB12_Msk                               /*!<Filter bit 12 */
#define CAN_F5R1_FB13_Pos      (13U)                                           
#define CAN_F5R1_FB13_Msk      (0x1U << CAN_F5R1_FB13_Pos)                     /*!< 0x00002000 */
#define CAN_F5R1_FB13          CAN_F5R1_FB13_Msk                               /*!<Filter bit 13 */
#define CAN_F5R1_FB14_Pos      (14U)                                           
#define CAN_F5R1_FB14_Msk      (0x1U << CAN_F5R1_FB14_Pos)                     /*!< 0x00004000 */
#define CAN_F5R1_FB14          CAN_F5R1_FB14_Msk                               /*!<Filter bit 14 */
#define CAN_F5R1_FB15_Pos      (15U)                                           
#define CAN_F5R1_FB15_Msk      (0x1U << CAN_F5R1_FB15_Pos)                     /*!< 0x00008000 */
#define CAN_F5R1_FB15          CAN_F5R1_FB15_Msk                               /*!<Filter bit 15 */
#define CAN_F5R1_FB16_Pos      (16U)                                           
#define CAN_F5R1_FB16_Msk      (0x1U << CAN_F5R1_FB16_Pos)                     /*!< 0x00010000 */
#define CAN_F5R1_FB16          CAN_F5R1_FB16_Msk                               /*!<Filter bit 16 */
#define CAN_F5R1_FB17_Pos      (17U)                                           
#define CAN_F5R1_FB17_Msk      (0x1U << CAN_F5R1_FB17_Pos)                     /*!< 0x00020000 */
#define CAN_F5R1_FB17          CAN_F5R1_FB17_Msk                               /*!<Filter bit 17 */
#define CAN_F5R1_FB18_Pos      (18U)                                           
#define CAN_F5R1_FB18_Msk      (0x1U << CAN_F5R1_FB18_Pos)                     /*!< 0x00040000 */
#define CAN_F5R1_FB18          CAN_F5R1_FB18_Msk                               /*!<Filter bit 18 */
#define CAN_F5R1_FB19_Pos      (19U)                                           
#define CAN_F5R1_FB19_Msk      (0x1U << CAN_F5R1_FB19_Pos)                     /*!< 0x00080000 */
#define CAN_F5R1_FB19          CAN_F5R1_FB19_Msk                               /*!<Filter bit 19 */
#define CAN_F5R1_FB20_Pos      (20U)                                           
#define CAN_F5R1_FB20_Msk      (0x1U << CAN_F5R1_FB20_Pos)                     /*!< 0x00100000 */
#define CAN_F5R1_FB20          CAN_F5R1_FB20_Msk                               /*!<Filter bit 20 */
#define CAN_F5R1_FB21_Pos      (21U)                                           
#define CAN_F5R1_FB21_Msk      (0x1U << CAN_F5R1_FB21_Pos)                     /*!< 0x00200000 */
#define CAN_F5R1_FB21          CAN_F5R1_FB21_Msk                               /*!<Filter bit 21 */
#define CAN_F5R1_FB22_Pos      (22U)                                           
#define CAN_F5R1_FB22_Msk      (0x1U << CAN_F5R1_FB22_Pos)                     /*!< 0x00400000 */
#define CAN_F5R1_FB22          CAN_F5R1_FB22_Msk                               /*!<Filter bit 22 */
#define CAN_F5R1_FB23_Pos      (23U)                                           
#define CAN_F5R1_FB23_Msk      (0x1U << CAN_F5R1_FB23_Pos)                     /*!< 0x00800000 */
#define CAN_F5R1_FB23          CAN_F5R1_FB23_Msk                               /*!<Filter bit 23 */
#define CAN_F5R1_FB24_Pos      (24U)                                           
#define CAN_F5R1_FB24_Msk      (0x1U << CAN_F5R1_FB24_Pos)                     /*!< 0x01000000 */
#define CAN_F5R1_FB24          CAN_F5R1_FB24_Msk                               /*!<Filter bit 24 */
#define CAN_F5R1_FB25_Pos      (25U)                                           
#define CAN_F5R1_FB25_Msk      (0x1U << CAN_F5R1_FB25_Pos)                     /*!< 0x02000000 */
#define CAN_F5R1_FB25          CAN_F5R1_FB25_Msk                               /*!<Filter bit 25 */
#define CAN_F5R1_FB26_Pos      (26U)                                           
#define CAN_F5R1_FB26_Msk      (0x1U << CAN_F5R1_FB26_Pos)                     /*!< 0x04000000 */
#define CAN_F5R1_FB26          CAN_F5R1_FB26_Msk                               /*!<Filter bit 26 */
#define CAN_F5R1_FB27_Pos      (27U)                                           
#define CAN_F5R1_FB27_Msk      (0x1U << CAN_F5R1_FB27_Pos)                     /*!< 0x08000000 */
#define CAN_F5R1_FB27          CAN_F5R1_FB27_Msk                               /*!<Filter bit 27 */
#define CAN_F5R1_FB28_Pos      (28U)                                           
#define CAN_F5R1_FB28_Msk      (0x1U << CAN_F5R1_FB28_Pos)                     /*!< 0x10000000 */
#define CAN_F5R1_FB28          CAN_F5R1_FB28_Msk                               /*!<Filter bit 28 */
#define CAN_F5R1_FB29_Pos      (29U)                                           
#define CAN_F5R1_FB29_Msk      (0x1U << CAN_F5R1_FB29_Pos)                     /*!< 0x20000000 */
#define CAN_F5R1_FB29          CAN_F5R1_FB29_Msk                               /*!<Filter bit 29 */
#define CAN_F5R1_FB30_Pos      (30U)                                           
#define CAN_F5R1_FB30_Msk      (0x1U << CAN_F5R1_FB30_Pos)                     /*!< 0x40000000 */
#define CAN_F5R1_FB30          CAN_F5R1_FB30_Msk                               /*!<Filter bit 30 */
#define CAN_F5R1_FB31_Pos      (31U)                                           
#define CAN_F5R1_FB31_Msk      (0x1U << CAN_F5R1_FB31_Pos)                     /*!< 0x80000000 */
#define CAN_F5R1_FB31          CAN_F5R1_FB31_Msk                               /*!<Filter bit 31 */

/*******************  Bit definition for CAN_F6R1 register  *******************/
#define CAN_F6R1_FB0_Pos       (0U)                                            
#define CAN_F6R1_FB0_Msk       (0x1U << CAN_F6R1_FB0_Pos)                      /*!< 0x00000001 */
#define CAN_F6R1_FB0           CAN_F6R1_FB0_Msk                                /*!<Filter bit 0 */
#define CAN_F6R1_FB1_Pos       (1U)                                            
#define CAN_F6R1_FB1_Msk       (0x1U << CAN_F6R1_FB1_Pos)                      /*!< 0x00000002 */
#define CAN_F6R1_FB1           CAN_F6R1_FB1_Msk                                /*!<Filter bit 1 */
#define CAN_F6R1_FB2_Pos       (2U)                                            
#define CAN_F6R1_FB2_Msk       (0x1U << CAN_F6R1_FB2_Pos)                      /*!< 0x00000004 */
#define CAN_F6R1_FB2           CAN_F6R1_FB2_Msk                                /*!<Filter bit 2 */
#define CAN_F6R1_FB3_Pos       (3U)                                            
#define CAN_F6R1_FB3_Msk       (0x1U << CAN_F6R1_FB3_Pos)                      /*!< 0x00000008 */
#define CAN_F6R1_FB3           CAN_F6R1_FB3_Msk                                /*!<Filter bit 3 */
#define CAN_F6R1_FB4_Pos       (4U)                                            
#define CAN_F6R1_FB4_Msk       (0x1U << CAN_F6R1_FB4_Pos)                      /*!< 0x00000010 */
#define CAN_F6R1_FB4           CAN_F6R1_FB4_Msk                                /*!<Filter bit 4 */
#define CAN_F6R1_FB5_Pos       (5U)                                            
#define CAN_F6R1_FB5_Msk       (0x1U << CAN_F6R1_FB5_Pos)                      /*!< 0x00000020 */
#define CAN_F6R1_FB5           CAN_F6R1_FB5_Msk                                /*!<Filter bit 5 */
#define CAN_F6R1_FB6_Pos       (6U)                                            
#define CAN_F6R1_FB6_Msk       (0x1U << CAN_F6R1_FB6_Pos)                      /*!< 0x00000040 */
#define CAN_F6R1_FB6           CAN_F6R1_FB6_Msk                                /*!<Filter bit 6 */
#define CAN_F6R1_FB7_Pos       (7U)                                            
#define CAN_F6R1_FB7_Msk       (0x1U << CAN_F6R1_FB7_Pos)                      /*!< 0x00000080 */
#define CAN_F6R1_FB7           CAN_F6R1_FB7_Msk                                /*!<Filter bit 7 */
#define CAN_F6R1_FB8_Pos       (8U)                                            
#define CAN_F6R1_FB8_Msk       (0x1U << CAN_F6R1_FB8_Pos)                      /*!< 0x00000100 */
#define CAN_F6R1_FB8           CAN_F6R1_FB8_Msk                                /*!<Filter bit 8 */
#define CAN_F6R1_FB9_Pos       (9U)                                            
#define CAN_F6R1_FB9_Msk       (0x1U << CAN_F6R1_FB9_Pos)                      /*!< 0x00000200 */
#define CAN_F6R1_FB9           CAN_F6R1_FB9_Msk                                /*!<Filter bit 9 */
#define CAN_F6R1_FB10_Pos      (10U)                                           
#define CAN_F6R1_FB10_Msk      (0x1U << CAN_F6R1_FB10_Pos)                     /*!< 0x00000400 */
#define CAN_F6R1_FB10          CAN_F6R1_FB10_Msk                               /*!<Filter bit 10 */
#define CAN_F6R1_FB11_Pos      (11U)                                           
#define CAN_F6R1_FB11_Msk      (0x1U << CAN_F6R1_FB11_Pos)                     /*!< 0x00000800 */
#define CAN_F6R1_FB11          CAN_F6R1_FB11_Msk                               /*!<Filter bit 11 */
#define CAN_F6R1_FB12_Pos      (12U)                                           
#define CAN_F6R1_FB12_Msk      (0x1U << CAN_F6R1_FB12_Pos)                     /*!< 0x00001000 */
#define CAN_F6R1_FB12          CAN_F6R1_FB12_Msk                               /*!<Filter bit 12 */
#define CAN_F6R1_FB13_Pos      (13U)                                           
#define CAN_F6R1_FB13_Msk      (0x1U << CAN_F6R1_FB13_Pos)                     /*!< 0x00002000 */
#define CAN_F6R1_FB13          CAN_F6R1_FB13_Msk                               /*!<Filter bit 13 */
#define CAN_F6R1_FB14_Pos      (14U)                                           
#define CAN_F6R1_FB14_Msk      (0x1U << CAN_F6R1_FB14_Pos)                     /*!< 0x00004000 */
#define CAN_F6R1_FB14          CAN_F6R1_FB14_Msk                               /*!<Filter bit 14 */
#define CAN_F6R1_FB15_Pos      (15U)                                           
#define CAN_F6R1_FB15_Msk      (0x1U << CAN_F6R1_FB15_Pos)                     /*!< 0x00008000 */
#define CAN_F6R1_FB15          CAN_F6R1_FB15_Msk                               /*!<Filter bit 15 */
#define CAN_F6R1_FB16_Pos      (16U)                                           
#define CAN_F6R1_FB16_Msk      (0x1U << CAN_F6R1_FB16_Pos)                     /*!< 0x00010000 */
#define CAN_F6R1_FB16          CAN_F6R1_FB16_Msk                               /*!<Filter bit 16 */
#define CAN_F6R1_FB17_Pos      (17U)                                           
#define CAN_F6R1_FB17_Msk      (0x1U << CAN_F6R1_FB17_Pos)                     /*!< 0x00020000 */
#define CAN_F6R1_FB17          CAN_F6R1_FB17_Msk                               /*!<Filter bit 17 */
#define CAN_F6R1_FB18_Pos      (18U)                                           
#define CAN_F6R1_FB18_Msk      (0x1U << CAN_F6R1_FB18_Pos)                     /*!< 0x00040000 */
#define CAN_F6R1_FB18          CAN_F6R1_FB18_Msk                               /*!<Filter bit 18 */
#define CAN_F6R1_FB19_Pos      (19U)                                           
#define CAN_F6R1_FB19_Msk      (0x1U << CAN_F6R1_FB19_Pos)                     /*!< 0x00080000 */
#define CAN_F6R1_FB19          CAN_F6R1_FB19_Msk                               /*!<Filter bit 19 */
#define CAN_F6R1_FB20_Pos      (20U)                                           
#define CAN_F6R1_FB20_Msk      (0x1U << CAN_F6R1_FB20_Pos)                     /*!< 0x00100000 */
#define CAN_F6R1_FB20          CAN_F6R1_FB20_Msk                               /*!<Filter bit 20 */
#define CAN_F6R1_FB21_Pos      (21U)                                           
#define CAN_F6R1_FB21_Msk      (0x1U << CAN_F6R1_FB21_Pos)                     /*!< 0x00200000 */
#define CAN_F6R1_FB21          CAN_F6R1_FB21_Msk                               /*!<Filter bit 21 */
#define CAN_F6R1_FB22_Pos      (22U)                                           
#define CAN_F6R1_FB22_Msk      (0x1U << CAN_F6R1_FB22_Pos)                     /*!< 0x00400000 */
#define CAN_F6R1_FB22          CAN_F6R1_FB22_Msk                               /*!<Filter bit 22 */
#define CAN_F6R1_FB23_Pos      (23U)                                           
#define CAN_F6R1_FB23_Msk      (0x1U << CAN_F6R1_FB23_Pos)                     /*!< 0x00800000 */
#define CAN_F6R1_FB23          CAN_F6R1_FB23_Msk                               /*!<Filter bit 23 */
#define CAN_F6R1_FB24_Pos      (24U)                                           
#define CAN_F6R1_FB24_Msk      (0x1U << CAN_F6R1_FB24_Pos)                     /*!< 0x01000000 */
#define CAN_F6R1_FB24          CAN_F6R1_FB24_Msk                               /*!<Filter bit 24 */
#define CAN_F6R1_FB25_Pos      (25U)                                           
#define CAN_F6R1_FB25_Msk      (0x1U << CAN_F6R1_FB25_Pos)                     /*!< 0x02000000 */
#define CAN_F6R1_FB25          CAN_F6R1_FB25_Msk                               /*!<Filter bit 25 */
#define CAN_F6R1_FB26_Pos      (26U)                                           
#define CAN_F6R1_FB26_Msk      (0x1U << CAN_F6R1_FB26_Pos)                     /*!< 0x04000000 */
#define CAN_F6R1_FB26          CAN_F6R1_FB26_Msk                               /*!<Filter bit 26 */
#define CAN_F6R1_FB27_Pos      (27U)                                           
#define CAN_F6R1_FB27_Msk      (0x1U << CAN_F6R1_FB27_Pos)                     /*!< 0x08000000 */
#define CAN_F6R1_FB27          CAN_F6R1_FB27_Msk                               /*!<Filter bit 27 */
#define CAN_F6R1_FB28_Pos      (28U)                                           
#define CAN_F6R1_FB28_Msk      (0x1U << CAN_F6R1_FB28_Pos)                     /*!< 0x10000000 */
#define CAN_F6R1_FB28          CAN_F6R1_FB28_Msk                               /*!<Filter bit 28 */
#define CAN_F6R1_FB29_Pos      (29U)                                           
#define CAN_F6R1_FB29_Msk      (0x1U << CAN_F6R1_FB29_Pos)                     /*!< 0x20000000 */
#define CAN_F6R1_FB29          CAN_F6R1_FB29_Msk                               /*!<Filter bit 29 */
#define CAN_F6R1_FB30_Pos      (30U)                                           
#define CAN_F6R1_FB30_Msk      (0x1U << CAN_F6R1_FB30_Pos)                     /*!< 0x40000000 */
#define CAN_F6R1_FB30          CAN_F6R1_FB30_Msk                               /*!<Filter bit 30 */
#define CAN_F6R1_FB31_Pos      (31U)                                           
#define CAN_F6R1_FB31_Msk      (0x1U << CAN_F6R1_FB31_Pos)                     /*!< 0x80000000 */
#define CAN_F6R1_FB31          CAN_F6R1_FB31_Msk                               /*!<Filter bit 31 */

/*******************  Bit definition for CAN_F7R1 register  *******************/
#define CAN_F7R1_FB0_Pos       (0U)                                            
#define CAN_F7R1_FB0_Msk       (0x1U << CAN_F7R1_FB0_Pos)                      /*!< 0x00000001 */
#define CAN_F7R1_FB0           CAN_F7R1_FB0_Msk                                /*!<Filter bit 0 */
#define CAN_F7R1_FB1_Pos       (1U)                                            
#define CAN_F7R1_FB1_Msk       (0x1U << CAN_F7R1_FB1_Pos)                      /*!< 0x00000002 */
#define CAN_F7R1_FB1           CAN_F7R1_FB1_Msk                                /*!<Filter bit 1 */
#define CAN_F7R1_FB2_Pos       (2U)                                            
#define CAN_F7R1_FB2_Msk       (0x1U << CAN_F7R1_FB2_Pos)                      /*!< 0x00000004 */
#define CAN_F7R1_FB2           CAN_F7R1_FB2_Msk                                /*!<Filter bit 2 */
#define CAN_F7R1_FB3_Pos       (3U)                                            
#define CAN_F7R1_FB3_Msk       (0x1U << CAN_F7R1_FB3_Pos)                      /*!< 0x00000008 */
#define CAN_F7R1_FB3           CAN_F7R1_FB3_Msk                                /*!<Filter bit 3 */
#define CAN_F7R1_FB4_Pos       (4U)                                            
#define CAN_F7R1_FB4_Msk       (0x1U << CAN_F7R1_FB4_Pos)                      /*!< 0x00000010 */
#define CAN_F7R1_FB4           CAN_F7R1_FB4_Msk                                /*!<Filter bit 4 */
#define CAN_F7R1_FB5_Pos       (5U)                                            
#define CAN_F7R1_FB5_Msk       (0x1U << CAN_F7R1_FB5_Pos)                      /*!< 0x00000020 */
#define CAN_F7R1_FB5           CAN_F7R1_FB5_Msk                                /*!<Filter bit 5 */
#define CAN_F7R1_FB6_Pos       (6U)                                            
#define CAN_F7R1_FB6_Msk       (0x1U << CAN_F7R1_FB6_Pos)                      /*!< 0x00000040 */
#define CAN_F7R1_FB6           CAN_F7R1_FB6_Msk                                /*!<Filter bit 6 */
#define CAN_F7R1_FB7_Pos       (7U)                                            
#define CAN_F7R1_FB7_Msk       (0x1U << CAN_F7R1_FB7_Pos)                      /*!< 0x00000080 */
#define CAN_F7R1_FB7           CAN_F7R1_FB7_Msk                                /*!<Filter bit 7 */
#define CAN_F7R1_FB8_Pos       (8U)                                            
#define CAN_F7R1_FB8_Msk       (0x1U << CAN_F7R1_FB8_Pos)                      /*!< 0x00000100 */
#define CAN_F7R1_FB8           CAN_F7R1_FB8_Msk                                /*!<Filter bit 8 */
#define CAN_F7R1_FB9_Pos       (9U)                                            
#define CAN_F7R1_FB9_Msk       (0x1U << CAN_F7R1_FB9_Pos)                      /*!< 0x00000200 */
#define CAN_F7R1_FB9           CAN_F7R1_FB9_Msk                                /*!<Filter bit 9 */
#define CAN_F7R1_FB10_Pos      (10U)                                           
#define CAN_F7R1_FB10_Msk      (0x1U << CAN_F7R1_FB10_Pos)                     /*!< 0x00000400 */
#define CAN_F7R1_FB10          CAN_F7R1_FB10_Msk                               /*!<Filter bit 10 */
#define CAN_F7R1_FB11_Pos      (11U)                                           
#define CAN_F7R1_FB11_Msk      (0x1U << CAN_F7R1_FB11_Pos)                     /*!< 0x00000800 */
#define CAN_F7R1_FB11          CAN_F7R1_FB11_Msk                               /*!<Filter bit 11 */
#define CAN_F7R1_FB12_Pos      (12U)                                           
#define CAN_F7R1_FB12_Msk      (0x1U << CAN_F7R1_FB12_Pos)                     /*!< 0x00001000 */
#define CAN_F7R1_FB12          CAN_F7R1_FB12_Msk                               /*!<Filter bit 12 */
#define CAN_F7R1_FB13_Pos      (13U)                                           
#define CAN_F7R1_FB13_Msk      (0x1U << CAN_F7R1_FB13_Pos)                     /*!< 0x00002000 */
#define CAN_F7R1_FB13          CAN_F7R1_FB13_Msk                               /*!<Filter bit 13 */
#define CAN_F7R1_FB14_Pos      (14U)                                           
#define CAN_F7R1_FB14_Msk      (0x1U << CAN_F7R1_FB14_Pos)                     /*!< 0x00004000 */
#define CAN_F7R1_FB14          CAN_F7R1_FB14_Msk                               /*!<Filter bit 14 */
#define CAN_F7R1_FB15_Pos      (15U)                                           
#define CAN_F7R1_FB15_Msk      (0x1U << CAN_F7R1_FB15_Pos)                     /*!< 0x00008000 */
#define CAN_F7R1_FB15          CAN_F7R1_FB15_Msk                               /*!<Filter bit 15 */
#define CAN_F7R1_FB16_Pos      (16U)                                           
#define CAN_F7R1_FB16_Msk      (0x1U << CAN_F7R1_FB16_Pos)                     /*!< 0x00010000 */
#define CAN_F7R1_FB16          CAN_F7R1_FB16_Msk                               /*!<Filter bit 16 */
#define CAN_F7R1_FB17_Pos      (17U)                                           
#define CAN_F7R1_FB17_Msk      (0x1U << CAN_F7R1_FB17_Pos)                     /*!< 0x00020000 */
#define CAN_F7R1_FB17          CAN_F7R1_FB17_Msk                               /*!<Filter bit 17 */
#define CAN_F7R1_FB18_Pos      (18U)                                           
#define CAN_F7R1_FB18_Msk      (0x1U << CAN_F7R1_FB18_Pos)                     /*!< 0x00040000 */
#define CAN_F7R1_FB18          CAN_F7R1_FB18_Msk                               /*!<Filter bit 18 */
#define CAN_F7R1_FB19_Pos      (19U)                                           
#define CAN_F7R1_FB19_Msk      (0x1U << CAN_F7R1_FB19_Pos)                     /*!< 0x00080000 */
#define CAN_F7R1_FB19          CAN_F7R1_FB19_Msk                               /*!<Filter bit 19 */
#define CAN_F7R1_FB20_Pos      (20U)                                           
#define CAN_F7R1_FB20_Msk      (0x1U << CAN_F7R1_FB20_Pos)                     /*!< 0x00100000 */
#define CAN_F7R1_FB20          CAN_F7R1_FB20_Msk                               /*!<Filter bit 20 */
#define CAN_F7R1_FB21_Pos      (21U)                                           
#define CAN_F7R1_FB21_Msk      (0x1U << CAN_F7R1_FB21_Pos)                     /*!< 0x00200000 */
#define CAN_F7R1_FB21          CAN_F7R1_FB21_Msk                               /*!<Filter bit 21 */
#define CAN_F7R1_FB22_Pos      (22U)                                           
#define CAN_F7R1_FB22_Msk      (0x1U << CAN_F7R1_FB22_Pos)                     /*!< 0x00400000 */
#define CAN_F7R1_FB22          CAN_F7R1_FB22_Msk                               /*!<Filter bit 22 */
#define CAN_F7R1_FB23_Pos      (23U)                                           
#define CAN_F7R1_FB23_Msk      (0x1U << CAN_F7R1_FB23_Pos)                     /*!< 0x00800000 */
#define CAN_F7R1_FB23          CAN_F7R1_FB23_Msk                               /*!<Filter bit 23 */
#define CAN_F7R1_FB24_Pos      (24U)                                           
#define CAN_F7R1_FB24_Msk      (0x1U << CAN_F7R1_FB24_Pos)                     /*!< 0x01000000 */
#define CAN_F7R1_FB24          CAN_F7R1_FB24_Msk                               /*!<Filter bit 24 */
#define CAN_F7R1_FB25_Pos      (25U)                                           
#define CAN_F7R1_FB25_Msk      (0x1U << CAN_F7R1_FB25_Pos)                     /*!< 0x02000000 */
#define CAN_F7R1_FB25          CAN_F7R1_FB25_Msk                               /*!<Filter bit 25 */
#define CAN_F7R1_FB26_Pos      (26U)                                           
#define CAN_F7R1_FB26_Msk      (0x1U << CAN_F7R1_FB26_Pos)                     /*!< 0x04000000 */
#define CAN_F7R1_FB26          CAN_F7R1_FB26_Msk                               /*!<Filter bit 26 */
#define CAN_F7R1_FB27_Pos      (27U)                                           
#define CAN_F7R1_FB27_Msk      (0x1U << CAN_F7R1_FB27_Pos)                     /*!< 0x08000000 */
#define CAN_F7R1_FB27          CAN_F7R1_FB27_Msk                               /*!<Filter bit 27 */
#define CAN_F7R1_FB28_Pos      (28U)                                           
#define CAN_F7R1_FB28_Msk      (0x1U << CAN_F7R1_FB28_Pos)                     /*!< 0x10000000 */
#define CAN_F7R1_FB28          CAN_F7R1_FB28_Msk                               /*!<Filter bit 28 */
#define CAN_F7R1_FB29_Pos      (29U)                                           
#define CAN_F7R1_FB29_Msk      (0x1U << CAN_F7R1_FB29_Pos)                     /*!< 0x20000000 */
#define CAN_F7R1_FB29          CAN_F7R1_FB29_Msk                               /*!<Filter bit 29 */
#define CAN_F7R1_FB30_Pos      (30U)                                           
#define CAN_F7R1_FB30_Msk      (0x1U << CAN_F7R1_FB30_Pos)                     /*!< 0x40000000 */
#define CAN_F7R1_FB30          CAN_F7R1_FB30_Msk                               /*!<Filter bit 30 */
#define CAN_F7R1_FB31_Pos      (31U)                                           
#define CAN_F7R1_FB31_Msk      (0x1U << CAN_F7R1_FB31_Pos)                     /*!< 0x80000000 */
#define CAN_F7R1_FB31          CAN_F7R1_FB31_Msk                               /*!<Filter bit 31 */

/*******************  Bit definition for CAN_F8R1 register  *******************/
#define CAN_F8R1_FB0_Pos       (0U)                                            
#define CAN_F8R1_FB0_Msk       (0x1U << CAN_F8R1_FB0_Pos)                      /*!< 0x00000001 */
#define CAN_F8R1_FB0           CAN_F8R1_FB0_Msk                                /*!<Filter bit 0 */
#define CAN_F8R1_FB1_Pos       (1U)                                            
#define CAN_F8R1_FB1_Msk       (0x1U << CAN_F8R1_FB1_Pos)                      /*!< 0x00000002 */
#define CAN_F8R1_FB1           CAN_F8R1_FB1_Msk                                /*!<Filter bit 1 */
#define CAN_F8R1_FB2_Pos       (2U)                                            
#define CAN_F8R1_FB2_Msk       (0x1U << CAN_F8R1_FB2_Pos)                      /*!< 0x00000004 */
#define CAN_F8R1_FB2           CAN_F8R1_FB2_Msk                                /*!<Filter bit 2 */
#define CAN_F8R1_FB3_Pos       (3U)                                            
#define CAN_F8R1_FB3_Msk       (0x1U << CAN_F8R1_FB3_Pos)                      /*!< 0x00000008 */
#define CAN_F8R1_FB3           CAN_F8R1_FB3_Msk                                /*!<Filter bit 3 */
#define CAN_F8R1_FB4_Pos       (4U)                                            
#define CAN_F8R1_FB4_Msk       (0x1U << CAN_F8R1_FB4_Pos)                      /*!< 0x00000010 */
#define CAN_F8R1_FB4           CAN_F8R1_FB4_Msk                                /*!<Filter bit 4 */
#define CAN_F8R1_FB5_Pos       (5U)                                            
#define CAN_F8R1_FB5_Msk       (0x1U << CAN_F8R1_FB5_Pos)                      /*!< 0x00000020 */
#define CAN_F8R1_FB5           CAN_F8R1_FB5_Msk                                /*!<Filter bit 5 */
#define CAN_F8R1_FB6_Pos       (6U)                                            
#define CAN_F8R1_FB6_Msk       (0x1U << CAN_F8R1_FB6_Pos)                      /*!< 0x00000040 */
#define CAN_F8R1_FB6           CAN_F8R1_FB6_Msk                                /*!<Filter bit 6 */
#define CAN_F8R1_FB7_Pos       (7U)                                            
#define CAN_F8R1_FB7_Msk       (0x1U << CAN_F8R1_FB7_Pos)                      /*!< 0x00000080 */
#define CAN_F8R1_FB7           CAN_F8R1_FB7_Msk                                /*!<Filter bit 7 */
#define CAN_F8R1_FB8_Pos       (8U)                                            
#define CAN_F8R1_FB8_Msk       (0x1U << CAN_F8R1_FB8_Pos)                      /*!< 0x00000100 */
#define CAN_F8R1_FB8           CAN_F8R1_FB8_Msk                                /*!<Filter bit 8 */
#define CAN_F8R1_FB9_Pos       (9U)                                            
#define CAN_F8R1_FB9_Msk       (0x1U << CAN_F8R1_FB9_Pos)                      /*!< 0x00000200 */
#define CAN_F8R1_FB9           CAN_F8R1_FB9_Msk                                /*!<Filter bit 9 */
#define CAN_F8R1_FB10_Pos      (10U)                                           
#define CAN_F8R1_FB10_Msk      (0x1U << CAN_F8R1_FB10_Pos)                     /*!< 0x00000400 */
#define CAN_F8R1_FB10          CAN_F8R1_FB10_Msk                               /*!<Filter bit 10 */
#define CAN_F8R1_FB11_Pos      (11U)                                           
#define CAN_F8R1_FB11_Msk      (0x1U << CAN_F8R1_FB11_Pos)                     /*!< 0x00000800 */
#define CAN_F8R1_FB11          CAN_F8R1_FB11_Msk                               /*!<Filter bit 11 */
#define CAN_F8R1_FB12_Pos      (12U)                                           
#define CAN_F8R1_FB12_Msk      (0x1U << CAN_F8R1_FB12_Pos)                     /*!< 0x00001000 */
#define CAN_F8R1_FB12          CAN_F8R1_FB12_Msk                               /*!<Filter bit 12 */
#define CAN_F8R1_FB13_Pos      (13U)                                           
#define CAN_F8R1_FB13_Msk      (0x1U << CAN_F8R1_FB13_Pos)                     /*!< 0x00002000 */
#define CAN_F8R1_FB13          CAN_F8R1_FB13_Msk                               /*!<Filter bit 13 */
#define CAN_F8R1_FB14_Pos      (14U)                                           
#define CAN_F8R1_FB14_Msk      (0x1U << CAN_F8R1_FB14_Pos)                     /*!< 0x00004000 */
#define CAN_F8R1_FB14          CAN_F8R1_FB14_Msk                               /*!<Filter bit 14 */
#define CAN_F8R1_FB15_Pos      (15U)                                           
#define CAN_F8R1_FB15_Msk      (0x1U << CAN_F8R1_FB15_Pos)                     /*!< 0x00008000 */
#define CAN_F8R1_FB15          CAN_F8R1_FB15_Msk                               /*!<Filter bit 15 */
#define CAN_F8R1_FB16_Pos      (16U)                                           
#define CAN_F8R1_FB16_Msk      (0x1U << CAN_F8R1_FB16_Pos)                     /*!< 0x00010000 */
#define CAN_F8R1_FB16          CAN_F8R1_FB16_Msk                               /*!<Filter bit 16 */
#define CAN_F8R1_FB17_Pos      (17U)                                           
#define CAN_F8R1_FB17_Msk      (0x1U << CAN_F8R1_FB17_Pos)                     /*!< 0x00020000 */
#define CAN_F8R1_FB17          CAN_F8R1_FB17_Msk                               /*!<Filter bit 17 */
#define CAN_F8R1_FB18_Pos      (18U)                                           
#define CAN_F8R1_FB18_Msk      (0x1U << CAN_F8R1_FB18_Pos)                     /*!< 0x00040000 */
#define CAN_F8R1_FB18          CAN_F8R1_FB18_Msk                               /*!<Filter bit 18 */
#define CAN_F8R1_FB19_Pos      (19U)                                           
#define CAN_F8R1_FB19_Msk      (0x1U << CAN_F8R1_FB19_Pos)                     /*!< 0x00080000 */
#define CAN_F8R1_FB19          CAN_F8R1_FB19_Msk                               /*!<Filter bit 19 */
#define CAN_F8R1_FB20_Pos      (20U)                                           
#define CAN_F8R1_FB20_Msk      (0x1U << CAN_F8R1_FB20_Pos)                     /*!< 0x00100000 */
#define CAN_F8R1_FB20          CAN_F8R1_FB20_Msk                               /*!<Filter bit 20 */
#define CAN_F8R1_FB21_Pos      (21U)                                           
#define CAN_F8R1_FB21_Msk      (0x1U << CAN_F8R1_FB21_Pos)                     /*!< 0x00200000 */
#define CAN_F8R1_FB21          CAN_F8R1_FB21_Msk                               /*!<Filter bit 21 */
#define CAN_F8R1_FB22_Pos      (22U)                                           
#define CAN_F8R1_FB22_Msk      (0x1U << CAN_F8R1_FB22_Pos)                     /*!< 0x00400000 */
#define CAN_F8R1_FB22          CAN_F8R1_FB22_Msk                               /*!<Filter bit 22 */
#define CAN_F8R1_FB23_Pos      (23U)                                           
#define CAN_F8R1_FB23_Msk      (0x1U << CAN_F8R1_FB23_Pos)                     /*!< 0x00800000 */
#define CAN_F8R1_FB23          CAN_F8R1_FB23_Msk                               /*!<Filter bit 23 */
#define CAN_F8R1_FB24_Pos      (24U)                                           
#define CAN_F8R1_FB24_Msk      (0x1U << CAN_F8R1_FB24_Pos)                     /*!< 0x01000000 */
#define CAN_F8R1_FB24          CAN_F8R1_FB24_Msk                               /*!<Filter bit 24 */
#define CAN_F8R1_FB25_Pos      (25U)                                           
#define CAN_F8R1_FB25_Msk      (0x1U << CAN_F8R1_FB25_Pos)                     /*!< 0x02000000 */
#define CAN_F8R1_FB25          CAN_F8R1_FB25_Msk                               /*!<Filter bit 25 */
#define CAN_F8R1_FB26_Pos      (26U)                                           
#define CAN_F8R1_FB26_Msk      (0x1U << CAN_F8R1_FB26_Pos)                     /*!< 0x04000000 */
#define CAN_F8R1_FB26          CAN_F8R1_FB26_Msk                               /*!<Filter bit 26 */
#define CAN_F8R1_FB27_Pos      (27U)                                           
#define CAN_F8R1_FB27_Msk      (0x1U << CAN_F8R1_FB27_Pos)                     /*!< 0x08000000 */
#define CAN_F8R1_FB27          CAN_F8R1_FB27_Msk                               /*!<Filter bit 27 */
#define CAN_F8R1_FB28_Pos      (28U)                                           
#define CAN_F8R1_FB28_Msk      (0x1U << CAN_F8R1_FB28_Pos)                     /*!< 0x10000000 */
#define CAN_F8R1_FB28          CAN_F8R1_FB28_Msk                               /*!<Filter bit 28 */
#define CAN_F8R1_FB29_Pos      (29U)                                           
#define CAN_F8R1_FB29_Msk      (0x1U << CAN_F8R1_FB29_Pos)                     /*!< 0x20000000 */
#define CAN_F8R1_FB29          CAN_F8R1_FB29_Msk                               /*!<Filter bit 29 */
#define CAN_F8R1_FB30_Pos      (30U)                                           
#define CAN_F8R1_FB30_Msk      (0x1U << CAN_F8R1_FB30_Pos)                     /*!< 0x40000000 */
#define CAN_F8R1_FB30          CAN_F8R1_FB30_Msk                               /*!<Filter bit 30 */
#define CAN_F8R1_FB31_Pos      (31U)                                           
#define CAN_F8R1_FB31_Msk      (0x1U << CAN_F8R1_FB31_Pos)                     /*!< 0x80000000 */
#define CAN_F8R1_FB31          CAN_F8R1_FB31_Msk                               /*!<Filter bit 31 */

/*******************  Bit definition for CAN_F9R1 register  *******************/
#define CAN_F9R1_FB0_Pos       (0U)                                            
#define CAN_F9R1_FB0_Msk       (0x1U << CAN_F9R1_FB0_Pos)                      /*!< 0x00000001 */
#define CAN_F9R1_FB0           CAN_F9R1_FB0_Msk                                /*!<Filter bit 0 */
#define CAN_F9R1_FB1_Pos       (1U)                                            
#define CAN_F9R1_FB1_Msk       (0x1U << CAN_F9R1_FB1_Pos)                      /*!< 0x00000002 */
#define CAN_F9R1_FB1           CAN_F9R1_FB1_Msk                                /*!<Filter bit 1 */
#define CAN_F9R1_FB2_Pos       (2U)                                            
#define CAN_F9R1_FB2_Msk       (0x1U << CAN_F9R1_FB2_Pos)                      /*!< 0x00000004 */
#define CAN_F9R1_FB2           CAN_F9R1_FB2_Msk                                /*!<Filter bit 2 */
#define CAN_F9R1_FB3_Pos       (3U)                                            
#define CAN_F9R1_FB3_Msk       (0x1U << CAN_F9R1_FB3_Pos)                      /*!< 0x00000008 */
#define CAN_F9R1_FB3           CAN_F9R1_FB3_Msk                                /*!<Filter bit 3 */
#define CAN_F9R1_FB4_Pos       (4U)                                            
#define CAN_F9R1_FB4_Msk       (0x1U << CAN_F9R1_FB4_Pos)                      /*!< 0x00000010 */
#define CAN_F9R1_FB4           CAN_F9R1_FB4_Msk                                /*!<Filter bit 4 */
#define CAN_F9R1_FB5_Pos       (5U)                                            
#define CAN_F9R1_FB5_Msk       (0x1U << CAN_F9R1_FB5_Pos)                      /*!< 0x00000020 */
#define CAN_F9R1_FB5           CAN_F9R1_FB5_Msk                                /*!<Filter bit 5 */
#define CAN_F9R1_FB6_Pos       (6U)                                            
#define CAN_F9R1_FB6_Msk       (0x1U << CAN_F9R1_FB6_Pos)                      /*!< 0x00000040 */
#define CAN_F9R1_FB6           CAN_F9R1_FB6_Msk                                /*!<Filter bit 6 */
#define CAN_F9R1_FB7_Pos       (7U)                                            
#define CAN_F9R1_FB7_Msk       (0x1U << CAN_F9R1_FB7_Pos)                      /*!< 0x00000080 */
#define CAN_F9R1_FB7           CAN_F9R1_FB7_Msk                                /*!<Filter bit 7 */
#define CAN_F9R1_FB8_Pos       (8U)                                            
#define CAN_F9R1_FB8_Msk       (0x1U << CAN_F9R1_FB8_Pos)                      /*!< 0x00000100 */
#define CAN_F9R1_FB8           CAN_F9R1_FB8_Msk                                /*!<Filter bit 8 */
#define CAN_F9R1_FB9_Pos       (9U)                                            
#define CAN_F9R1_FB9_Msk       (0x1U << CAN_F9R1_FB9_Pos)                      /*!< 0x00000200 */
#define CAN_F9R1_FB9           CAN_F9R1_FB9_Msk                                /*!<Filter bit 9 */
#define CAN_F9R1_FB10_Pos      (10U)                                           
#define CAN_F9R1_FB10_Msk      (0x1U << CAN_F9R1_FB10_Pos)                     /*!< 0x00000400 */
#define CAN_F9R1_FB10          CAN_F9R1_FB10_Msk                               /*!<Filter bit 10 */
#define CAN_F9R1_FB11_Pos      (11U)                                           
#define CAN_F9R1_FB11_Msk      (0x1U << CAN_F9R1_FB11_Pos)                     /*!< 0x00000800 */
#define CAN_F9R1_FB11          CAN_F9R1_FB11_Msk                               /*!<Filter bit 11 */
#define CAN_F9R1_FB12_Pos      (12U)                                           
#define CAN_F9R1_FB12_Msk      (0x1U << CAN_F9R1_FB12_Pos)                     /*!< 0x00001000 */
#define CAN_F9R1_FB12          CAN_F9R1_FB12_Msk                               /*!<Filter bit 12 */
#define CAN_F9R1_FB13_Pos      (13U)                                           
#define CAN_F9R1_FB13_Msk      (0x1U << CAN_F9R1_FB13_Pos)                     /*!< 0x00002000 */
#define CAN_F9R1_FB13          CAN_F9R1_FB13_Msk                               /*!<Filter bit 13 */
#define CAN_F9R1_FB14_Pos      (14U)                                           
#define CAN_F9R1_FB14_Msk      (0x1U << CAN_F9R1_FB14_Pos)                     /*!< 0x00004000 */
#define CAN_F9R1_FB14          CAN_F9R1_FB14_Msk                               /*!<Filter bit 14 */
#define CAN_F9R1_FB15_Pos      (15U)                                           
#define CAN_F9R1_FB15_Msk      (0x1U << CAN_F9R1_FB15_Pos)                     /*!< 0x00008000 */
#define CAN_F9R1_FB15          CAN_F9R1_FB15_Msk                               /*!<Filter bit 15 */
#define CAN_F9R1_FB16_Pos      (16U)                                           
#define CAN_F9R1_FB16_Msk      (0x1U << CAN_F9R1_FB16_Pos)                     /*!< 0x00010000 */
#define CAN_F9R1_FB16          CAN_F9R1_FB16_Msk                               /*!<Filter bit 16 */
#define CAN_F9R1_FB17_Pos      (17U)                                           
#define CAN_F9R1_FB17_Msk      (0x1U << CAN_F9R1_FB17_Pos)                     /*!< 0x00020000 */
#define CAN_F9R1_FB17          CAN_F9R1_FB17_Msk                               /*!<Filter bit 17 */
#define CAN_F9R1_FB18_Pos      (18U)                                           
#define CAN_F9R1_FB18_Msk      (0x1U << CAN_F9R1_FB18_Pos)                     /*!< 0x00040000 */
#define CAN_F9R1_FB18          CAN_F9R1_FB18_Msk                               /*!<Filter bit 18 */
#define CAN_F9R1_FB19_Pos      (19U)                                           
#define CAN_F9R1_FB19_Msk      (0x1U << CAN_F9R1_FB19_Pos)                     /*!< 0x00080000 */
#define CAN_F9R1_FB19          CAN_F9R1_FB19_Msk                               /*!<Filter bit 19 */
#define CAN_F9R1_FB20_Pos      (20U)                                           
#define CAN_F9R1_FB20_Msk      (0x1U << CAN_F9R1_FB20_Pos)                     /*!< 0x00100000 */
#define CAN_F9R1_FB20          CAN_F9R1_FB20_Msk                               /*!<Filter bit 20 */
#define CAN_F9R1_FB21_Pos      (21U)                                           
#define CAN_F9R1_FB21_Msk      (0x1U << CAN_F9R1_FB21_Pos)                     /*!< 0x00200000 */
#define CAN_F9R1_FB21          CAN_F9R1_FB21_Msk                               /*!<Filter bit 21 */
#define CAN_F9R1_FB22_Pos      (22U)                                           
#define CAN_F9R1_FB22_Msk      (0x1U << CAN_F9R1_FB22_Pos)                     /*!< 0x00400000 */
#define CAN_F9R1_FB22          CAN_F9R1_FB22_Msk                               /*!<Filter bit 22 */
#define CAN_F9R1_FB23_Pos      (23U)                                           
#define CAN_F9R1_FB23_Msk      (0x1U << CAN_F9R1_FB23_Pos)                     /*!< 0x00800000 */
#define CAN_F9R1_FB23          CAN_F9R1_FB23_Msk                               /*!<Filter bit 23 */
#define CAN_F9R1_FB24_Pos      (24U)                                           
#define CAN_F9R1_FB24_Msk      (0x1U << CAN_F9R1_FB24_Pos)                     /*!< 0x01000000 */
#define CAN_F9R1_FB24          CAN_F9R1_FB24_Msk                               /*!<Filter bit 24 */
#define CAN_F9R1_FB25_Pos      (25U)                                           
#define CAN_F9R1_FB25_Msk      (0x1U << CAN_F9R1_FB25_Pos)                     /*!< 0x02000000 */
#define CAN_F9R1_FB25          CAN_F9R1_FB25_Msk                               /*!<Filter bit 25 */
#define CAN_F9R1_FB26_Pos      (26U)                                           
#define CAN_F9R1_FB26_Msk      (0x1U << CAN_F9R1_FB26_Pos)                     /*!< 0x04000000 */
#define CAN_F9R1_FB26          CAN_F9R1_FB26_Msk                               /*!<Filter bit 26 */
#define CAN_F9R1_FB27_Pos      (27U)                                           
#define CAN_F9R1_FB27_Msk      (0x1U << CAN_F9R1_FB27_Pos)                     /*!< 0x08000000 */
#define CAN_F9R1_FB27          CAN_F9R1_FB27_Msk                               /*!<Filter bit 27 */
#define CAN_F9R1_FB28_Pos      (28U)                                           
#define CAN_F9R1_FB28_Msk      (0x1U << CAN_F9R1_FB28_Pos)                     /*!< 0x10000000 */
#define CAN_F9R1_FB28          CAN_F9R1_FB28_Msk                               /*!<Filter bit 28 */
#define CAN_F9R1_FB29_Pos      (29U)                                           
#define CAN_F9R1_FB29_Msk      (0x1U << CAN_F9R1_FB29_Pos)                     /*!< 0x20000000 */
#define CAN_F9R1_FB29          CAN_F9R1_FB29_Msk                               /*!<Filter bit 29 */
#define CAN_F9R1_FB30_Pos      (30U)                                           
#define CAN_F9R1_FB30_Msk      (0x1U << CAN_F9R1_FB30_Pos)                     /*!< 0x40000000 */
#define CAN_F9R1_FB30          CAN_F9R1_FB30_Msk                               /*!<Filter bit 30 */
#define CAN_F9R1_FB31_Pos      (31U)                                           
#define CAN_F9R1_FB31_Msk      (0x1U << CAN_F9R1_FB31_Pos)                     /*!< 0x80000000 */
#define CAN_F9R1_FB31          CAN_F9R1_FB31_Msk                               /*!<Filter bit 31 */

/*******************  Bit definition for CAN_F10R1 register  ******************/
#define CAN_F10R1_FB0_Pos      (0U)                                            
#define CAN_F10R1_FB0_Msk      (0x1U << CAN_F10R1_FB0_Pos)                     /*!< 0x00000001 */
#define CAN_F10R1_FB0          CAN_F10R1_FB0_Msk                               /*!<Filter bit 0 */
#define CAN_F10R1_FB1_Pos      (1U)                                            
#define CAN_F10R1_FB1_Msk      (0x1U << CAN_F10R1_FB1_Pos)                     /*!< 0x00000002 */
#define CAN_F10R1_FB1          CAN_F10R1_FB1_Msk                               /*!<Filter bit 1 */
#define CAN_F10R1_FB2_Pos      (2U)                                            
#define CAN_F10R1_FB2_Msk      (0x1U << CAN_F10R1_FB2_Pos)                     /*!< 0x00000004 */
#define CAN_F10R1_FB2          CAN_F10R1_FB2_Msk                               /*!<Filter bit 2 */
#define CAN_F10R1_FB3_Pos      (3U)                                            
#define CAN_F10R1_FB3_Msk      (0x1U << CAN_F10R1_FB3_Pos)                     /*!< 0x00000008 */
#define CAN_F10R1_FB3          CAN_F10R1_FB3_Msk                               /*!<Filter bit 3 */
#define CAN_F10R1_FB4_Pos      (4U)                                            
#define CAN_F10R1_FB4_Msk      (0x1U << CAN_F10R1_FB4_Pos)                     /*!< 0x00000010 */
#define CAN_F10R1_FB4          CAN_F10R1_FB4_Msk                               /*!<Filter bit 4 */
#define CAN_F10R1_FB5_Pos      (5U)                                            
#define CAN_F10R1_FB5_Msk      (0x1U << CAN_F10R1_FB5_Pos)                     /*!< 0x00000020 */
#define CAN_F10R1_FB5          CAN_F10R1_FB5_Msk                               /*!<Filter bit 5 */
#define CAN_F10R1_FB6_Pos      (6U)                                            
#define CAN_F10R1_FB6_Msk      (0x1U << CAN_F10R1_FB6_Pos)                     /*!< 0x00000040 */
#define CAN_F10R1_FB6          CAN_F10R1_FB6_Msk                               /*!<Filter bit 6 */
#define CAN_F10R1_FB7_Pos      (7U)                                            
#define CAN_F10R1_FB7_Msk      (0x1U << CAN_F10R1_FB7_Pos)                     /*!< 0x00000080 */
#define CAN_F10R1_FB7          CAN_F10R1_FB7_Msk                               /*!<Filter bit 7 */
#define CAN_F10R1_FB8_Pos      (8U)                                            
#define CAN_F10R1_FB8_Msk      (0x1U << CAN_F10R1_FB8_Pos)                     /*!< 0x00000100 */
#define CAN_F10R1_FB8          CAN_F10R1_FB8_Msk                               /*!<Filter bit 8 */
#define CAN_F10R1_FB9_Pos      (9U)                                            
#define CAN_F10R1_FB9_Msk      (0x1U << CAN_F10R1_FB9_Pos)                     /*!< 0x00000200 */
#define CAN_F10R1_FB9          CAN_F10R1_FB9_Msk                               /*!<Filter bit 9 */
#define CAN_F10R1_FB10_Pos     (10U)                                           
#define CAN_F10R1_FB10_Msk     (0x1U << CAN_F10R1_FB10_Pos)                    /*!< 0x00000400 */
#define CAN_F10R1_FB10         CAN_F10R1_FB10_Msk                              /*!<Filter bit 10 */
#define CAN_F10R1_FB11_Pos     (11U)                                           
#define CAN_F10R1_FB11_Msk     (0x1U << CAN_F10R1_FB11_Pos)                    /*!< 0x00000800 */
#define CAN_F10R1_FB11         CAN_F10R1_FB11_Msk                              /*!<Filter bit 11 */
#define CAN_F10R1_FB12_Pos     (12U)                                           
#define CAN_F10R1_FB12_Msk     (0x1U << CAN_F10R1_FB12_Pos)                    /*!< 0x00001000 */
#define CAN_F10R1_FB12         CAN_F10R1_FB12_Msk                              /*!<Filter bit 12 */
#define CAN_F10R1_FB13_Pos     (13U)                                           
#define CAN_F10R1_FB13_Msk     (0x1U << CAN_F10R1_FB13_Pos)                    /*!< 0x00002000 */
#define CAN_F10R1_FB13         CAN_F10R1_FB13_Msk                              /*!<Filter bit 13 */
#define CAN_F10R1_FB14_Pos     (14U)                                           
#define CAN_F10R1_FB14_Msk     (0x1U << CAN_F10R1_FB14_Pos)                    /*!< 0x00004000 */
#define CAN_F10R1_FB14         CAN_F10R1_FB14_Msk                              /*!<Filter bit 14 */
#define CAN_F10R1_FB15_Pos     (15U)                                           
#define CAN_F10R1_FB15_Msk     (0x1U << CAN_F10R1_FB15_Pos)                    /*!< 0x00008000 */
#define CAN_F10R1_FB15         CAN_F10R1_FB15_Msk                              /*!<Filter bit 15 */
#define CAN_F10R1_FB16_Pos     (16U)                                           
#define CAN_F10R1_FB16_Msk     (0x1U << CAN_F10R1_FB16_Pos)                    /*!< 0x00010000 */
#define CAN_F10R1_FB16         CAN_F10R1_FB16_Msk                              /*!<Filter bit 16 */
#define CAN_F10R1_FB17_Pos     (17U)                                           
#define CAN_F10R1_FB17_Msk     (0x1U << CAN_F10R1_FB17_Pos)                    /*!< 0x00020000 */
#define CAN_F10R1_FB17         CAN_F10R1_FB17_Msk                              /*!<Filter bit 17 */
#define CAN_F10R1_FB18_Pos     (18U)                                           
#define CAN_F10R1_FB18_Msk     (0x1U << CAN_F10R1_FB18_Pos)                    /*!< 0x00040000 */
#define CAN_F10R1_FB18         CAN_F10R1_FB18_Msk                              /*!<Filter bit 18 */
#define CAN_F10R1_FB19_Pos     (19U)                                           
#define CAN_F10R1_FB19_Msk     (0x1U << CAN_F10R1_FB19_Pos)                    /*!< 0x00080000 */
#define CAN_F10R1_FB19         CAN_F10R1_FB19_Msk                              /*!<Filter bit 19 */
#define CAN_F10R1_FB20_Pos     (20U)                                           
#define CAN_F10R1_FB20_Msk     (0x1U << CAN_F10R1_FB20_Pos)                    /*!< 0x00100000 */
#define CAN_F10R1_FB20         CAN_F10R1_FB20_Msk                              /*!<Filter bit 20 */
#define CAN_F10R1_FB21_Pos     (21U)                                           
#define CAN_F10R1_FB21_Msk     (0x1U << CAN_F10R1_FB21_Pos)                    /*!< 0x00200000 */
#define CAN_F10R1_FB21         CAN_F10R1_FB21_Msk                              /*!<Filter bit 21 */
#define CAN_F10R1_FB22_Pos     (22U)                                           
#define CAN_F10R1_FB22_Msk     (0x1U << CAN_F10R1_FB22_Pos)                    /*!< 0x00400000 */
#define CAN_F10R1_FB22         CAN_F10R1_FB22_Msk                              /*!<Filter bit 22 */
#define CAN_F10R1_FB23_Pos     (23U)                                           
#define CAN_F10R1_FB23_Msk     (0x1U << CAN_F10R1_FB23_Pos)                    /*!< 0x00800000 */
#define CAN_F10R1_FB23         CAN_F10R1_FB23_Msk                              /*!<Filter bit 23 */
#define CAN_F10R1_FB24_Pos     (24U)                                           
#define CAN_F10R1_FB24_Msk     (0x1U << CAN_F10R1_FB24_Pos)                    /*!< 0x01000000 */
#define CAN_F10R1_FB24         CAN_F10R1_FB24_Msk                              /*!<Filter bit 24 */
#define CAN_F10R1_FB25_Pos     (25U)                                           
#define CAN_F10R1_FB25_Msk     (0x1U << CAN_F10R1_FB25_Pos)                    /*!< 0x02000000 */
#define CAN_F10R1_FB25         CAN_F10R1_FB25_Msk                              /*!<Filter bit 25 */
#define CAN_F10R1_FB26_Pos     (26U)                                           
#define CAN_F10R1_FB26_Msk     (0x1U << CAN_F10R1_FB26_Pos)                    /*!< 0x04000000 */
#define CAN_F10R1_FB26         CAN_F10R1_FB26_Msk                              /*!<Filter bit 26 */
#define CAN_F10R1_FB27_Pos     (27U)                                           
#define CAN_F10R1_FB27_Msk     (0x1U << CAN_F10R1_FB27_Pos)                    /*!< 0x08000000 */
#define CAN_F10R1_FB27         CAN_F10R1_FB27_Msk                              /*!<Filter bit 27 */
#define CAN_F10R1_FB28_Pos     (28U)                                           
#define CAN_F10R1_FB28_Msk     (0x1U << CAN_F10R1_FB28_Pos)                    /*!< 0x10000000 */
#define CAN_F10R1_FB28         CAN_F10R1_FB28_Msk                              /*!<Filter bit 28 */
#define CAN_F10R1_FB29_Pos     (29U)                                           
#define CAN_F10R1_FB29_Msk     (0x1U << CAN_F10R1_FB29_Pos)                    /*!< 0x20000000 */
#define CAN_F10R1_FB29         CAN_F10R1_FB29_Msk                              /*!<Filter bit 29 */
#define CAN_F10R1_FB30_Pos     (30U)                                           
#define CAN_F10R1_FB30_Msk     (0x1U << CAN_F10R1_FB30_Pos)                    /*!< 0x40000000 */
#define CAN_F10R1_FB30         CAN_F10R1_FB30_Msk                              /*!<Filter bit 30 */
#define CAN_F10R1_FB31_Pos     (31U)                                           
#define CAN_F10R1_FB31_Msk     (0x1U << CAN_F10R1_FB31_Pos)                    /*!< 0x80000000 */
#define CAN_F10R1_FB31         CAN_F10R1_FB31_Msk                              /*!<Filter bit 31 */

/*******************  Bit definition for CAN_F11R1 register  ******************/
#define CAN_F11R1_FB0_Pos      (0U)                                            
#define CAN_F11R1_FB0_Msk      (0x1U << CAN_F11R1_FB0_Pos)                     /*!< 0x00000001 */
#define CAN_F11R1_FB0          CAN_F11R1_FB0_Msk                               /*!<Filter bit 0 */
#define CAN_F11R1_FB1_Pos      (1U)                                            
#define CAN_F11R1_FB1_Msk      (0x1U << CAN_F11R1_FB1_Pos)                     /*!< 0x00000002 */
#define CAN_F11R1_FB1          CAN_F11R1_FB1_Msk                               /*!<Filter bit 1 */
#define CAN_F11R1_FB2_Pos      (2U)                                            
#define CAN_F11R1_FB2_Msk      (0x1U << CAN_F11R1_FB2_Pos)                     /*!< 0x00000004 */
#define CAN_F11R1_FB2          CAN_F11R1_FB2_Msk                               /*!<Filter bit 2 */
#define CAN_F11R1_FB3_Pos      (3U)                                            
#define CAN_F11R1_FB3_Msk      (0x1U << CAN_F11R1_FB3_Pos)                     /*!< 0x00000008 */
#define CAN_F11R1_FB3          CAN_F11R1_FB3_Msk                               /*!<Filter bit 3 */
#define CAN_F11R1_FB4_Pos      (4U)                                            
#define CAN_F11R1_FB4_Msk      (0x1U << CAN_F11R1_FB4_Pos)                     /*!< 0x00000010 */
#define CAN_F11R1_FB4          CAN_F11R1_FB4_Msk                               /*!<Filter bit 4 */
#define CAN_F11R1_FB5_Pos      (5U)                                            
#define CAN_F11R1_FB5_Msk      (0x1U << CAN_F11R1_FB5_Pos)                     /*!< 0x00000020 */
#define CAN_F11R1_FB5          CAN_F11R1_FB5_Msk                               /*!<Filter bit 5 */
#define CAN_F11R1_FB6_Pos      (6U)                                            
#define CAN_F11R1_FB6_Msk      (0x1U << CAN_F11R1_FB6_Pos)                     /*!< 0x00000040 */
#define CAN_F11R1_FB6          CAN_F11R1_FB6_Msk                               /*!<Filter bit 6 */
#define CAN_F11R1_FB7_Pos      (7U)                                            
#define CAN_F11R1_FB7_Msk      (0x1U << CAN_F11R1_FB7_Pos)                     /*!< 0x00000080 */
#define CAN_F11R1_FB7          CAN_F11R1_FB7_Msk                               /*!<Filter bit 7 */
#define CAN_F11R1_FB8_Pos      (8U)                                            
#define CAN_F11R1_FB8_Msk      (0x1U << CAN_F11R1_FB8_Pos)                     /*!< 0x00000100 */
#define CAN_F11R1_FB8          CAN_F11R1_FB8_Msk                               /*!<Filter bit 8 */
#define CAN_F11R1_FB9_Pos      (9U)                                            
#define CAN_F11R1_FB9_Msk      (0x1U << CAN_F11R1_FB9_Pos)                     /*!< 0x00000200 */
#define CAN_F11R1_FB9          CAN_F11R1_FB9_Msk                               /*!<Filter bit 9 */
#define CAN_F11R1_FB10_Pos     (10U)                                           
#define CAN_F11R1_FB10_Msk     (0x1U << CAN_F11R1_FB10_Pos)                    /*!< 0x00000400 */
#define CAN_F11R1_FB10         CAN_F11R1_FB10_Msk                              /*!<Filter bit 10 */
#define CAN_F11R1_FB11_Pos     (11U)                                           
#define CAN_F11R1_FB11_Msk     (0x1U << CAN_F11R1_FB11_Pos)                    /*!< 0x00000800 */
#define CAN_F11R1_FB11         CAN_F11R1_FB11_Msk                              /*!<Filter bit 11 */
#define CAN_F11R1_FB12_Pos     (12U)                                           
#define CAN_F11R1_FB12_Msk     (0x1U << CAN_F11R1_FB12_Pos)                    /*!< 0x00001000 */
#define CAN_F11R1_FB12         CAN_F11R1_FB12_Msk                              /*!<Filter bit 12 */
#define CAN_F11R1_FB13_Pos     (13U)                                           
#define CAN_F11R1_FB13_Msk     (0x1U << CAN_F11R1_FB13_Pos)                    /*!< 0x00002000 */
#define CAN_F11R1_FB13         CAN_F11R1_FB13_Msk                              /*!<Filter bit 13 */
#define CAN_F11R1_FB14_Pos     (14U)                                           
#define CAN_F11R1_FB14_Msk     (0x1U << CAN_F11R1_FB14_Pos)                    /*!< 0x00004000 */
#define CAN_F11R1_FB14         CAN_F11R1_FB14_Msk                              /*!<Filter bit 14 */
#define CAN_F11R1_FB15_Pos     (15U)                                           
#define CAN_F11R1_FB15_Msk     (0x1U << CAN_F11R1_FB15_Pos)                    /*!< 0x00008000 */
#define CAN_F11R1_FB15         CAN_F11R1_FB15_Msk                              /*!<Filter bit 15 */
#define CAN_F11R1_FB16_Pos     (16U)                                           
#define CAN_F11R1_FB16_Msk     (0x1U << CAN_F11R1_FB16_Pos)                    /*!< 0x00010000 */
#define CAN_F11R1_FB16         CAN_F11R1_FB16_Msk                              /*!<Filter bit 16 */
#define CAN_F11R1_FB17_Pos     (17U)                                           
#define CAN_F11R1_FB17_Msk     (0x1U << CAN_F11R1_FB17_Pos)                    /*!< 0x00020000 */
#define CAN_F11R1_FB17         CAN_F11R1_FB17_Msk                              /*!<Filter bit 17 */
#define CAN_F11R1_FB18_Pos     (18U)                                           
#define CAN_F11R1_FB18_Msk     (0x1U << CAN_F11R1_FB18_Pos)                    /*!< 0x00040000 */
#define CAN_F11R1_FB18         CAN_F11R1_FB18_Msk                              /*!<Filter bit 18 */
#define CAN_F11R1_FB19_Pos     (19U)                                           
#define CAN_F11R1_FB19_Msk     (0x1U << CAN_F11R1_FB19_Pos)                    /*!< 0x00080000 */
#define CAN_F11R1_FB19         CAN_F11R1_FB19_Msk                              /*!<Filter bit 19 */
#define CAN_F11R1_FB20_Pos     (20U)                                           
#define CAN_F11R1_FB20_Msk     (0x1U << CAN_F11R1_FB20_Pos)                    /*!< 0x00100000 */
#define CAN_F11R1_FB20         CAN_F11R1_FB20_Msk                              /*!<Filter bit 20 */
#define CAN_F11R1_FB21_Pos     (21U)                                           
#define CAN_F11R1_FB21_Msk     (0x1U << CAN_F11R1_FB21_Pos)                    /*!< 0x00200000 */
#define CAN_F11R1_FB21         CAN_F11R1_FB21_Msk                              /*!<Filter bit 21 */
#define CAN_F11R1_FB22_Pos     (22U)                                           
#define CAN_F11R1_FB22_Msk     (0x1U << CAN_F11R1_FB22_Pos)                    /*!< 0x00400000 */
#define CAN_F11R1_FB22         CAN_F11R1_FB22_Msk                              /*!<Filter bit 22 */
#define CAN_F11R1_FB23_Pos     (23U)                                           
#define CAN_F11R1_FB23_Msk     (0x1U << CAN_F11R1_FB23_Pos)                    /*!< 0x00800000 */
#define CAN_F11R1_FB23         CAN_F11R1_FB23_Msk                              /*!<Filter bit 23 */
#define CAN_F11R1_FB24_Pos     (24U)                                           
#define CAN_F11R1_FB24_Msk     (0x1U << CAN_F11R1_FB24_Pos)                    /*!< 0x01000000 */
#define CAN_F11R1_FB24         CAN_F11R1_FB24_Msk                              /*!<Filter bit 24 */
#define CAN_F11R1_FB25_Pos     (25U)                                           
#define CAN_F11R1_FB25_Msk     (0x1U << CAN_F11R1_FB25_Pos)                    /*!< 0x02000000 */
#define CAN_F11R1_FB25         CAN_F11R1_FB25_Msk                              /*!<Filter bit 25 */
#define CAN_F11R1_FB26_Pos     (26U)                                           
#define CAN_F11R1_FB26_Msk     (0x1U << CAN_F11R1_FB26_Pos)                    /*!< 0x04000000 */
#define CAN_F11R1_FB26         CAN_F11R1_FB26_Msk                              /*!<Filter bit 26 */
#define CAN_F11R1_FB27_Pos     (27U)                                           
#define CAN_F11R1_FB27_Msk     (0x1U << CAN_F11R1_FB27_Pos)                    /*!< 0x08000000 */
#define CAN_F11R1_FB27         CAN_F11R1_FB27_Msk                              /*!<Filter bit 27 */
#define CAN_F11R1_FB28_Pos     (28U)                                           
#define CAN_F11R1_FB28_Msk     (0x1U << CAN_F11R1_FB28_Pos)                    /*!< 0x10000000 */
#define CAN_F11R1_FB28         CAN_F11R1_FB28_Msk                              /*!<Filter bit 28 */
#define CAN_F11R1_FB29_Pos     (29U)                                           
#define CAN_F11R1_FB29_Msk     (0x1U << CAN_F11R1_FB29_Pos)                    /*!< 0x20000000 */
#define CAN_F11R1_FB29         CAN_F11R1_FB29_Msk                              /*!<Filter bit 29 */
#define CAN_F11R1_FB30_Pos     (30U)                                           
#define CAN_F11R1_FB30_Msk     (0x1U << CAN_F11R1_FB30_Pos)                    /*!< 0x40000000 */
#define CAN_F11R1_FB30         CAN_F11R1_FB30_Msk                              /*!<Filter bit 30 */
#define CAN_F11R1_FB31_Pos     (31U)                                           
#define CAN_F11R1_FB31_Msk     (0x1U << CAN_F11R1_FB31_Pos)                    /*!< 0x80000000 */
#define CAN_F11R1_FB31         CAN_F11R1_FB31_Msk                              /*!<Filter bit 31 */

/*******************  Bit definition for CAN_F12R1 register  ******************/
#define CAN_F12R1_FB0_Pos      (0U)                                            
#define CAN_F12R1_FB0_Msk      (0x1U << CAN_F12R1_FB0_Pos)                     /*!< 0x00000001 */
#define CAN_F12R1_FB0          CAN_F12R1_FB0_Msk                               /*!<Filter bit 0 */
#define CAN_F12R1_FB1_Pos      (1U)                                            
#define CAN_F12R1_FB1_Msk      (0x1U << CAN_F12R1_FB1_Pos)                     /*!< 0x00000002 */
#define CAN_F12R1_FB1          CAN_F12R1_FB1_Msk                               /*!<Filter bit 1 */
#define CAN_F12R1_FB2_Pos      (2U)                                            
#define CAN_F12R1_FB2_Msk      (0x1U << CAN_F12R1_FB2_Pos)                     /*!< 0x00000004 */
#define CAN_F12R1_FB2          CAN_F12R1_FB2_Msk                               /*!<Filter bit 2 */
#define CAN_F12R1_FB3_Pos      (3U)                                            
#define CAN_F12R1_FB3_Msk      (0x1U << CAN_F12R1_FB3_Pos)                     /*!< 0x00000008 */
#define CAN_F12R1_FB3          CAN_F12R1_FB3_Msk                               /*!<Filter bit 3 */
#define CAN_F12R1_FB4_Pos      (4U)                                            
#define CAN_F12R1_FB4_Msk      (0x1U << CAN_F12R1_FB4_Pos)                     /*!< 0x00000010 */
#define CAN_F12R1_FB4          CAN_F12R1_FB4_Msk                               /*!<Filter bit 4 */
#define CAN_F12R1_FB5_Pos      (5U)                                            
#define CAN_F12R1_FB5_Msk      (0x1U << CAN_F12R1_FB5_Pos)                     /*!< 0x00000020 */
#define CAN_F12R1_FB5          CAN_F12R1_FB5_Msk                               /*!<Filter bit 5 */
#define CAN_F12R1_FB6_Pos      (6U)                                            
#define CAN_F12R1_FB6_Msk      (0x1U << CAN_F12R1_FB6_Pos)                     /*!< 0x00000040 */
#define CAN_F12R1_FB6          CAN_F12R1_FB6_Msk                               /*!<Filter bit 6 */
#define CAN_F12R1_FB7_Pos      (7U)                                            
#define CAN_F12R1_FB7_Msk      (0x1U << CAN_F12R1_FB7_Pos)                     /*!< 0x00000080 */
#define CAN_F12R1_FB7          CAN_F12R1_FB7_Msk                               /*!<Filter bit 7 */
#define CAN_F12R1_FB8_Pos      (8U)                                            
#define CAN_F12R1_FB8_Msk      (0x1U << CAN_F12R1_FB8_Pos)                     /*!< 0x00000100 */
#define CAN_F12R1_FB8          CAN_F12R1_FB8_Msk                               /*!<Filter bit 8 */
#define CAN_F12R1_FB9_Pos      (9U)                                            
#define CAN_F12R1_FB9_Msk      (0x1U << CAN_F12R1_FB9_Pos)                     /*!< 0x00000200 */
#define CAN_F12R1_FB9          CAN_F12R1_FB9_Msk                               /*!<Filter bit 9 */
#define CAN_F12R1_FB10_Pos     (10U)                                           
#define CAN_F12R1_FB10_Msk     (0x1U << CAN_F12R1_FB10_Pos)                    /*!< 0x00000400 */
#define CAN_F12R1_FB10         CAN_F12R1_FB10_Msk                              /*!<Filter bit 10 */
#define CAN_F12R1_FB11_Pos     (11U)                                           
#define CAN_F12R1_FB11_Msk     (0x1U << CAN_F12R1_FB11_Pos)                    /*!< 0x00000800 */
#define CAN_F12R1_FB11         CAN_F12R1_FB11_Msk                              /*!<Filter bit 11 */
#define CAN_F12R1_FB12_Pos     (12U)                                           
#define CAN_F12R1_FB12_Msk     (0x1U << CAN_F12R1_FB12_Pos)                    /*!< 0x00001000 */
#define CAN_F12R1_FB12         CAN_F12R1_FB12_Msk                              /*!<Filter bit 12 */
#define CAN_F12R1_FB13_Pos     (13U)                                           
#define CAN_F12R1_FB13_Msk     (0x1U << CAN_F12R1_FB13_Pos)                    /*!< 0x00002000 */
#define CAN_F12R1_FB13         CAN_F12R1_FB13_Msk                              /*!<Filter bit 13 */
#define CAN_F12R1_FB14_Pos     (14U)                                           
#define CAN_F12R1_FB14_Msk     (0x1U << CAN_F12R1_FB14_Pos)                    /*!< 0x00004000 */
#define CAN_F12R1_FB14         CAN_F12R1_FB14_Msk                              /*!<Filter bit 14 */
#define CAN_F12R1_FB15_Pos     (15U)                                           
#define CAN_F12R1_FB15_Msk     (0x1U << CAN_F12R1_FB15_Pos)                    /*!< 0x00008000 */
#define CAN_F12R1_FB15         CAN_F12R1_FB15_Msk                              /*!<Filter bit 15 */
#define CAN_F12R1_FB16_Pos     (16U)                                           
#define CAN_F12R1_FB16_Msk     (0x1U << CAN_F12R1_FB16_Pos)                    /*!< 0x00010000 */
#define CAN_F12R1_FB16         CAN_F12R1_FB16_Msk                              /*!<Filter bit 16 */
#define CAN_F12R1_FB17_Pos     (17U)                                           
#define CAN_F12R1_FB17_Msk     (0x1U << CAN_F12R1_FB17_Pos)                    /*!< 0x00020000 */
#define CAN_F12R1_FB17         CAN_F12R1_FB17_Msk                              /*!<Filter bit 17 */
#define CAN_F12R1_FB18_Pos     (18U)                                           
#define CAN_F12R1_FB18_Msk     (0x1U << CAN_F12R1_FB18_Pos)                    /*!< 0x00040000 */
#define CAN_F12R1_FB18         CAN_F12R1_FB18_Msk                              /*!<Filter bit 18 */
#define CAN_F12R1_FB19_Pos     (19U)                                           
#define CAN_F12R1_FB19_Msk     (0x1U << CAN_F12R1_FB19_Pos)                    /*!< 0x00080000 */
#define CAN_F12R1_FB19         CAN_F12R1_FB19_Msk                              /*!<Filter bit 19 */
#define CAN_F12R1_FB20_Pos     (20U)                                           
#define CAN_F12R1_FB20_Msk     (0x1U << CAN_F12R1_FB20_Pos)                    /*!< 0x00100000 */
#define CAN_F12R1_FB20         CAN_F12R1_FB20_Msk                              /*!<Filter bit 20 */
#define CAN_F12R1_FB21_Pos     (21U)                                           
#define CAN_F12R1_FB21_Msk     (0x1U << CAN_F12R1_FB21_Pos)                    /*!< 0x00200000 */
#define CAN_F12R1_FB21         CAN_F12R1_FB21_Msk                              /*!<Filter bit 21 */
#define CAN_F12R1_FB22_Pos     (22U)                                           
#define CAN_F12R1_FB22_Msk     (0x1U << CAN_F12R1_FB22_Pos)                    /*!< 0x00400000 */
#define CAN_F12R1_FB22         CAN_F12R1_FB22_Msk                              /*!<Filter bit 22 */
#define CAN_F12R1_FB23_Pos     (23U)                                           
#define CAN_F12R1_FB23_Msk     (0x1U << CAN_F12R1_FB23_Pos)                    /*!< 0x00800000 */
#define CAN_F12R1_FB23         CAN_F12R1_FB23_Msk                              /*!<Filter bit 23 */
#define CAN_F12R1_FB24_Pos     (24U)                                           
#define CAN_F12R1_FB24_Msk     (0x1U << CAN_F12R1_FB24_Pos)                    /*!< 0x01000000 */
#define CAN_F12R1_FB24         CAN_F12R1_FB24_Msk                              /*!<Filter bit 24 */
#define CAN_F12R1_FB25_Pos     (25U)                                           
#define CAN_F12R1_FB25_Msk     (0x1U << CAN_F12R1_FB25_Pos)                    /*!< 0x02000000 */
#define CAN_F12R1_FB25         CAN_F12R1_FB25_Msk                              /*!<Filter bit 25 */
#define CAN_F12R1_FB26_Pos     (26U)                                           
#define CAN_F12R1_FB26_Msk     (0x1U << CAN_F12R1_FB26_Pos)                    /*!< 0x04000000 */
#define CAN_F12R1_FB26         CAN_F12R1_FB26_Msk                              /*!<Filter bit 26 */
#define CAN_F12R1_FB27_Pos     (27U)                                           
#define CAN_F12R1_FB27_Msk     (0x1U << CAN_F12R1_FB27_Pos)                    /*!< 0x08000000 */
#define CAN_F12R1_FB27         CAN_F12R1_FB27_Msk                              /*!<Filter bit 27 */
#define CAN_F12R1_FB28_Pos     (28U)                                           
#define CAN_F12R1_FB28_Msk     (0x1U << CAN_F12R1_FB28_Pos)                    /*!< 0x10000000 */
#define CAN_F12R1_FB28         CAN_F12R1_FB28_Msk                              /*!<Filter bit 28 */
#define CAN_F12R1_FB29_Pos     (29U)                                           
#define CAN_F12R1_FB29_Msk     (0x1U << CAN_F12R1_FB29_Pos)                    /*!< 0x20000000 */
#define CAN_F12R1_FB29         CAN_F12R1_FB29_Msk                              /*!<Filter bit 29 */
#define CAN_F12R1_FB30_Pos     (30U)                                           
#define CAN_F12R1_FB30_Msk     (0x1U << CAN_F12R1_FB30_Pos)                    /*!< 0x40000000 */
#define CAN_F12R1_FB30         CAN_F12R1_FB30_Msk                              /*!<Filter bit 30 */
#define CAN_F12R1_FB31_Pos     (31U)                                           
#define CAN_F12R1_FB31_Msk     (0x1U << CAN_F12R1_FB31_Pos)                    /*!< 0x80000000 */
#define CAN_F12R1_FB31         CAN_F12R1_FB31_Msk                              /*!<Filter bit 31 */

/*******************  Bit definition for CAN_F13R1 register  ******************/
#define CAN_F13R1_FB0_Pos      (0U)                                            
#define CAN_F13R1_FB0_Msk      (0x1U << CAN_F13R1_FB0_Pos)                     /*!< 0x00000001 */
#define CAN_F13R1_FB0          CAN_F13R1_FB0_Msk                               /*!<Filter bit 0 */
#define CAN_F13R1_FB1_Pos      (1U)                                            
#define CAN_F13R1_FB1_Msk      (0x1U << CAN_F13R1_FB1_Pos)                     /*!< 0x00000002 */
#define CAN_F13R1_FB1          CAN_F13R1_FB1_Msk                               /*!<Filter bit 1 */
#define CAN_F13R1_FB2_Pos      (2U)                                            
#define CAN_F13R1_FB2_Msk      (0x1U << CAN_F13R1_FB2_Pos)                     /*!< 0x00000004 */
#define CAN_F13R1_FB2          CAN_F13R1_FB2_Msk                               /*!<Filter bit 2 */
#define CAN_F13R1_FB3_Pos      (3U)                                            
#define CAN_F13R1_FB3_Msk      (0x1U << CAN_F13R1_FB3_Pos)                     /*!< 0x00000008 */
#define CAN_F13R1_FB3          CAN_F13R1_FB3_Msk                               /*!<Filter bit 3 */
#define CAN_F13R1_FB4_Pos      (4U)                                            
#define CAN_F13R1_FB4_Msk      (0x1U << CAN_F13R1_FB4_Pos)                     /*!< 0x00000010 */
#define CAN_F13R1_FB4          CAN_F13R1_FB4_Msk                               /*!<Filter bit 4 */
#define CAN_F13R1_FB5_Pos      (5U)                                            
#define CAN_F13R1_FB5_Msk      (0x1U << CAN_F13R1_FB5_Pos)                     /*!< 0x00000020 */
#define CAN_F13R1_FB5          CAN_F13R1_FB5_Msk                               /*!<Filter bit 5 */
#define CAN_F13R1_FB6_Pos      (6U)                                            
#define CAN_F13R1_FB6_Msk      (0x1U << CAN_F13R1_FB6_Pos)                     /*!< 0x00000040 */
#define CAN_F13R1_FB6          CAN_F13R1_FB6_Msk                               /*!<Filter bit 6 */
#define CAN_F13R1_FB7_Pos      (7U)                                            
#define CAN_F13R1_FB7_Msk      (0x1U << CAN_F13R1_FB7_Pos)                     /*!< 0x00000080 */
#define CAN_F13R1_FB7          CAN_F13R1_FB7_Msk                               /*!<Filter bit 7 */
#define CAN_F13R1_FB8_Pos      (8U)                                            
#define CAN_F13R1_FB8_Msk      (0x1U << CAN_F13R1_FB8_Pos)                     /*!< 0x00000100 */
#define CAN_F13R1_FB8          CAN_F13R1_FB8_Msk                               /*!<Filter bit 8 */
#define CAN_F13R1_FB9_Pos      (9U)                                            
#define CAN_F13R1_FB9_Msk      (0x1U << CAN_F13R1_FB9_Pos)                     /*!< 0x00000200 */
#define CAN_F13R1_FB9          CAN_F13R1_FB9_Msk                               /*!<Filter bit 9 */
#define CAN_F13R1_FB10_Pos     (10U)                                           
#define CAN_F13R1_FB10_Msk     (0x1U << CAN_F13R1_FB10_Pos)                    /*!< 0x00000400 */
#define CAN_F13R1_FB10         CAN_F13R1_FB10_Msk                              /*!<Filter bit 10 */
#define CAN_F13R1_FB11_Pos     (11U)                                           
#define CAN_F13R1_FB11_Msk     (0x1U << CAN_F13R1_FB11_Pos)                    /*!< 0x00000800 */
#define CAN_F13R1_FB11         CAN_F13R1_FB11_Msk                              /*!<Filter bit 11 */
#define CAN_F13R1_FB12_Pos     (12U)                                           
#define CAN_F13R1_FB12_Msk     (0x1U << CAN_F13R1_FB12_Pos)                    /*!< 0x00001000 */
#define CAN_F13R1_FB12         CAN_F13R1_FB12_Msk                              /*!<Filter bit 12 */
#define CAN_F13R1_FB13_Pos     (13U)                                           
#define CAN_F13R1_FB13_Msk     (0x1U << CAN_F13R1_FB13_Pos)                    /*!< 0x00002000 */
#define CAN_F13R1_FB13         CAN_F13R1_FB13_Msk                              /*!<Filter bit 13 */
#define CAN_F13R1_FB14_Pos     (14U)                                           
#define CAN_F13R1_FB14_Msk     (0x1U << CAN_F13R1_FB14_Pos)                    /*!< 0x00004000 */
#define CAN_F13R1_FB14         CAN_F13R1_FB14_Msk                              /*!<Filter bit 14 */
#define CAN_F13R1_FB15_Pos     (15U)                                           
#define CAN_F13R1_FB15_Msk     (0x1U << CAN_F13R1_FB15_Pos)                    /*!< 0x00008000 */
#define CAN_F13R1_FB15         CAN_F13R1_FB15_Msk                              /*!<Filter bit 15 */
#define CAN_F13R1_FB16_Pos     (16U)                                           
#define CAN_F13R1_FB16_Msk     (0x1U << CAN_F13R1_FB16_Pos)                    /*!< 0x00010000 */
#define CAN_F13R1_FB16         CAN_F13R1_FB16_Msk                              /*!<Filter bit 16 */
#define CAN_F13R1_FB17_Pos     (17U)                                           
#define CAN_F13R1_FB17_Msk     (0x1U << CAN_F13R1_FB17_Pos)                    /*!< 0x00020000 */
#define CAN_F13R1_FB17         CAN_F13R1_FB17_Msk                              /*!<Filter bit 17 */
#define CAN_F13R1_FB18_Pos     (18U)                                           
#define CAN_F13R1_FB18_Msk     (0x1U << CAN_F13R1_FB18_Pos)                    /*!< 0x00040000 */
#define CAN_F13R1_FB18         CAN_F13R1_FB18_Msk                              /*!<Filter bit 18 */
#define CAN_F13R1_FB19_Pos     (19U)                                           
#define CAN_F13R1_FB19_Msk     (0x1U << CAN_F13R1_FB19_Pos)                    /*!< 0x00080000 */
#define CAN_F13R1_FB19         CAN_F13R1_FB19_Msk                              /*!<Filter bit 19 */
#define CAN_F13R1_FB20_Pos     (20U)                                           
#define CAN_F13R1_FB20_Msk     (0x1U << CAN_F13R1_FB20_Pos)                    /*!< 0x00100000 */
#define CAN_F13R1_FB20         CAN_F13R1_FB20_Msk                              /*!<Filter bit 20 */
#define CAN_F13R1_FB21_Pos     (21U)                                           
#define CAN_F13R1_FB21_Msk     (0x1U << CAN_F13R1_FB21_Pos)                    /*!< 0x00200000 */
#define CAN_F13R1_FB21         CAN_F13R1_FB21_Msk                              /*!<Filter bit 21 */
#define CAN_F13R1_FB22_Pos     (22U)                                           
#define CAN_F13R1_FB22_Msk     (0x1U << CAN_F13R1_FB22_Pos)                    /*!< 0x00400000 */
#define CAN_F13R1_FB22         CAN_F13R1_FB22_Msk                              /*!<Filter bit 22 */
#define CAN_F13R1_FB23_Pos     (23U)                                           
#define CAN_F13R1_FB23_Msk     (0x1U << CAN_F13R1_FB23_Pos)                    /*!< 0x00800000 */
#define CAN_F13R1_FB23         CAN_F13R1_FB23_Msk                              /*!<Filter bit 23 */
#define CAN_F13R1_FB24_Pos     (24U)                                           
#define CAN_F13R1_FB24_Msk     (0x1U << CAN_F13R1_FB24_Pos)                    /*!< 0x01000000 */
#define CAN_F13R1_FB24         CAN_F13R1_FB24_Msk                              /*!<Filter bit 24 */
#define CAN_F13R1_FB25_Pos     (25U)                                           
#define CAN_F13R1_FB25_Msk     (0x1U << CAN_F13R1_FB25_Pos)                    /*!< 0x02000000 */
#define CAN_F13R1_FB25         CAN_F13R1_FB25_Msk                              /*!<Filter bit 25 */
#define CAN_F13R1_FB26_Pos     (26U)                                           
#define CAN_F13R1_FB26_Msk     (0x1U << CAN_F13R1_FB26_Pos)                    /*!< 0x04000000 */
#define CAN_F13R1_FB26         CAN_F13R1_FB26_Msk                              /*!<Filter bit 26 */
#define CAN_F13R1_FB27_Pos     (27U)                                           
#define CAN_F13R1_FB27_Msk     (0x1U << CAN_F13R1_FB27_Pos)                    /*!< 0x08000000 */
#define CAN_F13R1_FB27         CAN_F13R1_FB27_Msk                              /*!<Filter bit 27 */
#define CAN_F13R1_FB28_Pos     (28U)                                           
#define CAN_F13R1_FB28_Msk     (0x1U << CAN_F13R1_FB28_Pos)                    /*!< 0x10000000 */
#define CAN_F13R1_FB28         CAN_F13R1_FB28_Msk                              /*!<Filter bit 28 */
#define CAN_F13R1_FB29_Pos     (29U)                                           
#define CAN_F13R1_FB29_Msk     (0x1U << CAN_F13R1_FB29_Pos)                    /*!< 0x20000000 */
#define CAN_F13R1_FB29         CAN_F13R1_FB29_Msk                              /*!<Filter bit 29 */
#define CAN_F13R1_FB30_Pos     (30U)                                           
#define CAN_F13R1_FB30_Msk     (0x1U << CAN_F13R1_FB30_Pos)                    /*!< 0x40000000 */
#define CAN_F13R1_FB30         CAN_F13R1_FB30_Msk                              /*!<Filter bit 30 */
#define CAN_F13R1_FB31_Pos     (31U)                                           
#define CAN_F13R1_FB31_Msk     (0x1U << CAN_F13R1_FB31_Pos)                    /*!< 0x80000000 */
#define CAN_F13R1_FB31         CAN_F13R1_FB31_Msk                              /*!<Filter bit 31 */

/*******************  Bit definition for CAN_F0R2 register  *******************/
#define CAN_F0R2_FB0_Pos       (0U)                                            
#define CAN_F0R2_FB0_Msk       (0x1U << CAN_F0R2_FB0_Pos)                      /*!< 0x00000001 */
#define CAN_F0R2_FB0           CAN_F0R2_FB0_Msk                                /*!<Filter bit 0 */
#define CAN_F0R2_FB1_Pos       (1U)                                            
#define CAN_F0R2_FB1_Msk       (0x1U << CAN_F0R2_FB1_Pos)                      /*!< 0x00000002 */
#define CAN_F0R2_FB1           CAN_F0R2_FB1_Msk                                /*!<Filter bit 1 */
#define CAN_F0R2_FB2_Pos       (2U)                                            
#define CAN_F0R2_FB2_Msk       (0x1U << CAN_F0R2_FB2_Pos)                      /*!< 0x00000004 */
#define CAN_F0R2_FB2           CAN_F0R2_FB2_Msk                                /*!<Filter bit 2 */
#define CAN_F0R2_FB3_Pos       (3U)                                            
#define CAN_F0R2_FB3_Msk       (0x1U << CAN_F0R2_FB3_Pos)                      /*!< 0x00000008 */
#define CAN_F0R2_FB3           CAN_F0R2_FB3_Msk                                /*!<Filter bit 3 */
#define CAN_F0R2_FB4_Pos       (4U)                                            
#define CAN_F0R2_FB4_Msk       (0x1U << CAN_F0R2_FB4_Pos)                      /*!< 0x00000010 */
#define CAN_F0R2_FB4           CAN_F0R2_FB4_Msk                                /*!<Filter bit 4 */
#define CAN_F0R2_FB5_Pos       (5U)                                            
#define CAN_F0R2_FB5_Msk       (0x1U << CAN_F0R2_FB5_Pos)                      /*!< 0x00000020 */
#define CAN_F0R2_FB5           CAN_F0R2_FB5_Msk                                /*!<Filter bit 5 */
#define CAN_F0R2_FB6_Pos       (6U)                                            
#define CAN_F0R2_FB6_Msk       (0x1U << CAN_F0R2_FB6_Pos)                      /*!< 0x00000040 */
#define CAN_F0R2_FB6           CAN_F0R2_FB6_Msk                                /*!<Filter bit 6 */
#define CAN_F0R2_FB7_Pos       (7U)                                            
#define CAN_F0R2_FB7_Msk       (0x1U << CAN_F0R2_FB7_Pos)                      /*!< 0x00000080 */
#define CAN_F0R2_FB7           CAN_F0R2_FB7_Msk                                /*!<Filter bit 7 */
#define CAN_F0R2_FB8_Pos       (8U)                                            
#define CAN_F0R2_FB8_Msk       (0x1U << CAN_F0R2_FB8_Pos)                      /*!< 0x00000100 */
#define CAN_F0R2_FB8           CAN_F0R2_FB8_Msk                                /*!<Filter bit 8 */
#define CAN_F0R2_FB9_Pos       (9U)                                            
#define CAN_F0R2_FB9_Msk       (0x1U << CAN_F0R2_FB9_Pos)                      /*!< 0x00000200 */
#define CAN_F0R2_FB9           CAN_F0R2_FB9_Msk                                /*!<Filter bit 9 */
#define CAN_F0R2_FB10_Pos      (10U)                                           
#define CAN_F0R2_FB10_Msk      (0x1U << CAN_F0R2_FB10_Pos)                     /*!< 0x00000400 */
#define CAN_F0R2_FB10          CAN_F0R2_FB10_Msk                               /*!<Filter bit 10 */
#define CAN_F0R2_FB11_Pos      (11U)                                           
#define CAN_F0R2_FB11_Msk      (0x1U << CAN_F0R2_FB11_Pos)                     /*!< 0x00000800 */
#define CAN_F0R2_FB11          CAN_F0R2_FB11_Msk                               /*!<Filter bit 11 */
#define CAN_F0R2_FB12_Pos      (12U)                                           
#define CAN_F0R2_FB12_Msk      (0x1U << CAN_F0R2_FB12_Pos)                     /*!< 0x00001000 */
#define CAN_F0R2_FB12          CAN_F0R2_FB12_Msk                               /*!<Filter bit 12 */
#define CAN_F0R2_FB13_Pos      (13U)                                           
#define CAN_F0R2_FB13_Msk      (0x1U << CAN_F0R2_FB13_Pos)                     /*!< 0x00002000 */
#define CAN_F0R2_FB13          CAN_F0R2_FB13_Msk                               /*!<Filter bit 13 */
#define CAN_F0R2_FB14_Pos      (14U)                                           
#define CAN_F0R2_FB14_Msk      (0x1U << CAN_F0R2_FB14_Pos)                     /*!< 0x00004000 */
#define CAN_F0R2_FB14          CAN_F0R2_FB14_Msk                               /*!<Filter bit 14 */
#define CAN_F0R2_FB15_Pos      (15U)                                           
#define CAN_F0R2_FB15_Msk      (0x1U << CAN_F0R2_FB15_Pos)                     /*!< 0x00008000 */
#define CAN_F0R2_FB15          CAN_F0R2_FB15_Msk                               /*!<Filter bit 15 */
#define CAN_F0R2_FB16_Pos      (16U)                                           
#define CAN_F0R2_FB16_Msk      (0x1U << CAN_F0R2_FB16_Pos)                     /*!< 0x00010000 */
#define CAN_F0R2_FB16          CAN_F0R2_FB16_Msk                               /*!<Filter bit 16 */
#define CAN_F0R2_FB17_Pos      (17U)                                           
#define CAN_F0R2_FB17_Msk      (0x1U << CAN_F0R2_FB17_Pos)                     /*!< 0x00020000 */
#define CAN_F0R2_FB17          CAN_F0R2_FB17_Msk                               /*!<Filter bit 17 */
#define CAN_F0R2_FB18_Pos      (18U)                                           
#define CAN_F0R2_FB18_Msk      (0x1U << CAN_F0R2_FB18_Pos)                     /*!< 0x00040000 */
#define CAN_F0R2_FB18          CAN_F0R2_FB18_Msk                               /*!<Filter bit 18 */
#define CAN_F0R2_FB19_Pos      (19U)                                           
#define CAN_F0R2_FB19_Msk      (0x1U << CAN_F0R2_FB19_Pos)                     /*!< 0x00080000 */
#define CAN_F0R2_FB19          CAN_F0R2_FB19_Msk                               /*!<Filter bit 19 */
#define CAN_F0R2_FB20_Pos      (20U)                                           
#define CAN_F0R2_FB20_Msk      (0x1U << CAN_F0R2_FB20_Pos)                     /*!< 0x00100000 */
#define CAN_F0R2_FB20          CAN_F0R2_FB20_Msk                               /*!<Filter bit 20 */
#define CAN_F0R2_FB21_Pos      (21U)                                           
#define CAN_F0R2_FB21_Msk      (0x1U << CAN_F0R2_FB21_Pos)                     /*!< 0x00200000 */
#define CAN_F0R2_FB21          CAN_F0R2_FB21_Msk                               /*!<Filter bit 21 */
#define CAN_F0R2_FB22_Pos      (22U)                                           
#define CAN_F0R2_FB22_Msk      (0x1U << CAN_F0R2_FB22_Pos)                     /*!< 0x00400000 */
#define CAN_F0R2_FB22          CAN_F0R2_FB22_Msk                               /*!<Filter bit 22 */
#define CAN_F0R2_FB23_Pos      (23U)                                           
#define CAN_F0R2_FB23_Msk      (0x1U << CAN_F0R2_FB23_Pos)                     /*!< 0x00800000 */
#define CAN_F0R2_FB23          CAN_F0R2_FB23_Msk                               /*!<Filter bit 23 */
#define CAN_F0R2_FB24_Pos      (24U)                                           
#define CAN_F0R2_FB24_Msk      (0x1U << CAN_F0R2_FB24_Pos)                     /*!< 0x01000000 */
#define CAN_F0R2_FB24          CAN_F0R2_FB24_Msk                               /*!<Filter bit 24 */
#define CAN_F0R2_FB25_Pos      (25U)                                           
#define CAN_F0R2_FB25_Msk      (0x1U << CAN_F0R2_FB25_Pos)                     /*!< 0x02000000 */
#define CAN_F0R2_FB25          CAN_F0R2_FB25_Msk                               /*!<Filter bit 25 */
#define CAN_F0R2_FB26_Pos      (26U)                                           
#define CAN_F0R2_FB26_Msk      (0x1U << CAN_F0R2_FB26_Pos)                     /*!< 0x04000000 */
#define CAN_F0R2_FB26          CAN_F0R2_FB26_Msk                               /*!<Filter bit 26 */
#define CAN_F0R2_FB27_Pos      (27U)                                           
#define CAN_F0R2_FB27_Msk      (0x1U << CAN_F0R2_FB27_Pos)                     /*!< 0x08000000 */
#define CAN_F0R2_FB27          CAN_F0R2_FB27_Msk                               /*!<Filter bit 27 */
#define CAN_F0R2_FB28_Pos      (28U)                                           
#define CAN_F0R2_FB28_Msk      (0x1U << CAN_F0R2_FB28_Pos)                     /*!< 0x10000000 */
#define CAN_F0R2_FB28          CAN_F0R2_FB28_Msk                               /*!<Filter bit 28 */
#define CAN_F0R2_FB29_Pos      (29U)                                           
#define CAN_F0R2_FB29_Msk      (0x1U << CAN_F0R2_FB29_Pos)                     /*!< 0x20000000 */
#define CAN_F0R2_FB29          CAN_F0R2_FB29_Msk                               /*!<Filter bit 29 */
#define CAN_F0R2_FB30_Pos      (30U)                                           
#define CAN_F0R2_FB30_Msk      (0x1U << CAN_F0R2_FB30_Pos)                     /*!< 0x40000000 */
#define CAN_F0R2_FB30          CAN_F0R2_FB30_Msk                               /*!<Filter bit 30 */
#define CAN_F0R2_FB31_Pos      (31U)                                           
#define CAN_F0R2_FB31_Msk      (0x1U << CAN_F0R2_FB31_Pos)                     /*!< 0x80000000 */
#define CAN_F0R2_FB31          CAN_F0R2_FB31_Msk                               /*!<Filter bit 31 */

/*******************  Bit definition for CAN_F1R2 register  *******************/
#define CAN_F1R2_FB0_Pos       (0U)                                            
#define CAN_F1R2_FB0_Msk       (0x1U << CAN_F1R2_FB0_Pos)                      /*!< 0x00000001 */
#define CAN_F1R2_FB0           CAN_F1R2_FB0_Msk                                /*!<Filter bit 0 */
#define CAN_F1R2_FB1_Pos       (1U)                                            
#define CAN_F1R2_FB1_Msk       (0x1U << CAN_F1R2_FB1_Pos)                      /*!< 0x00000002 */
#define CAN_F1R2_FB1           CAN_F1R2_FB1_Msk                                /*!<Filter bit 1 */
#define CAN_F1R2_FB2_Pos       (2U)                                            
#define CAN_F1R2_FB2_Msk       (0x1U << CAN_F1R2_FB2_Pos)                      /*!< 0x00000004 */
#define CAN_F1R2_FB2           CAN_F1R2_FB2_Msk                                /*!<Filter bit 2 */
#define CAN_F1R2_FB3_Pos       (3U)                                            
#define CAN_F1R2_FB3_Msk       (0x1U << CAN_F1R2_FB3_Pos)                      /*!< 0x00000008 */
#define CAN_F1R2_FB3           CAN_F1R2_FB3_Msk                                /*!<Filter bit 3 */
#define CAN_F1R2_FB4_Pos       (4U)                                            
#define CAN_F1R2_FB4_Msk       (0x1U << CAN_F1R2_FB4_Pos)                      /*!< 0x00000010 */
#define CAN_F1R2_FB4           CAN_F1R2_FB4_Msk                                /*!<Filter bit 4 */
#define CAN_F1R2_FB5_Pos       (5U)                                            
#define CAN_F1R2_FB5_Msk       (0x1U << CAN_F1R2_FB5_Pos)                      /*!< 0x00000020 */
#define CAN_F1R2_FB5           CAN_F1R2_FB5_Msk                                /*!<Filter bit 5 */
#define CAN_F1R2_FB6_Pos       (6U)                                            
#define CAN_F1R2_FB6_Msk       (0x1U << CAN_F1R2_FB6_Pos)                      /*!< 0x00000040 */
#define CAN_F1R2_FB6           CAN_F1R2_FB6_Msk                                /*!<Filter bit 6 */
#define CAN_F1R2_FB7_Pos       (7U)                                            
#define CAN_F1R2_FB7_Msk       (0x1U << CAN_F1R2_FB7_Pos)                      /*!< 0x00000080 */
#define CAN_F1R2_FB7           CAN_F1R2_FB7_Msk                                /*!<Filter bit 7 */
#define CAN_F1R2_FB8_Pos       (8U)                                            
#define CAN_F1R2_FB8_Msk       (0x1U << CAN_F1R2_FB8_Pos)                      /*!< 0x00000100 */
#define CAN_F1R2_FB8           CAN_F1R2_FB8_Msk                                /*!<Filter bit 8 */
#define CAN_F1R2_FB9_Pos       (9U)                                            
#define CAN_F1R2_FB9_Msk       (0x1U << CAN_F1R2_FB9_Pos)                      /*!< 0x00000200 */
#define CAN_F1R2_FB9           CAN_F1R2_FB9_Msk                                /*!<Filter bit 9 */
#define CAN_F1R2_FB10_Pos      (10U)                                           
#define CAN_F1R2_FB10_Msk      (0x1U << CAN_F1R2_FB10_Pos)                     /*!< 0x00000400 */
#define CAN_F1R2_FB10          CAN_F1R2_FB10_Msk                               /*!<Filter bit 10 */
#define CAN_F1R2_FB11_Pos      (11U)                                           
#define CAN_F1R2_FB11_Msk      (0x1U << CAN_F1R2_FB11_Pos)                     /*!< 0x00000800 */
#define CAN_F1R2_FB11          CAN_F1R2_FB11_Msk                               /*!<Filter bit 11 */
#define CAN_F1R2_FB12_Pos      (12U)                                           
#define CAN_F1R2_FB12_Msk      (0x1U << CAN_F1R2_FB12_Pos)                     /*!< 0x00001000 */
#define CAN_F1R2_FB12          CAN_F1R2_FB12_Msk                               /*!<Filter bit 12 */
#define CAN_F1R2_FB13_Pos      (13U)                                           
#define CAN_F1R2_FB13_Msk      (0x1U << CAN_F1R2_FB13_Pos)                     /*!< 0x00002000 */
#define CAN_F1R2_FB13          CAN_F1R2_FB13_Msk                               /*!<Filter bit 13 */
#define CAN_F1R2_FB14_Pos      (14U)                                           
#define CAN_F1R2_FB14_Msk      (0x1U << CAN_F1R2_FB14_Pos)                     /*!< 0x00004000 */
#define CAN_F1R2_FB14          CAN_F1R2_FB14_Msk                               /*!<Filter bit 14 */
#define CAN_F1R2_FB15_Pos      (15U)                                           
#define CAN_F1R2_FB15_Msk      (0x1U << CAN_F1R2_FB15_Pos)                     /*!< 0x00008000 */
#define CAN_F1R2_FB15          CAN_F1R2_FB15_Msk                               /*!<Filter bit 15 */
#define CAN_F1R2_FB16_Pos      (16U)                                           
#define CAN_F1R2_FB16_Msk      (0x1U << CAN_F1R2_FB16_Pos)                     /*!< 0x00010000 */
#define CAN_F1R2_FB16          CAN_F1R2_FB16_Msk                               /*!<Filter bit 16 */
#define CAN_F1R2_FB17_Pos      (17U)                                           
#define CAN_F1R2_FB17_Msk      (0x1U << CAN_F1R2_FB17_Pos)                     /*!< 0x00020000 */
#define CAN_F1R2_FB17          CAN_F1R2_FB17_Msk                               /*!<Filter bit 17 */
#define CAN_F1R2_FB18_Pos      (18U)                                           
#define CAN_F1R2_FB18_Msk      (0x1U << CAN_F1R2_FB18_Pos)                     /*!< 0x00040000 */
#define CAN_F1R2_FB18          CAN_F1R2_FB18_Msk                               /*!<Filter bit 18 */
#define CAN_F1R2_FB19_Pos      (19U)                                           
#define CAN_F1R2_FB19_Msk      (0x1U << CAN_F1R2_FB19_Pos)                     /*!< 0x00080000 */
#define CAN_F1R2_FB19          CAN_F1R2_FB19_Msk                               /*!<Filter bit 19 */
#define CAN_F1R2_FB20_Pos      (20U)                                           
#define CAN_F1R2_FB20_Msk      (0x1U << CAN_F1R2_FB20_Pos)                     /*!< 0x00100000 */
#define CAN_F1R2_FB20          CAN_F1R2_FB20_Msk                               /*!<Filter bit 20 */
#define CAN_F1R2_FB21_Pos      (21U)                                           
#define CAN_F1R2_FB21_Msk      (0x1U << CAN_F1R2_FB21_Pos)                     /*!< 0x00200000 */
#define CAN_F1R2_FB21          CAN_F1R2_FB21_Msk                               /*!<Filter bit 21 */
#define CAN_F1R2_FB22_Pos      (22U)                                           
#define CAN_F1R2_FB22_Msk      (0x1U << CAN_F1R2_FB22_Pos)                     /*!< 0x00400000 */
#define CAN_F1R2_FB22          CAN_F1R2_FB22_Msk                               /*!<Filter bit 22 */
#define CAN_F1R2_FB23_Pos      (23U)                                           
#define CAN_F1R2_FB23_Msk      (0x1U << CAN_F1R2_FB23_Pos)                     /*!< 0x00800000 */
#define CAN_F1R2_FB23          CAN_F1R2_FB23_Msk                               /*!<Filter bit 23 */
#define CAN_F1R2_FB24_Pos      (24U)                                           
#define CAN_F1R2_FB24_Msk      (0x1U << CAN_F1R2_FB24_Pos)                     /*!< 0x01000000 */
#define CAN_F1R2_FB24          CAN_F1R2_FB24_Msk                               /*!<Filter bit 24 */
#define CAN_F1R2_FB25_Pos      (25U)                                           
#define CAN_F1R2_FB25_Msk      (0x1U << CAN_F1R2_FB25_Pos)                     /*!< 0x02000000 */
#define CAN_F1R2_FB25          CAN_F1R2_FB25_Msk                               /*!<Filter bit 25 */
#define CAN_F1R2_FB26_Pos      (26U)                                           
#define CAN_F1R2_FB26_Msk      (0x1U << CAN_F1R2_FB26_Pos)                     /*!< 0x04000000 */
#define CAN_F1R2_FB26          CAN_F1R2_FB26_Msk                               /*!<Filter bit 26 */
#define CAN_F1R2_FB27_Pos      (27U)                                           
#define CAN_F1R2_FB27_Msk      (0x1U << CAN_F1R2_FB27_Pos)                     /*!< 0x08000000 */
#define CAN_F1R2_FB27          CAN_F1R2_FB27_Msk                               /*!<Filter bit 27 */
#define CAN_F1R2_FB28_Pos      (28U)                                           
#define CAN_F1R2_FB28_Msk      (0x1U << CAN_F1R2_FB28_Pos)                     /*!< 0x10000000 */
#define CAN_F1R2_FB28          CAN_F1R2_FB28_Msk                               /*!<Filter bit 28 */
#define CAN_F1R2_FB29_Pos      (29U)                                           
#define CAN_F1R2_FB29_Msk      (0x1U << CAN_F1R2_FB29_Pos)                     /*!< 0x20000000 */
#define CAN_F1R2_FB29          CAN_F1R2_FB29_Msk                               /*!<Filter bit 29 */
#define CAN_F1R2_FB30_Pos      (30U)                                           
#define CAN_F1R2_FB30_Msk      (0x1U << CAN_F1R2_FB30_Pos)                     /*!< 0x40000000 */
#define CAN_F1R2_FB30          CAN_F1R2_FB30_Msk                               /*!<Filter bit 30 */
#define CAN_F1R2_FB31_Pos      (31U)                                           
#define CAN_F1R2_FB31_Msk      (0x1U << CAN_F1R2_FB31_Pos)                     /*!< 0x80000000 */
#define CAN_F1R2_FB31          CAN_F1R2_FB31_Msk                               /*!<Filter bit 31 */

/*******************  Bit definition for CAN_F2R2 register  *******************/
#define CAN_F2R2_FB0_Pos       (0U)                                            
#define CAN_F2R2_FB0_Msk       (0x1U << CAN_F2R2_FB0_Pos)                      /*!< 0x00000001 */
#define CAN_F2R2_FB0           CAN_F2R2_FB0_Msk                                /*!<Filter bit 0 */
#define CAN_F2R2_FB1_Pos       (1U)                                            
#define CAN_F2R2_FB1_Msk       (0x1U << CAN_F2R2_FB1_Pos)                      /*!< 0x00000002 */
#define CAN_F2R2_FB1           CAN_F2R2_FB1_Msk                                /*!<Filter bit 1 */
#define CAN_F2R2_FB2_Pos       (2U)                                            
#define CAN_F2R2_FB2_Msk       (0x1U << CAN_F2R2_FB2_Pos)                      /*!< 0x00000004 */
#define CAN_F2R2_FB2           CAN_F2R2_FB2_Msk                                /*!<Filter bit 2 */
#define CAN_F2R2_FB3_Pos       (3U)                                            
#define CAN_F2R2_FB3_Msk       (0x1U << CAN_F2R2_FB3_Pos)                      /*!< 0x00000008 */
#define CAN_F2R2_FB3           CAN_F2R2_FB3_Msk                                /*!<Filter bit 3 */
#define CAN_F2R2_FB4_Pos       (4U)                                            
#define CAN_F2R2_FB4_Msk       (0x1U << CAN_F2R2_FB4_Pos)                      /*!< 0x00000010 */
#define CAN_F2R2_FB4           CAN_F2R2_FB4_Msk                                /*!<Filter bit 4 */
#define CAN_F2R2_FB5_Pos       (5U)                                            
#define CAN_F2R2_FB5_Msk       (0x1U << CAN_F2R2_FB5_Pos)                      /*!< 0x00000020 */
#define CAN_F2R2_FB5           CAN_F2R2_FB5_Msk                                /*!<Filter bit 5 */
#define CAN_F2R2_FB6_Pos       (6U)                                            
#define CAN_F2R2_FB6_Msk       (0x1U << CAN_F2R2_FB6_Pos)                      /*!< 0x00000040 */
#define CAN_F2R2_FB6           CAN_F2R2_FB6_Msk                                /*!<Filter bit 6 */
#define CAN_F2R2_FB7_Pos       (7U)                                            
#define CAN_F2R2_FB7_Msk       (0x1U << CAN_F2R2_FB7_Pos)                      /*!< 0x00000080 */
#define CAN_F2R2_FB7           CAN_F2R2_FB7_Msk                                /*!<Filter bit 7 */
#define CAN_F2R2_FB8_Pos       (8U)                                            
#define CAN_F2R2_FB8_Msk       (0x1U << CAN_F2R2_FB8_Pos)                      /*!< 0x00000100 */
#define CAN_F2R2_FB8           CAN_F2R2_FB8_Msk                                /*!<Filter bit 8 */
#define CAN_F2R2_FB9_Pos       (9U)                                            
#define CAN_F2R2_FB9_Msk       (0x1U << CAN_F2R2_FB9_Pos)                      /*!< 0x00000200 */
#define CAN_F2R2_FB9           CAN_F2R2_FB9_Msk                                /*!<Filter bit 9 */
#define CAN_F2R2_FB10_Pos      (10U)                                           
#define CAN_F2R2_FB10_Msk      (0x1U << CAN_F2R2_FB10_Pos)                     /*!< 0x00000400 */
#define CAN_F2R2_FB10          CAN_F2R2_FB10_Msk                               /*!<Filter bit 10 */
#define CAN_F2R2_FB11_Pos      (11U)                                           
#define CAN_F2R2_FB11_Msk      (0x1U << CAN_F2R2_FB11_Pos)                     /*!< 0x00000800 */
#define CAN_F2R2_FB11          CAN_F2R2_FB11_Msk                               /*!<Filter bit 11 */
#define CAN_F2R2_FB12_Pos      (12U)                                           
#define CAN_F2R2_FB12_Msk      (0x1U << CAN_F2R2_FB12_Pos)                     /*!< 0x00001000 */
#define CAN_F2R2_FB12          CAN_F2R2_FB12_Msk                               /*!<Filter bit 12 */
#define CAN_F2R2_FB13_Pos      (13U)                                           
#define CAN_F2R2_FB13_Msk      (0x1U << CAN_F2R2_FB13_Pos)                     /*!< 0x00002000 */
#define CAN_F2R2_FB13          CAN_F2R2_FB13_Msk                               /*!<Filter bit 13 */
#define CAN_F2R2_FB14_Pos      (14U)                                           
#define CAN_F2R2_FB14_Msk      (0x1U << CAN_F2R2_FB14_Pos)                     /*!< 0x00004000 */
#define CAN_F2R2_FB14          CAN_F2R2_FB14_Msk                               /*!<Filter bit 14 */
#define CAN_F2R2_FB15_Pos      (15U)                                           
#define CAN_F2R2_FB15_Msk      (0x1U << CAN_F2R2_FB15_Pos)                     /*!< 0x00008000 */
#define CAN_F2R2_FB15          CAN_F2R2_FB15_Msk                               /*!<Filter bit 15 */
#define CAN_F2R2_FB16_Pos      (16U)                                           
#define CAN_F2R2_FB16_Msk      (0x1U << CAN_F2R2_FB16_Pos)                     /*!< 0x00010000 */
#define CAN_F2R2_FB16          CAN_F2R2_FB16_Msk                               /*!<Filter bit 16 */
#define CAN_F2R2_FB17_Pos      (17U)                                           
#define CAN_F2R2_FB17_Msk      (0x1U << CAN_F2R2_FB17_Pos)                     /*!< 0x00020000 */
#define CAN_F2R2_FB17          CAN_F2R2_FB17_Msk                               /*!<Filter bit 17 */
#define CAN_F2R2_FB18_Pos      (18U)                                           
#define CAN_F2R2_FB18_Msk      (0x1U << CAN_F2R2_FB18_Pos)                     /*!< 0x00040000 */
#define CAN_F2R2_FB18          CAN_F2R2_FB18_Msk                               /*!<Filter bit 18 */
#define CAN_F2R2_FB19_Pos      (19U)                                           
#define CAN_F2R2_FB19_Msk      (0x1U << CAN_F2R2_FB19_Pos)                     /*!< 0x00080000 */
#define CAN_F2R2_FB19          CAN_F2R2_FB19_Msk                               /*!<Filter bit 19 */
#define CAN_F2R2_FB20_Pos      (20U)                                           
#define CAN_F2R2_FB20_Msk      (0x1U << CAN_F2R2_FB20_Pos)                     /*!< 0x00100000 */
#define CAN_F2R2_FB20          CAN_F2R2_FB20_Msk                               /*!<Filter bit 20 */
#define CAN_F2R2_FB21_Pos      (21U)                                           
#define CAN_F2R2_FB21_Msk      (0x1U << CAN_F2R2_FB21_Pos)                     /*!< 0x00200000 */
#define CAN_F2R2_FB21          CAN_F2R2_FB21_Msk                               /*!<Filter bit 21 */
#define CAN_F2R2_FB22_Pos      (22U)                                           
#define CAN_F2R2_FB22_Msk      (0x1U << CAN_F2R2_FB22_Pos)                     /*!< 0x00400000 */
#define CAN_F2R2_FB22          CAN_F2R2_FB22_Msk                               /*!<Filter bit 22 */
#define CAN_F2R2_FB23_Pos      (23U)                                           
#define CAN_F2R2_FB23_Msk      (0x1U << CAN_F2R2_FB23_Pos)                     /*!< 0x00800000 */
#define CAN_F2R2_FB23          CAN_F2R2_FB23_Msk                               /*!<Filter bit 23 */
#define CAN_F2R2_FB24_Pos      (24U)                                           
#define CAN_F2R2_FB24_Msk      (0x1U << CAN_F2R2_FB24_Pos)                     /*!< 0x01000000 */
#define CAN_F2R2_FB24          CAN_F2R2_FB24_Msk                               /*!<Filter bit 24 */
#define CAN_F2R2_FB25_Pos      (25U)                                           
#define CAN_F2R2_FB25_Msk      (0x1U << CAN_F2R2_FB25_Pos)                     /*!< 0x02000000 */
#define CAN_F2R2_FB25          CAN_F2R2_FB25_Msk                               /*!<Filter bit 25 */
#define CAN_F2R2_FB26_Pos      (26U)                                           
#define CAN_F2R2_FB26_Msk      (0x1U << CAN_F2R2_FB26_Pos)                     /*!< 0x04000000 */
#define CAN_F2R2_FB26          CAN_F2R2_FB26_Msk                               /*!<Filter bit 26 */
#define CAN_F2R2_FB27_Pos      (27U)                                           
#define CAN_F2R2_FB27_Msk      (0x1U << CAN_F2R2_FB27_Pos)                     /*!< 0x08000000 */
#define CAN_F2R2_FB27          CAN_F2R2_FB27_Msk                               /*!<Filter bit 27 */
#define CAN_F2R2_FB28_Pos      (28U)                                           
#define CAN_F2R2_FB28_Msk      (0x1U << CAN_F2R2_FB28_Pos)                     /*!< 0x10000000 */
#define CAN_F2R2_FB28          CAN_F2R2_FB28_Msk                               /*!<Filter bit 28 */
#define CAN_F2R2_FB29_Pos      (29U)                                           
#define CAN_F2R2_FB29_Msk      (0x1U << CAN_F2R2_FB29_Pos)                     /*!< 0x20000000 */
#define CAN_F2R2_FB29          CAN_F2R2_FB29_Msk                               /*!<Filter bit 29 */
#define CAN_F2R2_FB30_Pos      (30U)                                           
#define CAN_F2R2_FB30_Msk      (0x1U << CAN_F2R2_FB30_Pos)                     /*!< 0x40000000 */
#define CAN_F2R2_FB30          CAN_F2R2_FB30_Msk                               /*!<Filter bit 30 */
#define CAN_F2R2_FB31_Pos      (31U)                                           
#define CAN_F2R2_FB31_Msk      (0x1U << CAN_F2R2_FB31_Pos)                     /*!< 0x80000000 */
#define CAN_F2R2_FB31          CAN_F2R2_FB31_Msk                               /*!<Filter bit 31 */

/*******************  Bit definition for CAN_F3R2 register  *******************/
#define CAN_F3R2_FB0_Pos       (0U)                                            
#define CAN_F3R2_FB0_Msk       (0x1U << CAN_F3R2_FB0_Pos)                      /*!< 0x00000001 */
#define CAN_F3R2_FB0           CAN_F3R2_FB0_Msk                                /*!<Filter bit 0 */
#define CAN_F3R2_FB1_Pos       (1U)                                            
#define CAN_F3R2_FB1_Msk       (0x1U << CAN_F3R2_FB1_Pos)                      /*!< 0x00000002 */
#define CAN_F3R2_FB1           CAN_F3R2_FB1_Msk                                /*!<Filter bit 1 */
#define CAN_F3R2_FB2_Pos       (2U)                                            
#define CAN_F3R2_FB2_Msk       (0x1U << CAN_F3R2_FB2_Pos)                      /*!< 0x00000004 */
#define CAN_F3R2_FB2           CAN_F3R2_FB2_Msk                                /*!<Filter bit 2 */
#define CAN_F3R2_FB3_Pos       (3U)                                            
#define CAN_F3R2_FB3_Msk       (0x1U << CAN_F3R2_FB3_Pos)                      /*!< 0x00000008 */
#define CAN_F3R2_FB3           CAN_F3R2_FB3_Msk                                /*!<Filter bit 3 */
#define CAN_F3R2_FB4_Pos       (4U)                                            
#define CAN_F3R2_FB4_Msk       (0x1U << CAN_F3R2_FB4_Pos)                      /*!< 0x00000010 */
#define CAN_F3R2_FB4           CAN_F3R2_FB4_Msk                                /*!<Filter bit 4 */
#define CAN_F3R2_FB5_Pos       (5U)                                            
#define CAN_F3R2_FB5_Msk       (0x1U << CAN_F3R2_FB5_Pos)                      /*!< 0x00000020 */
#define CAN_F3R2_FB5           CAN_F3R2_FB5_Msk                                /*!<Filter bit 5 */
#define CAN_F3R2_FB6_Pos       (6U)                                            
#define CAN_F3R2_FB6_Msk       (0x1U << CAN_F3R2_FB6_Pos)                      /*!< 0x00000040 */
#define CAN_F3R2_FB6           CAN_F3R2_FB6_Msk                                /*!<Filter bit 6 */
#define CAN_F3R2_FB7_Pos       (7U)                                            
#define CAN_F3R2_FB7_Msk       (0x1U << CAN_F3R2_FB7_Pos)                      /*!< 0x00000080 */
#define CAN_F3R2_FB7           CAN_F3R2_FB7_Msk                                /*!<Filter bit 7 */
#define CAN_F3R2_FB8_Pos       (8U)                                            
#define CAN_F3R2_FB8_Msk       (0x1U << CAN_F3R2_FB8_Pos)                      /*!< 0x00000100 */
#define CAN_F3R2_FB8           CAN_F3R2_FB8_Msk                                /*!<Filter bit 8 */
#define CAN_F3R2_FB9_Pos       (9U)                                            
#define CAN_F3R2_FB9_Msk       (0x1U << CAN_F3R2_FB9_Pos)                      /*!< 0x00000200 */
#define CAN_F3R2_FB9           CAN_F3R2_FB9_Msk                                /*!<Filter bit 9 */
#define CAN_F3R2_FB10_Pos      (10U)                                           
#define CAN_F3R2_FB10_Msk      (0x1U << CAN_F3R2_FB10_Pos)                     /*!< 0x00000400 */
#define CAN_F3R2_FB10          CAN_F3R2_FB10_Msk                               /*!<Filter bit 10 */
#define CAN_F3R2_FB11_Pos      (11U)                                           
#define CAN_F3R2_FB11_Msk      (0x1U << CAN_F3R2_FB11_Pos)                     /*!< 0x00000800 */
#define CAN_F3R2_FB11          CAN_F3R2_FB11_Msk                               /*!<Filter bit 11 */
#define CAN_F3R2_FB12_Pos      (12U)                                           
#define CAN_F3R2_FB12_Msk      (0x1U << CAN_F3R2_FB12_Pos)                     /*!< 0x00001000 */
#define CAN_F3R2_FB12          CAN_F3R2_FB12_Msk                               /*!<Filter bit 12 */
#define CAN_F3R2_FB13_Pos      (13U)                                           
#define CAN_F3R2_FB13_Msk      (0x1U << CAN_F3R2_FB13_Pos)                     /*!< 0x00002000 */
#define CAN_F3R2_FB13          CAN_F3R2_FB13_Msk                               /*!<Filter bit 13 */
#define CAN_F3R2_FB14_Pos      (14U)                                           
#define CAN_F3R2_FB14_Msk      (0x1U << CAN_F3R2_FB14_Pos)                     /*!< 0x00004000 */
#define CAN_F3R2_FB14          CAN_F3R2_FB14_Msk                               /*!<Filter bit 14 */
#define CAN_F3R2_FB15_Pos      (15U)                                           
#define CAN_F3R2_FB15_Msk      (0x1U << CAN_F3R2_FB15_Pos)                     /*!< 0x00008000 */
#define CAN_F3R2_FB15          CAN_F3R2_FB15_Msk                               /*!<Filter bit 15 */
#define CAN_F3R2_FB16_Pos      (16U)                                           
#define CAN_F3R2_FB16_Msk      (0x1U << CAN_F3R2_FB16_Pos)                     /*!< 0x00010000 */
#define CAN_F3R2_FB16          CAN_F3R2_FB16_Msk                               /*!<Filter bit 16 */
#define CAN_F3R2_FB17_Pos      (17U)                                           
#define CAN_F3R2_FB17_Msk      (0x1U << CAN_F3R2_FB17_Pos)                     /*!< 0x00020000 */
#define CAN_F3R2_FB17          CAN_F3R2_FB17_Msk                               /*!<Filter bit 17 */
#define CAN_F3R2_FB18_Pos      (18U)                                           
#define CAN_F3R2_FB18_Msk      (0x1U << CAN_F3R2_FB18_Pos)                     /*!< 0x00040000 */
#define CAN_F3R2_FB18          CAN_F3R2_FB18_Msk                               /*!<Filter bit 18 */
#define CAN_F3R2_FB19_Pos      (19U)                                           
#define CAN_F3R2_FB19_Msk      (0x1U << CAN_F3R2_FB19_Pos)                     /*!< 0x00080000 */
#define CAN_F3R2_FB19          CAN_F3R2_FB19_Msk                               /*!<Filter bit 19 */
#define CAN_F3R2_FB20_Pos      (20U)                                           
#define CAN_F3R2_FB20_Msk      (0x1U << CAN_F3R2_FB20_Pos)                     /*!< 0x00100000 */
#define CAN_F3R2_FB20          CAN_F3R2_FB20_Msk                               /*!<Filter bit 20 */
#define CAN_F3R2_FB21_Pos      (21U)                                           
#define CAN_F3R2_FB21_Msk      (0x1U << CAN_F3R2_FB21_Pos)                     /*!< 0x00200000 */
#define CAN_F3R2_FB21          CAN_F3R2_FB21_Msk                               /*!<Filter bit 21 */
#define CAN_F3R2_FB22_Pos      (22U)                                           
#define CAN_F3R2_FB22_Msk      (0x1U << CAN_F3R2_FB22_Pos)                     /*!< 0x00400000 */
#define CAN_F3R2_FB22          CAN_F3R2_FB22_Msk                               /*!<Filter bit 22 */
#define CAN_F3R2_FB23_Pos      (23U)                                           
#define CAN_F3R2_FB23_Msk      (0x1U << CAN_F3R2_FB23_Pos)                     /*!< 0x00800000 */
#define CAN_F3R2_FB23          CAN_F3R2_FB23_Msk                               /*!<Filter bit 23 */
#define CAN_F3R2_FB24_Pos      (24U)                                           
#define CAN_F3R2_FB24_Msk      (0x1U << CAN_F3R2_FB24_Pos)                     /*!< 0x01000000 */
#define CAN_F3R2_FB24          CAN_F3R2_FB24_Msk                               /*!<Filter bit 24 */
#define CAN_F3R2_FB25_Pos      (25U)                                           
#define CAN_F3R2_FB25_Msk      (0x1U << CAN_F3R2_FB25_Pos)                     /*!< 0x02000000 */
#define CAN_F3R2_FB25          CAN_F3R2_FB25_Msk                               /*!<Filter bit 25 */
#define CAN_F3R2_FB26_Pos      (26U)                                           
#define CAN_F3R2_FB26_Msk      (0x1U << CAN_F3R2_FB26_Pos)                     /*!< 0x04000000 */
#define CAN_F3R2_FB26          CAN_F3R2_FB26_Msk                               /*!<Filter bit 26 */
#define CAN_F3R2_FB27_Pos      (27U)                                           
#define CAN_F3R2_FB27_Msk      (0x1U << CAN_F3R2_FB27_Pos)                     /*!< 0x08000000 */
#define CAN_F3R2_FB27          CAN_F3R2_FB27_Msk                               /*!<Filter bit 27 */
#define CAN_F3R2_FB28_Pos      (28U)                                           
#define CAN_F3R2_FB28_Msk      (0x1U << CAN_F3R2_FB28_Pos)                     /*!< 0x10000000 */
#define CAN_F3R2_FB28          CAN_F3R2_FB28_Msk                               /*!<Filter bit 28 */
#define CAN_F3R2_FB29_Pos      (29U)                                           
#define CAN_F3R2_FB29_Msk      (0x1U << CAN_F3R2_FB29_Pos)                     /*!< 0x20000000 */
#define CAN_F3R2_FB29          CAN_F3R2_FB29_Msk                               /*!<Filter bit 29 */
#define CAN_F3R2_FB30_Pos      (30U)                                           
#define CAN_F3R2_FB30_Msk      (0x1U << CAN_F3R2_FB30_Pos)                     /*!< 0x40000000 */
#define CAN_F3R2_FB30          CAN_F3R2_FB30_Msk                               /*!<Filter bit 30 */
#define CAN_F3R2_FB31_Pos      (31U)                                           
#define CAN_F3R2_FB31_Msk      (0x1U << CAN_F3R2_FB31_Pos)                     /*!< 0x80000000 */
#define CAN_F3R2_FB31          CAN_F3R2_FB31_Msk                               /*!<Filter bit 31 */

/*******************  Bit definition for CAN_F4R2 register  *******************/
#define CAN_F4R2_FB0_Pos       (0U)                                            
#define CAN_F4R2_FB0_Msk       (0x1U << CAN_F4R2_FB0_Pos)                      /*!< 0x00000001 */
#define CAN_F4R2_FB0           CAN_F4R2_FB0_Msk                                /*!<Filter bit 0 */
#define CAN_F4R2_FB1_Pos       (1U)                                            
#define CAN_F4R2_FB1_Msk       (0x1U << CAN_F4R2_FB1_Pos)                      /*!< 0x00000002 */
#define CAN_F4R2_FB1           CAN_F4R2_FB1_Msk                                /*!<Filter bit 1 */
#define CAN_F4R2_FB2_Pos       (2U)                                            
#define CAN_F4R2_FB2_Msk       (0x1U << CAN_F4R2_FB2_Pos)                      /*!< 0x00000004 */
#define CAN_F4R2_FB2           CAN_F4R2_FB2_Msk                                /*!<Filter bit 2 */
#define CAN_F4R2_FB3_Pos       (3U)                                            
#define CAN_F4R2_FB3_Msk       (0x1U << CAN_F4R2_FB3_Pos)                      /*!< 0x00000008 */
#define CAN_F4R2_FB3           CAN_F4R2_FB3_Msk                                /*!<Filter bit 3 */
#define CAN_F4R2_FB4_Pos       (4U)                                            
#define CAN_F4R2_FB4_Msk       (0x1U << CAN_F4R2_FB4_Pos)                      /*!< 0x00000010 */
#define CAN_F4R2_FB4           CAN_F4R2_FB4_Msk                                /*!<Filter bit 4 */
#define CAN_F4R2_FB5_Pos       (5U)                                            
#define CAN_F4R2_FB5_Msk       (0x1U << CAN_F4R2_FB5_Pos)                      /*!< 0x00000020 */
#define CAN_F4R2_FB5           CAN_F4R2_FB5_Msk                                /*!<Filter bit 5 */
#define CAN_F4R2_FB6_Pos       (6U)                                            
#define CAN_F4R2_FB6_Msk       (0x1U << CAN_F4R2_FB6_Pos)                      /*!< 0x00000040 */
#define CAN_F4R2_FB6           CAN_F4R2_FB6_Msk                                /*!<Filter bit 6 */
#define CAN_F4R2_FB7_Pos       (7U)                                            
#define CAN_F4R2_FB7_Msk       (0x1U << CAN_F4R2_FB7_Pos)                      /*!< 0x00000080 */
#define CAN_F4R2_FB7           CAN_F4R2_FB7_Msk                                /*!<Filter bit 7 */
#define CAN_F4R2_FB8_Pos       (8U)                                            
#define CAN_F4R2_FB8_Msk       (0x1U << CAN_F4R2_FB8_Pos)                      /*!< 0x00000100 */
#define CAN_F4R2_FB8           CAN_F4R2_FB8_Msk                                /*!<Filter bit 8 */
#define CAN_F4R2_FB9_Pos       (9U)                                            
#define CAN_F4R2_FB9_Msk       (0x1U << CAN_F4R2_FB9_Pos)                      /*!< 0x00000200 */
#define CAN_F4R2_FB9           CAN_F4R2_FB9_Msk                                /*!<Filter bit 9 */
#define CAN_F4R2_FB10_Pos      (10U)                                           
#define CAN_F4R2_FB10_Msk      (0x1U << CAN_F4R2_FB10_Pos)                     /*!< 0x00000400 */
#define CAN_F4R2_FB10          CAN_F4R2_FB10_Msk                               /*!<Filter bit 10 */
#define CAN_F4R2_FB11_Pos      (11U)                                           
#define CAN_F4R2_FB11_Msk      (0x1U << CAN_F4R2_FB11_Pos)                     /*!< 0x00000800 */
#define CAN_F4R2_FB11          CAN_F4R2_FB11_Msk                               /*!<Filter bit 11 */
#define CAN_F4R2_FB12_Pos      (12U)                                           
#define CAN_F4R2_FB12_Msk      (0x1U << CAN_F4R2_FB12_Pos)                     /*!< 0x00001000 */
#define CAN_F4R2_FB12          CAN_F4R2_FB12_Msk                               /*!<Filter bit 12 */
#define CAN_F4R2_FB13_Pos      (13U)                                           
#define CAN_F4R2_FB13_Msk      (0x1U << CAN_F4R2_FB13_Pos)                     /*!< 0x00002000 */
#define CAN_F4R2_FB13          CAN_F4R2_FB13_Msk                               /*!<Filter bit 13 */
#define CAN_F4R2_FB14_Pos      (14U)                                           
#define CAN_F4R2_FB14_Msk      (0x1U << CAN_F4R2_FB14_Pos)                     /*!< 0x00004000 */
#define CAN_F4R2_FB14          CAN_F4R2_FB14_Msk                               /*!<Filter bit 14 */
#define CAN_F4R2_FB15_Pos      (15U)                                           
#define CAN_F4R2_FB15_Msk      (0x1U << CAN_F4R2_FB15_Pos)                     /*!< 0x00008000 */
#define CAN_F4R2_FB15          CAN_F4R2_FB15_Msk                               /*!<Filter bit 15 */
#define CAN_F4R2_FB16_Pos      (16U)                                           
#define CAN_F4R2_FB16_Msk      (0x1U << CAN_F4R2_FB16_Pos)                     /*!< 0x00010000 */
#define CAN_F4R2_FB16          CAN_F4R2_FB16_Msk                               /*!<Filter bit 16 */
#define CAN_F4R2_FB17_Pos      (17U)                                           
#define CAN_F4R2_FB17_Msk      (0x1U << CAN_F4R2_FB17_Pos)                     /*!< 0x00020000 */
#define CAN_F4R2_FB17          CAN_F4R2_FB17_Msk                               /*!<Filter bit 17 */
#define CAN_F4R2_FB18_Pos      (18U)                                           
#define CAN_F4R2_FB18_Msk      (0x1U << CAN_F4R2_FB18_Pos)                     /*!< 0x00040000 */
#define CAN_F4R2_FB18          CAN_F4R2_FB18_Msk                               /*!<Filter bit 18 */
#define CAN_F4R2_FB19_Pos      (19U)                                           
#define CAN_F4R2_FB19_Msk      (0x1U << CAN_F4R2_FB19_Pos)                     /*!< 0x00080000 */
#define CAN_F4R2_FB19          CAN_F4R2_FB19_Msk                               /*!<Filter bit 19 */
#define CAN_F4R2_FB20_Pos      (20U)                                           
#define CAN_F4R2_FB20_Msk      (0x1U << CAN_F4R2_FB20_Pos)                     /*!< 0x00100000 */
#define CAN_F4R2_FB20          CAN_F4R2_FB20_Msk                               /*!<Filter bit 20 */
#define CAN_F4R2_FB21_Pos      (21U)                                           
#define CAN_F4R2_FB21_Msk      (0x1U << CAN_F4R2_FB21_Pos)                     /*!< 0x00200000 */
#define CAN_F4R2_FB21          CAN_F4R2_FB21_Msk                               /*!<Filter bit 21 */
#define CAN_F4R2_FB22_Pos      (22U)                                           
#define CAN_F4R2_FB22_Msk      (0x1U << CAN_F4R2_FB22_Pos)                     /*!< 0x00400000 */
#define CAN_F4R2_FB22          CAN_F4R2_FB22_Msk                               /*!<Filter bit 22 */
#define CAN_F4R2_FB23_Pos      (23U)                                           
#define CAN_F4R2_FB23_Msk      (0x1U << CAN_F4R2_FB23_Pos)                     /*!< 0x00800000 */
#define CAN_F4R2_FB23          CAN_F4R2_FB23_Msk                               /*!<Filter bit 23 */
#define CAN_F4R2_FB24_Pos      (24U)                                           
#define CAN_F4R2_FB24_Msk      (0x1U << CAN_F4R2_FB24_Pos)                     /*!< 0x01000000 */
#define CAN_F4R2_FB24          CAN_F4R2_FB24_Msk                               /*!<Filter bit 24 */
#define CAN_F4R2_FB25_Pos      (25U)                                           
#define CAN_F4R2_FB25_Msk      (0x1U << CAN_F4R2_FB25_Pos)                     /*!< 0x02000000 */
#define CAN_F4R2_FB25          CAN_F4R2_FB25_Msk                               /*!<Filter bit 25 */
#define CAN_F4R2_FB26_Pos      (26U)                                           
#define CAN_F4R2_FB26_Msk      (0x1U << CAN_F4R2_FB26_Pos)                     /*!< 0x04000000 */
#define CAN_F4R2_FB26          CAN_F4R2_FB26_Msk                               /*!<Filter bit 26 */
#define CAN_F4R2_FB27_Pos      (27U)                                           
#define CAN_F4R2_FB27_Msk      (0x1U << CAN_F4R2_FB27_Pos)                     /*!< 0x08000000 */
#define CAN_F4R2_FB27          CAN_F4R2_FB27_Msk                               /*!<Filter bit 27 */
#define CAN_F4R2_FB28_Pos      (28U)                                           
#define CAN_F4R2_FB28_Msk      (0x1U << CAN_F4R2_FB28_Pos)                     /*!< 0x10000000 */
#define CAN_F4R2_FB28          CAN_F4R2_FB28_Msk                               /*!<Filter bit 28 */
#define CAN_F4R2_FB29_Pos      (29U)                                           
#define CAN_F4R2_FB29_Msk      (0x1U << CAN_F4R2_FB29_Pos)                     /*!< 0x20000000 */
#define CAN_F4R2_FB29          CAN_F4R2_FB29_Msk                               /*!<Filter bit 29 */
#define CAN_F4R2_FB30_Pos      (30U)                                           
#define CAN_F4R2_FB30_Msk      (0x1U << CAN_F4R2_FB30_Pos)                     /*!< 0x40000000 */
#define CAN_F4R2_FB30          CAN_F4R2_FB30_Msk                               /*!<Filter bit 30 */
#define CAN_F4R2_FB31_Pos      (31U)                                           
#define CAN_F4R2_FB31_Msk      (0x1U << CAN_F4R2_FB31_Pos)                     /*!< 0x80000000 */
#define CAN_F4R2_FB31          CAN_F4R2_FB31_Msk                               /*!<Filter bit 31 */

/*******************  Bit definition for CAN_F5R2 register  *******************/
#define CAN_F5R2_FB0_Pos       (0U)                                            
#define CAN_F5R2_FB0_Msk       (0x1U << CAN_F5R2_FB0_Pos)                      /*!< 0x00000001 */
#define CAN_F5R2_FB0           CAN_F5R2_FB0_Msk                                /*!<Filter bit 0 */
#define CAN_F5R2_FB1_Pos       (1U)                                            
#define CAN_F5R2_FB1_Msk       (0x1U << CAN_F5R2_FB1_Pos)                      /*!< 0x00000002 */
#define CAN_F5R2_FB1           CAN_F5R2_FB1_Msk                                /*!<Filter bit 1 */
#define CAN_F5R2_FB2_Pos       (2U)                                            
#define CAN_F5R2_FB2_Msk       (0x1U << CAN_F5R2_FB2_Pos)                      /*!< 0x00000004 */
#define CAN_F5R2_FB2           CAN_F5R2_FB2_Msk                                /*!<Filter bit 2 */
#define CAN_F5R2_FB3_Pos       (3U)                                            
#define CAN_F5R2_FB3_Msk       (0x1U << CAN_F5R2_FB3_Pos)                      /*!< 0x00000008 */
#define CAN_F5R2_FB3           CAN_F5R2_FB3_Msk                                /*!<Filter bit 3 */
#define CAN_F5R2_FB4_Pos       (4U)                                            
#define CAN_F5R2_FB4_Msk       (0x1U << CAN_F5R2_FB4_Pos)                      /*!< 0x00000010 */
#define CAN_F5R2_FB4           CAN_F5R2_FB4_Msk                                /*!<Filter bit 4 */
#define CAN_F5R2_FB5_Pos       (5U)                                            
#define CAN_F5R2_FB5_Msk       (0x1U << CAN_F5R2_FB5_Pos)                      /*!< 0x00000020 */
#define CAN_F5R2_FB5           CAN_F5R2_FB5_Msk                                /*!<Filter bit 5 */
#define CAN_F5R2_FB6_Pos       (6U)                                            
#define CAN_F5R2_FB6_Msk       (0x1U << CAN_F5R2_FB6_Pos)                      /*!< 0x00000040 */
#define CAN_F5R2_FB6           CAN_F5R2_FB6_Msk                                /*!<Filter bit 6 */
#define CAN_F5R2_FB7_Pos       (7U)                                            
#define CAN_F5R2_FB7_Msk       (0x1U << CAN_F5R2_FB7_Pos)                      /*!< 0x00000080 */
#define CAN_F5R2_FB7           CAN_F5R2_FB7_Msk                                /*!<Filter bit 7 */
#define CAN_F5R2_FB8_Pos       (8U)                                            
#define CAN_F5R2_FB8_Msk       (0x1U << CAN_F5R2_FB8_Pos)                      /*!< 0x00000100 */
#define CAN_F5R2_FB8           CAN_F5R2_FB8_Msk                                /*!<Filter bit 8 */
#define CAN_F5R2_FB9_Pos       (9U)                                            
#define CAN_F5R2_FB9_Msk       (0x1U << CAN_F5R2_FB9_Pos)                      /*!< 0x00000200 */
#define CAN_F5R2_FB9           CAN_F5R2_FB9_Msk                                /*!<Filter bit 9 */
#define CAN_F5R2_FB10_Pos      (10U)                                           
#define CAN_F5R2_FB10_Msk      (0x1U << CAN_F5R2_FB10_Pos)                     /*!< 0x00000400 */
#define CAN_F5R2_FB10          CAN_F5R2_FB10_Msk                               /*!<Filter bit 10 */
#define CAN_F5R2_FB11_Pos      (11U)                                           
#define CAN_F5R2_FB11_Msk      (0x1U << CAN_F5R2_FB11_Pos)                     /*!< 0x00000800 */
#define CAN_F5R2_FB11          CAN_F5R2_FB11_Msk                               /*!<Filter bit 11 */
#define CAN_F5R2_FB12_Pos      (12U)                                           
#define CAN_F5R2_FB12_Msk      (0x1U << CAN_F5R2_FB12_Pos)                     /*!< 0x00001000 */
#define CAN_F5R2_FB12          CAN_F5R2_FB12_Msk                               /*!<Filter bit 12 */
#define CAN_F5R2_FB13_Pos      (13U)                                           
#define CAN_F5R2_FB13_Msk      (0x1U << CAN_F5R2_FB13_Pos)                     /*!< 0x00002000 */
#define CAN_F5R2_FB13          CAN_F5R2_FB13_Msk                               /*!<Filter bit 13 */
#define CAN_F5R2_FB14_Pos      (14U)                                           
#define CAN_F5R2_FB14_Msk      (0x1U << CAN_F5R2_FB14_Pos)                     /*!< 0x00004000 */
#define CAN_F5R2_FB14          CAN_F5R2_FB14_Msk                               /*!<Filter bit 14 */
#define CAN_F5R2_FB15_Pos      (15U)                                           
#define CAN_F5R2_FB15_Msk      (0x1U << CAN_F5R2_FB15_Pos)                     /*!< 0x00008000 */
#define CAN_F5R2_FB15          CAN_F5R2_FB15_Msk                               /*!<Filter bit 15 */
#define CAN_F5R2_FB16_Pos      (16U)                                           
#define CAN_F5R2_FB16_Msk      (0x1U << CAN_F5R2_FB16_Pos)                     /*!< 0x00010000 */
#define CAN_F5R2_FB16          CAN_F5R2_FB16_Msk                               /*!<Filter bit 16 */
#define CAN_F5R2_FB17_Pos      (17U)                                           
#define CAN_F5R2_FB17_Msk      (0x1U << CAN_F5R2_FB17_Pos)                     /*!< 0x00020000 */
#define CAN_F5R2_FB17          CAN_F5R2_FB17_Msk                               /*!<Filter bit 17 */
#define CAN_F5R2_FB18_Pos      (18U)                                           
#define CAN_F5R2_FB18_Msk      (0x1U << CAN_F5R2_FB18_Pos)                     /*!< 0x00040000 */
#define CAN_F5R2_FB18          CAN_F5R2_FB18_Msk                               /*!<Filter bit 18 */
#define CAN_F5R2_FB19_Pos      (19U)                                           
#define CAN_F5R2_FB19_Msk      (0x1U << CAN_F5R2_FB19_Pos)                     /*!< 0x00080000 */
#define CAN_F5R2_FB19          CAN_F5R2_FB19_Msk                               /*!<Filter bit 19 */
#define CAN_F5R2_FB20_Pos      (20U)                                           
#define CAN_F5R2_FB20_Msk      (0x1U << CAN_F5R2_FB20_Pos)                     /*!< 0x00100000 */
#define CAN_F5R2_FB20          CAN_F5R2_FB20_Msk                               /*!<Filter bit 20 */
#define CAN_F5R2_FB21_Pos      (21U)                                           
#define CAN_F5R2_FB21_Msk      (0x1U << CAN_F5R2_FB21_Pos)                     /*!< 0x00200000 */
#define CAN_F5R2_FB21          CAN_F5R2_FB21_Msk                               /*!<Filter bit 21 */
#define CAN_F5R2_FB22_Pos      (22U)                                           
#define CAN_F5R2_FB22_Msk      (0x1U << CAN_F5R2_FB22_Pos)                     /*!< 0x00400000 */
#define CAN_F5R2_FB22          CAN_F5R2_FB22_Msk                               /*!<Filter bit 22 */
#define CAN_F5R2_FB23_Pos      (23U)                                           
#define CAN_F5R2_FB23_Msk      (0x1U << CAN_F5R2_FB23_Pos)                     /*!< 0x00800000 */
#define CAN_F5R2_FB23          CAN_F5R2_FB23_Msk                               /*!<Filter bit 23 */
#define CAN_F5R2_FB24_Pos      (24U)                                           
#define CAN_F5R2_FB24_Msk      (0x1U << CAN_F5R2_FB24_Pos)                     /*!< 0x01000000 */
#define CAN_F5R2_FB24          CAN_F5R2_FB24_Msk                               /*!<Filter bit 24 */
#define CAN_F5R2_FB25_Pos      (25U)                                           
#define CAN_F5R2_FB25_Msk      (0x1U << CAN_F5R2_FB25_Pos)                     /*!< 0x02000000 */
#define CAN_F5R2_FB25          CAN_F5R2_FB25_Msk                               /*!<Filter bit 25 */
#define CAN_F5R2_FB26_Pos      (26U)                                           
#define CAN_F5R2_FB26_Msk      (0x1U << CAN_F5R2_FB26_Pos)                     /*!< 0x04000000 */
#define CAN_F5R2_FB26          CAN_F5R2_FB26_Msk                               /*!<Filter bit 26 */
#define CAN_F5R2_FB27_Pos      (27U)                                           
#define CAN_F5R2_FB27_Msk      (0x1U << CAN_F5R2_FB27_Pos)                     /*!< 0x08000000 */
#define CAN_F5R2_FB27          CAN_F5R2_FB27_Msk                               /*!<Filter bit 27 */
#define CAN_F5R2_FB28_Pos      (28U)                                           
#define CAN_F5R2_FB28_Msk      (0x1U << CAN_F5R2_FB28_Pos)                     /*!< 0x10000000 */
#define CAN_F5R2_FB28          CAN_F5R2_FB28_Msk                               /*!<Filter bit 28 */
#define CAN_F5R2_FB29_Pos      (29U)                                           
#define CAN_F5R2_FB29_Msk      (0x1U << CAN_F5R2_FB29_Pos)                     /*!< 0x20000000 */
#define CAN_F5R2_FB29          CAN_F5R2_FB29_Msk                               /*!<Filter bit 29 */
#define CAN_F5R2_FB30_Pos      (30U)                                           
#define CAN_F5R2_FB30_Msk      (0x1U << CAN_F5R2_FB30_Pos)                     /*!< 0x40000000 */
#define CAN_F5R2_FB30          CAN_F5R2_FB30_Msk                               /*!<Filter bit 30 */
#define CAN_F5R2_FB31_Pos      (31U)                                           
#define CAN_F5R2_FB31_Msk      (0x1U << CAN_F5R2_FB31_Pos)                     /*!< 0x80000000 */
#define CAN_F5R2_FB31          CAN_F5R2_FB31_Msk                               /*!<Filter bit 31 */

/*******************  Bit definition for CAN_F6R2 register  *******************/
#define CAN_F6R2_FB0_Pos       (0U)                                            
#define CAN_F6R2_FB0_Msk       (0x1U << CAN_F6R2_FB0_Pos)                      /*!< 0x00000001 */
#define CAN_F6R2_FB0           CAN_F6R2_FB0_Msk                                /*!<Filter bit 0 */
#define CAN_F6R2_FB1_Pos       (1U)                                            
#define CAN_F6R2_FB1_Msk       (0x1U << CAN_F6R2_FB1_Pos)                      /*!< 0x00000002 */
#define CAN_F6R2_FB1           CAN_F6R2_FB1_Msk                                /*!<Filter bit 1 */
#define CAN_F6R2_FB2_Pos       (2U)                                            
#define CAN_F6R2_FB2_Msk       (0x1U << CAN_F6R2_FB2_Pos)                      /*!< 0x00000004 */
#define CAN_F6R2_FB2           CAN_F6R2_FB2_Msk                                /*!<Filter bit 2 */
#define CAN_F6R2_FB3_Pos       (3U)                                            
#define CAN_F6R2_FB3_Msk       (0x1U << CAN_F6R2_FB3_Pos)                      /*!< 0x00000008 */
#define CAN_F6R2_FB3           CAN_F6R2_FB3_Msk                                /*!<Filter bit 3 */
#define CAN_F6R2_FB4_Pos       (4U)                                            
#define CAN_F6R2_FB4_Msk       (0x1U << CAN_F6R2_FB4_Pos)                      /*!< 0x00000010 */
#define CAN_F6R2_FB4           CAN_F6R2_FB4_Msk                                /*!<Filter bit 4 */
#define CAN_F6R2_FB5_Pos       (5U)                                            
#define CAN_F6R2_FB5_Msk       (0x1U << CAN_F6R2_FB5_Pos)                      /*!< 0x00000020 */
#define CAN_F6R2_FB5           CAN_F6R2_FB5_Msk                                /*!<Filter bit 5 */
#define CAN_F6R2_FB6_Pos       (6U)                                            
#define CAN_F6R2_FB6_Msk       (0x1U << CAN_F6R2_FB6_Pos)                      /*!< 0x00000040 */
#define CAN_F6R2_FB6           CAN_F6R2_FB6_Msk                                /*!<Filter bit 6 */
#define CAN_F6R2_FB7_Pos       (7U)                                            
#define CAN_F6R2_FB7_Msk       (0x1U << CAN_F6R2_FB7_Pos)                      /*!< 0x00000080 */
#define CAN_F6R2_FB7           CAN_F6R2_FB7_Msk                                /*!<Filter bit 7 */
#define CAN_F6R2_FB8_Pos       (8U)                                            
#define CAN_F6R2_FB8_Msk       (0x1U << CAN_F6R2_FB8_Pos)                      /*!< 0x00000100 */
#define CAN_F6R2_FB8           CAN_F6R2_FB8_Msk                                /*!<Filter bit 8 */
#define CAN_F6R2_FB9_Pos       (9U)                                            
#define CAN_F6R2_FB9_Msk       (0x1U << CAN_F6R2_FB9_Pos)                      /*!< 0x00000200 */
#define CAN_F6R2_FB9           CAN_F6R2_FB9_Msk                                /*!<Filter bit 9 */
#define CAN_F6R2_FB10_Pos      (10U)                                           
#define CAN_F6R2_FB10_Msk      (0x1U << CAN_F6R2_FB10_Pos)                     /*!< 0x00000400 */
#define CAN_F6R2_FB10          CAN_F6R2_FB10_Msk                               /*!<Filter bit 10 */
#define CAN_F6R2_FB11_Pos      (11U)                                           
#define CAN_F6R2_FB11_Msk      (0x1U << CAN_F6R2_FB11_Pos)                     /*!< 0x00000800 */
#define CAN_F6R2_FB11          CAN_F6R2_FB11_Msk                               /*!<Filter bit 11 */
#define CAN_F6R2_FB12_Pos      (12U)                                           
#define CAN_F6R2_FB12_Msk      (0x1U << CAN_F6R2_FB12_Pos)                     /*!< 0x00001000 */
#define CAN_F6R2_FB12          CAN_F6R2_FB12_Msk                               /*!<Filter bit 12 */
#define CAN_F6R2_FB13_Pos      (13U)                                           
#define CAN_F6R2_FB13_Msk      (0x1U << CAN_F6R2_FB13_Pos)                     /*!< 0x00002000 */
#define CAN_F6R2_FB13          CAN_F6R2_FB13_Msk                               /*!<Filter bit 13 */
#define CAN_F6R2_FB14_Pos      (14U)                                           
#define CAN_F6R2_FB14_Msk      (0x1U << CAN_F6R2_FB14_Pos)                     /*!< 0x00004000 */
#define CAN_F6R2_FB14          CAN_F6R2_FB14_Msk                               /*!<Filter bit 14 */
#define CAN_F6R2_FB15_Pos      (15U)                                           
#define CAN_F6R2_FB15_Msk      (0x1U << CAN_F6R2_FB15_Pos)                     /*!< 0x00008000 */
#define CAN_F6R2_FB15          CAN_F6R2_FB15_Msk                               /*!<Filter bit 15 */
#define CAN_F6R2_FB16_Pos      (16U)                                           
#define CAN_F6R2_FB16_Msk      (0x1U << CAN_F6R2_FB16_Pos)                     /*!< 0x00010000 */
#define CAN_F6R2_FB16          CAN_F6R2_FB16_Msk                               /*!<Filter bit 16 */
#define CAN_F6R2_FB17_Pos      (17U)                                           
#define CAN_F6R2_FB17_Msk      (0x1U << CAN_F6R2_FB17_Pos)                     /*!< 0x00020000 */
#define CAN_F6R2_FB17          CAN_F6R2_FB17_Msk                               /*!<Filter bit 17 */
#define CAN_F6R2_FB18_Pos      (18U)                                           
#define CAN_F6R2_FB18_Msk      (0x1U << CAN_F6R2_FB18_Pos)                     /*!< 0x00040000 */
#define CAN_F6R2_FB18          CAN_F6R2_FB18_Msk                               /*!<Filter bit 18 */
#define CAN_F6R2_FB19_Pos      (19U)                                           
#define CAN_F6R2_FB19_Msk      (0x1U << CAN_F6R2_FB19_Pos)                     /*!< 0x00080000 */
#define CAN_F6R2_FB19          CAN_F6R2_FB19_Msk                               /*!<Filter bit 19 */
#define CAN_F6R2_FB20_Pos      (20U)                                           
#define CAN_F6R2_FB20_Msk      (0x1U << CAN_F6R2_FB20_Pos)                     /*!< 0x00100000 */
#define CAN_F6R2_FB20          CAN_F6R2_FB20_Msk                               /*!<Filter bit 20 */
#define CAN_F6R2_FB21_Pos      (21U)                                           
#define CAN_F6R2_FB21_Msk      (0x1U << CAN_F6R2_FB21_Pos)                     /*!< 0x00200000 */
#define CAN_F6R2_FB21          CAN_F6R2_FB21_Msk                               /*!<Filter bit 21 */
#define CAN_F6R2_FB22_Pos      (22U)                                           
#define CAN_F6R2_FB22_Msk      (0x1U << CAN_F6R2_FB22_Pos)                     /*!< 0x00400000 */
#define CAN_F6R2_FB22          CAN_F6R2_FB22_Msk                               /*!<Filter bit 22 */
#define CAN_F6R2_FB23_Pos      (23U)                                           
#define CAN_F6R2_FB23_Msk      (0x1U << CAN_F6R2_FB23_Pos)                     /*!< 0x00800000 */
#define CAN_F6R2_FB23          CAN_F6R2_FB23_Msk                               /*!<Filter bit 23 */
#define CAN_F6R2_FB24_Pos      (24U)                                           
#define CAN_F6R2_FB24_Msk      (0x1U << CAN_F6R2_FB24_Pos)                     /*!< 0x01000000 */
#define CAN_F6R2_FB24          CAN_F6R2_FB24_Msk                               /*!<Filter bit 24 */
#define CAN_F6R2_FB25_Pos      (25U)                                           
#define CAN_F6R2_FB25_Msk      (0x1U << CAN_F6R2_FB25_Pos)                     /*!< 0x02000000 */
#define CAN_F6R2_FB25          CAN_F6R2_FB25_Msk                               /*!<Filter bit 25 */
#define CAN_F6R2_FB26_Pos      (26U)                                           
#define CAN_F6R2_FB26_Msk      (0x1U << CAN_F6R2_FB26_Pos)                     /*!< 0x04000000 */
#define CAN_F6R2_FB26          CAN_F6R2_FB26_Msk                               /*!<Filter bit 26 */
#define CAN_F6R2_FB27_Pos      (27U)                                           
#define CAN_F6R2_FB27_Msk      (0x1U << CAN_F6R2_FB27_Pos)                     /*!< 0x08000000 */
#define CAN_F6R2_FB27          CAN_F6R2_FB27_Msk                               /*!<Filter bit 27 */
#define CAN_F6R2_FB28_Pos      (28U)                                           
#define CAN_F6R2_FB28_Msk      (0x1U << CAN_F6R2_FB28_Pos)                     /*!< 0x10000000 */
#define CAN_F6R2_FB28          CAN_F6R2_FB28_Msk                               /*!<Filter bit 28 */
#define CAN_F6R2_FB29_Pos      (29U)                                           
#define CAN_F6R2_FB29_Msk      (0x1U << CAN_F6R2_FB29_Pos)                     /*!< 0x20000000 */
#define CAN_F6R2_FB29          CAN_F6R2_FB29_Msk                               /*!<Filter bit 29 */
#define CAN_F6R2_FB30_Pos      (30U)                                           
#define CAN_F6R2_FB30_Msk      (0x1U << CAN_F6R2_FB30_Pos)                     /*!< 0x40000000 */
#define CAN_F6R2_FB30          CAN_F6R2_FB30_Msk                               /*!<Filter bit 30 */
#define CAN_F6R2_FB31_Pos      (31U)                                           
#define CAN_F6R2_FB31_Msk      (0x1U << CAN_F6R2_FB31_Pos)                     /*!< 0x80000000 */
#define CAN_F6R2_FB31          CAN_F6R2_FB31_Msk                               /*!<Filter bit 31 */

/*******************  Bit definition for CAN_F7R2 register  *******************/
#define CAN_F7R2_FB0_Pos       (0U)                                            
#define CAN_F7R2_FB0_Msk       (0x1U << CAN_F7R2_FB0_Pos)                      /*!< 0x00000001 */
#define CAN_F7R2_FB0           CAN_F7R2_FB0_Msk                                /*!<Filter bit 0 */
#define CAN_F7R2_FB1_Pos       (1U)                                            
#define CAN_F7R2_FB1_Msk       (0x1U << CAN_F7R2_FB1_Pos)                      /*!< 0x00000002 */
#define CAN_F7R2_FB1           CAN_F7R2_FB1_Msk                                /*!<Filter bit 1 */
#define CAN_F7R2_FB2_Pos       (2U)                                            
#define CAN_F7R2_FB2_Msk       (0x1U << CAN_F7R2_FB2_Pos)                      /*!< 0x00000004 */
#define CAN_F7R2_FB2           CAN_F7R2_FB2_Msk                                /*!<Filter bit 2 */
#define CAN_F7R2_FB3_Pos       (3U)                                            
#define CAN_F7R2_FB3_Msk       (0x1U << CAN_F7R2_FB3_Pos)                      /*!< 0x00000008 */
#define CAN_F7R2_FB3           CAN_F7R2_FB3_Msk                                /*!<Filter bit 3 */
#define CAN_F7R2_FB4_Pos       (4U)                                            
#define CAN_F7R2_FB4_Msk       (0x1U << CAN_F7R2_FB4_Pos)                      /*!< 0x00000010 */
#define CAN_F7R2_FB4           CAN_F7R2_FB4_Msk                                /*!<Filter bit 4 */
#define CAN_F7R2_FB5_Pos       (5U)                                            
#define CAN_F7R2_FB5_Msk       (0x1U << CAN_F7R2_FB5_Pos)                      /*!< 0x00000020 */
#define CAN_F7R2_FB5           CAN_F7R2_FB5_Msk                                /*!<Filter bit 5 */
#define CAN_F7R2_FB6_Pos       (6U)                                            
#define CAN_F7R2_FB6_Msk       (0x1U << CAN_F7R2_FB6_Pos)                      /*!< 0x00000040 */
#define CAN_F7R2_FB6           CAN_F7R2_FB6_Msk                                /*!<Filter bit 6 */
#define CAN_F7R2_FB7_Pos       (7U)                                            
#define CAN_F7R2_FB7_Msk       (0x1U << CAN_F7R2_FB7_Pos)                      /*!< 0x00000080 */
#define CAN_F7R2_FB7           CAN_F7R2_FB7_Msk                                /*!<Filter bit 7 */
#define CAN_F7R2_FB8_Pos       (8U)                                            
#define CAN_F7R2_FB8_Msk       (0x1U << CAN_F7R2_FB8_Pos)                      /*!< 0x00000100 */
#define CAN_F7R2_FB8           CAN_F7R2_FB8_Msk                                /*!<Filter bit 8 */
#define CAN_F7R2_FB9_Pos       (9U)                                            
#define CAN_F7R2_FB9_Msk       (0x1U << CAN_F7R2_FB9_Pos)                      /*!< 0x00000200 */
#define CAN_F7R2_FB9           CAN_F7R2_FB9_Msk                                /*!<Filter bit 9 */
#define CAN_F7R2_FB10_Pos      (10U)                                           
#define CAN_F7R2_FB10_Msk      (0x1U << CAN_F7R2_FB10_Pos)                     /*!< 0x00000400 */
#define CAN_F7R2_FB10          CAN_F7R2_FB10_Msk                               /*!<Filter bit 10 */
#define CAN_F7R2_FB11_Pos      (11U)                                           
#define CAN_F7R2_FB11_Msk      (0x1U << CAN_F7R2_FB11_Pos)                     /*!< 0x00000800 */
#define CAN_F7R2_FB11          CAN_F7R2_FB11_Msk                               /*!<Filter bit 11 */
#define CAN_F7R2_FB12_Pos      (12U)                                           
#define CAN_F7R2_FB12_Msk      (0x1U << CAN_F7R2_FB12_Pos)                     /*!< 0x00001000 */
#define CAN_F7R2_FB12          CAN_F7R2_FB12_Msk                               /*!<Filter bit 12 */
#define CAN_F7R2_FB13_Pos      (13U)                                           
#define CAN_F7R2_FB13_Msk      (0x1U << CAN_F7R2_FB13_Pos)                     /*!< 0x00002000 */
#define CAN_F7R2_FB13          CAN_F7R2_FB13_Msk                               /*!<Filter bit 13 */
#define CAN_F7R2_FB14_Pos      (14U)                                           
#define CAN_F7R2_FB14_Msk      (0x1U << CAN_F7R2_FB14_Pos)                     /*!< 0x00004000 */
#define CAN_F7R2_FB14          CAN_F7R2_FB14_Msk                               /*!<Filter bit 14 */
#define CAN_F7R2_FB15_Pos      (15U)                                           
#define CAN_F7R2_FB15_Msk      (0x1U << CAN_F7R2_FB15_Pos)                     /*!< 0x00008000 */
#define CAN_F7R2_FB15          CAN_F7R2_FB15_Msk                               /*!<Filter bit 15 */
#define CAN_F7R2_FB16_Pos      (16U)                                           
#define CAN_F7R2_FB16_Msk      (0x1U << CAN_F7R2_FB16_Pos)                     /*!< 0x00010000 */
#define CAN_F7R2_FB16          CAN_F7R2_FB16_Msk                               /*!<Filter bit 16 */
#define CAN_F7R2_FB17_Pos      (17U)                                           
#define CAN_F7R2_FB17_Msk      (0x1U << CAN_F7R2_FB17_Pos)                     /*!< 0x00020000 */
#define CAN_F7R2_FB17          CAN_F7R2_FB17_Msk                               /*!<Filter bit 17 */
#define CAN_F7R2_FB18_Pos      (18U)                                           
#define CAN_F7R2_FB18_Msk      (0x1U << CAN_F7R2_FB18_Pos)                     /*!< 0x00040000 */
#define CAN_F7R2_FB18          CAN_F7R2_FB18_Msk                               /*!<Filter bit 18 */
#define CAN_F7R2_FB19_Pos      (19U)                                           
#define CAN_F7R2_FB19_Msk      (0x1U << CAN_F7R2_FB19_Pos)                     /*!< 0x00080000 */
#define CAN_F7R2_FB19          CAN_F7R2_FB19_Msk                               /*!<Filter bit 19 */
#define CAN_F7R2_FB20_Pos      (20U)                                           
#define CAN_F7R2_FB20_Msk      (0x1U << CAN_F7R2_FB20_Pos)                     /*!< 0x00100000 */
#define CAN_F7R2_FB20          CAN_F7R2_FB20_Msk                               /*!<Filter bit 20 */
#define CAN_F7R2_FB21_Pos      (21U)                                           
#define CAN_F7R2_FB21_Msk      (0x1U << CAN_F7R2_FB21_Pos)                     /*!< 0x00200000 */
#define CAN_F7R2_FB21          CAN_F7R2_FB21_Msk                               /*!<Filter bit 21 */
#define CAN_F7R2_FB22_Pos      (22U)                                           
#define CAN_F7R2_FB22_Msk      (0x1U << CAN_F7R2_FB22_Pos)                     /*!< 0x00400000 */
#define CAN_F7R2_FB22          CAN_F7R2_FB22_Msk                               /*!<Filter bit 22 */
#define CAN_F7R2_FB23_Pos      (23U)                                           
#define CAN_F7R2_FB23_Msk      (0x1U << CAN_F7R2_FB23_Pos)                     /*!< 0x00800000 */
#define CAN_F7R2_FB23          CAN_F7R2_FB23_Msk                               /*!<Filter bit 23 */
#define CAN_F7R2_FB24_Pos      (24U)                                           
#define CAN_F7R2_FB24_Msk      (0x1U << CAN_F7R2_FB24_Pos)                     /*!< 0x01000000 */
#define CAN_F7R2_FB24          CAN_F7R2_FB24_Msk                               /*!<Filter bit 24 */
#define CAN_F7R2_FB25_Pos      (25U)                                           
#define CAN_F7R2_FB25_Msk      (0x1U << CAN_F7R2_FB25_Pos)                     /*!< 0x02000000 */
#define CAN_F7R2_FB25          CAN_F7R2_FB25_Msk                               /*!<Filter bit 25 */
#define CAN_F7R2_FB26_Pos      (26U)                                           
#define CAN_F7R2_FB26_Msk      (0x1U << CAN_F7R2_FB26_Pos)                     /*!< 0x04000000 */
#define CAN_F7R2_FB26          CAN_F7R2_FB26_Msk                               /*!<Filter bit 26 */
#define CAN_F7R2_FB27_Pos      (27U)                                           
#define CAN_F7R2_FB27_Msk      (0x1U << CAN_F7R2_FB27_Pos)                     /*!< 0x08000000 */
#define CAN_F7R2_FB27          CAN_F7R2_FB27_Msk                               /*!<Filter bit 27 */
#define CAN_F7R2_FB28_Pos      (28U)                                           
#define CAN_F7R2_FB28_Msk      (0x1U << CAN_F7R2_FB28_Pos)                     /*!< 0x10000000 */
#define CAN_F7R2_FB28          CAN_F7R2_FB28_Msk                               /*!<Filter bit 28 */
#define CAN_F7R2_FB29_Pos      (29U)                                           
#define CAN_F7R2_FB29_Msk      (0x1U << CAN_F7R2_FB29_Pos)                     /*!< 0x20000000 */
#define CAN_F7R2_FB29          CAN_F7R2_FB29_Msk                               /*!<Filter bit 29 */
#define CAN_F7R2_FB30_Pos      (30U)                                           
#define CAN_F7R2_FB30_Msk      (0x1U << CAN_F7R2_FB30_Pos)                     /*!< 0x40000000 */
#define CAN_F7R2_FB30          CAN_F7R2_FB30_Msk                               /*!<Filter bit 30 */
#define CAN_F7R2_FB31_Pos      (31U)                                           
#define CAN_F7R2_FB31_Msk      (0x1U << CAN_F7R2_FB31_Pos)                     /*!< 0x80000000 */
#define CAN_F7R2_FB31          CAN_F7R2_FB31_Msk                               /*!<Filter bit 31 */

/*******************  Bit definition for CAN_F8R2 register  *******************/
#define CAN_F8R2_FB0_Pos       (0U)                                            
#define CAN_F8R2_FB0_Msk       (0x1U << CAN_F8R2_FB0_Pos)                      /*!< 0x00000001 */
#define CAN_F8R2_FB0           CAN_F8R2_FB0_Msk                                /*!<Filter bit 0 */
#define CAN_F8R2_FB1_Pos       (1U)                                            
#define CAN_F8R2_FB1_Msk       (0x1U << CAN_F8R2_FB1_Pos)                      /*!< 0x00000002 */
#define CAN_F8R2_FB1           CAN_F8R2_FB1_Msk                                /*!<Filter bit 1 */
#define CAN_F8R2_FB2_Pos       (2U)                                            
#define CAN_F8R2_FB2_Msk       (0x1U << CAN_F8R2_FB2_Pos)                      /*!< 0x00000004 */
#define CAN_F8R2_FB2           CAN_F8R2_FB2_Msk                                /*!<Filter bit 2 */
#define CAN_F8R2_FB3_Pos       (3U)                                            
#define CAN_F8R2_FB3_Msk       (0x1U << CAN_F8R2_FB3_Pos)                      /*!< 0x00000008 */
#define CAN_F8R2_FB3           CAN_F8R2_FB3_Msk                                /*!<Filter bit 3 */
#define CAN_F8R2_FB4_Pos       (4U)                                            
#define CAN_F8R2_FB4_Msk       (0x1U << CAN_F8R2_FB4_Pos)                      /*!< 0x00000010 */
#define CAN_F8R2_FB4           CAN_F8R2_FB4_Msk                                /*!<Filter bit 4 */
#define CAN_F8R2_FB5_Pos       (5U)                                            
#define CAN_F8R2_FB5_Msk       (0x1U << CAN_F8R2_FB5_Pos)                      /*!< 0x00000020 */
#define CAN_F8R2_FB5           CAN_F8R2_FB5_Msk                                /*!<Filter bit 5 */
#define CAN_F8R2_FB6_Pos       (6U)                                            
#define CAN_F8R2_FB6_Msk       (0x1U << CAN_F8R2_FB6_Pos)                      /*!< 0x00000040 */
#define CAN_F8R2_FB6           CAN_F8R2_FB6_Msk                                /*!<Filter bit 6 */
#define CAN_F8R2_FB7_Pos       (7U)                                            
#define CAN_F8R2_FB7_Msk       (0x1U << CAN_F8R2_FB7_Pos)                      /*!< 0x00000080 */
#define CAN_F8R2_FB7           CAN_F8R2_FB7_Msk                                /*!<Filter bit 7 */
#define CAN_F8R2_FB8_Pos       (8U)                                            
#define CAN_F8R2_FB8_Msk       (0x1U << CAN_F8R2_FB8_Pos)                      /*!< 0x00000100 */
#define CAN_F8R2_FB8           CAN_F8R2_FB8_Msk                                /*!<Filter bit 8 */
#define CAN_F8R2_FB9_Pos       (9U)                                            
#define CAN_F8R2_FB9_Msk       (0x1U << CAN_F8R2_FB9_Pos)                      /*!< 0x00000200 */
#define CAN_F8R2_FB9           CAN_F8R2_FB9_Msk                                /*!<Filter bit 9 */
#define CAN_F8R2_FB10_Pos      (10U)                                           
#define CAN_F8R2_FB10_Msk      (0x1U << CAN_F8R2_FB10_Pos)                     /*!< 0x00000400 */
#define CAN_F8R2_FB10          CAN_F8R2_FB10_Msk                               /*!<Filter bit 10 */
#define CAN_F8R2_FB11_Pos      (11U)                                           
#define CAN_F8R2_FB11_Msk      (0x1U << CAN_F8R2_FB11_Pos)                     /*!< 0x00000800 */
#define CAN_F8R2_FB11          CAN_F8R2_FB11_Msk                               /*!<Filter bit 11 */
#define CAN_F8R2_FB12_Pos      (12U)                                           
#define CAN_F8R2_FB12_Msk      (0x1U << CAN_F8R2_FB12_Pos)                     /*!< 0x00001000 */
#define CAN_F8R2_FB12          CAN_F8R2_FB12_Msk                               /*!<Filter bit 12 */
#define CAN_F8R2_FB13_Pos      (13U)                                           
#define CAN_F8R2_FB13_Msk      (0x1U << CAN_F8R2_FB13_Pos)                     /*!< 0x00002000 */
#define CAN_F8R2_FB13          CAN_F8R2_FB13_Msk                               /*!<Filter bit 13 */
#define CAN_F8R2_FB14_Pos      (14U)                                           
#define CAN_F8R2_FB14_Msk      (0x1U << CAN_F8R2_FB14_Pos)                     /*!< 0x00004000 */
#define CAN_F8R2_FB14          CAN_F8R2_FB14_Msk                               /*!<Filter bit 14 */
#define CAN_F8R2_FB15_Pos      (15U)                                           
#define CAN_F8R2_FB15_Msk      (0x1U << CAN_F8R2_FB15_Pos)                     /*!< 0x00008000 */
#define CAN_F8R2_FB15          CAN_F8R2_FB15_Msk                               /*!<Filter bit 15 */
#define CAN_F8R2_FB16_Pos      (16U)                                           
#define CAN_F8R2_FB16_Msk      (0x1U << CAN_F8R2_FB16_Pos)                     /*!< 0x00010000 */
#define CAN_F8R2_FB16          CAN_F8R2_FB16_Msk                               /*!<Filter bit 16 */
#define CAN_F8R2_FB17_Pos      (17U)                                           
#define CAN_F8R2_FB17_Msk      (0x1U << CAN_F8R2_FB17_Pos)                     /*!< 0x00020000 */
#define CAN_F8R2_FB17          CAN_F8R2_FB17_Msk                               /*!<Filter bit 17 */
#define CAN_F8R2_FB18_Pos      (18U)                                           
#define CAN_F8R2_FB18_Msk      (0x1U << CAN_F8R2_FB18_Pos)                     /*!< 0x00040000 */
#define CAN_F8R2_FB18          CAN_F8R2_FB18_Msk                               /*!<Filter bit 18 */
#define CAN_F8R2_FB19_Pos      (19U)                                           
#define CAN_F8R2_FB19_Msk      (0x1U << CAN_F8R2_FB19_Pos)                     /*!< 0x00080000 */
#define CAN_F8R2_FB19          CAN_F8R2_FB19_Msk                               /*!<Filter bit 19 */
#define CAN_F8R2_FB20_Pos      (20U)                                           
#define CAN_F8R2_FB20_Msk      (0x1U << CAN_F8R2_FB20_Pos)                     /*!< 0x00100000 */
#define CAN_F8R2_FB20          CAN_F8R2_FB20_Msk                               /*!<Filter bit 20 */
#define CAN_F8R2_FB21_Pos      (21U)                                           
#define CAN_F8R2_FB21_Msk      (0x1U << CAN_F8R2_FB21_Pos)                     /*!< 0x00200000 */
#define CAN_F8R2_FB21          CAN_F8R2_FB21_Msk                               /*!<Filter bit 21 */
#define CAN_F8R2_FB22_Pos      (22U)                                           
#define CAN_F8R2_FB22_Msk      (0x1U << CAN_F8R2_FB22_Pos)                     /*!< 0x00400000 */
#define CAN_F8R2_FB22          CAN_F8R2_FB22_Msk                               /*!<Filter bit 22 */
#define CAN_F8R2_FB23_Pos      (23U)                                           
#define CAN_F8R2_FB23_Msk      (0x1U << CAN_F8R2_FB23_Pos)                     /*!< 0x00800000 */
#define CAN_F8R2_FB23          CAN_F8R2_FB23_Msk                               /*!<Filter bit 23 */
#define CAN_F8R2_FB24_Pos      (24U)                                           
#define CAN_F8R2_FB24_Msk      (0x1U << CAN_F8R2_FB24_Pos)                     /*!< 0x01000000 */
#define CAN_F8R2_FB24          CAN_F8R2_FB24_Msk                               /*!<Filter bit 24 */
#define CAN_F8R2_FB25_Pos      (25U)                                           
#define CAN_F8R2_FB25_Msk      (0x1U << CAN_F8R2_FB25_Pos)                     /*!< 0x02000000 */
#define CAN_F8R2_FB25          CAN_F8R2_FB25_Msk                               /*!<Filter bit 25 */
#define CAN_F8R2_FB26_Pos      (26U)                                           
#define CAN_F8R2_FB26_Msk      (0x1U << CAN_F8R2_FB26_Pos)                     /*!< 0x04000000 */
#define CAN_F8R2_FB26          CAN_F8R2_FB26_Msk                               /*!<Filter bit 26 */
#define CAN_F8R2_FB27_Pos      (27U)                                           
#define CAN_F8R2_FB27_Msk      (0x1U << CAN_F8R2_FB27_Pos)                     /*!< 0x08000000 */
#define CAN_F8R2_FB27          CAN_F8R2_FB27_Msk                               /*!<Filter bit 27 */
#define CAN_F8R2_FB28_Pos      (28U)                                           
#define CAN_F8R2_FB28_Msk      (0x1U << CAN_F8R2_FB28_Pos)                     /*!< 0x10000000 */
#define CAN_F8R2_FB28          CAN_F8R2_FB28_Msk                               /*!<Filter bit 28 */
#define CAN_F8R2_FB29_Pos      (29U)                                           
#define CAN_F8R2_FB29_Msk      (0x1U << CAN_F8R2_FB29_Pos)                     /*!< 0x20000000 */
#define CAN_F8R2_FB29          CAN_F8R2_FB29_Msk                               /*!<Filter bit 29 */
#define CAN_F8R2_FB30_Pos      (30U)                                           
#define CAN_F8R2_FB30_Msk      (0x1U << CAN_F8R2_FB30_Pos)                     /*!< 0x40000000 */
#define CAN_F8R2_FB30          CAN_F8R2_FB30_Msk                               /*!<Filter bit 30 */
#define CAN_F8R2_FB31_Pos      (31U)                                           
#define CAN_F8R2_FB31_Msk      (0x1U << CAN_F8R2_FB31_Pos)                     /*!< 0x80000000 */
#define CAN_F8R2_FB31          CAN_F8R2_FB31_Msk                               /*!<Filter bit 31 */

/*******************  Bit definition for CAN_F9R2 register  *******************/
#define CAN_F9R2_FB0_Pos       (0U)                                            
#define CAN_F9R2_FB0_Msk       (0x1U << CAN_F9R2_FB0_Pos)                      /*!< 0x00000001 */
#define CAN_F9R2_FB0           CAN_F9R2_FB0_Msk                                /*!<Filter bit 0 */
#define CAN_F9R2_FB1_Pos       (1U)                                            
#define CAN_F9R2_FB1_Msk       (0x1U << CAN_F9R2_FB1_Pos)                      /*!< 0x00000002 */
#define CAN_F9R2_FB1           CAN_F9R2_FB1_Msk                                /*!<Filter bit 1 */
#define CAN_F9R2_FB2_Pos       (2U)                                            
#define CAN_F9R2_FB2_Msk       (0x1U << CAN_F9R2_FB2_Pos)                      /*!< 0x00000004 */
#define CAN_F9R2_FB2           CAN_F9R2_FB2_Msk                                /*!<Filter bit 2 */
#define CAN_F9R2_FB3_Pos       (3U)                                            
#define CAN_F9R2_FB3_Msk       (0x1U << CAN_F9R2_FB3_Pos)                      /*!< 0x00000008 */
#define CAN_F9R2_FB3           CAN_F9R2_FB3_Msk                                /*!<Filter bit 3 */
#define CAN_F9R2_FB4_Pos       (4U)                                            
#define CAN_F9R2_FB4_Msk       (0x1U << CAN_F9R2_FB4_Pos)                      /*!< 0x00000010 */
#define CAN_F9R2_FB4           CAN_F9R2_FB4_Msk                                /*!<Filter bit 4 */
#define CAN_F9R2_FB5_Pos       (5U)                                            
#define CAN_F9R2_FB5_Msk       (0x1U << CAN_F9R2_FB5_Pos)                      /*!< 0x00000020 */
#define CAN_F9R2_FB5           CAN_F9R2_FB5_Msk                                /*!<Filter bit 5 */
#define CAN_F9R2_FB6_Pos       (6U)                                            
#define CAN_F9R2_FB6_Msk       (0x1U << CAN_F9R2_FB6_Pos)                      /*!< 0x00000040 */
#define CAN_F9R2_FB6           CAN_F9R2_FB6_Msk                                /*!<Filter bit 6 */
#define CAN_F9R2_FB7_Pos       (7U)                                            
#define CAN_F9R2_FB7_Msk       (0x1U << CAN_F9R2_FB7_Pos)                      /*!< 0x00000080 */
#define CAN_F9R2_FB7           CAN_F9R2_FB7_Msk                                /*!<Filter bit 7 */
#define CAN_F9R2_FB8_Pos       (8U)                                            
#define CAN_F9R2_FB8_Msk       (0x1U << CAN_F9R2_FB8_Pos)                      /*!< 0x00000100 */
#define CAN_F9R2_FB8           CAN_F9R2_FB8_Msk                                /*!<Filter bit 8 */
#define CAN_F9R2_FB9_Pos       (9U)                                            
#define CAN_F9R2_FB9_Msk       (0x1U << CAN_F9R2_FB9_Pos)                      /*!< 0x00000200 */
#define CAN_F9R2_FB9           CAN_F9R2_FB9_Msk                                /*!<Filter bit 9 */
#define CAN_F9R2_FB10_Pos      (10U)                                           
#define CAN_F9R2_FB10_Msk      (0x1U << CAN_F9R2_FB10_Pos)                     /*!< 0x00000400 */
#define CAN_F9R2_FB10          CAN_F9R2_FB10_Msk                               /*!<Filter bit 10 */
#define CAN_F9R2_FB11_Pos      (11U)                                           
#define CAN_F9R2_FB11_Msk      (0x1U << CAN_F9R2_FB11_Pos)                     /*!< 0x00000800 */
#define CAN_F9R2_FB11          CAN_F9R2_FB11_Msk                               /*!<Filter bit 11 */
#define CAN_F9R2_FB12_Pos      (12U)                                           
#define CAN_F9R2_FB12_Msk      (0x1U << CAN_F9R2_FB12_Pos)                     /*!< 0x00001000 */
#define CAN_F9R2_FB12          CAN_F9R2_FB12_Msk                               /*!<Filter bit 12 */
#define CAN_F9R2_FB13_Pos      (13U)                                           
#define CAN_F9R2_FB13_Msk      (0x1U << CAN_F9R2_FB13_Pos)                     /*!< 0x00002000 */
#define CAN_F9R2_FB13          CAN_F9R2_FB13_Msk                               /*!<Filter bit 13 */
#define CAN_F9R2_FB14_Pos      (14U)                                           
#define CAN_F9R2_FB14_Msk      (0x1U << CAN_F9R2_FB14_Pos)                     /*!< 0x00004000 */
#define CAN_F9R2_FB14          CAN_F9R2_FB14_Msk                               /*!<Filter bit 14 */
#define CAN_F9R2_FB15_Pos      (15U)                                           
#define CAN_F9R2_FB15_Msk      (0x1U << CAN_F9R2_FB15_Pos)                     /*!< 0x00008000 */
#define CAN_F9R2_FB15          CAN_F9R2_FB15_Msk                               /*!<Filter bit 15 */
#define CAN_F9R2_FB16_Pos      (16U)                                           
#define CAN_F9R2_FB16_Msk      (0x1U << CAN_F9R2_FB16_Pos)                     /*!< 0x00010000 */
#define CAN_F9R2_FB16          CAN_F9R2_FB16_Msk                               /*!<Filter bit 16 */
#define CAN_F9R2_FB17_Pos      (17U)                                           
#define CAN_F9R2_FB17_Msk      (0x1U << CAN_F9R2_FB17_Pos)                     /*!< 0x00020000 */
#define CAN_F9R2_FB17          CAN_F9R2_FB17_Msk                               /*!<Filter bit 17 */
#define CAN_F9R2_FB18_Pos      (18U)                                           
#define CAN_F9R2_FB18_Msk      (0x1U << CAN_F9R2_FB18_Pos)                     /*!< 0x00040000 */
#define CAN_F9R2_FB18          CAN_F9R2_FB18_Msk                               /*!<Filter bit 18 */
#define CAN_F9R2_FB19_Pos      (19U)                                           
#define CAN_F9R2_FB19_Msk      (0x1U << CAN_F9R2_FB19_Pos)                     /*!< 0x00080000 */
#define CAN_F9R2_FB19          CAN_F9R2_FB19_Msk                               /*!<Filter bit 19 */
#define CAN_F9R2_FB20_Pos      (20U)                                           
#define CAN_F9R2_FB20_Msk      (0x1U << CAN_F9R2_FB20_Pos)                     /*!< 0x00100000 */
#define CAN_F9R2_FB20          CAN_F9R2_FB20_Msk                               /*!<Filter bit 20 */
#define CAN_F9R2_FB21_Pos      (21U)                                           
#define CAN_F9R2_FB21_Msk      (0x1U << CAN_F9R2_FB21_Pos)                     /*!< 0x00200000 */
#define CAN_F9R2_FB21          CAN_F9R2_FB21_Msk                               /*!<Filter bit 21 */
#define CAN_F9R2_FB22_Pos      (22U)                                           
#define CAN_F9R2_FB22_Msk      (0x1U << CAN_F9R2_FB22_Pos)                     /*!< 0x00400000 */
#define CAN_F9R2_FB22          CAN_F9R2_FB22_Msk                               /*!<Filter bit 22 */
#define CAN_F9R2_FB23_Pos      (23U)                                           
#define CAN_F9R2_FB23_Msk      (0x1U << CAN_F9R2_FB23_Pos)                     /*!< 0x00800000 */
#define CAN_F9R2_FB23          CAN_F9R2_FB23_Msk                               /*!<Filter bit 23 */
#define CAN_F9R2_FB24_Pos      (24U)                                           
#define CAN_F9R2_FB24_Msk      (0x1U << CAN_F9R2_FB24_Pos)                     /*!< 0x01000000 */
#define CAN_F9R2_FB24          CAN_F9R2_FB24_Msk                               /*!<Filter bit 24 */
#define CAN_F9R2_FB25_Pos      (25U)                                           
#define CAN_F9R2_FB25_Msk      (0x1U << CAN_F9R2_FB25_Pos)                     /*!< 0x02000000 */
#define CAN_F9R2_FB25          CAN_F9R2_FB25_Msk                               /*!<Filter bit 25 */
#define CAN_F9R2_FB26_Pos      (26U)                                           
#define CAN_F9R2_FB26_Msk      (0x1U << CAN_F9R2_FB26_Pos)                     /*!< 0x04000000 */
#define CAN_F9R2_FB26          CAN_F9R2_FB26_Msk                               /*!<Filter bit 26 */
#define CAN_F9R2_FB27_Pos      (27U)                                           
#define CAN_F9R2_FB27_Msk      (0x1U << CAN_F9R2_FB27_Pos)                     /*!< 0x08000000 */
#define CAN_F9R2_FB27          CAN_F9R2_FB27_Msk                               /*!<Filter bit 27 */
#define CAN_F9R2_FB28_Pos      (28U)                                           
#define CAN_F9R2_FB28_Msk      (0x1U << CAN_F9R2_FB28_Pos)                     /*!< 0x10000000 */
#define CAN_F9R2_FB28          CAN_F9R2_FB28_Msk                               /*!<Filter bit 28 */
#define CAN_F9R2_FB29_Pos      (29U)                                           
#define CAN_F9R2_FB29_Msk      (0x1U << CAN_F9R2_FB29_Pos)                     /*!< 0x20000000 */
#define CAN_F9R2_FB29          CAN_F9R2_FB29_Msk                               /*!<Filter bit 29 */
#define CAN_F9R2_FB30_Pos      (30U)                                           
#define CAN_F9R2_FB30_Msk      (0x1U << CAN_F9R2_FB30_Pos)                     /*!< 0x40000000 */
#define CAN_F9R2_FB30          CAN_F9R2_FB30_Msk                               /*!<Filter bit 30 */
#define CAN_F9R2_FB31_Pos      (31U)                                           
#define CAN_F9R2_FB31_Msk      (0x1U << CAN_F9R2_FB31_Pos)                     /*!< 0x80000000 */
#define CAN_F9R2_FB31          CAN_F9R2_FB31_Msk                               /*!<Filter bit 31 */

/*******************  Bit definition for CAN_F10R2 register  ******************/
#define CAN_F10R2_FB0_Pos      (0U)                                            
#define CAN_F10R2_FB0_Msk      (0x1U << CAN_F10R2_FB0_Pos)                     /*!< 0x00000001 */
#define CAN_F10R2_FB0          CAN_F10R2_FB0_Msk                               /*!<Filter bit 0 */
#define CAN_F10R2_FB1_Pos      (1U)                                            
#define CAN_F10R2_FB1_Msk      (0x1U << CAN_F10R2_FB1_Pos)                     /*!< 0x00000002 */
#define CAN_F10R2_FB1          CAN_F10R2_FB1_Msk                               /*!<Filter bit 1 */
#define CAN_F10R2_FB2_Pos      (2U)                                            
#define CAN_F10R2_FB2_Msk      (0x1U << CAN_F10R2_FB2_Pos)                     /*!< 0x00000004 */
#define CAN_F10R2_FB2          CAN_F10R2_FB2_Msk                               /*!<Filter bit 2 */
#define CAN_F10R2_FB3_Pos      (3U)                                            
#define CAN_F10R2_FB3_Msk      (0x1U << CAN_F10R2_FB3_Pos)                     /*!< 0x00000008 */
#define CAN_F10R2_FB3          CAN_F10R2_FB3_Msk                               /*!<Filter bit 3 */
#define CAN_F10R2_FB4_Pos      (4U)                                            
#define CAN_F10R2_FB4_Msk      (0x1U << CAN_F10R2_FB4_Pos)                     /*!< 0x00000010 */
#define CAN_F10R2_FB4          CAN_F10R2_FB4_Msk                               /*!<Filter bit 4 */
#define CAN_F10R2_FB5_Pos      (5U)                                            
#define CAN_F10R2_FB5_Msk      (0x1U << CAN_F10R2_FB5_Pos)                     /*!< 0x00000020 */
#define CAN_F10R2_FB5          CAN_F10R2_FB5_Msk                               /*!<Filter bit 5 */
#define CAN_F10R2_FB6_Pos      (6U)                                            
#define CAN_F10R2_FB6_Msk      (0x1U << CAN_F10R2_FB6_Pos)                     /*!< 0x00000040 */
#define CAN_F10R2_FB6          CAN_F10R2_FB6_Msk                               /*!<Filter bit 6 */
#define CAN_F10R2_FB7_Pos      (7U)                                            
#define CAN_F10R2_FB7_Msk      (0x1U << CAN_F10R2_FB7_Pos)                     /*!< 0x00000080 */
#define CAN_F10R2_FB7          CAN_F10R2_FB7_Msk                               /*!<Filter bit 7 */
#define CAN_F10R2_FB8_Pos      (8U)                                            
#define CAN_F10R2_FB8_Msk      (0x1U << CAN_F10R2_FB8_Pos)                     /*!< 0x00000100 */
#define CAN_F10R2_FB8          CAN_F10R2_FB8_Msk                               /*!<Filter bit 8 */
#define CAN_F10R2_FB9_Pos      (9U)                                            
#define CAN_F10R2_FB9_Msk      (0x1U << CAN_F10R2_FB9_Pos)                     /*!< 0x00000200 */
#define CAN_F10R2_FB9          CAN_F10R2_FB9_Msk                               /*!<Filter bit 9 */
#define CAN_F10R2_FB10_Pos     (10U)                                           
#define CAN_F10R2_FB10_Msk     (0x1U << CAN_F10R2_FB10_Pos)                    /*!< 0x00000400 */
#define CAN_F10R2_FB10         CAN_F10R2_FB10_Msk                              /*!<Filter bit 10 */
#define CAN_F10R2_FB11_Pos     (11U)                                           
#define CAN_F10R2_FB11_Msk     (0x1U << CAN_F10R2_FB11_Pos)                    /*!< 0x00000800 */
#define CAN_F10R2_FB11         CAN_F10R2_FB11_Msk                              /*!<Filter bit 11 */
#define CAN_F10R2_FB12_Pos     (12U)                                           
#define CAN_F10R2_FB12_Msk     (0x1U << CAN_F10R2_FB12_Pos)                    /*!< 0x00001000 */
#define CAN_F10R2_FB12         CAN_F10R2_FB12_Msk                              /*!<Filter bit 12 */
#define CAN_F10R2_FB13_Pos     (13U)                                           
#define CAN_F10R2_FB13_Msk     (0x1U << CAN_F10R2_FB13_Pos)                    /*!< 0x00002000 */
#define CAN_F10R2_FB13         CAN_F10R2_FB13_Msk                              /*!<Filter bit 13 */
#define CAN_F10R2_FB14_Pos     (14U)                                           
#define CAN_F10R2_FB14_Msk     (0x1U << CAN_F10R2_FB14_Pos)                    /*!< 0x00004000 */
#define CAN_F10R2_FB14         CAN_F10R2_FB14_Msk                              /*!<Filter bit 14 */
#define CAN_F10R2_FB15_Pos     (15U)                                           
#define CAN_F10R2_FB15_Msk     (0x1U << CAN_F10R2_FB15_Pos)                    /*!< 0x00008000 */
#define CAN_F10R2_FB15         CAN_F10R2_FB15_Msk                              /*!<Filter bit 15 */
#define CAN_F10R2_FB16_Pos     (16U)                                           
#define CAN_F10R2_FB16_Msk     (0x1U << CAN_F10R2_FB16_Pos)                    /*!< 0x00010000 */
#define CAN_F10R2_FB16         CAN_F10R2_FB16_Msk                              /*!<Filter bit 16 */
#define CAN_F10R2_FB17_Pos     (17U)                                           
#define CAN_F10R2_FB17_Msk     (0x1U << CAN_F10R2_FB17_Pos)                    /*!< 0x00020000 */
#define CAN_F10R2_FB17         CAN_F10R2_FB17_Msk                              /*!<Filter bit 17 */
#define CAN_F10R2_FB18_Pos     (18U)                                           
#define CAN_F10R2_FB18_Msk     (0x1U << CAN_F10R2_FB18_Pos)                    /*!< 0x00040000 */
#define CAN_F10R2_FB18         CAN_F10R2_FB18_Msk                              /*!<Filter bit 18 */
#define CAN_F10R2_FB19_Pos     (19U)                                           
#define CAN_F10R2_FB19_Msk     (0x1U << CAN_F10R2_FB19_Pos)                    /*!< 0x00080000 */
#define CAN_F10R2_FB19         CAN_F10R2_FB19_Msk                              /*!<Filter bit 19 */
#define CAN_F10R2_FB20_Pos     (20U)                                           
#define CAN_F10R2_FB20_Msk     (0x1U << CAN_F10R2_FB20_Pos)                    /*!< 0x00100000 */
#define CAN_F10R2_FB20         CAN_F10R2_FB20_Msk                              /*!<Filter bit 20 */
#define CAN_F10R2_FB21_Pos     (21U)                                           
#define CAN_F10R2_FB21_Msk     (0x1U << CAN_F10R2_FB21_Pos)                    /*!< 0x00200000 */
#define CAN_F10R2_FB21         CAN_F10R2_FB21_Msk                              /*!<Filter bit 21 */
#define CAN_F10R2_FB22_Pos     (22U)                                           
#define CAN_F10R2_FB22_Msk     (0x1U << CAN_F10R2_FB22_Pos)                    /*!< 0x00400000 */
#define CAN_F10R2_FB22         CAN_F10R2_FB22_Msk                              /*!<Filter bit 22 */
#define CAN_F10R2_FB23_Pos     (23U)                                           
#define CAN_F10R2_FB23_Msk     (0x1U << CAN_F10R2_FB23_Pos)                    /*!< 0x00800000 */
#define CAN_F10R2_FB23         CAN_F10R2_FB23_Msk                              /*!<Filter bit 23 */
#define CAN_F10R2_FB24_Pos     (24U)                                           
#define CAN_F10R2_FB24_Msk     (0x1U << CAN_F10R2_FB24_Pos)                    /*!< 0x01000000 */
#define CAN_F10R2_FB24         CAN_F10R2_FB24_Msk                              /*!<Filter bit 24 */
#define CAN_F10R2_FB25_Pos     (25U)                                           
#define CAN_F10R2_FB25_Msk     (0x1U << CAN_F10R2_FB25_Pos)                    /*!< 0x02000000 */
#define CAN_F10R2_FB25         CAN_F10R2_FB25_Msk                              /*!<Filter bit 25 */
#define CAN_F10R2_FB26_Pos     (26U)                                           
#define CAN_F10R2_FB26_Msk     (0x1U << CAN_F10R2_FB26_Pos)                    /*!< 0x04000000 */
#define CAN_F10R2_FB26         CAN_F10R2_FB26_Msk                              /*!<Filter bit 26 */
#define CAN_F10R2_FB27_Pos     (27U)                                           
#define CAN_F10R2_FB27_Msk     (0x1U << CAN_F10R2_FB27_Pos)                    /*!< 0x08000000 */
#define CAN_F10R2_FB27         CAN_F10R2_FB27_Msk                              /*!<Filter bit 27 */
#define CAN_F10R2_FB28_Pos     (28U)                                           
#define CAN_F10R2_FB28_Msk     (0x1U << CAN_F10R2_FB28_Pos)                    /*!< 0x10000000 */
#define CAN_F10R2_FB28         CAN_F10R2_FB28_Msk                              /*!<Filter bit 28 */
#define CAN_F10R2_FB29_Pos     (29U)                                           
#define CAN_F10R2_FB29_Msk     (0x1U << CAN_F10R2_FB29_Pos)                    /*!< 0x20000000 */
#define CAN_F10R2_FB29         CAN_F10R2_FB29_Msk                              /*!<Filter bit 29 */
#define CAN_F10R2_FB30_Pos     (30U)                                           
#define CAN_F10R2_FB30_Msk     (0x1U << CAN_F10R2_FB30_Pos)                    /*!< 0x40000000 */
#define CAN_F10R2_FB30         CAN_F10R2_FB30_Msk                              /*!<Filter bit 30 */
#define CAN_F10R2_FB31_Pos     (31U)                                           
#define CAN_F10R2_FB31_Msk     (0x1U << CAN_F10R2_FB31_Pos)                    /*!< 0x80000000 */
#define CAN_F10R2_FB31         CAN_F10R2_FB31_Msk                              /*!<Filter bit 31 */

/*******************  Bit definition for CAN_F11R2 register  ******************/
#define CAN_F11R2_FB0_Pos      (0U)                                            
#define CAN_F11R2_FB0_Msk      (0x1U << CAN_F11R2_FB0_Pos)                     /*!< 0x00000001 */
#define CAN_F11R2_FB0          CAN_F11R2_FB0_Msk                               /*!<Filter bit 0 */
#define CAN_F11R2_FB1_Pos      (1U)                                            
#define CAN_F11R2_FB1_Msk      (0x1U << CAN_F11R2_FB1_Pos)                     /*!< 0x00000002 */
#define CAN_F11R2_FB1          CAN_F11R2_FB1_Msk                               /*!<Filter bit 1 */
#define CAN_F11R2_FB2_Pos      (2U)                                            
#define CAN_F11R2_FB2_Msk      (0x1U << CAN_F11R2_FB2_Pos)                     /*!< 0x00000004 */
#define CAN_F11R2_FB2          CAN_F11R2_FB2_Msk                               /*!<Filter bit 2 */
#define CAN_F11R2_FB3_Pos      (3U)                                            
#define CAN_F11R2_FB3_Msk      (0x1U << CAN_F11R2_FB3_Pos)                     /*!< 0x00000008 */
#define CAN_F11R2_FB3          CAN_F11R2_FB3_Msk                               /*!<Filter bit 3 */
#define CAN_F11R2_FB4_Pos      (4U)                                            
#define CAN_F11R2_FB4_Msk      (0x1U << CAN_F11R2_FB4_Pos)                     /*!< 0x00000010 */
#define CAN_F11R2_FB4          CAN_F11R2_FB4_Msk                               /*!<Filter bit 4 */
#define CAN_F11R2_FB5_Pos      (5U)                                            
#define CAN_F11R2_FB5_Msk      (0x1U << CAN_F11R2_FB5_Pos)                     /*!< 0x00000020 */
#define CAN_F11R2_FB5          CAN_F11R2_FB5_Msk                               /*!<Filter bit 5 */
#define CAN_F11R2_FB6_Pos      (6U)                                            
#define CAN_F11R2_FB6_Msk      (0x1U << CAN_F11R2_FB6_Pos)                     /*!< 0x00000040 */
#define CAN_F11R2_FB6          CAN_F11R2_FB6_Msk                               /*!<Filter bit 6 */
#define CAN_F11R2_FB7_Pos      (7U)                                            
#define CAN_F11R2_FB7_Msk      (0x1U << CAN_F11R2_FB7_Pos)                     /*!< 0x00000080 */
#define CAN_F11R2_FB7          CAN_F11R2_FB7_Msk                               /*!<Filter bit 7 */
#define CAN_F11R2_FB8_Pos      (8U)                                            
#define CAN_F11R2_FB8_Msk      (0x1U << CAN_F11R2_FB8_Pos)                     /*!< 0x00000100 */
#define CAN_F11R2_FB8          CAN_F11R2_FB8_Msk                               /*!<Filter bit 8 */
#define CAN_F11R2_FB9_Pos      (9U)                                            
#define CAN_F11R2_FB9_Msk      (0x1U << CAN_F11R2_FB9_Pos)                     /*!< 0x00000200 */
#define CAN_F11R2_FB9          CAN_F11R2_FB9_Msk                               /*!<Filter bit 9 */
#define CAN_F11R2_FB10_Pos     (10U)                                           
#define CAN_F11R2_FB10_Msk     (0x1U << CAN_F11R2_FB10_Pos)                    /*!< 0x00000400 */
#define CAN_F11R2_FB10         CAN_F11R2_FB10_Msk                              /*!<Filter bit 10 */
#define CAN_F11R2_FB11_Pos     (11U)                                           
#define CAN_F11R2_FB11_Msk     (0x1U << CAN_F11R2_FB11_Pos)                    /*!< 0x00000800 */
#define CAN_F11R2_FB11         CAN_F11R2_FB11_Msk                              /*!<Filter bit 11 */
#define CAN_F11R2_FB12_Pos     (12U)                                           
#define CAN_F11R2_FB12_Msk     (0x1U << CAN_F11R2_FB12_Pos)                    /*!< 0x00001000 */
#define CAN_F11R2_FB12         CAN_F11R2_FB12_Msk                              /*!<Filter bit 12 */
#define CAN_F11R2_FB13_Pos     (13U)                                           
#define CAN_F11R2_FB13_Msk     (0x1U << CAN_F11R2_FB13_Pos)                    /*!< 0x00002000 */
#define CAN_F11R2_FB13         CAN_F11R2_FB13_Msk                              /*!<Filter bit 13 */
#define CAN_F11R2_FB14_Pos     (14U)                                           
#define CAN_F11R2_FB14_Msk     (0x1U << CAN_F11R2_FB14_Pos)                    /*!< 0x00004000 */
#define CAN_F11R2_FB14         CAN_F11R2_FB14_Msk                              /*!<Filter bit 14 */
#define CAN_F11R2_FB15_Pos     (15U)                                           
#define CAN_F11R2_FB15_Msk     (0x1U << CAN_F11R2_FB15_Pos)                    /*!< 0x00008000 */
#define CAN_F11R2_FB15         CAN_F11R2_FB15_Msk                              /*!<Filter bit 15 */
#define CAN_F11R2_FB16_Pos     (16U)                                           
#define CAN_F11R2_FB16_Msk     (0x1U << CAN_F11R2_FB16_Pos)                    /*!< 0x00010000 */
#define CAN_F11R2_FB16         CAN_F11R2_FB16_Msk                              /*!<Filter bit 16 */
#define CAN_F11R2_FB17_Pos     (17U)                                           
#define CAN_F11R2_FB17_Msk     (0x1U << CAN_F11R2_FB17_Pos)                    /*!< 0x00020000 */
#define CAN_F11R2_FB17         CAN_F11R2_FB17_Msk                              /*!<Filter bit 17 */
#define CAN_F11R2_FB18_Pos     (18U)                                           
#define CAN_F11R2_FB18_Msk     (0x1U << CAN_F11R2_FB18_Pos)                    /*!< 0x00040000 */
#define CAN_F11R2_FB18         CAN_F11R2_FB18_Msk                              /*!<Filter bit 18 */
#define CAN_F11R2_FB19_Pos     (19U)                                           
#define CAN_F11R2_FB19_Msk     (0x1U << CAN_F11R2_FB19_Pos)                    /*!< 0x00080000 */
#define CAN_F11R2_FB19         CAN_F11R2_FB19_Msk                              /*!<Filter bit 19 */
#define CAN_F11R2_FB20_Pos     (20U)                                           
#define CAN_F11R2_FB20_Msk     (0x1U << CAN_F11R2_FB20_Pos)                    /*!< 0x00100000 */
#define CAN_F11R2_FB20         CAN_F11R2_FB20_Msk                              /*!<Filter bit 20 */
#define CAN_F11R2_FB21_Pos     (21U)                                           
#define CAN_F11R2_FB21_Msk     (0x1U << CAN_F11R2_FB21_Pos)                    /*!< 0x00200000 */
#define CAN_F11R2_FB21         CAN_F11R2_FB21_Msk                              /*!<Filter bit 21 */
#define CAN_F11R2_FB22_Pos     (22U)                                           
#define CAN_F11R2_FB22_Msk     (0x1U << CAN_F11R2_FB22_Pos)                    /*!< 0x00400000 */
#define CAN_F11R2_FB22         CAN_F11R2_FB22_Msk                              /*!<Filter bit 22 */
#define CAN_F11R2_FB23_Pos     (23U)                                           
#define CAN_F11R2_FB23_Msk     (0x1U << CAN_F11R2_FB23_Pos)                    /*!< 0x00800000 */
#define CAN_F11R2_FB23         CAN_F11R2_FB23_Msk                              /*!<Filter bit 23 */
#define CAN_F11R2_FB24_Pos     (24U)                                           
#define CAN_F11R2_FB24_Msk     (0x1U << CAN_F11R2_FB24_Pos)                    /*!< 0x01000000 */
#define CAN_F11R2_FB24         CAN_F11R2_FB24_Msk                              /*!<Filter bit 24 */
#define CAN_F11R2_FB25_Pos     (25U)                                           
#define CAN_F11R2_FB25_Msk     (0x1U << CAN_F11R2_FB25_Pos)                    /*!< 0x02000000 */
#define CAN_F11R2_FB25         CAN_F11R2_FB25_Msk                              /*!<Filter bit 25 */
#define CAN_F11R2_FB26_Pos     (26U)                                           
#define CAN_F11R2_FB26_Msk     (0x1U << CAN_F11R2_FB26_Pos)                    /*!< 0x04000000 */
#define CAN_F11R2_FB26         CAN_F11R2_FB26_Msk                              /*!<Filter bit 26 */
#define CAN_F11R2_FB27_Pos     (27U)                                           
#define CAN_F11R2_FB27_Msk     (0x1U << CAN_F11R2_FB27_Pos)                    /*!< 0x08000000 */
#define CAN_F11R2_FB27         CAN_F11R2_FB27_Msk                              /*!<Filter bit 27 */
#define CAN_F11R2_FB28_Pos     (28U)                                           
#define CAN_F11R2_FB28_Msk     (0x1U << CAN_F11R2_FB28_Pos)                    /*!< 0x10000000 */
#define CAN_F11R2_FB28         CAN_F11R2_FB28_Msk                              /*!<Filter bit 28 */
#define CAN_F11R2_FB29_Pos     (29U)                                           
#define CAN_F11R2_FB29_Msk     (0x1U << CAN_F11R2_FB29_Pos)                    /*!< 0x20000000 */
#define CAN_F11R2_FB29         CAN_F11R2_FB29_Msk                              /*!<Filter bit 29 */
#define CAN_F11R2_FB30_Pos     (30U)                                           
#define CAN_F11R2_FB30_Msk     (0x1U << CAN_F11R2_FB30_Pos)                    /*!< 0x40000000 */
#define CAN_F11R2_FB30         CAN_F11R2_FB30_Msk                              /*!<Filter bit 30 */
#define CAN_F11R2_FB31_Pos     (31U)                                           
#define CAN_F11R2_FB31_Msk     (0x1U << CAN_F11R2_FB31_Pos)                    /*!< 0x80000000 */
#define CAN_F11R2_FB31         CAN_F11R2_FB31_Msk                              /*!<Filter bit 31 */

/*******************  Bit definition for CAN_F12R2 register  ******************/
#define CAN_F12R2_FB0_Pos      (0U)                                            
#define CAN_F12R2_FB0_Msk      (0x1U << CAN_F12R2_FB0_Pos)                     /*!< 0x00000001 */
#define CAN_F12R2_FB0          CAN_F12R2_FB0_Msk                               /*!<Filter bit 0 */
#define CAN_F12R2_FB1_Pos      (1U)                                            
#define CAN_F12R2_FB1_Msk      (0x1U << CAN_F12R2_FB1_Pos)                     /*!< 0x00000002 */
#define CAN_F12R2_FB1          CAN_F12R2_FB1_Msk                               /*!<Filter bit 1 */
#define CAN_F12R2_FB2_Pos      (2U)                                            
#define CAN_F12R2_FB2_Msk      (0x1U << CAN_F12R2_FB2_Pos)                     /*!< 0x00000004 */
#define CAN_F12R2_FB2          CAN_F12R2_FB2_Msk                               /*!<Filter bit 2 */
#define CAN_F12R2_FB3_Pos      (3U)                                            
#define CAN_F12R2_FB3_Msk      (0x1U << CAN_F12R2_FB3_Pos)                     /*!< 0x00000008 */
#define CAN_F12R2_FB3          CAN_F12R2_FB3_Msk                               /*!<Filter bit 3 */
#define CAN_F12R2_FB4_Pos      (4U)                                            
#define CAN_F12R2_FB4_Msk      (0x1U << CAN_F12R2_FB4_Pos)                     /*!< 0x00000010 */
#define CAN_F12R2_FB4          CAN_F12R2_FB4_Msk                               /*!<Filter bit 4 */
#define CAN_F12R2_FB5_Pos      (5U)                                            
#define CAN_F12R2_FB5_Msk      (0x1U << CAN_F12R2_FB5_Pos)                     /*!< 0x00000020 */
#define CAN_F12R2_FB5          CAN_F12R2_FB5_Msk                               /*!<Filter bit 5 */
#define CAN_F12R2_FB6_Pos      (6U)                                            
#define CAN_F12R2_FB6_Msk      (0x1U << CAN_F12R2_FB6_Pos)                     /*!< 0x00000040 */
#define CAN_F12R2_FB6          CAN_F12R2_FB6_Msk                               /*!<Filter bit 6 */
#define CAN_F12R2_FB7_Pos      (7U)                                            
#define CAN_F12R2_FB7_Msk      (0x1U << CAN_F12R2_FB7_Pos)                     /*!< 0x00000080 */
#define CAN_F12R2_FB7          CAN_F12R2_FB7_Msk                               /*!<Filter bit 7 */
#define CAN_F12R2_FB8_Pos      (8U)                                            
#define CAN_F12R2_FB8_Msk      (0x1U << CAN_F12R2_FB8_Pos)                     /*!< 0x00000100 */
#define CAN_F12R2_FB8          CAN_F12R2_FB8_Msk                               /*!<Filter bit 8 */
#define CAN_F12R2_FB9_Pos      (9U)                                            
#define CAN_F12R2_FB9_Msk      (0x1U << CAN_F12R2_FB9_Pos)                     /*!< 0x00000200 */
#define CAN_F12R2_FB9          CAN_F12R2_FB9_Msk                               /*!<Filter bit 9 */
#define CAN_F12R2_FB10_Pos     (10U)                                           
#define CAN_F12R2_FB10_Msk     (0x1U << CAN_F12R2_FB10_Pos)                    /*!< 0x00000400 */
#define CAN_F12R2_FB10         CAN_F12R2_FB10_Msk                              /*!<Filter bit 10 */
#define CAN_F12R2_FB11_Pos     (11U)                                           
#define CAN_F12R2_FB11_Msk     (0x1U << CAN_F12R2_FB11_Pos)                    /*!< 0x00000800 */
#define CAN_F12R2_FB11         CAN_F12R2_FB11_Msk                              /*!<Filter bit 11 */
#define CAN_F12R2_FB12_Pos     (12U)                                           
#define CAN_F12R2_FB12_Msk     (0x1U << CAN_F12R2_FB12_Pos)                    /*!< 0x00001000 */
#define CAN_F12R2_FB12         CAN_F12R2_FB12_Msk                              /*!<Filter bit 12 */
#define CAN_F12R2_FB13_Pos     (13U)                                           
#define CAN_F12R2_FB13_Msk     (0x1U << CAN_F12R2_FB13_Pos)                    /*!< 0x00002000 */
#define CAN_F12R2_FB13         CAN_F12R2_FB13_Msk                              /*!<Filter bit 13 */
#define CAN_F12R2_FB14_Pos     (14U)                                           
#define CAN_F12R2_FB14_Msk     (0x1U << CAN_F12R2_FB14_Pos)                    /*!< 0x00004000 */
#define CAN_F12R2_FB14         CAN_F12R2_FB14_Msk                              /*!<Filter bit 14 */
#define CAN_F12R2_FB15_Pos     (15U)                                           
#define CAN_F12R2_FB15_Msk     (0x1U << CAN_F12R2_FB15_Pos)                    /*!< 0x00008000 */
#define CAN_F12R2_FB15         CAN_F12R2_FB15_Msk                              /*!<Filter bit 15 */
#define CAN_F12R2_FB16_Pos     (16U)                                           
#define CAN_F12R2_FB16_Msk     (0x1U << CAN_F12R2_FB16_Pos)                    /*!< 0x00010000 */
#define CAN_F12R2_FB16         CAN_F12R2_FB16_Msk                              /*!<Filter bit 16 */
#define CAN_F12R2_FB17_Pos     (17U)                                           
#define CAN_F12R2_FB17_Msk     (0x1U << CAN_F12R2_FB17_Pos)                    /*!< 0x00020000 */
#define CAN_F12R2_FB17         CAN_F12R2_FB17_Msk                              /*!<Filter bit 17 */
#define CAN_F12R2_FB18_Pos     (18U)                                           
#define CAN_F12R2_FB18_Msk     (0x1U << CAN_F12R2_FB18_Pos)                    /*!< 0x00040000 */
#define CAN_F12R2_FB18         CAN_F12R2_FB18_Msk                              /*!<Filter bit 18 */
#define CAN_F12R2_FB19_Pos     (19U)                                           
#define CAN_F12R2_FB19_Msk     (0x1U << CAN_F12R2_FB19_Pos)                    /*!< 0x00080000 */
#define CAN_F12R2_FB19         CAN_F12R2_FB19_Msk                              /*!<Filter bit 19 */
#define CAN_F12R2_FB20_Pos     (20U)                                           
#define CAN_F12R2_FB20_Msk     (0x1U << CAN_F12R2_FB20_Pos)                    /*!< 0x00100000 */
#define CAN_F12R2_FB20         CAN_F12R2_FB20_Msk                              /*!<Filter bit 20 */
#define CAN_F12R2_FB21_Pos     (21U)                                           
#define CAN_F12R2_FB21_Msk     (0x1U << CAN_F12R2_FB21_Pos)                    /*!< 0x00200000 */
#define CAN_F12R2_FB21         CAN_F12R2_FB21_Msk                              /*!<Filter bit 21 */
#define CAN_F12R2_FB22_Pos     (22U)                                           
#define CAN_F12R2_FB22_Msk     (0x1U << CAN_F12R2_FB22_Pos)                    /*!< 0x00400000 */
#define CAN_F12R2_FB22         CAN_F12R2_FB22_Msk                              /*!<Filter bit 22 */
#define CAN_F12R2_FB23_Pos     (23U)                                           
#define CAN_F12R2_FB23_Msk     (0x1U << CAN_F12R2_FB23_Pos)                    /*!< 0x00800000 */
#define CAN_F12R2_FB23         CAN_F12R2_FB23_Msk                              /*!<Filter bit 23 */
#define CAN_F12R2_FB24_Pos     (24U)                                           
#define CAN_F12R2_FB24_Msk     (0x1U << CAN_F12R2_FB24_Pos)                    /*!< 0x01000000 */
#define CAN_F12R2_FB24         CAN_F12R2_FB24_Msk                              /*!<Filter bit 24 */
#define CAN_F12R2_FB25_Pos     (25U)                                           
#define CAN_F12R2_FB25_Msk     (0x1U << CAN_F12R2_FB25_Pos)                    /*!< 0x02000000 */
#define CAN_F12R2_FB25         CAN_F12R2_FB25_Msk                              /*!<Filter bit 25 */
#define CAN_F12R2_FB26_Pos     (26U)                                           
#define CAN_F12R2_FB26_Msk     (0x1U << CAN_F12R2_FB26_Pos)                    /*!< 0x04000000 */
#define CAN_F12R2_FB26         CAN_F12R2_FB26_Msk                              /*!<Filter bit 26 */
#define CAN_F12R2_FB27_Pos     (27U)                                           
#define CAN_F12R2_FB27_Msk     (0x1U << CAN_F12R2_FB27_Pos)                    /*!< 0x08000000 */
#define CAN_F12R2_FB27         CAN_F12R2_FB27_Msk                              /*!<Filter bit 27 */
#define CAN_F12R2_FB28_Pos     (28U)                                           
#define CAN_F12R2_FB28_Msk     (0x1U << CAN_F12R2_FB28_Pos)                    /*!< 0x10000000 */
#define CAN_F12R2_FB28         CAN_F12R2_FB28_Msk                              /*!<Filter bit 28 */
#define CAN_F12R2_FB29_Pos     (29U)                                           
#define CAN_F12R2_FB29_Msk     (0x1U << CAN_F12R2_FB29_Pos)                    /*!< 0x20000000 */
#define CAN_F12R2_FB29         CAN_F12R2_FB29_Msk                              /*!<Filter bit 29 */
#define CAN_F12R2_FB30_Pos     (30U)                                           
#define CAN_F12R2_FB30_Msk     (0x1U << CAN_F12R2_FB30_Pos)                    /*!< 0x40000000 */
#define CAN_F12R2_FB30         CAN_F12R2_FB30_Msk                              /*!<Filter bit 30 */
#define CAN_F12R2_FB31_Pos     (31U)                                           
#define CAN_F12R2_FB31_Msk     (0x1U << CAN_F12R2_FB31_Pos)                    /*!< 0x80000000 */
#define CAN_F12R2_FB31         CAN_F12R2_FB31_Msk                              /*!<Filter bit 31 */

/*******************  Bit definition for CAN_F13R2 register  ******************/
#define CAN_F13R2_FB0_Pos      (0U)                                            
#define CAN_F13R2_FB0_Msk      (0x1U << CAN_F13R2_FB0_Pos)                     /*!< 0x00000001 */
#define CAN_F13R2_FB0          CAN_F13R2_FB0_Msk                               /*!<Filter bit 0 */
#define CAN_F13R2_FB1_Pos      (1U)                                            
#define CAN_F13R2_FB1_Msk      (0x1U << CAN_F13R2_FB1_Pos)                     /*!< 0x00000002 */
#define CAN_F13R2_FB1          CAN_F13R2_FB1_Msk                               /*!<Filter bit 1 */
#define CAN_F13R2_FB2_Pos      (2U)                                            
#define CAN_F13R2_FB2_Msk      (0x1U << CAN_F13R2_FB2_Pos)                     /*!< 0x00000004 */
#define CAN_F13R2_FB2          CAN_F13R2_FB2_Msk                               /*!<Filter bit 2 */
#define CAN_F13R2_FB3_Pos      (3U)                                            
#define CAN_F13R2_FB3_Msk      (0x1U << CAN_F13R2_FB3_Pos)                     /*!< 0x00000008 */
#define CAN_F13R2_FB3          CAN_F13R2_FB3_Msk                               /*!<Filter bit 3 */
#define CAN_F13R2_FB4_Pos      (4U)                                            
#define CAN_F13R2_FB4_Msk      (0x1U << CAN_F13R2_FB4_Pos)                     /*!< 0x00000010 */
#define CAN_F13R2_FB4          CAN_F13R2_FB4_Msk                               /*!<Filter bit 4 */
#define CAN_F13R2_FB5_Pos      (5U)                                            
#define CAN_F13R2_FB5_Msk      (0x1U << CAN_F13R2_FB5_Pos)                     /*!< 0x00000020 */
#define CAN_F13R2_FB5          CAN_F13R2_FB5_Msk                               /*!<Filter bit 5 */
#define CAN_F13R2_FB6_Pos      (6U)                                            
#define CAN_F13R2_FB6_Msk      (0x1U << CAN_F13R2_FB6_Pos)                     /*!< 0x00000040 */
#define CAN_F13R2_FB6          CAN_F13R2_FB6_Msk                               /*!<Filter bit 6 */
#define CAN_F13R2_FB7_Pos      (7U)                                            
#define CAN_F13R2_FB7_Msk      (0x1U << CAN_F13R2_FB7_Pos)                     /*!< 0x00000080 */
#define CAN_F13R2_FB7          CAN_F13R2_FB7_Msk                               /*!<Filter bit 7 */
#define CAN_F13R2_FB8_Pos      (8U)                                            
#define CAN_F13R2_FB8_Msk      (0x1U << CAN_F13R2_FB8_Pos)                     /*!< 0x00000100 */
#define CAN_F13R2_FB8          CAN_F13R2_FB8_Msk                               /*!<Filter bit 8 */
#define CAN_F13R2_FB9_Pos      (9U)                                            
#define CAN_F13R2_FB9_Msk      (0x1U << CAN_F13R2_FB9_Pos)                     /*!< 0x00000200 */
#define CAN_F13R2_FB9          CAN_F13R2_FB9_Msk                               /*!<Filter bit 9 */
#define CAN_F13R2_FB10_Pos     (10U)                                           
#define CAN_F13R2_FB10_Msk     (0x1U << CAN_F13R2_FB10_Pos)                    /*!< 0x00000400 */
#define CAN_F13R2_FB10         CAN_F13R2_FB10_Msk                              /*!<Filter bit 10 */
#define CAN_F13R2_FB11_Pos     (11U)                                           
#define CAN_F13R2_FB11_Msk     (0x1U << CAN_F13R2_FB11_Pos)                    /*!< 0x00000800 */
#define CAN_F13R2_FB11         CAN_F13R2_FB11_Msk                              /*!<Filter bit 11 */
#define CAN_F13R2_FB12_Pos     (12U)                                           
#define CAN_F13R2_FB12_Msk     (0x1U << CAN_F13R2_FB12_Pos)                    /*!< 0x00001000 */
#define CAN_F13R2_FB12         CAN_F13R2_FB12_Msk                              /*!<Filter bit 12 */
#define CAN_F13R2_FB13_Pos     (13U)                                           
#define CAN_F13R2_FB13_Msk     (0x1U << CAN_F13R2_FB13_Pos)                    /*!< 0x00002000 */
#define CAN_F13R2_FB13         CAN_F13R2_FB13_Msk                              /*!<Filter bit 13 */
#define CAN_F13R2_FB14_Pos     (14U)                                           
#define CAN_F13R2_FB14_Msk     (0x1U << CAN_F13R2_FB14_Pos)                    /*!< 0x00004000 */
#define CAN_F13R2_FB14         CAN_F13R2_FB14_Msk                              /*!<Filter bit 14 */
#define CAN_F13R2_FB15_Pos     (15U)                                           
#define CAN_F13R2_FB15_Msk     (0x1U << CAN_F13R2_FB15_Pos)                    /*!< 0x00008000 */
#define CAN_F13R2_FB15         CAN_F13R2_FB15_Msk                              /*!<Filter bit 15 */
#define CAN_F13R2_FB16_Pos     (16U)                                           
#define CAN_F13R2_FB16_Msk     (0x1U << CAN_F13R2_FB16_Pos)                    /*!< 0x00010000 */
#define CAN_F13R2_FB16         CAN_F13R2_FB16_Msk                              /*!<Filter bit 16 */
#define CAN_F13R2_FB17_Pos     (17U)                                           
#define CAN_F13R2_FB17_Msk     (0x1U << CAN_F13R2_FB17_Pos)                    /*!< 0x00020000 */
#define CAN_F13R2_FB17         CAN_F13R2_FB17_Msk                              /*!<Filter bit 17 */
#define CAN_F13R2_FB18_Pos     (18U)                                           
#define CAN_F13R2_FB18_Msk     (0x1U << CAN_F13R2_FB18_Pos)                    /*!< 0x00040000 */
#define CAN_F13R2_FB18         CAN_F13R2_FB18_Msk                              /*!<Filter bit 18 */
#define CAN_F13R2_FB19_Pos     (19U)                                           
#define CAN_F13R2_FB19_Msk     (0x1U << CAN_F13R2_FB19_Pos)                    /*!< 0x00080000 */
#define CAN_F13R2_FB19         CAN_F13R2_FB19_Msk                              /*!<Filter bit 19 */
#define CAN_F13R2_FB20_Pos     (20U)                                           
#define CAN_F13R2_FB20_Msk     (0x1U << CAN_F13R2_FB20_Pos)                    /*!< 0x00100000 */
#define CAN_F13R2_FB20         CAN_F13R2_FB20_Msk                              /*!<Filter bit 20 */
#define CAN_F13R2_FB21_Pos     (21U)                                           
#define CAN_F13R2_FB21_Msk     (0x1U << CAN_F13R2_FB21_Pos)                    /*!< 0x00200000 */
#define CAN_F13R2_FB21         CAN_F13R2_FB21_Msk                              /*!<Filter bit 21 */
#define CAN_F13R2_FB22_Pos     (22U)                                           
#define CAN_F13R2_FB22_Msk     (0x1U << CAN_F13R2_FB22_Pos)                    /*!< 0x00400000 */
#define CAN_F13R2_FB22         CAN_F13R2_FB22_Msk                              /*!<Filter bit 22 */
#define CAN_F13R2_FB23_Pos     (23U)                                           
#define CAN_F13R2_FB23_Msk     (0x1U << CAN_F13R2_FB23_Pos)                    /*!< 0x00800000 */
#define CAN_F13R2_FB23         CAN_F13R2_FB23_Msk                              /*!<Filter bit 23 */
#define CAN_F13R2_FB24_Pos     (24U)                                           
#define CAN_F13R2_FB24_Msk     (0x1U << CAN_F13R2_FB24_Pos)                    /*!< 0x01000000 */
#define CAN_F13R2_FB24         CAN_F13R2_FB24_Msk                              /*!<Filter bit 24 */
#define CAN_F13R2_FB25_Pos     (25U)                                           
#define CAN_F13R2_FB25_Msk     (0x1U << CAN_F13R2_FB25_Pos)                    /*!< 0x02000000 */
#define CAN_F13R2_FB25         CAN_F13R2_FB25_Msk                              /*!<Filter bit 25 */
#define CAN_F13R2_FB26_Pos     (26U)                                           
#define CAN_F13R2_FB26_Msk     (0x1U << CAN_F13R2_FB26_Pos)                    /*!< 0x04000000 */
#define CAN_F13R2_FB26         CAN_F13R2_FB26_Msk                              /*!<Filter bit 26 */
#define CAN_F13R2_FB27_Pos     (27U)                                           
#define CAN_F13R2_FB27_Msk     (0x1U << CAN_F13R2_FB27_Pos)                    /*!< 0x08000000 */
#define CAN_F13R2_FB27         CAN_F13R2_FB27_Msk                              /*!<Filter bit 27 */
#define CAN_F13R2_FB28_Pos     (28U)                                           
#define CAN_F13R2_FB28_Msk     (0x1U << CAN_F13R2_FB28_Pos)                    /*!< 0x10000000 */
#define CAN_F13R2_FB28         CAN_F13R2_FB28_Msk                              /*!<Filter bit 28 */
#define CAN_F13R2_FB29_Pos     (29U)                                           
#define CAN_F13R2_FB29_Msk     (0x1U << CAN_F13R2_FB29_Pos)                    /*!< 0x20000000 */
#define CAN_F13R2_FB29         CAN_F13R2_FB29_Msk                              /*!<Filter bit 29 */
#define CAN_F13R2_FB30_Pos     (30U)                                           
#define CAN_F13R2_FB30_Msk     (0x1U << CAN_F13R2_FB30_Pos)                    /*!< 0x40000000 */
#define CAN_F13R2_FB30         CAN_F13R2_FB30_Msk                              /*!<Filter bit 30 */
#define CAN_F13R2_FB31_Pos     (31U)                                           
#define CAN_F13R2_FB31_Msk     (0x1U << CAN_F13R2_FB31_Pos)                    /*!< 0x80000000 */
#define CAN_F13R2_FB31         CAN_F13R2_FB31_Msk                              /*!<Filter bit 31 */

/******************************************************************************/
/*                                                                            */
/*                     CRC calculation unit (CRC)                             */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for CRC_DR register  *********************/
#define CRC_DR_DR_Pos            (0U)                                          
#define CRC_DR_DR_Msk            (0xFFFFFFFFU << CRC_DR_DR_Pos)                /*!< 0xFFFFFFFF */
#define CRC_DR_DR                CRC_DR_DR_Msk                                 /*!< Data register bits */

/*******************  Bit definition for CRC_IDR register  ********************/
#define CRC_IDR_IDR              ((uint8_t)0xFFU)                              /*!< General-purpose 8-bit data register bits */

/********************  Bit definition for CRC_CR register  ********************/
#define CRC_CR_RESET_Pos         (0U)                                          
#define CRC_CR_RESET_Msk         (0x1U << CRC_CR_RESET_Pos)                    /*!< 0x00000001 */
#define CRC_CR_RESET             CRC_CR_RESET_Msk                              /*!< RESET the CRC computation unit bit */
#define CRC_CR_POLYSIZE_Pos      (3U)                                          
#define CRC_CR_POLYSIZE_Msk      (0x3U << CRC_CR_POLYSIZE_Pos)                 /*!< 0x00000018 */
#define CRC_CR_POLYSIZE          CRC_CR_POLYSIZE_Msk                           /*!< Polynomial size bits */
#define CRC_CR_POLYSIZE_0        (0x1U << CRC_CR_POLYSIZE_Pos)                 /*!< 0x00000008 */
#define CRC_CR_POLYSIZE_1        (0x2U << CRC_CR_POLYSIZE_Pos)                 /*!< 0x00000010 */
#define CRC_CR_REV_IN_Pos        (5U)                                          
#define CRC_CR_REV_IN_Msk        (0x3U << CRC_CR_REV_IN_Pos)                   /*!< 0x00000060 */
#define CRC_CR_REV_IN            CRC_CR_REV_IN_Msk                             /*!< REV_IN Reverse Input Data bits */
#define CRC_CR_REV_IN_0          (0x1U << CRC_CR_REV_IN_Pos)                   /*!< 0x00000020 */
#define CRC_CR_REV_IN_1          (0x2U << CRC_CR_REV_IN_Pos)                   /*!< 0x00000040 */
#define CRC_CR_REV_OUT_Pos       (7U)                                          
#define CRC_CR_REV_OUT_Msk       (0x1U << CRC_CR_REV_OUT_Pos)                  /*!< 0x00000080 */
#define CRC_CR_REV_OUT           CRC_CR_REV_OUT_Msk                            /*!< REV_OUT Reverse Output Data bits */

/*******************  Bit definition for CRC_INIT register  *******************/
#define CRC_INIT_INIT_Pos        (0U)                                          
#define CRC_INIT_INIT_Msk        (0xFFFFFFFFU << CRC_INIT_INIT_Pos)            /*!< 0xFFFFFFFF */
#define CRC_INIT_INIT            CRC_INIT_INIT_Msk                             /*!< Initial CRC value bits */

/*******************  Bit definition for CRC_POL register  ********************/
#define CRC_POL_POL_Pos          (0U)                                          
#define CRC_POL_POL_Msk          (0xFFFFFFFFU << CRC_POL_POL_Pos)              /*!< 0xFFFFFFFF */
#define CRC_POL_POL              CRC_POL_POL_Msk                               /*!< Coefficients of the polynomial */

/******************************************************************************/
/*                                                                            */
/*                 Digital to Analog Converter (DAC)                          */
/*                                                                            */
/******************************************************************************/

/*
 * @brief Specific device feature definitions (not present on all devices in the STM32F3 serie)
 */
#define DAC_CHANNEL2_SUPPORT                           /*!< DAC feature available only on specific devices: DAC channel 2 available (may not be available on all DAC instances DACx) */


/********************  Bit definition for DAC_CR register  ********************/
#define DAC_CR_EN1_Pos              (0U)                                       
#define DAC_CR_EN1_Msk              (0x1U << DAC_CR_EN1_Pos)                   /*!< 0x00000001 */
#define DAC_CR_EN1                  DAC_CR_EN1_Msk                             /*!< DAC channel1 enable */
#define DAC_CR_BOFF1_Pos            (1U)                                       
#define DAC_CR_BOFF1_Msk            (0x1U << DAC_CR_BOFF1_Pos)                 /*!< 0x00000002 */
#define DAC_CR_BOFF1                DAC_CR_BOFF1_Msk                           /*!< DAC channel1 output buffer disable */
#define DAC_CR_OUTEN1_Pos           (1U)                                       
#define DAC_CR_OUTEN1_Msk           (0x1U << DAC_CR_OUTEN1_Pos)                /*!< 0x00000002 */
#define DAC_CR_OUTEN1               DAC_CR_OUTEN1_Msk                          /*!< DAC channel1 output switch enable (only for DAC instance: DAC2) */
#define DAC_CR_TEN1_Pos             (2U)                                       
#define DAC_CR_TEN1_Msk             (0x1U << DAC_CR_TEN1_Pos)                  /*!< 0x00000004 */
#define DAC_CR_TEN1                 DAC_CR_TEN1_Msk                            /*!< DAC channel1 Trigger enable */

#define DAC_CR_TSEL1_Pos            (3U)                                       
#define DAC_CR_TSEL1_Msk            (0x7U << DAC_CR_TSEL1_Pos)                 /*!< 0x00000038 */
#define DAC_CR_TSEL1                DAC_CR_TSEL1_Msk                           /*!< TSEL1[2:0] (DAC channel1 Trigger selection) */
#define DAC_CR_TSEL1_0              (0x1U << DAC_CR_TSEL1_Pos)                 /*!< 0x00000008 */
#define DAC_CR_TSEL1_1              (0x2U << DAC_CR_TSEL1_Pos)                 /*!< 0x00000010 */
#define DAC_CR_TSEL1_2              (0x4U << DAC_CR_TSEL1_Pos)                 /*!< 0x00000020 */

#define DAC_CR_WAVE1_Pos            (6U)                                       
#define DAC_CR_WAVE1_Msk            (0x3U << DAC_CR_WAVE1_Pos)                 /*!< 0x000000C0 */
#define DAC_CR_WAVE1                DAC_CR_WAVE1_Msk                           /*!< WAVE1[1:0] (DAC channel1 noise/triangle wave generation enable) */
#define DAC_CR_WAVE1_0              (0x1U << DAC_CR_WAVE1_Pos)                 /*!< 0x00000040 */
#define DAC_CR_WAVE1_1              (0x2U << DAC_CR_WAVE1_Pos)                 /*!< 0x00000080 */

#define DAC_CR_MAMP1_Pos            (8U)                                       
#define DAC_CR_MAMP1_Msk            (0xFU << DAC_CR_MAMP1_Pos)                 /*!< 0x00000F00 */
#define DAC_CR_MAMP1                DAC_CR_MAMP1_Msk                           /*!< MAMP1[3:0] (DAC channel1 Mask/Amplitude selector) */
#define DAC_CR_MAMP1_0              (0x1U << DAC_CR_MAMP1_Pos)                 /*!< 0x00000100 */
#define DAC_CR_MAMP1_1              (0x2U << DAC_CR_MAMP1_Pos)                 /*!< 0x00000200 */
#define DAC_CR_MAMP1_2              (0x4U << DAC_CR_MAMP1_Pos)                 /*!< 0x00000400 */
#define DAC_CR_MAMP1_3              (0x8U << DAC_CR_MAMP1_Pos)                 /*!< 0x00000800 */

#define DAC_CR_DMAEN1_Pos           (12U)                                      
#define DAC_CR_DMAEN1_Msk           (0x1U << DAC_CR_DMAEN1_Pos)                /*!< 0x00001000 */
#define DAC_CR_DMAEN1               DAC_CR_DMAEN1_Msk                          /*!< DAC channel1 DMA enable */
#define DAC_CR_DMAUDRIE1_Pos        (13U)                                      
#define DAC_CR_DMAUDRIE1_Msk        (0x1U << DAC_CR_DMAUDRIE1_Pos)             /*!< 0x00002000 */
#define DAC_CR_DMAUDRIE1            DAC_CR_DMAUDRIE1_Msk                       /*!< DAC channel1 DMA underrun IT enable */ 
#define DAC_CR_EN2_Pos              (16U)                                      
#define DAC_CR_EN2_Msk              (0x1U << DAC_CR_EN2_Pos)                   /*!< 0x00010000 */
#define DAC_CR_EN2                  DAC_CR_EN2_Msk                             /*!< DAC channel2 enable */
#define DAC_CR_BOFF2_Pos            (17U)                                      
#define DAC_CR_BOFF2_Msk            (0x1U << DAC_CR_BOFF2_Pos)                 /*!< 0x00020000 */
#define DAC_CR_BOFF2                DAC_CR_BOFF2_Msk                           /*!< DAC channel2 output buffer disable */
#define DAC_CR_OUTEN2_Pos           (17U)                                      
#define DAC_CR_OUTEN2_Msk           (0x1U << DAC_CR_OUTEN2_Pos)                /*!< 0x00020000 */
#define DAC_CR_OUTEN2               DAC_CR_OUTEN2_Msk                          /*!< DAC channel2 output switch enable (only for DAC instance: DAC2) */
#define DAC_CR_TEN2_Pos             (18U)                                      
#define DAC_CR_TEN2_Msk             (0x1U << DAC_CR_TEN2_Pos)                  /*!< 0x00040000 */
#define DAC_CR_TEN2                 DAC_CR_TEN2_Msk                            /*!< DAC channel2 Trigger enable */

#define DAC_CR_TSEL2_Pos            (19U)                                      
#define DAC_CR_TSEL2_Msk            (0x7U << DAC_CR_TSEL2_Pos)                 /*!< 0x00380000 */
#define DAC_CR_TSEL2                DAC_CR_TSEL2_Msk                           /*!< TSEL2[2:0] (DAC channel2 Trigger selection) */
#define DAC_CR_TSEL2_0              (0x1U << DAC_CR_TSEL2_Pos)                 /*!< 0x00080000 */
#define DAC_CR_TSEL2_1              (0x2U << DAC_CR_TSEL2_Pos)                 /*!< 0x00100000 */
#define DAC_CR_TSEL2_2              (0x4U << DAC_CR_TSEL2_Pos)                 /*!< 0x00200000 */

#define DAC_CR_WAVE2_Pos            (22U)                                      
#define DAC_CR_WAVE2_Msk            (0x3U << DAC_CR_WAVE2_Pos)                 /*!< 0x00C00000 */
#define DAC_CR_WAVE2                DAC_CR_WAVE2_Msk                           /*!< WAVE2[1:0] (DAC channel2 noise/triangle wave generation enable) */
#define DAC_CR_WAVE2_0              (0x1U << DAC_CR_WAVE2_Pos)                 /*!< 0x00400000 */
#define DAC_CR_WAVE2_1              (0x2U << DAC_CR_WAVE2_Pos)                 /*!< 0x00800000 */

#define DAC_CR_MAMP2_Pos            (24U)                                      
#define DAC_CR_MAMP2_Msk            (0xFU << DAC_CR_MAMP2_Pos)                 /*!< 0x0F000000 */
#define DAC_CR_MAMP2                DAC_CR_MAMP2_Msk                           /*!< MAMP2[3:0] (DAC channel2 Mask/Amplitude selector) */
#define DAC_CR_MAMP2_0              (0x1U << DAC_CR_MAMP2_Pos)                 /*!< 0x01000000 */
#define DAC_CR_MAMP2_1              (0x2U << DAC_CR_MAMP2_Pos)                 /*!< 0x02000000 */
#define DAC_CR_MAMP2_2              (0x4U << DAC_CR_MAMP2_Pos)                 /*!< 0x04000000 */
#define DAC_CR_MAMP2_3              (0x8U << DAC_CR_MAMP2_Pos)                 /*!< 0x08000000 */

#define DAC_CR_DMAEN2_Pos           (28U)                                      
#define DAC_CR_DMAEN2_Msk           (0x1U << DAC_CR_DMAEN2_Pos)                /*!< 0x10000000 */
#define DAC_CR_DMAEN2               DAC_CR_DMAEN2_Msk                          /*!< DAC channel2 DMA enabled */
#define DAC_CR_DMAUDRIE2_Pos        (29U)                                      
#define DAC_CR_DMAUDRIE2_Msk        (0x1U << DAC_CR_DMAUDRIE2_Pos)             /*!< 0x20000000 */
#define DAC_CR_DMAUDRIE2            DAC_CR_DMAUDRIE2_Msk                       /*!< DAC channel2 DMA underrun IT enable */ 

/*****************  Bit definition for DAC_SWTRIGR register  ******************/
#define DAC_SWTRIGR_SWTRIG1_Pos     (0U)                                       
#define DAC_SWTRIGR_SWTRIG1_Msk     (0x1U << DAC_SWTRIGR_SWTRIG1_Pos)          /*!< 0x00000001 */
#define DAC_SWTRIGR_SWTRIG1         DAC_SWTRIGR_SWTRIG1_Msk                    /*!< DAC channel1 software trigger */
#define DAC_SWTRIGR_SWTRIG2_Pos     (1U)                                       
#define DAC_SWTRIGR_SWTRIG2_Msk     (0x1U << DAC_SWTRIGR_SWTRIG2_Pos)          /*!< 0x00000002 */
#define DAC_SWTRIGR_SWTRIG2         DAC_SWTRIGR_SWTRIG2_Msk                    /*!< DAC channel2 software trigger */

/*****************  Bit definition for DAC_DHR12R1 register  ******************/
#define DAC_DHR12R1_DACC1DHR_Pos    (0U)                                       
#define DAC_DHR12R1_DACC1DHR_Msk    (0xFFFU << DAC_DHR12R1_DACC1DHR_Pos)       /*!< 0x00000FFF */
#define DAC_DHR12R1_DACC1DHR        DAC_DHR12R1_DACC1DHR_Msk                   /*!< DAC channel1 12-bit Right aligned data */

/*****************  Bit definition for DAC_DHR12L1 register  ******************/
#define DAC_DHR12L1_DACC1DHR_Pos    (4U)                                       
#define DAC_DHR12L1_DACC1DHR_Msk    (0xFFFU << DAC_DHR12L1_DACC1DHR_Pos)       /*!< 0x0000FFF0 */
#define DAC_DHR12L1_DACC1DHR        DAC_DHR12L1_DACC1DHR_Msk                   /*!< DAC channel1 12-bit Left aligned data */

/******************  Bit definition for DAC_DHR8R1 register  ******************/
#define DAC_DHR8R1_DACC1DHR_Pos     (0U)                                       
#define DAC_DHR8R1_DACC1DHR_Msk     (0xFFU << DAC_DHR8R1_DACC1DHR_Pos)         /*!< 0x000000FF */
#define DAC_DHR8R1_DACC1DHR         DAC_DHR8R1_DACC1DHR_Msk                    /*!< DAC channel1 8-bit Right aligned data */

/*****************  Bit definition for DAC_DHR12R2 register  ******************/
#define DAC_DHR12R2_DACC2DHR_Pos    (0U)                                       
#define DAC_DHR12R2_DACC2DHR_Msk    (0xFFFU << DAC_DHR12R2_DACC2DHR_Pos)       /*!< 0x00000FFF */
#define DAC_DHR12R2_DACC2DHR        DAC_DHR12R2_DACC2DHR_Msk                   /*!< DAC channel2 12-bit Right aligned data */

/*****************  Bit definition for DAC_DHR12L2 register  ******************/
#define DAC_DHR12L2_DACC2DHR_Pos    (4U)                                       
#define DAC_DHR12L2_DACC2DHR_Msk    (0xFFFU << DAC_DHR12L2_DACC2DHR_Pos)       /*!< 0x0000FFF0 */
#define DAC_DHR12L2_DACC2DHR        DAC_DHR12L2_DACC2DHR_Msk                   /*!< DAC channel2 12-bit Left aligned data */

/******************  Bit definition for DAC_DHR8R2 register  ******************/
#define DAC_DHR8R2_DACC2DHR_Pos     (0U)                                       
#define DAC_DHR8R2_DACC2DHR_Msk     (0xFFU << DAC_DHR8R2_DACC2DHR_Pos)         /*!< 0x000000FF */
#define DAC_DHR8R2_DACC2DHR         DAC_DHR8R2_DACC2DHR_Msk                    /*!< DAC channel2 8-bit Right aligned data */

/*****************  Bit definition for DAC_DHR12RD register  ******************/
#define DAC_DHR12RD_DACC1DHR_Pos    (0U)                                       
#define DAC_DHR12RD_DACC1DHR_Msk    (0xFFFU << DAC_DHR12RD_DACC1DHR_Pos)       /*!< 0x00000FFF */
#define DAC_DHR12RD_DACC1DHR        DAC_DHR12RD_DACC1DHR_Msk                   /*!< DAC channel1 12-bit Right aligned data */
#define DAC_DHR12RD_DACC2DHR_Pos    (16U)                                      
#define DAC_DHR12RD_DACC2DHR_Msk    (0xFFFU << DAC_DHR12RD_DACC2DHR_Pos)       /*!< 0x0FFF0000 */
#define DAC_DHR12RD_DACC2DHR        DAC_DHR12RD_DACC2DHR_Msk                   /*!< DAC channel2 12-bit Right aligned data */

/*****************  Bit definition for DAC_DHR12LD register  ******************/
#define DAC_DHR12LD_DACC1DHR_Pos    (4U)                                       
#define DAC_DHR12LD_DACC1DHR_Msk    (0xFFFU << DAC_DHR12LD_DACC1DHR_Pos)       /*!< 0x0000FFF0 */
#define DAC_DHR12LD_DACC1DHR        DAC_DHR12LD_DACC1DHR_Msk                   /*!< DAC channel1 12-bit Left aligned data */
#define DAC_DHR12LD_DACC2DHR_Pos    (20U)                                      
#define DAC_DHR12LD_DACC2DHR_Msk    (0xFFFU << DAC_DHR12LD_DACC2DHR_Pos)       /*!< 0xFFF00000 */
#define DAC_DHR12LD_DACC2DHR        DAC_DHR12LD_DACC2DHR_Msk                   /*!< DAC channel2 12-bit Left aligned data */

/******************  Bit definition for DAC_DHR8RD register  ******************/
#define DAC_DHR8RD_DACC1DHR_Pos     (0U)                                       
#define DAC_DHR8RD_DACC1DHR_Msk     (0xFFU << DAC_DHR8RD_DACC1DHR_Pos)         /*!< 0x000000FF */
#define DAC_DHR8RD_DACC1DHR         DAC_DHR8RD_DACC1DHR_Msk                    /*!< DAC channel1 8-bit Right aligned data */
#define DAC_DHR8RD_DACC2DHR_Pos     (8U)                                       
#define DAC_DHR8RD_DACC2DHR_Msk     (0xFFU << DAC_DHR8RD_DACC2DHR_Pos)         /*!< 0x0000FF00 */
#define DAC_DHR8RD_DACC2DHR         DAC_DHR8RD_DACC2DHR_Msk                    /*!< DAC channel2 8-bit Right aligned data */

/*******************  Bit definition for DAC_DOR1 register  *******************/
#define DAC_DOR1_DACC1DOR_Pos       (0U)                                       
#define DAC_DOR1_DACC1DOR_Msk       (0xFFFU << DAC_DOR1_DACC1DOR_Pos)          /*!< 0x00000FFF */
#define DAC_DOR1_DACC1DOR           DAC_DOR1_DACC1DOR_Msk                      /*!< DAC channel1 data output */

/*******************  Bit definition for DAC_DOR2 register  *******************/
#define DAC_DOR2_DACC2DOR_Pos       (0U)                                       
#define DAC_DOR2_DACC2DOR_Msk       (0xFFFU << DAC_DOR2_DACC2DOR_Pos)          /*!< 0x00000FFF */
#define DAC_DOR2_DACC2DOR           DAC_DOR2_DACC2DOR_Msk                      /*!< DAC channel2 data output */

/********************  Bit definition for DAC_SR register  ********************/
#define DAC_SR_DMAUDR1_Pos          (13U)                                      
#define DAC_SR_DMAUDR1_Msk          (0x1U << DAC_SR_DMAUDR1_Pos)               /*!< 0x00002000 */
#define DAC_SR_DMAUDR1              DAC_SR_DMAUDR1_Msk                         /*!< DAC channel1 DMA underrun flag */
#define DAC_SR_DMAUDR2_Pos          (29U)                                      
#define DAC_SR_DMAUDR2_Msk          (0x1U << DAC_SR_DMAUDR2_Pos)               /*!< 0x20000000 */
#define DAC_SR_DMAUDR2              DAC_SR_DMAUDR2_Msk                         /*!< DAC channel2 DMA underrun flag */

/******************************************************************************/
/*                                                                            */
/*                                 Debug MCU (DBGMCU)                         */
/*                                                                            */
/******************************************************************************/
/********************  Bit definition for DBGMCU_IDCODE register  *************/
#define DBGMCU_IDCODE_DEV_ID_Pos                     (0U)                      
#define DBGMCU_IDCODE_DEV_ID_Msk                     (0xFFFU << DBGMCU_IDCODE_DEV_ID_Pos) /*!< 0x00000FFF */
#define DBGMCU_IDCODE_DEV_ID                         DBGMCU_IDCODE_DEV_ID_Msk  
#define DBGMCU_IDCODE_REV_ID_Pos                     (16U)                     
#define DBGMCU_IDCODE_REV_ID_Msk                     (0xFFFFU << DBGMCU_IDCODE_REV_ID_Pos) /*!< 0xFFFF0000 */
#define DBGMCU_IDCODE_REV_ID                         DBGMCU_IDCODE_REV_ID_Msk  

/********************  Bit definition for DBGMCU_CR register  *****************/
#define DBGMCU_CR_DBG_SLEEP_Pos                      (0U)                      
#define DBGMCU_CR_DBG_SLEEP_Msk                      (0x1U << DBGMCU_CR_DBG_SLEEP_Pos) /*!< 0x00000001 */
#define DBGMCU_CR_DBG_SLEEP                          DBGMCU_CR_DBG_SLEEP_Msk   
#define DBGMCU_CR_DBG_STOP_Pos                       (1U)                      
#define DBGMCU_CR_DBG_STOP_Msk                       (0x1U << DBGMCU_CR_DBG_STOP_Pos) /*!< 0x00000002 */
#define DBGMCU_CR_DBG_STOP                           DBGMCU_CR_DBG_STOP_Msk    
#define DBGMCU_CR_DBG_STANDBY_Pos                    (2U)                      
#define DBGMCU_CR_DBG_STANDBY_Msk                    (0x1U << DBGMCU_CR_DBG_STANDBY_Pos) /*!< 0x00000004 */
#define DBGMCU_CR_DBG_STANDBY                        DBGMCU_CR_DBG_STANDBY_Msk 
#define DBGMCU_CR_TRACE_IOEN_Pos                     (5U)                      
#define DBGMCU_CR_TRACE_IOEN_Msk                     (0x1U << DBGMCU_CR_TRACE_IOEN_Pos) /*!< 0x00000020 */
#define DBGMCU_CR_TRACE_IOEN                         DBGMCU_CR_TRACE_IOEN_Msk  

#define DBGMCU_CR_TRACE_MODE_Pos                     (6U)                      
#define DBGMCU_CR_TRACE_MODE_Msk                     (0x3U << DBGMCU_CR_TRACE_MODE_Pos) /*!< 0x000000C0 */
#define DBGMCU_CR_TRACE_MODE                         DBGMCU_CR_TRACE_MODE_Msk  
#define DBGMCU_CR_TRACE_MODE_0                       (0x1U << DBGMCU_CR_TRACE_MODE_Pos) /*!< 0x00000040 */
#define DBGMCU_CR_TRACE_MODE_1                       (0x2U << DBGMCU_CR_TRACE_MODE_Pos) /*!< 0x00000080 */

/********************  Bit definition for DBGMCU_APB1_FZ register  ************/
#define DBGMCU_APB1_FZ_DBG_TIM2_STOP_Pos             (0U)                      
#define DBGMCU_APB1_FZ_DBG_TIM2_STOP_Msk             (0x1U << DBGMCU_APB1_FZ_DBG_TIM2_STOP_Pos) /*!< 0x00000001 */
#define DBGMCU_APB1_FZ_DBG_TIM2_STOP                 DBGMCU_APB1_FZ_DBG_TIM2_STOP_Msk 
#define DBGMCU_APB1_FZ_DBG_TIM3_STOP_Pos             (1U)                      
#define DBGMCU_APB1_FZ_DBG_TIM3_STOP_Msk             (0x1U << DBGMCU_APB1_FZ_DBG_TIM3_STOP_Pos) /*!< 0x00000002 */
#define DBGMCU_APB1_FZ_DBG_TIM3_STOP                 DBGMCU_APB1_FZ_DBG_TIM3_STOP_Msk 
#define DBGMCU_APB1_FZ_DBG_TIM6_STOP_Pos             (4U)                      
#define DBGMCU_APB1_FZ_DBG_TIM6_STOP_Msk             (0x1U << DBGMCU_APB1_FZ_DBG_TIM6_STOP_Pos) /*!< 0x00000010 */
#define DBGMCU_APB1_FZ_DBG_TIM6_STOP                 DBGMCU_APB1_FZ_DBG_TIM6_STOP_Msk 
#define DBGMCU_APB1_FZ_DBG_TIM7_STOP_Pos             (5U)                      
#define DBGMCU_APB1_FZ_DBG_TIM7_STOP_Msk             (0x1U << DBGMCU_APB1_FZ_DBG_TIM7_STOP_Pos) /*!< 0x00000020 */
#define DBGMCU_APB1_FZ_DBG_TIM7_STOP                 DBGMCU_APB1_FZ_DBG_TIM7_STOP_Msk 
#define DBGMCU_APB1_FZ_DBG_RTC_STOP_Pos              (10U)                     
#define DBGMCU_APB1_FZ_DBG_RTC_STOP_Msk              (0x1U << DBGMCU_APB1_FZ_DBG_RTC_STOP_Pos) /*!< 0x00000400 */
#define DBGMCU_APB1_FZ_DBG_RTC_STOP                  DBGMCU_APB1_FZ_DBG_RTC_STOP_Msk 
#define DBGMCU_APB1_FZ_DBG_WWDG_STOP_Pos             (11U)                     
#define DBGMCU_APB1_FZ_DBG_WWDG_STOP_Msk             (0x1U << DBGMCU_APB1_FZ_DBG_WWDG_STOP_Pos) /*!< 0x00000800 */
#define DBGMCU_APB1_FZ_DBG_WWDG_STOP                 DBGMCU_APB1_FZ_DBG_WWDG_STOP_Msk 
#define DBGMCU_APB1_FZ_DBG_IWDG_STOP_Pos             (12U)                     
#define DBGMCU_APB1_FZ_DBG_IWDG_STOP_Msk             (0x1U << DBGMCU_APB1_FZ_DBG_IWDG_STOP_Pos) /*!< 0x00001000 */
#define DBGMCU_APB1_FZ_DBG_IWDG_STOP                 DBGMCU_APB1_FZ_DBG_IWDG_STOP_Msk 
#define DBGMCU_APB1_FZ_DBG_I2C1_SMBUS_TIMEOUT_Pos    (21U)                     
#define DBGMCU_APB1_FZ_DBG_I2C1_SMBUS_TIMEOUT_Msk    (0x1U << DBGMCU_APB1_FZ_DBG_I2C1_SMBUS_TIMEOUT_Pos) /*!< 0x00200000 */
#define DBGMCU_APB1_FZ_DBG_I2C1_SMBUS_TIMEOUT        DBGMCU_APB1_FZ_DBG_I2C1_SMBUS_TIMEOUT_Msk 
#define DBGMCU_APB1_FZ_DBG_CAN_STOP_Pos              (25U)                     
#define DBGMCU_APB1_FZ_DBG_CAN_STOP_Msk              (0x1U << DBGMCU_APB1_FZ_DBG_CAN_STOP_Pos) /*!< 0x02000000 */
#define DBGMCU_APB1_FZ_DBG_CAN_STOP                  DBGMCU_APB1_FZ_DBG_CAN_STOP_Msk 

/********************  Bit definition for DBGMCU_APB2_FZ register  ************/
#define DBGMCU_APB2_FZ_DBG_TIM1_STOP_Pos             (0U)                      
#define DBGMCU_APB2_FZ_DBG_TIM1_STOP_Msk             (0x1U << DBGMCU_APB2_FZ_DBG_TIM1_STOP_Pos) /*!< 0x00000001 */
#define DBGMCU_APB2_FZ_DBG_TIM1_STOP                 DBGMCU_APB2_FZ_DBG_TIM1_STOP_Msk 
#define DBGMCU_APB2_FZ_DBG_TIM15_STOP_Pos            (2U)                      
#define DBGMCU_APB2_FZ_DBG_TIM15_STOP_Msk            (0x1U << DBGMCU_APB2_FZ_DBG_TIM15_STOP_Pos) /*!< 0x00000004 */
#define DBGMCU_APB2_FZ_DBG_TIM15_STOP                DBGMCU_APB2_FZ_DBG_TIM15_STOP_Msk 
#define DBGMCU_APB2_FZ_DBG_TIM16_STOP_Pos            (3U)                      
#define DBGMCU_APB2_FZ_DBG_TIM16_STOP_Msk            (0x1U << DBGMCU_APB2_FZ_DBG_TIM16_STOP_Pos) /*!< 0x00000008 */
#define DBGMCU_APB2_FZ_DBG_TIM16_STOP                DBGMCU_APB2_FZ_DBG_TIM16_STOP_Msk 
#define DBGMCU_APB2_FZ_DBG_TIM17_STOP_Pos            (4U)                      
#define DBGMCU_APB2_FZ_DBG_TIM17_STOP_Msk            (0x1U << DBGMCU_APB2_FZ_DBG_TIM17_STOP_Pos) /*!< 0x00000010 */
#define DBGMCU_APB2_FZ_DBG_TIM17_STOP                DBGMCU_APB2_FZ_DBG_TIM17_STOP_Msk 
#define DBGMCU_APB2_FZ_DBG_HRTIM1_STOP_Pos           (8U)                      
#define DBGMCU_APB2_FZ_DBG_HRTIM1_STOP_Msk           (0x1U << DBGMCU_APB2_FZ_DBG_HRTIM1_STOP_Pos) /*!< 0x00000100 */
#define DBGMCU_APB2_FZ_DBG_HRTIM1_STOP               DBGMCU_APB2_FZ_DBG_HRTIM1_STOP_Msk 

/******************************************************************************/
/*                                                                            */
/*                             DMA Controller (DMA)                           */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for DMA_ISR register  ********************/
#define DMA_ISR_GIF1_Pos       (0U)                                            
#define DMA_ISR_GIF1_Msk       (0x1U << DMA_ISR_GIF1_Pos)                      /*!< 0x00000001 */
#define DMA_ISR_GIF1           DMA_ISR_GIF1_Msk                                /*!< Channel 1 Global interrupt flag */
#define DMA_ISR_TCIF1_Pos      (1U)                                            
#define DMA_ISR_TCIF1_Msk      (0x1U << DMA_ISR_TCIF1_Pos)                     /*!< 0x00000002 */
#define DMA_ISR_TCIF1          DMA_ISR_TCIF1_Msk                               /*!< Channel 1 Transfer Complete flag */
#define DMA_ISR_HTIF1_Pos      (2U)                                            
#define DMA_ISR_HTIF1_Msk      (0x1U << DMA_ISR_HTIF1_Pos)                     /*!< 0x00000004 */
#define DMA_ISR_HTIF1          DMA_ISR_HTIF1_Msk                               /*!< Channel 1 Half Transfer flag */
#define DMA_ISR_TEIF1_Pos      (3U)                                            
#define DMA_ISR_TEIF1_Msk      (0x1U << DMA_ISR_TEIF1_Pos)                     /*!< 0x00000008 */
#define DMA_ISR_TEIF1          DMA_ISR_TEIF1_Msk                               /*!< Channel 1 Transfer Error flag */
#define DMA_ISR_GIF2_Pos       (4U)                                            
#define DMA_ISR_GIF2_Msk       (0x1U << DMA_ISR_GIF2_Pos)                      /*!< 0x00000010 */
#define DMA_ISR_GIF2           DMA_ISR_GIF2_Msk                                /*!< Channel 2 Global interrupt flag */
#define DMA_ISR_TCIF2_Pos      (5U)                                            
#define DMA_ISR_TCIF2_Msk      (0x1U << DMA_ISR_TCIF2_Pos)                     /*!< 0x00000020 */
#define DMA_ISR_TCIF2          DMA_ISR_TCIF2_Msk                               /*!< Channel 2 Transfer Complete flag */
#define DMA_ISR_HTIF2_Pos      (6U)                                            
#define DMA_ISR_HTIF2_Msk      (0x1U << DMA_ISR_HTIF2_Pos)                     /*!< 0x00000040 */
#define DMA_ISR_HTIF2          DMA_ISR_HTIF2_Msk                               /*!< Channel 2 Half Transfer flag */
#define DMA_ISR_TEIF2_Pos      (7U)                                            
#define DMA_ISR_TEIF2_Msk      (0x1U << DMA_ISR_TEIF2_Pos)                     /*!< 0x00000080 */
#define DMA_ISR_TEIF2          DMA_ISR_TEIF2_Msk                               /*!< Channel 2 Transfer Error flag */
#define DMA_ISR_GIF3_Pos       (8U)                                            
#define DMA_ISR_GIF3_Msk       (0x1U << DMA_ISR_GIF3_Pos)                      /*!< 0x00000100 */
#define DMA_ISR_GIF3           DMA_ISR_GIF3_Msk                                /*!< Channel 3 Global interrupt flag */
#define DMA_ISR_TCIF3_Pos      (9U)                                            
#define DMA_ISR_TCIF3_Msk      (0x1U << DMA_ISR_TCIF3_Pos)                     /*!< 0x00000200 */
#define DMA_ISR_TCIF3          DMA_ISR_TCIF3_Msk                               /*!< Channel 3 Transfer Complete flag */
#define DMA_ISR_HTIF3_Pos      (10U)                                           
#define DMA_ISR_HTIF3_Msk      (0x1U << DMA_ISR_HTIF3_Pos)                     /*!< 0x00000400 */
#define DMA_ISR_HTIF3          DMA_ISR_HTIF3_Msk                               /*!< Channel 3 Half Transfer flag */
#define DMA_ISR_TEIF3_Pos      (11U)                                           
#define DMA_ISR_TEIF3_Msk      (0x1U << DMA_ISR_TEIF3_Pos)                     /*!< 0x00000800 */
#define DMA_ISR_TEIF3          DMA_ISR_TEIF3_Msk                               /*!< Channel 3 Transfer Error flag */
#define DMA_ISR_GIF4_Pos       (12U)                                           
#define DMA_ISR_GIF4_Msk       (0x1U << DMA_ISR_GIF4_Pos)                      /*!< 0x00001000 */
#define DMA_ISR_GIF4           DMA_ISR_GIF4_Msk                                /*!< Channel 4 Global interrupt flag */
#define DMA_ISR_TCIF4_Pos      (13U)                                           
#define DMA_ISR_TCIF4_Msk      (0x1U << DMA_ISR_TCIF4_Pos)                     /*!< 0x00002000 */
#define DMA_ISR_TCIF4          DMA_ISR_TCIF4_Msk                               /*!< Channel 4 Transfer Complete flag */
#define DMA_ISR_HTIF4_Pos      (14U)                                           
#define DMA_ISR_HTIF4_Msk      (0x1U << DMA_ISR_HTIF4_Pos)                     /*!< 0x00004000 */
#define DMA_ISR_HTIF4          DMA_ISR_HTIF4_Msk                               /*!< Channel 4 Half Transfer flag */
#define DMA_ISR_TEIF4_Pos      (15U)                                           
#define DMA_ISR_TEIF4_Msk      (0x1U << DMA_ISR_TEIF4_Pos)                     /*!< 0x00008000 */
#define DMA_ISR_TEIF4          DMA_ISR_TEIF4_Msk                               /*!< Channel 4 Transfer Error flag */
#define DMA_ISR_GIF5_Pos       (16U)                                           
#define DMA_ISR_GIF5_Msk       (0x1U << DMA_ISR_GIF5_Pos)                      /*!< 0x00010000 */
#define DMA_ISR_GIF5           DMA_ISR_GIF5_Msk                                /*!< Channel 5 Global interrupt flag */
#define DMA_ISR_TCIF5_Pos      (17U)                                           
#define DMA_ISR_TCIF5_Msk      (0x1U << DMA_ISR_TCIF5_Pos)                     /*!< 0x00020000 */
#define DMA_ISR_TCIF5          DMA_ISR_TCIF5_Msk                               /*!< Channel 5 Transfer Complete flag */
#define DMA_ISR_HTIF5_Pos      (18U)                                           
#define DMA_ISR_HTIF5_Msk      (0x1U << DMA_ISR_HTIF5_Pos)                     /*!< 0x00040000 */
#define DMA_ISR_HTIF5          DMA_ISR_HTIF5_Msk                               /*!< Channel 5 Half Transfer flag */
#define DMA_ISR_TEIF5_Pos      (19U)                                           
#define DMA_ISR_TEIF5_Msk      (0x1U << DMA_ISR_TEIF5_Pos)                     /*!< 0x00080000 */
#define DMA_ISR_TEIF5          DMA_ISR_TEIF5_Msk                               /*!< Channel 5 Transfer Error flag */
#define DMA_ISR_GIF6_Pos       (20U)                                           
#define DMA_ISR_GIF6_Msk       (0x1U << DMA_ISR_GIF6_Pos)                      /*!< 0x00100000 */
#define DMA_ISR_GIF6           DMA_ISR_GIF6_Msk                                /*!< Channel 6 Global interrupt flag */
#define DMA_ISR_TCIF6_Pos      (21U)                                           
#define DMA_ISR_TCIF6_Msk      (0x1U << DMA_ISR_TCIF6_Pos)                     /*!< 0x00200000 */
#define DMA_ISR_TCIF6          DMA_ISR_TCIF6_Msk                               /*!< Channel 6 Transfer Complete flag */
#define DMA_ISR_HTIF6_Pos      (22U)                                           
#define DMA_ISR_HTIF6_Msk      (0x1U << DMA_ISR_HTIF6_Pos)                     /*!< 0x00400000 */
#define DMA_ISR_HTIF6          DMA_ISR_HTIF6_Msk                               /*!< Channel 6 Half Transfer flag */
#define DMA_ISR_TEIF6_Pos      (23U)                                           
#define DMA_ISR_TEIF6_Msk      (0x1U << DMA_ISR_TEIF6_Pos)                     /*!< 0x00800000 */
#define DMA_ISR_TEIF6          DMA_ISR_TEIF6_Msk                               /*!< Channel 6 Transfer Error flag */
#define DMA_ISR_GIF7_Pos       (24U)                                           
#define DMA_ISR_GIF7_Msk       (0x1U << DMA_ISR_GIF7_Pos)                      /*!< 0x01000000 */
#define DMA_ISR_GIF7           DMA_ISR_GIF7_Msk                                /*!< Channel 7 Global interrupt flag */
#define DMA_ISR_TCIF7_Pos      (25U)                                           
#define DMA_ISR_TCIF7_Msk      (0x1U << DMA_ISR_TCIF7_Pos)                     /*!< 0x02000000 */
#define DMA_ISR_TCIF7          DMA_ISR_TCIF7_Msk                               /*!< Channel 7 Transfer Complete flag */
#define DMA_ISR_HTIF7_Pos      (26U)                                           
#define DMA_ISR_HTIF7_Msk      (0x1U << DMA_ISR_HTIF7_Pos)                     /*!< 0x04000000 */
#define DMA_ISR_HTIF7          DMA_ISR_HTIF7_Msk                               /*!< Channel 7 Half Transfer flag */
#define DMA_ISR_TEIF7_Pos      (27U)                                           
#define DMA_ISR_TEIF7_Msk      (0x1U << DMA_ISR_TEIF7_Pos)                     /*!< 0x08000000 */
#define DMA_ISR_TEIF7          DMA_ISR_TEIF7_Msk                               /*!< Channel 7 Transfer Error flag */

/*******************  Bit definition for DMA_IFCR register  *******************/
#define DMA_IFCR_CGIF1_Pos     (0U)                                            
#define DMA_IFCR_CGIF1_Msk     (0x1U << DMA_IFCR_CGIF1_Pos)                    /*!< 0x00000001 */
#define DMA_IFCR_CGIF1         DMA_IFCR_CGIF1_Msk                              /*!< Channel 1 Global interrupt clear */
#define DMA_IFCR_CTCIF1_Pos    (1U)                                            
#define DMA_IFCR_CTCIF1_Msk    (0x1U << DMA_IFCR_CTCIF1_Pos)                   /*!< 0x00000002 */
#define DMA_IFCR_CTCIF1        DMA_IFCR_CTCIF1_Msk                             /*!< Channel 1 Transfer Complete clear */
#define DMA_IFCR_CHTIF1_Pos    (2U)                                            
#define DMA_IFCR_CHTIF1_Msk    (0x1U << DMA_IFCR_CHTIF1_Pos)                   /*!< 0x00000004 */
#define DMA_IFCR_CHTIF1        DMA_IFCR_CHTIF1_Msk                             /*!< Channel 1 Half Transfer clear */
#define DMA_IFCR_CTEIF1_Pos    (3U)                                            
#define DMA_IFCR_CTEIF1_Msk    (0x1U << DMA_IFCR_CTEIF1_Pos)                   /*!< 0x00000008 */
#define DMA_IFCR_CTEIF1        DMA_IFCR_CTEIF1_Msk                             /*!< Channel 1 Transfer Error clear */
#define DMA_IFCR_CGIF2_Pos     (4U)                                            
#define DMA_IFCR_CGIF2_Msk     (0x1U << DMA_IFCR_CGIF2_Pos)                    /*!< 0x00000010 */
#define DMA_IFCR_CGIF2         DMA_IFCR_CGIF2_Msk                              /*!< Channel 2 Global interrupt clear */
#define DMA_IFCR_CTCIF2_Pos    (5U)                                            
#define DMA_IFCR_CTCIF2_Msk    (0x1U << DMA_IFCR_CTCIF2_Pos)                   /*!< 0x00000020 */
#define DMA_IFCR_CTCIF2        DMA_IFCR_CTCIF2_Msk                             /*!< Channel 2 Transfer Complete clear */
#define DMA_IFCR_CHTIF2_Pos    (6U)                                            
#define DMA_IFCR_CHTIF2_Msk    (0x1U << DMA_IFCR_CHTIF2_Pos)                   /*!< 0x00000040 */
#define DMA_IFCR_CHTIF2        DMA_IFCR_CHTIF2_Msk                             /*!< Channel 2 Half Transfer clear */
#define DMA_IFCR_CTEIF2_Pos    (7U)                                            
#define DMA_IFCR_CTEIF2_Msk    (0x1U << DMA_IFCR_CTEIF2_Pos)                   /*!< 0x00000080 */
#define DMA_IFCR_CTEIF2        DMA_IFCR_CTEIF2_Msk                             /*!< Channel 2 Transfer Error clear */
#define DMA_IFCR_CGIF3_Pos     (8U)                                            
#define DMA_IFCR_CGIF3_Msk     (0x1U << DMA_IFCR_CGIF3_Pos)                    /*!< 0x00000100 */
#define DMA_IFCR_CGIF3         DMA_IFCR_CGIF3_Msk                              /*!< Channel 3 Global interrupt clear */
#define DMA_IFCR_CTCIF3_Pos    (9U)                                            
#define DMA_IFCR_CTCIF3_Msk    (0x1U << DMA_IFCR_CTCIF3_Pos)                   /*!< 0x00000200 */
#define DMA_IFCR_CTCIF3        DMA_IFCR_CTCIF3_Msk                             /*!< Channel 3 Transfer Complete clear */
#define DMA_IFCR_CHTIF3_Pos    (10U)                                           
#define DMA_IFCR_CHTIF3_Msk    (0x1U << DMA_IFCR_CHTIF3_Pos)                   /*!< 0x00000400 */
#define DMA_IFCR_CHTIF3        DMA_IFCR_CHTIF3_Msk                             /*!< Channel 3 Half Transfer clear */
#define DMA_IFCR_CTEIF3_Pos    (11U)                                           
#define DMA_IFCR_CTEIF3_Msk    (0x1U << DMA_IFCR_CTEIF3_Pos)                   /*!< 0x00000800 */
#define DMA_IFCR_CTEIF3        DMA_IFCR_CTEIF3_Msk                             /*!< Channel 3 Transfer Error clear */
#define DMA_IFCR_CGIF4_Pos     (12U)                                           
#define DMA_IFCR_CGIF4_Msk     (0x1U << DMA_IFCR_CGIF4_Pos)                    /*!< 0x00001000 */
#define DMA_IFCR_CGIF4         DMA_IFCR_CGIF4_Msk                              /*!< Channel 4 Global interrupt clear */
#define DMA_IFCR_CTCIF4_Pos    (13U)                                           
#define DMA_IFCR_CTCIF4_Msk    (0x1U << DMA_IFCR_CTCIF4_Pos)                   /*!< 0x00002000 */
#define DMA_IFCR_CTCIF4        DMA_IFCR_CTCIF4_Msk                             /*!< Channel 4 Transfer Complete clear */
#define DMA_IFCR_CHTIF4_Pos    (14U)                                           
#define DMA_IFCR_CHTIF4_Msk    (0x1U << DMA_IFCR_CHTIF4_Pos)                   /*!< 0x00004000 */
#define DMA_IFCR_CHTIF4        DMA_IFCR_CHTIF4_Msk                             /*!< Channel 4 Half Transfer clear */
#define DMA_IFCR_CTEIF4_Pos    (15U)                                           
#define DMA_IFCR_CTEIF4_Msk    (0x1U << DMA_IFCR_CTEIF4_Pos)                   /*!< 0x00008000 */
#define DMA_IFCR_CTEIF4        DMA_IFCR_CTEIF4_Msk                             /*!< Channel 4 Transfer Error clear */
#define DMA_IFCR_CGIF5_Pos     (16U)                                           
#define DMA_IFCR_CGIF5_Msk     (0x1U << DMA_IFCR_CGIF5_Pos)                    /*!< 0x00010000 */
#define DMA_IFCR_CGIF5         DMA_IFCR_CGIF5_Msk                              /*!< Channel 5 Global interrupt clear */
#define DMA_IFCR_CTCIF5_Pos    (17U)                                           
#define DMA_IFCR_CTCIF5_Msk    (0x1U << DMA_IFCR_CTCIF5_Pos)                   /*!< 0x00020000 */
#define DMA_IFCR_CTCIF5        DMA_IFCR_CTCIF5_Msk                             /*!< Channel 5 Transfer Complete clear */
#define DMA_IFCR_CHTIF5_Pos    (18U)                                           
#define DMA_IFCR_CHTIF5_Msk    (0x1U << DMA_IFCR_CHTIF5_Pos)                   /*!< 0x00040000 */
#define DMA_IFCR_CHTIF5        DMA_IFCR_CHTIF5_Msk                             /*!< Channel 5 Half Transfer clear */
#define DMA_IFCR_CTEIF5_Pos    (19U)                                           
#define DMA_IFCR_CTEIF5_Msk    (0x1U << DMA_IFCR_CTEIF5_Pos)                   /*!< 0x00080000 */
#define DMA_IFCR_CTEIF5        DMA_IFCR_CTEIF5_Msk                             /*!< Channel 5 Transfer Error clear */
#define DMA_IFCR_CGIF6_Pos     (20U)                                           
#define DMA_IFCR_CGIF6_Msk     (0x1U << DMA_IFCR_CGIF6_Pos)                    /*!< 0x00100000 */
#define DMA_IFCR_CGIF6         DMA_IFCR_CGIF6_Msk                              /*!< Channel 6 Global interrupt clear */
#define DMA_IFCR_CTCIF6_Pos    (21U)                                           
#define DMA_IFCR_CTCIF6_Msk    (0x1U << DMA_IFCR_CTCIF6_Pos)                   /*!< 0x00200000 */
#define DMA_IFCR_CTCIF6        DMA_IFCR_CTCIF6_Msk                             /*!< Channel 6 Transfer Complete clear */
#define DMA_IFCR_CHTIF6_Pos    (22U)                                           
#define DMA_IFCR_CHTIF6_Msk    (0x1U << DMA_IFCR_CHTIF6_Pos)                   /*!< 0x00400000 */
#define DMA_IFCR_CHTIF6        DMA_IFCR_CHTIF6_Msk                             /*!< Channel 6 Half Transfer clear */
#define DMA_IFCR_CTEIF6_Pos    (23U)                                           
#define DMA_IFCR_CTEIF6_Msk    (0x1U << DMA_IFCR_CTEIF6_Pos)                   /*!< 0x00800000 */
#define DMA_IFCR_CTEIF6        DMA_IFCR_CTEIF6_Msk                             /*!< Channel 6 Transfer Error clear */
#define DMA_IFCR_CGIF7_Pos     (24U)                                           
#define DMA_IFCR_CGIF7_Msk     (0x1U << DMA_IFCR_CGIF7_Pos)                    /*!< 0x01000000 */
#define DMA_IFCR_CGIF7         DMA_IFCR_CGIF7_Msk                              /*!< Channel 7 Global interrupt clear */
#define DMA_IFCR_CTCIF7_Pos    (25U)                                           
#define DMA_IFCR_CTCIF7_Msk    (0x1U << DMA_IFCR_CTCIF7_Pos)                   /*!< 0x02000000 */
#define DMA_IFCR_CTCIF7        DMA_IFCR_CTCIF7_Msk                             /*!< Channel 7 Transfer Complete clear */
#define DMA_IFCR_CHTIF7_Pos    (26U)                                           
#define DMA_IFCR_CHTIF7_Msk    (0x1U << DMA_IFCR_CHTIF7_Pos)                   /*!< 0x04000000 */
#define DMA_IFCR_CHTIF7        DMA_IFCR_CHTIF7_Msk                             /*!< Channel 7 Half Transfer clear */
#define DMA_IFCR_CTEIF7_Pos    (27U)                                           
#define DMA_IFCR_CTEIF7_Msk    (0x1U << DMA_IFCR_CTEIF7_Pos)                   /*!< 0x08000000 */
#define DMA_IFCR_CTEIF7        DMA_IFCR_CTEIF7_Msk                             /*!< Channel 7 Transfer Error clear */

/*******************  Bit definition for DMA_CCR register  ********************/
#define DMA_CCR_EN_Pos         (0U)                                            
#define DMA_CCR_EN_Msk         (0x1U << DMA_CCR_EN_Pos)                        /*!< 0x00000001 */
#define DMA_CCR_EN             DMA_CCR_EN_Msk                                  /*!< Channel enable                      */
#define DMA_CCR_TCIE_Pos       (1U)                                            
#define DMA_CCR_TCIE_Msk       (0x1U << DMA_CCR_TCIE_Pos)                      /*!< 0x00000002 */
#define DMA_CCR_TCIE           DMA_CCR_TCIE_Msk                                /*!< Transfer complete interrupt enable  */
#define DMA_CCR_HTIE_Pos       (2U)                                            
#define DMA_CCR_HTIE_Msk       (0x1U << DMA_CCR_HTIE_Pos)                      /*!< 0x00000004 */
#define DMA_CCR_HTIE           DMA_CCR_HTIE_Msk                                /*!< Half Transfer interrupt enable      */
#define DMA_CCR_TEIE_Pos       (3U)                                            
#define DMA_CCR_TEIE_Msk       (0x1U << DMA_CCR_TEIE_Pos)                      /*!< 0x00000008 */
#define DMA_CCR_TEIE           DMA_CCR_TEIE_Msk                                /*!< Transfer error interrupt enable     */
#define DMA_CCR_DIR_Pos        (4U)                                            
#define DMA_CCR_DIR_Msk        (0x1U << DMA_CCR_DIR_Pos)                       /*!< 0x00000010 */
#define DMA_CCR_DIR            DMA_CCR_DIR_Msk                                 /*!< Data transfer direction             */
#define DMA_CCR_CIRC_Pos       (5U)                                            
#define DMA_CCR_CIRC_Msk       (0x1U << DMA_CCR_CIRC_Pos)                      /*!< 0x00000020 */
#define DMA_CCR_CIRC           DMA_CCR_CIRC_Msk                                /*!< Circular mode                       */
#define DMA_CCR_PINC_Pos       (6U)                                            
#define DMA_CCR_PINC_Msk       (0x1U << DMA_CCR_PINC_Pos)                      /*!< 0x00000040 */
#define DMA_CCR_PINC           DMA_CCR_PINC_Msk                                /*!< Peripheral increment mode           */
#define DMA_CCR_MINC_Pos       (7U)                                            
#define DMA_CCR_MINC_Msk       (0x1U << DMA_CCR_MINC_Pos)                      /*!< 0x00000080 */
#define DMA_CCR_MINC           DMA_CCR_MINC_Msk                                /*!< Memory increment mode               */

#define DMA_CCR_PSIZE_Pos      (8U)                                            
#define DMA_CCR_PSIZE_Msk      (0x3U << DMA_CCR_PSIZE_Pos)                     /*!< 0x00000300 */
#define DMA_CCR_PSIZE          DMA_CCR_PSIZE_Msk                               /*!< PSIZE[1:0] bits (Peripheral size)   */
#define DMA_CCR_PSIZE_0        (0x1U << DMA_CCR_PSIZE_Pos)                     /*!< 0x00000100 */
#define DMA_CCR_PSIZE_1        (0x2U << DMA_CCR_PSIZE_Pos)                     /*!< 0x00000200 */

#define DMA_CCR_MSIZE_Pos      (10U)                                           
#define DMA_CCR_MSIZE_Msk      (0x3U << DMA_CCR_MSIZE_Pos)                     /*!< 0x00000C00 */
#define DMA_CCR_MSIZE          DMA_CCR_MSIZE_Msk                               /*!< MSIZE[1:0] bits (Memory size)       */
#define DMA_CCR_MSIZE_0        (0x1U << DMA_CCR_MSIZE_Pos)                     /*!< 0x00000400 */
#define DMA_CCR_MSIZE_1        (0x2U << DMA_CCR_MSIZE_Pos)                     /*!< 0x00000800 */

#define DMA_CCR_PL_Pos         (12U)                                           
#define DMA_CCR_PL_Msk         (0x3U << DMA_CCR_PL_Pos)                        /*!< 0x00003000 */
#define DMA_CCR_PL             DMA_CCR_PL_Msk                                  /*!< PL[1:0] bits(Channel Priority level)*/
#define DMA_CCR_PL_0           (0x1U << DMA_CCR_PL_Pos)                        /*!< 0x00001000 */
#define DMA_CCR_PL_1           (0x2U << DMA_CCR_PL_Pos)                        /*!< 0x00002000 */

#define DMA_CCR_MEM2MEM_Pos    (14U)                                           
#define DMA_CCR_MEM2MEM_Msk    (0x1U << DMA_CCR_MEM2MEM_Pos)                   /*!< 0x00004000 */
#define DMA_CCR_MEM2MEM        DMA_CCR_MEM2MEM_Msk                             /*!< Memory to memory mode               */

/******************  Bit definition for DMA_CNDTR register  *******************/
#define DMA_CNDTR_NDT_Pos      (0U)                                            
#define DMA_CNDTR_NDT_Msk      (0xFFFFU << DMA_CNDTR_NDT_Pos)                  /*!< 0x0000FFFF */
#define DMA_CNDTR_NDT          DMA_CNDTR_NDT_Msk                               /*!< Number of data to Transfer          */

/******************  Bit definition for DMA_CPAR register  ********************/
#define DMA_CPAR_PA_Pos        (0U)                                            
#define DMA_CPAR_PA_Msk        (0xFFFFFFFFU << DMA_CPAR_PA_Pos)                /*!< 0xFFFFFFFF */
#define DMA_CPAR_PA            DMA_CPAR_PA_Msk                                 /*!< Peripheral Address                  */

/******************  Bit definition for DMA_CMAR register  ********************/
#define DMA_CMAR_MA_Pos        (0U)                                            
#define DMA_CMAR_MA_Msk        (0xFFFFFFFFU << DMA_CMAR_MA_Pos)                /*!< 0xFFFFFFFF */
#define DMA_CMAR_MA            DMA_CMAR_MA_Msk                                 /*!< Memory Address                      */

/******************************************************************************/
/*                                                                            */
/*                    External Interrupt/Event Controller (EXTI)              */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for EXTI_IMR register  *******************/
#define EXTI_IMR_MR0_Pos           (0U)                                        
#define EXTI_IMR_MR0_Msk           (0x1U << EXTI_IMR_MR0_Pos)                  /*!< 0x00000001 */
#define EXTI_IMR_MR0               EXTI_IMR_MR0_Msk                            /*!< Interrupt Mask on line 0 */
#define EXTI_IMR_MR1_Pos           (1U)                                        
#define EXTI_IMR_MR1_Msk           (0x1U << EXTI_IMR_MR1_Pos)                  /*!< 0x00000002 */
#define EXTI_IMR_MR1               EXTI_IMR_MR1_Msk                            /*!< Interrupt Mask on line 1 */
#define EXTI_IMR_MR2_Pos           (2U)                                        
#define EXTI_IMR_MR2_Msk           (0x1U << EXTI_IMR_MR2_Pos)                  /*!< 0x00000004 */
#define EXTI_IMR_MR2               EXTI_IMR_MR2_Msk                            /*!< Interrupt Mask on line 2 */
#define EXTI_IMR_MR3_Pos           (3U)                                        
#define EXTI_IMR_MR3_Msk           (0x1U << EXTI_IMR_MR3_Pos)                  /*!< 0x00000008 */
#define EXTI_IMR_MR3               EXTI_IMR_MR3_Msk                            /*!< Interrupt Mask on line 3 */
#define EXTI_IMR_MR4_Pos           (4U)                                        
#define EXTI_IMR_MR4_Msk           (0x1U << EXTI_IMR_MR4_Pos)                  /*!< 0x00000010 */
#define EXTI_IMR_MR4               EXTI_IMR_MR4_Msk                            /*!< Interrupt Mask on line 4 */
#define EXTI_IMR_MR5_Pos           (5U)                                        
#define EXTI_IMR_MR5_Msk           (0x1U << EXTI_IMR_MR5_Pos)                  /*!< 0x00000020 */
#define EXTI_IMR_MR5               EXTI_IMR_MR5_Msk                            /*!< Interrupt Mask on line 5 */
#define EXTI_IMR_MR6_Pos           (6U)                                        
#define EXTI_IMR_MR6_Msk           (0x1U << EXTI_IMR_MR6_Pos)                  /*!< 0x00000040 */
#define EXTI_IMR_MR6               EXTI_IMR_MR6_Msk                            /*!< Interrupt Mask on line 6 */
#define EXTI_IMR_MR7_Pos           (7U)                                        
#define EXTI_IMR_MR7_Msk           (0x1U << EXTI_IMR_MR7_Pos)                  /*!< 0x00000080 */
#define EXTI_IMR_MR7               EXTI_IMR_MR7_Msk                            /*!< Interrupt Mask on line 7 */
#define EXTI_IMR_MR8_Pos           (8U)                                        
#define EXTI_IMR_MR8_Msk           (0x1U << EXTI_IMR_MR8_Pos)                  /*!< 0x00000100 */
#define EXTI_IMR_MR8               EXTI_IMR_MR8_Msk                            /*!< Interrupt Mask on line 8 */
#define EXTI_IMR_MR9_Pos           (9U)                                        
#define EXTI_IMR_MR9_Msk           (0x1U << EXTI_IMR_MR9_Pos)                  /*!< 0x00000200 */
#define EXTI_IMR_MR9               EXTI_IMR_MR9_Msk                            /*!< Interrupt Mask on line 9 */
#define EXTI_IMR_MR10_Pos          (10U)                                       
#define EXTI_IMR_MR10_Msk          (0x1U << EXTI_IMR_MR10_Pos)                 /*!< 0x00000400 */
#define EXTI_IMR_MR10              EXTI_IMR_MR10_Msk                           /*!< Interrupt Mask on line 10 */
#define EXTI_IMR_MR11_Pos          (11U)                                       
#define EXTI_IMR_MR11_Msk          (0x1U << EXTI_IMR_MR11_Pos)                 /*!< 0x00000800 */
#define EXTI_IMR_MR11              EXTI_IMR_MR11_Msk                           /*!< Interrupt Mask on line 11 */
#define EXTI_IMR_MR12_Pos          (12U)                                       
#define EXTI_IMR_MR12_Msk          (0x1U << EXTI_IMR_MR12_Pos)                 /*!< 0x00001000 */
#define EXTI_IMR_MR12              EXTI_IMR_MR12_Msk                           /*!< Interrupt Mask on line 12 */
#define EXTI_IMR_MR13_Pos          (13U)                                       
#define EXTI_IMR_MR13_Msk          (0x1U << EXTI_IMR_MR13_Pos)                 /*!< 0x00002000 */
#define EXTI_IMR_MR13              EXTI_IMR_MR13_Msk                           /*!< Interrupt Mask on line 13 */
#define EXTI_IMR_MR14_Pos          (14U)                                       
#define EXTI_IMR_MR14_Msk          (0x1U << EXTI_IMR_MR14_Pos)                 /*!< 0x00004000 */
#define EXTI_IMR_MR14              EXTI_IMR_MR14_Msk                           /*!< Interrupt Mask on line 14 */
#define EXTI_IMR_MR15_Pos          (15U)                                       
#define EXTI_IMR_MR15_Msk          (0x1U << EXTI_IMR_MR15_Pos)                 /*!< 0x00008000 */
#define EXTI_IMR_MR15              EXTI_IMR_MR15_Msk                           /*!< Interrupt Mask on line 15 */
#define EXTI_IMR_MR16_Pos          (16U)                                       
#define EXTI_IMR_MR16_Msk          (0x1U << EXTI_IMR_MR16_Pos)                 /*!< 0x00010000 */
#define EXTI_IMR_MR16              EXTI_IMR_MR16_Msk                           /*!< Interrupt Mask on line 16 */
#define EXTI_IMR_MR17_Pos          (17U)                                       
#define EXTI_IMR_MR17_Msk          (0x1U << EXTI_IMR_MR17_Pos)                 /*!< 0x00020000 */
#define EXTI_IMR_MR17              EXTI_IMR_MR17_Msk                           /*!< Interrupt Mask on line 17 */
#define EXTI_IMR_MR18_Pos          (18U)                                       
#define EXTI_IMR_MR18_Msk          (0x1U << EXTI_IMR_MR18_Pos)                 /*!< 0x00040000 */
#define EXTI_IMR_MR18              EXTI_IMR_MR18_Msk                           /*!< Interrupt Mask on line 18 */
#define EXTI_IMR_MR19_Pos          (19U)                                       
#define EXTI_IMR_MR19_Msk          (0x1U << EXTI_IMR_MR19_Pos)                 /*!< 0x00080000 */
#define EXTI_IMR_MR19              EXTI_IMR_MR19_Msk                           /*!< Interrupt Mask on line 19 */
#define EXTI_IMR_MR20_Pos          (20U)                                       
#define EXTI_IMR_MR20_Msk          (0x1U << EXTI_IMR_MR20_Pos)                 /*!< 0x00100000 */
#define EXTI_IMR_MR20              EXTI_IMR_MR20_Msk                           /*!< Interrupt Mask on line 20 */
#define EXTI_IMR_MR21_Pos          (21U)                                       
#define EXTI_IMR_MR21_Msk          (0x1U << EXTI_IMR_MR21_Pos)                 /*!< 0x00200000 */
#define EXTI_IMR_MR21              EXTI_IMR_MR21_Msk                           /*!< Interrupt Mask on line 21 */
#define EXTI_IMR_MR22_Pos          (22U)                                       
#define EXTI_IMR_MR22_Msk          (0x1U << EXTI_IMR_MR22_Pos)                 /*!< 0x00400000 */
#define EXTI_IMR_MR22              EXTI_IMR_MR22_Msk                           /*!< Interrupt Mask on line 22 */
#define EXTI_IMR_MR23_Pos          (23U)                                       
#define EXTI_IMR_MR23_Msk          (0x1U << EXTI_IMR_MR23_Pos)                 /*!< 0x00800000 */
#define EXTI_IMR_MR23              EXTI_IMR_MR23_Msk                           /*!< Interrupt Mask on line 23 */
#define EXTI_IMR_MR24_Pos          (24U)                                       
#define EXTI_IMR_MR24_Msk          (0x1U << EXTI_IMR_MR24_Pos)                 /*!< 0x01000000 */
#define EXTI_IMR_MR24              EXTI_IMR_MR24_Msk                           /*!< Interrupt Mask on line 24 */
#define EXTI_IMR_MR25_Pos          (25U)                                       
#define EXTI_IMR_MR25_Msk          (0x1U << EXTI_IMR_MR25_Pos)                 /*!< 0x02000000 */
#define EXTI_IMR_MR25              EXTI_IMR_MR25_Msk                           /*!< Interrupt Mask on line 25 */
#define EXTI_IMR_MR26_Pos          (26U)                                       
#define EXTI_IMR_MR26_Msk          (0x1U << EXTI_IMR_MR26_Pos)                 /*!< 0x04000000 */
#define EXTI_IMR_MR26              EXTI_IMR_MR26_Msk                           /*!< Interrupt Mask on line 26 */
#define EXTI_IMR_MR27_Pos          (27U)                                       
#define EXTI_IMR_MR27_Msk          (0x1U << EXTI_IMR_MR27_Pos)                 /*!< 0x08000000 */
#define EXTI_IMR_MR27              EXTI_IMR_MR27_Msk                           /*!< Interrupt Mask on line 27 */
#define EXTI_IMR_MR28_Pos          (28U)                                       
#define EXTI_IMR_MR28_Msk          (0x1U << EXTI_IMR_MR28_Pos)                 /*!< 0x10000000 */
#define EXTI_IMR_MR28              EXTI_IMR_MR28_Msk                           /*!< Interrupt Mask on line 28 */
#define EXTI_IMR_MR29_Pos          (29U)                                       
#define EXTI_IMR_MR29_Msk          (0x1U << EXTI_IMR_MR29_Pos)                 /*!< 0x20000000 */
#define EXTI_IMR_MR29              EXTI_IMR_MR29_Msk                           /*!< Interrupt Mask on line 29 */
#define EXTI_IMR_MR30_Pos          (30U)                                       
#define EXTI_IMR_MR30_Msk          (0x1U << EXTI_IMR_MR30_Pos)                 /*!< 0x40000000 */
#define EXTI_IMR_MR30              EXTI_IMR_MR30_Msk                           /*!< Interrupt Mask on line 30 */
#define EXTI_IMR_MR31_Pos          (31U)                                       
#define EXTI_IMR_MR31_Msk          (0x1U << EXTI_IMR_MR31_Pos)                 /*!< 0x80000000 */
#define EXTI_IMR_MR31              EXTI_IMR_MR31_Msk                           /*!< Interrupt Mask on line 31 */

/* References Defines */
#define  EXTI_IMR_IM0 EXTI_IMR_MR0
#define  EXTI_IMR_IM1 EXTI_IMR_MR1
#define  EXTI_IMR_IM2 EXTI_IMR_MR2
#define  EXTI_IMR_IM3 EXTI_IMR_MR3
#define  EXTI_IMR_IM4 EXTI_IMR_MR4
#define  EXTI_IMR_IM5 EXTI_IMR_MR5
#define  EXTI_IMR_IM6 EXTI_IMR_MR6
#define  EXTI_IMR_IM7 EXTI_IMR_MR7
#define  EXTI_IMR_IM8 EXTI_IMR_MR8
#define  EXTI_IMR_IM9 EXTI_IMR_MR9
#define  EXTI_IMR_IM10 EXTI_IMR_MR10
#define  EXTI_IMR_IM11 EXTI_IMR_MR11
#define  EXTI_IMR_IM12 EXTI_IMR_MR12
#define  EXTI_IMR_IM13 EXTI_IMR_MR13
#define  EXTI_IMR_IM14 EXTI_IMR_MR14
#define  EXTI_IMR_IM15 EXTI_IMR_MR15
#define  EXTI_IMR_IM16 EXTI_IMR_MR16
#define  EXTI_IMR_IM17 EXTI_IMR_MR17
#define  EXTI_IMR_IM18 EXTI_IMR_MR18
#define  EXTI_IMR_IM19 EXTI_IMR_MR19
#define  EXTI_IMR_IM20 EXTI_IMR_MR20
#define  EXTI_IMR_IM21 EXTI_IMR_MR21
#define  EXTI_IMR_IM22 EXTI_IMR_MR22
#define  EXTI_IMR_IM23 EXTI_IMR_MR23
#define  EXTI_IMR_IM24 EXTI_IMR_MR24
#define  EXTI_IMR_IM25 EXTI_IMR_MR25
#define  EXTI_IMR_IM26 EXTI_IMR_MR26
#define  EXTI_IMR_IM27 EXTI_IMR_MR27
#define  EXTI_IMR_IM28 EXTI_IMR_MR28
#define  EXTI_IMR_IM29 EXTI_IMR_MR29
#define  EXTI_IMR_IM30 EXTI_IMR_MR30
#define  EXTI_IMR_IM31 EXTI_IMR_MR31

#define EXTI_IMR_IM_Pos            (0U)                                        
#define EXTI_IMR_IM_Msk            (0xFFFFFFFFU << EXTI_IMR_IM_Pos)            /*!< 0xFFFFFFFF */
#define EXTI_IMR_IM                EXTI_IMR_IM_Msk                             /*!< Interrupt Mask All */

/*******************  Bit definition for EXTI_EMR register  *******************/
#define EXTI_EMR_MR0_Pos           (0U)                                        
#define EXTI_EMR_MR0_Msk           (0x1U << EXTI_EMR_MR0_Pos)                  /*!< 0x00000001 */
#define EXTI_EMR_MR0               EXTI_EMR_MR0_Msk                            /*!< Event Mask on line 0 */
#define EXTI_EMR_MR1_Pos           (1U)                                        
#define EXTI_EMR_MR1_Msk           (0x1U << EXTI_EMR_MR1_Pos)                  /*!< 0x00000002 */
#define EXTI_EMR_MR1               EXTI_EMR_MR1_Msk                            /*!< Event Mask on line 1 */
#define EXTI_EMR_MR2_Pos           (2U)                                        
#define EXTI_EMR_MR2_Msk           (0x1U << EXTI_EMR_MR2_Pos)                  /*!< 0x00000004 */
#define EXTI_EMR_MR2               EXTI_EMR_MR2_Msk                            /*!< Event Mask on line 2 */
#define EXTI_EMR_MR3_Pos           (3U)                                        
#define EXTI_EMR_MR3_Msk           (0x1U << EXTI_EMR_MR3_Pos)                  /*!< 0x00000008 */
#define EXTI_EMR_MR3               EXTI_EMR_MR3_Msk                            /*!< Event Mask on line 3 */
#define EXTI_EMR_MR4_Pos           (4U)                                        
#define EXTI_EMR_MR4_Msk           (0x1U << EXTI_EMR_MR4_Pos)                  /*!< 0x00000010 */
#define EXTI_EMR_MR4               EXTI_EMR_MR4_Msk                            /*!< Event Mask on line 4 */
#define EXTI_EMR_MR5_Pos           (5U)                                        
#define EXTI_EMR_MR5_Msk           (0x1U << EXTI_EMR_MR5_Pos)                  /*!< 0x00000020 */
#define EXTI_EMR_MR5               EXTI_EMR_MR5_Msk                            /*!< Event Mask on line 5 */
#define EXTI_EMR_MR6_Pos           (6U)                                        
#define EXTI_EMR_MR6_Msk           (0x1U << EXTI_EMR_MR6_Pos)                  /*!< 0x00000040 */
#define EXTI_EMR_MR6               EXTI_EMR_MR6_Msk                            /*!< Event Mask on line 6 */
#define EXTI_EMR_MR7_Pos           (7U)                                        
#define EXTI_EMR_MR7_Msk           (0x1U << EXTI_EMR_MR7_Pos)                  /*!< 0x00000080 */
#define EXTI_EMR_MR7               EXTI_EMR_MR7_Msk                            /*!< Event Mask on line 7 */
#define EXTI_EMR_MR8_Pos           (8U)                                        
#define EXTI_EMR_MR8_Msk           (0x1U << EXTI_EMR_MR8_Pos)                  /*!< 0x00000100 */
#define EXTI_EMR_MR8               EXTI_EMR_MR8_Msk                            /*!< Event Mask on line 8 */
#define EXTI_EMR_MR9_Pos           (9U)                                        
#define EXTI_EMR_MR9_Msk           (0x1U << EXTI_EMR_MR9_Pos)                  /*!< 0x00000200 */
#define EXTI_EMR_MR9               EXTI_EMR_MR9_Msk                            /*!< Event Mask on line 9 */
#define EXTI_EMR_MR10_Pos          (10U)                                       
#define EXTI_EMR_MR10_Msk          (0x1U << EXTI_EMR_MR10_Pos)                 /*!< 0x00000400 */
#define EXTI_EMR_MR10              EXTI_EMR_MR10_Msk                           /*!< Event Mask on line 10 */
#define EXTI_EMR_MR11_Pos          (11U)                                       
#define EXTI_EMR_MR11_Msk          (0x1U << EXTI_EMR_MR11_Pos)                 /*!< 0x00000800 */
#define EXTI_EMR_MR11              EXTI_EMR_MR11_Msk                           /*!< Event Mask on line 11 */
#define EXTI_EMR_MR12_Pos          (12U)                                       
#define EXTI_EMR_MR12_Msk          (0x1U << EXTI_EMR_MR12_Pos)                 /*!< 0x00001000 */
#define EXTI_EMR_MR12              EXTI_EMR_MR12_Msk                           /*!< Event Mask on line 12 */
#define EXTI_EMR_MR13_Pos          (13U)                                       
#define EXTI_EMR_MR13_Msk          (0x1U << EXTI_EMR_MR13_Pos)                 /*!< 0x00002000 */
#define EXTI_EMR_MR13              EXTI_EMR_MR13_Msk                           /*!< Event Mask on line 13 */
#define EXTI_EMR_MR14_Pos          (14U)                                       
#define EXTI_EMR_MR14_Msk          (0x1U << EXTI_EMR_MR14_Pos)                 /*!< 0x00004000 */
#define EXTI_EMR_MR14              EXTI_EMR_MR14_Msk                           /*!< Event Mask on line 14 */
#define EXTI_EMR_MR15_Pos          (15U)                                       
#define EXTI_EMR_MR15_Msk          (0x1U << EXTI_EMR_MR15_Pos)                 /*!< 0x00008000 */
#define EXTI_EMR_MR15              EXTI_EMR_MR15_Msk                           /*!< Event Mask on line 15 */
#define EXTI_EMR_MR16_Pos          (16U)                                       
#define EXTI_EMR_MR16_Msk          (0x1U << EXTI_EMR_MR16_Pos)                 /*!< 0x00010000 */
#define EXTI_EMR_MR16              EXTI_EMR_MR16_Msk                           /*!< Event Mask on line 16 */
#define EXTI_EMR_MR17_Pos          (17U)                                       
#define EXTI_EMR_MR17_Msk          (0x1U << EXTI_EMR_MR17_Pos)                 /*!< 0x00020000 */
#define EXTI_EMR_MR17              EXTI_EMR_MR17_Msk                           /*!< Event Mask on line 17 */
#define EXTI_EMR_MR18_Pos          (18U)                                       
#define EXTI_EMR_MR18_Msk          (0x1U << EXTI_EMR_MR18_Pos)                 /*!< 0x00040000 */
#define EXTI_EMR_MR18              EXTI_EMR_MR18_Msk                           /*!< Event Mask on line 18 */
#define EXTI_EMR_MR19_Pos          (19U)                                       
#define EXTI_EMR_MR19_Msk          (0x1U << EXTI_EMR_MR19_Pos)                 /*!< 0x00080000 */
#define EXTI_EMR_MR19              EXTI_EMR_MR19_Msk                           /*!< Event Mask on line 19 */
#define EXTI_EMR_MR20_Pos          (20U)                                       
#define EXTI_EMR_MR20_Msk          (0x1U << EXTI_EMR_MR20_Pos)                 /*!< 0x00100000 */
#define EXTI_EMR_MR20              EXTI_EMR_MR20_Msk                           /*!< Event Mask on line 20 */
#define EXTI_EMR_MR21_Pos          (21U)                                       
#define EXTI_EMR_MR21_Msk          (0x1U << EXTI_EMR_MR21_Pos)                 /*!< 0x00200000 */
#define EXTI_EMR_MR21              EXTI_EMR_MR21_Msk                           /*!< Event Mask on line 21 */
#define EXTI_EMR_MR22_Pos          (22U)                                       
#define EXTI_EMR_MR22_Msk          (0x1U << EXTI_EMR_MR22_Pos)                 /*!< 0x00400000 */
#define EXTI_EMR_MR22              EXTI_EMR_MR22_Msk                           /*!< Event Mask on line 22 */
#define EXTI_EMR_MR23_Pos          (23U)                                       
#define EXTI_EMR_MR23_Msk          (0x1U << EXTI_EMR_MR23_Pos)                 /*!< 0x00800000 */
#define EXTI_EMR_MR23              EXTI_EMR_MR23_Msk                           /*!< Event Mask on line 23 */
#define EXTI_EMR_MR24_Pos          (24U)                                       
#define EXTI_EMR_MR24_Msk          (0x1U << EXTI_EMR_MR24_Pos)                 /*!< 0x01000000 */
#define EXTI_EMR_MR24              EXTI_EMR_MR24_Msk                           /*!< Event Mask on line 24 */
#define EXTI_EMR_MR25_Pos          (25U)                                       
#define EXTI_EMR_MR25_Msk          (0x1U << EXTI_EMR_MR25_Pos)                 /*!< 0x02000000 */
#define EXTI_EMR_MR25              EXTI_EMR_MR25_Msk                           /*!< Event Mask on line 25 */
#define EXTI_EMR_MR26_Pos          (26U)                                       
#define EXTI_EMR_MR26_Msk          (0x1U << EXTI_EMR_MR26_Pos)                 /*!< 0x04000000 */
#define EXTI_EMR_MR26              EXTI_EMR_MR26_Msk                           /*!< Event Mask on line 26 */
#define EXTI_EMR_MR27_Pos          (27U)                                       
#define EXTI_EMR_MR27_Msk          (0x1U << EXTI_EMR_MR27_Pos)                 /*!< 0x08000000 */
#define EXTI_EMR_MR27              EXTI_EMR_MR27_Msk                           /*!< Event Mask on line 27 */
#define EXTI_EMR_MR28_Pos          (28U)                                       
#define EXTI_EMR_MR28_Msk          (0x1U << EXTI_EMR_MR28_Pos)                 /*!< 0x10000000 */
#define EXTI_EMR_MR28              EXTI_EMR_MR28_Msk                           /*!< Event Mask on line 28 */
#define EXTI_EMR_MR29_Pos          (29U)                                       
#define EXTI_EMR_MR29_Msk          (0x1U << EXTI_EMR_MR29_Pos)                 /*!< 0x20000000 */
#define EXTI_EMR_MR29              EXTI_EMR_MR29_Msk                           /*!< Event Mask on line 29 */
#define EXTI_EMR_MR30_Pos          (30U)                                       
#define EXTI_EMR_MR30_Msk          (0x1U << EXTI_EMR_MR30_Pos)                 /*!< 0x40000000 */
#define EXTI_EMR_MR30              EXTI_EMR_MR30_Msk                           /*!< Event Mask on line 30 */
#define EXTI_EMR_MR31_Pos          (31U)                                       
#define EXTI_EMR_MR31_Msk          (0x1U << EXTI_EMR_MR31_Pos)                 /*!< 0x80000000 */
#define EXTI_EMR_MR31              EXTI_EMR_MR31_Msk                           /*!< Event Mask on line 31 */

/* References Defines */
#define  EXTI_EMR_EM0 EXTI_EMR_MR0
#define  EXTI_EMR_EM1 EXTI_EMR_MR1
#define  EXTI_EMR_EM2 EXTI_EMR_MR2
#define  EXTI_EMR_EM3 EXTI_EMR_MR3
#define  EXTI_EMR_EM4 EXTI_EMR_MR4
#define  EXTI_EMR_EM5 EXTI_EMR_MR5
#define  EXTI_EMR_EM6 EXTI_EMR_MR6
#define  EXTI_EMR_EM7 EXTI_EMR_MR7
#define  EXTI_EMR_EM8 EXTI_EMR_MR8
#define  EXTI_EMR_EM9 EXTI_EMR_MR9
#define  EXTI_EMR_EM10 EXTI_EMR_MR10
#define  EXTI_EMR_EM11 EXTI_EMR_MR11
#define  EXTI_EMR_EM12 EXTI_EMR_MR12
#define  EXTI_EMR_EM13 EXTI_EMR_MR13
#define  EXTI_EMR_EM14 EXTI_EMR_MR14
#define  EXTI_EMR_EM15 EXTI_EMR_MR15
#define  EXTI_EMR_EM16 EXTI_EMR_MR16
#define  EXTI_EMR_EM17 EXTI_EMR_MR17
#define  EXTI_EMR_EM18 EXTI_EMR_MR18
#define  EXTI_EMR_EM19 EXTI_EMR_MR19
#define  EXTI_EMR_EM20 EXTI_EMR_MR20
#define  EXTI_EMR_EM21 EXTI_EMR_MR21
#define  EXTI_EMR_EM22 EXTI_EMR_MR22
#define  EXTI_EMR_EM23 EXTI_EMR_MR23
#define  EXTI_EMR_EM24 EXTI_EMR_MR24
#define  EXTI_EMR_EM25 EXTI_EMR_MR25
#define  EXTI_EMR_EM26 EXTI_EMR_MR26
#define  EXTI_EMR_EM27 EXTI_EMR_MR27
#define  EXTI_EMR_EM28 EXTI_EMR_MR28
#define  EXTI_EMR_EM29 EXTI_EMR_MR29
#define  EXTI_EMR_EM30 EXTI_EMR_MR30
#define  EXTI_EMR_EM31 EXTI_EMR_MR31

/******************  Bit definition for EXTI_RTSR register  *******************/
#define EXTI_RTSR_TR0_Pos          (0U)                                        
#define EXTI_RTSR_TR0_Msk          (0x1U << EXTI_RTSR_TR0_Pos)                 /*!< 0x00000001 */
#define EXTI_RTSR_TR0              EXTI_RTSR_TR0_Msk                           /*!< Rising trigger event configuration bit of line 0 */
#define EXTI_RTSR_TR1_Pos          (1U)                                        
#define EXTI_RTSR_TR1_Msk          (0x1U << EXTI_RTSR_TR1_Pos)                 /*!< 0x00000002 */
#define EXTI_RTSR_TR1              EXTI_RTSR_TR1_Msk                           /*!< Rising trigger event configuration bit of line 1 */
#define EXTI_RTSR_TR2_Pos          (2U)                                        
#define EXTI_RTSR_TR2_Msk          (0x1U << EXTI_RTSR_TR2_Pos)                 /*!< 0x00000004 */
#define EXTI_RTSR_TR2              EXTI_RTSR_TR2_Msk                           /*!< Rising trigger event configuration bit of line 2 */
#define EXTI_RTSR_TR3_Pos          (3U)                                        
#define EXTI_RTSR_TR3_Msk          (0x1U << EXTI_RTSR_TR3_Pos)                 /*!< 0x00000008 */
#define EXTI_RTSR_TR3              EXTI_RTSR_TR3_Msk                           /*!< Rising trigger event configuration bit of line 3 */
#define EXTI_RTSR_TR4_Pos          (4U)                                        
#define EXTI_RTSR_TR4_Msk          (0x1U << EXTI_RTSR_TR4_Pos)                 /*!< 0x00000010 */
#define EXTI_RTSR_TR4              EXTI_RTSR_TR4_Msk                           /*!< Rising trigger event configuration bit of line 4 */
#define EXTI_RTSR_TR5_Pos          (5U)                                        
#define EXTI_RTSR_TR5_Msk          (0x1U << EXTI_RTSR_TR5_Pos)                 /*!< 0x00000020 */
#define EXTI_RTSR_TR5              EXTI_RTSR_TR5_Msk                           /*!< Rising trigger event configuration bit of line 5 */
#define EXTI_RTSR_TR6_Pos          (6U)                                        
#define EXTI_RTSR_TR6_Msk          (0x1U << EXTI_RTSR_TR6_Pos)                 /*!< 0x00000040 */
#define EXTI_RTSR_TR6              EXTI_RTSR_TR6_Msk                           /*!< Rising trigger event configuration bit of line 6 */
#define EXTI_RTSR_TR7_Pos          (7U)                                        
#define EXTI_RTSR_TR7_Msk          (0x1U << EXTI_RTSR_TR7_Pos)                 /*!< 0x00000080 */
#define EXTI_RTSR_TR7              EXTI_RTSR_TR7_Msk                           /*!< Rising trigger event configuration bit of line 7 */
#define EXTI_RTSR_TR8_Pos          (8U)                                        
#define EXTI_RTSR_TR8_Msk          (0x1U << EXTI_RTSR_TR8_Pos)                 /*!< 0x00000100 */
#define EXTI_RTSR_TR8              EXTI_RTSR_TR8_Msk                           /*!< Rising trigger event configuration bit of line 8 */
#define EXTI_RTSR_TR9_Pos          (9U)                                        
#define EXTI_RTSR_TR9_Msk          (0x1U << EXTI_RTSR_TR9_Pos)                 /*!< 0x00000200 */
#define EXTI_RTSR_TR9              EXTI_RTSR_TR9_Msk                           /*!< Rising trigger event configuration bit of line 9 */
#define EXTI_RTSR_TR10_Pos         (10U)                                       
#define EXTI_RTSR_TR10_Msk         (0x1U << EXTI_RTSR_TR10_Pos)                /*!< 0x00000400 */
#define EXTI_RTSR_TR10             EXTI_RTSR_TR10_Msk                          /*!< Rising trigger event configuration bit of line 10 */
#define EXTI_RTSR_TR11_Pos         (11U)                                       
#define EXTI_RTSR_TR11_Msk         (0x1U << EXTI_RTSR_TR11_Pos)                /*!< 0x00000800 */
#define EXTI_RTSR_TR11             EXTI_RTSR_TR11_Msk                          /*!< Rising trigger event configuration bit of line 11 */
#define EXTI_RTSR_TR12_Pos         (12U)                                       
#define EXTI_RTSR_TR12_Msk         (0x1U << EXTI_RTSR_TR12_Pos)                /*!< 0x00001000 */
#define EXTI_RTSR_TR12             EXTI_RTSR_TR12_Msk                          /*!< Rising trigger event configuration bit of line 12 */
#define EXTI_RTSR_TR13_Pos         (13U)                                       
#define EXTI_RTSR_TR13_Msk         (0x1U << EXTI_RTSR_TR13_Pos)                /*!< 0x00002000 */
#define EXTI_RTSR_TR13             EXTI_RTSR_TR13_Msk                          /*!< Rising trigger event configuration bit of line 13 */
#define EXTI_RTSR_TR14_Pos         (14U)                                       
#define EXTI_RTSR_TR14_Msk         (0x1U << EXTI_RTSR_TR14_Pos)                /*!< 0x00004000 */
#define EXTI_RTSR_TR14             EXTI_RTSR_TR14_Msk                          /*!< Rising trigger event configuration bit of line 14 */
#define EXTI_RTSR_TR15_Pos         (15U)                                       
#define EXTI_RTSR_TR15_Msk         (0x1U << EXTI_RTSR_TR15_Pos)                /*!< 0x00008000 */
#define EXTI_RTSR_TR15             EXTI_RTSR_TR15_Msk                          /*!< Rising trigger event configuration bit of line 15 */
#define EXTI_RTSR_TR16_Pos         (16U)                                       
#define EXTI_RTSR_TR16_Msk         (0x1U << EXTI_RTSR_TR16_Pos)                /*!< 0x00010000 */
#define EXTI_RTSR_TR16             EXTI_RTSR_TR16_Msk                          /*!< Rising trigger event configuration bit of line 16 */
#define EXTI_RTSR_TR17_Pos         (17U)                                       
#define EXTI_RTSR_TR17_Msk         (0x1U << EXTI_RTSR_TR17_Pos)                /*!< 0x00020000 */
#define EXTI_RTSR_TR17             EXTI_RTSR_TR17_Msk                          /*!< Rising trigger event configuration bit of line 17 */
#define EXTI_RTSR_TR18_Pos         (18U)                                       
#define EXTI_RTSR_TR18_Msk         (0x1U << EXTI_RTSR_TR18_Pos)                /*!< 0x00040000 */
#define EXTI_RTSR_TR18             EXTI_RTSR_TR18_Msk                          /*!< Rising trigger event configuration bit of line 18 */
#define EXTI_RTSR_TR19_Pos         (19U)                                       
#define EXTI_RTSR_TR19_Msk         (0x1U << EXTI_RTSR_TR19_Pos)                /*!< 0x00080000 */
#define EXTI_RTSR_TR19             EXTI_RTSR_TR19_Msk                          /*!< Rising trigger event configuration bit of line 19 */
#define EXTI_RTSR_TR20_Pos         (20U)                                       
#define EXTI_RTSR_TR20_Msk         (0x1U << EXTI_RTSR_TR20_Pos)                /*!< 0x00100000 */
#define EXTI_RTSR_TR20             EXTI_RTSR_TR20_Msk                          /*!< Rising trigger event configuration bit of line 20 */
#define EXTI_RTSR_TR21_Pos         (21U)                                       
#define EXTI_RTSR_TR21_Msk         (0x1U << EXTI_RTSR_TR21_Pos)                /*!< 0x00200000 */
#define EXTI_RTSR_TR21             EXTI_RTSR_TR21_Msk                          /*!< Rising trigger event configuration bit of line 21 */
#define EXTI_RTSR_TR22_Pos         (22U)                                       
#define EXTI_RTSR_TR22_Msk         (0x1U << EXTI_RTSR_TR22_Pos)                /*!< 0x00400000 */
#define EXTI_RTSR_TR22             EXTI_RTSR_TR22_Msk                          /*!< Rising trigger event configuration bit of line 22 */
#define EXTI_RTSR_TR29_Pos         (29U)                                       
#define EXTI_RTSR_TR29_Msk         (0x1U << EXTI_RTSR_TR29_Pos)                /*!< 0x20000000 */
#define EXTI_RTSR_TR29             EXTI_RTSR_TR29_Msk                          /*!< Rising trigger event configuration bit of line 29 */
#define EXTI_RTSR_TR30_Pos         (30U)                                       
#define EXTI_RTSR_TR30_Msk         (0x1U << EXTI_RTSR_TR30_Pos)                /*!< 0x40000000 */
#define EXTI_RTSR_TR30             EXTI_RTSR_TR30_Msk                          /*!< Rising trigger event configuration bit of line 30 */
#define EXTI_RTSR_TR31_Pos         (31U)                                       
#define EXTI_RTSR_TR31_Msk         (0x1U << EXTI_RTSR_TR31_Pos)                /*!< 0x80000000 */
#define EXTI_RTSR_TR31             EXTI_RTSR_TR31_Msk                          /*!< Rising trigger event configuration bit of line 31 */

/* References Defines */
#define EXTI_RTSR_RT0 EXTI_RTSR_TR0
#define EXTI_RTSR_RT1 EXTI_RTSR_TR1
#define EXTI_RTSR_RT2 EXTI_RTSR_TR2
#define EXTI_RTSR_RT3 EXTI_RTSR_TR3
#define EXTI_RTSR_RT4 EXTI_RTSR_TR4
#define EXTI_RTSR_RT5 EXTI_RTSR_TR5
#define EXTI_RTSR_RT6 EXTI_RTSR_TR6
#define EXTI_RTSR_RT7 EXTI_RTSR_TR7
#define EXTI_RTSR_RT8 EXTI_RTSR_TR8
#define EXTI_RTSR_RT9 EXTI_RTSR_TR9
#define EXTI_RTSR_RT10 EXTI_RTSR_TR10
#define EXTI_RTSR_RT11 EXTI_RTSR_TR11
#define EXTI_RTSR_RT12 EXTI_RTSR_TR12
#define EXTI_RTSR_RT13 EXTI_RTSR_TR13
#define EXTI_RTSR_RT14 EXTI_RTSR_TR14
#define EXTI_RTSR_RT15 EXTI_RTSR_TR15
#define EXTI_RTSR_RT16 EXTI_RTSR_TR16
#define EXTI_RTSR_RT17 EXTI_RTSR_TR17
#define EXTI_RTSR_RT18 EXTI_RTSR_TR18
#define EXTI_RTSR_RT19 EXTI_RTSR_TR19
#define EXTI_RTSR_RT20 EXTI_RTSR_TR20
#define EXTI_RTSR_RT21 EXTI_RTSR_TR21
#define EXTI_RTSR_RT22 EXTI_RTSR_TR22
#define EXTI_RTSR_RT29 EXTI_RTSR_TR29
#define EXTI_RTSR_RT30 EXTI_RTSR_TR30
#define EXTI_RTSR_RT31 EXTI_RTSR_TR31

/******************  Bit definition for EXTI_FTSR register  *******************/
#define EXTI_FTSR_TR0_Pos          (0U)                                        
#define EXTI_FTSR_TR0_Msk          (0x1U << EXTI_FTSR_TR0_Pos)                 /*!< 0x00000001 */
#define EXTI_FTSR_TR0              EXTI_FTSR_TR0_Msk                           /*!< Falling trigger event configuration bit of line 0 */
#define EXTI_FTSR_TR1_Pos          (1U)                                        
#define EXTI_FTSR_TR1_Msk          (0x1U << EXTI_FTSR_TR1_Pos)                 /*!< 0x00000002 */
#define EXTI_FTSR_TR1              EXTI_FTSR_TR1_Msk                           /*!< Falling trigger event configuration bit of line 1 */
#define EXTI_FTSR_TR2_Pos          (2U)                                        
#define EXTI_FTSR_TR2_Msk          (0x1U << EXTI_FTSR_TR2_Pos)                 /*!< 0x00000004 */
#define EXTI_FTSR_TR2              EXTI_FTSR_TR2_Msk                           /*!< Falling trigger event configuration bit of line 2 */
#define EXTI_FTSR_TR3_Pos          (3U)                                        
#define EXTI_FTSR_TR3_Msk          (0x1U << EXTI_FTSR_TR3_Pos)                 /*!< 0x00000008 */
#define EXTI_FTSR_TR3              EXTI_FTSR_TR3_Msk                           /*!< Falling trigger event configuration bit of line 3 */
#define EXTI_FTSR_TR4_Pos          (4U)                                        
#define EXTI_FTSR_TR4_Msk          (0x1U << EXTI_FTSR_TR4_Pos)                 /*!< 0x00000010 */
#define EXTI_FTSR_TR4              EXTI_FTSR_TR4_Msk                           /*!< Falling trigger event configuration bit of line 4 */
#define EXTI_FTSR_TR5_Pos          (5U)                                        
#define EXTI_FTSR_TR5_Msk          (0x1U << EXTI_FTSR_TR5_Pos)                 /*!< 0x00000020 */
#define EXTI_FTSR_TR5              EXTI_FTSR_TR5_Msk                           /*!< Falling trigger event configuration bit of line 5 */
#define EXTI_FTSR_TR6_Pos          (6U)                                        
#define EXTI_FTSR_TR6_Msk          (0x1U << EXTI_FTSR_TR6_Pos)                 /*!< 0x00000040 */
#define EXTI_FTSR_TR6              EXTI_FTSR_TR6_Msk                           /*!< Falling trigger event configuration bit of line 6 */
#define EXTI_FTSR_TR7_Pos          (7U)                                        
#define EXTI_FTSR_TR7_Msk          (0x1U << EXTI_FTSR_TR7_Pos)                 /*!< 0x00000080 */
#define EXTI_FTSR_TR7              EXTI_FTSR_TR7_Msk                           /*!< Falling trigger event configuration bit of line 7 */
#define EXTI_FTSR_TR8_Pos          (8U)                                        
#define EXTI_FTSR_TR8_Msk          (0x1U << EXTI_FTSR_TR8_Pos)                 /*!< 0x00000100 */
#define EXTI_FTSR_TR8              EXTI_FTSR_TR8_Msk                           /*!< Falling trigger event configuration bit of line 8 */
#define EXTI_FTSR_TR9_Pos          (9U)                                        
#define EXTI_FTSR_TR9_Msk          (0x1U << EXTI_FTSR_TR9_Pos)                 /*!< 0x00000200 */
#define EXTI_FTSR_TR9              EXTI_FTSR_TR9_Msk                           /*!< Falling trigger event configuration bit of line 9 */
#define EXTI_FTSR_TR10_Pos         (10U)                                       
#define EXTI_FTSR_TR10_Msk         (0x1U << EXTI_FTSR_TR10_Pos)                /*!< 0x00000400 */
#define EXTI_FTSR_TR10             EXTI_FTSR_TR10_Msk                          /*!< Falling trigger event configuration bit of line 10 */
#define EXTI_FTSR_TR11_Pos         (11U)                                       
#define EXTI_FTSR_TR11_Msk         (0x1U << EXTI_FTSR_TR11_Pos)                /*!< 0x00000800 */
#define EXTI_FTSR_TR11             EXTI_FTSR_TR11_Msk                          /*!< Falling trigger event configuration bit of line 11 */
#define EXTI_FTSR_TR12_Pos         (12U)                                       
#define EXTI_FTSR_TR12_Msk         (0x1U << EXTI_FTSR_TR12_Pos)                /*!< 0x00001000 */
#define EXTI_FTSR_TR12             EXTI_FTSR_TR12_Msk                          /*!< Falling trigger event configuration bit of line 12 */
#define EXTI_FTSR_TR13_Pos         (13U)                                       
#define EXTI_FTSR_TR13_Msk         (0x1U << EXTI_FTSR_TR13_Pos)                /*!< 0x00002000 */
#define EXTI_FTSR_TR13             EXTI_FTSR_TR13_Msk                          /*!< Falling trigger event configuration bit of line 13 */
#define EXTI_FTSR_TR14_Pos         (14U)                                       
#define EXTI_FTSR_TR14_Msk         (0x1U << EXTI_FTSR_TR14_Pos)                /*!< 0x00004000 */
#define EXTI_FTSR_TR14             EXTI_FTSR_TR14_Msk                          /*!< Falling trigger event configuration bit of line 14 */
#define EXTI_FTSR_TR15_Pos         (15U)                                       
#define EXTI_FTSR_TR15_Msk         (0x1U << EXTI_FTSR_TR15_Pos)                /*!< 0x00008000 */
#define EXTI_FTSR_TR15             EXTI_FTSR_TR15_Msk                          /*!< Falling trigger event configuration bit of line 15 */
#define EXTI_FTSR_TR16_Pos         (16U)                                       
#define EXTI_FTSR_TR16_Msk         (0x1U << EXTI_FTSR_TR16_Pos)                /*!< 0x00010000 */
#define EXTI_FTSR_TR16             EXTI_FTSR_TR16_Msk                          /*!< Falling trigger event configuration bit of line 16 */
#define EXTI_FTSR_TR17_Pos         (17U)                                       
#define EXTI_FTSR_TR17_Msk         (0x1U << EXTI_FTSR_TR17_Pos)                /*!< 0x00020000 */
#define EXTI_FTSR_TR17             EXTI_FTSR_TR17_Msk                          /*!< Falling trigger event configuration bit of line 17 */
#define EXTI_FTSR_TR18_Pos         (18U)                                       
#define EXTI_FTSR_TR18_Msk         (0x1U << EXTI_FTSR_TR18_Pos)                /*!< 0x00040000 */
#define EXTI_FTSR_TR18             EXTI_FTSR_TR18_Msk                          /*!< Falling trigger event configuration bit of line 18 */
#define EXTI_FTSR_TR19_Pos         (19U)                                       
#define EXTI_FTSR_TR19_Msk         (0x1U << EXTI_FTSR_TR19_Pos)                /*!< 0x00080000 */
#define EXTI_FTSR_TR19             EXTI_FTSR_TR19_Msk                          /*!< Falling trigger event configuration bit of line 19 */
#define EXTI_FTSR_TR20_Pos         (20U)                                       
#define EXTI_FTSR_TR20_Msk         (0x1U << EXTI_FTSR_TR20_Pos)                /*!< 0x00100000 */
#define EXTI_FTSR_TR20             EXTI_FTSR_TR20_Msk                          /*!< Falling trigger event configuration bit of line 20 */
#define EXTI_FTSR_TR21_Pos         (21U)                                       
#define EXTI_FTSR_TR21_Msk         (0x1U << EXTI_FTSR_TR21_Pos)                /*!< 0x00200000 */
#define EXTI_FTSR_TR21             EXTI_FTSR_TR21_Msk                          /*!< Falling trigger event configuration bit of line 21 */
#define EXTI_FTSR_TR22_Pos         (22U)                                       
#define EXTI_FTSR_TR22_Msk         (0x1U << EXTI_FTSR_TR22_Pos)                /*!< 0x00400000 */
#define EXTI_FTSR_TR22             EXTI_FTSR_TR22_Msk                          /*!< Falling trigger event configuration bit of line 22 */
#define EXTI_FTSR_TR29_Pos         (29U)                                       
#define EXTI_FTSR_TR29_Msk         (0x1U << EXTI_FTSR_TR29_Pos)                /*!< 0x20000000 */
#define EXTI_FTSR_TR29             EXTI_FTSR_TR29_Msk                          /*!< Falling trigger event configuration bit of line 29 */
#define EXTI_FTSR_TR30_Pos         (30U)                                       
#define EXTI_FTSR_TR30_Msk         (0x1U << EXTI_FTSR_TR30_Pos)                /*!< 0x40000000 */
#define EXTI_FTSR_TR30             EXTI_FTSR_TR30_Msk                          /*!< Falling trigger event configuration bit of line 30 */
#define EXTI_FTSR_TR31_Pos         (31U)                                       
#define EXTI_FTSR_TR31_Msk         (0x1U << EXTI_FTSR_TR31_Pos)                /*!< 0x80000000 */
#define EXTI_FTSR_TR31             EXTI_FTSR_TR31_Msk                          /*!< Falling trigger event configuration bit of line 31 */

/* References Defines */
#define EXTI_FTSR_FT0 EXTI_FTSR_TR0
#define EXTI_FTSR_FT1 EXTI_FTSR_TR1
#define EXTI_FTSR_FT2 EXTI_FTSR_TR2
#define EXTI_FTSR_FT3 EXTI_FTSR_TR3
#define EXTI_FTSR_FT4 EXTI_FTSR_TR4
#define EXTI_FTSR_FT5 EXTI_FTSR_TR5
#define EXTI_FTSR_FT6 EXTI_FTSR_TR6
#define EXTI_FTSR_FT7 EXTI_FTSR_TR7
#define EXTI_FTSR_FT8 EXTI_FTSR_TR8
#define EXTI_FTSR_FT9 EXTI_FTSR_TR9
#define EXTI_FTSR_FT10 EXTI_FTSR_TR10
#define EXTI_FTSR_FT11 EXTI_FTSR_TR11
#define EXTI_FTSR_FT12 EXTI_FTSR_TR12
#define EXTI_FTSR_FT13 EXTI_FTSR_TR13
#define EXTI_FTSR_FT14 EXTI_FTSR_TR14
#define EXTI_FTSR_FT15 EXTI_FTSR_TR15
#define EXTI_FTSR_FT16 EXTI_FTSR_TR16
#define EXTI_FTSR_FT17 EXTI_FTSR_TR17
#define  EXTI_FTSR_FT18 EXTI_FTSR_TR18
#define  EXTI_FTSR_FT19 EXTI_FTSR_TR19
#define  EXTI_FTSR_FT20 EXTI_FTSR_TR20
#define  EXTI_FTSR_FT21 EXTI_FTSR_TR21
#define  EXTI_FTSR_FT22 EXTI_FTSR_TR22
#define  EXTI_FTSR_FT29 EXTI_FTSR_TR29
#define  EXTI_FTSR_FT30 EXTI_FTSR_TR30
#define  EXTI_FTSR_FT31 EXTI_FTSR_TR31

/******************  Bit definition for EXTI_SWIER register  ******************/
#define EXTI_SWIER_SWIER0_Pos      (0U)                                        
#define EXTI_SWIER_SWIER0_Msk      (0x1U << EXTI_SWIER_SWIER0_Pos)             /*!< 0x00000001 */
#define EXTI_SWIER_SWIER0          EXTI_SWIER_SWIER0_Msk                       /*!< Software Interrupt on line 0 */
#define EXTI_SWIER_SWIER1_Pos      (1U)                                        
#define EXTI_SWIER_SWIER1_Msk      (0x1U << EXTI_SWIER_SWIER1_Pos)             /*!< 0x00000002 */
#define EXTI_SWIER_SWIER1          EXTI_SWIER_SWIER1_Msk                       /*!< Software Interrupt on line 1 */
#define EXTI_SWIER_SWIER2_Pos      (2U)                                        
#define EXTI_SWIER_SWIER2_Msk      (0x1U << EXTI_SWIER_SWIER2_Pos)             /*!< 0x00000004 */
#define EXTI_SWIER_SWIER2          EXTI_SWIER_SWIER2_Msk                       /*!< Software Interrupt on line 2 */
#define EXTI_SWIER_SWIER3_Pos      (3U)                                        
#define EXTI_SWIER_SWIER3_Msk      (0x1U << EXTI_SWIER_SWIER3_Pos)             /*!< 0x00000008 */
#define EXTI_SWIER_SWIER3          EXTI_SWIER_SWIER3_Msk                       /*!< Software Interrupt on line 3 */
#define EXTI_SWIER_SWIER4_Pos      (4U)                                        
#define EXTI_SWIER_SWIER4_Msk      (0x1U << EXTI_SWIER_SWIER4_Pos)             /*!< 0x00000010 */
#define EXTI_SWIER_SWIER4          EXTI_SWIER_SWIER4_Msk                       /*!< Software Interrupt on line 4 */
#define EXTI_SWIER_SWIER5_Pos      (5U)                                        
#define EXTI_SWIER_SWIER5_Msk      (0x1U << EXTI_SWIER_SWIER5_Pos)             /*!< 0x00000020 */
#define EXTI_SWIER_SWIER5          EXTI_SWIER_SWIER5_Msk                       /*!< Software Interrupt on line 5 */
#define EXTI_SWIER_SWIER6_Pos      (6U)                                        
#define EXTI_SWIER_SWIER6_Msk      (0x1U << EXTI_SWIER_SWIER6_Pos)             /*!< 0x00000040 */
#define EXTI_SWIER_SWIER6          EXTI_SWIER_SWIER6_Msk                       /*!< Software Interrupt on line 6 */
#define EXTI_SWIER_SWIER7_Pos      (7U)                                        
#define EXTI_SWIER_SWIER7_Msk      (0x1U << EXTI_SWIER_SWIER7_Pos)             /*!< 0x00000080 */
#define EXTI_SWIER_SWIER7          EXTI_SWIER_SWIER7_Msk                       /*!< Software Interrupt on line 7 */
#define EXTI_SWIER_SWIER8_Pos      (8U)                                        
#define EXTI_SWIER_SWIER8_Msk      (0x1U << EXTI_SWIER_SWIER8_Pos)             /*!< 0x00000100 */
#define EXTI_SWIER_SWIER8          EXTI_SWIER_SWIER8_Msk                       /*!< Software Interrupt on line 8 */
#define EXTI_SWIER_SWIER9_Pos      (9U)                                        
#define EXTI_SWIER_SWIER9_Msk      (0x1U << EXTI_SWIER_SWIER9_Pos)             /*!< 0x00000200 */
#define EXTI_SWIER_SWIER9          EXTI_SWIER_SWIER9_Msk                       /*!< Software Interrupt on line 9 */
#define EXTI_SWIER_SWIER10_Pos     (10U)                                       
#define EXTI_SWIER_SWIER10_Msk     (0x1U << EXTI_SWIER_SWIER10_Pos)            /*!< 0x00000400 */
#define EXTI_SWIER_SWIER10         EXTI_SWIER_SWIER10_Msk                      /*!< Software Interrupt on line 10 */
#define EXTI_SWIER_SWIER11_Pos     (11U)                                       
#define EXTI_SWIER_SWIER11_Msk     (0x1U << EXTI_SWIER_SWIER11_Pos)            /*!< 0x00000800 */
#define EXTI_SWIER_SWIER11         EXTI_SWIER_SWIER11_Msk                      /*!< Software Interrupt on line 11 */
#define EXTI_SWIER_SWIER12_Pos     (12U)                                       
#define EXTI_SWIER_SWIER12_Msk     (0x1U << EXTI_SWIER_SWIER12_Pos)            /*!< 0x00001000 */
#define EXTI_SWIER_SWIER12         EXTI_SWIER_SWIER12_Msk                      /*!< Software Interrupt on line 12 */
#define EXTI_SWIER_SWIER13_Pos     (13U)                                       
#define EXTI_SWIER_SWIER13_Msk     (0x1U << EXTI_SWIER_SWIER13_Pos)            /*!< 0x00002000 */
#define EXTI_SWIER_SWIER13         EXTI_SWIER_SWIER13_Msk                      /*!< Software Interrupt on line 13 */
#define EXTI_SWIER_SWIER14_Pos     (14U)                                       
#define EXTI_SWIER_SWIER14_Msk     (0x1U << EXTI_SWIER_SWIER14_Pos)            /*!< 0x00004000 */
#define EXTI_SWIER_SWIER14         EXTI_SWIER_SWIER14_Msk                      /*!< Software Interrupt on line 14 */
#define EXTI_SWIER_SWIER15_Pos     (15U)                                       
#define EXTI_SWIER_SWIER15_Msk     (0x1U << EXTI_SWIER_SWIER15_Pos)            /*!< 0x00008000 */
#define EXTI_SWIER_SWIER15         EXTI_SWIER_SWIER15_Msk                      /*!< Software Interrupt on line 15 */
#define EXTI_SWIER_SWIER16_Pos     (16U)                                       
#define EXTI_SWIER_SWIER16_Msk     (0x1U << EXTI_SWIER_SWIER16_Pos)            /*!< 0x00010000 */
#define EXTI_SWIER_SWIER16         EXTI_SWIER_SWIER16_Msk                      /*!< Software Interrupt on line 16 */
#define EXTI_SWIER_SWIER17_Pos     (17U)                                       
#define EXTI_SWIER_SWIER17_Msk     (0x1U << EXTI_SWIER_SWIER17_Pos)            /*!< 0x00020000 */
#define EXTI_SWIER_SWIER17         EXTI_SWIER_SWIER17_Msk                      /*!< Software Interrupt on line 17 */
#define EXTI_SWIER_SWIER18_Pos     (18U)                                       
#define EXTI_SWIER_SWIER18_Msk     (0x1U << EXTI_SWIER_SWIER18_Pos)            /*!< 0x00040000 */
#define EXTI_SWIER_SWIER18         EXTI_SWIER_SWIER18_Msk                      /*!< Software Interrupt on line 18 */
#define EXTI_SWIER_SWIER19_Pos     (19U)                                       
#define EXTI_SWIER_SWIER19_Msk     (0x1U << EXTI_SWIER_SWIER19_Pos)            /*!< 0x00080000 */
#define EXTI_SWIER_SWIER19         EXTI_SWIER_SWIER19_Msk                      /*!< Software Interrupt on line 19 */
#define EXTI_SWIER_SWIER20_Pos     (20U)                                       
#define EXTI_SWIER_SWIER20_Msk     (0x1U << EXTI_SWIER_SWIER20_Pos)            /*!< 0x00100000 */
#define EXTI_SWIER_SWIER20         EXTI_SWIER_SWIER20_Msk                      /*!< Software Interrupt on line 20 */
#define EXTI_SWIER_SWIER21_Pos     (21U)                                       
#define EXTI_SWIER_SWIER21_Msk     (0x1U << EXTI_SWIER_SWIER21_Pos)            /*!< 0x00200000 */
#define EXTI_SWIER_SWIER21         EXTI_SWIER_SWIER21_Msk                      /*!< Software Interrupt on line 21 */
#define EXTI_SWIER_SWIER22_Pos     (22U)                                       
#define EXTI_SWIER_SWIER22_Msk     (0x1U << EXTI_SWIER_SWIER22_Pos)            /*!< 0x00400000 */
#define EXTI_SWIER_SWIER22         EXTI_SWIER_SWIER22_Msk                      /*!< Software Interrupt on line 22 */
#define EXTI_SWIER_SWIER29_Pos     (29U)                                       
#define EXTI_SWIER_SWIER29_Msk     (0x1U << EXTI_SWIER_SWIER29_Pos)            /*!< 0x20000000 */
#define EXTI_SWIER_SWIER29         EXTI_SWIER_SWIER29_Msk                      /*!< Software Interrupt on line 29 */
#define EXTI_SWIER_SWIER30_Pos     (30U)                                       
#define EXTI_SWIER_SWIER30_Msk     (0x1U << EXTI_SWIER_SWIER30_Pos)            /*!< 0x40000000 */
#define EXTI_SWIER_SWIER30         EXTI_SWIER_SWIER30_Msk                      /*!< Software Interrupt on line 30 */
#define EXTI_SWIER_SWIER31_Pos     (31U)                                       
#define EXTI_SWIER_SWIER31_Msk     (0x1U << EXTI_SWIER_SWIER31_Pos)            /*!< 0x80000000 */
#define EXTI_SWIER_SWIER31         EXTI_SWIER_SWIER31_Msk                      /*!< Software Interrupt on line 31 */

/* References Defines */
#define EXTI_SWIER_SWI0 EXTI_SWIER_SWIER0
#define EXTI_SWIER_SWI1 EXTI_SWIER_SWIER1
#define EXTI_SWIER_SWI2 EXTI_SWIER_SWIER2
#define EXTI_SWIER_SWI3 EXTI_SWIER_SWIER3
#define EXTI_SWIER_SWI4 EXTI_SWIER_SWIER4
#define EXTI_SWIER_SWI5 EXTI_SWIER_SWIER5
#define EXTI_SWIER_SWI6 EXTI_SWIER_SWIER6
#define EXTI_SWIER_SWI7 EXTI_SWIER_SWIER7
#define EXTI_SWIER_SWI8 EXTI_SWIER_SWIER8
#define EXTI_SWIER_SWI9 EXTI_SWIER_SWIER9
#define EXTI_SWIER_SWI10 EXTI_SWIER_SWIER10
#define EXTI_SWIER_SWI11 EXTI_SWIER_SWIER11
#define EXTI_SWIER_SWI12 EXTI_SWIER_SWIER12
#define EXTI_SWIER_SWI13 EXTI_SWIER_SWIER13
#define EXTI_SWIER_SWI14 EXTI_SWIER_SWIER14
#define EXTI_SWIER_SWI15 EXTI_SWIER_SWIER15
#define EXTI_SWIER_SWI16 EXTI_SWIER_SWIER16
#define EXTI_SWIER_SWI17 EXTI_SWIER_SWIER17
#define  EXTI_SWIER_SWI18 EXTI_SWIER_SWIER18
#define  EXTI_SWIER_SWI19 EXTI_SWIER_SWIER19
#define  EXTI_SWIER_SWI20 EXTI_SWIER_SWIER20
#define  EXTI_SWIER_SWI21 EXTI_SWIER_SWIER21
#define  EXTI_SWIER_SWI22 EXTI_SWIER_SWIER22
#define  EXTI_SWIER_SWI29 EXTI_SWIER_SWIER29
#define  EXTI_SWIER_SWI30 EXTI_SWIER_SWIER30
#define  EXTI_SWIER_SWI31 EXTI_SWIER_SWIER31

/*******************  Bit definition for EXTI_PR register  ********************/
#define EXTI_PR_PR0_Pos            (0U)                                        
#define EXTI_PR_PR0_Msk            (0x1U << EXTI_PR_PR0_Pos)                   /*!< 0x00000001 */
#define EXTI_PR_PR0                EXTI_PR_PR0_Msk                             /*!< Pending bit for line 0 */
#define EXTI_PR_PR1_Pos            (1U)                                        
#define EXTI_PR_PR1_Msk            (0x1U << EXTI_PR_PR1_Pos)                   /*!< 0x00000002 */
#define EXTI_PR_PR1                EXTI_PR_PR1_Msk                             /*!< Pending bit for line 1 */
#define EXTI_PR_PR2_Pos            (2U)                                        
#define EXTI_PR_PR2_Msk            (0x1U << EXTI_PR_PR2_Pos)                   /*!< 0x00000004 */
#define EXTI_PR_PR2                EXTI_PR_PR2_Msk                             /*!< Pending bit for line 2 */
#define EXTI_PR_PR3_Pos            (3U)                                        
#define EXTI_PR_PR3_Msk            (0x1U << EXTI_PR_PR3_Pos)                   /*!< 0x00000008 */
#define EXTI_PR_PR3                EXTI_PR_PR3_Msk                             /*!< Pending bit for line 3 */
#define EXTI_PR_PR4_Pos            (4U)                                        
#define EXTI_PR_PR4_Msk            (0x1U << EXTI_PR_PR4_Pos)                   /*!< 0x00000010 */
#define EXTI_PR_PR4                EXTI_PR_PR4_Msk                             /*!< Pending bit for line 4 */
#define EXTI_PR_PR5_Pos            (5U)                                        
#define EXTI_PR_PR5_Msk            (0x1U << EXTI_PR_PR5_Pos)                   /*!< 0x00000020 */
#define EXTI_PR_PR5                EXTI_PR_PR5_Msk                             /*!< Pending bit for line 5 */
#define EXTI_PR_PR6_Pos            (6U)                                        
#define EXTI_PR_PR6_Msk            (0x1U << EXTI_PR_PR6_Pos)                   /*!< 0x00000040 */
#define EXTI_PR_PR6                EXTI_PR_PR6_Msk                             /*!< Pending bit for line 6 */
#define EXTI_PR_PR7_Pos            (7U)                                        
#define EXTI_PR_PR7_Msk            (0x1U << EXTI_PR_PR7_Pos)                   /*!< 0x00000080 */
#define EXTI_PR_PR7                EXTI_PR_PR7_Msk                             /*!< Pending bit for line 7 */
#define EXTI_PR_PR8_Pos            (8U)                                        
#define EXTI_PR_PR8_Msk            (0x1U << EXTI_PR_PR8_Pos)                   /*!< 0x00000100 */
#define EXTI_PR_PR8                EXTI_PR_PR8_Msk                             /*!< Pending bit for line 8 */
#define EXTI_PR_PR9_Pos            (9U)                                        
#define EXTI_PR_PR9_Msk            (0x1U << EXTI_PR_PR9_Pos)                   /*!< 0x00000200 */
#define EXTI_PR_PR9                EXTI_PR_PR9_Msk                             /*!< Pending bit for line 9 */
#define EXTI_PR_PR10_Pos           (10U)                                       
#define EXTI_PR_PR10_Msk           (0x1U << EXTI_PR_PR10_Pos)                  /*!< 0x00000400 */
#define EXTI_PR_PR10               EXTI_PR_PR10_Msk                            /*!< Pending bit for line 10 */
#define EXTI_PR_PR11_Pos           (11U)                                       
#define EXTI_PR_PR11_Msk           (0x1U << EXTI_PR_PR11_Pos)                  /*!< 0x00000800 */
#define EXTI_PR_PR11               EXTI_PR_PR11_Msk                            /*!< Pending bit for line 11 */
#define EXTI_PR_PR12_Pos           (12U)                                       
#define EXTI_PR_PR12_Msk           (0x1U << EXTI_PR_PR12_Pos)                  /*!< 0x00001000 */
#define EXTI_PR_PR12               EXTI_PR_PR12_Msk                            /*!< Pending bit for line 12 */
#define EXTI_PR_PR13_Pos           (13U)                                       
#define EXTI_PR_PR13_Msk           (0x1U << EXTI_PR_PR13_Pos)                  /*!< 0x00002000 */
#define EXTI_PR_PR13               EXTI_PR_PR13_Msk                            /*!< Pending bit for line 13 */
#define EXTI_PR_PR14_Pos           (14U)                                       
#define EXTI_PR_PR14_Msk           (0x1U << EXTI_PR_PR14_Pos)                  /*!< 0x00004000 */
#define EXTI_PR_PR14               EXTI_PR_PR14_Msk                            /*!< Pending bit for line 14 */
#define EXTI_PR_PR15_Pos           (15U)                                       
#define EXTI_PR_PR15_Msk           (0x1U << EXTI_PR_PR15_Pos)                  /*!< 0x00008000 */
#define EXTI_PR_PR15               EXTI_PR_PR15_Msk                            /*!< Pending bit for line 15 */
#define EXTI_PR_PR16_Pos           (16U)                                       
#define EXTI_PR_PR16_Msk           (0x1U << EXTI_PR_PR16_Pos)                  /*!< 0x00010000 */
#define EXTI_PR_PR16               EXTI_PR_PR16_Msk                            /*!< Pending bit for line 16 */
#define EXTI_PR_PR17_Pos           (17U)                                       
#define EXTI_PR_PR17_Msk           (0x1U << EXTI_PR_PR17_Pos)                  /*!< 0x00020000 */
#define EXTI_PR_PR17               EXTI_PR_PR17_Msk                            /*!< Pending bit for line 17 */
#define EXTI_PR_PR18_Pos           (18U)                                       
#define EXTI_PR_PR18_Msk           (0x1U << EXTI_PR_PR18_Pos)                  /*!< 0x00040000 */
#define EXTI_PR_PR18               EXTI_PR_PR18_Msk                            /*!< Pending bit for line 18 */
#define EXTI_PR_PR19_Pos           (19U)                                       
#define EXTI_PR_PR19_Msk           (0x1U << EXTI_PR_PR19_Pos)                  /*!< 0x00080000 */
#define EXTI_PR_PR19               EXTI_PR_PR19_Msk                            /*!< Pending bit for line 19 */
#define EXTI_PR_PR20_Pos           (20U)                                       
#define EXTI_PR_PR20_Msk           (0x1U << EXTI_PR_PR20_Pos)                  /*!< 0x00100000 */
#define EXTI_PR_PR20               EXTI_PR_PR20_Msk                            /*!< Pending bit for line 20 */
#define EXTI_PR_PR21_Pos           (21U)                                       
#define EXTI_PR_PR21_Msk           (0x1U << EXTI_PR_PR21_Pos)                  /*!< 0x00200000 */
#define EXTI_PR_PR21               EXTI_PR_PR21_Msk                            /*!< Pending bit for line 21 */
#define EXTI_PR_PR22_Pos           (22U)                                       
#define EXTI_PR_PR22_Msk           (0x1U << EXTI_PR_PR22_Pos)                  /*!< 0x00400000 */
#define EXTI_PR_PR22               EXTI_PR_PR22_Msk                            /*!< Pending bit for line 22 */
#define EXTI_PR_PR29_Pos           (29U)                                       
#define EXTI_PR_PR29_Msk           (0x1U << EXTI_PR_PR29_Pos)                  /*!< 0x20000000 */
#define EXTI_PR_PR29               EXTI_PR_PR29_Msk                            /*!< Pending bit for line 29 */
#define EXTI_PR_PR30_Pos           (30U)                                       
#define EXTI_PR_PR30_Msk           (0x1U << EXTI_PR_PR30_Pos)                  /*!< 0x40000000 */
#define EXTI_PR_PR30               EXTI_PR_PR30_Msk                            /*!< Pending bit for line 30 */
#define EXTI_PR_PR31_Pos           (31U)                                       
#define EXTI_PR_PR31_Msk           (0x1U << EXTI_PR_PR31_Pos)                  /*!< 0x80000000 */
#define EXTI_PR_PR31               EXTI_PR_PR31_Msk                            /*!< Pending bit for line 31 */

/* References Defines */
#define EXTI_PR_PIF0 EXTI_PR_PR0
#define EXTI_PR_PIF1 EXTI_PR_PR1
#define EXTI_PR_PIF2 EXTI_PR_PR2
#define EXTI_PR_PIF3 EXTI_PR_PR3
#define EXTI_PR_PIF4 EXTI_PR_PR4
#define EXTI_PR_PIF5 EXTI_PR_PR5
#define EXTI_PR_PIF6 EXTI_PR_PR6
#define EXTI_PR_PIF7 EXTI_PR_PR7
#define EXTI_PR_PIF8 EXTI_PR_PR8
#define EXTI_PR_PIF9 EXTI_PR_PR9
#define EXTI_PR_PIF10 EXTI_PR_PR10
#define EXTI_PR_PIF11 EXTI_PR_PR11
#define EXTI_PR_PIF12 EXTI_PR_PR12
#define EXTI_PR_PIF13 EXTI_PR_PR13
#define EXTI_PR_PIF14 EXTI_PR_PR14
#define EXTI_PR_PIF15 EXTI_PR_PR15
#define EXTI_PR_PIF16 EXTI_PR_PR16
#define EXTI_PR_PIF17 EXTI_PR_PR17
#define  EXTI_PR_PIF18 EXTI_PR_PR18
#define  EXTI_PR_PIF19 EXTI_PR_PR19
#define  EXTI_PR_PIF20 EXTI_PR_PR20
#define  EXTI_PR_PIF21 EXTI_PR_PR21
#define  EXTI_PR_PIF22 EXTI_PR_PR22
#define  EXTI_PR_PIF29 EXTI_PR_PR29
#define  EXTI_PR_PIF30 EXTI_PR_PR30
#define  EXTI_PR_PIF31 EXTI_PR_PR31

#define EXTI_32_63_SUPPORT /* EXTI support more than 32 lines */

/*******************  Bit definition for EXTI_IMR2 register  ******************/
#define EXTI_IMR2_MR32_Pos         (0U)                                        
#define EXTI_IMR2_MR32_Msk         (0x1U << EXTI_IMR2_MR32_Pos)                /*!< 0x00000001 */
#define EXTI_IMR2_MR32             EXTI_IMR2_MR32_Msk                          /*!< Interrupt Mask on line 32 */
#define EXTI_IMR2_MR33_Pos         (1U)                                        
#define EXTI_IMR2_MR33_Msk         (0x1U << EXTI_IMR2_MR33_Pos)                /*!< 0x00000002 */
#define EXTI_IMR2_MR33             EXTI_IMR2_MR33_Msk                          /*!< Interrupt Mask on line 33 */
#define EXTI_IMR2_MR34_Pos         (2U)                                        
#define EXTI_IMR2_MR34_Msk         (0x1U << EXTI_IMR2_MR34_Pos)                /*!< 0x00000004 */
#define EXTI_IMR2_MR34             EXTI_IMR2_MR34_Msk                          /*!< Interrupt Mask on line 34 */
#define EXTI_IMR2_MR35_Pos         (3U)                                        
#define EXTI_IMR2_MR35_Msk         (0x1U << EXTI_IMR2_MR35_Pos)                /*!< 0x00000008 */
#define EXTI_IMR2_MR35             EXTI_IMR2_MR35_Msk                          /*!< Interrupt Mask on line 35 */

/* References Defines */
#define  EXTI_IMR2_IM32 EXTI_IMR2_MR32
#define  EXTI_IMR2_IM33 EXTI_IMR2_MR33
#define  EXTI_IMR2_IM34 EXTI_IMR2_MR34
#define  EXTI_IMR2_IM35 EXTI_IMR2_MR35

#define EXTI_IMR2_IM_Pos           (0U)                                        
#define EXTI_IMR2_IM_Msk           (0x1U << EXTI_IMR2_IM_Pos)                  /*!< 0x00000001 */
#define EXTI_IMR2_IM               EXTI_IMR2_IM_Msk                            

/*******************  Bit definition for EXTI_EMR2 ****************************/
#define EXTI_EMR2_MR32_Pos         (0U)                                        
#define EXTI_EMR2_MR32_Msk         (0x1U << EXTI_EMR2_MR32_Pos)                /*!< 0x00000001 */
#define EXTI_EMR2_MR32             EXTI_EMR2_MR32_Msk                          /*!< Event Mask on line 32 */
#define EXTI_EMR2_MR33_Pos         (1U)                                        
#define EXTI_EMR2_MR33_Msk         (0x1U << EXTI_EMR2_MR33_Pos)                /*!< 0x00000002 */
#define EXTI_EMR2_MR33             EXTI_EMR2_MR33_Msk                          /*!< Event Mask on line 33 */
#define EXTI_EMR2_MR34_Pos         (2U)                                        
#define EXTI_EMR2_MR34_Msk         (0x1U << EXTI_EMR2_MR34_Pos)                /*!< 0x00000004 */
#define EXTI_EMR2_MR34             EXTI_EMR2_MR34_Msk                          /*!< Event Mask on line 34 */
#define EXTI_EMR2_MR35_Pos         (3U)                                        
#define EXTI_EMR2_MR35_Msk         (0x1U << EXTI_EMR2_MR35_Pos)                /*!< 0x00000008 */
#define EXTI_EMR2_MR35             EXTI_EMR2_MR35_Msk                          /*!< Event Mask on line 34 */

/* References Defines */
#define  EXTI_EMR2_EM32 EXTI_EMR2_MR32
#define  EXTI_EMR2_EM33 EXTI_EMR2_MR33
#define  EXTI_EMR2_EM34 EXTI_EMR2_MR34
#define  EXTI_EMR2_EM35 EXTI_EMR2_MR35

/******************  Bit definition for EXTI_RTSR2 register ********************/
#define EXTI_RTSR2_TR32_Pos        (0U)                                        
#define EXTI_RTSR2_TR32_Msk        (0x1U << EXTI_RTSR2_TR32_Pos)               /*!< 0x00000001 */
#define EXTI_RTSR2_TR32            EXTI_RTSR2_TR32_Msk                         /*!< Rising trigger event configuration bit of line 32 */
#define EXTI_RTSR2_TR33_Pos        (1U)                                        
#define EXTI_RTSR2_TR33_Msk        (0x1U << EXTI_RTSR2_TR33_Pos)               /*!< 0x00000002 */
#define EXTI_RTSR2_TR33            EXTI_RTSR2_TR33_Msk                         /*!< Rising trigger event configuration bit of line 33 */

/* References Defines */
#define  EXTI_RTSR2_RT32 EXTI_RTSR2_TR32
#define  EXTI_RTSR2_RT33 EXTI_RTSR2_TR33

/******************  Bit definition for EXTI_FTSR2 register  ******************/
#define EXTI_FTSR2_TR32_Pos        (0U)                                        
#define EXTI_FTSR2_TR32_Msk        (0x1U << EXTI_FTSR2_TR32_Pos)               /*!< 0x00000001 */
#define EXTI_FTSR2_TR32            EXTI_FTSR2_TR32_Msk                         /*!< Falling trigger event configuration bit of line 32 */
#define EXTI_FTSR2_TR33_Pos        (1U)                                        
#define EXTI_FTSR2_TR33_Msk        (0x1U << EXTI_FTSR2_TR33_Pos)               /*!< 0x00000002 */
#define EXTI_FTSR2_TR33            EXTI_FTSR2_TR33_Msk                         /*!< Falling trigger event configuration bit of line 33 */

/* References Defines */
#define  EXTI_FTSR2_FT32 EXTI_FTSR2_TR32
#define  EXTI_FTSR2_FT33 EXTI_FTSR2_TR33

/******************  Bit definition for EXTI_SWIER2 register  *****************/
#define EXTI_SWIER2_SWIER32_Pos    (0U)                                        
#define EXTI_SWIER2_SWIER32_Msk    (0x1U << EXTI_SWIER2_SWIER32_Pos)           /*!< 0x00000001 */
#define EXTI_SWIER2_SWIER32        EXTI_SWIER2_SWIER32_Msk                     /*!< Software Interrupt on line 32 */
#define EXTI_SWIER2_SWIER33_Pos    (1U)                                        
#define EXTI_SWIER2_SWIER33_Msk    (0x1U << EXTI_SWIER2_SWIER33_Pos)           /*!< 0x00000002 */
#define EXTI_SWIER2_SWIER33        EXTI_SWIER2_SWIER33_Msk                     /*!< Software Interrupt on line 33 */

/* References Defines */
#define  EXTI_SWIER2_SWI32 EXTI_SWIER2_SWIER32
#define  EXTI_SWIER2_SWI33 EXTI_SWIER2_SWIER33

/*******************  Bit definition for EXTI_PR2 register  *******************/
#define EXTI_PR2_PR32_Pos          (0U)                                        
#define EXTI_PR2_PR32_Msk          (0x1U << EXTI_PR2_PR32_Pos)                 /*!< 0x00000001 */
#define EXTI_PR2_PR32              EXTI_PR2_PR32_Msk                           /*!< Pending bit for line 32 */
#define EXTI_PR2_PR33_Pos          (1U)                                        
#define EXTI_PR2_PR33_Msk          (0x1U << EXTI_PR2_PR33_Pos)                 /*!< 0x00000002 */
#define EXTI_PR2_PR33              EXTI_PR2_PR33_Msk                           /*!< Pending bit for line 33 */

/* References Defines */
#define  EXTI_PR2_PIF32 EXTI_PR2_PR32
#define  EXTI_PR2_PIF33 EXTI_PR2_PR33

/******************************************************************************/
/*                                                                            */
/*                                    FLASH                                   */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for FLASH_ACR register  ******************/
#define FLASH_ACR_LATENCY_Pos                (0U)                              
#define FLASH_ACR_LATENCY_Msk                (0x7U << FLASH_ACR_LATENCY_Pos)   /*!< 0x00000007 */
#define FLASH_ACR_LATENCY                    FLASH_ACR_LATENCY_Msk             /*!< LATENCY[2:0] bits (Latency) */
#define FLASH_ACR_LATENCY_0                  (0x1U << FLASH_ACR_LATENCY_Pos)   /*!< 0x00000001 */
#define FLASH_ACR_LATENCY_1                  (0x2U << FLASH_ACR_LATENCY_Pos)   /*!< 0x00000002 */
#define FLASH_ACR_LATENCY_2                  (0x4U << FLASH_ACR_LATENCY_Pos)   /*!< 0x00000004 */

#define FLASH_ACR_HLFCYA_Pos                 (3U)                              
#define FLASH_ACR_HLFCYA_Msk                 (0x1U << FLASH_ACR_HLFCYA_Pos)    /*!< 0x00000008 */
#define FLASH_ACR_HLFCYA                     FLASH_ACR_HLFCYA_Msk              /*!< Flash Half Cycle Access Enable */
#define FLASH_ACR_PRFTBE_Pos                 (4U)                              
#define FLASH_ACR_PRFTBE_Msk                 (0x1U << FLASH_ACR_PRFTBE_Pos)    /*!< 0x00000010 */
#define FLASH_ACR_PRFTBE                     FLASH_ACR_PRFTBE_Msk              /*!< Prefetch Buffer Enable */
#define FLASH_ACR_PRFTBS_Pos                 (5U)                              
#define FLASH_ACR_PRFTBS_Msk                 (0x1U << FLASH_ACR_PRFTBS_Pos)    /*!< 0x00000020 */
#define FLASH_ACR_PRFTBS                     FLASH_ACR_PRFTBS_Msk              /*!< Prefetch Buffer Status */

/******************  Bit definition for FLASH_KEYR register  ******************/
#define FLASH_KEYR_FKEYR_Pos                 (0U)                              
#define FLASH_KEYR_FKEYR_Msk                 (0xFFFFFFFFU << FLASH_KEYR_FKEYR_Pos) /*!< 0xFFFFFFFF */
#define FLASH_KEYR_FKEYR                     FLASH_KEYR_FKEYR_Msk              /*!< FPEC Key */

#define RDP_KEY_Pos    (0U)                                                    
#define RDP_KEY_Msk    (0xA5U << RDP_KEY_Pos)                                  /*!< 0x000000A5 */
#define RDP_KEY        RDP_KEY_Msk                                             /*!< RDP Key */
#define FLASH_KEY1_Pos                       (0U)                              
#define FLASH_KEY1_Msk                       (0x45670123U << FLASH_KEY1_Pos)   /*!< 0x45670123 */
#define FLASH_KEY1                           FLASH_KEY1_Msk                    /*!< FPEC Key1 */
#define FLASH_KEY2_Pos                       (0U)                              
#define FLASH_KEY2_Msk                       (0xCDEF89ABU << FLASH_KEY2_Pos)   /*!< 0xCDEF89AB */
#define FLASH_KEY2                           FLASH_KEY2_Msk                    /*!< FPEC Key2 */

/*****************  Bit definition for FLASH_OPTKEYR register  ****************/
#define FLASH_OPTKEYR_OPTKEYR_Pos            (0U)                              
#define FLASH_OPTKEYR_OPTKEYR_Msk            (0xFFFFFFFFU << FLASH_OPTKEYR_OPTKEYR_Pos) /*!< 0xFFFFFFFF */
#define FLASH_OPTKEYR_OPTKEYR                FLASH_OPTKEYR_OPTKEYR_Msk         /*!< Option Byte Key */

#define  FLASH_OPTKEY1                       FLASH_KEY1                    /*!< Option Byte Key1 */
#define  FLASH_OPTKEY2                       FLASH_KEY2                    /*!< Option Byte Key2 */

/******************  Bit definition for FLASH_SR register  *******************/
#define FLASH_SR_BSY_Pos                     (0U)                              
#define FLASH_SR_BSY_Msk                     (0x1U << FLASH_SR_BSY_Pos)        /*!< 0x00000001 */
#define FLASH_SR_BSY                         FLASH_SR_BSY_Msk                  /*!< Busy */
#define FLASH_SR_PGERR_Pos                   (2U)                              
#define FLASH_SR_PGERR_Msk                   (0x1U << FLASH_SR_PGERR_Pos)      /*!< 0x00000004 */
#define FLASH_SR_PGERR                       FLASH_SR_PGERR_Msk                /*!< Programming Error */
#define FLASH_SR_WRPERR_Pos                  (4U)                              
#define FLASH_SR_WRPERR_Msk                  (0x1U << FLASH_SR_WRPERR_Pos)     /*!< 0x00000010 */
#define FLASH_SR_WRPERR                      FLASH_SR_WRPERR_Msk               /*!< Write Protection Error */
#define FLASH_SR_EOP_Pos                     (5U)                              
#define FLASH_SR_EOP_Msk                     (0x1U << FLASH_SR_EOP_Pos)        /*!< 0x00000020 */
#define FLASH_SR_EOP                         FLASH_SR_EOP_Msk                  /*!< End of operation */

/*******************  Bit definition for FLASH_CR register  *******************/
#define FLASH_CR_PG_Pos                      (0U)                              
#define FLASH_CR_PG_Msk                      (0x1U << FLASH_CR_PG_Pos)         /*!< 0x00000001 */
#define FLASH_CR_PG                          FLASH_CR_PG_Msk                   /*!< Programming */
#define FLASH_CR_PER_Pos                     (1U)                              
#define FLASH_CR_PER_Msk                     (0x1U << FLASH_CR_PER_Pos)        /*!< 0x00000002 */
#define FLASH_CR_PER                         FLASH_CR_PER_Msk                  /*!< Page Erase */
#define FLASH_CR_MER_Pos                     (2U)                              
#define FLASH_CR_MER_Msk                     (0x1U << FLASH_CR_MER_Pos)        /*!< 0x00000004 */
#define FLASH_CR_MER                         FLASH_CR_MER_Msk                  /*!< Mass Erase */
#define FLASH_CR_OPTPG_Pos                   (4U)                              
#define FLASH_CR_OPTPG_Msk                   (0x1U << FLASH_CR_OPTPG_Pos)      /*!< 0x00000010 */
#define FLASH_CR_OPTPG                       FLASH_CR_OPTPG_Msk                /*!< Option Byte Programming */
#define FLASH_CR_OPTER_Pos                   (5U)                              
#define FLASH_CR_OPTER_Msk                   (0x1U << FLASH_CR_OPTER_Pos)      /*!< 0x00000020 */
#define FLASH_CR_OPTER                       FLASH_CR_OPTER_Msk                /*!< Option Byte Erase */
#define FLASH_CR_STRT_Pos                    (6U)                              
#define FLASH_CR_STRT_Msk                    (0x1U << FLASH_CR_STRT_Pos)       /*!< 0x00000040 */
#define FLASH_CR_STRT                        FLASH_CR_STRT_Msk                 /*!< Start */
#define FLASH_CR_LOCK_Pos                    (7U)                              
#define FLASH_CR_LOCK_Msk                    (0x1U << FLASH_CR_LOCK_Pos)       /*!< 0x00000080 */
#define FLASH_CR_LOCK                        FLASH_CR_LOCK_Msk                 /*!< Lock */
#define FLASH_CR_OPTWRE_Pos                  (9U)                              
#define FLASH_CR_OPTWRE_Msk                  (0x1U << FLASH_CR_OPTWRE_Pos)     /*!< 0x00000200 */
#define FLASH_CR_OPTWRE                      FLASH_CR_OPTWRE_Msk               /*!< Option Bytes Write Enable */
#define FLASH_CR_ERRIE_Pos                   (10U)                             
#define FLASH_CR_ERRIE_Msk                   (0x1U << FLASH_CR_ERRIE_Pos)      /*!< 0x00000400 */
#define FLASH_CR_ERRIE                       FLASH_CR_ERRIE_Msk                /*!< Error Interrupt Enable */
#define FLASH_CR_EOPIE_Pos                   (12U)                             
#define FLASH_CR_EOPIE_Msk                   (0x1U << FLASH_CR_EOPIE_Pos)      /*!< 0x00001000 */
#define FLASH_CR_EOPIE                       FLASH_CR_EOPIE_Msk                /*!< End of operation interrupt enable */
#define FLASH_CR_OBL_LAUNCH_Pos              (13U)                             
#define FLASH_CR_OBL_LAUNCH_Msk              (0x1U << FLASH_CR_OBL_LAUNCH_Pos) /*!< 0x00002000 */
#define FLASH_CR_OBL_LAUNCH                  FLASH_CR_OBL_LAUNCH_Msk           /*!< OptionBytes Loader Launch */

/*******************  Bit definition for FLASH_AR register  *******************/
#define FLASH_AR_FAR_Pos                     (0U)                              
#define FLASH_AR_FAR_Msk                     (0xFFFFFFFFU << FLASH_AR_FAR_Pos) /*!< 0xFFFFFFFF */
#define FLASH_AR_FAR                         FLASH_AR_FAR_Msk                  /*!< Flash Address */

/******************  Bit definition for FLASH_OBR register  *******************/
#define FLASH_OBR_OPTERR_Pos                 (0U)                              
#define FLASH_OBR_OPTERR_Msk                 (0x1U << FLASH_OBR_OPTERR_Pos)    /*!< 0x00000001 */
#define FLASH_OBR_OPTERR                     FLASH_OBR_OPTERR_Msk              /*!< Option Byte Error */
#define FLASH_OBR_RDPRT_Pos                  (1U)                              
#define FLASH_OBR_RDPRT_Msk                  (0x3U << FLASH_OBR_RDPRT_Pos)     /*!< 0x00000006 */
#define FLASH_OBR_RDPRT                      FLASH_OBR_RDPRT_Msk               /*!< Read protection */
#define FLASH_OBR_RDPRT_1                    (0x1U << FLASH_OBR_RDPRT_Pos)     /*!< 0x00000002 */
#define FLASH_OBR_RDPRT_2                    (0x3U << FLASH_OBR_RDPRT_Pos)     /*!< 0x00000006 */

#define FLASH_OBR_USER_Pos                   (8U)                              
#define FLASH_OBR_USER_Msk                   (0x77U << FLASH_OBR_USER_Pos)     /*!< 0x00007700 */
#define FLASH_OBR_USER                       FLASH_OBR_USER_Msk                /*!< User Option Bytes */
#define FLASH_OBR_IWDG_SW_Pos                (8U)                              
#define FLASH_OBR_IWDG_SW_Msk                (0x1U << FLASH_OBR_IWDG_SW_Pos)   /*!< 0x00000100 */
#define FLASH_OBR_IWDG_SW                    FLASH_OBR_IWDG_SW_Msk             /*!< IWDG SW */
#define FLASH_OBR_nRST_STOP_Pos              (9U)                              
#define FLASH_OBR_nRST_STOP_Msk              (0x1U << FLASH_OBR_nRST_STOP_Pos) /*!< 0x00000200 */
#define FLASH_OBR_nRST_STOP                  FLASH_OBR_nRST_STOP_Msk           /*!< nRST_STOP */
#define FLASH_OBR_nRST_STDBY_Pos             (10U)                             
#define FLASH_OBR_nRST_STDBY_Msk             (0x1U << FLASH_OBR_nRST_STDBY_Pos) /*!< 0x00000400 */
#define FLASH_OBR_nRST_STDBY                 FLASH_OBR_nRST_STDBY_Msk          /*!< nRST_STDBY */
#define FLASH_OBR_nBOOT1_Pos                 (12U)                             
#define FLASH_OBR_nBOOT1_Msk                 (0x1U << FLASH_OBR_nBOOT1_Pos)    /*!< 0x00001000 */
#define FLASH_OBR_nBOOT1                     FLASH_OBR_nBOOT1_Msk              /*!< nBOOT1 */
#define FLASH_OBR_VDDA_MONITOR_Pos           (13U)                             
#define FLASH_OBR_VDDA_MONITOR_Msk           (0x1U << FLASH_OBR_VDDA_MONITOR_Pos) /*!< 0x00002000 */
#define FLASH_OBR_VDDA_MONITOR               FLASH_OBR_VDDA_MONITOR_Msk        /*!< VDDA_MONITOR */
#define FLASH_OBR_SRAM_PE_Pos                (14U)                             
#define FLASH_OBR_SRAM_PE_Msk                (0x1U << FLASH_OBR_SRAM_PE_Pos)   /*!< 0x00004000 */
#define FLASH_OBR_SRAM_PE                    FLASH_OBR_SRAM_PE_Msk             /*!< SRAM_PE */
#define FLASH_OBR_DATA0_Pos                  (16U)                             
#define FLASH_OBR_DATA0_Msk                  (0xFFU << FLASH_OBR_DATA0_Pos)    /*!< 0x00FF0000 */
#define FLASH_OBR_DATA0                      FLASH_OBR_DATA0_Msk               /*!< Data0 */
#define FLASH_OBR_DATA1_Pos                  (24U)                             
#define FLASH_OBR_DATA1_Msk                  (0xFFU << FLASH_OBR_DATA1_Pos)    /*!< 0xFF000000 */
#define FLASH_OBR_DATA1                      FLASH_OBR_DATA1_Msk               /*!< Data1 */

/* Legacy defines */
#define FLASH_OBR_WDG_SW FLASH_OBR_IWDG_SW

/******************  Bit definition for FLASH_WRPR register  ******************/
#define FLASH_WRPR_WRP_Pos                   (0U)                              
#define FLASH_WRPR_WRP_Msk                   (0xFFFFFFFFU << FLASH_WRPR_WRP_Pos) /*!< 0xFFFFFFFF */
#define FLASH_WRPR_WRP                       FLASH_WRPR_WRP_Msk                /*!< Write Protect */

/*----------------------------------------------------------------------------*/

/******************  Bit definition for OB_RDP register  **********************/
#define OB_RDP_RDP_Pos       (0U)                                              
#define OB_RDP_RDP_Msk       (0xFFU << OB_RDP_RDP_Pos)                         /*!< 0x000000FF */
#define OB_RDP_RDP           OB_RDP_RDP_Msk                                    /*!< Read protection option byte */
#define OB_RDP_nRDP_Pos      (8U)                                              
#define OB_RDP_nRDP_Msk      (0xFFU << OB_RDP_nRDP_Pos)                        /*!< 0x0000FF00 */
#define OB_RDP_nRDP          OB_RDP_nRDP_Msk                                   /*!< Read protection complemented option byte */

/******************  Bit definition for OB_USER register  *********************/
#define OB_USER_USER_Pos     (16U)                                             
#define OB_USER_USER_Msk     (0xFFU << OB_USER_USER_Pos)                       /*!< 0x00FF0000 */
#define OB_USER_USER         OB_USER_USER_Msk                                  /*!< User option byte */
#define OB_USER_nUSER_Pos    (24U)                                             
#define OB_USER_nUSER_Msk    (0xFFU << OB_USER_nUSER_Pos)                      /*!< 0xFF000000 */
#define OB_USER_nUSER        OB_USER_nUSER_Msk                                 /*!< User complemented option byte */

/******************  Bit definition for FLASH_WRP0 register  ******************/
#define OB_WRP0_WRP0_Pos     (0U)                                              
#define OB_WRP0_WRP0_Msk     (0xFFU << OB_WRP0_WRP0_Pos)                       /*!< 0x000000FF */
#define OB_WRP0_WRP0         OB_WRP0_WRP0_Msk                                  /*!< Flash memory write protection option bytes */
#define OB_WRP0_nWRP0_Pos    (8U)                                              
#define OB_WRP0_nWRP0_Msk    (0xFFU << OB_WRP0_nWRP0_Pos)                      /*!< 0x0000FF00 */
#define OB_WRP0_nWRP0        OB_WRP0_nWRP0_Msk                                 /*!< Flash memory write protection complemented option bytes */

/******************  Bit definition for FLASH_WRP1 register  ******************/
#define OB_WRP1_WRP1_Pos     (16U)                                             
#define OB_WRP1_WRP1_Msk     (0xFFU << OB_WRP1_WRP1_Pos)                       /*!< 0x00FF0000 */
#define OB_WRP1_WRP1         OB_WRP1_WRP1_Msk                                  /*!< Flash memory write protection option bytes */
#define OB_WRP1_nWRP1_Pos    (24U)                                             
#define OB_WRP1_nWRP1_Msk    (0xFFU << OB_WRP1_nWRP1_Pos)                      /*!< 0xFF000000 */
#define OB_WRP1_nWRP1        OB_WRP1_nWRP1_Msk                                 /*!< Flash memory write protection complemented option bytes */

/******************  Bit definition for FLASH_WRP2 register  ******************/
#define OB_WRP2_WRP2_Pos     (0U)                                              
#define OB_WRP2_WRP2_Msk     (0xFFU << OB_WRP2_WRP2_Pos)                       /*!< 0x000000FF */
#define OB_WRP2_WRP2         OB_WRP2_WRP2_Msk                                  /*!< Flash memory write protection option bytes */
#define OB_WRP2_nWRP2_Pos    (8U)                                              
#define OB_WRP2_nWRP2_Msk    (0xFFU << OB_WRP2_nWRP2_Pos)                      /*!< 0x0000FF00 */
#define OB_WRP2_nWRP2        OB_WRP2_nWRP2_Msk                                 /*!< Flash memory write protection complemented option bytes */

/******************  Bit definition for FLASH_WRP3 register  ******************/
#define OB_WRP3_WRP3_Pos     (16U)                                             
#define OB_WRP3_WRP3_Msk     (0xFFU << OB_WRP3_WRP3_Pos)                       /*!< 0x00FF0000 */
#define OB_WRP3_WRP3         OB_WRP3_WRP3_Msk                                  /*!< Flash memory write protection option bytes */
#define OB_WRP3_nWRP3_Pos    (24U)                                             
#define OB_WRP3_nWRP3_Msk    (0xFFU << OB_WRP3_nWRP3_Pos)                      /*!< 0xFF000000 */
#define OB_WRP3_nWRP3        OB_WRP3_nWRP3_Msk                                 /*!< Flash memory write protection complemented option bytes */

/******************************************************************************/
/*                                                                            */
/*                            General Purpose I/O (GPIO)                      */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for GPIO_MODER register  *****************/
#define GPIO_MODER_MODER0_Pos            (0U)                                  
#define GPIO_MODER_MODER0_Msk            (0x3U << GPIO_MODER_MODER0_Pos)       /*!< 0x00000003 */
#define GPIO_MODER_MODER0                GPIO_MODER_MODER0_Msk                 
#define GPIO_MODER_MODER0_0              (0x1U << GPIO_MODER_MODER0_Pos)       /*!< 0x00000001 */
#define GPIO_MODER_MODER0_1              (0x2U << GPIO_MODER_MODER0_Pos)       /*!< 0x00000002 */
#define GPIO_MODER_MODER1_Pos            (2U)                                  
#define GPIO_MODER_MODER1_Msk            (0x3U << GPIO_MODER_MODER1_Pos)       /*!< 0x0000000C */
#define GPIO_MODER_MODER1                GPIO_MODER_MODER1_Msk                 
#define GPIO_MODER_MODER1_0              (0x1U << GPIO_MODER_MODER1_Pos)       /*!< 0x00000004 */
#define GPIO_MODER_MODER1_1              (0x2U << GPIO_MODER_MODER1_Pos)       /*!< 0x00000008 */
#define GPIO_MODER_MODER2_Pos            (4U)                                  
#define GPIO_MODER_MODER2_Msk            (0x3U << GPIO_MODER_MODER2_Pos)       /*!< 0x00000030 */
#define GPIO_MODER_MODER2                GPIO_MODER_MODER2_Msk                 
#define GPIO_MODER_MODER2_0              (0x1U << GPIO_MODER_MODER2_Pos)       /*!< 0x00000010 */
#define GPIO_MODER_MODER2_1              (0x2U << GPIO_MODER_MODER2_Pos)       /*!< 0x00000020 */
#define GPIO_MODER_MODER3_Pos            (6U)                                  
#define GPIO_MODER_MODER3_Msk            (0x3U << GPIO_MODER_MODER3_Pos)       /*!< 0x000000C0 */
#define GPIO_MODER_MODER3                GPIO_MODER_MODER3_Msk                 
#define GPIO_MODER_MODER3_0              (0x1U << GPIO_MODER_MODER3_Pos)       /*!< 0x00000040 */
#define GPIO_MODER_MODER3_1              (0x2U << GPIO_MODER_MODER3_Pos)       /*!< 0x00000080 */
#define GPIO_MODER_MODER4_Pos            (8U)                                  
#define GPIO_MODER_MODER4_Msk            (0x3U << GPIO_MODER_MODER4_Pos)       /*!< 0x00000300 */
#define GPIO_MODER_MODER4                GPIO_MODER_MODER4_Msk                 
#define GPIO_MODER_MODER4_0              (0x1U << GPIO_MODER_MODER4_Pos)       /*!< 0x00000100 */
#define GPIO_MODER_MODER4_1              (0x2U << GPIO_MODER_MODER4_Pos)       /*!< 0x00000200 */
#define GPIO_MODER_MODER5_Pos            (10U)                                 
#define GPIO_MODER_MODER5_Msk            (0x3U << GPIO_MODER_MODER5_Pos)       /*!< 0x00000C00 */
#define GPIO_MODER_MODER5                GPIO_MODER_MODER5_Msk                 
#define GPIO_MODER_MODER5_0              (0x1U << GPIO_MODER_MODER5_Pos)       /*!< 0x00000400 */
#define GPIO_MODER_MODER5_1              (0x2U << GPIO_MODER_MODER5_Pos)       /*!< 0x00000800 */
#define GPIO_MODER_MODER6_Pos            (12U)                                 
#define GPIO_MODER_MODER6_Msk            (0x3U << GPIO_MODER_MODER6_Pos)       /*!< 0x00003000 */
#define GPIO_MODER_MODER6                GPIO_MODER_MODER6_Msk                 
#define GPIO_MODER_MODER6_0              (0x1U << GPIO_MODER_MODER6_Pos)       /*!< 0x00001000 */
#define GPIO_MODER_MODER6_1              (0x2U << GPIO_MODER_MODER6_Pos)       /*!< 0x00002000 */
#define GPIO_MODER_MODER7_Pos            (14U)                                 
#define GPIO_MODER_MODER7_Msk            (0x3U << GPIO_MODER_MODER7_Pos)       /*!< 0x0000C000 */
#define GPIO_MODER_MODER7                GPIO_MODER_MODER7_Msk                 
#define GPIO_MODER_MODER7_0              (0x1U << GPIO_MODER_MODER7_Pos)       /*!< 0x00004000 */
#define GPIO_MODER_MODER7_1              (0x2U << GPIO_MODER_MODER7_Pos)       /*!< 0x00008000 */
#define GPIO_MODER_MODER8_Pos            (16U)                                 
#define GPIO_MODER_MODER8_Msk            (0x3U << GPIO_MODER_MODER8_Pos)       /*!< 0x00030000 */
#define GPIO_MODER_MODER8                GPIO_MODER_MODER8_Msk                 
#define GPIO_MODER_MODER8_0              (0x1U << GPIO_MODER_MODER8_Pos)       /*!< 0x00010000 */
#define GPIO_MODER_MODER8_1              (0x2U << GPIO_MODER_MODER8_Pos)       /*!< 0x00020000 */
#define GPIO_MODER_MODER9_Pos            (18U)                                 
#define GPIO_MODER_MODER9_Msk            (0x3U << GPIO_MODER_MODER9_Pos)       /*!< 0x000C0000 */
#define GPIO_MODER_MODER9                GPIO_MODER_MODER9_Msk                 
#define GPIO_MODER_MODER9_0              (0x1U << GPIO_MODER_MODER9_Pos)       /*!< 0x00040000 */
#define GPIO_MODER_MODER9_1              (0x2U << GPIO_MODER_MODER9_Pos)       /*!< 0x00080000 */
#define GPIO_MODER_MODER10_Pos           (20U)                                 
#define GPIO_MODER_MODER10_Msk           (0x3U << GPIO_MODER_MODER10_Pos)      /*!< 0x00300000 */
#define GPIO_MODER_MODER10               GPIO_MODER_MODER10_Msk                
#define GPIO_MODER_MODER10_0             (0x1U << GPIO_MODER_MODER10_Pos)      /*!< 0x00100000 */
#define GPIO_MODER_MODER10_1             (0x2U << GPIO_MODER_MODER10_Pos)      /*!< 0x00200000 */
#define GPIO_MODER_MODER11_Pos           (22U)                                 
#define GPIO_MODER_MODER11_Msk           (0x3U << GPIO_MODER_MODER11_Pos)      /*!< 0x00C00000 */
#define GPIO_MODER_MODER11               GPIO_MODER_MODER11_Msk                
#define GPIO_MODER_MODER11_0             (0x1U << GPIO_MODER_MODER11_Pos)      /*!< 0x00400000 */
#define GPIO_MODER_MODER11_1             (0x2U << GPIO_MODER_MODER11_Pos)      /*!< 0x00800000 */
#define GPIO_MODER_MODER12_Pos           (24U)                                 
#define GPIO_MODER_MODER12_Msk           (0x3U << GPIO_MODER_MODER12_Pos)      /*!< 0x03000000 */
#define GPIO_MODER_MODER12               GPIO_MODER_MODER12_Msk                
#define GPIO_MODER_MODER12_0             (0x1U << GPIO_MODER_MODER12_Pos)      /*!< 0x01000000 */
#define GPIO_MODER_MODER12_1             (0x2U << GPIO_MODER_MODER12_Pos)      /*!< 0x02000000 */
#define GPIO_MODER_MODER13_Pos           (26U)                                 
#define GPIO_MODER_MODER13_Msk           (0x3U << GPIO_MODER_MODER13_Pos)      /*!< 0x0C000000 */
#define GPIO_MODER_MODER13               GPIO_MODER_MODER13_Msk                
#define GPIO_MODER_MODER13_0             (0x1U << GPIO_MODER_MODER13_Pos)      /*!< 0x04000000 */
#define GPIO_MODER_MODER13_1             (0x2U << GPIO_MODER_MODER13_Pos)      /*!< 0x08000000 */
#define GPIO_MODER_MODER14_Pos           (28U)                                 
#define GPIO_MODER_MODER14_Msk           (0x3U << GPIO_MODER_MODER14_Pos)      /*!< 0x30000000 */
#define GPIO_MODER_MODER14               GPIO_MODER_MODER14_Msk                
#define GPIO_MODER_MODER14_0             (0x1U << GPIO_MODER_MODER14_Pos)      /*!< 0x10000000 */
#define GPIO_MODER_MODER14_1             (0x2U << GPIO_MODER_MODER14_Pos)      /*!< 0x20000000 */
#define GPIO_MODER_MODER15_Pos           (30U)                                 
#define GPIO_MODER_MODER15_Msk           (0x3U << GPIO_MODER_MODER15_Pos)      /*!< 0xC0000000 */
#define GPIO_MODER_MODER15               GPIO_MODER_MODER15_Msk                
#define GPIO_MODER_MODER15_0             (0x1U << GPIO_MODER_MODER15_Pos)      /*!< 0x40000000 */
#define GPIO_MODER_MODER15_1             (0x2U << GPIO_MODER_MODER15_Pos)      /*!< 0x80000000 */

/******************  Bit definition for GPIO_OTYPER register  *****************/
#define GPIO_OTYPER_OT_0                 (0x00000001U)                         
#define GPIO_OTYPER_OT_1                 (0x00000002U)                         
#define GPIO_OTYPER_OT_2                 (0x00000004U)                         
#define GPIO_OTYPER_OT_3                 (0x00000008U)                         
#define GPIO_OTYPER_OT_4                 (0x00000010U)                         
#define GPIO_OTYPER_OT_5                 (0x00000020U)                         
#define GPIO_OTYPER_OT_6                 (0x00000040U)                         
#define GPIO_OTYPER_OT_7                 (0x00000080U)                         
#define GPIO_OTYPER_OT_8                 (0x00000100U)                         
#define GPIO_OTYPER_OT_9                 (0x00000200U)                         
#define GPIO_OTYPER_OT_10                (0x00000400U)                         
#define GPIO_OTYPER_OT_11                (0x00000800U)                         
#define GPIO_OTYPER_OT_12                (0x00001000U)                         
#define GPIO_OTYPER_OT_13                (0x00002000U)                         
#define GPIO_OTYPER_OT_14                (0x00004000U)                         
#define GPIO_OTYPER_OT_15                (0x00008000U)                         

/****************  Bit definition for GPIO_OSPEEDR register  ******************/
#define GPIO_OSPEEDER_OSPEEDR0_Pos       (0U)                                  
#define GPIO_OSPEEDER_OSPEEDR0_Msk       (0x3U << GPIO_OSPEEDER_OSPEEDR0_Pos)  /*!< 0x00000003 */
#define GPIO_OSPEEDER_OSPEEDR0           GPIO_OSPEEDER_OSPEEDR0_Msk            
#define GPIO_OSPEEDER_OSPEEDR0_0         (0x1U << GPIO_OSPEEDER_OSPEEDR0_Pos)  /*!< 0x00000001 */
#define GPIO_OSPEEDER_OSPEEDR0_1         (0x2U << GPIO_OSPEEDER_OSPEEDR0_Pos)  /*!< 0x00000002 */
#define GPIO_OSPEEDER_OSPEEDR1_Pos       (2U)                                  
#define GPIO_OSPEEDER_OSPEEDR1_Msk       (0x3U << GPIO_OSPEEDER_OSPEEDR1_Pos)  /*!< 0x0000000C */
#define GPIO_OSPEEDER_OSPEEDR1           GPIO_OSPEEDER_OSPEEDR1_Msk            
#define GPIO_OSPEEDER_OSPEEDR1_0         (0x1U << GPIO_OSPEEDER_OSPEEDR1_Pos)  /*!< 0x00000004 */
#define GPIO_OSPEEDER_OSPEEDR1_1         (0x2U << GPIO_OSPEEDER_OSPEEDR1_Pos)  /*!< 0x00000008 */
#define GPIO_OSPEEDER_OSPEEDR2_Pos       (4U)                                  
#define GPIO_OSPEEDER_OSPEEDR2_Msk       (0x3U << GPIO_OSPEEDER_OSPEEDR2_Pos)  /*!< 0x00000030 */
#define GPIO_OSPEEDER_OSPEEDR2           GPIO_OSPEEDER_OSPEEDR2_Msk            
#define GPIO_OSPEEDER_OSPEEDR2_0         (0x1U << GPIO_OSPEEDER_OSPEEDR2_Pos)  /*!< 0x00000010 */
#define GPIO_OSPEEDER_OSPEEDR2_1         (0x2U << GPIO_OSPEEDER_OSPEEDR2_Pos)  /*!< 0x00000020 */
#define GPIO_OSPEEDER_OSPEEDR3_Pos       (6U)                                  
#define GPIO_OSPEEDER_OSPEEDR3_Msk       (0x3U << GPIO_OSPEEDER_OSPEEDR3_Pos)  /*!< 0x000000C0 */
#define GPIO_OSPEEDER_OSPEEDR3           GPIO_OSPEEDER_OSPEEDR3_Msk            
#define GPIO_OSPEEDER_OSPEEDR3_0         (0x1U << GPIO_OSPEEDER_OSPEEDR3_Pos)  /*!< 0x00000040 */
#define GPIO_OSPEEDER_OSPEEDR3_1         (0x2U << GPIO_OSPEEDER_OSPEEDR3_Pos)  /*!< 0x00000080 */
#define GPIO_OSPEEDER_OSPEEDR4_Pos       (8U)                                  
#define GPIO_OSPEEDER_OSPEEDR4_Msk       (0x3U << GPIO_OSPEEDER_OSPEEDR4_Pos)  /*!< 0x00000300 */
#define GPIO_OSPEEDER_OSPEEDR4           GPIO_OSPEEDER_OSPEEDR4_Msk            
#define GPIO_OSPEEDER_OSPEEDR4_0         (0x1U << GPIO_OSPEEDER_OSPEEDR4_Pos)  /*!< 0x00000100 */
#define GPIO_OSPEEDER_OSPEEDR4_1         (0x2U << GPIO_OSPEEDER_OSPEEDR4_Pos)  /*!< 0x00000200 */
#define GPIO_OSPEEDER_OSPEEDR5_Pos       (10U)                                 
#define GPIO_OSPEEDER_OSPEEDR5_Msk       (0x3U << GPIO_OSPEEDER_OSPEEDR5_Pos)  /*!< 0x00000C00 */
#define GPIO_OSPEEDER_OSPEEDR5           GPIO_OSPEEDER_OSPEEDR5_Msk            
#define GPIO_OSPEEDER_OSPEEDR5_0         (0x1U << GPIO_OSPEEDER_OSPEEDR5_Pos)  /*!< 0x00000400 */
#define GPIO_OSPEEDER_OSPEEDR5_1         (0x2U << GPIO_OSPEEDER_OSPEEDR5_Pos)  /*!< 0x00000800 */
#define GPIO_OSPEEDER_OSPEEDR6_Pos       (12U)                                 
#define GPIO_OSPEEDER_OSPEEDR6_Msk       (0x3U << GPIO_OSPEEDER_OSPEEDR6_Pos)  /*!< 0x00003000 */
#define GPIO_OSPEEDER_OSPEEDR6           GPIO_OSPEEDER_OSPEEDR6_Msk            
#define GPIO_OSPEEDER_OSPEEDR6_0         (0x1U << GPIO_OSPEEDER_OSPEEDR6_Pos)  /*!< 0x00001000 */
#define GPIO_OSPEEDER_OSPEEDR6_1         (0x2U << GPIO_OSPEEDER_OSPEEDR6_Pos)  /*!< 0x00002000 */
#define GPIO_OSPEEDER_OSPEEDR7_Pos       (14U)                                 
#define GPIO_OSPEEDER_OSPEEDR7_Msk       (0x3U << GPIO_OSPEEDER_OSPEEDR7_Pos)  /*!< 0x0000C000 */
#define GPIO_OSPEEDER_OSPEEDR7           GPIO_OSPEEDER_OSPEEDR7_Msk            
#define GPIO_OSPEEDER_OSPEEDR7_0         (0x1U << GPIO_OSPEEDER_OSPEEDR7_Pos)  /*!< 0x00004000 */
#define GPIO_OSPEEDER_OSPEEDR7_1         (0x2U << GPIO_OSPEEDER_OSPEEDR7_Pos)  /*!< 0x00008000 */
#define GPIO_OSPEEDER_OSPEEDR8_Pos       (16U)                                 
#define GPIO_OSPEEDER_OSPEEDR8_Msk       (0x3U << GPIO_OSPEEDER_OSPEEDR8_Pos)  /*!< 0x00030000 */
#define GPIO_OSPEEDER_OSPEEDR8           GPIO_OSPEEDER_OSPEEDR8_Msk            
#define GPIO_OSPEEDER_OSPEEDR8_0         (0x1U << GPIO_OSPEEDER_OSPEEDR8_Pos)  /*!< 0x00010000 */
#define GPIO_OSPEEDER_OSPEEDR8_1         (0x2U << GPIO_OSPEEDER_OSPEEDR8_Pos)  /*!< 0x00020000 */
#define GPIO_OSPEEDER_OSPEEDR9_Pos       (18U)                                 
#define GPIO_OSPEEDER_OSPEEDR9_Msk       (0x3U << GPIO_OSPEEDER_OSPEEDR9_Pos)  /*!< 0x000C0000 */
#define GPIO_OSPEEDER_OSPEEDR9           GPIO_OSPEEDER_OSPEEDR9_Msk            
#define GPIO_OSPEEDER_OSPEEDR9_0         (0x1U << GPIO_OSPEEDER_OSPEEDR9_Pos)  /*!< 0x00040000 */
#define GPIO_OSPEEDER_OSPEEDR9_1         (0x2U << GPIO_OSPEEDER_OSPEEDR9_Pos)  /*!< 0x00080000 */
#define GPIO_OSPEEDER_OSPEEDR10_Pos      (20U)                                 
#define GPIO_OSPEEDER_OSPEEDR10_Msk      (0x3U << GPIO_OSPEEDER_OSPEEDR10_Pos) /*!< 0x00300000 */
#define GPIO_OSPEEDER_OSPEEDR10          GPIO_OSPEEDER_OSPEEDR10_Msk           
#define GPIO_OSPEEDER_OSPEEDR10_0        (0x1U << GPIO_OSPEEDER_OSPEEDR10_Pos) /*!< 0x00100000 */
#define GPIO_OSPEEDER_OSPEEDR10_1        (0x2U << GPIO_OSPEEDER_OSPEEDR10_Pos) /*!< 0x00200000 */
#define GPIO_OSPEEDER_OSPEEDR11_Pos      (22U)                                 
#define GPIO_OSPEEDER_OSPEEDR11_Msk      (0x3U << GPIO_OSPEEDER_OSPEEDR11_Pos) /*!< 0x00C00000 */
#define GPIO_OSPEEDER_OSPEEDR11          GPIO_OSPEEDER_OSPEEDR11_Msk           
#define GPIO_OSPEEDER_OSPEEDR11_0        (0x1U << GPIO_OSPEEDER_OSPEEDR11_Pos) /*!< 0x00400000 */
#define GPIO_OSPEEDER_OSPEEDR11_1        (0x2U << GPIO_OSPEEDER_OSPEEDR11_Pos) /*!< 0x00800000 */
#define GPIO_OSPEEDER_OSPEEDR12_Pos      (24U)                                 
#define GPIO_OSPEEDER_OSPEEDR12_Msk      (0x3U << GPIO_OSPEEDER_OSPEEDR12_Pos) /*!< 0x03000000 */
#define GPIO_OSPEEDER_OSPEEDR12          GPIO_OSPEEDER_OSPEEDR12_Msk           
#define GPIO_OSPEEDER_OSPEEDR12_0        (0x1U << GPIO_OSPEEDER_OSPEEDR12_Pos) /*!< 0x01000000 */
#define GPIO_OSPEEDER_OSPEEDR12_1        (0x2U << GPIO_OSPEEDER_OSPEEDR12_Pos) /*!< 0x02000000 */
#define GPIO_OSPEEDER_OSPEEDR13_Pos      (26U)                                 
#define GPIO_OSPEEDER_OSPEEDR13_Msk      (0x3U << GPIO_OSPEEDER_OSPEEDR13_Pos) /*!< 0x0C000000 */
#define GPIO_OSPEEDER_OSPEEDR13          GPIO_OSPEEDER_OSPEEDR13_Msk           
#define GPIO_OSPEEDER_OSPEEDR13_0        (0x1U << GPIO_OSPEEDER_OSPEEDR13_Pos) /*!< 0x04000000 */
#define GPIO_OSPEEDER_OSPEEDR13_1        (0x2U << GPIO_OSPEEDER_OSPEEDR13_Pos) /*!< 0x08000000 */
#define GPIO_OSPEEDER_OSPEEDR14_Pos      (28U)                                 
#define GPIO_OSPEEDER_OSPEEDR14_Msk      (0x3U << GPIO_OSPEEDER_OSPEEDR14_Pos) /*!< 0x30000000 */
#define GPIO_OSPEEDER_OSPEEDR14          GPIO_OSPEEDER_OSPEEDR14_Msk           
#define GPIO_OSPEEDER_OSPEEDR14_0        (0x1U << GPIO_OSPEEDER_OSPEEDR14_Pos) /*!< 0x10000000 */
#define GPIO_OSPEEDER_OSPEEDR14_1        (0x2U << GPIO_OSPEEDER_OSPEEDR14_Pos) /*!< 0x20000000 */
#define GPIO_OSPEEDER_OSPEEDR15_Pos      (30U)                                 
#define GPIO_OSPEEDER_OSPEEDR15_Msk      (0x3U << GPIO_OSPEEDER_OSPEEDR15_Pos) /*!< 0xC0000000 */
#define GPIO_OSPEEDER_OSPEEDR15          GPIO_OSPEEDER_OSPEEDR15_Msk           
#define GPIO_OSPEEDER_OSPEEDR15_0        (0x1U << GPIO_OSPEEDER_OSPEEDR15_Pos) /*!< 0x40000000 */
#define GPIO_OSPEEDER_OSPEEDR15_1        (0x2U << GPIO_OSPEEDER_OSPEEDR15_Pos) /*!< 0x80000000 */

/*******************  Bit definition for GPIO_PUPDR register ******************/
#define GPIO_PUPDR_PUPDR0_Pos            (0U)                                  
#define GPIO_PUPDR_PUPDR0_Msk            (0x3U << GPIO_PUPDR_PUPDR0_Pos)       /*!< 0x00000003 */
#define GPIO_PUPDR_PUPDR0                GPIO_PUPDR_PUPDR0_Msk                 
#define GPIO_PUPDR_PUPDR0_0              (0x1U << GPIO_PUPDR_PUPDR0_Pos)       /*!< 0x00000001 */
#define GPIO_PUPDR_PUPDR0_1              (0x2U << GPIO_PUPDR_PUPDR0_Pos)       /*!< 0x00000002 */
#define GPIO_PUPDR_PUPDR1_Pos            (2U)                                  
#define GPIO_PUPDR_PUPDR1_Msk            (0x3U << GPIO_PUPDR_PUPDR1_Pos)       /*!< 0x0000000C */
#define GPIO_PUPDR_PUPDR1                GPIO_PUPDR_PUPDR1_Msk                 
#define GPIO_PUPDR_PUPDR1_0              (0x1U << GPIO_PUPDR_PUPDR1_Pos)       /*!< 0x00000004 */
#define GPIO_PUPDR_PUPDR1_1              (0x2U << GPIO_PUPDR_PUPDR1_Pos)       /*!< 0x00000008 */
#define GPIO_PUPDR_PUPDR2_Pos            (4U)                                  
#define GPIO_PUPDR_PUPDR2_Msk            (0x3U << GPIO_PUPDR_PUPDR2_Pos)       /*!< 0x00000030 */
#define GPIO_PUPDR_PUPDR2                GPIO_PUPDR_PUPDR2_Msk                 
#define GPIO_PUPDR_PUPDR2_0              (0x1U << GPIO_PUPDR_PUPDR2_Pos)       /*!< 0x00000010 */
#define GPIO_PUPDR_PUPDR2_1              (0x2U << GPIO_PUPDR_PUPDR2_Pos)       /*!< 0x00000020 */
#define GPIO_PUPDR_PUPDR3_Pos            (6U)                                  
#define GPIO_PUPDR_PUPDR3_Msk            (0x3U << GPIO_PUPDR_PUPDR3_Pos)       /*!< 0x000000C0 */
#define GPIO_PUPDR_PUPDR3                GPIO_PUPDR_PUPDR3_Msk                 
#define GPIO_PUPDR_PUPDR3_0              (0x1U << GPIO_PUPDR_PUPDR3_Pos)       /*!< 0x00000040 */
#define GPIO_PUPDR_PUPDR3_1              (0x2U << GPIO_PUPDR_PUPDR3_Pos)       /*!< 0x00000080 */
#define GPIO_PUPDR_PUPDR4_Pos            (8U)                                  
#define GPIO_PUPDR_PUPDR4_Msk            (0x3U << GPIO_PUPDR_PUPDR4_Pos)       /*!< 0x00000300 */
#define GPIO_PUPDR_PUPDR4                GPIO_PUPDR_PUPDR4_Msk                 
#define GPIO_PUPDR_PUPDR4_0              (0x1U << GPIO_PUPDR_PUPDR4_Pos)       /*!< 0x00000100 */
#define GPIO_PUPDR_PUPDR4_1              (0x2U << GPIO_PUPDR_PUPDR4_Pos)       /*!< 0x00000200 */
#define GPIO_PUPDR_PUPDR5_Pos            (10U)                                 
#define GPIO_PUPDR_PUPDR5_Msk            (0x3U << GPIO_PUPDR_PUPDR5_Pos)       /*!< 0x00000C00 */
#define GPIO_PUPDR_PUPDR5                GPIO_PUPDR_PUPDR5_Msk                 
#define GPIO_PUPDR_PUPDR5_0              (0x1U << GPIO_PUPDR_PUPDR5_Pos)       /*!< 0x00000400 */
#define GPIO_PUPDR_PUPDR5_1              (0x2U << GPIO_PUPDR_PUPDR5_Pos)       /*!< 0x00000800 */
#define GPIO_PUPDR_PUPDR6_Pos            (12U)                                 
#define GPIO_PUPDR_PUPDR6_Msk            (0x3U << GPIO_PUPDR_PUPDR6_Pos)       /*!< 0x00003000 */
#define GPIO_PUPDR_PUPDR6                GPIO_PUPDR_PUPDR6_Msk                 
#define GPIO_PUPDR_PUPDR6_0              (0x1U << GPIO_PUPDR_PUPDR6_Pos)       /*!< 0x00001000 */
#define GPIO_PUPDR_PUPDR6_1              (0x2U << GPIO_PUPDR_PUPDR6_Pos)       /*!< 0x00002000 */
#define GPIO_PUPDR_PUPDR7_Pos            (14U)                                 
#define GPIO_PUPDR_PUPDR7_Msk            (0x3U << GPIO_PUPDR_PUPDR7_Pos)       /*!< 0x0000C000 */
#define GPIO_PUPDR_PUPDR7                GPIO_PUPDR_PUPDR7_Msk                 
#define GPIO_PUPDR_PUPDR7_0              (0x1U << GPIO_PUPDR_PUPDR7_Pos)       /*!< 0x00004000 */
#define GPIO_PUPDR_PUPDR7_1              (0x2U << GPIO_PUPDR_PUPDR7_Pos)       /*!< 0x00008000 */
#define GPIO_PUPDR_PUPDR8_Pos            (16U)                                 
#define GPIO_PUPDR_PUPDR8_Msk            (0x3U << GPIO_PUPDR_PUPDR8_Pos)       /*!< 0x00030000 */
#define GPIO_PUPDR_PUPDR8                GPIO_PUPDR_PUPDR8_Msk                 
#define GPIO_PUPDR_PUPDR8_0              (0x1U << GPIO_PUPDR_PUPDR8_Pos)       /*!< 0x00010000 */
#define GPIO_PUPDR_PUPDR8_1              (0x2U << GPIO_PUPDR_PUPDR8_Pos)       /*!< 0x00020000 */
#define GPIO_PUPDR_PUPDR9_Pos            (18U)                                 
#define GPIO_PUPDR_PUPDR9_Msk            (0x3U << GPIO_PUPDR_PUPDR9_Pos)       /*!< 0x000C0000 */
#define GPIO_PUPDR_PUPDR9                GPIO_PUPDR_PUPDR9_Msk                 
#define GPIO_PUPDR_PUPDR9_0              (0x1U << GPIO_PUPDR_PUPDR9_Pos)       /*!< 0x00040000 */
#define GPIO_PUPDR_PUPDR9_1              (0x2U << GPIO_PUPDR_PUPDR9_Pos)       /*!< 0x00080000 */
#define GPIO_PUPDR_PUPDR10_Pos           (20U)                                 
#define GPIO_PUPDR_PUPDR10_Msk           (0x3U << GPIO_PUPDR_PUPDR10_Pos)      /*!< 0x00300000 */
#define GPIO_PUPDR_PUPDR10               GPIO_PUPDR_PUPDR10_Msk                
#define GPIO_PUPDR_PUPDR10_0             (0x1U << GPIO_PUPDR_PUPDR10_Pos)      /*!< 0x00100000 */
#define GPIO_PUPDR_PUPDR10_1             (0x2U << GPIO_PUPDR_PUPDR10_Pos)      /*!< 0x00200000 */
#define GPIO_PUPDR_PUPDR11_Pos           (22U)                                 
#define GPIO_PUPDR_PUPDR11_Msk           (0x3U << GPIO_PUPDR_PUPDR11_Pos)      /*!< 0x00C00000 */
#define GPIO_PUPDR_PUPDR11               GPIO_PUPDR_PUPDR11_Msk                
#define GPIO_PUPDR_PUPDR11_0             (0x1U << GPIO_PUPDR_PUPDR11_Pos)      /*!< 0x00400000 */
#define GPIO_PUPDR_PUPDR11_1             (0x2U << GPIO_PUPDR_PUPDR11_Pos)      /*!< 0x00800000 */
#define GPIO_PUPDR_PUPDR12_Pos           (24U)                                 
#define GPIO_PUPDR_PUPDR12_Msk           (0x3U << GPIO_PUPDR_PUPDR12_Pos)      /*!< 0x03000000 */
#define GPIO_PUPDR_PUPDR12               GPIO_PUPDR_PUPDR12_Msk                
#define GPIO_PUPDR_PUPDR12_0             (0x1U << GPIO_PUPDR_PUPDR12_Pos)      /*!< 0x01000000 */
#define GPIO_PUPDR_PUPDR12_1             (0x2U << GPIO_PUPDR_PUPDR12_Pos)      /*!< 0x02000000 */
#define GPIO_PUPDR_PUPDR13_Pos           (26U)                                 
#define GPIO_PUPDR_PUPDR13_Msk           (0x3U << GPIO_PUPDR_PUPDR13_Pos)      /*!< 0x0C000000 */
#define GPIO_PUPDR_PUPDR13               GPIO_PUPDR_PUPDR13_Msk                
#define GPIO_PUPDR_PUPDR13_0             (0x1U << GPIO_PUPDR_PUPDR13_Pos)      /*!< 0x04000000 */
#define GPIO_PUPDR_PUPDR13_1             (0x2U << GPIO_PUPDR_PUPDR13_Pos)      /*!< 0x08000000 */
#define GPIO_PUPDR_PUPDR14_Pos           (28U)                                 
#define GPIO_PUPDR_PUPDR14_Msk           (0x3U << GPIO_PUPDR_PUPDR14_Pos)      /*!< 0x30000000 */
#define GPIO_PUPDR_PUPDR14               GPIO_PUPDR_PUPDR14_Msk                
#define GPIO_PUPDR_PUPDR14_0             (0x1U << GPIO_PUPDR_PUPDR14_Pos)      /*!< 0x10000000 */
#define GPIO_PUPDR_PUPDR14_1             (0x2U << GPIO_PUPDR_PUPDR14_Pos)      /*!< 0x20000000 */
#define GPIO_PUPDR_PUPDR15_Pos           (30U)                                 
#define GPIO_PUPDR_PUPDR15_Msk           (0x3U << GPIO_PUPDR_PUPDR15_Pos)      /*!< 0xC0000000 */
#define GPIO_PUPDR_PUPDR15               GPIO_PUPDR_PUPDR15_Msk                
#define GPIO_PUPDR_PUPDR15_0             (0x1U << GPIO_PUPDR_PUPDR15_Pos)      /*!< 0x40000000 */
#define GPIO_PUPDR_PUPDR15_1             (0x2U << GPIO_PUPDR_PUPDR15_Pos)      /*!< 0x80000000 */

/*******************  Bit definition for GPIO_IDR register  *******************/
#define GPIO_IDR_0                       (0x00000001U)                         
#define GPIO_IDR_1                       (0x00000002U)                         
#define GPIO_IDR_2                       (0x00000004U)                         
#define GPIO_IDR_3                       (0x00000008U)                         
#define GPIO_IDR_4                       (0x00000010U)                         
#define GPIO_IDR_5                       (0x00000020U)                         
#define GPIO_IDR_6                       (0x00000040U)                         
#define GPIO_IDR_7                       (0x00000080U)                         
#define GPIO_IDR_8                       (0x00000100U)                         
#define GPIO_IDR_9                       (0x00000200U)                         
#define GPIO_IDR_10                      (0x00000400U)                         
#define GPIO_IDR_11                      (0x00000800U)                         
#define GPIO_IDR_12                      (0x00001000U)                         
#define GPIO_IDR_13                      (0x00002000U)                         
#define GPIO_IDR_14                      (0x00004000U)                         
#define GPIO_IDR_15                      (0x00008000U)                         

/******************  Bit definition for GPIO_ODR register  ********************/
#define GPIO_ODR_0                       (0x00000001U)                         
#define GPIO_ODR_1                       (0x00000002U)                         
#define GPIO_ODR_2                       (0x00000004U)                         
#define GPIO_ODR_3                       (0x00000008U)                         
#define GPIO_ODR_4                       (0x00000010U)                         
#define GPIO_ODR_5                       (0x00000020U)                         
#define GPIO_ODR_6                       (0x00000040U)                         
#define GPIO_ODR_7                       (0x00000080U)                         
#define GPIO_ODR_8                       (0x00000100U)                         
#define GPIO_ODR_9                       (0x00000200U)                         
#define GPIO_ODR_10                      (0x00000400U)                         
#define GPIO_ODR_11                      (0x00000800U)                         
#define GPIO_ODR_12                      (0x00001000U)                         
#define GPIO_ODR_13                      (0x00002000U)                         
#define GPIO_ODR_14                      (0x00004000U)                         
#define GPIO_ODR_15                      (0x00008000U)                         

/****************** Bit definition for GPIO_BSRR register  ********************/
#define GPIO_BSRR_BS_0                   (0x00000001U)                         
#define GPIO_BSRR_BS_1                   (0x00000002U)                         
#define GPIO_BSRR_BS_2                   (0x00000004U)                         
#define GPIO_BSRR_BS_3                   (0x00000008U)                         
#define GPIO_BSRR_BS_4                   (0x00000010U)                         
#define GPIO_BSRR_BS_5                   (0x00000020U)                         
#define GPIO_BSRR_BS_6                   (0x00000040U)                         
#define GPIO_BSRR_BS_7                   (0x00000080U)                         
#define GPIO_BSRR_BS_8                   (0x00000100U)                         
#define GPIO_BSRR_BS_9                   (0x00000200U)                         
#define GPIO_BSRR_BS_10                  (0x00000400U)                         
#define GPIO_BSRR_BS_11                  (0x00000800U)                         
#define GPIO_BSRR_BS_12                  (0x00001000U)                         
#define GPIO_BSRR_BS_13                  (0x00002000U)                         
#define GPIO_BSRR_BS_14                  (0x00004000U)                         
#define GPIO_BSRR_BS_15                  (0x00008000U)                         
#define GPIO_BSRR_BR_0                   (0x00010000U)                         
#define GPIO_BSRR_BR_1                   (0x00020000U)                         
#define GPIO_BSRR_BR_2                   (0x00040000U)                         
#define GPIO_BSRR_BR_3                   (0x00080000U)                         
#define GPIO_BSRR_BR_4                   (0x00100000U)                         
#define GPIO_BSRR_BR_5                   (0x00200000U)                         
#define GPIO_BSRR_BR_6                   (0x00400000U)                         
#define GPIO_BSRR_BR_7                   (0x00800000U)                         
#define GPIO_BSRR_BR_8                   (0x01000000U)                         
#define GPIO_BSRR_BR_9                   (0x02000000U)                         
#define GPIO_BSRR_BR_10                  (0x04000000U)                         
#define GPIO_BSRR_BR_11                  (0x08000000U)                         
#define GPIO_BSRR_BR_12                  (0x10000000U)                         
#define GPIO_BSRR_BR_13                  (0x20000000U)                         
#define GPIO_BSRR_BR_14                  (0x40000000U)                         
#define GPIO_BSRR_BR_15                  (0x80000000U)                         

/****************** Bit definition for GPIO_LCKR register  ********************/
#define GPIO_LCKR_LCK0_Pos               (0U)                                  
#define GPIO_LCKR_LCK0_Msk               (0x1U << GPIO_LCKR_LCK0_Pos)          /*!< 0x00000001 */
#define GPIO_LCKR_LCK0                   GPIO_LCKR_LCK0_Msk                    
#define GPIO_LCKR_LCK1_Pos               (1U)                                  
#define GPIO_LCKR_LCK1_Msk               (0x1U << GPIO_LCKR_LCK1_Pos)          /*!< 0x00000002 */
#define GPIO_LCKR_LCK1                   GPIO_LCKR_LCK1_Msk                    
#define GPIO_LCKR_LCK2_Pos               (2U)                                  
#define GPIO_LCKR_LCK2_Msk               (0x1U << GPIO_LCKR_LCK2_Pos)          /*!< 0x00000004 */
#define GPIO_LCKR_LCK2                   GPIO_LCKR_LCK2_Msk                    
#define GPIO_LCKR_LCK3_Pos               (3U)                                  
#define GPIO_LCKR_LCK3_Msk               (0x1U << GPIO_LCKR_LCK3_Pos)          /*!< 0x00000008 */
#define GPIO_LCKR_LCK3                   GPIO_LCKR_LCK3_Msk                    
#define GPIO_LCKR_LCK4_Pos               (4U)                                  
#define GPIO_LCKR_LCK4_Msk               (0x1U << GPIO_LCKR_LCK4_Pos)          /*!< 0x00000010 */
#define GPIO_LCKR_LCK4                   GPIO_LCKR_LCK4_Msk                    
#define GPIO_LCKR_LCK5_Pos               (5U)                                  
#define GPIO_LCKR_LCK5_Msk               (0x1U << GPIO_LCKR_LCK5_Pos)          /*!< 0x00000020 */
#define GPIO_LCKR_LCK5                   GPIO_LCKR_LCK5_Msk                    
#define GPIO_LCKR_LCK6_Pos               (6U)                                  
#define GPIO_LCKR_LCK6_Msk               (0x1U << GPIO_LCKR_LCK6_Pos)          /*!< 0x00000040 */
#define GPIO_LCKR_LCK6                   GPIO_LCKR_LCK6_Msk                    
#define GPIO_LCKR_LCK7_Pos               (7U)                                  
#define GPIO_LCKR_LCK7_Msk               (0x1U << GPIO_LCKR_LCK7_Pos)          /*!< 0x00000080 */
#define GPIO_LCKR_LCK7                   GPIO_LCKR_LCK7_Msk                    
#define GPIO_LCKR_LCK8_Pos               (8U)                                  
#define GPIO_LCKR_LCK8_Msk               (0x1U << GPIO_LCKR_LCK8_Pos)          /*!< 0x00000100 */
#define GPIO_LCKR_LCK8                   GPIO_LCKR_LCK8_Msk                    
#define GPIO_LCKR_LCK9_Pos               (9U)                                  
#define GPIO_LCKR_LCK9_Msk               (0x1U << GPIO_LCKR_LCK9_Pos)          /*!< 0x00000200 */
#define GPIO_LCKR_LCK9                   GPIO_LCKR_LCK9_Msk                    
#define GPIO_LCKR_LCK10_Pos              (10U)                                 
#define GPIO_LCKR_LCK10_Msk              (0x1U << GPIO_LCKR_LCK10_Pos)         /*!< 0x00000400 */
#define GPIO_LCKR_LCK10                  GPIO_LCKR_LCK10_Msk                   
#define GPIO_LCKR_LCK11_Pos              (11U)                                 
#define GPIO_LCKR_LCK11_Msk              (0x1U << GPIO_LCKR_LCK11_Pos)         /*!< 0x00000800 */
#define GPIO_LCKR_LCK11                  GPIO_LCKR_LCK11_Msk                   
#define GPIO_LCKR_LCK12_Pos              (12U)                                 
#define GPIO_LCKR_LCK12_Msk              (0x1U << GPIO_LCKR_LCK12_Pos)         /*!< 0x00001000 */
#define GPIO_LCKR_LCK12                  GPIO_LCKR_LCK12_Msk                   
#define GPIO_LCKR_LCK13_Pos              (13U)                                 
#define GPIO_LCKR_LCK13_Msk              (0x1U << GPIO_LCKR_LCK13_Pos)         /*!< 0x00002000 */
#define GPIO_LCKR_LCK13                  GPIO_LCKR_LCK13_Msk                   
#define GPIO_LCKR_LCK14_Pos              (14U)                                 
#define GPIO_LCKR_LCK14_Msk              (0x1U << GPIO_LCKR_LCK14_Pos)         /*!< 0x00004000 */
#define GPIO_LCKR_LCK14                  GPIO_LCKR_LCK14_Msk                   
#define GPIO_LCKR_LCK15_Pos              (15U)                                 
#define GPIO_LCKR_LCK15_Msk              (0x1U << GPIO_LCKR_LCK15_Pos)         /*!< 0x00008000 */
#define GPIO_LCKR_LCK15                  GPIO_LCKR_LCK15_Msk                   
#define GPIO_LCKR_LCKK_Pos               (16U)                                 
#define GPIO_LCKR_LCKK_Msk               (0x1U << GPIO_LCKR_LCKK_Pos)          /*!< 0x00010000 */
#define GPIO_LCKR_LCKK                   GPIO_LCKR_LCKK_Msk                    

/****************** Bit definition for GPIO_AFRL register  ********************/
#define GPIO_AFRL_AFRL0_Pos              (0U)                                  
#define GPIO_AFRL_AFRL0_Msk              (0xFU << GPIO_AFRL_AFRL0_Pos)         /*!< 0x0000000F */
#define GPIO_AFRL_AFRL0                  GPIO_AFRL_AFRL0_Msk                   
#define GPIO_AFRL_AFRL1_Pos              (4U)                                  
#define GPIO_AFRL_AFRL1_Msk              (0xFU << GPIO_AFRL_AFRL1_Pos)         /*!< 0x000000F0 */
#define GPIO_AFRL_AFRL1                  GPIO_AFRL_AFRL1_Msk                   
#define GPIO_AFRL_AFRL2_Pos              (8U)                                  
#define GPIO_AFRL_AFRL2_Msk              (0xFU << GPIO_AFRL_AFRL2_Pos)         /*!< 0x00000F00 */
#define GPIO_AFRL_AFRL2                  GPIO_AFRL_AFRL2_Msk                   
#define GPIO_AFRL_AFRL3_Pos              (12U)                                 
#define GPIO_AFRL_AFRL3_Msk              (0xFU << GPIO_AFRL_AFRL3_Pos)         /*!< 0x0000F000 */
#define GPIO_AFRL_AFRL3                  GPIO_AFRL_AFRL3_Msk                   
#define GPIO_AFRL_AFRL4_Pos              (16U)                                 
#define GPIO_AFRL_AFRL4_Msk              (0xFU << GPIO_AFRL_AFRL4_Pos)         /*!< 0x000F0000 */
#define GPIO_AFRL_AFRL4                  GPIO_AFRL_AFRL4_Msk                   
#define GPIO_AFRL_AFRL5_Pos              (20U)                                 
#define GPIO_AFRL_AFRL5_Msk              (0xFU << GPIO_AFRL_AFRL5_Pos)         /*!< 0x00F00000 */
#define GPIO_AFRL_AFRL5                  GPIO_AFRL_AFRL5_Msk                   
#define GPIO_AFRL_AFRL6_Pos              (24U)                                 
#define GPIO_AFRL_AFRL6_Msk              (0xFU << GPIO_AFRL_AFRL6_Pos)         /*!< 0x0F000000 */
#define GPIO_AFRL_AFRL6                  GPIO_AFRL_AFRL6_Msk                   
#define GPIO_AFRL_AFRL7_Pos              (28U)                                 
#define GPIO_AFRL_AFRL7_Msk              (0xFU << GPIO_AFRL_AFRL7_Pos)         /*!< 0xF0000000 */
#define GPIO_AFRL_AFRL7                  GPIO_AFRL_AFRL7_Msk                   

/****************** Bit definition for GPIO_AFRH register  ********************/
#define GPIO_AFRH_AFRH0_Pos              (0U)                                  
#define GPIO_AFRH_AFRH0_Msk              (0xFU << GPIO_AFRH_AFRH0_Pos)         /*!< 0x0000000F */
#define GPIO_AFRH_AFRH0                  GPIO_AFRH_AFRH0_Msk                   
#define GPIO_AFRH_AFRH1_Pos              (4U)                                  
#define GPIO_AFRH_AFRH1_Msk              (0xFU << GPIO_AFRH_AFRH1_Pos)         /*!< 0x000000F0 */
#define GPIO_AFRH_AFRH1                  GPIO_AFRH_AFRH1_Msk                   
#define GPIO_AFRH_AFRH2_Pos              (8U)                                  
#define GPIO_AFRH_AFRH2_Msk              (0xFU << GPIO_AFRH_AFRH2_Pos)         /*!< 0x00000F00 */
#define GPIO_AFRH_AFRH2                  GPIO_AFRH_AFRH2_Msk                   
#define GPIO_AFRH_AFRH3_Pos              (12U)                                 
#define GPIO_AFRH_AFRH3_Msk              (0xFU << GPIO_AFRH_AFRH3_Pos)         /*!< 0x0000F000 */
#define GPIO_AFRH_AFRH3                  GPIO_AFRH_AFRH3_Msk                   
#define GPIO_AFRH_AFRH4_Pos              (16U)                                 
#define GPIO_AFRH_AFRH4_Msk              (0xFU << GPIO_AFRH_AFRH4_Pos)         /*!< 0x000F0000 */
#define GPIO_AFRH_AFRH4                  GPIO_AFRH_AFRH4_Msk                   
#define GPIO_AFRH_AFRH5_Pos              (20U)                                 
#define GPIO_AFRH_AFRH5_Msk              (0xFU << GPIO_AFRH_AFRH5_Pos)         /*!< 0x00F00000 */
#define GPIO_AFRH_AFRH5                  GPIO_AFRH_AFRH5_Msk                   
#define GPIO_AFRH_AFRH6_Pos              (24U)                                 
#define GPIO_AFRH_AFRH6_Msk              (0xFU << GPIO_AFRH_AFRH6_Pos)         /*!< 0x0F000000 */
#define GPIO_AFRH_AFRH6                  GPIO_AFRH_AFRH6_Msk                   
#define GPIO_AFRH_AFRH7_Pos              (28U)                                 
#define GPIO_AFRH_AFRH7_Msk              (0xFU << GPIO_AFRH_AFRH7_Pos)         /*!< 0xF0000000 */
#define GPIO_AFRH_AFRH7                  GPIO_AFRH_AFRH7_Msk                   

/****************** Bit definition for GPIO_BRR register  *********************/
#define GPIO_BRR_BR_0                    (0x00000001U)                         
#define GPIO_BRR_BR_1                    (0x00000002U)                         
#define GPIO_BRR_BR_2                    (0x00000004U)                         
#define GPIO_BRR_BR_3                    (0x00000008U)                         
#define GPIO_BRR_BR_4                    (0x00000010U)                         
#define GPIO_BRR_BR_5                    (0x00000020U)                         
#define GPIO_BRR_BR_6                    (0x00000040U)                         
#define GPIO_BRR_BR_7                    (0x00000080U)                         
#define GPIO_BRR_BR_8                    (0x00000100U)                         
#define GPIO_BRR_BR_9                    (0x00000200U)                         
#define GPIO_BRR_BR_10                   (0x00000400U)                         
#define GPIO_BRR_BR_11                   (0x00000800U)                         
#define GPIO_BRR_BR_12                   (0x00001000U)                         
#define GPIO_BRR_BR_13                   (0x00002000U)                         
#define GPIO_BRR_BR_14                   (0x00004000U)                         
#define GPIO_BRR_BR_15                   (0x00008000U)                         

/******************************************************************************/
/*                                                                            */
/*                        High Resolution Timer (HRTIM)                       */
/*                                                                            */
/******************************************************************************/
/******************** Master Timer control register ***************************/
#define HRTIM_MCR_CK_PSC_Pos          (0U)                                     
#define HRTIM_MCR_CK_PSC_Msk          (0x7U << HRTIM_MCR_CK_PSC_Pos)           /*!< 0x00000007 */
#define HRTIM_MCR_CK_PSC              HRTIM_MCR_CK_PSC_Msk                     /*!< Prescaler mask */
#define HRTIM_MCR_CK_PSC_0            (0x1U << HRTIM_MCR_CK_PSC_Pos)           /*!< 0x00000001 */
#define HRTIM_MCR_CK_PSC_1            (0x2U << HRTIM_MCR_CK_PSC_Pos)           /*!< 0x00000002 */
#define HRTIM_MCR_CK_PSC_2            (0x4U << HRTIM_MCR_CK_PSC_Pos)           /*!< 0x00000004 */

#define HRTIM_MCR_CONT_Pos            (3U)                                     
#define HRTIM_MCR_CONT_Msk            (0x1U << HRTIM_MCR_CONT_Pos)             /*!< 0x00000008 */
#define HRTIM_MCR_CONT                HRTIM_MCR_CONT_Msk                       /*!< Continuous mode */
#define HRTIM_MCR_RETRIG_Pos          (4U)                                     
#define HRTIM_MCR_RETRIG_Msk          (0x1U << HRTIM_MCR_RETRIG_Pos)           /*!< 0x00000010 */
#define HRTIM_MCR_RETRIG              HRTIM_MCR_RETRIG_Msk                     /*!< Rettrigreable mode */
#define HRTIM_MCR_HALF_Pos            (5U)                                     
#define HRTIM_MCR_HALF_Msk            (0x1U << HRTIM_MCR_HALF_Pos)             /*!< 0x00000020 */
#define HRTIM_MCR_HALF                HRTIM_MCR_HALF_Msk                       /*!< Half mode */

#define HRTIM_MCR_SYNC_IN_Pos         (8U)                                     
#define HRTIM_MCR_SYNC_IN_Msk         (0x3U << HRTIM_MCR_SYNC_IN_Pos)          /*!< 0x00000300 */
#define HRTIM_MCR_SYNC_IN             HRTIM_MCR_SYNC_IN_Msk                    /*!< Synchronization input master */
#define HRTIM_MCR_SYNC_IN_0           (0x1U << HRTIM_MCR_SYNC_IN_Pos)          /*!< 0x00000100 */
#define HRTIM_MCR_SYNC_IN_1           (0x2U << HRTIM_MCR_SYNC_IN_Pos)          /*!< 0x00000200 */
#define HRTIM_MCR_SYNCRSTM_Pos        (10U)                                    
#define HRTIM_MCR_SYNCRSTM_Msk        (0x1U << HRTIM_MCR_SYNCRSTM_Pos)         /*!< 0x00000400 */
#define HRTIM_MCR_SYNCRSTM            HRTIM_MCR_SYNCRSTM_Msk                   /*!< Synchronization reset master */
#define HRTIM_MCR_SYNCSTRTM_Pos       (11U)                                    
#define HRTIM_MCR_SYNCSTRTM_Msk       (0x1U << HRTIM_MCR_SYNCSTRTM_Pos)        /*!< 0x00000800 */
#define HRTIM_MCR_SYNCSTRTM           HRTIM_MCR_SYNCSTRTM_Msk                  /*!< Synchronization start master */
#define HRTIM_MCR_SYNC_OUT_Pos        (12U)                                    
#define HRTIM_MCR_SYNC_OUT_Msk        (0x3U << HRTIM_MCR_SYNC_OUT_Pos)         /*!< 0x00003000 */
#define HRTIM_MCR_SYNC_OUT            HRTIM_MCR_SYNC_OUT_Msk                   /*!< Synchronization output master */
#define HRTIM_MCR_SYNC_OUT_0          (0x1U << HRTIM_MCR_SYNC_OUT_Pos)         /*!< 0x00001000 */
#define HRTIM_MCR_SYNC_OUT_1          (0x2U << HRTIM_MCR_SYNC_OUT_Pos)         /*!< 0x00002000 */
#define HRTIM_MCR_SYNC_SRC_Pos        (14U)                                    
#define HRTIM_MCR_SYNC_SRC_Msk        (0x3U << HRTIM_MCR_SYNC_SRC_Pos)         /*!< 0x0000C000 */
#define HRTIM_MCR_SYNC_SRC            HRTIM_MCR_SYNC_SRC_Msk                   /*!< Synchronization source */
#define HRTIM_MCR_SYNC_SRC_0          (0x1U << HRTIM_MCR_SYNC_SRC_Pos)         /*!< 0x00004000 */
#define HRTIM_MCR_SYNC_SRC_1          (0x2U << HRTIM_MCR_SYNC_SRC_Pos)         /*!< 0x00008000 */

#define HRTIM_MCR_MCEN_Pos            (16U)                                    
#define HRTIM_MCR_MCEN_Msk            (0x1U << HRTIM_MCR_MCEN_Pos)             /*!< 0x00010000 */
#define HRTIM_MCR_MCEN                HRTIM_MCR_MCEN_Msk                       /*!< Master counter enable */
#define HRTIM_MCR_TACEN_Pos           (17U)                                    
#define HRTIM_MCR_TACEN_Msk           (0x1U << HRTIM_MCR_TACEN_Pos)            /*!< 0x00020000 */
#define HRTIM_MCR_TACEN               HRTIM_MCR_TACEN_Msk                      /*!< Timer A counter enable */
#define HRTIM_MCR_TBCEN_Pos           (18U)                                    
#define HRTIM_MCR_TBCEN_Msk           (0x1U << HRTIM_MCR_TBCEN_Pos)            /*!< 0x00040000 */
#define HRTIM_MCR_TBCEN               HRTIM_MCR_TBCEN_Msk                      /*!< Timer B counter enable */
#define HRTIM_MCR_TCCEN_Pos           (19U)                                    
#define HRTIM_MCR_TCCEN_Msk           (0x1U << HRTIM_MCR_TCCEN_Pos)            /*!< 0x00080000 */
#define HRTIM_MCR_TCCEN               HRTIM_MCR_TCCEN_Msk                      /*!< Timer C counter enable */
#define HRTIM_MCR_TDCEN_Pos           (20U)                                    
#define HRTIM_MCR_TDCEN_Msk           (0x1U << HRTIM_MCR_TDCEN_Pos)            /*!< 0x00100000 */
#define HRTIM_MCR_TDCEN               HRTIM_MCR_TDCEN_Msk                      /*!< Timer D counter enable */
#define HRTIM_MCR_TECEN_Pos           (21U)                                    
#define HRTIM_MCR_TECEN_Msk           (0x1U << HRTIM_MCR_TECEN_Pos)            /*!< 0x00200000 */
#define HRTIM_MCR_TECEN               HRTIM_MCR_TECEN_Msk                      /*!< Timer E counter enable */

#define HRTIM_MCR_DACSYNC_Pos         (25U)                                    
#define HRTIM_MCR_DACSYNC_Msk         (0x3U << HRTIM_MCR_DACSYNC_Pos)          /*!< 0x06000000 */
#define HRTIM_MCR_DACSYNC             HRTIM_MCR_DACSYNC_Msk                    /*!< DAC sychronization mask */
#define HRTIM_MCR_DACSYNC_0           (0x1U << HRTIM_MCR_DACSYNC_Pos)          /*!< 0x02000000 */
#define HRTIM_MCR_DACSYNC_1           (0x2U << HRTIM_MCR_DACSYNC_Pos)          /*!< 0x04000000 */

#define HRTIM_MCR_PREEN_Pos           (27U)                                    
#define HRTIM_MCR_PREEN_Msk           (0x1U << HRTIM_MCR_PREEN_Pos)            /*!< 0x08000000 */
#define HRTIM_MCR_PREEN               HRTIM_MCR_PREEN_Msk                      /*!< Master preload enable */
#define HRTIM_MCR_MREPU_Pos           (29U)                                    
#define HRTIM_MCR_MREPU_Msk           (0x1U << HRTIM_MCR_MREPU_Pos)            /*!< 0x20000000 */
#define HRTIM_MCR_MREPU               HRTIM_MCR_MREPU_Msk                      /*!< Master repetition update */

#define HRTIM_MCR_BRSTDMA_Pos         (30U)                                    
#define HRTIM_MCR_BRSTDMA_Msk         (0x3U << HRTIM_MCR_BRSTDMA_Pos)          /*!< 0xC0000000 */
#define HRTIM_MCR_BRSTDMA             HRTIM_MCR_BRSTDMA_Msk                    /*!< Burst DMA update */
#define HRTIM_MCR_BRSTDMA_0           (0x1U << HRTIM_MCR_BRSTDMA_Pos)          /*!< 0x40000000 */
#define HRTIM_MCR_BRSTDMA_1           (0x2U << HRTIM_MCR_BRSTDMA_Pos)          /*!< 0x80000000 */

/******************** Master Timer Interrupt status register ******************/
#define HRTIM_MISR_MCMP1_Pos          (0U)                                     
#define HRTIM_MISR_MCMP1_Msk          (0x1U << HRTIM_MISR_MCMP1_Pos)           /*!< 0x00000001 */
#define HRTIM_MISR_MCMP1              HRTIM_MISR_MCMP1_Msk                     /*!< Master compare 1 interrupt flag */
#define HRTIM_MISR_MCMP2_Pos          (1U)                                     
#define HRTIM_MISR_MCMP2_Msk          (0x1U << HRTIM_MISR_MCMP2_Pos)           /*!< 0x00000002 */
#define HRTIM_MISR_MCMP2              HRTIM_MISR_MCMP2_Msk                     /*!< Master compare 2 interrupt flag */
#define HRTIM_MISR_MCMP3_Pos          (2U)                                     
#define HRTIM_MISR_MCMP3_Msk          (0x1U << HRTIM_MISR_MCMP3_Pos)           /*!< 0x00000004 */
#define HRTIM_MISR_MCMP3              HRTIM_MISR_MCMP3_Msk                     /*!< Master compare 3 interrupt flag */
#define HRTIM_MISR_MCMP4_Pos          (3U)                                     
#define HRTIM_MISR_MCMP4_Msk          (0x1U << HRTIM_MISR_MCMP4_Pos)           /*!< 0x00000008 */
#define HRTIM_MISR_MCMP4              HRTIM_MISR_MCMP4_Msk                     /*!< Master compare 4 interrupt flag */
#define HRTIM_MISR_MREP_Pos           (4U)                                     
#define HRTIM_MISR_MREP_Msk           (0x1U << HRTIM_MISR_MREP_Pos)            /*!< 0x00000010 */
#define HRTIM_MISR_MREP               HRTIM_MISR_MREP_Msk                      /*!< Master Repetition interrupt flag */
#define HRTIM_MISR_SYNC_Pos           (5U)                                     
#define HRTIM_MISR_SYNC_Msk           (0x1U << HRTIM_MISR_SYNC_Pos)            /*!< 0x00000020 */
#define HRTIM_MISR_SYNC               HRTIM_MISR_SYNC_Msk                      /*!< Synchronization input interrupt flag */
#define HRTIM_MISR_MUPD_Pos           (6U)                                     
#define HRTIM_MISR_MUPD_Msk           (0x1U << HRTIM_MISR_MUPD_Pos)            /*!< 0x00000040 */
#define HRTIM_MISR_MUPD               HRTIM_MISR_MUPD_Msk                      /*!< Master update interrupt flag */

/******************** Master Timer Interrupt clear register *******************/
#define HRTIM_MICR_MCMP1_Pos          (0U)                                     
#define HRTIM_MICR_MCMP1_Msk          (0x1U << HRTIM_MICR_MCMP1_Pos)           /*!< 0x00000001 */
#define HRTIM_MICR_MCMP1              HRTIM_MICR_MCMP1_Msk                     /*!< Master compare 1 interrupt flag clear */
#define HRTIM_MICR_MCMP2_Pos          (1U)                                     
#define HRTIM_MICR_MCMP2_Msk          (0x1U << HRTIM_MICR_MCMP2_Pos)           /*!< 0x00000002 */
#define HRTIM_MICR_MCMP2              HRTIM_MICR_MCMP2_Msk                     /*!< Master compare 2 interrupt flag clear */
#define HRTIM_MICR_MCMP3_Pos          (2U)                                     
#define HRTIM_MICR_MCMP3_Msk          (0x1U << HRTIM_MICR_MCMP3_Pos)           /*!< 0x00000004 */
#define HRTIM_MICR_MCMP3              HRTIM_MICR_MCMP3_Msk                     /*!< Master compare 3 interrupt flag clear */
#define HRTIM_MICR_MCMP4_Pos          (3U)                                     
#define HRTIM_MICR_MCMP4_Msk          (0x1U << HRTIM_MICR_MCMP4_Pos)           /*!< 0x00000008 */
#define HRTIM_MICR_MCMP4              HRTIM_MICR_MCMP4_Msk                     /*!< Master compare 4 interrupt flag clear */
#define HRTIM_MICR_MREP_Pos           (4U)                                     
#define HRTIM_MICR_MREP_Msk           (0x1U << HRTIM_MICR_MREP_Pos)            /*!< 0x00000010 */
#define HRTIM_MICR_MREP               HRTIM_MICR_MREP_Msk                      /*!< Master Repetition interrupt flag clear */
#define HRTIM_MICR_SYNC_Pos           (5U)                                     
#define HRTIM_MICR_SYNC_Msk           (0x1U << HRTIM_MICR_SYNC_Pos)            /*!< 0x00000020 */
#define HRTIM_MICR_SYNC               HRTIM_MICR_SYNC_Msk                      /*!< Synchronization input interrupt flag clear */
#define HRTIM_MICR_MUPD_Pos           (6U)                                     
#define HRTIM_MICR_MUPD_Msk           (0x1U << HRTIM_MICR_MUPD_Pos)            /*!< 0x00000040 */
#define HRTIM_MICR_MUPD               HRTIM_MICR_MUPD_Msk                      /*!< Master update interrupt flag clear */

/******************** Master Timer DMA/Interrupt enable register **************/
#define HRTIM_MDIER_MCMP1IE_Pos       (0U)                                     
#define HRTIM_MDIER_MCMP1IE_Msk       (0x1U << HRTIM_MDIER_MCMP1IE_Pos)        /*!< 0x00000001 */
#define HRTIM_MDIER_MCMP1IE           HRTIM_MDIER_MCMP1IE_Msk                  /*!< Master compare 1 interrupt enable */
#define HRTIM_MDIER_MCMP2IE_Pos       (1U)                                     
#define HRTIM_MDIER_MCMP2IE_Msk       (0x1U << HRTIM_MDIER_MCMP2IE_Pos)        /*!< 0x00000002 */
#define HRTIM_MDIER_MCMP2IE           HRTIM_MDIER_MCMP2IE_Msk                  /*!< Master compare 2 interrupt enable */
#define HRTIM_MDIER_MCMP3IE_Pos       (2U)                                     
#define HRTIM_MDIER_MCMP3IE_Msk       (0x1U << HRTIM_MDIER_MCMP3IE_Pos)        /*!< 0x00000004 */
#define HRTIM_MDIER_MCMP3IE           HRTIM_MDIER_MCMP3IE_Msk                  /*!< Master compare 3 interrupt enable */
#define HRTIM_MDIER_MCMP4IE_Pos       (3U)                                     
#define HRTIM_MDIER_MCMP4IE_Msk       (0x1U << HRTIM_MDIER_MCMP4IE_Pos)        /*!< 0x00000008 */
#define HRTIM_MDIER_MCMP4IE           HRTIM_MDIER_MCMP4IE_Msk                  /*!< Master compare 4 interrupt enable */
#define HRTIM_MDIER_MREPIE_Pos        (4U)                                     
#define HRTIM_MDIER_MREPIE_Msk        (0x1U << HRTIM_MDIER_MREPIE_Pos)         /*!< 0x00000010 */
#define HRTIM_MDIER_MREPIE            HRTIM_MDIER_MREPIE_Msk                   /*!< Master Repetition interrupt enable */
#define HRTIM_MDIER_SYNCIE_Pos        (5U)                                     
#define HRTIM_MDIER_SYNCIE_Msk        (0x1U << HRTIM_MDIER_SYNCIE_Pos)         /*!< 0x00000020 */
#define HRTIM_MDIER_SYNCIE            HRTIM_MDIER_SYNCIE_Msk                   /*!< Synchronization input interrupt enable */
#define HRTIM_MDIER_MUPDIE_Pos        (6U)                                     
#define HRTIM_MDIER_MUPDIE_Msk        (0x1U << HRTIM_MDIER_MUPDIE_Pos)         /*!< 0x00000040 */
#define HRTIM_MDIER_MUPDIE            HRTIM_MDIER_MUPDIE_Msk                   /*!< Master update interrupt enable */

#define HRTIM_MDIER_MCMP1DE_Pos       (16U)                                    
#define HRTIM_MDIER_MCMP1DE_Msk       (0x1U << HRTIM_MDIER_MCMP1DE_Pos)        /*!< 0x00010000 */
#define HRTIM_MDIER_MCMP1DE           HRTIM_MDIER_MCMP1DE_Msk                  /*!< Master compare 1 DMA enable */
#define HRTIM_MDIER_MCMP2DE_Pos       (17U)                                    
#define HRTIM_MDIER_MCMP2DE_Msk       (0x1U << HRTIM_MDIER_MCMP2DE_Pos)        /*!< 0x00020000 */
#define HRTIM_MDIER_MCMP2DE           HRTIM_MDIER_MCMP2DE_Msk                  /*!< Master compare 2 DMA enable */
#define HRTIM_MDIER_MCMP3DE_Pos       (18U)                                    
#define HRTIM_MDIER_MCMP3DE_Msk       (0x1U << HRTIM_MDIER_MCMP3DE_Pos)        /*!< 0x00040000 */
#define HRTIM_MDIER_MCMP3DE           HRTIM_MDIER_MCMP3DE_Msk                  /*!< Master compare 3 DMA enable */
#define HRTIM_MDIER_MCMP4DE_Pos       (19U)                                    
#define HRTIM_MDIER_MCMP4DE_Msk       (0x1U << HRTIM_MDIER_MCMP4DE_Pos)        /*!< 0x00080000 */
#define HRTIM_MDIER_MCMP4DE           HRTIM_MDIER_MCMP4DE_Msk                  /*!< Master compare 4 DMA enable */
#define HRTIM_MDIER_MREPDE_Pos        (20U)                                    
#define HRTIM_MDIER_MREPDE_Msk        (0x1U << HRTIM_MDIER_MREPDE_Pos)         /*!< 0x00100000 */
#define HRTIM_MDIER_MREPDE            HRTIM_MDIER_MREPDE_Msk                   /*!< Master Repetition DMA enable */
#define HRTIM_MDIER_SYNCDE_Pos        (21U)                                    
#define HRTIM_MDIER_SYNCDE_Msk        (0x1U << HRTIM_MDIER_SYNCDE_Pos)         /*!< 0x00200000 */
#define HRTIM_MDIER_SYNCDE            HRTIM_MDIER_SYNCDE_Msk                   /*!< Synchronization input DMA enable */
#define HRTIM_MDIER_MUPDDE_Pos        (22U)                                    
#define HRTIM_MDIER_MUPDDE_Msk        (0x1U << HRTIM_MDIER_MUPDDE_Pos)         /*!< 0x00400000 */
#define HRTIM_MDIER_MUPDDE            HRTIM_MDIER_MUPDDE_Msk                   /*!< Master update DMA enable */

/*******************  Bit definition for HRTIM_MCNTR register  ****************/
#define HRTIM_MCNTR_MCNTR_Pos         (0U)                                     
#define HRTIM_MCNTR_MCNTR_Msk         (0xFFFFFFFFU << HRTIM_MCNTR_MCNTR_Pos)   /*!< 0xFFFFFFFF */
#define HRTIM_MCNTR_MCNTR             HRTIM_MCNTR_MCNTR_Msk                    /*!<Counter Value */

/*******************  Bit definition for HRTIM_MPER register  *****************/
#define HRTIM_MPER_MPER_Pos           (0U)                                     
#define HRTIM_MPER_MPER_Msk           (0xFFFFFFFFU << HRTIM_MPER_MPER_Pos)     /*!< 0xFFFFFFFF */
#define HRTIM_MPER_MPER               HRTIM_MPER_MPER_Msk                      /*!< Period Value */

/*******************  Bit definition for HRTIM_MREP register  *****************/
#define HRTIM_MREP_MREP_Pos           (0U)                                     
#define HRTIM_MREP_MREP_Msk           (0xFFFFFFFFU << HRTIM_MREP_MREP_Pos)     /*!< 0xFFFFFFFF */
#define HRTIM_MREP_MREP               HRTIM_MREP_MREP_Msk                      /*!<Repetition Value */

/*******************  Bit definition for HRTIM_MCMP1R register  *****************/
#define HRTIM_MCMP1R_MCMP1R_Pos       (0U)                                     
#define HRTIM_MCMP1R_MCMP1R_Msk       (0xFFFFFFFFU << HRTIM_MCMP1R_MCMP1R_Pos) /*!< 0xFFFFFFFF */
#define HRTIM_MCMP1R_MCMP1R           HRTIM_MCMP1R_MCMP1R_Msk                  /*!<Compare Value */

/*******************  Bit definition for HRTIM_MCMP2R register  *****************/
#define HRTIM_MCMP2R_MCMP2R_Pos       (0U)                                     
#define HRTIM_MCMP2R_MCMP2R_Msk       (0xFFFFFFFFU << HRTIM_MCMP2R_MCMP2R_Pos) /*!< 0xFFFFFFFF */
#define HRTIM_MCMP2R_MCMP2R           HRTIM_MCMP2R_MCMP2R_Msk                  /*!<Compare Value */

/*******************  Bit definition for HRTIM_MCMP3R register  *****************/
#define HRTIM_MCMP3R_MCMP3R_Pos       (0U)                                     
#define HRTIM_MCMP3R_MCMP3R_Msk       (0xFFFFFFFFU << HRTIM_MCMP3R_MCMP3R_Pos) /*!< 0xFFFFFFFF */
#define HRTIM_MCMP3R_MCMP3R           HRTIM_MCMP3R_MCMP3R_Msk                  /*!<Compare Value */

/*******************  Bit definition for HRTIM_MCMP4R register  *****************/
#define HRTIM_MCMP4R_MCMP4R_Pos       (0U)                                     
#define HRTIM_MCMP4R_MCMP4R_Msk       (0xFFFFFFFFU << HRTIM_MCMP4R_MCMP4R_Pos) /*!< 0xFFFFFFFF */
#define HRTIM_MCMP4R_MCMP4R           HRTIM_MCMP4R_MCMP4R_Msk                  /*!<Compare Value */

/* Legacy defines */
#define HRTIM_MCMP1R_MCMP2R HRTIM_MCMP2R_MCMP2R
#define HRTIM_MCMP1R_MCMP3R HRTIM_MCMP3R_MCMP3R
#define HRTIM_MCMP1R_MCMP4R HRTIM_MCMP4R_MCMP4R

/******************** Slave control register **********************************/
#define HRTIM_TIMCR_CK_PSC_Pos        (0U)                                     
#define HRTIM_TIMCR_CK_PSC_Msk        (0x7U << HRTIM_TIMCR_CK_PSC_Pos)         /*!< 0x00000007 */
#define HRTIM_TIMCR_CK_PSC            HRTIM_TIMCR_CK_PSC_Msk                   /*!< Slave prescaler mask*/
#define HRTIM_TIMCR_CK_PSC_0          (0x1U << HRTIM_TIMCR_CK_PSC_Pos)         /*!< 0x00000001 */
#define HRTIM_TIMCR_CK_PSC_1          (0x2U << HRTIM_TIMCR_CK_PSC_Pos)         /*!< 0x00000002 */
#define HRTIM_TIMCR_CK_PSC_2          (0x4U << HRTIM_TIMCR_CK_PSC_Pos)         /*!< 0x00000004 */

#define HRTIM_TIMCR_CONT_Pos          (3U)                                     
#define HRTIM_TIMCR_CONT_Msk          (0x1U << HRTIM_TIMCR_CONT_Pos)           /*!< 0x00000008 */
#define HRTIM_TIMCR_CONT              HRTIM_TIMCR_CONT_Msk                     /*!< Slave continuous mode */
#define HRTIM_TIMCR_RETRIG_Pos        (4U)                                     
#define HRTIM_TIMCR_RETRIG_Msk        (0x1U << HRTIM_TIMCR_RETRIG_Pos)         /*!< 0x00000010 */
#define HRTIM_TIMCR_RETRIG            HRTIM_TIMCR_RETRIG_Msk                   /*!< Slave Retrigreable mode */
#define HRTIM_TIMCR_HALF_Pos          (5U)                                     
#define HRTIM_TIMCR_HALF_Msk          (0x1U << HRTIM_TIMCR_HALF_Pos)           /*!< 0x00000020 */
#define HRTIM_TIMCR_HALF              HRTIM_TIMCR_HALF_Msk                     /*!< Slave Half mode */
#define HRTIM_TIMCR_PSHPLL_Pos        (6U)                                     
#define HRTIM_TIMCR_PSHPLL_Msk        (0x1U << HRTIM_TIMCR_PSHPLL_Pos)         /*!< 0x00000040 */
#define HRTIM_TIMCR_PSHPLL            HRTIM_TIMCR_PSHPLL_Msk                   /*!< Slave push-pull mode */

#define HRTIM_TIMCR_SYNCRST_Pos       (10U)                                    
#define HRTIM_TIMCR_SYNCRST_Msk       (0x1U << HRTIM_TIMCR_SYNCRST_Pos)        /*!< 0x00000400 */
#define HRTIM_TIMCR_SYNCRST           HRTIM_TIMCR_SYNCRST_Msk                  /*!< Slave synchronization resets */
#define HRTIM_TIMCR_SYNCSTRT_Pos      (11U)                                    
#define HRTIM_TIMCR_SYNCSTRT_Msk      (0x1U << HRTIM_TIMCR_SYNCSTRT_Pos)       /*!< 0x00000800 */
#define HRTIM_TIMCR_SYNCSTRT          HRTIM_TIMCR_SYNCSTRT_Msk                 /*!< Slave synchronization starts */

#define HRTIM_TIMCR_DELCMP2_Pos       (12U)                                    
#define HRTIM_TIMCR_DELCMP2_Msk       (0x3U << HRTIM_TIMCR_DELCMP2_Pos)        /*!< 0x00003000 */
#define HRTIM_TIMCR_DELCMP2           HRTIM_TIMCR_DELCMP2_Msk                  /*!< Slave delayed compartor 2 mode mask */
#define HRTIM_TIMCR_DELCMP2_0         (0x1U << HRTIM_TIMCR_DELCMP2_Pos)        /*!< 0x00001000 */
#define HRTIM_TIMCR_DELCMP2_1         (0x2U << HRTIM_TIMCR_DELCMP2_Pos)        /*!< 0x00002000 */
#define HRTIM_TIMCR_DELCMP4_Pos       (14U)                                    
#define HRTIM_TIMCR_DELCMP4_Msk       (0x3U << HRTIM_TIMCR_DELCMP4_Pos)        /*!< 0x0000C000 */
#define HRTIM_TIMCR_DELCMP4           HRTIM_TIMCR_DELCMP4_Msk                  /*!< Slave delayed compartor 4 mode mask */
#define HRTIM_TIMCR_DELCMP4_0         (0x1U << HRTIM_TIMCR_DELCMP4_Pos)        /*!< 0x00004000 */
#define HRTIM_TIMCR_DELCMP4_1         (0x2U << HRTIM_TIMCR_DELCMP4_Pos)        /*!< 0x00008000 */

#define HRTIM_TIMCR_TREPU_Pos         (17U)                                    
#define HRTIM_TIMCR_TREPU_Msk         (0x1U << HRTIM_TIMCR_TREPU_Pos)          /*!< 0x00020000 */
#define HRTIM_TIMCR_TREPU             HRTIM_TIMCR_TREPU_Msk                    /*!< Slave repetition update */
#define HRTIM_TIMCR_TRSTU_Pos         (18U)                                    
#define HRTIM_TIMCR_TRSTU_Msk         (0x1U << HRTIM_TIMCR_TRSTU_Pos)          /*!< 0x00040000 */
#define HRTIM_TIMCR_TRSTU             HRTIM_TIMCR_TRSTU_Msk                    /*!< Slave reset update */
#define HRTIM_TIMCR_TAU_Pos           (19U)                                    
#define HRTIM_TIMCR_TAU_Msk           (0x1U << HRTIM_TIMCR_TAU_Pos)            /*!< 0x00080000 */
#define HRTIM_TIMCR_TAU               HRTIM_TIMCR_TAU_Msk                      /*!< Slave Timer A update reserved for TIM A */
#define HRTIM_TIMCR_TBU_Pos           (20U)                                    
#define HRTIM_TIMCR_TBU_Msk           (0x1U << HRTIM_TIMCR_TBU_Pos)            /*!< 0x00100000 */
#define HRTIM_TIMCR_TBU               HRTIM_TIMCR_TBU_Msk                      /*!< Slave Timer B update reserved for TIM B */
#define HRTIM_TIMCR_TCU_Pos           (21U)                                    
#define HRTIM_TIMCR_TCU_Msk           (0x1U << HRTIM_TIMCR_TCU_Pos)            /*!< 0x00200000 */
#define HRTIM_TIMCR_TCU               HRTIM_TIMCR_TCU_Msk                      /*!< Slave Timer C update reserved for TIM C */
#define HRTIM_TIMCR_TDU_Pos           (22U)                                    
#define HRTIM_TIMCR_TDU_Msk           (0x1U << HRTIM_TIMCR_TDU_Pos)            /*!< 0x00400000 */
#define HRTIM_TIMCR_TDU               HRTIM_TIMCR_TDU_Msk                      /*!< Slave Timer D update reserved for TIM D */
#define HRTIM_TIMCR_TEU_Pos           (23U)                                    
#define HRTIM_TIMCR_TEU_Msk           (0x1U << HRTIM_TIMCR_TEU_Pos)            /*!< 0x00800000 */
#define HRTIM_TIMCR_TEU               HRTIM_TIMCR_TEU_Msk                      /*!< Slave Timer E update reserved for TIM E */
#define HRTIM_TIMCR_MSTU_Pos          (24U)                                    
#define HRTIM_TIMCR_MSTU_Msk          (0x1U << HRTIM_TIMCR_MSTU_Pos)           /*!< 0x01000000 */
#define HRTIM_TIMCR_MSTU              HRTIM_TIMCR_MSTU_Msk                     /*!< Master Update */

#define HRTIM_TIMCR_DACSYNC_Pos       (25U)                                    
#define HRTIM_TIMCR_DACSYNC_Msk       (0x3U << HRTIM_TIMCR_DACSYNC_Pos)        /*!< 0x06000000 */
#define HRTIM_TIMCR_DACSYNC           HRTIM_TIMCR_DACSYNC_Msk                  /*!< DAC sychronization mask */
#define HRTIM_TIMCR_DACSYNC_0         (0x1U << HRTIM_TIMCR_DACSYNC_Pos)        /*!< 0x02000000 */
#define HRTIM_TIMCR_DACSYNC_1         (0x2U << HRTIM_TIMCR_DACSYNC_Pos)        /*!< 0x04000000 */
#define HRTIM_TIMCR_PREEN_Pos         (27U)                                    
#define HRTIM_TIMCR_PREEN_Msk         (0x1U << HRTIM_TIMCR_PREEN_Pos)          /*!< 0x08000000 */
#define HRTIM_TIMCR_PREEN             HRTIM_TIMCR_PREEN_Msk                    /*!< Slave preload enable */

#define HRTIM_TIMCR_UPDGAT_Pos        (28U)                                    
#define HRTIM_TIMCR_UPDGAT_Msk        (0xFU << HRTIM_TIMCR_UPDGAT_Pos)         /*!< 0xF0000000 */
#define HRTIM_TIMCR_UPDGAT            HRTIM_TIMCR_UPDGAT_Msk                   /*!< Slave update gating mask */
#define HRTIM_TIMCR_UPDGAT_0          (0x1U << HRTIM_TIMCR_UPDGAT_Pos)         /*!< 0x10000000 */
#define HRTIM_TIMCR_UPDGAT_1          (0x2U << HRTIM_TIMCR_UPDGAT_Pos)         /*!< 0x20000000 */
#define HRTIM_TIMCR_UPDGAT_2          (0x4U << HRTIM_TIMCR_UPDGAT_Pos)         /*!< 0x40000000 */
#define HRTIM_TIMCR_UPDGAT_3          (0x8U << HRTIM_TIMCR_UPDGAT_Pos)         /*!< 0x80000000 */

/******************** Slave Interrupt status register **************************/
#define HRTIM_TIMISR_CMP1_Pos         (0U)                                     
#define HRTIM_TIMISR_CMP1_Msk         (0x1U << HRTIM_TIMISR_CMP1_Pos)          /*!< 0x00000001 */
#define HRTIM_TIMISR_CMP1             HRTIM_TIMISR_CMP1_Msk                    /*!< Slave compare 1 interrupt flag */
#define HRTIM_TIMISR_CMP2_Pos         (1U)                                     
#define HRTIM_TIMISR_CMP2_Msk         (0x1U << HRTIM_TIMISR_CMP2_Pos)          /*!< 0x00000002 */
#define HRTIM_TIMISR_CMP2             HRTIM_TIMISR_CMP2_Msk                    /*!< Slave compare 2 interrupt flag */
#define HRTIM_TIMISR_CMP3_Pos         (2U)                                     
#define HRTIM_TIMISR_CMP3_Msk         (0x1U << HRTIM_TIMISR_CMP3_Pos)          /*!< 0x00000004 */
#define HRTIM_TIMISR_CMP3             HRTIM_TIMISR_CMP3_Msk                    /*!< Slave compare 3 interrupt flag */
#define HRTIM_TIMISR_CMP4_Pos         (3U)                                     
#define HRTIM_TIMISR_CMP4_Msk         (0x1U << HRTIM_TIMISR_CMP4_Pos)          /*!< 0x00000008 */
#define HRTIM_TIMISR_CMP4             HRTIM_TIMISR_CMP4_Msk                    /*!< Slave compare 4 interrupt flag */
#define HRTIM_TIMISR_REP_Pos          (4U)                                     
#define HRTIM_TIMISR_REP_Msk          (0x1U << HRTIM_TIMISR_REP_Pos)           /*!< 0x00000010 */
#define HRTIM_TIMISR_REP              HRTIM_TIMISR_REP_Msk                     /*!< Slave repetition interrupt flag */
#define HRTIM_TIMISR_UPD_Pos          (6U)                                     
#define HRTIM_TIMISR_UPD_Msk          (0x1U << HRTIM_TIMISR_UPD_Pos)           /*!< 0x00000040 */
#define HRTIM_TIMISR_UPD              HRTIM_TIMISR_UPD_Msk                     /*!< Slave update interrupt flag */
#define HRTIM_TIMISR_CPT1_Pos         (7U)                                     
#define HRTIM_TIMISR_CPT1_Msk         (0x1U << HRTIM_TIMISR_CPT1_Pos)          /*!< 0x00000080 */
#define HRTIM_TIMISR_CPT1             HRTIM_TIMISR_CPT1_Msk                    /*!< Slave capture 1 interrupt flag */
#define HRTIM_TIMISR_CPT2_Pos         (8U)                                     
#define HRTIM_TIMISR_CPT2_Msk         (0x1U << HRTIM_TIMISR_CPT2_Pos)          /*!< 0x00000100 */
#define HRTIM_TIMISR_CPT2             HRTIM_TIMISR_CPT2_Msk                    /*!< Slave capture 2 interrupt flag */
#define HRTIM_TIMISR_SET1_Pos         (9U)                                     
#define HRTIM_TIMISR_SET1_Msk         (0x1U << HRTIM_TIMISR_SET1_Pos)          /*!< 0x00000200 */
#define HRTIM_TIMISR_SET1             HRTIM_TIMISR_SET1_Msk                    /*!< Slave output 1 set interrupt flag */
#define HRTIM_TIMISR_RST1_Pos         (10U)                                    
#define HRTIM_TIMISR_RST1_Msk         (0x1U << HRTIM_TIMISR_RST1_Pos)          /*!< 0x00000400 */
#define HRTIM_TIMISR_RST1             HRTIM_TIMISR_RST1_Msk                    /*!< Slave output 1 reset interrupt flag */
#define HRTIM_TIMISR_SET2_Pos         (11U)                                    
#define HRTIM_TIMISR_SET2_Msk         (0x1U << HRTIM_TIMISR_SET2_Pos)          /*!< 0x00000800 */
#define HRTIM_TIMISR_SET2             HRTIM_TIMISR_SET2_Msk                    /*!< Slave output 2 set interrupt flag */
#define HRTIM_TIMISR_RST2_Pos         (12U)                                    
#define HRTIM_TIMISR_RST2_Msk         (0x1U << HRTIM_TIMISR_RST2_Pos)          /*!< 0x00001000 */
#define HRTIM_TIMISR_RST2             HRTIM_TIMISR_RST2_Msk                    /*!< Slave output 2 reset interrupt flag */
#define HRTIM_TIMISR_RST_Pos          (13U)                                    
#define HRTIM_TIMISR_RST_Msk          (0x1U << HRTIM_TIMISR_RST_Pos)           /*!< 0x00002000 */
#define HRTIM_TIMISR_RST              HRTIM_TIMISR_RST_Msk                     /*!< Slave reset interrupt flag */
#define HRTIM_TIMISR_DLYPRT_Pos       (14U)                                    
#define HRTIM_TIMISR_DLYPRT_Msk       (0x1U << HRTIM_TIMISR_DLYPRT_Pos)        /*!< 0x00004000 */
#define HRTIM_TIMISR_DLYPRT           HRTIM_TIMISR_DLYPRT_Msk                  /*!< Slave output 1 delay protection interrupt flag */
#define HRTIM_TIMISR_CPPSTAT_Pos      (16U)                                    
#define HRTIM_TIMISR_CPPSTAT_Msk      (0x1U << HRTIM_TIMISR_CPPSTAT_Pos)       /*!< 0x00010000 */
#define HRTIM_TIMISR_CPPSTAT          HRTIM_TIMISR_CPPSTAT_Msk                 /*!< Slave current push-pull flag */
#define HRTIM_TIMISR_IPPSTAT_Pos      (17U)                                    
#define HRTIM_TIMISR_IPPSTAT_Msk      (0x1U << HRTIM_TIMISR_IPPSTAT_Pos)       /*!< 0x00020000 */
#define HRTIM_TIMISR_IPPSTAT          HRTIM_TIMISR_IPPSTAT_Msk                 /*!< Slave idle push-pull flag */
#define HRTIM_TIMISR_O1STAT_Pos       (18U)                                    
#define HRTIM_TIMISR_O1STAT_Msk       (0x1U << HRTIM_TIMISR_O1STAT_Pos)        /*!< 0x00040000 */
#define HRTIM_TIMISR_O1STAT           HRTIM_TIMISR_O1STAT_Msk                  /*!< Slave output 1 state flag */
#define HRTIM_TIMISR_O2STAT_Pos       (19U)                                    
#define HRTIM_TIMISR_O2STAT_Msk       (0x1U << HRTIM_TIMISR_O2STAT_Pos)        /*!< 0x00080000 */
#define HRTIM_TIMISR_O2STAT           HRTIM_TIMISR_O2STAT_Msk                  /*!< Slave output 2 state flag */
#define HRTIM_TIMISR_O1CPY_Pos        (20U)                                    
#define HRTIM_TIMISR_O1CPY_Msk        (0x1U << HRTIM_TIMISR_O1CPY_Pos)         /*!< 0x00100000 */
#define HRTIM_TIMISR_O1CPY            HRTIM_TIMISR_O1CPY_Msk                   /*!< Slave output 1 copy flag */
#define HRTIM_TIMISR_O2CPY_Pos        (21U)                                    
#define HRTIM_TIMISR_O2CPY_Msk        (0x1U << HRTIM_TIMISR_O2CPY_Pos)         /*!< 0x00200000 */
#define HRTIM_TIMISR_O2CPY            HRTIM_TIMISR_O2CPY_Msk                   /*!< Slave output 2 copy flag */

/******************** Slave Interrupt clear register **************************/
#define HRTIM_TIMICR_CMP1C_Pos        (0U)                                     
#define HRTIM_TIMICR_CMP1C_Msk        (0x1U << HRTIM_TIMICR_CMP1C_Pos)         /*!< 0x00000001 */
#define HRTIM_TIMICR_CMP1C            HRTIM_TIMICR_CMP1C_Msk                   /*!< Slave compare 1 clear flag */
#define HRTIM_TIMICR_CMP2C_Pos        (1U)                                     
#define HRTIM_TIMICR_CMP2C_Msk        (0x1U << HRTIM_TIMICR_CMP2C_Pos)         /*!< 0x00000002 */
#define HRTIM_TIMICR_CMP2C            HRTIM_TIMICR_CMP2C_Msk                   /*!< Slave compare 2 clear flag */
#define HRTIM_TIMICR_CMP3C_Pos        (2U)                                     
#define HRTIM_TIMICR_CMP3C_Msk        (0x1U << HRTIM_TIMICR_CMP3C_Pos)         /*!< 0x00000004 */
#define HRTIM_TIMICR_CMP3C            HRTIM_TIMICR_CMP3C_Msk                   /*!< Slave compare 3 clear flag */
#define HRTIM_TIMICR_CMP4C_Pos        (3U)                                     
#define HRTIM_TIMICR_CMP4C_Msk        (0x1U << HRTIM_TIMICR_CMP4C_Pos)         /*!< 0x00000008 */
#define HRTIM_TIMICR_CMP4C            HRTIM_TIMICR_CMP4C_Msk                   /*!< Slave compare 4 clear flag */
#define HRTIM_TIMICR_REPC_Pos         (4U)                                     
#define HRTIM_TIMICR_REPC_Msk         (0x1U << HRTIM_TIMICR_REPC_Pos)          /*!< 0x00000010 */
#define HRTIM_TIMICR_REPC             HRTIM_TIMICR_REPC_Msk                    /*!< Slave repetition clear flag */
#define HRTIM_TIMICR_UPDC_Pos         (6U)                                     
#define HRTIM_TIMICR_UPDC_Msk         (0x1U << HRTIM_TIMICR_UPDC_Pos)          /*!< 0x00000040 */
#define HRTIM_TIMICR_UPDC             HRTIM_TIMICR_UPDC_Msk                    /*!< Slave update clear flag */
#define HRTIM_TIMICR_CPT1C_Pos        (7U)                                     
#define HRTIM_TIMICR_CPT1C_Msk        (0x1U << HRTIM_TIMICR_CPT1C_Pos)         /*!< 0x00000080 */
#define HRTIM_TIMICR_CPT1C            HRTIM_TIMICR_CPT1C_Msk                   /*!< Slave capture 1 clear flag */
#define HRTIM_TIMICR_CPT2C_Pos        (8U)                                     
#define HRTIM_TIMICR_CPT2C_Msk        (0x1U << HRTIM_TIMICR_CPT2C_Pos)         /*!< 0x00000100 */
#define HRTIM_TIMICR_CPT2C            HRTIM_TIMICR_CPT2C_Msk                   /*!< Slave capture 2 clear flag */
#define HRTIM_TIMICR_SET1C_Pos        (9U)                                     
#define HRTIM_TIMICR_SET1C_Msk        (0x1U << HRTIM_TIMICR_SET1C_Pos)         /*!< 0x00000200 */
#define HRTIM_TIMICR_SET1C            HRTIM_TIMICR_SET1C_Msk                   /*!< Slave output 1 set clear flag */
#define HRTIM_TIMICR_RST1C_Pos        (10U)                                    
#define HRTIM_TIMICR_RST1C_Msk        (0x1U << HRTIM_TIMICR_RST1C_Pos)         /*!< 0x00000400 */
#define HRTIM_TIMICR_RST1C            HRTIM_TIMICR_RST1C_Msk                   /*!< Slave output 1 reset clear flag */
#define HRTIM_TIMICR_SET2C_Pos        (11U)                                    
#define HRTIM_TIMICR_SET2C_Msk        (0x1U << HRTIM_TIMICR_SET2C_Pos)         /*!< 0x00000800 */
#define HRTIM_TIMICR_SET2C            HRTIM_TIMICR_SET2C_Msk                   /*!< Slave output 2 set clear flag */
#define HRTIM_TIMICR_RST2C_Pos        (12U)                                    
#define HRTIM_TIMICR_RST2C_Msk        (0x1U << HRTIM_TIMICR_RST2C_Pos)         /*!< 0x00001000 */
#define HRTIM_TIMICR_RST2C            HRTIM_TIMICR_RST2C_Msk                   /*!< Slave output 2 reset clear flag */
#define HRTIM_TIMICR_RSTC_Pos         (13U)                                    
#define HRTIM_TIMICR_RSTC_Msk         (0x1U << HRTIM_TIMICR_RSTC_Pos)          /*!< 0x00002000 */
#define HRTIM_TIMICR_RSTC             HRTIM_TIMICR_RSTC_Msk                    /*!< Slave reset clear flag */
#define HRTIM_TIMICR_DLYPRT1C_Pos     (14U)                                    
#define HRTIM_TIMICR_DLYPRT1C_Msk     (0x1U << HRTIM_TIMICR_DLYPRT1C_Pos)      /*!< 0x00004000 */
#define HRTIM_TIMICR_DLYPRT1C         HRTIM_TIMICR_DLYPRT1C_Msk                /*!< Slave output 1 delay protection clear flag */
#define HRTIM_TIMICR_DLYPRT2C_Pos     (15U)                                    
#define HRTIM_TIMICR_DLYPRT2C_Msk     (0x1U << HRTIM_TIMICR_DLYPRT2C_Pos)      /*!< 0x00008000 */
#define HRTIM_TIMICR_DLYPRT2C         HRTIM_TIMICR_DLYPRT2C_Msk                /*!< Slave output 2 delay protection clear flag */

/******************** Slave DMA/Interrupt enable register *********************/
#define HRTIM_TIMDIER_CMP1IE_Pos      (0U)                                     
#define HRTIM_TIMDIER_CMP1IE_Msk      (0x1U << HRTIM_TIMDIER_CMP1IE_Pos)       /*!< 0x00000001 */
#define HRTIM_TIMDIER_CMP1IE          HRTIM_TIMDIER_CMP1IE_Msk                 /*!< Slave compare 1 interrupt enable */
#define HRTIM_TIMDIER_CMP2IE_Pos      (1U)                                     
#define HRTIM_TIMDIER_CMP2IE_Msk      (0x1U << HRTIM_TIMDIER_CMP2IE_Pos)       /*!< 0x00000002 */
#define HRTIM_TIMDIER_CMP2IE          HRTIM_TIMDIER_CMP2IE_Msk                 /*!< Slave compare 2 interrupt enable */
#define HRTIM_TIMDIER_CMP3IE_Pos      (2U)                                     
#define HRTIM_TIMDIER_CMP3IE_Msk      (0x1U << HRTIM_TIMDIER_CMP3IE_Pos)       /*!< 0x00000004 */
#define HRTIM_TIMDIER_CMP3IE          HRTIM_TIMDIER_CMP3IE_Msk                 /*!< Slave compare 3 interrupt enable */
#define HRTIM_TIMDIER_CMP4IE_Pos      (3U)                                     
#define HRTIM_TIMDIER_CMP4IE_Msk      (0x1U << HRTIM_TIMDIER_CMP4IE_Pos)       /*!< 0x00000008 */
#define HRTIM_TIMDIER_CMP4IE          HRTIM_TIMDIER_CMP4IE_Msk                 /*!< Slave compare 4 interrupt enable */
#define HRTIM_TIMDIER_REPIE_Pos       (4U)                                     
#define HRTIM_TIMDIER_REPIE_Msk       (0x1U << HRTIM_TIMDIER_REPIE_Pos)        /*!< 0x00000010 */
#define HRTIM_TIMDIER_REPIE           HRTIM_TIMDIER_REPIE_Msk                  /*!< Slave repetition interrupt enable */
#define HRTIM_TIMDIER_UPDIE_Pos       (6U)                                     
#define HRTIM_TIMDIER_UPDIE_Msk       (0x1U << HRTIM_TIMDIER_UPDIE_Pos)        /*!< 0x00000040 */
#define HRTIM_TIMDIER_UPDIE           HRTIM_TIMDIER_UPDIE_Msk                  /*!< Slave update interrupt enable */
#define HRTIM_TIMDIER_CPT1IE_Pos      (7U)                                     
#define HRTIM_TIMDIER_CPT1IE_Msk      (0x1U << HRTIM_TIMDIER_CPT1IE_Pos)       /*!< 0x00000080 */
#define HRTIM_TIMDIER_CPT1IE          HRTIM_TIMDIER_CPT1IE_Msk                 /*!< Slave capture 1 interrupt enable */
#define HRTIM_TIMDIER_CPT2IE_Pos      (8U)                                     
#define HRTIM_TIMDIER_CPT2IE_Msk      (0x1U << HRTIM_TIMDIER_CPT2IE_Pos)       /*!< 0x00000100 */
#define HRTIM_TIMDIER_CPT2IE          HRTIM_TIMDIER_CPT2IE_Msk                 /*!< Slave capture 2 interrupt enable */
#define HRTIM_TIMDIER_SET1IE_Pos      (9U)                                     
#define HRTIM_TIMDIER_SET1IE_Msk      (0x1U << HRTIM_TIMDIER_SET1IE_Pos)       /*!< 0x00000200 */
#define HRTIM_TIMDIER_SET1IE          HRTIM_TIMDIER_SET1IE_Msk                 /*!< Slave output 1 set interrupt enable */
#define HRTIM_TIMDIER_RST1IE_Pos      (10U)                                    
#define HRTIM_TIMDIER_RST1IE_Msk      (0x1U << HRTIM_TIMDIER_RST1IE_Pos)       /*!< 0x00000400 */
#define HRTIM_TIMDIER_RST1IE          HRTIM_TIMDIER_RST1IE_Msk                 /*!< Slave output 1 reset interrupt enable */
#define HRTIM_TIMDIER_SET2IE_Pos      (11U)                                    
#define HRTIM_TIMDIER_SET2IE_Msk      (0x1U << HRTIM_TIMDIER_SET2IE_Pos)       /*!< 0x00000800 */
#define HRTIM_TIMDIER_SET2IE          HRTIM_TIMDIER_SET2IE_Msk                 /*!< Slave output 2 set interrupt enable */
#define HRTIM_TIMDIER_RST2IE_Pos      (12U)                                    
#define HRTIM_TIMDIER_RST2IE_Msk      (0x1U << HRTIM_TIMDIER_RST2IE_Pos)       /*!< 0x00001000 */
#define HRTIM_TIMDIER_RST2IE          HRTIM_TIMDIER_RST2IE_Msk                 /*!< Slave output 2 reset interrupt enable */
#define HRTIM_TIMDIER_RSTIE_Pos       (13U)                                    
#define HRTIM_TIMDIER_RSTIE_Msk       (0x1U << HRTIM_TIMDIER_RSTIE_Pos)        /*!< 0x00002000 */
#define HRTIM_TIMDIER_RSTIE           HRTIM_TIMDIER_RSTIE_Msk                  /*!< Slave reset interrupt enable */
#define HRTIM_TIMDIER_DLYPRTIE_Pos    (14U)                                    
#define HRTIM_TIMDIER_DLYPRTIE_Msk    (0x1U << HRTIM_TIMDIER_DLYPRTIE_Pos)     /*!< 0x00004000 */
#define HRTIM_TIMDIER_DLYPRTIE        HRTIM_TIMDIER_DLYPRTIE_Msk               /*!< Slave delay protection interrupt enable */

#define HRTIM_TIMDIER_CMP1DE_Pos      (16U)                                    
#define HRTIM_TIMDIER_CMP1DE_Msk      (0x1U << HRTIM_TIMDIER_CMP1DE_Pos)       /*!< 0x00010000 */
#define HRTIM_TIMDIER_CMP1DE          HRTIM_TIMDIER_CMP1DE_Msk                 /*!< Slave compare 1 request enable */
#define HRTIM_TIMDIER_CMP2DE_Pos      (17U)                                    
#define HRTIM_TIMDIER_CMP2DE_Msk      (0x1U << HRTIM_TIMDIER_CMP2DE_Pos)       /*!< 0x00020000 */
#define HRTIM_TIMDIER_CMP2DE          HRTIM_TIMDIER_CMP2DE_Msk                 /*!< Slave compare 2 request enable */
#define HRTIM_TIMDIER_CMP3DE_Pos      (18U)                                    
#define HRTIM_TIMDIER_CMP3DE_Msk      (0x1U << HRTIM_TIMDIER_CMP3DE_Pos)       /*!< 0x00040000 */
#define HRTIM_TIMDIER_CMP3DE          HRTIM_TIMDIER_CMP3DE_Msk                 /*!< Slave compare 3 request enable */
#define HRTIM_TIMDIER_CMP4DE_Pos      (19U)                                    
#define HRTIM_TIMDIER_CMP4DE_Msk      (0x1U << HRTIM_TIMDIER_CMP4DE_Pos)       /*!< 0x00080000 */
#define HRTIM_TIMDIER_CMP4DE          HRTIM_TIMDIER_CMP4DE_Msk                 /*!< Slave compare 4 request enable */
#define HRTIM_TIMDIER_REPDE_Pos       (20U)                                    
#define HRTIM_TIMDIER_REPDE_Msk       (0x1U << HRTIM_TIMDIER_REPDE_Pos)        /*!< 0x00100000 */
#define HRTIM_TIMDIER_REPDE           HRTIM_TIMDIER_REPDE_Msk                  /*!< Slave repetition request enable */
#define HRTIM_TIMDIER_UPDDE_Pos       (22U)                                    
#define HRTIM_TIMDIER_UPDDE_Msk       (0x1U << HRTIM_TIMDIER_UPDDE_Pos)        /*!< 0x00400000 */
#define HRTIM_TIMDIER_UPDDE           HRTIM_TIMDIER_UPDDE_Msk                  /*!< Slave update request enable */
#define HRTIM_TIMDIER_CPT1DE_Pos      (23U)                                    
#define HRTIM_TIMDIER_CPT1DE_Msk      (0x1U << HRTIM_TIMDIER_CPT1DE_Pos)       /*!< 0x00800000 */
#define HRTIM_TIMDIER_CPT1DE          HRTIM_TIMDIER_CPT1DE_Msk                 /*!< Slave capture 1 request enable */
#define HRTIM_TIMDIER_CPT2DE_Pos      (24U)                                    
#define HRTIM_TIMDIER_CPT2DE_Msk      (0x1U << HRTIM_TIMDIER_CPT2DE_Pos)       /*!< 0x01000000 */
#define HRTIM_TIMDIER_CPT2DE          HRTIM_TIMDIER_CPT2DE_Msk                 /*!< Slave capture 2 request enable */
#define HRTIM_TIMDIER_SET1DE_Pos      (25U)                                    
#define HRTIM_TIMDIER_SET1DE_Msk      (0x1U << HRTIM_TIMDIER_SET1DE_Pos)       /*!< 0x02000000 */
#define HRTIM_TIMDIER_SET1DE          HRTIM_TIMDIER_SET1DE_Msk                 /*!< Slave output 1 set request enable */
#define HRTIM_TIMDIER_RST1DE_Pos      (26U)                                    
#define HRTIM_TIMDIER_RST1DE_Msk      (0x1U << HRTIM_TIMDIER_RST1DE_Pos)       /*!< 0x04000000 */
#define HRTIM_TIMDIER_RST1DE          HRTIM_TIMDIER_RST1DE_Msk                 /*!< Slave output 1 reset request enable */
#define HRTIM_TIMDIER_SET2DE_Pos      (27U)                                    
#define HRTIM_TIMDIER_SET2DE_Msk      (0x1U << HRTIM_TIMDIER_SET2DE_Pos)       /*!< 0x08000000 */
#define HRTIM_TIMDIER_SET2DE          HRTIM_TIMDIER_SET2DE_Msk                 /*!< Slave output 2 set request enable */
#define HRTIM_TIMDIER_RST2DE_Pos      (28U)                                    
#define HRTIM_TIMDIER_RST2DE_Msk      (0x1U << HRTIM_TIMDIER_RST2DE_Pos)       /*!< 0x10000000 */
#define HRTIM_TIMDIER_RST2DE          HRTIM_TIMDIER_RST2DE_Msk                 /*!< Slave output 2 reset request enable */
#define HRTIM_TIMDIER_RSTDE_Pos       (29U)                                    
#define HRTIM_TIMDIER_RSTDE_Msk       (0x1U << HRTIM_TIMDIER_RSTDE_Pos)        /*!< 0x20000000 */
#define HRTIM_TIMDIER_RSTDE           HRTIM_TIMDIER_RSTDE_Msk                  /*!< Slave reset request enable */
#define HRTIM_TIMDIER_DLYPRTDE_Pos    (30U)                                    
#define HRTIM_TIMDIER_DLYPRTDE_Msk    (0x1U << HRTIM_TIMDIER_DLYPRTDE_Pos)     /*!< 0x40000000 */
#define HRTIM_TIMDIER_DLYPRTDE        HRTIM_TIMDIER_DLYPRTDE_Msk               /*!< Slavedelay protection request enable */

/******************  Bit definition for HRTIM_CNTR register  ****************/
#define HRTIM_CNTR_CNTR_Pos           (0U)                                     
#define HRTIM_CNTR_CNTR_Msk           (0xFFFFFFFFU << HRTIM_CNTR_CNTR_Pos)     /*!< 0xFFFFFFFF */
#define HRTIM_CNTR_CNTR               HRTIM_CNTR_CNTR_Msk                      /*!< Counter Value */

/*******************  Bit definition for HRTIM_PER register  *****************/
#define HRTIM_PER_PER_Pos             (0U)                                     
#define HRTIM_PER_PER_Msk             (0xFFFFFFFFU << HRTIM_PER_PER_Pos)       /*!< 0xFFFFFFFF */
#define HRTIM_PER_PER                 HRTIM_PER_PER_Msk                        /*!< Period Value */

/*******************  Bit definition for HRTIM_REP register  *****************/
#define HRTIM_REP_REP_Pos             (0U)                                     
#define HRTIM_REP_REP_Msk             (0xFFFFFFFFU << HRTIM_REP_REP_Pos)       /*!< 0xFFFFFFFF */
#define HRTIM_REP_REP                 HRTIM_REP_REP_Msk                        /*!< Repetition Value */

/*******************  Bit definition for HRTIM_CMP1R register  *****************/
#define HRTIM_CMP1R_CMP1R_Pos         (0U)                                     
#define HRTIM_CMP1R_CMP1R_Msk         (0xFFFFFFFFU << HRTIM_CMP1R_CMP1R_Pos)   /*!< 0xFFFFFFFF */
#define HRTIM_CMP1R_CMP1R             HRTIM_CMP1R_CMP1R_Msk                    /*!< Compare Value */

/*******************  Bit definition for HRTIM_CMP1CR register  *****************/
#define HRTIM_CMP1CR_CMP1CR_Pos       (0U)                                     
#define HRTIM_CMP1CR_CMP1CR_Msk       (0xFFFFFFFFU << HRTIM_CMP1CR_CMP1CR_Pos) /*!< 0xFFFFFFFF */
#define HRTIM_CMP1CR_CMP1CR           HRTIM_CMP1CR_CMP1CR_Msk                  /*!< Compare Value */

/*******************  Bit definition for HRTIM_CMP2R register  *****************/
#define HRTIM_CMP2R_CMP2R_Pos         (0U)                                     
#define HRTIM_CMP2R_CMP2R_Msk         (0xFFFFFFFFU << HRTIM_CMP2R_CMP2R_Pos)   /*!< 0xFFFFFFFF */
#define HRTIM_CMP2R_CMP2R             HRTIM_CMP2R_CMP2R_Msk                    /*!< Compare Value */

/*******************  Bit definition for HRTIM_CMP3R register  *****************/
#define HRTIM_CMP3R_CMP3R_Pos         (0U)                                     
#define HRTIM_CMP3R_CMP3R_Msk         (0xFFFFFFFFU << HRTIM_CMP3R_CMP3R_Pos)   /*!< 0xFFFFFFFF */
#define HRTIM_CMP3R_CMP3R             HRTIM_CMP3R_CMP3R_Msk                    /*!< Compare Value */

/*******************  Bit definition for HRTIM_CMP4R register  *****************/
#define HRTIM_CMP4R_CMP4R_Pos         (0U)                                     
#define HRTIM_CMP4R_CMP4R_Msk         (0xFFFFFFFFU << HRTIM_CMP4R_CMP4R_Pos)   /*!< 0xFFFFFFFF */
#define HRTIM_CMP4R_CMP4R             HRTIM_CMP4R_CMP4R_Msk                    /*!< Compare Value */

/*******************  Bit definition for HRTIM_CPT1R register  ****************/
#define HRTIM_CPT1R_CPT1R_Pos         (0U)                                     
#define HRTIM_CPT1R_CPT1R_Msk         (0xFFFFFFFFU << HRTIM_CPT1R_CPT1R_Pos)   /*!< 0xFFFFFFFF */
#define HRTIM_CPT1R_CPT1R             HRTIM_CPT1R_CPT1R_Msk                    /*!< Capture Value */

/*******************  Bit definition for HRTIM_CPT2R register  ****************/
#define HRTIM_CPT2R_CPT2R_Pos         (0U)                                     
#define HRTIM_CPT2R_CPT2R_Msk         (0xFFFFFFFFU << HRTIM_CPT2R_CPT2R_Pos)   /*!< 0xFFFFFFFF */
#define HRTIM_CPT2R_CPT2R             HRTIM_CPT2R_CPT2R_Msk                    /*!< Capture Value */

/******************** Bit definition for Slave Deadtime register **************/
#define HRTIM_DTR_DTR_Pos             (0U)                                     
#define HRTIM_DTR_DTR_Msk             (0x1FFU << HRTIM_DTR_DTR_Pos)            /*!< 0x000001FF */
#define HRTIM_DTR_DTR                 HRTIM_DTR_DTR_Msk                        /*!< Dead time rising value */
#define HRTIM_DTR_DTR_0               (0x001U << HRTIM_DTR_DTR_Pos)            /*!< 0x00000001 */
#define HRTIM_DTR_DTR_1               (0x002U << HRTIM_DTR_DTR_Pos)            /*!< 0x00000002 */
#define HRTIM_DTR_DTR_2               (0x004U << HRTIM_DTR_DTR_Pos)            /*!< 0x00000004 */
#define HRTIM_DTR_DTR_3               (0x008U << HRTIM_DTR_DTR_Pos)            /*!< 0x00000008 */
#define HRTIM_DTR_DTR_4               (0x010U << HRTIM_DTR_DTR_Pos)            /*!< 0x00000010 */
#define HRTIM_DTR_DTR_5               (0x020U << HRTIM_DTR_DTR_Pos)            /*!< 0x00000020 */
#define HRTIM_DTR_DTR_6               (0x040U << HRTIM_DTR_DTR_Pos)            /*!< 0x00000040 */
#define HRTIM_DTR_DTR_7               (0x080U << HRTIM_DTR_DTR_Pos)            /*!< 0x00000080 */
#define HRTIM_DTR_DTR_8               (0x100U << HRTIM_DTR_DTR_Pos)            /*!< 0x00000100 */
#define HRTIM_DTR_SDTR_Pos            (9U)                                     
#define HRTIM_DTR_SDTR_Msk            (0x1U << HRTIM_DTR_SDTR_Pos)             /*!< 0x00000200 */
#define HRTIM_DTR_SDTR                HRTIM_DTR_SDTR_Msk                       /*!< Sign dead time rising value */
#define HRTIM_DTR_DTPRSC_Pos          (10U)                                    
#define HRTIM_DTR_DTPRSC_Msk          (0x7U << HRTIM_DTR_DTPRSC_Pos)           /*!< 0x00001C00 */
#define HRTIM_DTR_DTPRSC              HRTIM_DTR_DTPRSC_Msk                     /*!< Dead time prescaler */
#define HRTIM_DTR_DTPRSC_0            (0x1U << HRTIM_DTR_DTPRSC_Pos)           /*!< 0x00000400 */
#define HRTIM_DTR_DTPRSC_1            (0x2U << HRTIM_DTR_DTPRSC_Pos)           /*!< 0x00000800 */
#define HRTIM_DTR_DTPRSC_2            (0x4U << HRTIM_DTR_DTPRSC_Pos)           /*!< 0x00001000 */
#define HRTIM_DTR_DTRSLK_Pos          (14U)                                    
#define HRTIM_DTR_DTRSLK_Msk          (0x1U << HRTIM_DTR_DTRSLK_Pos)           /*!< 0x00004000 */
#define HRTIM_DTR_DTRSLK              HRTIM_DTR_DTRSLK_Msk                     /*!< Dead time rising sign lock */
#define HRTIM_DTR_DTRLK_Pos           (15U)                                    
#define HRTIM_DTR_DTRLK_Msk           (0x1U << HRTIM_DTR_DTRLK_Pos)            /*!< 0x00008000 */
#define HRTIM_DTR_DTRLK               HRTIM_DTR_DTRLK_Msk                      /*!< Dead time rising lock */
#define HRTIM_DTR_DTF_Pos             (16U)                                    
#define HRTIM_DTR_DTF_Msk             (0x1FFU << HRTIM_DTR_DTF_Pos)            /*!< 0x01FF0000 */
#define HRTIM_DTR_DTF                 HRTIM_DTR_DTF_Msk                        /*!< Dead time falling value */
#define HRTIM_DTR_DTF_0               (0x001U << HRTIM_DTR_DTF_Pos)            /*!< 0x00010000 */
#define HRTIM_DTR_DTF_1               (0x002U << HRTIM_DTR_DTF_Pos)            /*!< 0x00020000 */
#define HRTIM_DTR_DTF_2               (0x004U << HRTIM_DTR_DTF_Pos)            /*!< 0x00040000 */
#define HRTIM_DTR_DTF_3               (0x008U << HRTIM_DTR_DTF_Pos)            /*!< 0x00080000 */
#define HRTIM_DTR_DTF_4               (0x010U << HRTIM_DTR_DTF_Pos)            /*!< 0x00100000 */
#define HRTIM_DTR_DTF_5               (0x020U << HRTIM_DTR_DTF_Pos)            /*!< 0x00200000 */
#define HRTIM_DTR_DTF_6               (0x040U << HRTIM_DTR_DTF_Pos)            /*!< 0x00400000 */
#define HRTIM_DTR_DTF_7               (0x080U << HRTIM_DTR_DTF_Pos)            /*!< 0x00800000 */
#define HRTIM_DTR_DTF_8               (0x100U << HRTIM_DTR_DTF_Pos)            /*!< 0x01000000 */
#define HRTIM_DTR_SDTF_Pos            (25U)                                    
#define HRTIM_DTR_SDTF_Msk            (0x1U << HRTIM_DTR_SDTF_Pos)             /*!< 0x02000000 */
#define HRTIM_DTR_SDTF                HRTIM_DTR_SDTF_Msk                       /*!< Sign dead time falling value */
#define HRTIM_DTR_DTFSLK_Pos          (30U)                                    
#define HRTIM_DTR_DTFSLK_Msk          (0x1U << HRTIM_DTR_DTFSLK_Pos)           /*!< 0x40000000 */
#define HRTIM_DTR_DTFSLK              HRTIM_DTR_DTFSLK_Msk                     /*!< Dead time falling sign lock */
#define HRTIM_DTR_DTFLK_Pos           (31U)                                    
#define HRTIM_DTR_DTFLK_Msk           (0x1U << HRTIM_DTR_DTFLK_Pos)            /*!< 0x80000000 */
#define HRTIM_DTR_DTFLK               HRTIM_DTR_DTFLK_Msk                      /*!< Dead time falling lock */

/**** Bit definition for Slave Output 1 set register **************************/
#define HRTIM_SET1R_SST_Pos           (0U)                                     
#define HRTIM_SET1R_SST_Msk           (0x1U << HRTIM_SET1R_SST_Pos)            /*!< 0x00000001 */
#define HRTIM_SET1R_SST               HRTIM_SET1R_SST_Msk                      /*!< software set trigger */
#define HRTIM_SET1R_RESYNC_Pos        (1U)                                     
#define HRTIM_SET1R_RESYNC_Msk        (0x1U << HRTIM_SET1R_RESYNC_Pos)         /*!< 0x00000002 */
#define HRTIM_SET1R_RESYNC            HRTIM_SET1R_RESYNC_Msk                   /*!< Timer A resynchronization */
#define HRTIM_SET1R_PER_Pos           (2U)                                     
#define HRTIM_SET1R_PER_Msk           (0x1U << HRTIM_SET1R_PER_Pos)            /*!< 0x00000004 */
#define HRTIM_SET1R_PER               HRTIM_SET1R_PER_Msk                      /*!< Timer A period */
#define HRTIM_SET1R_CMP1_Pos          (3U)                                     
#define HRTIM_SET1R_CMP1_Msk          (0x1U << HRTIM_SET1R_CMP1_Pos)           /*!< 0x00000008 */
#define HRTIM_SET1R_CMP1              HRTIM_SET1R_CMP1_Msk                     /*!< Timer A compare 1 */
#define HRTIM_SET1R_CMP2_Pos          (4U)                                     
#define HRTIM_SET1R_CMP2_Msk          (0x1U << HRTIM_SET1R_CMP2_Pos)           /*!< 0x00000010 */
#define HRTIM_SET1R_CMP2              HRTIM_SET1R_CMP2_Msk                     /*!< Timer A compare 2 */
#define HRTIM_SET1R_CMP3_Pos          (5U)                                     
#define HRTIM_SET1R_CMP3_Msk          (0x1U << HRTIM_SET1R_CMP3_Pos)           /*!< 0x00000020 */
#define HRTIM_SET1R_CMP3              HRTIM_SET1R_CMP3_Msk                     /*!< Timer A compare 3 */
#define HRTIM_SET1R_CMP4_Pos          (6U)                                     
#define HRTIM_SET1R_CMP4_Msk          (0x1U << HRTIM_SET1R_CMP4_Pos)           /*!< 0x00000040 */
#define HRTIM_SET1R_CMP4              HRTIM_SET1R_CMP4_Msk                     /*!< Timer A compare 4 */

#define HRTIM_SET1R_MSTPER_Pos        (7U)                                     
#define HRTIM_SET1R_MSTPER_Msk        (0x1U << HRTIM_SET1R_MSTPER_Pos)         /*!< 0x00000080 */
#define HRTIM_SET1R_MSTPER            HRTIM_SET1R_MSTPER_Msk                   /*!< Master period */
#define HRTIM_SET1R_MSTCMP1_Pos       (8U)                                     
#define HRTIM_SET1R_MSTCMP1_Msk       (0x1U << HRTIM_SET1R_MSTCMP1_Pos)        /*!< 0x00000100 */
#define HRTIM_SET1R_MSTCMP1           HRTIM_SET1R_MSTCMP1_Msk                  /*!< Master compare 1 */
#define HRTIM_SET1R_MSTCMP2_Pos       (9U)                                     
#define HRTIM_SET1R_MSTCMP2_Msk       (0x1U << HRTIM_SET1R_MSTCMP2_Pos)        /*!< 0x00000200 */
#define HRTIM_SET1R_MSTCMP2           HRTIM_SET1R_MSTCMP2_Msk                  /*!< Master compare 2 */
#define HRTIM_SET1R_MSTCMP3_Pos       (10U)                                    
#define HRTIM_SET1R_MSTCMP3_Msk       (0x1U << HRTIM_SET1R_MSTCMP3_Pos)        /*!< 0x00000400 */
#define HRTIM_SET1R_MSTCMP3           HRTIM_SET1R_MSTCMP3_Msk                  /*!< Master compare 3 */
#define HRTIM_SET1R_MSTCMP4_Pos       (11U)                                    
#define HRTIM_SET1R_MSTCMP4_Msk       (0x1U << HRTIM_SET1R_MSTCMP4_Pos)        /*!< 0x00000800 */
#define HRTIM_SET1R_MSTCMP4           HRTIM_SET1R_MSTCMP4_Msk                  /*!< Master compare 4 */

#define HRTIM_SET1R_TIMEVNT1_Pos      (12U)                                    
#define HRTIM_SET1R_TIMEVNT1_Msk      (0x1U << HRTIM_SET1R_TIMEVNT1_Pos)       /*!< 0x00001000 */
#define HRTIM_SET1R_TIMEVNT1          HRTIM_SET1R_TIMEVNT1_Msk                 /*!< Timer event 1 */
#define HRTIM_SET1R_TIMEVNT2_Pos      (13U)                                    
#define HRTIM_SET1R_TIMEVNT2_Msk      (0x1U << HRTIM_SET1R_TIMEVNT2_Pos)       /*!< 0x00002000 */
#define HRTIM_SET1R_TIMEVNT2          HRTIM_SET1R_TIMEVNT2_Msk                 /*!< Timer event 2 */
#define HRTIM_SET1R_TIMEVNT3_Pos      (14U)                                    
#define HRTIM_SET1R_TIMEVNT3_Msk      (0x1U << HRTIM_SET1R_TIMEVNT3_Pos)       /*!< 0x00004000 */
#define HRTIM_SET1R_TIMEVNT3          HRTIM_SET1R_TIMEVNT3_Msk                 /*!< Timer event 3 */
#define HRTIM_SET1R_TIMEVNT4_Pos      (15U)                                    
#define HRTIM_SET1R_TIMEVNT4_Msk      (0x1U << HRTIM_SET1R_TIMEVNT4_Pos)       /*!< 0x00008000 */
#define HRTIM_SET1R_TIMEVNT4          HRTIM_SET1R_TIMEVNT4_Msk                 /*!< Timer event 4 */
#define HRTIM_SET1R_TIMEVNT5_Pos      (16U)                                    
#define HRTIM_SET1R_TIMEVNT5_Msk      (0x1U << HRTIM_SET1R_TIMEVNT5_Pos)       /*!< 0x00010000 */
#define HRTIM_SET1R_TIMEVNT5          HRTIM_SET1R_TIMEVNT5_Msk                 /*!< Timer event 5 */
#define HRTIM_SET1R_TIMEVNT6_Pos      (17U)                                    
#define HRTIM_SET1R_TIMEVNT6_Msk      (0x1U << HRTIM_SET1R_TIMEVNT6_Pos)       /*!< 0x00020000 */
#define HRTIM_SET1R_TIMEVNT6          HRTIM_SET1R_TIMEVNT6_Msk                 /*!< Timer event 6 */
#define HRTIM_SET1R_TIMEVNT7_Pos      (18U)                                    
#define HRTIM_SET1R_TIMEVNT7_Msk      (0x1U << HRTIM_SET1R_TIMEVNT7_Pos)       /*!< 0x00040000 */
#define HRTIM_SET1R_TIMEVNT7          HRTIM_SET1R_TIMEVNT7_Msk                 /*!< Timer event 7 */
#define HRTIM_SET1R_TIMEVNT8_Pos      (19U)                                    
#define HRTIM_SET1R_TIMEVNT8_Msk      (0x1U << HRTIM_SET1R_TIMEVNT8_Pos)       /*!< 0x00080000 */
#define HRTIM_SET1R_TIMEVNT8          HRTIM_SET1R_TIMEVNT8_Msk                 /*!< Timer event 8 */
#define HRTIM_SET1R_TIMEVNT9_Pos      (20U)                                    
#define HRTIM_SET1R_TIMEVNT9_Msk      (0x1U << HRTIM_SET1R_TIMEVNT9_Pos)       /*!< 0x00100000 */
#define HRTIM_SET1R_TIMEVNT9          HRTIM_SET1R_TIMEVNT9_Msk                 /*!< Timer event 9 */

#define HRTIM_SET1R_EXTVNT1_Pos       (21U)                                    
#define HRTIM_SET1R_EXTVNT1_Msk       (0x1U << HRTIM_SET1R_EXTVNT1_Pos)        /*!< 0x00200000 */
#define HRTIM_SET1R_EXTVNT1           HRTIM_SET1R_EXTVNT1_Msk                  /*!< External event 1 */
#define HRTIM_SET1R_EXTVNT2_Pos       (22U)                                    
#define HRTIM_SET1R_EXTVNT2_Msk       (0x1U << HRTIM_SET1R_EXTVNT2_Pos)        /*!< 0x00400000 */
#define HRTIM_SET1R_EXTVNT2           HRTIM_SET1R_EXTVNT2_Msk                  /*!< External event 2 */
#define HRTIM_SET1R_EXTVNT3_Pos       (23U)                                    
#define HRTIM_SET1R_EXTVNT3_Msk       (0x1U << HRTIM_SET1R_EXTVNT3_Pos)        /*!< 0x00800000 */
#define HRTIM_SET1R_EXTVNT3           HRTIM_SET1R_EXTVNT3_Msk                  /*!< External event 3 */
#define HRTIM_SET1R_EXTVNT4_Pos       (24U)                                    
#define HRTIM_SET1R_EXTVNT4_Msk       (0x1U << HRTIM_SET1R_EXTVNT4_Pos)        /*!< 0x01000000 */
#define HRTIM_SET1R_EXTVNT4           HRTIM_SET1R_EXTVNT4_Msk                  /*!< External event 4 */
#define HRTIM_SET1R_EXTVNT5_Pos       (25U)                                    
#define HRTIM_SET1R_EXTVNT5_Msk       (0x1U << HRTIM_SET1R_EXTVNT5_Pos)        /*!< 0x02000000 */
#define HRTIM_SET1R_EXTVNT5           HRTIM_SET1R_EXTVNT5_Msk                  /*!< External event 5 */
#define HRTIM_SET1R_EXTVNT6_Pos       (26U)                                    
#define HRTIM_SET1R_EXTVNT6_Msk       (0x1U << HRTIM_SET1R_EXTVNT6_Pos)        /*!< 0x04000000 */
#define HRTIM_SET1R_EXTVNT6           HRTIM_SET1R_EXTVNT6_Msk                  /*!< External event 6 */
#define HRTIM_SET1R_EXTVNT7_Pos       (27U)                                    
#define HRTIM_SET1R_EXTVNT7_Msk       (0x1U << HRTIM_SET1R_EXTVNT7_Pos)        /*!< 0x08000000 */
#define HRTIM_SET1R_EXTVNT7           HRTIM_SET1R_EXTVNT7_Msk                  /*!< External event 7 */
#define HRTIM_SET1R_EXTVNT8_Pos       (28U)                                    
#define HRTIM_SET1R_EXTVNT8_Msk       (0x1U << HRTIM_SET1R_EXTVNT8_Pos)        /*!< 0x10000000 */
#define HRTIM_SET1R_EXTVNT8           HRTIM_SET1R_EXTVNT8_Msk                  /*!< External event 8 */
#define HRTIM_SET1R_EXTVNT9_Pos       (29U)                                    
#define HRTIM_SET1R_EXTVNT9_Msk       (0x1U << HRTIM_SET1R_EXTVNT9_Pos)        /*!< 0x20000000 */
#define HRTIM_SET1R_EXTVNT9           HRTIM_SET1R_EXTVNT9_Msk                  /*!< External event 9 */
#define HRTIM_SET1R_EXTVNT10_Pos      (30U)                                    
#define HRTIM_SET1R_EXTVNT10_Msk      (0x1U << HRTIM_SET1R_EXTVNT10_Pos)       /*!< 0x40000000 */
#define HRTIM_SET1R_EXTVNT10          HRTIM_SET1R_EXTVNT10_Msk                 /*!< External event 10 */

#define HRTIM_SET1R_UPDATE_Pos        (31U)                                    
#define HRTIM_SET1R_UPDATE_Msk        (0x1U << HRTIM_SET1R_UPDATE_Pos)         /*!< 0x80000000 */
#define HRTIM_SET1R_UPDATE            HRTIM_SET1R_UPDATE_Msk                   /*!< Register update (transfer preload to active) */

/**** Bit definition for Slave Output 1 reset register ************************/
#define HRTIM_RST1R_SRT_Pos           (0U)                                     
#define HRTIM_RST1R_SRT_Msk           (0x1U << HRTIM_RST1R_SRT_Pos)            /*!< 0x00000001 */
#define HRTIM_RST1R_SRT               HRTIM_RST1R_SRT_Msk                      /*!< software reset trigger */
#define HRTIM_RST1R_RESYNC_Pos        (1U)                                     
#define HRTIM_RST1R_RESYNC_Msk        (0x1U << HRTIM_RST1R_RESYNC_Pos)         /*!< 0x00000002 */
#define HRTIM_RST1R_RESYNC            HRTIM_RST1R_RESYNC_Msk                   /*!< Timer A resynchronization */
#define HRTIM_RST1R_PER_Pos           (2U)                                     
#define HRTIM_RST1R_PER_Msk           (0x1U << HRTIM_RST1R_PER_Pos)            /*!< 0x00000004 */
#define HRTIM_RST1R_PER               HRTIM_RST1R_PER_Msk                      /*!< Timer A period */
#define HRTIM_RST1R_CMP1_Pos          (3U)                                     
#define HRTIM_RST1R_CMP1_Msk          (0x1U << HRTIM_RST1R_CMP1_Pos)           /*!< 0x00000008 */
#define HRTIM_RST1R_CMP1              HRTIM_RST1R_CMP1_Msk                     /*!< Timer A compare 1 */
#define HRTIM_RST1R_CMP2_Pos          (4U)                                     
#define HRTIM_RST1R_CMP2_Msk          (0x1U << HRTIM_RST1R_CMP2_Pos)           /*!< 0x00000010 */
#define HRTIM_RST1R_CMP2              HRTIM_RST1R_CMP2_Msk                     /*!< Timer A compare 2 */
#define HRTIM_RST1R_CMP3_Pos          (5U)                                     
#define HRTIM_RST1R_CMP3_Msk          (0x1U << HRTIM_RST1R_CMP3_Pos)           /*!< 0x00000020 */
#define HRTIM_RST1R_CMP3              HRTIM_RST1R_CMP3_Msk                     /*!< Timer A compare 3 */
#define HRTIM_RST1R_CMP4_Pos          (6U)                                     
#define HRTIM_RST1R_CMP4_Msk          (0x1U << HRTIM_RST1R_CMP4_Pos)           /*!< 0x00000040 */
#define HRTIM_RST1R_CMP4              HRTIM_RST1R_CMP4_Msk                     /*!< Timer A compare 4 */

#define HRTIM_RST1R_MSTPER_Pos        (7U)                                     
#define HRTIM_RST1R_MSTPER_Msk        (0x1U << HRTIM_RST1R_MSTPER_Pos)         /*!< 0x00000080 */
#define HRTIM_RST1R_MSTPER            HRTIM_RST1R_MSTPER_Msk                   /*!< Master period */
#define HRTIM_RST1R_MSTCMP1_Pos       (8U)                                     
#define HRTIM_RST1R_MSTCMP1_Msk       (0x1U << HRTIM_RST1R_MSTCMP1_Pos)        /*!< 0x00000100 */
#define HRTIM_RST1R_MSTCMP1           HRTIM_RST1R_MSTCMP1_Msk                  /*!< Master compare 1 */
#define HRTIM_RST1R_MSTCMP2_Pos       (9U)                                     
#define HRTIM_RST1R_MSTCMP2_Msk       (0x1U << HRTIM_RST1R_MSTCMP2_Pos)        /*!< 0x00000200 */
#define HRTIM_RST1R_MSTCMP2           HRTIM_RST1R_MSTCMP2_Msk                  /*!< Master compare 2 */
#define HRTIM_RST1R_MSTCMP3_Pos       (10U)                                    
#define HRTIM_RST1R_MSTCMP3_Msk       (0x1U << HRTIM_RST1R_MSTCMP3_Pos)        /*!< 0x00000400 */
#define HRTIM_RST1R_MSTCMP3           HRTIM_RST1R_MSTCMP3_Msk                  /*!< Master compare 3 */
#define HRTIM_RST1R_MSTCMP4_Pos       (11U)                                    
#define HRTIM_RST1R_MSTCMP4_Msk       (0x1U << HRTIM_RST1R_MSTCMP4_Pos)        /*!< 0x00000800 */
#define HRTIM_RST1R_MSTCMP4           HRTIM_RST1R_MSTCMP4_Msk                  /*!< Master compare 4 */

#define HRTIM_RST1R_TIMEVNT1_Pos      (12U)                                    
#define HRTIM_RST1R_TIMEVNT1_Msk      (0x1U << HRTIM_RST1R_TIMEVNT1_Pos)       /*!< 0x00001000 */
#define HRTIM_RST1R_TIMEVNT1          HRTIM_RST1R_TIMEVNT1_Msk                 /*!< Timer event 1 */
#define HRTIM_RST1R_TIMEVNT2_Pos      (13U)                                    
#define HRTIM_RST1R_TIMEVNT2_Msk      (0x1U << HRTIM_RST1R_TIMEVNT2_Pos)       /*!< 0x00002000 */
#define HRTIM_RST1R_TIMEVNT2          HRTIM_RST1R_TIMEVNT2_Msk                 /*!< Timer event 2 */
#define HRTIM_RST1R_TIMEVNT3_Pos      (14U)                                    
#define HRTIM_RST1R_TIMEVNT3_Msk      (0x1U << HRTIM_RST1R_TIMEVNT3_Pos)       /*!< 0x00004000 */
#define HRTIM_RST1R_TIMEVNT3          HRTIM_RST1R_TIMEVNT3_Msk                 /*!< Timer event 3 */
#define HRTIM_RST1R_TIMEVNT4_Pos      (15U)                                    
#define HRTIM_RST1R_TIMEVNT4_Msk      (0x1U << HRTIM_RST1R_TIMEVNT4_Pos)       /*!< 0x00008000 */
#define HRTIM_RST1R_TIMEVNT4          HRTIM_RST1R_TIMEVNT4_Msk                 /*!< Timer event 4 */
#define HRTIM_RST1R_TIMEVNT5_Pos      (16U)                                    
#define HRTIM_RST1R_TIMEVNT5_Msk      (0x1U << HRTIM_RST1R_TIMEVNT5_Pos)       /*!< 0x00010000 */
#define HRTIM_RST1R_TIMEVNT5          HRTIM_RST1R_TIMEVNT5_Msk                 /*!< Timer event 5 */
#define HRTIM_RST1R_TIMEVNT6_Pos      (17U)                                    
#define HRTIM_RST1R_TIMEVNT6_Msk      (0x1U << HRTIM_RST1R_TIMEVNT6_Pos)       /*!< 0x00020000 */
#define HRTIM_RST1R_TIMEVNT6          HRTIM_RST1R_TIMEVNT6_Msk                 /*!< Timer event 6 */
#define HRTIM_RST1R_TIMEVNT7_Pos      (18U)                                    
#define HRTIM_RST1R_TIMEVNT7_Msk      (0x1U << HRTIM_RST1R_TIMEVNT7_Pos)       /*!< 0x00040000 */
#define HRTIM_RST1R_TIMEVNT7          HRTIM_RST1R_TIMEVNT7_Msk                 /*!< Timer event 7 */
#define HRTIM_RST1R_TIMEVNT8_Pos      (19U)                                    
#define HRTIM_RST1R_TIMEVNT8_Msk      (0x1U << HRTIM_RST1R_TIMEVNT8_Pos)       /*!< 0x00080000 */
#define HRTIM_RST1R_TIMEVNT8          HRTIM_RST1R_TIMEVNT8_Msk                 /*!< Timer event 8 */
#define HRTIM_RST1R_TIMEVNT9_Pos      (20U)                                    
#define HRTIM_RST1R_TIMEVNT9_Msk      (0x1U << HRTIM_RST1R_TIMEVNT9_Pos)       /*!< 0x00100000 */
#define HRTIM_RST1R_TIMEVNT9          HRTIM_RST1R_TIMEVNT9_Msk                 /*!< Timer event 9 */

#define HRTIM_RST1R_EXTVNT1_Pos       (21U)                                    
#define HRTIM_RST1R_EXTVNT1_Msk       (0x1U << HRTIM_RST1R_EXTVNT1_Pos)        /*!< 0x00200000 */
#define HRTIM_RST1R_EXTVNT1           HRTIM_RST1R_EXTVNT1_Msk                  /*!< External event 1 */
#define HRTIM_RST1R_EXTVNT2_Pos       (22U)                                    
#define HRTIM_RST1R_EXTVNT2_Msk       (0x1U << HRTIM_RST1R_EXTVNT2_Pos)        /*!< 0x00400000 */
#define HRTIM_RST1R_EXTVNT2           HRTIM_RST1R_EXTVNT2_Msk                  /*!< External event 2 */
#define HRTIM_RST1R_EXTVNT3_Pos       (23U)                                    
#define HRTIM_RST1R_EXTVNT3_Msk       (0x1U << HRTIM_RST1R_EXTVNT3_Pos)        /*!< 0x00800000 */
#define HRTIM_RST1R_EXTVNT3           HRTIM_RST1R_EXTVNT3_Msk                  /*!< External event 3 */
#define HRTIM_RST1R_EXTVNT4_Pos       (24U)                                    
#define HRTIM_RST1R_EXTVNT4_Msk       (0x1U << HRTIM_RST1R_EXTVNT4_Pos)        /*!< 0x01000000 */
#define HRTIM_RST1R_EXTVNT4           HRTIM_RST1R_EXTVNT4_Msk                  /*!< External event 4 */
#define HRTIM_RST1R_EXTVNT5_Pos       (25U)                                    
#define HRTIM_RST1R_EXTVNT5_Msk       (0x1U << HRTIM_RST1R_EXTVNT5_Pos)        /*!< 0x02000000 */
#define HRTIM_RST1R_EXTVNT5           HRTIM_RST1R_EXTVNT5_Msk                  /*!< External event 5 */
#define HRTIM_RST1R_EXTVNT6_Pos       (26U)                                    
#define HRTIM_RST1R_EXTVNT6_Msk       (0x1U << HRTIM_RST1R_EXTVNT6_Pos)        /*!< 0x04000000 */
#define HRTIM_RST1R_EXTVNT6           HRTIM_RST1R_EXTVNT6_Msk                  /*!< External event 6 */
#define HRTIM_RST1R_EXTVNT7_Pos       (27U)                                    
#define HRTIM_RST1R_EXTVNT7_Msk       (0x1U << HRTIM_RST1R_EXTVNT7_Pos)        /*!< 0x08000000 */
#define HRTIM_RST1R_EXTVNT7           HRTIM_RST1R_EXTVNT7_Msk                  /*!< External event 7 */
#define HRTIM_RST1R_EXTVNT8_Pos       (28U)                                    
#define HRTIM_RST1R_EXTVNT8_Msk       (0x1U << HRTIM_RST1R_EXTVNT8_Pos)        /*!< 0x10000000 */
#define HRTIM_RST1R_EXTVNT8           HRTIM_RST1R_EXTVNT8_Msk                  /*!< External event 8 */
#define HRTIM_RST1R_EXTVNT9_Pos       (29U)                                    
#define HRTIM_RST1R_EXTVNT9_Msk       (0x1U << HRTIM_RST1R_EXTVNT9_Pos)        /*!< 0x20000000 */
#define HRTIM_RST1R_EXTVNT9           HRTIM_RST1R_EXTVNT9_Msk                  /*!< External event 9 */
#define HRTIM_RST1R_EXTVNT10_Pos      (30U)                                    
#define HRTIM_RST1R_EXTVNT10_Msk      (0x1U << HRTIM_RST1R_EXTVNT10_Pos)       /*!< 0x40000000 */
#define HRTIM_RST1R_EXTVNT10          HRTIM_RST1R_EXTVNT10_Msk                 /*!< External event 10 */

#define HRTIM_RST1R_UPDATE_Pos        (31U)                                    
#define HRTIM_RST1R_UPDATE_Msk        (0x1U << HRTIM_RST1R_UPDATE_Pos)         /*!< 0x80000000 */
#define HRTIM_RST1R_UPDATE            HRTIM_RST1R_UPDATE_Msk                   /*!< Register update (transfer preload to active) */


/**** Bit definition for Slave Output 2 set register **************************/
#define HRTIM_SET2R_SST_Pos           (0U)                                     
#define HRTIM_SET2R_SST_Msk           (0x1U << HRTIM_SET2R_SST_Pos)            /*!< 0x00000001 */
#define HRTIM_SET2R_SST               HRTIM_SET2R_SST_Msk                      /*!< software set trigger */
#define HRTIM_SET2R_RESYNC_Pos        (1U)                                     
#define HRTIM_SET2R_RESYNC_Msk        (0x1U << HRTIM_SET2R_RESYNC_Pos)         /*!< 0x00000002 */
#define HRTIM_SET2R_RESYNC            HRTIM_SET2R_RESYNC_Msk                   /*!< Timer A resynchronization */
#define HRTIM_SET2R_PER_Pos           (2U)                                     
#define HRTIM_SET2R_PER_Msk           (0x1U << HRTIM_SET2R_PER_Pos)            /*!< 0x00000004 */
#define HRTIM_SET2R_PER               HRTIM_SET2R_PER_Msk                      /*!< Timer A period */
#define HRTIM_SET2R_CMP1_Pos          (3U)                                     
#define HRTIM_SET2R_CMP1_Msk          (0x1U << HRTIM_SET2R_CMP1_Pos)           /*!< 0x00000008 */
#define HRTIM_SET2R_CMP1              HRTIM_SET2R_CMP1_Msk                     /*!< Timer A compare 1 */
#define HRTIM_SET2R_CMP2_Pos          (4U)                                     
#define HRTIM_SET2R_CMP2_Msk          (0x1U << HRTIM_SET2R_CMP2_Pos)           /*!< 0x00000010 */
#define HRTIM_SET2R_CMP2              HRTIM_SET2R_CMP2_Msk                     /*!< Timer A compare 2 */
#define HRTIM_SET2R_CMP3_Pos          (5U)                                     
#define HRTIM_SET2R_CMP3_Msk          (0x1U << HRTIM_SET2R_CMP3_Pos)           /*!< 0x00000020 */
#define HRTIM_SET2R_CMP3              HRTIM_SET2R_CMP3_Msk                     /*!< Timer A compare 3 */
#define HRTIM_SET2R_CMP4_Pos          (6U)                                     
#define HRTIM_SET2R_CMP4_Msk          (0x1U << HRTIM_SET2R_CMP4_Pos)           /*!< 0x00000040 */
#define HRTIM_SET2R_CMP4              HRTIM_SET2R_CMP4_Msk                     /*!< Timer A compare 4 */

#define HRTIM_SET2R_MSTPER_Pos        (7U)                                     
#define HRTIM_SET2R_MSTPER_Msk        (0x1U << HRTIM_SET2R_MSTPER_Pos)         /*!< 0x00000080 */
#define HRTIM_SET2R_MSTPER            HRTIM_SET2R_MSTPER_Msk                   /*!< Master period */
#define HRTIM_SET2R_MSTCMP1_Pos       (8U)                                     
#define HRTIM_SET2R_MSTCMP1_Msk       (0x1U << HRTIM_SET2R_MSTCMP1_Pos)        /*!< 0x00000100 */
#define HRTIM_SET2R_MSTCMP1           HRTIM_SET2R_MSTCMP1_Msk                  /*!< Master compare 1 */
#define HRTIM_SET2R_MSTCMP2_Pos       (9U)                                     
#define HRTIM_SET2R_MSTCMP2_Msk       (0x1U << HRTIM_SET2R_MSTCMP2_Pos)        /*!< 0x00000200 */
#define HRTIM_SET2R_MSTCMP2           HRTIM_SET2R_MSTCMP2_Msk                  /*!< Master compare 2 */
#define HRTIM_SET2R_MSTCMP3_Pos       (10U)                                    
#define HRTIM_SET2R_MSTCMP3_Msk       (0x1U << HRTIM_SET2R_MSTCMP3_Pos)        /*!< 0x00000400 */
#define HRTIM_SET2R_MSTCMP3           HRTIM_SET2R_MSTCMP3_Msk                  /*!< Master compare 3 */
#define HRTIM_SET2R_MSTCMP4_Pos       (11U)                                    
#define HRTIM_SET2R_MSTCMP4_Msk       (0x1U << HRTIM_SET2R_MSTCMP4_Pos)        /*!< 0x00000800 */
#define HRTIM_SET2R_MSTCMP4           HRTIM_SET2R_MSTCMP4_Msk                  /*!< Master compare 4 */

#define HRTIM_SET2R_TIMEVNT1_Pos      (12U)                                    
#define HRTIM_SET2R_TIMEVNT1_Msk      (0x1U << HRTIM_SET2R_TIMEVNT1_Pos)       /*!< 0x00001000 */
#define HRTIM_SET2R_TIMEVNT1          HRTIM_SET2R_TIMEVNT1_Msk                 /*!< Timer event 1 */
#define HRTIM_SET2R_TIMEVNT2_Pos      (13U)                                    
#define HRTIM_SET2R_TIMEVNT2_Msk      (0x1U << HRTIM_SET2R_TIMEVNT2_Pos)       /*!< 0x00002000 */
#define HRTIM_SET2R_TIMEVNT2          HRTIM_SET2R_TIMEVNT2_Msk                 /*!< Timer event 2 */
#define HRTIM_SET2R_TIMEVNT3_Pos      (14U)                                    
#define HRTIM_SET2R_TIMEVNT3_Msk      (0x1U << HRTIM_SET2R_TIMEVNT3_Pos)       /*!< 0x00004000 */
#define HRTIM_SET2R_TIMEVNT3          HRTIM_SET2R_TIMEVNT3_Msk                 /*!< Timer event 3 */
#define HRTIM_SET2R_TIMEVNT4_Pos      (15U)                                    
#define HRTIM_SET2R_TIMEVNT4_Msk      (0x1U << HRTIM_SET2R_TIMEVNT4_Pos)       /*!< 0x00008000 */
#define HRTIM_SET2R_TIMEVNT4          HRTIM_SET2R_TIMEVNT4_Msk                 /*!< Timer event 4 */
#define HRTIM_SET2R_TIMEVNT5_Pos      (16U)                                    
#define HRTIM_SET2R_TIMEVNT5_Msk      (0x1U << HRTIM_SET2R_TIMEVNT5_Pos)       /*!< 0x00010000 */
#define HRTIM_SET2R_TIMEVNT5          HRTIM_SET2R_TIMEVNT5_Msk                 /*!< Timer event 5 */
#define HRTIM_SET2R_TIMEVNT6_Pos      (17U)                                    
#define HRTIM_SET2R_TIMEVNT6_Msk      (0x1U << HRTIM_SET2R_TIMEVNT6_Pos)       /*!< 0x00020000 */
#define HRTIM_SET2R_TIMEVNT6          HRTIM_SET2R_TIMEVNT6_Msk                 /*!< Timer event 6 */
#define HRTIM_SET2R_TIMEVNT7_Pos      (18U)                                    
#define HRTIM_SET2R_TIMEVNT7_Msk      (0x1U << HRTIM_SET2R_TIMEVNT7_Pos)       /*!< 0x00040000 */
#define HRTIM_SET2R_TIMEVNT7          HRTIM_SET2R_TIMEVNT7_Msk                 /*!< Timer event 7 */
#define HRTIM_SET2R_TIMEVNT8_Pos      (19U)                                    
#define HRTIM_SET2R_TIMEVNT8_Msk      (0x1U << HRTIM_SET2R_TIMEVNT8_Pos)       /*!< 0x00080000 */
#define HRTIM_SET2R_TIMEVNT8          HRTIM_SET2R_TIMEVNT8_Msk                 /*!< Timer event 8 */
#define HRTIM_SET2R_TIMEVNT9_Pos      (20U)                                    
#define HRTIM_SET2R_TIMEVNT9_Msk      (0x1U << HRTIM_SET2R_TIMEVNT9_Pos)       /*!< 0x00100000 */
#define HRTIM_SET2R_TIMEVNT9          HRTIM_SET2R_TIMEVNT9_Msk                 /*!< Timer event 9 */

#define HRTIM_SET2R_EXTVNT1_Pos       (21U)                                    
#define HRTIM_SET2R_EXTVNT1_Msk       (0x1U << HRTIM_SET2R_EXTVNT1_Pos)        /*!< 0x00200000 */
#define HRTIM_SET2R_EXTVNT1           HRTIM_SET2R_EXTVNT1_Msk                  /*!< External event 1 */
#define HRTIM_SET2R_EXTVNT2_Pos       (22U)                                    
#define HRTIM_SET2R_EXTVNT2_Msk       (0x1U << HRTIM_SET2R_EXTVNT2_Pos)        /*!< 0x00400000 */
#define HRTIM_SET2R_EXTVNT2           HRTIM_SET2R_EXTVNT2_Msk                  /*!< External event 2 */
#define HRTIM_SET2R_EXTVNT3_Pos       (23U)                                    
#define HRTIM_SET2R_EXTVNT3_Msk       (0x1U << HRTIM_SET2R_EXTVNT3_Pos)        /*!< 0x00800000 */
#define HRTIM_SET2R_EXTVNT3           HRTIM_SET2R_EXTVNT3_Msk                  /*!< External event 3 */
#define HRTIM_SET2R_EXTVNT4_Pos       (24U)                                    
#define HRTIM_SET2R_EXTVNT4_Msk       (0x1U << HRTIM_SET2R_EXTVNT4_Pos)        /*!< 0x01000000 */
#define HRTIM_SET2R_EXTVNT4           HRTIM_SET2R_EXTVNT4_Msk                  /*!< External event 4 */
#define HRTIM_SET2R_EXTVNT5_Pos       (25U)                                    
#define HRTIM_SET2R_EXTVNT5_Msk       (0x1U << HRTIM_SET2R_EXTVNT5_Pos)        /*!< 0x02000000 */
#define HRTIM_SET2R_EXTVNT5           HRTIM_SET2R_EXTVNT5_Msk                  /*!< External event 5 */
#define HRTIM_SET2R_EXTVNT6_Pos       (26U)                                    
#define HRTIM_SET2R_EXTVNT6_Msk       (0x1U << HRTIM_SET2R_EXTVNT6_Pos)        /*!< 0x04000000 */
#define HRTIM_SET2R_EXTVNT6           HRTIM_SET2R_EXTVNT6_Msk                  /*!< External event 6 */
#define HRTIM_SET2R_EXTVNT7_Pos       (27U)                                    
#define HRTIM_SET2R_EXTVNT7_Msk       (0x1U << HRTIM_SET2R_EXTVNT7_Pos)        /*!< 0x08000000 */
#define HRTIM_SET2R_EXTVNT7           HRTIM_SET2R_EXTVNT7_Msk                  /*!< External event 7 */
#define HRTIM_SET2R_EXTVNT8_Pos       (28U)                                    
#define HRTIM_SET2R_EXTVNT8_Msk       (0x1U << HRTIM_SET2R_EXTVNT8_Pos)        /*!< 0x10000000 */
#define HRTIM_SET2R_EXTVNT8           HRTIM_SET2R_EXTVNT8_Msk                  /*!< External event 8 */
#define HRTIM_SET2R_EXTVNT9_Pos       (29U)                                    
#define HRTIM_SET2R_EXTVNT9_Msk       (0x1U << HRTIM_SET2R_EXTVNT9_Pos)        /*!< 0x20000000 */
#define HRTIM_SET2R_EXTVNT9           HRTIM_SET2R_EXTVNT9_Msk                  /*!< External event 9 */
#define HRTIM_SET2R_EXTVNT10_Pos      (30U)                                    
#define HRTIM_SET2R_EXTVNT10_Msk      (0x1U << HRTIM_SET2R_EXTVNT10_Pos)       /*!< 0x40000000 */
#define HRTIM_SET2R_EXTVNT10          HRTIM_SET2R_EXTVNT10_Msk                 /*!< External event 10 */

#define HRTIM_SET2R_UPDATE_Pos        (31U)                                    
#define HRTIM_SET2R_UPDATE_Msk        (0x1U << HRTIM_SET2R_UPDATE_Pos)         /*!< 0x80000000 */
#define HRTIM_SET2R_UPDATE            HRTIM_SET2R_UPDATE_Msk                   /*!< Register update (transfer preload to active) */

/**** Bit definition for Slave Output 2 reset register ************************/
#define HRTIM_RST2R_SRT_Pos           (0U)                                     
#define HRTIM_RST2R_SRT_Msk           (0x1U << HRTIM_RST2R_SRT_Pos)            /*!< 0x00000001 */
#define HRTIM_RST2R_SRT               HRTIM_RST2R_SRT_Msk                      /*!< software reset trigger */
#define HRTIM_RST2R_RESYNC_Pos        (1U)                                     
#define HRTIM_RST2R_RESYNC_Msk        (0x1U << HRTIM_RST2R_RESYNC_Pos)         /*!< 0x00000002 */
#define HRTIM_RST2R_RESYNC            HRTIM_RST2R_RESYNC_Msk                   /*!< Timer A resynchronization */
#define HRTIM_RST2R_PER_Pos           (2U)                                     
#define HRTIM_RST2R_PER_Msk           (0x1U << HRTIM_RST2R_PER_Pos)            /*!< 0x00000004 */
#define HRTIM_RST2R_PER               HRTIM_RST2R_PER_Msk                      /*!< Timer A period */
#define HRTIM_RST2R_CMP1_Pos          (3U)                                     
#define HRTIM_RST2R_CMP1_Msk          (0x1U << HRTIM_RST2R_CMP1_Pos)           /*!< 0x00000008 */
#define HRTIM_RST2R_CMP1              HRTIM_RST2R_CMP1_Msk                     /*!< Timer A compare 1 */
#define HRTIM_RST2R_CMP2_Pos          (4U)                                     
#define HRTIM_RST2R_CMP2_Msk          (0x1U << HRTIM_RST2R_CMP2_Pos)           /*!< 0x00000010 */
#define HRTIM_RST2R_CMP2              HRTIM_RST2R_CMP2_Msk                     /*!< Timer A compare 2 */
#define HRTIM_RST2R_CMP3_Pos          (5U)                                     
#define HRTIM_RST2R_CMP3_Msk          (0x1U << HRTIM_RST2R_CMP3_Pos)           /*!< 0x00000020 */
#define HRTIM_RST2R_CMP3              HRTIM_RST2R_CMP3_Msk                     /*!< Timer A compare 3 */
#define HRTIM_RST2R_CMP4_Pos          (6U)                                     
#define HRTIM_RST2R_CMP4_Msk          (0x1U << HRTIM_RST2R_CMP4_Pos)           /*!< 0x00000040 */
#define HRTIM_RST2R_CMP4              HRTIM_RST2R_CMP4_Msk                     /*!< Timer A compare 4 */

#define HRTIM_RST2R_MSTPER_Pos        (7U)                                     
#define HRTIM_RST2R_MSTPER_Msk        (0x1U << HRTIM_RST2R_MSTPER_Pos)         /*!< 0x00000080 */
#define HRTIM_RST2R_MSTPER            HRTIM_RST2R_MSTPER_Msk                   /*!< Master period */
#define HRTIM_RST2R_MSTCMP1_Pos       (8U)                                     
#define HRTIM_RST2R_MSTCMP1_Msk       (0x1U << HRTIM_RST2R_MSTCMP1_Pos)        /*!< 0x00000100 */
#define HRTIM_RST2R_MSTCMP1           HRTIM_RST2R_MSTCMP1_Msk                  /*!< Master compare 1 */
#define HRTIM_RST2R_MSTCMP2_Pos       (9U)                                     
#define HRTIM_RST2R_MSTCMP2_Msk       (0x1U << HRTIM_RST2R_MSTCMP2_Pos)        /*!< 0x00000200 */
#define HRTIM_RST2R_MSTCMP2           HRTIM_RST2R_MSTCMP2_Msk                  /*!< Master compare 2 */
#define HRTIM_RST2R_MSTCMP3_Pos       (10U)                                    
#define HRTIM_RST2R_MSTCMP3_Msk       (0x1U << HRTIM_RST2R_MSTCMP3_Pos)        /*!< 0x00000400 */
#define HRTIM_RST2R_MSTCMP3           HRTIM_RST2R_MSTCMP3_Msk                  /*!< Master compare 3 */
#define HRTIM_RST2R_MSTCMP4_Pos       (11U)                                    
#define HRTIM_RST2R_MSTCMP4_Msk       (0x1U << HRTIM_RST2R_MSTCMP4_Pos)        /*!< 0x00000800 */
#define HRTIM_RST2R_MSTCMP4           HRTIM_RST2R_MSTCMP4_Msk                  /*!< Master compare 4 */

#define HRTIM_RST2R_TIMEVNT1_Pos      (12U)                                    
#define HRTIM_RST2R_TIMEVNT1_Msk      (0x1U << HRTIM_RST2R_TIMEVNT1_Pos)       /*!< 0x00001000 */
#define HRTIM_RST2R_TIMEVNT1          HRTIM_RST2R_TIMEVNT1_Msk                 /*!< Timer event 1 */
#define HRTIM_RST2R_TIMEVNT2_Pos      (13U)                                    
#define HRTIM_RST2R_TIMEVNT2_Msk      (0x1U << HRTIM_RST2R_TIMEVNT2_Pos)       /*!< 0x00002000 */
#define HRTIM_RST2R_TIMEVNT2          HRTIM_RST2R_TIMEVNT2_Msk                 /*!< Timer event 2 */
#define HRTIM_RST2R_TIMEVNT3_Pos      (14U)                                    
#define HRTIM_RST2R_TIMEVNT3_Msk      (0x1U << HRTIM_RST2R_TIMEVNT3_Pos)       /*!< 0x00004000 */
#define HRTIM_RST2R_TIMEVNT3          HRTIM_RST2R_TIMEVNT3_Msk                 /*!< Timer event 3 */
#define HRTIM_RST2R_TIMEVNT4_Pos      (15U)                                    
#define HRTIM_RST2R_TIMEVNT4_Msk      (0x1U << HRTIM_RST2R_TIMEVNT4_Pos)       /*!< 0x00008000 */
#define HRTIM_RST2R_TIMEVNT4          HRTIM_RST2R_TIMEVNT4_Msk                 /*!< Timer event 4 */
#define HRTIM_RST2R_TIMEVNT5_Pos      (16U)                                    
#define HRTIM_RST2R_TIMEVNT5_Msk      (0x1U << HRTIM_RST2R_TIMEVNT5_Pos)       /*!< 0x00010000 */
#define HRTIM_RST2R_TIMEVNT5          HRTIM_RST2R_TIMEVNT5_Msk                 /*!< Timer event 5 */
#define HRTIM_RST2R_TIMEVNT6_Pos      (17U)                                    
#define HRTIM_RST2R_TIMEVNT6_Msk      (0x1U << HRTIM_RST2R_TIMEVNT6_Pos)       /*!< 0x00020000 */
#define HRTIM_RST2R_TIMEVNT6          HRTIM_RST2R_TIMEVNT6_Msk                 /*!< Timer event 6 */
#define HRTIM_RST2R_TIMEVNT7_Pos      (18U)                                    
#define HRTIM_RST2R_TIMEVNT7_Msk      (0x1U << HRTIM_RST2R_TIMEVNT7_Pos)       /*!< 0x00040000 */
#define HRTIM_RST2R_TIMEVNT7          HRTIM_RST2R_TIMEVNT7_Msk                 /*!< Timer event 7 */
#define HRTIM_RST2R_TIMEVNT8_Pos      (19U)                                    
#define HRTIM_RST2R_TIMEVNT8_Msk      (0x1U << HRTIM_RST2R_TIMEVNT8_Pos)       /*!< 0x00080000 */
#define HRTIM_RST2R_TIMEVNT8          HRTIM_RST2R_TIMEVNT8_Msk                 /*!< Timer event 8 */
#define HRTIM_RST2R_TIMEVNT9_Pos      (20U)                                    
#define HRTIM_RST2R_TIMEVNT9_Msk      (0x1U << HRTIM_RST2R_TIMEVNT9_Pos)       /*!< 0x00100000 */
#define HRTIM_RST2R_TIMEVNT9          HRTIM_RST2R_TIMEVNT9_Msk                 /*!< Timer event 9 */

#define HRTIM_RST2R_EXTVNT1_Pos       (21U)                                    
#define HRTIM_RST2R_EXTVNT1_Msk       (0x1U << HRTIM_RST2R_EXTVNT1_Pos)        /*!< 0x00200000 */
#define HRTIM_RST2R_EXTVNT1           HRTIM_RST2R_EXTVNT1_Msk                  /*!< External event 1 */
#define HRTIM_RST2R_EXTVNT2_Pos       (22U)                                    
#define HRTIM_RST2R_EXTVNT2_Msk       (0x1U << HRTIM_RST2R_EXTVNT2_Pos)        /*!< 0x00400000 */
#define HRTIM_RST2R_EXTVNT2           HRTIM_RST2R_EXTVNT2_Msk                  /*!< External event 2 */
#define HRTIM_RST2R_EXTVNT3_Pos       (23U)                                    
#define HRTIM_RST2R_EXTVNT3_Msk       (0x1U << HRTIM_RST2R_EXTVNT3_Pos)        /*!< 0x00800000 */
#define HRTIM_RST2R_EXTVNT3           HRTIM_RST2R_EXTVNT3_Msk                  /*!< External event 3 */
#define HRTIM_RST2R_EXTVNT4_Pos       (24U)                                    
#define HRTIM_RST2R_EXTVNT4_Msk       (0x1U << HRTIM_RST2R_EXTVNT4_Pos)        /*!< 0x01000000 */
#define HRTIM_RST2R_EXTVNT4           HRTIM_RST2R_EXTVNT4_Msk                  /*!< External event 4 */
#define HRTIM_RST2R_EXTVNT5_Pos       (25U)                                    
#define HRTIM_RST2R_EXTVNT5_Msk       (0x1U << HRTIM_RST2R_EXTVNT5_Pos)        /*!< 0x02000000 */
#define HRTIM_RST2R_EXTVNT5           HRTIM_RST2R_EXTVNT5_Msk                  /*!< External event 5 */
#define HRTIM_RST2R_EXTVNT6_Pos       (26U)                                    
#define HRTIM_RST2R_EXTVNT6_Msk       (0x1U << HRTIM_RST2R_EXTVNT6_Pos)        /*!< 0x04000000 */
#define HRTIM_RST2R_EXTVNT6           HRTIM_RST2R_EXTVNT6_Msk                  /*!< External event 6 */
#define HRTIM_RST2R_EXTVNT7_Pos       (27U)                                    
#define HRTIM_RST2R_EXTVNT7_Msk       (0x1U << HRTIM_RST2R_EXTVNT7_Pos)        /*!< 0x08000000 */
#define HRTIM_RST2R_EXTVNT7           HRTIM_RST2R_EXTVNT7_Msk                  /*!< External event 7 */
#define HRTIM_RST2R_EXTVNT8_Pos       (28U)                                    
#define HRTIM_RST2R_EXTVNT8_Msk       (0x1U << HRTIM_RST2R_EXTVNT8_Pos)        /*!< 0x10000000 */
#define HRTIM_RST2R_EXTVNT8           HRTIM_RST2R_EXTVNT8_Msk                  /*!< External event 8 */
#define HRTIM_RST2R_EXTVNT9_Pos       (29U)                                    
#define HRTIM_RST2R_EXTVNT9_Msk       (0x1U << HRTIM_RST2R_EXTVNT9_Pos)        /*!< 0x20000000 */
#define HRTIM_RST2R_EXTVNT9           HRTIM_RST2R_EXTVNT9_Msk                  /*!< External event 9 */
#define HRTIM_RST2R_EXTVNT10_Pos      (30U)                                    
#define HRTIM_RST2R_EXTVNT10_Msk      (0x1U << HRTIM_RST2R_EXTVNT10_Pos)       /*!< 0x40000000 */
#define HRTIM_RST2R_EXTVNT10          HRTIM_RST2R_EXTVNT10_Msk                 /*!< External event 10 */

#define HRTIM_RST2R_UPDATE_Pos        (31U)                                    
#define HRTIM_RST2R_UPDATE_Msk        (0x1U << HRTIM_RST2R_UPDATE_Pos)         /*!< 0x80000000 */
#define HRTIM_RST2R_UPDATE            HRTIM_RST2R_UPDATE_Msk                   /*!< Register update (transfer preload to active) */

/**** Bit definition for Slave external event filtering  register 1 ***********/
#define HRTIM_EEFR1_EE1LTCH_Pos       (0U)                                     
#define HRTIM_EEFR1_EE1LTCH_Msk       (0x1U << HRTIM_EEFR1_EE1LTCH_Pos)        /*!< 0x00000001 */
#define HRTIM_EEFR1_EE1LTCH           HRTIM_EEFR1_EE1LTCH_Msk                  /*!< External Event 1 latch */
#define HRTIM_EEFR1_EE1FLTR_Pos       (1U)                                     
#define HRTIM_EEFR1_EE1FLTR_Msk       (0xFU << HRTIM_EEFR1_EE1FLTR_Pos)        /*!< 0x0000001E */
#define HRTIM_EEFR1_EE1FLTR           HRTIM_EEFR1_EE1FLTR_Msk                  /*!< External Event 1 filter mask */
#define HRTIM_EEFR1_EE1FLTR_0         (0x1U << HRTIM_EEFR1_EE1FLTR_Pos)        /*!< 0x00000002 */
#define HRTIM_EEFR1_EE1FLTR_1         (0x2U << HRTIM_EEFR1_EE1FLTR_Pos)        /*!< 0x00000004 */
#define HRTIM_EEFR1_EE1FLTR_2         (0x4U << HRTIM_EEFR1_EE1FLTR_Pos)        /*!< 0x00000008 */
#define HRTIM_EEFR1_EE1FLTR_3         (0x8U << HRTIM_EEFR1_EE1FLTR_Pos)        /*!< 0x00000010 */

#define HRTIM_EEFR1_EE2LTCH_Pos       (6U)                                     
#define HRTIM_EEFR1_EE2LTCH_Msk       (0x1U << HRTIM_EEFR1_EE2LTCH_Pos)        /*!< 0x00000040 */
#define HRTIM_EEFR1_EE2LTCH           HRTIM_EEFR1_EE2LTCH_Msk                  /*!< External Event 2 latch */
#define HRTIM_EEFR1_EE2FLTR_Pos       (7U)                                     
#define HRTIM_EEFR1_EE2FLTR_Msk       (0xFU << HRTIM_EEFR1_EE2FLTR_Pos)        /*!< 0x00000780 */
#define HRTIM_EEFR1_EE2FLTR           HRTIM_EEFR1_EE2FLTR_Msk                  /*!< External Event 2 filter mask */
#define HRTIM_EEFR1_EE2FLTR_0         (0x1U << HRTIM_EEFR1_EE2FLTR_Pos)        /*!< 0x00000080 */
#define HRTIM_EEFR1_EE2FLTR_1         (0x2U << HRTIM_EEFR1_EE2FLTR_Pos)        /*!< 0x00000100 */
#define HRTIM_EEFR1_EE2FLTR_2         (0x4U << HRTIM_EEFR1_EE2FLTR_Pos)        /*!< 0x00000200 */
#define HRTIM_EEFR1_EE2FLTR_3         (0x8U << HRTIM_EEFR1_EE2FLTR_Pos)        /*!< 0x00000400 */

#define HRTIM_EEFR1_EE3LTCH_Pos       (12U)                                    
#define HRTIM_EEFR1_EE3LTCH_Msk       (0x1U << HRTIM_EEFR1_EE3LTCH_Pos)        /*!< 0x00001000 */
#define HRTIM_EEFR1_EE3LTCH           HRTIM_EEFR1_EE3LTCH_Msk                  /*!< External Event 3 latch */
#define HRTIM_EEFR1_EE3FLTR_Pos       (13U)                                    
#define HRTIM_EEFR1_EE3FLTR_Msk       (0xFU << HRTIM_EEFR1_EE3FLTR_Pos)        /*!< 0x0001E000 */
#define HRTIM_EEFR1_EE3FLTR           HRTIM_EEFR1_EE3FLTR_Msk                  /*!< External Event 3 filter mask */
#define HRTIM_EEFR1_EE3FLTR_0         (0x1U << HRTIM_EEFR1_EE3FLTR_Pos)        /*!< 0x00002000 */
#define HRTIM_EEFR1_EE3FLTR_1         (0x2U << HRTIM_EEFR1_EE3FLTR_Pos)        /*!< 0x00004000 */
#define HRTIM_EEFR1_EE3FLTR_2         (0x4U << HRTIM_EEFR1_EE3FLTR_Pos)        /*!< 0x00008000 */
#define HRTIM_EEFR1_EE3FLTR_3         (0x8U << HRTIM_EEFR1_EE3FLTR_Pos)        /*!< 0x00010000 */

#define HRTIM_EEFR1_EE4LTCH_Pos       (18U)                                    
#define HRTIM_EEFR1_EE4LTCH_Msk       (0x1U << HRTIM_EEFR1_EE4LTCH_Pos)        /*!< 0x00040000 */
#define HRTIM_EEFR1_EE4LTCH           HRTIM_EEFR1_EE4LTCH_Msk                  /*!< External Event 4 latch */
#define HRTIM_EEFR1_EE4FLTR_Pos       (19U)                                    
#define HRTIM_EEFR1_EE4FLTR_Msk       (0xFU << HRTIM_EEFR1_EE4FLTR_Pos)        /*!< 0x00780000 */
#define HRTIM_EEFR1_EE4FLTR           HRTIM_EEFR1_EE4FLTR_Msk                  /*!< External Event 4 filter mask */
#define HRTIM_EEFR1_EE4FLTR_0         (0x1U << HRTIM_EEFR1_EE4FLTR_Pos)        /*!< 0x00080000 */
#define HRTIM_EEFR1_EE4FLTR_1         (0x2U << HRTIM_EEFR1_EE4FLTR_Pos)        /*!< 0x00100000 */
#define HRTIM_EEFR1_EE4FLTR_2         (0x4U << HRTIM_EEFR1_EE4FLTR_Pos)        /*!< 0x00200000 */
#define HRTIM_EEFR1_EE4FLTR_3         (0x8U << HRTIM_EEFR1_EE4FLTR_Pos)        /*!< 0x00400000 */

#define HRTIM_EEFR1_EE5LTCH_Pos       (24U)                                    
#define HRTIM_EEFR1_EE5LTCH_Msk       (0x1U << HRTIM_EEFR1_EE5LTCH_Pos)        /*!< 0x01000000 */
#define HRTIM_EEFR1_EE5LTCH           HRTIM_EEFR1_EE5LTCH_Msk                  /*!< External Event 5 latch */
#define HRTIM_EEFR1_EE5FLTR_Pos       (25U)                                    
#define HRTIM_EEFR1_EE5FLTR_Msk       (0xFU << HRTIM_EEFR1_EE5FLTR_Pos)        /*!< 0x1E000000 */
#define HRTIM_EEFR1_EE5FLTR           HRTIM_EEFR1_EE5FLTR_Msk                  /*!< External Event 5 filter mask */
#define HRTIM_EEFR1_EE5FLTR_0         (0x1U << HRTIM_EEFR1_EE5FLTR_Pos)        /*!< 0x02000000 */
#define HRTIM_EEFR1_EE5FLTR_1         (0x2U << HRTIM_EEFR1_EE5FLTR_Pos)        /*!< 0x04000000 */
#define HRTIM_EEFR1_EE5FLTR_2         (0x4U << HRTIM_EEFR1_EE5FLTR_Pos)        /*!< 0x08000000 */
#define HRTIM_EEFR1_EE5FLTR_3         (0x8U << HRTIM_EEFR1_EE5FLTR_Pos)        /*!< 0x10000000 */

/**** Bit definition for Slave external event filtering  register 2 ***********/
#define HRTIM_EEFR2_EE6LTCH_Pos       (0U)                                     
#define HRTIM_EEFR2_EE6LTCH_Msk       (0x1U << HRTIM_EEFR2_EE6LTCH_Pos)        /*!< 0x00000001 */
#define HRTIM_EEFR2_EE6LTCH           HRTIM_EEFR2_EE6LTCH_Msk                  /*!< External Event 6 latch */
#define HRTIM_EEFR2_EE6FLTR_Pos       (1U)                                     
#define HRTIM_EEFR2_EE6FLTR_Msk       (0xFU << HRTIM_EEFR2_EE6FLTR_Pos)        /*!< 0x0000001E */
#define HRTIM_EEFR2_EE6FLTR           HRTIM_EEFR2_EE6FLTR_Msk                  /*!< External Event 6 filter mask */
#define HRTIM_EEFR2_EE6FLTR_0         (0x1U << HRTIM_EEFR2_EE6FLTR_Pos)        /*!< 0x00000002 */
#define HRTIM_EEFR2_EE6FLTR_1         (0x2U << HRTIM_EEFR2_EE6FLTR_Pos)        /*!< 0x00000004 */
#define HRTIM_EEFR2_EE6FLTR_2         (0x4U << HRTIM_EEFR2_EE6FLTR_Pos)        /*!< 0x00000008 */
#define HRTIM_EEFR2_EE6FLTR_3         (0x8U << HRTIM_EEFR2_EE6FLTR_Pos)        /*!< 0x00000010 */

#define HRTIM_EEFR2_EE7LTCH_Pos       (6U)                                     
#define HRTIM_EEFR2_EE7LTCH_Msk       (0x1U << HRTIM_EEFR2_EE7LTCH_Pos)        /*!< 0x00000040 */
#define HRTIM_EEFR2_EE7LTCH           HRTIM_EEFR2_EE7LTCH_Msk                  /*!< External Event 7 latch */
#define HRTIM_EEFR2_EE7FLTR_Pos       (7U)                                     
#define HRTIM_EEFR2_EE7FLTR_Msk       (0xFU << HRTIM_EEFR2_EE7FLTR_Pos)        /*!< 0x00000780 */
#define HRTIM_EEFR2_EE7FLTR           HRTIM_EEFR2_EE7FLTR_Msk                  /*!< External Event 7 filter mask */
#define HRTIM_EEFR2_EE7FLTR_0         (0x1U << HRTIM_EEFR2_EE7FLTR_Pos)        /*!< 0x00000080 */
#define HRTIM_EEFR2_EE7FLTR_1         (0x2U << HRTIM_EEFR2_EE7FLTR_Pos)        /*!< 0x00000100 */
#define HRTIM_EEFR2_EE7FLTR_2         (0x4U << HRTIM_EEFR2_EE7FLTR_Pos)        /*!< 0x00000200 */
#define HRTIM_EEFR2_EE7FLTR_3         (0x8U << HRTIM_EEFR2_EE7FLTR_Pos)        /*!< 0x00000400 */

#define HRTIM_EEFR2_EE8LTCH_Pos       (12U)                                    
#define HRTIM_EEFR2_EE8LTCH_Msk       (0x1U << HRTIM_EEFR2_EE8LTCH_Pos)        /*!< 0x00001000 */
#define HRTIM_EEFR2_EE8LTCH           HRTIM_EEFR2_EE8LTCH_Msk                  /*!< External Event 8 latch */
#define HRTIM_EEFR2_EE8FLTR_Pos       (13U)                                    
#define HRTIM_EEFR2_EE8FLTR_Msk       (0xFU << HRTIM_EEFR2_EE8FLTR_Pos)        /*!< 0x0001E000 */
#define HRTIM_EEFR2_EE8FLTR           HRTIM_EEFR2_EE8FLTR_Msk                  /*!< External Event 8 filter mask */
#define HRTIM_EEFR2_EE8FLTR_0         (0x1U << HRTIM_EEFR2_EE8FLTR_Pos)        /*!< 0x00002000 */
#define HRTIM_EEFR2_EE8FLTR_1         (0x2U << HRTIM_EEFR2_EE8FLTR_Pos)        /*!< 0x00004000 */
#define HRTIM_EEFR2_EE8FLTR_2         (0x4U << HRTIM_EEFR2_EE8FLTR_Pos)        /*!< 0x00008000 */
#define HRTIM_EEFR2_EE8FLTR_3         (0x8U << HRTIM_EEFR2_EE8FLTR_Pos)        /*!< 0x00010000 */

#define HRTIM_EEFR2_EE9LTCH_Pos       (18U)                                    
#define HRTIM_EEFR2_EE9LTCH_Msk       (0x1U << HRTIM_EEFR2_EE9LTCH_Pos)        /*!< 0x00040000 */
#define HRTIM_EEFR2_EE9LTCH           HRTIM_EEFR2_EE9LTCH_Msk                  /*!< External Event 9 latch */
#define HRTIM_EEFR2_EE9FLTR_Pos       (19U)                                    
#define HRTIM_EEFR2_EE9FLTR_Msk       (0xFU << HRTIM_EEFR2_EE9FLTR_Pos)        /*!< 0x00780000 */
#define HRTIM_EEFR2_EE9FLTR           HRTIM_EEFR2_EE9FLTR_Msk                  /*!< External Event 9 filter mask */
#define HRTIM_EEFR2_EE9FLTR_0         (0x1U << HRTIM_EEFR2_EE9FLTR_Pos)        /*!< 0x00080000 */
#define HRTIM_EEFR2_EE9FLTR_1         (0x2U << HRTIM_EEFR2_EE9FLTR_Pos)        /*!< 0x00100000 */
#define HRTIM_EEFR2_EE9FLTR_2         (0x4U << HRTIM_EEFR2_EE9FLTR_Pos)        /*!< 0x00200000 */
#define HRTIM_EEFR2_EE9FLTR_3         (0x8U << HRTIM_EEFR2_EE9FLTR_Pos)        /*!< 0x00400000 */

#define HRTIM_EEFR2_EE10LTCH_Pos      (24U)                                    
#define HRTIM_EEFR2_EE10LTCH_Msk      (0x1U << HRTIM_EEFR2_EE10LTCH_Pos)       /*!< 0x01000000 */
#define HRTIM_EEFR2_EE10LTCH          HRTIM_EEFR2_EE10LTCH_Msk                 /*!< External Event 10 latch */
#define HRTIM_EEFR2_EE10FLTR_Pos      (25U)                                    
#define HRTIM_EEFR2_EE10FLTR_Msk      (0xFU << HRTIM_EEFR2_EE10FLTR_Pos)       /*!< 0x1E000000 */
#define HRTIM_EEFR2_EE10FLTR          HRTIM_EEFR2_EE10FLTR_Msk                 /*!< External Event 10 filter mask */
#define HRTIM_EEFR2_EE10FLTR_0        (0x1U << HRTIM_EEFR2_EE10FLTR_Pos)       /*!< 0x02000000 */
#define HRTIM_EEFR2_EE10FLTR_1        (0x2U << HRTIM_EEFR2_EE10FLTR_Pos)       /*!< 0x04000000 */
#define HRTIM_EEFR2_EE10FLTR_2        (0x4U << HRTIM_EEFR2_EE10FLTR_Pos)       /*!< 0x08000000 */
#define HRTIM_EEFR2_EE10FLTR_3        (0x8U << HRTIM_EEFR2_EE10FLTR_Pos)       /*!< 0x10000000 */

/**** Bit definition for Slave Timer reset register ***************************/
#define HRTIM_RSTR_UPDATE_Pos         (1U)                                     
#define HRTIM_RSTR_UPDATE_Msk         (0x1U << HRTIM_RSTR_UPDATE_Pos)          /*!< 0x00000002 */
#define HRTIM_RSTR_UPDATE             HRTIM_RSTR_UPDATE_Msk                    /*!< Timer update */
#define HRTIM_RSTR_CMP2_Pos           (2U)                                     
#define HRTIM_RSTR_CMP2_Msk           (0x1U << HRTIM_RSTR_CMP2_Pos)            /*!< 0x00000004 */
#define HRTIM_RSTR_CMP2               HRTIM_RSTR_CMP2_Msk                      /*!< Timer compare2 */
#define HRTIM_RSTR_CMP4_Pos           (3U)                                     
#define HRTIM_RSTR_CMP4_Msk           (0x1U << HRTIM_RSTR_CMP4_Pos)            /*!< 0x00000008 */
#define HRTIM_RSTR_CMP4               HRTIM_RSTR_CMP4_Msk                      /*!< Timer compare4 */

#define HRTIM_RSTR_MSTPER_Pos         (4U)                                     
#define HRTIM_RSTR_MSTPER_Msk         (0x1U << HRTIM_RSTR_MSTPER_Pos)          /*!< 0x00000010 */
#define HRTIM_RSTR_MSTPER             HRTIM_RSTR_MSTPER_Msk                    /*!< Master period */
#define HRTIM_RSTR_MSTCMP1_Pos        (5U)                                     
#define HRTIM_RSTR_MSTCMP1_Msk        (0x1U << HRTIM_RSTR_MSTCMP1_Pos)         /*!< 0x00000020 */
#define HRTIM_RSTR_MSTCMP1            HRTIM_RSTR_MSTCMP1_Msk                   /*!< Master compare1 */
#define HRTIM_RSTR_MSTCMP2_Pos        (6U)                                     
#define HRTIM_RSTR_MSTCMP2_Msk        (0x1U << HRTIM_RSTR_MSTCMP2_Pos)         /*!< 0x00000040 */
#define HRTIM_RSTR_MSTCMP2            HRTIM_RSTR_MSTCMP2_Msk                   /*!< Master compare2 */
#define HRTIM_RSTR_MSTCMP3_Pos        (7U)                                     
#define HRTIM_RSTR_MSTCMP3_Msk        (0x1U << HRTIM_RSTR_MSTCMP3_Pos)         /*!< 0x00000080 */
#define HRTIM_RSTR_MSTCMP3            HRTIM_RSTR_MSTCMP3_Msk                   /*!< Master compare3 */
#define HRTIM_RSTR_MSTCMP4_Pos        (8U)                                     
#define HRTIM_RSTR_MSTCMP4_Msk        (0x1U << HRTIM_RSTR_MSTCMP4_Pos)         /*!< 0x00000100 */
#define HRTIM_RSTR_MSTCMP4            HRTIM_RSTR_MSTCMP4_Msk                   /*!< Master compare4 */

#define HRTIM_RSTR_EXTEVNT1_Pos       (9U)                                     
#define HRTIM_RSTR_EXTEVNT1_Msk       (0x1U << HRTIM_RSTR_EXTEVNT1_Pos)        /*!< 0x00000200 */
#define HRTIM_RSTR_EXTEVNT1           HRTIM_RSTR_EXTEVNT1_Msk                  /*!< External event 1 */
#define HRTIM_RSTR_EXTEVNT2_Pos       (10U)                                    
#define HRTIM_RSTR_EXTEVNT2_Msk       (0x1U << HRTIM_RSTR_EXTEVNT2_Pos)        /*!< 0x00000400 */
#define HRTIM_RSTR_EXTEVNT2           HRTIM_RSTR_EXTEVNT2_Msk                  /*!< External event 2 */
#define HRTIM_RSTR_EXTEVNT3_Pos       (11U)                                    
#define HRTIM_RSTR_EXTEVNT3_Msk       (0x1U << HRTIM_RSTR_EXTEVNT3_Pos)        /*!< 0x00000800 */
#define HRTIM_RSTR_EXTEVNT3           HRTIM_RSTR_EXTEVNT3_Msk                  /*!< External event 3 */
#define HRTIM_RSTR_EXTEVNT4_Pos       (12U)                                    
#define HRTIM_RSTR_EXTEVNT4_Msk       (0x1U << HRTIM_RSTR_EXTEVNT4_Pos)        /*!< 0x00001000 */
#define HRTIM_RSTR_EXTEVNT4           HRTIM_RSTR_EXTEVNT4_Msk                  /*!< External event 4 */
#define HRTIM_RSTR_EXTEVNT5_Pos       (13U)                                    
#define HRTIM_RSTR_EXTEVNT5_Msk       (0x1U << HRTIM_RSTR_EXTEVNT5_Pos)        /*!< 0x00002000 */
#define HRTIM_RSTR_EXTEVNT5           HRTIM_RSTR_EXTEVNT5_Msk                  /*!< External event 5 */
#define HRTIM_RSTR_EXTEVNT6_Pos       (14U)                                    
#define HRTIM_RSTR_EXTEVNT6_Msk       (0x1U << HRTIM_RSTR_EXTEVNT6_Pos)        /*!< 0x00004000 */
#define HRTIM_RSTR_EXTEVNT6           HRTIM_RSTR_EXTEVNT6_Msk                  /*!< External event 6 */
#define HRTIM_RSTR_EXTEVNT7_Pos       (15U)                                    
#define HRTIM_RSTR_EXTEVNT7_Msk       (0x1U << HRTIM_RSTR_EXTEVNT7_Pos)        /*!< 0x00008000 */
#define HRTIM_RSTR_EXTEVNT7           HRTIM_RSTR_EXTEVNT7_Msk                  /*!< External event 7 */
#define HRTIM_RSTR_EXTEVNT8_Pos       (16U)                                    
#define HRTIM_RSTR_EXTEVNT8_Msk       (0x1U << HRTIM_RSTR_EXTEVNT8_Pos)        /*!< 0x00010000 */
#define HRTIM_RSTR_EXTEVNT8           HRTIM_RSTR_EXTEVNT8_Msk                  /*!< External event 8 */
#define HRTIM_RSTR_EXTEVNT9_Pos       (17U)                                    
#define HRTIM_RSTR_EXTEVNT9_Msk       (0x1U << HRTIM_RSTR_EXTEVNT9_Pos)        /*!< 0x00020000 */
#define HRTIM_RSTR_EXTEVNT9           HRTIM_RSTR_EXTEVNT9_Msk                  /*!< External event 9 */
#define HRTIM_RSTR_EXTEVNT10_Pos      (18U)                                    
#define HRTIM_RSTR_EXTEVNT10_Msk      (0x1U << HRTIM_RSTR_EXTEVNT10_Pos)       /*!< 0x00040000 */
#define HRTIM_RSTR_EXTEVNT10          HRTIM_RSTR_EXTEVNT10_Msk                 /*!< External event 10 */

#define HRTIM_RSTR_TIMBCMP1_Pos       (19U)                                    
#define HRTIM_RSTR_TIMBCMP1_Msk       (0x1U << HRTIM_RSTR_TIMBCMP1_Pos)        /*!< 0x00080000 */
#define HRTIM_RSTR_TIMBCMP1           HRTIM_RSTR_TIMBCMP1_Msk                  /*!< Timer B compare 1 */
#define HRTIM_RSTR_TIMBCMP2_Pos       (20U)                                    
#define HRTIM_RSTR_TIMBCMP2_Msk       (0x1U << HRTIM_RSTR_TIMBCMP2_Pos)        /*!< 0x00100000 */
#define HRTIM_RSTR_TIMBCMP2           HRTIM_RSTR_TIMBCMP2_Msk                  /*!< Timer B compare 2 */
#define HRTIM_RSTR_TIMBCMP4_Pos       (21U)                                    
#define HRTIM_RSTR_TIMBCMP4_Msk       (0x1U << HRTIM_RSTR_TIMBCMP4_Pos)        /*!< 0x00200000 */
#define HRTIM_RSTR_TIMBCMP4           HRTIM_RSTR_TIMBCMP4_Msk                  /*!< Timer B compare 4 */

#define HRTIM_RSTR_TIMCCMP1_Pos       (22U)                                    
#define HRTIM_RSTR_TIMCCMP1_Msk       (0x1U << HRTIM_RSTR_TIMCCMP1_Pos)        /*!< 0x00400000 */
#define HRTIM_RSTR_TIMCCMP1           HRTIM_RSTR_TIMCCMP1_Msk                  /*!< Timer C compare 1 */
#define HRTIM_RSTR_TIMCCMP2_Pos       (23U)                                    
#define HRTIM_RSTR_TIMCCMP2_Msk       (0x1U << HRTIM_RSTR_TIMCCMP2_Pos)        /*!< 0x00800000 */
#define HRTIM_RSTR_TIMCCMP2           HRTIM_RSTR_TIMCCMP2_Msk                  /*!< Timer C compare 2 */
#define HRTIM_RSTR_TIMCCMP4_Pos       (24U)                                    
#define HRTIM_RSTR_TIMCCMP4_Msk       (0x1U << HRTIM_RSTR_TIMCCMP4_Pos)        /*!< 0x01000000 */
#define HRTIM_RSTR_TIMCCMP4           HRTIM_RSTR_TIMCCMP4_Msk                  /*!< Timer C compare 4 */

#define HRTIM_RSTR_TIMDCMP1_Pos       (25U)                                    
#define HRTIM_RSTR_TIMDCMP1_Msk       (0x1U << HRTIM_RSTR_TIMDCMP1_Pos)        /*!< 0x02000000 */
#define HRTIM_RSTR_TIMDCMP1           HRTIM_RSTR_TIMDCMP1_Msk                  /*!< Timer D compare 1 */
#define HRTIM_RSTR_TIMDCMP2_Pos       (26U)                                    
#define HRTIM_RSTR_TIMDCMP2_Msk       (0x1U << HRTIM_RSTR_TIMDCMP2_Pos)        /*!< 0x04000000 */
#define HRTIM_RSTR_TIMDCMP2           HRTIM_RSTR_TIMDCMP2_Msk                  /*!< Timer D compare 2 */
#define HRTIM_RSTR_TIMDCMP4_Pos       (27U)                                    
#define HRTIM_RSTR_TIMDCMP4_Msk       (0x1U << HRTIM_RSTR_TIMDCMP4_Pos)        /*!< 0x08000000 */
#define HRTIM_RSTR_TIMDCMP4           HRTIM_RSTR_TIMDCMP4_Msk                  /*!< Timer D compare 4 */

#define HRTIM_RSTR_TIMECMP1_Pos       (28U)                                    
#define HRTIM_RSTR_TIMECMP1_Msk       (0x1U << HRTIM_RSTR_TIMECMP1_Pos)        /*!< 0x10000000 */
#define HRTIM_RSTR_TIMECMP1           HRTIM_RSTR_TIMECMP1_Msk                  /*!< Timer E compare 1 */
#define HRTIM_RSTR_TIMECMP2_Pos       (29U)                                    
#define HRTIM_RSTR_TIMECMP2_Msk       (0x1U << HRTIM_RSTR_TIMECMP2_Pos)        /*!< 0x20000000 */
#define HRTIM_RSTR_TIMECMP2           HRTIM_RSTR_TIMECMP2_Msk                  /*!< Timer E compare 2 */
#define HRTIM_RSTR_TIMECMP4_Pos       (30U)                                    
#define HRTIM_RSTR_TIMECMP4_Msk       (0x1U << HRTIM_RSTR_TIMECMP4_Pos)        /*!< 0x40000000 */
#define HRTIM_RSTR_TIMECMP4           HRTIM_RSTR_TIMECMP4_Msk                  /*!< Timer E compare 4 */

/**** Bit definition for Slave Timer Chopper register *************************/
#define HRTIM_CHPR_CARFRQ_Pos         (0U)                                     
#define HRTIM_CHPR_CARFRQ_Msk         (0xFU << HRTIM_CHPR_CARFRQ_Pos)          /*!< 0x0000000F */
#define HRTIM_CHPR_CARFRQ             HRTIM_CHPR_CARFRQ_Msk                    /*!< Timer carrier frequency value */
#define HRTIM_CHPR_CARFRQ_0           (0x1U << HRTIM_CHPR_CARFRQ_Pos)          /*!< 0x00000001 */
#define HRTIM_CHPR_CARFRQ_1           (0x2U << HRTIM_CHPR_CARFRQ_Pos)          /*!< 0x00000002 */
#define HRTIM_CHPR_CARFRQ_2           (0x4U << HRTIM_CHPR_CARFRQ_Pos)          /*!< 0x00000004 */
#define HRTIM_CHPR_CARFRQ_3           (0x8U << HRTIM_CHPR_CARFRQ_Pos)          /*!< 0x00000008 */

#define HRTIM_CHPR_CARDTY_Pos         (4U)                                     
#define HRTIM_CHPR_CARDTY_Msk         (0x7U << HRTIM_CHPR_CARDTY_Pos)          /*!< 0x00000070 */
#define HRTIM_CHPR_CARDTY             HRTIM_CHPR_CARDTY_Msk                    /*!< Timer chopper duty cycle value */
#define HRTIM_CHPR_CARDTY_0           (0x1U << HRTIM_CHPR_CARDTY_Pos)          /*!< 0x00000010 */
#define HRTIM_CHPR_CARDTY_1           (0x2U << HRTIM_CHPR_CARDTY_Pos)          /*!< 0x00000020 */
#define HRTIM_CHPR_CARDTY_2           (0x4U << HRTIM_CHPR_CARDTY_Pos)          /*!< 0x00000040 */

#define HRTIM_CHPR_STRPW_Pos          (7U)                                     
#define HRTIM_CHPR_STRPW_Msk          (0xFU << HRTIM_CHPR_STRPW_Pos)           /*!< 0x00000780 */
#define HRTIM_CHPR_STRPW              HRTIM_CHPR_STRPW_Msk                     /*!< Timer start pulse width value */
#define HRTIM_CHPR_STRPW_0            (0x1U << HRTIM_CHPR_STRPW_Pos)           /*!< 0x00000080 */
#define HRTIM_CHPR_STRPW_1            (0x2U << HRTIM_CHPR_STRPW_Pos)           /*!< 0x00000100 */
#define HRTIM_CHPR_STRPW_2            (0x4U << HRTIM_CHPR_STRPW_Pos)           /*!< 0x00000200 */
#define HRTIM_CHPR_STRPW_3            (0x8U << HRTIM_CHPR_STRPW_Pos)           /*!< 0x00000400 */

/**** Bit definition for Slave Timer Capture 1 control register ***************/
#define HRTIM_CPT1CR_SWCPT_Pos        (0U)                                     
#define HRTIM_CPT1CR_SWCPT_Msk        (0x1U << HRTIM_CPT1CR_SWCPT_Pos)         /*!< 0x00000001 */
#define HRTIM_CPT1CR_SWCPT            HRTIM_CPT1CR_SWCPT_Msk                   /*!< Software capture */
#define HRTIM_CPT1CR_UPDCPT_Pos       (1U)                                     
#define HRTIM_CPT1CR_UPDCPT_Msk       (0x1U << HRTIM_CPT1CR_UPDCPT_Pos)        /*!< 0x00000002 */
#define HRTIM_CPT1CR_UPDCPT           HRTIM_CPT1CR_UPDCPT_Msk                  /*!< Update capture */
#define HRTIM_CPT1CR_EXEV1CPT_Pos     (2U)                                     
#define HRTIM_CPT1CR_EXEV1CPT_Msk     (0x1U << HRTIM_CPT1CR_EXEV1CPT_Pos)      /*!< 0x00000004 */
#define HRTIM_CPT1CR_EXEV1CPT         HRTIM_CPT1CR_EXEV1CPT_Msk                /*!< External event 1 capture */
#define HRTIM_CPT1CR_EXEV2CPT_Pos     (3U)                                     
#define HRTIM_CPT1CR_EXEV2CPT_Msk     (0x1U << HRTIM_CPT1CR_EXEV2CPT_Pos)      /*!< 0x00000008 */
#define HRTIM_CPT1CR_EXEV2CPT         HRTIM_CPT1CR_EXEV2CPT_Msk                /*!< External event 2 capture */
#define HRTIM_CPT1CR_EXEV3CPT_Pos     (4U)                                     
#define HRTIM_CPT1CR_EXEV3CPT_Msk     (0x1U << HRTIM_CPT1CR_EXEV3CPT_Pos)      /*!< 0x00000010 */
#define HRTIM_CPT1CR_EXEV3CPT         HRTIM_CPT1CR_EXEV3CPT_Msk                /*!< External event 3 capture */
#define HRTIM_CPT1CR_EXEV4CPT_Pos     (5U)                                     
#define HRTIM_CPT1CR_EXEV4CPT_Msk     (0x1U << HRTIM_CPT1CR_EXEV4CPT_Pos)      /*!< 0x00000020 */
#define HRTIM_CPT1CR_EXEV4CPT         HRTIM_CPT1CR_EXEV4CPT_Msk                /*!< External event 4 capture */
#define HRTIM_CPT1CR_EXEV5CPT_Pos     (6U)                                     
#define HRTIM_CPT1CR_EXEV5CPT_Msk     (0x1U << HRTIM_CPT1CR_EXEV5CPT_Pos)      /*!< 0x00000040 */
#define HRTIM_CPT1CR_EXEV5CPT         HRTIM_CPT1CR_EXEV5CPT_Msk                /*!< External event 5 capture */
#define HRTIM_CPT1CR_EXEV6CPT_Pos     (7U)                                     
#define HRTIM_CPT1CR_EXEV6CPT_Msk     (0x1U << HRTIM_CPT1CR_EXEV6CPT_Pos)      /*!< 0x00000080 */
#define HRTIM_CPT1CR_EXEV6CPT         HRTIM_CPT1CR_EXEV6CPT_Msk                /*!< External event 6 capture */
#define HRTIM_CPT1CR_EXEV7CPT_Pos     (8U)                                     
#define HRTIM_CPT1CR_EXEV7CPT_Msk     (0x1U << HRTIM_CPT1CR_EXEV7CPT_Pos)      /*!< 0x00000100 */
#define HRTIM_CPT1CR_EXEV7CPT         HRTIM_CPT1CR_EXEV7CPT_Msk                /*!< External event 7 capture */
#define HRTIM_CPT1CR_EXEV8CPT_Pos     (9U)                                     
#define HRTIM_CPT1CR_EXEV8CPT_Msk     (0x1U << HRTIM_CPT1CR_EXEV8CPT_Pos)      /*!< 0x00000200 */
#define HRTIM_CPT1CR_EXEV8CPT         HRTIM_CPT1CR_EXEV8CPT_Msk                /*!< External event 8 capture */
#define HRTIM_CPT1CR_EXEV9CPT_Pos     (10U)                                    
#define HRTIM_CPT1CR_EXEV9CPT_Msk     (0x1U << HRTIM_CPT1CR_EXEV9CPT_Pos)      /*!< 0x00000400 */
#define HRTIM_CPT1CR_EXEV9CPT         HRTIM_CPT1CR_EXEV9CPT_Msk                /*!< External event 9 capture */
#define HRTIM_CPT1CR_EXEV10CPT_Pos    (11U)                                    
#define HRTIM_CPT1CR_EXEV10CPT_Msk    (0x1U << HRTIM_CPT1CR_EXEV10CPT_Pos)     /*!< 0x00000800 */
#define HRTIM_CPT1CR_EXEV10CPT        HRTIM_CPT1CR_EXEV10CPT_Msk               /*!< External event 10 capture */

#define HRTIM_CPT1CR_TA1SET_Pos       (12U)                                    
#define HRTIM_CPT1CR_TA1SET_Msk       (0x1U << HRTIM_CPT1CR_TA1SET_Pos)        /*!< 0x00001000 */
#define HRTIM_CPT1CR_TA1SET           HRTIM_CPT1CR_TA1SET_Msk                  /*!< Timer A output 1 set */
#define HRTIM_CPT1CR_TA1RST_Pos       (13U)                                    
#define HRTIM_CPT1CR_TA1RST_Msk       (0x1U << HRTIM_CPT1CR_TA1RST_Pos)        /*!< 0x00002000 */
#define HRTIM_CPT1CR_TA1RST           HRTIM_CPT1CR_TA1RST_Msk                  /*!< Timer A output 1 reset */
#define HRTIM_CPT1CR_TIMACMP1_Pos     (14U)                                    
#define HRTIM_CPT1CR_TIMACMP1_Msk     (0x1U << HRTIM_CPT1CR_TIMACMP1_Pos)      /*!< 0x00004000 */
#define HRTIM_CPT1CR_TIMACMP1         HRTIM_CPT1CR_TIMACMP1_Msk                /*!< Timer A compare 1 */
#define HRTIM_CPT1CR_TIMACMP2_Pos     (15U)                                    
#define HRTIM_CPT1CR_TIMACMP2_Msk     (0x1U << HRTIM_CPT1CR_TIMACMP2_Pos)      /*!< 0x00008000 */
#define HRTIM_CPT1CR_TIMACMP2         HRTIM_CPT1CR_TIMACMP2_Msk                /*!< Timer A compare 2 */

#define HRTIM_CPT1CR_TB1SET_Pos       (16U)                                    
#define HRTIM_CPT1CR_TB1SET_Msk       (0x1U << HRTIM_CPT1CR_TB1SET_Pos)        /*!< 0x00010000 */
#define HRTIM_CPT1CR_TB1SET           HRTIM_CPT1CR_TB1SET_Msk                  /*!< Timer B output 1 set */
#define HRTIM_CPT1CR_TB1RST_Pos       (17U)                                    
#define HRTIM_CPT1CR_TB1RST_Msk       (0x1U << HRTIM_CPT1CR_TB1RST_Pos)        /*!< 0x00020000 */
#define HRTIM_CPT1CR_TB1RST           HRTIM_CPT1CR_TB1RST_Msk                  /*!< Timer B output 1 reset */
#define HRTIM_CPT1CR_TIMBCMP1_Pos     (18U)                                    
#define HRTIM_CPT1CR_TIMBCMP1_Msk     (0x1U << HRTIM_CPT1CR_TIMBCMP1_Pos)      /*!< 0x00040000 */
#define HRTIM_CPT1CR_TIMBCMP1         HRTIM_CPT1CR_TIMBCMP1_Msk                /*!< Timer B compare 1 */
#define HRTIM_CPT1CR_TIMBCMP2_Pos     (19U)                                    
#define HRTIM_CPT1CR_TIMBCMP2_Msk     (0x1U << HRTIM_CPT1CR_TIMBCMP2_Pos)      /*!< 0x00080000 */
#define HRTIM_CPT1CR_TIMBCMP2         HRTIM_CPT1CR_TIMBCMP2_Msk                /*!< Timer B compare 2 */

#define HRTIM_CPT1CR_TC1SET_Pos       (20U)                                    
#define HRTIM_CPT1CR_TC1SET_Msk       (0x1U << HRTIM_CPT1CR_TC1SET_Pos)        /*!< 0x00100000 */
#define HRTIM_CPT1CR_TC1SET           HRTIM_CPT1CR_TC1SET_Msk                  /*!< Timer C output 1 set */
#define HRTIM_CPT1CR_TC1RST_Pos       (21U)                                    
#define HRTIM_CPT1CR_TC1RST_Msk       (0x1U << HRTIM_CPT1CR_TC1RST_Pos)        /*!< 0x00200000 */
#define HRTIM_CPT1CR_TC1RST           HRTIM_CPT1CR_TC1RST_Msk                  /*!< Timer C output 1 reset */
#define HRTIM_CPT1CR_TIMCCMP1_Pos     (22U)                                    
#define HRTIM_CPT1CR_TIMCCMP1_Msk     (0x1U << HRTIM_CPT1CR_TIMCCMP1_Pos)      /*!< 0x00400000 */
#define HRTIM_CPT1CR_TIMCCMP1         HRTIM_CPT1CR_TIMCCMP1_Msk                /*!< Timer C compare 1 */
#define HRTIM_CPT1CR_TIMCCMP2_Pos     (23U)                                    
#define HRTIM_CPT1CR_TIMCCMP2_Msk     (0x1U << HRTIM_CPT1CR_TIMCCMP2_Pos)      /*!< 0x00800000 */
#define HRTIM_CPT1CR_TIMCCMP2         HRTIM_CPT1CR_TIMCCMP2_Msk                /*!< Timer C compare 2 */

#define HRTIM_CPT1CR_TD1SET_Pos       (24U)                                    
#define HRTIM_CPT1CR_TD1SET_Msk       (0x1U << HRTIM_CPT1CR_TD1SET_Pos)        /*!< 0x01000000 */
#define HRTIM_CPT1CR_TD1SET           HRTIM_CPT1CR_TD1SET_Msk                  /*!< Timer D output 1 set */
#define HRTIM_CPT1CR_TD1RST_Pos       (25U)                                    
#define HRTIM_CPT1CR_TD1RST_Msk       (0x1U << HRTIM_CPT1CR_TD1RST_Pos)        /*!< 0x02000000 */
#define HRTIM_CPT1CR_TD1RST           HRTIM_CPT1CR_TD1RST_Msk                  /*!< Timer D output 1 reset */
#define HRTIM_CPT1CR_TIMDCMP1_Pos     (26U)                                    
#define HRTIM_CPT1CR_TIMDCMP1_Msk     (0x1U << HRTIM_CPT1CR_TIMDCMP1_Pos)      /*!< 0x04000000 */
#define HRTIM_CPT1CR_TIMDCMP1         HRTIM_CPT1CR_TIMDCMP1_Msk                /*!< Timer D compare 1 */
#define HRTIM_CPT1CR_TIMDCMP2_Pos     (27U)                                    
#define HRTIM_CPT1CR_TIMDCMP2_Msk     (0x1U << HRTIM_CPT1CR_TIMDCMP2_Pos)      /*!< 0x08000000 */
#define HRTIM_CPT1CR_TIMDCMP2         HRTIM_CPT1CR_TIMDCMP2_Msk                /*!< Timer D compare 2 */

#define HRTIM_CPT1CR_TE1SET_Pos       (28U)                                    
#define HRTIM_CPT1CR_TE1SET_Msk       (0x1U << HRTIM_CPT1CR_TE1SET_Pos)        /*!< 0x10000000 */
#define HRTIM_CPT1CR_TE1SET           HRTIM_CPT1CR_TE1SET_Msk                  /*!< Timer E output 1 set */
#define HRTIM_CPT1CR_TE1RST_Pos       (29U)                                    
#define HRTIM_CPT1CR_TE1RST_Msk       (0x1U << HRTIM_CPT1CR_TE1RST_Pos)        /*!< 0x20000000 */
#define HRTIM_CPT1CR_TE1RST           HRTIM_CPT1CR_TE1RST_Msk                  /*!< Timer E output 1 reset */
#define HRTIM_CPT1CR_TIMECMP1_Pos     (30U)                                    
#define HRTIM_CPT1CR_TIMECMP1_Msk     (0x1U << HRTIM_CPT1CR_TIMECMP1_Pos)      /*!< 0x40000000 */
#define HRTIM_CPT1CR_TIMECMP1         HRTIM_CPT1CR_TIMECMP1_Msk                /*!< Timer E compare 1 */
#define HRTIM_CPT1CR_TIMECMP2_Pos     (31U)                                    
#define HRTIM_CPT1CR_TIMECMP2_Msk     (0x1U << HRTIM_CPT1CR_TIMECMP2_Pos)      /*!< 0x80000000 */
#define HRTIM_CPT1CR_TIMECMP2         HRTIM_CPT1CR_TIMECMP2_Msk                /*!< Timer E compare 2 */

/**** Bit definition for Slave Timer Capture 2 control register ***************/
#define HRTIM_CPT2CR_SWCPT_Pos        (0U)                                     
#define HRTIM_CPT2CR_SWCPT_Msk        (0x1U << HRTIM_CPT2CR_SWCPT_Pos)         /*!< 0x00000001 */
#define HRTIM_CPT2CR_SWCPT            HRTIM_CPT2CR_SWCPT_Msk                   /*!< Software capture */
#define HRTIM_CPT2CR_UPDCPT_Pos       (1U)                                     
#define HRTIM_CPT2CR_UPDCPT_Msk       (0x1U << HRTIM_CPT2CR_UPDCPT_Pos)        /*!< 0x00000002 */
#define HRTIM_CPT2CR_UPDCPT           HRTIM_CPT2CR_UPDCPT_Msk                  /*!< Update capture */
#define HRTIM_CPT2CR_EXEV1CPT_Pos     (2U)                                     
#define HRTIM_CPT2CR_EXEV1CPT_Msk     (0x1U << HRTIM_CPT2CR_EXEV1CPT_Pos)      /*!< 0x00000004 */
#define HRTIM_CPT2CR_EXEV1CPT         HRTIM_CPT2CR_EXEV1CPT_Msk                /*!< External event 1 capture */
#define HRTIM_CPT2CR_EXEV2CPT_Pos     (3U)                                     
#define HRTIM_CPT2CR_EXEV2CPT_Msk     (0x1U << HRTIM_CPT2CR_EXEV2CPT_Pos)      /*!< 0x00000008 */
#define HRTIM_CPT2CR_EXEV2CPT         HRTIM_CPT2CR_EXEV2CPT_Msk                /*!< External event 2 capture */
#define HRTIM_CPT2CR_EXEV3CPT_Pos     (4U)                                     
#define HRTIM_CPT2CR_EXEV3CPT_Msk     (0x1U << HRTIM_CPT2CR_EXEV3CPT_Pos)      /*!< 0x00000010 */
#define HRTIM_CPT2CR_EXEV3CPT         HRTIM_CPT2CR_EXEV3CPT_Msk                /*!< External event 3 capture */
#define HRTIM_CPT2CR_EXEV4CPT_Pos     (5U)                                     
#define HRTIM_CPT2CR_EXEV4CPT_Msk     (0x1U << HRTIM_CPT2CR_EXEV4CPT_Pos)      /*!< 0x00000020 */
#define HRTIM_CPT2CR_EXEV4CPT         HRTIM_CPT2CR_EXEV4CPT_Msk                /*!< External event 4 capture */
#define HRTIM_CPT2CR_EXEV5CPT_Pos     (6U)                                     
#define HRTIM_CPT2CR_EXEV5CPT_Msk     (0x1U << HRTIM_CPT2CR_EXEV5CPT_Pos)      /*!< 0x00000040 */
#define HRTIM_CPT2CR_EXEV5CPT         HRTIM_CPT2CR_EXEV5CPT_Msk                /*!< External event 5 capture */
#define HRTIM_CPT2CR_EXEV6CPT_Pos     (7U)                                     
#define HRTIM_CPT2CR_EXEV6CPT_Msk     (0x1U << HRTIM_CPT2CR_EXEV6CPT_Pos)      /*!< 0x00000080 */
#define HRTIM_CPT2CR_EXEV6CPT         HRTIM_CPT2CR_EXEV6CPT_Msk                /*!< External event 6 capture */
#define HRTIM_CPT2CR_EXEV7CPT_Pos     (8U)                                     
#define HRTIM_CPT2CR_EXEV7CPT_Msk     (0x1U << HRTIM_CPT2CR_EXEV7CPT_Pos)      /*!< 0x00000100 */
#define HRTIM_CPT2CR_EXEV7CPT         HRTIM_CPT2CR_EXEV7CPT_Msk                /*!< External event 7 capture */
#define HRTIM_CPT2CR_EXEV8CPT_Pos     (9U)                                     
#define HRTIM_CPT2CR_EXEV8CPT_Msk     (0x1U << HRTIM_CPT2CR_EXEV8CPT_Pos)      /*!< 0x00000200 */
#define HRTIM_CPT2CR_EXEV8CPT         HRTIM_CPT2CR_EXEV8CPT_Msk                /*!< External event 8 capture */
#define HRTIM_CPT2CR_EXEV9CPT_Pos     (10U)                                    
#define HRTIM_CPT2CR_EXEV9CPT_Msk     (0x1U << HRTIM_CPT2CR_EXEV9CPT_Pos)      /*!< 0x00000400 */
#define HRTIM_CPT2CR_EXEV9CPT         HRTIM_CPT2CR_EXEV9CPT_Msk                /*!< External event 9 capture */
#define HRTIM_CPT2CR_EXEV10CPT_Pos    (11U)                                    
#define HRTIM_CPT2CR_EXEV10CPT_Msk    (0x1U << HRTIM_CPT2CR_EXEV10CPT_Pos)     /*!< 0x00000800 */
#define HRTIM_CPT2CR_EXEV10CPT        HRTIM_CPT2CR_EXEV10CPT_Msk               /*!< External event 10 capture */

#define HRTIM_CPT2CR_TA1SET_Pos       (12U)                                    
#define HRTIM_CPT2CR_TA1SET_Msk       (0x1U << HRTIM_CPT2CR_TA1SET_Pos)        /*!< 0x00001000 */
#define HRTIM_CPT2CR_TA1SET           HRTIM_CPT2CR_TA1SET_Msk                  /*!< Timer A output 1 set */
#define HRTIM_CPT2CR_TA1RST_Pos       (13U)                                    
#define HRTIM_CPT2CR_TA1RST_Msk       (0x1U << HRTIM_CPT2CR_TA1RST_Pos)        /*!< 0x00002000 */
#define HRTIM_CPT2CR_TA1RST           HRTIM_CPT2CR_TA1RST_Msk                  /*!< Timer A output 1 reset */
#define HRTIM_CPT2CR_TIMACMP1_Pos     (14U)                                    
#define HRTIM_CPT2CR_TIMACMP1_Msk     (0x1U << HRTIM_CPT2CR_TIMACMP1_Pos)      /*!< 0x00004000 */
#define HRTIM_CPT2CR_TIMACMP1         HRTIM_CPT2CR_TIMACMP1_Msk                /*!< Timer A compare 1 */
#define HRTIM_CPT2CR_TIMACMP2_Pos     (15U)                                    
#define HRTIM_CPT2CR_TIMACMP2_Msk     (0x1U << HRTIM_CPT2CR_TIMACMP2_Pos)      /*!< 0x00008000 */
#define HRTIM_CPT2CR_TIMACMP2         HRTIM_CPT2CR_TIMACMP2_Msk                /*!< Timer A compare 2 */

#define HRTIM_CPT2CR_TB1SET_Pos       (16U)                                    
#define HRTIM_CPT2CR_TB1SET_Msk       (0x1U << HRTIM_CPT2CR_TB1SET_Pos)        /*!< 0x00010000 */
#define HRTIM_CPT2CR_TB1SET           HRTIM_CPT2CR_TB1SET_Msk                  /*!< Timer B output 1 set */
#define HRTIM_CPT2CR_TB1RST_Pos       (17U)                                    
#define HRTIM_CPT2CR_TB1RST_Msk       (0x1U << HRTIM_CPT2CR_TB1RST_Pos)        /*!< 0x00020000 */
#define HRTIM_CPT2CR_TB1RST           HRTIM_CPT2CR_TB1RST_Msk                  /*!< Timer B output 1 reset */
#define HRTIM_CPT2CR_TIMBCMP1_Pos     (18U)                                    
#define HRTIM_CPT2CR_TIMBCMP1_Msk     (0x1U << HRTIM_CPT2CR_TIMBCMP1_Pos)      /*!< 0x00040000 */
#define HRTIM_CPT2CR_TIMBCMP1         HRTIM_CPT2CR_TIMBCMP1_Msk                /*!< Timer B compare 1 */
#define HRTIM_CPT2CR_TIMBCMP2_Pos     (19U)                                    
#define HRTIM_CPT2CR_TIMBCMP2_Msk     (0x1U << HRTIM_CPT2CR_TIMBCMP2_Pos)      /*!< 0x00080000 */
#define HRTIM_CPT2CR_TIMBCMP2         HRTIM_CPT2CR_TIMBCMP2_Msk                /*!< Timer B compare 2 */

#define HRTIM_CPT2CR_TC1SET_Pos       (20U)                                    
#define HRTIM_CPT2CR_TC1SET_Msk       (0x1U << HRTIM_CPT2CR_TC1SET_Pos)        /*!< 0x00100000 */
#define HRTIM_CPT2CR_TC1SET           HRTIM_CPT2CR_TC1SET_Msk                  /*!< Timer C output 1 set */
#define HRTIM_CPT2CR_TC1RST_Pos       (21U)                                    
#define HRTIM_CPT2CR_TC1RST_Msk       (0x1U << HRTIM_CPT2CR_TC1RST_Pos)        /*!< 0x00200000 */
#define HRTIM_CPT2CR_TC1RST           HRTIM_CPT2CR_TC1RST_Msk                  /*!< Timer C output 1 reset */
#define HRTIM_CPT2CR_TIMCCMP1_Pos     (22U)                                    
#define HRTIM_CPT2CR_TIMCCMP1_Msk     (0x1U << HRTIM_CPT2CR_TIMCCMP1_Pos)      /*!< 0x00400000 */
#define HRTIM_CPT2CR_TIMCCMP1         HRTIM_CPT2CR_TIMCCMP1_Msk                /*!< Timer C compare 1 */
#define HRTIM_CPT2CR_TIMCCMP2_Pos     (23U)                                    
#define HRTIM_CPT2CR_TIMCCMP2_Msk     (0x1U << HRTIM_CPT2CR_TIMCCMP2_Pos)      /*!< 0x00800000 */
#define HRTIM_CPT2CR_TIMCCMP2         HRTIM_CPT2CR_TIMCCMP2_Msk                /*!< Timer C compare 2 */

#define HRTIM_CPT2CR_TD1SET_Pos       (24U)                                    
#define HRTIM_CPT2CR_TD1SET_Msk       (0x1U << HRTIM_CPT2CR_TD1SET_Pos)        /*!< 0x01000000 */
#define HRTIM_CPT2CR_TD1SET           HRTIM_CPT2CR_TD1SET_Msk                  /*!< Timer D output 1 set */
#define HRTIM_CPT2CR_TD1RST_Pos       (25U)                                    
#define HRTIM_CPT2CR_TD1RST_Msk       (0x1U << HRTIM_CPT2CR_TD1RST_Pos)        /*!< 0x02000000 */
#define HRTIM_CPT2CR_TD1RST           HRTIM_CPT2CR_TD1RST_Msk                  /*!< Timer D output 1 reset */
#define HRTIM_CPT2CR_TIMDCMP1_Pos     (26U)                                    
#define HRTIM_CPT2CR_TIMDCMP1_Msk     (0x1U << HRTIM_CPT2CR_TIMDCMP1_Pos)      /*!< 0x04000000 */
#define HRTIM_CPT2CR_TIMDCMP1         HRTIM_CPT2CR_TIMDCMP1_Msk                /*!< Timer D compare 1 */
#define HRTIM_CPT2CR_TIMDCMP2_Pos     (27U)                                    
#define HRTIM_CPT2CR_TIMDCMP2_Msk     (0x1U << HRTIM_CPT2CR_TIMDCMP2_Pos)      /*!< 0x08000000 */
#define HRTIM_CPT2CR_TIMDCMP2         HRTIM_CPT2CR_TIMDCMP2_Msk                /*!< Timer D compare 2 */

#define HRTIM_CPT2CR_TE1SET_Pos       (28U)                                    
#define HRTIM_CPT2CR_TE1SET_Msk       (0x1U << HRTIM_CPT2CR_TE1SET_Pos)        /*!< 0x10000000 */
#define HRTIM_CPT2CR_TE1SET           HRTIM_CPT2CR_TE1SET_Msk                  /*!< Timer E output 1 set */
#define HRTIM_CPT2CR_TE1RST_Pos       (29U)                                    
#define HRTIM_CPT2CR_TE1RST_Msk       (0x1U << HRTIM_CPT2CR_TE1RST_Pos)        /*!< 0x20000000 */
#define HRTIM_CPT2CR_TE1RST           HRTIM_CPT2CR_TE1RST_Msk                  /*!< Timer E output 1 reset */
#define HRTIM_CPT2CR_TIMECMP1_Pos     (30U)                                    
#define HRTIM_CPT2CR_TIMECMP1_Msk     (0x1U << HRTIM_CPT2CR_TIMECMP1_Pos)      /*!< 0x40000000 */
#define HRTIM_CPT2CR_TIMECMP1         HRTIM_CPT2CR_TIMECMP1_Msk                /*!< Timer E compare 1 */
#define HRTIM_CPT2CR_TIMECMP2_Pos     (31U)                                    
#define HRTIM_CPT2CR_TIMECMP2_Msk     (0x1U << HRTIM_CPT2CR_TIMECMP2_Pos)      /*!< 0x80000000 */
#define HRTIM_CPT2CR_TIMECMP2         HRTIM_CPT2CR_TIMECMP2_Msk                /*!< Timer E compare 2 */

/**** Bit definition for Slave Timer Output register **************************/
#define HRTIM_OUTR_POL1_Pos           (1U)                                     
#define HRTIM_OUTR_POL1_Msk           (0x1U << HRTIM_OUTR_POL1_Pos)            /*!< 0x00000002 */
#define HRTIM_OUTR_POL1               HRTIM_OUTR_POL1_Msk                      /*!< Slave output 1 polarity */
#define HRTIM_OUTR_IDLM1_Pos          (2U)                                     
#define HRTIM_OUTR_IDLM1_Msk          (0x1U << HRTIM_OUTR_IDLM1_Pos)           /*!< 0x00000004 */
#define HRTIM_OUTR_IDLM1              HRTIM_OUTR_IDLM1_Msk                     /*!< Slave output 1 idle mode */
#define HRTIM_OUTR_IDLES1_Pos         (3U)                                     
#define HRTIM_OUTR_IDLES1_Msk         (0x1U << HRTIM_OUTR_IDLES1_Pos)          /*!< 0x00000008 */
#define HRTIM_OUTR_IDLES1             HRTIM_OUTR_IDLES1_Msk                    /*!< Slave output 1 idle state */
#define HRTIM_OUTR_FAULT1_Pos         (4U)                                     
#define HRTIM_OUTR_FAULT1_Msk         (0x3U << HRTIM_OUTR_FAULT1_Pos)          /*!< 0x00000030 */
#define HRTIM_OUTR_FAULT1             HRTIM_OUTR_FAULT1_Msk                    /*!< Slave output 1 fault state */
#define HRTIM_OUTR_FAULT1_0           (0x1U << HRTIM_OUTR_FAULT1_Pos)          /*!< 0x00000010 */
#define HRTIM_OUTR_FAULT1_1           (0x2U << HRTIM_OUTR_FAULT1_Pos)          /*!< 0x00000020 */
#define HRTIM_OUTR_CHP1_Pos           (6U)                                     
#define HRTIM_OUTR_CHP1_Msk           (0x1U << HRTIM_OUTR_CHP1_Pos)            /*!< 0x00000040 */
#define HRTIM_OUTR_CHP1               HRTIM_OUTR_CHP1_Msk                      /*!< Slave output 1 chopper enable */
#define HRTIM_OUTR_DIDL1_Pos          (7U)                                     
#define HRTIM_OUTR_DIDL1_Msk          (0x1U << HRTIM_OUTR_DIDL1_Pos)           /*!< 0x00000080 */
#define HRTIM_OUTR_DIDL1              HRTIM_OUTR_DIDL1_Msk                     /*!< Slave output 1 dead time idle */

#define HRTIM_OUTR_DTEN_Pos           (8U)                                     
#define HRTIM_OUTR_DTEN_Msk           (0x1U << HRTIM_OUTR_DTEN_Pos)            /*!< 0x00000100 */
#define HRTIM_OUTR_DTEN               HRTIM_OUTR_DTEN_Msk                      /*!< Slave output deadtime enable */
#define HRTIM_OUTR_DLYPRTEN_Pos       (9U)                                     
#define HRTIM_OUTR_DLYPRTEN_Msk       (0x1U << HRTIM_OUTR_DLYPRTEN_Pos)        /*!< 0x00000200 */
#define HRTIM_OUTR_DLYPRTEN           HRTIM_OUTR_DLYPRTEN_Msk                  /*!< Slave output delay protection enable */
#define HRTIM_OUTR_DLYPRT_Pos         (10U)                                    
#define HRTIM_OUTR_DLYPRT_Msk         (0x7U << HRTIM_OUTR_DLYPRT_Pos)          /*!< 0x00001C00 */
#define HRTIM_OUTR_DLYPRT             HRTIM_OUTR_DLYPRT_Msk                    /*!< Slave output delay protection */
#define HRTIM_OUTR_DLYPRT_0           (0x1U << HRTIM_OUTR_DLYPRT_Pos)          /*!< 0x00000400 */
#define HRTIM_OUTR_DLYPRT_1           (0x2U << HRTIM_OUTR_DLYPRT_Pos)          /*!< 0x00000800 */
#define HRTIM_OUTR_DLYPRT_2           (0x4U << HRTIM_OUTR_DLYPRT_Pos)          /*!< 0x00001000 */

#define HRTIM_OUTR_POL2_Pos           (17U)                                    
#define HRTIM_OUTR_POL2_Msk           (0x1U << HRTIM_OUTR_POL2_Pos)            /*!< 0x00020000 */
#define HRTIM_OUTR_POL2               HRTIM_OUTR_POL2_Msk                      /*!< Slave output 2 polarity */
#define HRTIM_OUTR_IDLM2_Pos          (18U)                                    
#define HRTIM_OUTR_IDLM2_Msk          (0x1U << HRTIM_OUTR_IDLM2_Pos)           /*!< 0x00040000 */
#define HRTIM_OUTR_IDLM2              HRTIM_OUTR_IDLM2_Msk                     /*!< Slave output 2 idle mode */
#define HRTIM_OUTR_IDLES2_Pos         (19U)                                    
#define HRTIM_OUTR_IDLES2_Msk         (0x1U << HRTIM_OUTR_IDLES2_Pos)          /*!< 0x00080000 */
#define HRTIM_OUTR_IDLES2             HRTIM_OUTR_IDLES2_Msk                    /*!< Slave output 2 idle state */
#define HRTIM_OUTR_FAULT2_Pos         (20U)                                    
#define HRTIM_OUTR_FAULT2_Msk         (0x3U << HRTIM_OUTR_FAULT2_Pos)          /*!< 0x00300000 */
#define HRTIM_OUTR_FAULT2             HRTIM_OUTR_FAULT2_Msk                    /*!< Slave output 2 fault state */
#define HRTIM_OUTR_FAULT2_0           (0x1U << HRTIM_OUTR_FAULT2_Pos)          /*!< 0x00100000 */
#define HRTIM_OUTR_FAULT2_1           (0x2U << HRTIM_OUTR_FAULT2_Pos)          /*!< 0x00200000 */
#define HRTIM_OUTR_CHP2_Pos           (22U)                                    
#define HRTIM_OUTR_CHP2_Msk           (0x1U << HRTIM_OUTR_CHP2_Pos)            /*!< 0x00400000 */
#define HRTIM_OUTR_CHP2               HRTIM_OUTR_CHP2_Msk                      /*!< Slave output 2 chopper enable */
#define HRTIM_OUTR_DIDL2_Pos          (23U)                                    
#define HRTIM_OUTR_DIDL2_Msk          (0x1U << HRTIM_OUTR_DIDL2_Pos)           /*!< 0x00800000 */
#define HRTIM_OUTR_DIDL2              HRTIM_OUTR_DIDL2_Msk                     /*!< Slave output 2 dead time idle */

/**** Bit definition for Slave Timer Fault register ***************************/
#define HRTIM_FLTR_FLT1EN_Pos         (0U)                                     
#define HRTIM_FLTR_FLT1EN_Msk         (0x1U << HRTIM_FLTR_FLT1EN_Pos)          /*!< 0x00000001 */
#define HRTIM_FLTR_FLT1EN             HRTIM_FLTR_FLT1EN_Msk                    /*!< Fault 1 enable */
#define HRTIM_FLTR_FLT2EN_Pos         (1U)                                     
#define HRTIM_FLTR_FLT2EN_Msk         (0x1U << HRTIM_FLTR_FLT2EN_Pos)          /*!< 0x00000002 */
#define HRTIM_FLTR_FLT2EN             HRTIM_FLTR_FLT2EN_Msk                    /*!< Fault 2 enable */
#define HRTIM_FLTR_FLT3EN_Pos         (2U)                                     
#define HRTIM_FLTR_FLT3EN_Msk         (0x1U << HRTIM_FLTR_FLT3EN_Pos)          /*!< 0x00000004 */
#define HRTIM_FLTR_FLT3EN             HRTIM_FLTR_FLT3EN_Msk                    /*!< Fault 3 enable */
#define HRTIM_FLTR_FLT4EN_Pos         (3U)                                     
#define HRTIM_FLTR_FLT4EN_Msk         (0x1U << HRTIM_FLTR_FLT4EN_Pos)          /*!< 0x00000008 */
#define HRTIM_FLTR_FLT4EN             HRTIM_FLTR_FLT4EN_Msk                    /*!< Fault 4 enable */
#define HRTIM_FLTR_FLT5EN_Pos         (4U)                                     
#define HRTIM_FLTR_FLT5EN_Msk         (0x1U << HRTIM_FLTR_FLT5EN_Pos)          /*!< 0x00000010 */
#define HRTIM_FLTR_FLT5EN             HRTIM_FLTR_FLT5EN_Msk                    /*!< Fault 5 enable */
#define HRTIM_FLTR_FLTLCK_Pos         (31U)                                    
#define HRTIM_FLTR_FLTLCK_Msk         (0x1U << HRTIM_FLTR_FLTLCK_Pos)          /*!< 0x80000000 */
#define HRTIM_FLTR_FLTLCK             HRTIM_FLTR_FLTLCK_Msk                    /*!< Fault sources lock */

/**** Bit definition for Common HRTIM Timer control register 1 ****************/
#define HRTIM_CR1_MUDIS_Pos           (0U)                                     
#define HRTIM_CR1_MUDIS_Msk           (0x1U << HRTIM_CR1_MUDIS_Pos)            /*!< 0x00000001 */
#define HRTIM_CR1_MUDIS               HRTIM_CR1_MUDIS_Msk                      /*!< Master update disable*/
#define HRTIM_CR1_TAUDIS_Pos          (1U)                                     
#define HRTIM_CR1_TAUDIS_Msk          (0x1U << HRTIM_CR1_TAUDIS_Pos)           /*!< 0x00000002 */
#define HRTIM_CR1_TAUDIS              HRTIM_CR1_TAUDIS_Msk                     /*!< Timer A update disable*/
#define HRTIM_CR1_TBUDIS_Pos          (2U)                                     
#define HRTIM_CR1_TBUDIS_Msk          (0x1U << HRTIM_CR1_TBUDIS_Pos)           /*!< 0x00000004 */
#define HRTIM_CR1_TBUDIS              HRTIM_CR1_TBUDIS_Msk                     /*!< Timer B update disable*/
#define HRTIM_CR1_TCUDIS_Pos          (3U)                                     
#define HRTIM_CR1_TCUDIS_Msk          (0x1U << HRTIM_CR1_TCUDIS_Pos)           /*!< 0x00000008 */
#define HRTIM_CR1_TCUDIS              HRTIM_CR1_TCUDIS_Msk                     /*!< Timer C update disable*/
#define HRTIM_CR1_TDUDIS_Pos          (4U)                                     
#define HRTIM_CR1_TDUDIS_Msk          (0x1U << HRTIM_CR1_TDUDIS_Pos)           /*!< 0x00000010 */
#define HRTIM_CR1_TDUDIS              HRTIM_CR1_TDUDIS_Msk                     /*!< Timer D update disable*/
#define HRTIM_CR1_TEUDIS_Pos          (5U)                                     
#define HRTIM_CR1_TEUDIS_Msk          (0x1U << HRTIM_CR1_TEUDIS_Pos)           /*!< 0x00000020 */
#define HRTIM_CR1_TEUDIS              HRTIM_CR1_TEUDIS_Msk                     /*!< Timer E update disable*/
#define HRTIM_CR1_ADC1USRC_Pos        (16U)                                    
#define HRTIM_CR1_ADC1USRC_Msk        (0x7U << HRTIM_CR1_ADC1USRC_Pos)         /*!< 0x00070000 */
#define HRTIM_CR1_ADC1USRC            HRTIM_CR1_ADC1USRC_Msk                   /*!< ADC Trigger 1 update source */
#define HRTIM_CR1_ADC1USRC_0          (0x1U << HRTIM_CR1_ADC1USRC_Pos)         /*!< 0x00010000 */
#define HRTIM_CR1_ADC1USRC_1          (0x2U << HRTIM_CR1_ADC1USRC_Pos)         /*!< 0x00020000 */
#define HRTIM_CR1_ADC1USRC_2          (0x4U << HRTIM_CR1_ADC1USRC_Pos)         /*!< 0x00040000 */
#define HRTIM_CR1_ADC2USRC_Pos        (19U)                                    
#define HRTIM_CR1_ADC2USRC_Msk        (0x7U << HRTIM_CR1_ADC2USRC_Pos)         /*!< 0x00380000 */
#define HRTIM_CR1_ADC2USRC            HRTIM_CR1_ADC2USRC_Msk                   /*!< ADC Trigger 2 update source */
#define HRTIM_CR1_ADC2USRC_0          (0x1U << HRTIM_CR1_ADC2USRC_Pos)         /*!< 0x00080000 */
#define HRTIM_CR1_ADC2USRC_1          (0x2U << HRTIM_CR1_ADC2USRC_Pos)         /*!< 0x00100000 */
#define HRTIM_CR1_ADC2USRC_2          (0x4U << HRTIM_CR1_ADC2USRC_Pos)         /*!< 0x00200000 */
#define HRTIM_CR1_ADC3USRC_Pos        (22U)                                    
#define HRTIM_CR1_ADC3USRC_Msk        (0x7U << HRTIM_CR1_ADC3USRC_Pos)         /*!< 0x01C00000 */
#define HRTIM_CR1_ADC3USRC            HRTIM_CR1_ADC3USRC_Msk                   /*!< ADC Trigger 3 update source */
#define HRTIM_CR1_ADC3USRC_0          (0x1U << HRTIM_CR1_ADC3USRC_Pos)         /*!< 0x00400000 */
#define HRTIM_CR1_ADC3USRC_1          (0x2U << HRTIM_CR1_ADC3USRC_Pos)         /*!< 0x00800000 */
#define HRTIM_CR1_ADC3USRC_2          (0x4U << HRTIM_CR1_ADC3USRC_Pos)         /*!< 0x01000000 */
#define HRTIM_CR1_ADC4USRC_Pos        (25U)                                    
#define HRTIM_CR1_ADC4USRC_Msk        (0x7U << HRTIM_CR1_ADC4USRC_Pos)         /*!< 0x0E000000 */
#define HRTIM_CR1_ADC4USRC            HRTIM_CR1_ADC4USRC_Msk                   /*!< ADC Trigger 4 update source */
#define HRTIM_CR1_ADC4USRC_0          (0x1U << HRTIM_CR1_ADC4USRC_Pos)         /*!< 0x02000000 */
#define HRTIM_CR1_ADC4USRC_1          (0x2U << HRTIM_CR1_ADC4USRC_Pos)         /*!< 0x04000000 */
#define HRTIM_CR1_ADC4USRC_2          (0x0U << HRTIM_CR1_ADC4USRC_Pos)         /*!< 0x0800000 */

/**** Bit definition for Common HRTIM Timer control register 2 ****************/
#define HRTIM_CR2_MSWU_Pos            (0U)                                     
#define HRTIM_CR2_MSWU_Msk            (0x1U << HRTIM_CR2_MSWU_Pos)             /*!< 0x00000001 */
#define HRTIM_CR2_MSWU                HRTIM_CR2_MSWU_Msk                       /*!< Master software update */
#define HRTIM_CR2_TASWU_Pos           (1U)                                     
#define HRTIM_CR2_TASWU_Msk           (0x1U << HRTIM_CR2_TASWU_Pos)            /*!< 0x00000002 */
#define HRTIM_CR2_TASWU               HRTIM_CR2_TASWU_Msk                      /*!< Timer A software update */
#define HRTIM_CR2_TBSWU_Pos           (2U)                                     
#define HRTIM_CR2_TBSWU_Msk           (0x1U << HRTIM_CR2_TBSWU_Pos)            /*!< 0x00000004 */
#define HRTIM_CR2_TBSWU               HRTIM_CR2_TBSWU_Msk                      /*!< Timer B software update */
#define HRTIM_CR2_TCSWU_Pos           (3U)                                     
#define HRTIM_CR2_TCSWU_Msk           (0x1U << HRTIM_CR2_TCSWU_Pos)            /*!< 0x00000008 */
#define HRTIM_CR2_TCSWU               HRTIM_CR2_TCSWU_Msk                      /*!< Timer C software update */
#define HRTIM_CR2_TDSWU_Pos           (4U)                                     
#define HRTIM_CR2_TDSWU_Msk           (0x1U << HRTIM_CR2_TDSWU_Pos)            /*!< 0x00000010 */
#define HRTIM_CR2_TDSWU               HRTIM_CR2_TDSWU_Msk                      /*!< Timer D software update */
#define HRTIM_CR2_TESWU_Pos           (5U)                                     
#define HRTIM_CR2_TESWU_Msk           (0x1U << HRTIM_CR2_TESWU_Pos)            /*!< 0x00000020 */
#define HRTIM_CR2_TESWU               HRTIM_CR2_TESWU_Msk                      /*!< Timer E software update */
#define HRTIM_CR2_MRST_Pos            (8U)                                     
#define HRTIM_CR2_MRST_Msk            (0x1U << HRTIM_CR2_MRST_Pos)             /*!< 0x00000100 */
#define HRTIM_CR2_MRST                HRTIM_CR2_MRST_Msk                       /*!< Master count software reset */
#define HRTIM_CR2_TARST_Pos           (9U)                                     
#define HRTIM_CR2_TARST_Msk           (0x1U << HRTIM_CR2_TARST_Pos)            /*!< 0x00000200 */
#define HRTIM_CR2_TARST               HRTIM_CR2_TARST_Msk                      /*!< Timer A count software reset */
#define HRTIM_CR2_TBRST_Pos           (10U)                                    
#define HRTIM_CR2_TBRST_Msk           (0x1U << HRTIM_CR2_TBRST_Pos)            /*!< 0x00000400 */
#define HRTIM_CR2_TBRST               HRTIM_CR2_TBRST_Msk                      /*!< Timer B count software reset */
#define HRTIM_CR2_TCRST_Pos           (11U)                                    
#define HRTIM_CR2_TCRST_Msk           (0x1U << HRTIM_CR2_TCRST_Pos)            /*!< 0x00000800 */
#define HRTIM_CR2_TCRST               HRTIM_CR2_TCRST_Msk                      /*!< Timer C count software reset */
#define HRTIM_CR2_TDRST_Pos           (12U)                                    
#define HRTIM_CR2_TDRST_Msk           (0x1U << HRTIM_CR2_TDRST_Pos)            /*!< 0x00001000 */
#define HRTIM_CR2_TDRST               HRTIM_CR2_TDRST_Msk                      /*!< Timer D count software reset */
#define HRTIM_CR2_TERST_Pos           (13U)                                    
#define HRTIM_CR2_TERST_Msk           (0x1U << HRTIM_CR2_TERST_Pos)            /*!< 0x00002000 */
#define HRTIM_CR2_TERST               HRTIM_CR2_TERST_Msk                      /*!< Timer E count software reset */

/**** Bit definition for Common HRTIM Timer interrupt status register *********/
#define HRTIM_ISR_FLT1_Pos            (0U)                                     
#define HRTIM_ISR_FLT1_Msk            (0x1U << HRTIM_ISR_FLT1_Pos)             /*!< 0x00000001 */
#define HRTIM_ISR_FLT1                HRTIM_ISR_FLT1_Msk                       /*!< Fault 1 interrupt flag */
#define HRTIM_ISR_FLT2_Pos            (1U)                                     
#define HRTIM_ISR_FLT2_Msk            (0x1U << HRTIM_ISR_FLT2_Pos)             /*!< 0x00000002 */
#define HRTIM_ISR_FLT2                HRTIM_ISR_FLT2_Msk                       /*!< Fault 2 interrupt flag */
#define HRTIM_ISR_FLT3_Pos            (2U)                                     
#define HRTIM_ISR_FLT3_Msk            (0x1U << HRTIM_ISR_FLT3_Pos)             /*!< 0x00000004 */
#define HRTIM_ISR_FLT3                HRTIM_ISR_FLT3_Msk                       /*!< Fault 3 interrupt flag */
#define HRTIM_ISR_FLT4_Pos            (3U)                                     
#define HRTIM_ISR_FLT4_Msk            (0x1U << HRTIM_ISR_FLT4_Pos)             /*!< 0x00000008 */
#define HRTIM_ISR_FLT4                HRTIM_ISR_FLT4_Msk                       /*!< Fault 4 interrupt flag */
#define HRTIM_ISR_FLT5_Pos            (4U)                                     
#define HRTIM_ISR_FLT5_Msk            (0x1U << HRTIM_ISR_FLT5_Pos)             /*!< 0x00000010 */
#define HRTIM_ISR_FLT5                HRTIM_ISR_FLT5_Msk                       /*!< Fault 5 interrupt flag */
#define HRTIM_ISR_SYSFLT_Pos          (5U)                                     
#define HRTIM_ISR_SYSFLT_Msk          (0x1U << HRTIM_ISR_SYSFLT_Pos)           /*!< 0x00000020 */
#define HRTIM_ISR_SYSFLT              HRTIM_ISR_SYSFLT_Msk                     /*!< System Fault interrupt flag */
#define HRTIM_ISR_DLLRDY_Pos          (16U)                                    
#define HRTIM_ISR_DLLRDY_Msk          (0x1U << HRTIM_ISR_DLLRDY_Pos)           /*!< 0x00010000 */
#define HRTIM_ISR_DLLRDY              HRTIM_ISR_DLLRDY_Msk                     /*!< DLL ready interrupt flag */
#define HRTIM_ISR_BMPER_Pos           (17U)                                    
#define HRTIM_ISR_BMPER_Msk           (0x1U << HRTIM_ISR_BMPER_Pos)            /*!< 0x00020000 */
#define HRTIM_ISR_BMPER               HRTIM_ISR_BMPER_Msk                      /*!<  Burst mode period interrupt flag */

/**** Bit definition for Common HRTIM Timer interrupt clear register **********/
#define HRTIM_ICR_FLT1C_Pos           (0U)                                     
#define HRTIM_ICR_FLT1C_Msk           (0x1U << HRTIM_ICR_FLT1C_Pos)            /*!< 0x00000001 */
#define HRTIM_ICR_FLT1C               HRTIM_ICR_FLT1C_Msk                      /*!< Fault 1 interrupt flag clear */
#define HRTIM_ICR_FLT2C_Pos           (1U)                                     
#define HRTIM_ICR_FLT2C_Msk           (0x1U << HRTIM_ICR_FLT2C_Pos)            /*!< 0x00000002 */
#define HRTIM_ICR_FLT2C               HRTIM_ICR_FLT2C_Msk                      /*!< Fault 2 interrupt flag clear */
#define HRTIM_ICR_FLT3C_Pos           (2U)                                     
#define HRTIM_ICR_FLT3C_Msk           (0x1U << HRTIM_ICR_FLT3C_Pos)            /*!< 0x00000004 */
#define HRTIM_ICR_FLT3C               HRTIM_ICR_FLT3C_Msk                      /*!< Fault 3 interrupt flag clear */
#define HRTIM_ICR_FLT4C_Pos           (3U)                                     
#define HRTIM_ICR_FLT4C_Msk           (0x1U << HRTIM_ICR_FLT4C_Pos)            /*!< 0x00000008 */
#define HRTIM_ICR_FLT4C               HRTIM_ICR_FLT4C_Msk                      /*!< Fault 4 interrupt flag clear */
#define HRTIM_ICR_FLT5C_Pos           (4U)                                     
#define HRTIM_ICR_FLT5C_Msk           (0x1U << HRTIM_ICR_FLT5C_Pos)            /*!< 0x00000010 */
#define HRTIM_ICR_FLT5C               HRTIM_ICR_FLT5C_Msk                      /*!< Fault 5 interrupt flag clear */
#define HRTIM_ICR_SYSFLTC_Pos         (5U)                                     
#define HRTIM_ICR_SYSFLTC_Msk         (0x1U << HRTIM_ICR_SYSFLTC_Pos)          /*!< 0x00000020 */
#define HRTIM_ICR_SYSFLTC             HRTIM_ICR_SYSFLTC_Msk                    /*!< System Fault interrupt flag clear */
#define HRTIM_ICR_DLLRDYC_Pos         (16U)                                    
#define HRTIM_ICR_DLLRDYC_Msk         (0x1U << HRTIM_ICR_DLLRDYC_Pos)          /*!< 0x00010000 */
#define HRTIM_ICR_DLLRDYC             HRTIM_ICR_DLLRDYC_Msk                    /*!< DLL ready interrupt flag clear */
#define HRTIM_ICR_BMPERC_Pos          (17U)                                    
#define HRTIM_ICR_BMPERC_Msk          (0x1U << HRTIM_ICR_BMPERC_Pos)           /*!< 0x00020000 */
#define HRTIM_ICR_BMPERC              HRTIM_ICR_BMPERC_Msk                     /*!<  Burst mode period interrupt flag clear */

/**** Bit definition for Common HRTIM Timer interrupt enable register *********/
#define HRTIM_IER_FLT1_Pos            (0U)                                     
#define HRTIM_IER_FLT1_Msk            (0x1U << HRTIM_IER_FLT1_Pos)             /*!< 0x00000001 */
#define HRTIM_IER_FLT1                HRTIM_IER_FLT1_Msk                       /*!< Fault 1 interrupt enable */
#define HRTIM_IER_FLT2_Pos            (1U)                                     
#define HRTIM_IER_FLT2_Msk            (0x1U << HRTIM_IER_FLT2_Pos)             /*!< 0x00000002 */
#define HRTIM_IER_FLT2                HRTIM_IER_FLT2_Msk                       /*!< Fault 2 interrupt enable */
#define HRTIM_IER_FLT3_Pos            (2U)                                     
#define HRTIM_IER_FLT3_Msk            (0x1U << HRTIM_IER_FLT3_Pos)             /*!< 0x00000004 */
#define HRTIM_IER_FLT3                HRTIM_IER_FLT3_Msk                       /*!< Fault 3 interrupt enable */
#define HRTIM_IER_FLT4_Pos            (3U)                                     
#define HRTIM_IER_FLT4_Msk            (0x1U << HRTIM_IER_FLT4_Pos)             /*!< 0x00000008 */
#define HRTIM_IER_FLT4                HRTIM_IER_FLT4_Msk                       /*!< Fault 4 interrupt enable */
#define HRTIM_IER_FLT5_Pos            (4U)                                     
#define HRTIM_IER_FLT5_Msk            (0x1U << HRTIM_IER_FLT5_Pos)             /*!< 0x00000010 */
#define HRTIM_IER_FLT5                HRTIM_IER_FLT5_Msk                       /*!< Fault 5 interrupt enable */
#define HRTIM_IER_SYSFLT_Pos          (5U)                                     
#define HRTIM_IER_SYSFLT_Msk          (0x1U << HRTIM_IER_SYSFLT_Pos)           /*!< 0x00000020 */
#define HRTIM_IER_SYSFLT              HRTIM_IER_SYSFLT_Msk                     /*!< System Fault interrupt enable */
#define HRTIM_IER_DLLRDY_Pos          (16U)                                    
#define HRTIM_IER_DLLRDY_Msk          (0x1U << HRTIM_IER_DLLRDY_Pos)           /*!< 0x00010000 */
#define HRTIM_IER_DLLRDY              HRTIM_IER_DLLRDY_Msk                     /*!< DLL ready interrupt enable */
#define HRTIM_IER_BMPER_Pos           (17U)                                    
#define HRTIM_IER_BMPER_Msk           (0x1U << HRTIM_IER_BMPER_Pos)            /*!< 0x00020000 */
#define HRTIM_IER_BMPER               HRTIM_IER_BMPER_Msk                      /*!<  Burst mode period interrupt enable */

/**** Bit definition for Common HRTIM Timer output enable register ************/
#define HRTIM_OENR_TA1OEN_Pos         (0U)                                     
#define HRTIM_OENR_TA1OEN_Msk         (0x1U << HRTIM_OENR_TA1OEN_Pos)          /*!< 0x00000001 */
#define HRTIM_OENR_TA1OEN             HRTIM_OENR_TA1OEN_Msk                    /*!< Timer A Output 1 enable */
#define HRTIM_OENR_TA2OEN_Pos         (1U)                                     
#define HRTIM_OENR_TA2OEN_Msk         (0x1U << HRTIM_OENR_TA2OEN_Pos)          /*!< 0x00000002 */
#define HRTIM_OENR_TA2OEN             HRTIM_OENR_TA2OEN_Msk                    /*!< Timer A Output 2 enable */
#define HRTIM_OENR_TB1OEN_Pos         (2U)                                     
#define HRTIM_OENR_TB1OEN_Msk         (0x1U << HRTIM_OENR_TB1OEN_Pos)          /*!< 0x00000004 */
#define HRTIM_OENR_TB1OEN             HRTIM_OENR_TB1OEN_Msk                    /*!< Timer B Output 1 enable */
#define HRTIM_OENR_TB2OEN_Pos         (3U)                                     
#define HRTIM_OENR_TB2OEN_Msk         (0x1U << HRTIM_OENR_TB2OEN_Pos)          /*!< 0x00000008 */
#define HRTIM_OENR_TB2OEN             HRTIM_OENR_TB2OEN_Msk                    /*!< Timer B Output 2 enable */
#define HRTIM_OENR_TC1OEN_Pos         (4U)                                     
#define HRTIM_OENR_TC1OEN_Msk         (0x1U << HRTIM_OENR_TC1OEN_Pos)          /*!< 0x00000010 */
#define HRTIM_OENR_TC1OEN             HRTIM_OENR_TC1OEN_Msk                    /*!< Timer C Output 1 enable */
#define HRTIM_OENR_TC2OEN_Pos         (5U)                                     
#define HRTIM_OENR_TC2OEN_Msk         (0x1U << HRTIM_OENR_TC2OEN_Pos)          /*!< 0x00000020 */
#define HRTIM_OENR_TC2OEN             HRTIM_OENR_TC2OEN_Msk                    /*!< Timer C Output 2 enable */
#define HRTIM_OENR_TD1OEN_Pos         (6U)                                     
#define HRTIM_OENR_TD1OEN_Msk         (0x1U << HRTIM_OENR_TD1OEN_Pos)          /*!< 0x00000040 */
#define HRTIM_OENR_TD1OEN             HRTIM_OENR_TD1OEN_Msk                    /*!< Timer D Output 1 enable */
#define HRTIM_OENR_TD2OEN_Pos         (7U)                                     
#define HRTIM_OENR_TD2OEN_Msk         (0x1U << HRTIM_OENR_TD2OEN_Pos)          /*!< 0x00000080 */
#define HRTIM_OENR_TD2OEN             HRTIM_OENR_TD2OEN_Msk                    /*!< Timer D Output 2 enable */
#define HRTIM_OENR_TE1OEN_Pos         (8U)                                     
#define HRTIM_OENR_TE1OEN_Msk         (0x1U << HRTIM_OENR_TE1OEN_Pos)          /*!< 0x00000100 */
#define HRTIM_OENR_TE1OEN             HRTIM_OENR_TE1OEN_Msk                    /*!< Timer E Output 1 enable */
#define HRTIM_OENR_TE2OEN_Pos         (9U)                                     
#define HRTIM_OENR_TE2OEN_Msk         (0x1U << HRTIM_OENR_TE2OEN_Pos)          /*!< 0x00000200 */
#define HRTIM_OENR_TE2OEN             HRTIM_OENR_TE2OEN_Msk                    /*!< Timer E Output 2 enable */

/**** Bit definition for Common HRTIM Timer output disable register ***********/
#define HRTIM_ODISR_TA1ODIS_Pos       (0U)                                     
#define HRTIM_ODISR_TA1ODIS_Msk       (0x1U << HRTIM_ODISR_TA1ODIS_Pos)        /*!< 0x00000001 */
#define HRTIM_ODISR_TA1ODIS           HRTIM_ODISR_TA1ODIS_Msk                  /*!< Timer A Output 1 disable */
#define HRTIM_ODISR_TA2ODIS_Pos       (1U)                                     
#define HRTIM_ODISR_TA2ODIS_Msk       (0x1U << HRTIM_ODISR_TA2ODIS_Pos)        /*!< 0x00000002 */
#define HRTIM_ODISR_TA2ODIS           HRTIM_ODISR_TA2ODIS_Msk                  /*!< Timer A Output 2 disable */
#define HRTIM_ODISR_TB1ODIS_Pos       (2U)                                     
#define HRTIM_ODISR_TB1ODIS_Msk       (0x1U << HRTIM_ODISR_TB1ODIS_Pos)        /*!< 0x00000004 */
#define HRTIM_ODISR_TB1ODIS           HRTIM_ODISR_TB1ODIS_Msk                  /*!< Timer B Output 1 disable */
#define HRTIM_ODISR_TB2ODIS_Pos       (3U)                                     
#define HRTIM_ODISR_TB2ODIS_Msk       (0x1U << HRTIM_ODISR_TB2ODIS_Pos)        /*!< 0x00000008 */
#define HRTIM_ODISR_TB2ODIS           HRTIM_ODISR_TB2ODIS_Msk                  /*!< Timer B Output 2 disable */
#define HRTIM_ODISR_TC1ODIS_Pos       (4U)                                     
#define HRTIM_ODISR_TC1ODIS_Msk       (0x1U << HRTIM_ODISR_TC1ODIS_Pos)        /*!< 0x00000010 */
#define HRTIM_ODISR_TC1ODIS           HRTIM_ODISR_TC1ODIS_Msk                  /*!< Timer C Output 1 disable */
#define HRTIM_ODISR_TC2ODIS_Pos       (5U)                                     
#define HRTIM_ODISR_TC2ODIS_Msk       (0x1U << HRTIM_ODISR_TC2ODIS_Pos)        /*!< 0x00000020 */
#define HRTIM_ODISR_TC2ODIS           HRTIM_ODISR_TC2ODIS_Msk                  /*!< Timer C Output 2 disable */
#define HRTIM_ODISR_TD1ODIS_Pos       (6U)                                     
#define HRTIM_ODISR_TD1ODIS_Msk       (0x1U << HRTIM_ODISR_TD1ODIS_Pos)        /*!< 0x00000040 */
#define HRTIM_ODISR_TD1ODIS           HRTIM_ODISR_TD1ODIS_Msk                  /*!< Timer D Output 1 disable */
#define HRTIM_ODISR_TD2ODIS_Pos       (7U)                                     
#define HRTIM_ODISR_TD2ODIS_Msk       (0x1U << HRTIM_ODISR_TD2ODIS_Pos)        /*!< 0x00000080 */
#define HRTIM_ODISR_TD2ODIS           HRTIM_ODISR_TD2ODIS_Msk                  /*!< Timer D Output 2 disable */
#define HRTIM_ODISR_TE1ODIS_Pos       (8U)                                     
#define HRTIM_ODISR_TE1ODIS_Msk       (0x1U << HRTIM_ODISR_TE1ODIS_Pos)        /*!< 0x00000100 */
#define HRTIM_ODISR_TE1ODIS           HRTIM_ODISR_TE1ODIS_Msk                  /*!< Timer E Output 1 disable */
#define HRTIM_ODISR_TE2ODIS_Pos       (9U)                                     
#define HRTIM_ODISR_TE2ODIS_Msk       (0x1U << HRTIM_ODISR_TE2ODIS_Pos)        /*!< 0x00000200 */
#define HRTIM_ODISR_TE2ODIS           HRTIM_ODISR_TE2ODIS_Msk                  /*!< Timer E Output 2 disable */

/**** Bit definition for Common HRTIM Timer output disable status register *****/
#define HRTIM_ODSR_TA1ODS_Pos         (0U)                                     
#define HRTIM_ODSR_TA1ODS_Msk         (0x1U << HRTIM_ODSR_TA1ODS_Pos)          /*!< 0x00000001 */
#define HRTIM_ODSR_TA1ODS             HRTIM_ODSR_TA1ODS_Msk                    /*!< Timer A Output 1 disable status */
#define HRTIM_ODSR_TA2ODS_Pos         (1U)                                     
#define HRTIM_ODSR_TA2ODS_Msk         (0x1U << HRTIM_ODSR_TA2ODS_Pos)          /*!< 0x00000002 */
#define HRTIM_ODSR_TA2ODS             HRTIM_ODSR_TA2ODS_Msk                    /*!< Timer A Output 2 disable status */
#define HRTIM_ODSR_TB1ODS_Pos         (2U)                                     
#define HRTIM_ODSR_TB1ODS_Msk         (0x1U << HRTIM_ODSR_TB1ODS_Pos)          /*!< 0x00000004 */
#define HRTIM_ODSR_TB1ODS             HRTIM_ODSR_TB1ODS_Msk                    /*!< Timer B Output 1 disable status */
#define HRTIM_ODSR_TB2ODS_Pos         (3U)                                     
#define HRTIM_ODSR_TB2ODS_Msk         (0x1U << HRTIM_ODSR_TB2ODS_Pos)          /*!< 0x00000008 */
#define HRTIM_ODSR_TB2ODS             HRTIM_ODSR_TB2ODS_Msk                    /*!< Timer B Output 2 disable status */
#define HRTIM_ODSR_TC1ODS_Pos         (4U)                                     
#define HRTIM_ODSR_TC1ODS_Msk         (0x1U << HRTIM_ODSR_TC1ODS_Pos)          /*!< 0x00000010 */
#define HRTIM_ODSR_TC1ODS             HRTIM_ODSR_TC1ODS_Msk                    /*!< Timer C Output 1 disable status */
#define HRTIM_ODSR_TC2ODS_Pos         (5U)                                     
#define HRTIM_ODSR_TC2ODS_Msk         (0x1U << HRTIM_ODSR_TC2ODS_Pos)          /*!< 0x00000020 */
#define HRTIM_ODSR_TC2ODS             HRTIM_ODSR_TC2ODS_Msk                    /*!< Timer C Output 2 disable status */
#define HRTIM_ODSR_TD1ODS_Pos         (6U)                                     
#define HRTIM_ODSR_TD1ODS_Msk         (0x1U << HRTIM_ODSR_TD1ODS_Pos)          /*!< 0x00000040 */
#define HRTIM_ODSR_TD1ODS             HRTIM_ODSR_TD1ODS_Msk                    /*!< Timer D Output 1 disable status */
#define HRTIM_ODSR_TD2ODS_Pos         (7U)                                     
#define HRTIM_ODSR_TD2ODS_Msk         (0x1U << HRTIM_ODSR_TD2ODS_Pos)          /*!< 0x00000080 */
#define HRTIM_ODSR_TD2ODS             HRTIM_ODSR_TD2ODS_Msk                    /*!< Timer D Output 2 disable status */
#define HRTIM_ODSR_TE1ODS_Pos         (8U)                                     
#define HRTIM_ODSR_TE1ODS_Msk         (0x1U << HRTIM_ODSR_TE1ODS_Pos)          /*!< 0x00000100 */
#define HRTIM_ODSR_TE1ODS             HRTIM_ODSR_TE1ODS_Msk                    /*!< Timer E Output 1 disable status */
#define HRTIM_ODSR_TE2ODS_Pos         (9U)                                     
#define HRTIM_ODSR_TE2ODS_Msk         (0x1U << HRTIM_ODSR_TE2ODS_Pos)          /*!< 0x00000200 */
#define HRTIM_ODSR_TE2ODS             HRTIM_ODSR_TE2ODS_Msk                    /*!< Timer E Output 2 disable status */

/**** Bit definition for Common HRTIM Timer Burst mode control register ********/
#define HRTIM_BMCR_BME_Pos            (0U)                                     
#define HRTIM_BMCR_BME_Msk            (0x1U << HRTIM_BMCR_BME_Pos)             /*!< 0x00000001 */
#define HRTIM_BMCR_BME                HRTIM_BMCR_BME_Msk                       /*!< Burst mode enbale */
#define HRTIM_BMCR_BMOM_Pos           (1U)                                     
#define HRTIM_BMCR_BMOM_Msk           (0x1U << HRTIM_BMCR_BMOM_Pos)            /*!< 0x00000002 */
#define HRTIM_BMCR_BMOM               HRTIM_BMCR_BMOM_Msk                      /*!< Burst mode operating mode */
#define HRTIM_BMCR_BMCLK_Pos          (2U)                                     
#define HRTIM_BMCR_BMCLK_Msk          (0xFU << HRTIM_BMCR_BMCLK_Pos)           /*!< 0x0000003C */
#define HRTIM_BMCR_BMCLK              HRTIM_BMCR_BMCLK_Msk                     /*!< Burst mode clock source */
#define HRTIM_BMCR_BMCLK_0            (0x1U << HRTIM_BMCR_BMCLK_Pos)           /*!< 0x00000004 */
#define HRTIM_BMCR_BMCLK_1            (0x2U << HRTIM_BMCR_BMCLK_Pos)           /*!< 0x00000008 */
#define HRTIM_BMCR_BMCLK_2            (0x4U << HRTIM_BMCR_BMCLK_Pos)           /*!< 0x00000010 */
#define HRTIM_BMCR_BMCLK_3            (0x8U << HRTIM_BMCR_BMCLK_Pos)           /*!< 0x00000020 */
#define HRTIM_BMCR_BMPRSC_Pos         (6U)                                     
#define HRTIM_BMCR_BMPRSC_Msk         (0xFU << HRTIM_BMCR_BMPRSC_Pos)          /*!< 0x000003C0 */
#define HRTIM_BMCR_BMPRSC             HRTIM_BMCR_BMPRSC_Msk                    /*!< Burst mode prescaler */
#define HRTIM_BMCR_BMPRSC_0           (0x1U << HRTIM_BMCR_BMPRSC_Pos)          /*!< 0x00000040 */
#define HRTIM_BMCR_BMPRSC_1           (0x2U << HRTIM_BMCR_BMPRSC_Pos)          /*!< 0x00000080 */
#define HRTIM_BMCR_BMPRSC_2           (0x4U << HRTIM_BMCR_BMPRSC_Pos)          /*!< 0x00000100 */
#define HRTIM_BMCR_BMPRSC_3           (0x8U << HRTIM_BMCR_BMPRSC_Pos)          /*!< 0x00000200 */
#define HRTIM_BMCR_BMPREN_Pos         (10U)                                    
#define HRTIM_BMCR_BMPREN_Msk         (0x1U << HRTIM_BMCR_BMPREN_Pos)          /*!< 0x00000400 */
#define HRTIM_BMCR_BMPREN             HRTIM_BMCR_BMPREN_Msk                    /*!< Burst mode Preload bit */
#define HRTIM_BMCR_MTBM_Pos           (16U)                                    
#define HRTIM_BMCR_MTBM_Msk           (0x1U << HRTIM_BMCR_MTBM_Pos)            /*!< 0x00010000 */
#define HRTIM_BMCR_MTBM               HRTIM_BMCR_MTBM_Msk                      /*!< Master Timer Burst mode */
#define HRTIM_BMCR_TABM_Pos           (17U)                                    
#define HRTIM_BMCR_TABM_Msk           (0x1U << HRTIM_BMCR_TABM_Pos)            /*!< 0x00020000 */
#define HRTIM_BMCR_TABM               HRTIM_BMCR_TABM_Msk                      /*!< Timer A Burst mode */
#define HRTIM_BMCR_TBBM_Pos           (18U)                                    
#define HRTIM_BMCR_TBBM_Msk           (0x1U << HRTIM_BMCR_TBBM_Pos)            /*!< 0x00040000 */
#define HRTIM_BMCR_TBBM               HRTIM_BMCR_TBBM_Msk                      /*!< Timer B Burst mode */
#define HRTIM_BMCR_TCBM_Pos           (19U)                                    
#define HRTIM_BMCR_TCBM_Msk           (0x1U << HRTIM_BMCR_TCBM_Pos)            /*!< 0x00080000 */
#define HRTIM_BMCR_TCBM               HRTIM_BMCR_TCBM_Msk                      /*!< Timer C Burst mode */
#define HRTIM_BMCR_TDBM_Pos           (20U)                                    
#define HRTIM_BMCR_TDBM_Msk           (0x1U << HRTIM_BMCR_TDBM_Pos)            /*!< 0x00100000 */
#define HRTIM_BMCR_TDBM               HRTIM_BMCR_TDBM_Msk                      /*!< Timer D Burst mode */
#define HRTIM_BMCR_TEBM_Pos           (21U)                                    
#define HRTIM_BMCR_TEBM_Msk           (0x1U << HRTIM_BMCR_TEBM_Pos)            /*!< 0x00200000 */
#define HRTIM_BMCR_TEBM               HRTIM_BMCR_TEBM_Msk                      /*!< Timer E Burst mode */
#define HRTIM_BMCR_BMSTAT_Pos         (31U)                                    
#define HRTIM_BMCR_BMSTAT_Msk         (0x1U << HRTIM_BMCR_BMSTAT_Pos)          /*!< 0x80000000 */
#define HRTIM_BMCR_BMSTAT             HRTIM_BMCR_BMSTAT_Msk                    /*!< Burst mode status */

/**** Bit definition for Common HRTIM Timer Burst mode Trigger register *******/
#define HRTIM_BMTRGR_SW_Pos           (0U)                                     
#define HRTIM_BMTRGR_SW_Msk           (0x1U << HRTIM_BMTRGR_SW_Pos)            /*!< 0x00000001 */
#define HRTIM_BMTRGR_SW               HRTIM_BMTRGR_SW_Msk                      /*!< Software start */
#define HRTIM_BMTRGR_MSTRST_Pos       (1U)                                     
#define HRTIM_BMTRGR_MSTRST_Msk       (0x1U << HRTIM_BMTRGR_MSTRST_Pos)        /*!< 0x00000002 */
#define HRTIM_BMTRGR_MSTRST           HRTIM_BMTRGR_MSTRST_Msk                  /*!<  Master reset */
#define HRTIM_BMTRGR_MSTREP_Pos       (2U)                                     
#define HRTIM_BMTRGR_MSTREP_Msk       (0x1U << HRTIM_BMTRGR_MSTREP_Pos)        /*!< 0x00000004 */
#define HRTIM_BMTRGR_MSTREP           HRTIM_BMTRGR_MSTREP_Msk                  /*!<  Master repetition */
#define HRTIM_BMTRGR_MSTCMP1_Pos      (3U)                                     
#define HRTIM_BMTRGR_MSTCMP1_Msk      (0x1U << HRTIM_BMTRGR_MSTCMP1_Pos)       /*!< 0x00000008 */
#define HRTIM_BMTRGR_MSTCMP1          HRTIM_BMTRGR_MSTCMP1_Msk                 /*!<  Master compare 1 */
#define HRTIM_BMTRGR_MSTCMP2_Pos      (4U)                                     
#define HRTIM_BMTRGR_MSTCMP2_Msk      (0x1U << HRTIM_BMTRGR_MSTCMP2_Pos)       /*!< 0x00000010 */
#define HRTIM_BMTRGR_MSTCMP2          HRTIM_BMTRGR_MSTCMP2_Msk                 /*!< Master compare 2  */
#define HRTIM_BMTRGR_MSTCMP3_Pos      (5U)                                     
#define HRTIM_BMTRGR_MSTCMP3_Msk      (0x1U << HRTIM_BMTRGR_MSTCMP3_Pos)       /*!< 0x00000020 */
#define HRTIM_BMTRGR_MSTCMP3          HRTIM_BMTRGR_MSTCMP3_Msk                 /*!< Master compare 3 */
#define HRTIM_BMTRGR_MSTCMP4_Pos      (6U)                                     
#define HRTIM_BMTRGR_MSTCMP4_Msk      (0x1U << HRTIM_BMTRGR_MSTCMP4_Pos)       /*!< 0x00000040 */
#define HRTIM_BMTRGR_MSTCMP4          HRTIM_BMTRGR_MSTCMP4_Msk                 /*!< Master compare 4 */
#define HRTIM_BMTRGR_TARST_Pos        (7U)                                     
#define HRTIM_BMTRGR_TARST_Msk        (0x1U << HRTIM_BMTRGR_TARST_Pos)         /*!< 0x00000080 */
#define HRTIM_BMTRGR_TARST            HRTIM_BMTRGR_TARST_Msk                   /*!< Timer A reset  */
#define HRTIM_BMTRGR_TAREP_Pos        (8U)                                     
#define HRTIM_BMTRGR_TAREP_Msk        (0x1U << HRTIM_BMTRGR_TAREP_Pos)         /*!< 0x00000100 */
#define HRTIM_BMTRGR_TAREP            HRTIM_BMTRGR_TAREP_Msk                   /*!< Timer A repetition  */
#define HRTIM_BMTRGR_TACMP1_Pos       (9U)                                     
#define HRTIM_BMTRGR_TACMP1_Msk       (0x1U << HRTIM_BMTRGR_TACMP1_Pos)        /*!< 0x00000200 */
#define HRTIM_BMTRGR_TACMP1           HRTIM_BMTRGR_TACMP1_Msk                  /*!< Timer A compare 1  */
#define HRTIM_BMTRGR_TACMP2_Pos       (10U)                                    
#define HRTIM_BMTRGR_TACMP2_Msk       (0x1U << HRTIM_BMTRGR_TACMP2_Pos)        /*!< 0x00000400 */
#define HRTIM_BMTRGR_TACMP2           HRTIM_BMTRGR_TACMP2_Msk                  /*!< Timer A compare 2  */
#define HRTIM_BMTRGR_TBRST_Pos        (11U)                                    
#define HRTIM_BMTRGR_TBRST_Msk        (0x1U << HRTIM_BMTRGR_TBRST_Pos)         /*!< 0x00000800 */
#define HRTIM_BMTRGR_TBRST            HRTIM_BMTRGR_TBRST_Msk                   /*!< Timer B reset  */
#define HRTIM_BMTRGR_TBREP_Pos        (12U)                                    
#define HRTIM_BMTRGR_TBREP_Msk        (0x1U << HRTIM_BMTRGR_TBREP_Pos)         /*!< 0x00001000 */
#define HRTIM_BMTRGR_TBREP            HRTIM_BMTRGR_TBREP_Msk                   /*!< Timer B repetition  */
#define HRTIM_BMTRGR_TBCMP1_Pos       (13U)                                    
#define HRTIM_BMTRGR_TBCMP1_Msk       (0x1U << HRTIM_BMTRGR_TBCMP1_Pos)        /*!< 0x00002000 */
#define HRTIM_BMTRGR_TBCMP1           HRTIM_BMTRGR_TBCMP1_Msk                  /*!< Timer B compare 1 */
#define HRTIM_BMTRGR_TBCMP2_Pos       (14U)                                    
#define HRTIM_BMTRGR_TBCMP2_Msk       (0x1U << HRTIM_BMTRGR_TBCMP2_Pos)        /*!< 0x00004000 */
#define HRTIM_BMTRGR_TBCMP2           HRTIM_BMTRGR_TBCMP2_Msk                  /*!< Timer B compare 2 */
#define HRTIM_BMTRGR_TCRST_Pos        (15U)                                    
#define HRTIM_BMTRGR_TCRST_Msk        (0x1U << HRTIM_BMTRGR_TCRST_Pos)         /*!< 0x00008000 */
#define HRTIM_BMTRGR_TCRST            HRTIM_BMTRGR_TCRST_Msk                   /*!< Timer C reset  */
#define HRTIM_BMTRGR_TCREP_Pos        (16U)                                    
#define HRTIM_BMTRGR_TCREP_Msk        (0x1U << HRTIM_BMTRGR_TCREP_Pos)         /*!< 0x00010000 */
#define HRTIM_BMTRGR_TCREP            HRTIM_BMTRGR_TCREP_Msk                   /*!< Timer C repetition */
#define HRTIM_BMTRGR_TCCMP1_Pos       (17U)                                    
#define HRTIM_BMTRGR_TCCMP1_Msk       (0x1U << HRTIM_BMTRGR_TCCMP1_Pos)        /*!< 0x00020000 */
#define HRTIM_BMTRGR_TCCMP1           HRTIM_BMTRGR_TCCMP1_Msk                  /*!< Timer C compare 1 */
#define HRTIM_BMTRGR_TCCMP2_Pos       (18U)                                    
#define HRTIM_BMTRGR_TCCMP2_Msk       (0x1U << HRTIM_BMTRGR_TCCMP2_Pos)        /*!< 0x00040000 */
#define HRTIM_BMTRGR_TCCMP2           HRTIM_BMTRGR_TCCMP2_Msk                  /*!< Timer C compare 2 */
#define HRTIM_BMTRGR_TDRST_Pos        (19U)                                    
#define HRTIM_BMTRGR_TDRST_Msk        (0x1U << HRTIM_BMTRGR_TDRST_Pos)         /*!< 0x00080000 */
#define HRTIM_BMTRGR_TDRST            HRTIM_BMTRGR_TDRST_Msk                   /*!< Timer D reset  */
#define HRTIM_BMTRGR_TDREP_Pos        (20U)                                    
#define HRTIM_BMTRGR_TDREP_Msk        (0x1U << HRTIM_BMTRGR_TDREP_Pos)         /*!< 0x00100000 */
#define HRTIM_BMTRGR_TDREP            HRTIM_BMTRGR_TDREP_Msk                   /*!< Timer D repetition  */
#define HRTIM_BMTRGR_TDCMP1_Pos       (21U)                                    
#define HRTIM_BMTRGR_TDCMP1_Msk       (0x1U << HRTIM_BMTRGR_TDCMP1_Pos)        /*!< 0x00200000 */
#define HRTIM_BMTRGR_TDCMP1           HRTIM_BMTRGR_TDCMP1_Msk                  /*!< Timer D compare 1 */
#define HRTIM_BMTRGR_TDCMP2_Pos       (22U)                                    
#define HRTIM_BMTRGR_TDCMP2_Msk       (0x1U << HRTIM_BMTRGR_TDCMP2_Pos)        /*!< 0x00400000 */
#define HRTIM_BMTRGR_TDCMP2           HRTIM_BMTRGR_TDCMP2_Msk                  /*!< Timer D compare 2 */
#define HRTIM_BMTRGR_TERST_Pos        (23U)                                    
#define HRTIM_BMTRGR_TERST_Msk        (0x1U << HRTIM_BMTRGR_TERST_Pos)         /*!< 0x00800000 */
#define HRTIM_BMTRGR_TERST            HRTIM_BMTRGR_TERST_Msk                   /*!< Timer E reset  */
#define HRTIM_BMTRGR_TEREP_Pos        (24U)                                    
#define HRTIM_BMTRGR_TEREP_Msk        (0x1U << HRTIM_BMTRGR_TEREP_Pos)         /*!< 0x01000000 */
#define HRTIM_BMTRGR_TEREP            HRTIM_BMTRGR_TEREP_Msk                   /*!< Timer E repetition  */
#define HRTIM_BMTRGR_TECMP1_Pos       (25U)                                    
#define HRTIM_BMTRGR_TECMP1_Msk       (0x1U << HRTIM_BMTRGR_TECMP1_Pos)        /*!< 0x02000000 */
#define HRTIM_BMTRGR_TECMP1           HRTIM_BMTRGR_TECMP1_Msk                  /*!< Timer E compare 1 */
#define HRTIM_BMTRGR_TECMP2_Pos       (26U)                                    
#define HRTIM_BMTRGR_TECMP2_Msk       (0x1U << HRTIM_BMTRGR_TECMP2_Pos)        /*!< 0x04000000 */
#define HRTIM_BMTRGR_TECMP2           HRTIM_BMTRGR_TECMP2_Msk                  /*!< Timer E compare 2 */
#define HRTIM_BMTRGR_TAEEV7_Pos       (27U)                                    
#define HRTIM_BMTRGR_TAEEV7_Msk       (0x1U << HRTIM_BMTRGR_TAEEV7_Pos)        /*!< 0x08000000 */
#define HRTIM_BMTRGR_TAEEV7           HRTIM_BMTRGR_TAEEV7_Msk                  /*!< Timer A period following External Event7  */
#define HRTIM_BMTRGR_TDEEV8_Pos       (28U)                                    
#define HRTIM_BMTRGR_TDEEV8_Msk       (0x1U << HRTIM_BMTRGR_TDEEV8_Pos)        /*!< 0x10000000 */
#define HRTIM_BMTRGR_TDEEV8           HRTIM_BMTRGR_TDEEV8_Msk                  /*!< Timer D period following External Event8  */
#define HRTIM_BMTRGR_EEV7_Pos         (29U)                                    
#define HRTIM_BMTRGR_EEV7_Msk         (0x1U << HRTIM_BMTRGR_EEV7_Pos)          /*!< 0x20000000 */
#define HRTIM_BMTRGR_EEV7             HRTIM_BMTRGR_EEV7_Msk                    /*!< External Event 7 */
#define HRTIM_BMTRGR_EEV8_Pos         (30U)                                    
#define HRTIM_BMTRGR_EEV8_Msk         (0x1U << HRTIM_BMTRGR_EEV8_Pos)          /*!< 0x40000000 */
#define HRTIM_BMTRGR_EEV8             HRTIM_BMTRGR_EEV8_Msk                    /*!< External Event 8 */
#define HRTIM_BMTRGR_OCHPEV_Pos       (31U)                                    
#define HRTIM_BMTRGR_OCHPEV_Msk       (0x1U << HRTIM_BMTRGR_OCHPEV_Pos)        /*!< 0x80000000 */
#define HRTIM_BMTRGR_OCHPEV           HRTIM_BMTRGR_OCHPEV_Msk                  /*!< on-chip Event */

/*******************  Bit definition for HRTIM_BMCMPR register  ***************/
#define HRTIM_BMCMPR_BMCMPR_Pos       (0U)                                     
#define HRTIM_BMCMPR_BMCMPR_Msk       (0xFFFFU << HRTIM_BMCMPR_BMCMPR_Pos)     /*!< 0x0000FFFF */
#define HRTIM_BMCMPR_BMCMPR           HRTIM_BMCMPR_BMCMPR_Msk                  /*!<!<Burst Compare Value */

/*******************  Bit definition for HRTIM_BMPER register  ****************/
#define HRTIM_BMPER_BMPER_Pos         (0U)                                     
#define HRTIM_BMPER_BMPER_Msk         (0xFFFFU << HRTIM_BMPER_BMPER_Pos)       /*!< 0x0000FFFF */
#define HRTIM_BMPER_BMPER             HRTIM_BMPER_BMPER_Msk                    /*!<!<Burst period Value */

/*******************  Bit definition for HRTIM_EECR1 register  ****************/
#define HRTIM_EECR1_EE1SRC_Pos        (0U)                                     
#define HRTIM_EECR1_EE1SRC_Msk        (0x3U << HRTIM_EECR1_EE1SRC_Pos)         /*!< 0x00000003 */
#define HRTIM_EECR1_EE1SRC            HRTIM_EECR1_EE1SRC_Msk                   /*!< External event 1 source */
#define HRTIM_EECR1_EE1SRC_0          (0x1U << HRTIM_EECR1_EE1SRC_Pos)         /*!< 0x00000001 */
#define HRTIM_EECR1_EE1SRC_1          (0x2U << HRTIM_EECR1_EE1SRC_Pos)         /*!< 0x00000002 */
#define HRTIM_EECR1_EE1POL_Pos        (2U)                                     
#define HRTIM_EECR1_EE1POL_Msk        (0x1U << HRTIM_EECR1_EE1POL_Pos)         /*!< 0x00000004 */
#define HRTIM_EECR1_EE1POL            HRTIM_EECR1_EE1POL_Msk                   /*!< External event 1 Polarity */
#define HRTIM_EECR1_EE1SNS_Pos        (3U)                                     
#define HRTIM_EECR1_EE1SNS_Msk        (0x3U << HRTIM_EECR1_EE1SNS_Pos)         /*!< 0x00000018 */
#define HRTIM_EECR1_EE1SNS            HRTIM_EECR1_EE1SNS_Msk                   /*!< External event 1 sensitivity */
#define HRTIM_EECR1_EE1SNS_0          (0x1U << HRTIM_EECR1_EE1SNS_Pos)         /*!< 0x00000008 */
#define HRTIM_EECR1_EE1SNS_1          (0x2U << HRTIM_EECR1_EE1SNS_Pos)         /*!< 0x00000010 */
#define HRTIM_EECR1_EE1FAST_Pos       (5U)                                     
#define HRTIM_EECR1_EE1FAST_Msk       (0x1U << HRTIM_EECR1_EE1FAST_Pos)        /*!< 0x00000020 */
#define HRTIM_EECR1_EE1FAST           HRTIM_EECR1_EE1FAST_Msk                  /*!< External event 1 Fast mode */

#define HRTIM_EECR1_EE2SRC_Pos        (6U)                                     
#define HRTIM_EECR1_EE2SRC_Msk        (0x3U << HRTIM_EECR1_EE2SRC_Pos)         /*!< 0x000000C0 */
#define HRTIM_EECR1_EE2SRC            HRTIM_EECR1_EE2SRC_Msk                   /*!< External event 2 source */
#define HRTIM_EECR1_EE2SRC_0          (0x1U << HRTIM_EECR1_EE2SRC_Pos)         /*!< 0x00000040 */
#define HRTIM_EECR1_EE2SRC_1          (0x2U << HRTIM_EECR1_EE2SRC_Pos)         /*!< 0x00000080 */
#define HRTIM_EECR1_EE2POL_Pos        (8U)                                     
#define HRTIM_EECR1_EE2POL_Msk        (0x1U << HRTIM_EECR1_EE2POL_Pos)         /*!< 0x00000100 */
#define HRTIM_EECR1_EE2POL            HRTIM_EECR1_EE2POL_Msk                   /*!< External event 2 Polarity */
#define HRTIM_EECR1_EE2SNS_Pos        (9U)                                     
#define HRTIM_EECR1_EE2SNS_Msk        (0x3U << HRTIM_EECR1_EE2SNS_Pos)         /*!< 0x00000600 */
#define HRTIM_EECR1_EE2SNS            HRTIM_EECR1_EE2SNS_Msk                   /*!< External event 2 sensitivity */
#define HRTIM_EECR1_EE2SNS_0          (0x1U << HRTIM_EECR1_EE2SNS_Pos)         /*!< 0x00000200 */
#define HRTIM_EECR1_EE2SNS_1          (0x2U << HRTIM_EECR1_EE2SNS_Pos)         /*!< 0x00000400 */
#define HRTIM_EECR1_EE2FAST_Pos       (11U)                                    
#define HRTIM_EECR1_EE2FAST_Msk       (0x1U << HRTIM_EECR1_EE2FAST_Pos)        /*!< 0x00000800 */
#define HRTIM_EECR1_EE2FAST           HRTIM_EECR1_EE2FAST_Msk                  /*!< External event 2 Fast mode */

#define HRTIM_EECR1_EE3SRC_Pos        (12U)                                    
#define HRTIM_EECR1_EE3SRC_Msk        (0x3U << HRTIM_EECR1_EE3SRC_Pos)         /*!< 0x00003000 */
#define HRTIM_EECR1_EE3SRC            HRTIM_EECR1_EE3SRC_Msk                   /*!< External event 3 source */
#define HRTIM_EECR1_EE3SRC_0          (0x1U << HRTIM_EECR1_EE3SRC_Pos)         /*!< 0x00001000 */
#define HRTIM_EECR1_EE3SRC_1          (0x2U << HRTIM_EECR1_EE3SRC_Pos)         /*!< 0x00002000 */
#define HRTIM_EECR1_EE3POL_Pos        (14U)                                    
#define HRTIM_EECR1_EE3POL_Msk        (0x1U << HRTIM_EECR1_EE3POL_Pos)         /*!< 0x00004000 */
#define HRTIM_EECR1_EE3POL            HRTIM_EECR1_EE3POL_Msk                   /*!< External event 3 Polarity */
#define HRTIM_EECR1_EE3SNS_Pos        (15U)                                    
#define HRTIM_EECR1_EE3SNS_Msk        (0x3U << HRTIM_EECR1_EE3SNS_Pos)         /*!< 0x00018000 */
#define HRTIM_EECR1_EE3SNS            HRTIM_EECR1_EE3SNS_Msk                   /*!< External event 3 sensitivity */
#define HRTIM_EECR1_EE3SNS_0          (0x1U << HRTIM_EECR1_EE3SNS_Pos)         /*!< 0x00008000 */
#define HRTIM_EECR1_EE3SNS_1          (0x2U << HRTIM_EECR1_EE3SNS_Pos)         /*!< 0x00010000 */
#define HRTIM_EECR1_EE3FAST_Pos       (17U)                                    
#define HRTIM_EECR1_EE3FAST_Msk       (0x1U << HRTIM_EECR1_EE3FAST_Pos)        /*!< 0x00020000 */
#define HRTIM_EECR1_EE3FAST           HRTIM_EECR1_EE3FAST_Msk                  /*!< External event 3 Fast mode */

#define HRTIM_EECR1_EE4SRC_Pos        (18U)                                    
#define HRTIM_EECR1_EE4SRC_Msk        (0x3U << HRTIM_EECR1_EE4SRC_Pos)         /*!< 0x000C0000 */
#define HRTIM_EECR1_EE4SRC            HRTIM_EECR1_EE4SRC_Msk                   /*!< External event 4 source */
#define HRTIM_EECR1_EE4SRC_0          (0x1U << HRTIM_EECR1_EE4SRC_Pos)         /*!< 0x00040000 */
#define HRTIM_EECR1_EE4SRC_1          (0x2U << HRTIM_EECR1_EE4SRC_Pos)         /*!< 0x00080000 */
#define HRTIM_EECR1_EE4POL_Pos        (20U)                                    
#define HRTIM_EECR1_EE4POL_Msk        (0x1U << HRTIM_EECR1_EE4POL_Pos)         /*!< 0x00100000 */
#define HRTIM_EECR1_EE4POL            HRTIM_EECR1_EE4POL_Msk                   /*!< External event 4 Polarity */
#define HRTIM_EECR1_EE4SNS_Pos        (21U)                                    
#define HRTIM_EECR1_EE4SNS_Msk        (0x3U << HRTIM_EECR1_EE4SNS_Pos)         /*!< 0x00600000 */
#define HRTIM_EECR1_EE4SNS            HRTIM_EECR1_EE4SNS_Msk                   /*!< External event 4 sensitivity */
#define HRTIM_EECR1_EE4SNS_0          (0x1U << HRTIM_EECR1_EE4SNS_Pos)         /*!< 0x00200000 */
#define HRTIM_EECR1_EE4SNS_1          (0x2U << HRTIM_EECR1_EE4SNS_Pos)         /*!< 0x00400000 */
#define HRTIM_EECR1_EE4FAST_Pos       (23U)                                    
#define HRTIM_EECR1_EE4FAST_Msk       (0x1U << HRTIM_EECR1_EE4FAST_Pos)        /*!< 0x00800000 */
#define HRTIM_EECR1_EE4FAST           HRTIM_EECR1_EE4FAST_Msk                  /*!< External event 4 Fast mode */

#define HRTIM_EECR1_EE5SRC_Pos        (24U)                                    
#define HRTIM_EECR1_EE5SRC_Msk        (0x3U << HRTIM_EECR1_EE5SRC_Pos)         /*!< 0x03000000 */
#define HRTIM_EECR1_EE5SRC            HRTIM_EECR1_EE5SRC_Msk                   /*!< External event 5 source */
#define HRTIM_EECR1_EE5SRC_0          (0x1U << HRTIM_EECR1_EE5SRC_Pos)         /*!< 0x01000000 */
#define HRTIM_EECR1_EE5SRC_1          (0x2U << HRTIM_EECR1_EE5SRC_Pos)         /*!< 0x02000000 */
#define HRTIM_EECR1_EE5POL_Pos        (26U)                                    
#define HRTIM_EECR1_EE5POL_Msk        (0x1U << HRTIM_EECR1_EE5POL_Pos)         /*!< 0x04000000 */
#define HRTIM_EECR1_EE5POL            HRTIM_EECR1_EE5POL_Msk                   /*!< External event 5 Polarity */
#define HRTIM_EECR1_EE5SNS_Pos        (27U)                                    
#define HRTIM_EECR1_EE5SNS_Msk        (0x3U << HRTIM_EECR1_EE5SNS_Pos)         /*!< 0x18000000 */
#define HRTIM_EECR1_EE5SNS            HRTIM_EECR1_EE5SNS_Msk                   /*!< External event 5 sensitivity */
#define HRTIM_EECR1_EE5SNS_0          (0x1U << HRTIM_EECR1_EE5SNS_Pos)         /*!< 0x08000000 */
#define HRTIM_EECR1_EE5SNS_1          (0x2U << HRTIM_EECR1_EE5SNS_Pos)         /*!< 0x10000000 */
#define HRTIM_EECR1_EE5FAST_Pos       (29U)                                    
#define HRTIM_EECR1_EE5FAST_Msk       (0x1U << HRTIM_EECR1_EE5FAST_Pos)        /*!< 0x20000000 */
#define HRTIM_EECR1_EE5FAST           HRTIM_EECR1_EE5FAST_Msk                  /*!< External event 5 Fast mode */

/*******************  Bit definition for HRTIM_EECR2 register  ****************/
#define HRTIM_EECR2_EE6SRC_Pos        (0U)                                     
#define HRTIM_EECR2_EE6SRC_Msk        (0x3U << HRTIM_EECR2_EE6SRC_Pos)         /*!< 0x00000003 */
#define HRTIM_EECR2_EE6SRC            HRTIM_EECR2_EE6SRC_Msk                   /*!< External event 6 source */
#define HRTIM_EECR2_EE6SRC_0          (0x1U << HRTIM_EECR2_EE6SRC_Pos)         /*!< 0x00000001 */
#define HRTIM_EECR2_EE6SRC_1          (0x2U << HRTIM_EECR2_EE6SRC_Pos)         /*!< 0x00000002 */
#define HRTIM_EECR2_EE6POL_Pos        (2U)                                     
#define HRTIM_EECR2_EE6POL_Msk        (0x1U << HRTIM_EECR2_EE6POL_Pos)         /*!< 0x00000004 */
#define HRTIM_EECR2_EE6POL            HRTIM_EECR2_EE6POL_Msk                   /*!< External event 6 Polarity */
#define HRTIM_EECR2_EE6SNS_Pos        (3U)                                     
#define HRTIM_EECR2_EE6SNS_Msk        (0x3U << HRTIM_EECR2_EE6SNS_Pos)         /*!< 0x00000018 */
#define HRTIM_EECR2_EE6SNS            HRTIM_EECR2_EE6SNS_Msk                   /*!< External event 6 sensitivity */
#define HRTIM_EECR2_EE6SNS_0          (0x1U << HRTIM_EECR2_EE6SNS_Pos)         /*!< 0x00000008 */
#define HRTIM_EECR2_EE6SNS_1          (0x2U << HRTIM_EECR2_EE6SNS_Pos)         /*!< 0x00000010 */

#define HRTIM_EECR2_EE7SRC_Pos        (6U)                                     
#define HRTIM_EECR2_EE7SRC_Msk        (0x3U << HRTIM_EECR2_EE7SRC_Pos)         /*!< 0x000000C0 */
#define HRTIM_EECR2_EE7SRC            HRTIM_EECR2_EE7SRC_Msk                   /*!< External event 7 source */
#define HRTIM_EECR2_EE7SRC_0          (0x1U << HRTIM_EECR2_EE7SRC_Pos)         /*!< 0x00000040 */
#define HRTIM_EECR2_EE7SRC_1          (0x2U << HRTIM_EECR2_EE7SRC_Pos)         /*!< 0x00000080 */
#define HRTIM_EECR2_EE7POL_Pos        (8U)                                     
#define HRTIM_EECR2_EE7POL_Msk        (0x1U << HRTIM_EECR2_EE7POL_Pos)         /*!< 0x00000100 */
#define HRTIM_EECR2_EE7POL            HRTIM_EECR2_EE7POL_Msk                   /*!< External event 7 Polarity */
#define HRTIM_EECR2_EE7SNS_Pos        (9U)                                     
#define HRTIM_EECR2_EE7SNS_Msk        (0x3U << HRTIM_EECR2_EE7SNS_Pos)         /*!< 0x00000600 */
#define HRTIM_EECR2_EE7SNS            HRTIM_EECR2_EE7SNS_Msk                   /*!< External event 7 sensitivity */
#define HRTIM_EECR2_EE7SNS_0          (0x1U << HRTIM_EECR2_EE7SNS_Pos)         /*!< 0x00000200 */
#define HRTIM_EECR2_EE7SNS_1          (0x2U << HRTIM_EECR2_EE7SNS_Pos)         /*!< 0x00000400 */

#define HRTIM_EECR2_EE8SRC_Pos        (12U)                                    
#define HRTIM_EECR2_EE8SRC_Msk        (0x3U << HRTIM_EECR2_EE8SRC_Pos)         /*!< 0x00003000 */
#define HRTIM_EECR2_EE8SRC            HRTIM_EECR2_EE8SRC_Msk                   /*!< External event 8 source */
#define HRTIM_EECR2_EE8SRC_0          (0x1U << HRTIM_EECR2_EE8SRC_Pos)         /*!< 0x00001000 */
#define HRTIM_EECR2_EE8SRC_1          (0x2U << HRTIM_EECR2_EE8SRC_Pos)         /*!< 0x00002000 */
#define HRTIM_EECR2_EE8POL_Pos        (14U)                                    
#define HRTIM_EECR2_EE8POL_Msk        (0x1U << HRTIM_EECR2_EE8POL_Pos)         /*!< 0x00004000 */
#define HRTIM_EECR2_EE8POL            HRTIM_EECR2_EE8POL_Msk                   /*!< External event 8 Polarity */
#define HRTIM_EECR2_EE8SNS_Pos        (15U)                                    
#define HRTIM_EECR2_EE8SNS_Msk        (0x3U << HRTIM_EECR2_EE8SNS_Pos)         /*!< 0x00018000 */
#define HRTIM_EECR2_EE8SNS            HRTIM_EECR2_EE8SNS_Msk                   /*!< External event 8 sensitivity */
#define HRTIM_EECR2_EE8SNS_0          (0x1U << HRTIM_EECR2_EE8SNS_Pos)         /*!< 0x00008000 */
#define HRTIM_EECR2_EE8SNS_1          (0x2U << HRTIM_EECR2_EE8SNS_Pos)         /*!< 0x00010000 */

#define HRTIM_EECR2_EE9SRC_Pos        (18U)                                    
#define HRTIM_EECR2_EE9SRC_Msk        (0x3U << HRTIM_EECR2_EE9SRC_Pos)         /*!< 0x000C0000 */
#define HRTIM_EECR2_EE9SRC            HRTIM_EECR2_EE9SRC_Msk                   /*!< External event 9 source */
#define HRTIM_EECR2_EE9SRC_0          (0x1U << HRTIM_EECR2_EE9SRC_Pos)         /*!< 0x00040000 */
#define HRTIM_EECR2_EE9SRC_1          (0x2U << HRTIM_EECR2_EE9SRC_Pos)         /*!< 0x00080000 */
#define HRTIM_EECR2_EE9POL_Pos        (20U)                                    
#define HRTIM_EECR2_EE9POL_Msk        (0x1U << HRTIM_EECR2_EE9POL_Pos)         /*!< 0x00100000 */
#define HRTIM_EECR2_EE9POL            HRTIM_EECR2_EE9POL_Msk                   /*!< External event 9 Polarity */
#define HRTIM_EECR2_EE9SNS_Pos        (21U)                                    
#define HRTIM_EECR2_EE9SNS_Msk        (0x3U << HRTIM_EECR2_EE9SNS_Pos)         /*!< 0x00600000 */
#define HRTIM_EECR2_EE9SNS            HRTIM_EECR2_EE9SNS_Msk                   /*!< External event 9 sensitivity */
#define HRTIM_EECR2_EE9SNS_0          (0x1U << HRTIM_EECR2_EE9SNS_Pos)         /*!< 0x00200000 */
#define HRTIM_EECR2_EE9SNS_1          (0x2U << HRTIM_EECR2_EE9SNS_Pos)         /*!< 0x00400000 */

#define HRTIM_EECR2_EE10SRC_Pos       (24U)                                    
#define HRTIM_EECR2_EE10SRC_Msk       (0x3U << HRTIM_EECR2_EE10SRC_Pos)        /*!< 0x03000000 */
#define HRTIM_EECR2_EE10SRC           HRTIM_EECR2_EE10SRC_Msk                  /*!< External event 10 source */
#define HRTIM_EECR2_EE10SRC_0         (0x1U << HRTIM_EECR2_EE10SRC_Pos)        /*!< 0x01000000 */
#define HRTIM_EECR2_EE10SRC_1         (0x2U << HRTIM_EECR2_EE10SRC_Pos)        /*!< 0x02000000 */
#define HRTIM_EECR2_EE10POL_Pos       (26U)                                    
#define HRTIM_EECR2_EE10POL_Msk       (0x1U << HRTIM_EECR2_EE10POL_Pos)        /*!< 0x04000000 */
#define HRTIM_EECR2_EE10POL           HRTIM_EECR2_EE10POL_Msk                  /*!< External event 10 Polarity */
#define HRTIM_EECR2_EE10SNS_Pos       (27U)                                    
#define HRTIM_EECR2_EE10SNS_Msk       (0x3U << HRTIM_EECR2_EE10SNS_Pos)        /*!< 0x18000000 */
#define HRTIM_EECR2_EE10SNS           HRTIM_EECR2_EE10SNS_Msk                  /*!< External event 10 sensitivity */
#define HRTIM_EECR2_EE10SNS_0         (0x1U << HRTIM_EECR2_EE10SNS_Pos)        /*!< 0x08000000 */
#define HRTIM_EECR2_EE10SNS_1         (0x2U << HRTIM_EECR2_EE10SNS_Pos)        /*!< 0x10000000 */

/*******************  Bit definition for HRTIM_EECR3 register  ****************/
#define HRTIM_EECR3_EE6F_Pos          (0U)                                     
#define HRTIM_EECR3_EE6F_Msk          (0xFU << HRTIM_EECR3_EE6F_Pos)           /*!< 0x0000000F */
#define HRTIM_EECR3_EE6F              HRTIM_EECR3_EE6F_Msk                     /*!< External event 6 filter */
#define HRTIM_EECR3_EE6F_0            (0x1U << HRTIM_EECR3_EE6F_Pos)           /*!< 0x00000001 */
#define HRTIM_EECR3_EE6F_1            (0x2U << HRTIM_EECR3_EE6F_Pos)           /*!< 0x00000002 */
#define HRTIM_EECR3_EE6F_2            (0x4U << HRTIM_EECR3_EE6F_Pos)           /*!< 0x00000004 */
#define HRTIM_EECR3_EE6F_3            (0x8U << HRTIM_EECR3_EE6F_Pos)           /*!< 0x00000008 */
#define HRTIM_EECR3_EE7F_Pos          (6U)                                     
#define HRTIM_EECR3_EE7F_Msk          (0xFU << HRTIM_EECR3_EE7F_Pos)           /*!< 0x000003C0 */
#define HRTIM_EECR3_EE7F              HRTIM_EECR3_EE7F_Msk                     /*!< External event 7 filter */
#define HRTIM_EECR3_EE7F_0            (0x1U << HRTIM_EECR3_EE7F_Pos)           /*!< 0x00000040 */
#define HRTIM_EECR3_EE7F_1            (0x2U << HRTIM_EECR3_EE7F_Pos)           /*!< 0x00000080 */
#define HRTIM_EECR3_EE7F_2            (0x4U << HRTIM_EECR3_EE7F_Pos)           /*!< 0x00000100 */
#define HRTIM_EECR3_EE7F_3            (0x8U << HRTIM_EECR3_EE7F_Pos)           /*!< 0x00000200 */
#define HRTIM_EECR3_EE8F_Pos          (12U)                                    
#define HRTIM_EECR3_EE8F_Msk          (0xFU << HRTIM_EECR3_EE8F_Pos)           /*!< 0x0000F000 */
#define HRTIM_EECR3_EE8F              HRTIM_EECR3_EE8F_Msk                     /*!< External event 8 filter */
#define HRTIM_EECR3_EE8F_0            (0x1U << HRTIM_EECR3_EE8F_Pos)           /*!< 0x00001000 */
#define HRTIM_EECR3_EE8F_1            (0x2U << HRTIM_EECR3_EE8F_Pos)           /*!< 0x00002000 */
#define HRTIM_EECR3_EE8F_2            (0x4U << HRTIM_EECR3_EE8F_Pos)           /*!< 0x00004000 */
#define HRTIM_EECR3_EE8F_3            (0x8U << HRTIM_EECR3_EE8F_Pos)           /*!< 0x00008000 */
#define HRTIM_EECR3_EE9F_Pos          (18U)                                    
#define HRTIM_EECR3_EE9F_Msk          (0xFU << HRTIM_EECR3_EE9F_Pos)           /*!< 0x003C0000 */
#define HRTIM_EECR3_EE9F              HRTIM_EECR3_EE9F_Msk                     /*!< External event 9 filter */
#define HRTIM_EECR3_EE9F_0            (0x1U << HRTIM_EECR3_EE9F_Pos)           /*!< 0x00040000 */
#define HRTIM_EECR3_EE9F_1            (0x2U << HRTIM_EECR3_EE9F_Pos)           /*!< 0x00080000 */
#define HRTIM_EECR3_EE9F_2            (0x4U << HRTIM_EECR3_EE9F_Pos)           /*!< 0x00100000 */
#define HRTIM_EECR3_EE9F_3            (0x8U << HRTIM_EECR3_EE9F_Pos)           /*!< 0x00200000 */
#define HRTIM_EECR3_EE10F_Pos         (24U)                                    
#define HRTIM_EECR3_EE10F_Msk         (0xFU << HRTIM_EECR3_EE10F_Pos)          /*!< 0x0F000000 */
#define HRTIM_EECR3_EE10F             HRTIM_EECR3_EE10F_Msk                    /*!< External event 10 filter */
#define HRTIM_EECR3_EE10F_0           (0x1U << HRTIM_EECR3_EE10F_Pos)          /*!< 0x01000000 */
#define HRTIM_EECR3_EE10F_1           (0x2U << HRTIM_EECR3_EE10F_Pos)          /*!< 0x02000000 */
#define HRTIM_EECR3_EE10F_2           (0x4U << HRTIM_EECR3_EE10F_Pos)          /*!< 0x04000000 */
#define HRTIM_EECR3_EE10F_3           (0x8U << HRTIM_EECR3_EE10F_Pos)          /*!< 0x08000000 */
#define HRTIM_EECR3_EEVSD_Pos         (30U)                                    
#define HRTIM_EECR3_EEVSD_Msk         (0x3U << HRTIM_EECR3_EEVSD_Pos)          /*!< 0xC0000000 */
#define HRTIM_EECR3_EEVSD             HRTIM_EECR3_EEVSD_Msk                    /*!< External event sampling clock division */
#define HRTIM_EECR3_EEVSD_0           (0x1U << HRTIM_EECR3_EEVSD_Pos)          /*!< 0x40000000 */
#define HRTIM_EECR3_EEVSD_1           (0x2U << HRTIM_EECR3_EEVSD_Pos)          /*!< 0x80000000 */

/*******************  Bit definition for HRTIM_ADC1R register  ****************/
#define HRTIM_ADC1R_AD1MC1_Pos        (0U)                                     
#define HRTIM_ADC1R_AD1MC1_Msk        (0x1U << HRTIM_ADC1R_AD1MC1_Pos)         /*!< 0x00000001 */
#define HRTIM_ADC1R_AD1MC1            HRTIM_ADC1R_AD1MC1_Msk                   /*!< ADC Trigger 1 on master compare 1 */
#define HRTIM_ADC1R_AD1MC2_Pos        (1U)                                     
#define HRTIM_ADC1R_AD1MC2_Msk        (0x1U << HRTIM_ADC1R_AD1MC2_Pos)         /*!< 0x00000002 */
#define HRTIM_ADC1R_AD1MC2            HRTIM_ADC1R_AD1MC2_Msk                   /*!< ADC Trigger 1 on master compare 2 */
#define HRTIM_ADC1R_AD1MC3_Pos        (2U)                                     
#define HRTIM_ADC1R_AD1MC3_Msk        (0x1U << HRTIM_ADC1R_AD1MC3_Pos)         /*!< 0x00000004 */
#define HRTIM_ADC1R_AD1MC3            HRTIM_ADC1R_AD1MC3_Msk                   /*!< ADC Trigger 1 on master compare 3 */
#define HRTIM_ADC1R_AD1MC4_Pos        (3U)                                     
#define HRTIM_ADC1R_AD1MC4_Msk        (0x1U << HRTIM_ADC1R_AD1MC4_Pos)         /*!< 0x00000008 */
#define HRTIM_ADC1R_AD1MC4            HRTIM_ADC1R_AD1MC4_Msk                   /*!< ADC Trigger 1 on master compare 4 */
#define HRTIM_ADC1R_AD1MPER_Pos       (4U)                                     
#define HRTIM_ADC1R_AD1MPER_Msk       (0x1U << HRTIM_ADC1R_AD1MPER_Pos)        /*!< 0x00000010 */
#define HRTIM_ADC1R_AD1MPER           HRTIM_ADC1R_AD1MPER_Msk                  /*!< ADC Trigger 1 on master period */
#define HRTIM_ADC1R_AD1EEV1_Pos       (5U)                                     
#define HRTIM_ADC1R_AD1EEV1_Msk       (0x1U << HRTIM_ADC1R_AD1EEV1_Pos)        /*!< 0x00000020 */
#define HRTIM_ADC1R_AD1EEV1           HRTIM_ADC1R_AD1EEV1_Msk                  /*!< ADC Trigger 1 on external event 1 */
#define HRTIM_ADC1R_AD1EEV2_Pos       (6U)                                     
#define HRTIM_ADC1R_AD1EEV2_Msk       (0x1U << HRTIM_ADC1R_AD1EEV2_Pos)        /*!< 0x00000040 */
#define HRTIM_ADC1R_AD1EEV2           HRTIM_ADC1R_AD1EEV2_Msk                  /*!< ADC Trigger 1 on external event 2 */
#define HRTIM_ADC1R_AD1EEV3_Pos       (7U)                                     
#define HRTIM_ADC1R_AD1EEV3_Msk       (0x1U << HRTIM_ADC1R_AD1EEV3_Pos)        /*!< 0x00000080 */
#define HRTIM_ADC1R_AD1EEV3           HRTIM_ADC1R_AD1EEV3_Msk                  /*!< ADC Trigger 1 on external event 3 */
#define HRTIM_ADC1R_AD1EEV4_Pos       (8U)                                     
#define HRTIM_ADC1R_AD1EEV4_Msk       (0x1U << HRTIM_ADC1R_AD1EEV4_Pos)        /*!< 0x00000100 */
#define HRTIM_ADC1R_AD1EEV4           HRTIM_ADC1R_AD1EEV4_Msk                  /*!< ADC Trigger 1 on external event 4 */
#define HRTIM_ADC1R_AD1EEV5_Pos       (9U)                                     
#define HRTIM_ADC1R_AD1EEV5_Msk       (0x1U << HRTIM_ADC1R_AD1EEV5_Pos)        /*!< 0x00000200 */
#define HRTIM_ADC1R_AD1EEV5           HRTIM_ADC1R_AD1EEV5_Msk                  /*!< ADC Trigger 1 on external event 5 */
#define HRTIM_ADC1R_AD1TAC2_Pos       (10U)                                    
#define HRTIM_ADC1R_AD1TAC2_Msk       (0x1U << HRTIM_ADC1R_AD1TAC2_Pos)        /*!< 0x00000400 */
#define HRTIM_ADC1R_AD1TAC2           HRTIM_ADC1R_AD1TAC2_Msk                  /*!< ADC Trigger 1 on Timer A compare 2 */
#define HRTIM_ADC1R_AD1TAC3_Pos       (11U)                                    
#define HRTIM_ADC1R_AD1TAC3_Msk       (0x1U << HRTIM_ADC1R_AD1TAC3_Pos)        /*!< 0x00000800 */
#define HRTIM_ADC1R_AD1TAC3           HRTIM_ADC1R_AD1TAC3_Msk                  /*!< ADC Trigger 1 on Timer A compare 3 */
#define HRTIM_ADC1R_AD1TAC4_Pos       (12U)                                    
#define HRTIM_ADC1R_AD1TAC4_Msk       (0x1U << HRTIM_ADC1R_AD1TAC4_Pos)        /*!< 0x00001000 */
#define HRTIM_ADC1R_AD1TAC4           HRTIM_ADC1R_AD1TAC4_Msk                  /*!< ADC Trigger 1 on Timer A compare 4 */
#define HRTIM_ADC1R_AD1TAPER_Pos      (13U)                                    
#define HRTIM_ADC1R_AD1TAPER_Msk      (0x1U << HRTIM_ADC1R_AD1TAPER_Pos)       /*!< 0x00002000 */
#define HRTIM_ADC1R_AD1TAPER          HRTIM_ADC1R_AD1TAPER_Msk                 /*!< ADC Trigger 1 on Timer A period */
#define HRTIM_ADC1R_AD1TARST_Pos      (14U)                                    
#define HRTIM_ADC1R_AD1TARST_Msk      (0x1U << HRTIM_ADC1R_AD1TARST_Pos)       /*!< 0x00004000 */
#define HRTIM_ADC1R_AD1TARST          HRTIM_ADC1R_AD1TARST_Msk                 /*!< ADC Trigger 1 on Timer A reset */
#define HRTIM_ADC1R_AD1TBC2_Pos       (15U)                                    
#define HRTIM_ADC1R_AD1TBC2_Msk       (0x1U << HRTIM_ADC1R_AD1TBC2_Pos)        /*!< 0x00008000 */
#define HRTIM_ADC1R_AD1TBC2           HRTIM_ADC1R_AD1TBC2_Msk                  /*!< ADC Trigger 1 on Timer B compare 2 */
#define HRTIM_ADC1R_AD1TBC3_Pos       (16U)                                    
#define HRTIM_ADC1R_AD1TBC3_Msk       (0x1U << HRTIM_ADC1R_AD1TBC3_Pos)        /*!< 0x00010000 */
#define HRTIM_ADC1R_AD1TBC3           HRTIM_ADC1R_AD1TBC3_Msk                  /*!< ADC Trigger 1 on Timer B compare 3 */
#define HRTIM_ADC1R_AD1TBC4_Pos       (17U)                                    
#define HRTIM_ADC1R_AD1TBC4_Msk       (0x1U << HRTIM_ADC1R_AD1TBC4_Pos)        /*!< 0x00020000 */
#define HRTIM_ADC1R_AD1TBC4           HRTIM_ADC1R_AD1TBC4_Msk                  /*!< ADC Trigger 1 on Timer B compare 4 */
#define HRTIM_ADC1R_AD1TBPER_Pos      (18U)                                    
#define HRTIM_ADC1R_AD1TBPER_Msk      (0x1U << HRTIM_ADC1R_AD1TBPER_Pos)       /*!< 0x00040000 */
#define HRTIM_ADC1R_AD1TBPER          HRTIM_ADC1R_AD1TBPER_Msk                 /*!< ADC Trigger 1 on Timer B period */
#define HRTIM_ADC1R_AD1TBRST_Pos      (19U)                                    
#define HRTIM_ADC1R_AD1TBRST_Msk      (0x1U << HRTIM_ADC1R_AD1TBRST_Pos)       /*!< 0x00080000 */
#define HRTIM_ADC1R_AD1TBRST          HRTIM_ADC1R_AD1TBRST_Msk                 /*!< ADC Trigger 1 on Timer B reset */
#define HRTIM_ADC1R_AD1TCC2_Pos       (20U)                                    
#define HRTIM_ADC1R_AD1TCC2_Msk       (0x1U << HRTIM_ADC1R_AD1TCC2_Pos)        /*!< 0x00100000 */
#define HRTIM_ADC1R_AD1TCC2           HRTIM_ADC1R_AD1TCC2_Msk                  /*!< ADC Trigger 1 on Timer C compare 2 */
#define HRTIM_ADC1R_AD1TCC3_Pos       (21U)                                    
#define HRTIM_ADC1R_AD1TCC3_Msk       (0x1U << HRTIM_ADC1R_AD1TCC3_Pos)        /*!< 0x00200000 */
#define HRTIM_ADC1R_AD1TCC3           HRTIM_ADC1R_AD1TCC3_Msk                  /*!< ADC Trigger 1 on Timer C compare 3 */
#define HRTIM_ADC1R_AD1TCC4_Pos       (22U)                                    
#define HRTIM_ADC1R_AD1TCC4_Msk       (0x1U << HRTIM_ADC1R_AD1TCC4_Pos)        /*!< 0x00400000 */
#define HRTIM_ADC1R_AD1TCC4           HRTIM_ADC1R_AD1TCC4_Msk                  /*!< ADC Trigger 1 on Timer C compare 4 */
#define HRTIM_ADC1R_AD1TCPER_Pos      (23U)                                    
#define HRTIM_ADC1R_AD1TCPER_Msk      (0x1U << HRTIM_ADC1R_AD1TCPER_Pos)       /*!< 0x00800000 */
#define HRTIM_ADC1R_AD1TCPER          HRTIM_ADC1R_AD1TCPER_Msk                 /*!< ADC Trigger 1 on Timer C period */
#define HRTIM_ADC1R_AD1TDC2_Pos       (24U)                                    
#define HRTIM_ADC1R_AD1TDC2_Msk       (0x1U << HRTIM_ADC1R_AD1TDC2_Pos)        /*!< 0x01000000 */
#define HRTIM_ADC1R_AD1TDC2           HRTIM_ADC1R_AD1TDC2_Msk                  /*!< ADC Trigger 1 on Timer D compare 2 */
#define HRTIM_ADC1R_AD1TDC3_Pos       (25U)                                    
#define HRTIM_ADC1R_AD1TDC3_Msk       (0x1U << HRTIM_ADC1R_AD1TDC3_Pos)        /*!< 0x02000000 */
#define HRTIM_ADC1R_AD1TDC3           HRTIM_ADC1R_AD1TDC3_Msk                  /*!< ADC Trigger 1 on Timer D compare 3 */
#define HRTIM_ADC1R_AD1TDC4_Pos       (26U)                                    
#define HRTIM_ADC1R_AD1TDC4_Msk       (0x1U << HRTIM_ADC1R_AD1TDC4_Pos)        /*!< 0x04000000 */
#define HRTIM_ADC1R_AD1TDC4           HRTIM_ADC1R_AD1TDC4_Msk                  /*!< ADC Trigger 1 on Timer D compare 4 */
#define HRTIM_ADC1R_AD1TDPER_Pos      (27U)                                    
#define HRTIM_ADC1R_AD1TDPER_Msk      (0x1U << HRTIM_ADC1R_AD1TDPER_Pos)       /*!< 0x08000000 */
#define HRTIM_ADC1R_AD1TDPER          HRTIM_ADC1R_AD1TDPER_Msk                 /*!< ADC Trigger 1 on Timer D period */
#define HRTIM_ADC1R_AD1TEC2_Pos       (28U)                                    
#define HRTIM_ADC1R_AD1TEC2_Msk       (0x1U << HRTIM_ADC1R_AD1TEC2_Pos)        /*!< 0x10000000 */
#define HRTIM_ADC1R_AD1TEC2           HRTIM_ADC1R_AD1TEC2_Msk                  /*!< ADC Trigger 1 on Timer E compare 2 */
#define HRTIM_ADC1R_AD1TEC3_Pos       (29U)                                    
#define HRTIM_ADC1R_AD1TEC3_Msk       (0x1U << HRTIM_ADC1R_AD1TEC3_Pos)        /*!< 0x20000000 */
#define HRTIM_ADC1R_AD1TEC3           HRTIM_ADC1R_AD1TEC3_Msk                  /*!< ADC Trigger 1 on Timer E compare 3 */
#define HRTIM_ADC1R_AD1TEC4_Pos       (30U)                                    
#define HRTIM_ADC1R_AD1TEC4_Msk       (0x1U << HRTIM_ADC1R_AD1TEC4_Pos)        /*!< 0x40000000 */
#define HRTIM_ADC1R_AD1TEC4           HRTIM_ADC1R_AD1TEC4_Msk                  /*!< ADC Trigger 1 on Timer E compare 4 */
#define HRTIM_ADC1R_AD1TEPER_Pos      (31U)                                    
#define HRTIM_ADC1R_AD1TEPER_Msk      (0x1U << HRTIM_ADC1R_AD1TEPER_Pos)       /*!< 0x80000000 */
#define HRTIM_ADC1R_AD1TEPER          HRTIM_ADC1R_AD1TEPER_Msk                 /*!< ADC Trigger 1 on Timer E period */

/*******************  Bit definition for HRTIM_ADC2R register  ****************/
#define HRTIM_ADC2R_AD2MC1_Pos        (0U)                                     
#define HRTIM_ADC2R_AD2MC1_Msk        (0x1U << HRTIM_ADC2R_AD2MC1_Pos)         /*!< 0x00000001 */
#define HRTIM_ADC2R_AD2MC1            HRTIM_ADC2R_AD2MC1_Msk                   /*!< ADC Trigger 2 on master compare 1 */
#define HRTIM_ADC2R_AD2MC2_Pos        (1U)                                     
#define HRTIM_ADC2R_AD2MC2_Msk        (0x1U << HRTIM_ADC2R_AD2MC2_Pos)         /*!< 0x00000002 */
#define HRTIM_ADC2R_AD2MC2            HRTIM_ADC2R_AD2MC2_Msk                   /*!< ADC Trigger 2 on master compare 2 */
#define HRTIM_ADC2R_AD2MC3_Pos        (2U)                                     
#define HRTIM_ADC2R_AD2MC3_Msk        (0x1U << HRTIM_ADC2R_AD2MC3_Pos)         /*!< 0x00000004 */
#define HRTIM_ADC2R_AD2MC3            HRTIM_ADC2R_AD2MC3_Msk                   /*!< ADC Trigger 2 on master compare 3 */
#define HRTIM_ADC2R_AD2MC4_Pos        (3U)                                     
#define HRTIM_ADC2R_AD2MC4_Msk        (0x1U << HRTIM_ADC2R_AD2MC4_Pos)         /*!< 0x00000008 */
#define HRTIM_ADC2R_AD2MC4            HRTIM_ADC2R_AD2MC4_Msk                   /*!< ADC Trigger 2 on master compare 4 */
#define HRTIM_ADC2R_AD2MPER_Pos       (4U)                                     
#define HRTIM_ADC2R_AD2MPER_Msk       (0x1U << HRTIM_ADC2R_AD2MPER_Pos)        /*!< 0x00000010 */
#define HRTIM_ADC2R_AD2MPER           HRTIM_ADC2R_AD2MPER_Msk                  /*!< ADC Trigger 2 on master period */
#define HRTIM_ADC2R_AD2EEV6_Pos       (5U)                                     
#define HRTIM_ADC2R_AD2EEV6_Msk       (0x1U << HRTIM_ADC2R_AD2EEV6_Pos)        /*!< 0x00000020 */
#define HRTIM_ADC2R_AD2EEV6           HRTIM_ADC2R_AD2EEV6_Msk                  /*!< ADC Trigger 2 on external event 6 */
#define HRTIM_ADC2R_AD2EEV7_Pos       (6U)                                     
#define HRTIM_ADC2R_AD2EEV7_Msk       (0x1U << HRTIM_ADC2R_AD2EEV7_Pos)        /*!< 0x00000040 */
#define HRTIM_ADC2R_AD2EEV7           HRTIM_ADC2R_AD2EEV7_Msk                  /*!< ADC Trigger 2 on external event 7 */
#define HRTIM_ADC2R_AD2EEV8_Pos       (7U)                                     
#define HRTIM_ADC2R_AD2EEV8_Msk       (0x1U << HRTIM_ADC2R_AD2EEV8_Pos)        /*!< 0x00000080 */
#define HRTIM_ADC2R_AD2EEV8           HRTIM_ADC2R_AD2EEV8_Msk                  /*!< ADC Trigger 2 on external event 8 */
#define HRTIM_ADC2R_AD2EEV9_Pos       (8U)                                     
#define HRTIM_ADC2R_AD2EEV9_Msk       (0x1U << HRTIM_ADC2R_AD2EEV9_Pos)        /*!< 0x00000100 */
#define HRTIM_ADC2R_AD2EEV9           HRTIM_ADC2R_AD2EEV9_Msk                  /*!< ADC Trigger 2 on external event 9 */
#define HRTIM_ADC2R_AD2EEV10_Pos      (9U)                                     
#define HRTIM_ADC2R_AD2EEV10_Msk      (0x1U << HRTIM_ADC2R_AD2EEV10_Pos)       /*!< 0x00000200 */
#define HRTIM_ADC2R_AD2EEV10          HRTIM_ADC2R_AD2EEV10_Msk                 /*!< ADC Trigger 2 on external event 10 */
#define HRTIM_ADC2R_AD2TAC2_Pos       (10U)                                    
#define HRTIM_ADC2R_AD2TAC2_Msk       (0x1U << HRTIM_ADC2R_AD2TAC2_Pos)        /*!< 0x00000400 */
#define HRTIM_ADC2R_AD2TAC2           HRTIM_ADC2R_AD2TAC2_Msk                  /*!< ADC Trigger 2 on Timer A compare 2 */
#define HRTIM_ADC2R_AD2TAC3_Pos       (11U)                                    
#define HRTIM_ADC2R_AD2TAC3_Msk       (0x1U << HRTIM_ADC2R_AD2TAC3_Pos)        /*!< 0x00000800 */
#define HRTIM_ADC2R_AD2TAC3           HRTIM_ADC2R_AD2TAC3_Msk                  /*!< ADC Trigger 2 on Timer A compare 3 */
#define HRTIM_ADC2R_AD2TAC4_Pos       (12U)                                    
#define HRTIM_ADC2R_AD2TAC4_Msk       (0x1U << HRTIM_ADC2R_AD2TAC4_Pos)        /*!< 0x00001000 */
#define HRTIM_ADC2R_AD2TAC4           HRTIM_ADC2R_AD2TAC4_Msk                  /*!< ADC Trigger 2 on Timer A compare 4*/
#define HRTIM_ADC2R_AD2TAPER_Pos      (13U)                                    
#define HRTIM_ADC2R_AD2TAPER_Msk      (0x1U << HRTIM_ADC2R_AD2TAPER_Pos)       /*!< 0x00002000 */
#define HRTIM_ADC2R_AD2TAPER          HRTIM_ADC2R_AD2TAPER_Msk                 /*!< ADC Trigger 2 on Timer A period */
#define HRTIM_ADC2R_AD2TBC2_Pos       (14U)                                    
#define HRTIM_ADC2R_AD2TBC2_Msk       (0x1U << HRTIM_ADC2R_AD2TBC2_Pos)        /*!< 0x00004000 */
#define HRTIM_ADC2R_AD2TBC2           HRTIM_ADC2R_AD2TBC2_Msk                  /*!< ADC Trigger 2 on Timer B compare 2 */
#define HRTIM_ADC2R_AD2TBC3_Pos       (15U)                                    
#define HRTIM_ADC2R_AD2TBC3_Msk       (0x1U << HRTIM_ADC2R_AD2TBC3_Pos)        /*!< 0x00008000 */
#define HRTIM_ADC2R_AD2TBC3           HRTIM_ADC2R_AD2TBC3_Msk                  /*!< ADC Trigger 2 on Timer B compare 3 */
#define HRTIM_ADC2R_AD2TBC4_Pos       (16U)                                    
#define HRTIM_ADC2R_AD2TBC4_Msk       (0x1U << HRTIM_ADC2R_AD2TBC4_Pos)        /*!< 0x00010000 */
#define HRTIM_ADC2R_AD2TBC4           HRTIM_ADC2R_AD2TBC4_Msk                  /*!< ADC Trigger 2 on Timer B compare 4 */
#define HRTIM_ADC2R_AD2TBPER_Pos      (17U)                                    
#define HRTIM_ADC2R_AD2TBPER_Msk      (0x1U << HRTIM_ADC2R_AD2TBPER_Pos)       /*!< 0x00020000 */
#define HRTIM_ADC2R_AD2TBPER          HRTIM_ADC2R_AD2TBPER_Msk                 /*!< ADC Trigger 2 on Timer B period */
#define HRTIM_ADC2R_AD2TCC2_Pos       (18U)                                    
#define HRTIM_ADC2R_AD2TCC2_Msk       (0x1U << HRTIM_ADC2R_AD2TCC2_Pos)        /*!< 0x00040000 */
#define HRTIM_ADC2R_AD2TCC2           HRTIM_ADC2R_AD2TCC2_Msk                  /*!< ADC Trigger 2 on Timer C compare 2 */
#define HRTIM_ADC2R_AD2TCC3_Pos       (19U)                                    
#define HRTIM_ADC2R_AD2TCC3_Msk       (0x1U << HRTIM_ADC2R_AD2TCC3_Pos)        /*!< 0x00080000 */
#define HRTIM_ADC2R_AD2TCC3           HRTIM_ADC2R_AD2TCC3_Msk                  /*!< ADC Trigger 2 on Timer C compare 3 */
#define HRTIM_ADC2R_AD2TCC4_Pos       (20U)                                    
#define HRTIM_ADC2R_AD2TCC4_Msk       (0x1U << HRTIM_ADC2R_AD2TCC4_Pos)        /*!< 0x00100000 */
#define HRTIM_ADC2R_AD2TCC4           HRTIM_ADC2R_AD2TCC4_Msk                  /*!< ADC Trigger 2 on Timer C compare 4 */
#define HRTIM_ADC2R_AD2TCPER_Pos      (21U)                                    
#define HRTIM_ADC2R_AD2TCPER_Msk      (0x1U << HRTIM_ADC2R_AD2TCPER_Pos)       /*!< 0x00200000 */
#define HRTIM_ADC2R_AD2TCPER          HRTIM_ADC2R_AD2TCPER_Msk                 /*!< ADC Trigger 2 on Timer C period */
#define HRTIM_ADC2R_AD2TCRST_Pos      (22U)                                    
#define HRTIM_ADC2R_AD2TCRST_Msk      (0x1U << HRTIM_ADC2R_AD2TCRST_Pos)       /*!< 0x00400000 */
#define HRTIM_ADC2R_AD2TCRST          HRTIM_ADC2R_AD2TCRST_Msk                 /*!< ADC Trigger 2 on Timer C reset */
#define HRTIM_ADC2R_AD2TDC2_Pos       (23U)                                    
#define HRTIM_ADC2R_AD2TDC2_Msk       (0x1U << HRTIM_ADC2R_AD2TDC2_Pos)        /*!< 0x00800000 */
#define HRTIM_ADC2R_AD2TDC2           HRTIM_ADC2R_AD2TDC2_Msk                  /*!< ADC Trigger 2 on Timer D compare 2 */
#define HRTIM_ADC2R_AD2TDC3_Pos       (24U)                                    
#define HRTIM_ADC2R_AD2TDC3_Msk       (0x1U << HRTIM_ADC2R_AD2TDC3_Pos)        /*!< 0x01000000 */
#define HRTIM_ADC2R_AD2TDC3           HRTIM_ADC2R_AD2TDC3_Msk                  /*!< ADC Trigger 2 on Timer D compare 3 */
#define HRTIM_ADC2R_AD2TDC4_Pos       (25U)                                    
#define HRTIM_ADC2R_AD2TDC4_Msk       (0x1U << HRTIM_ADC2R_AD2TDC4_Pos)        /*!< 0x02000000 */
#define HRTIM_ADC2R_AD2TDC4           HRTIM_ADC2R_AD2TDC4_Msk                  /*!< ADC Trigger 2 on Timer D compare 4*/
#define HRTIM_ADC2R_AD2TDPER_Pos      (26U)                                    
#define HRTIM_ADC2R_AD2TDPER_Msk      (0x1U << HRTIM_ADC2R_AD2TDPER_Pos)       /*!< 0x04000000 */
#define HRTIM_ADC2R_AD2TDPER          HRTIM_ADC2R_AD2TDPER_Msk                 /*!< ADC Trigger 2 on Timer D period */
#define HRTIM_ADC2R_AD2TDRST_Pos      (27U)                                    
#define HRTIM_ADC2R_AD2TDRST_Msk      (0x1U << HRTIM_ADC2R_AD2TDRST_Pos)       /*!< 0x08000000 */
#define HRTIM_ADC2R_AD2TDRST          HRTIM_ADC2R_AD2TDRST_Msk                 /*!< ADC Trigger 2 on Timer D reset */
#define HRTIM_ADC2R_AD2TEC2_Pos       (28U)                                    
#define HRTIM_ADC2R_AD2TEC2_Msk       (0x1U << HRTIM_ADC2R_AD2TEC2_Pos)        /*!< 0x10000000 */
#define HRTIM_ADC2R_AD2TEC2           HRTIM_ADC2R_AD2TEC2_Msk                  /*!< ADC Trigger 2 on Timer E compare 2 */
#define HRTIM_ADC2R_AD2TEC3_Pos       (29U)                                    
#define HRTIM_ADC2R_AD2TEC3_Msk       (0x1U << HRTIM_ADC2R_AD2TEC3_Pos)        /*!< 0x20000000 */
#define HRTIM_ADC2R_AD2TEC3           HRTIM_ADC2R_AD2TEC3_Msk                  /*!< ADC Trigger 2 on Timer E compare 3 */
#define HRTIM_ADC2R_AD2TEC4_Pos       (30U)                                    
#define HRTIM_ADC2R_AD2TEC4_Msk       (0x1U << HRTIM_ADC2R_AD2TEC4_Pos)        /*!< 0x40000000 */
#define HRTIM_ADC2R_AD2TEC4           HRTIM_ADC2R_AD2TEC4_Msk                  /*!< ADC Trigger 2 on Timer E compare 4 */
#define HRTIM_ADC2R_AD2TERST_Pos      (31U)                                    
#define HRTIM_ADC2R_AD2TERST_Msk      (0x1U << HRTIM_ADC2R_AD2TERST_Pos)       /*!< 0x80000000 */
#define HRTIM_ADC2R_AD2TERST          HRTIM_ADC2R_AD2TERST_Msk                 /*!< ADC Trigger 2 on Timer E reset */

/*******************  Bit definition for HRTIM_ADC3R register  ****************/
#define HRTIM_ADC3R_AD3MC1_Pos        (0U)                                     
#define HRTIM_ADC3R_AD3MC1_Msk        (0x1U << HRTIM_ADC3R_AD3MC1_Pos)         /*!< 0x00000001 */
#define HRTIM_ADC3R_AD3MC1            HRTIM_ADC3R_AD3MC1_Msk                   /*!< ADC Trigger 3 on master compare 1 */
#define HRTIM_ADC3R_AD3MC2_Pos        (1U)                                     
#define HRTIM_ADC3R_AD3MC2_Msk        (0x1U << HRTIM_ADC3R_AD3MC2_Pos)         /*!< 0x00000002 */
#define HRTIM_ADC3R_AD3MC2            HRTIM_ADC3R_AD3MC2_Msk                   /*!< ADC Trigger 3 on master compare 2 */
#define HRTIM_ADC3R_AD3MC3_Pos        (2U)                                     
#define HRTIM_ADC3R_AD3MC3_Msk        (0x1U << HRTIM_ADC3R_AD3MC3_Pos)         /*!< 0x00000004 */
#define HRTIM_ADC3R_AD3MC3            HRTIM_ADC3R_AD3MC3_Msk                   /*!< ADC Trigger 3 on master compare 3 */
#define HRTIM_ADC3R_AD3MC4_Pos        (3U)                                     
#define HRTIM_ADC3R_AD3MC4_Msk        (0x1U << HRTIM_ADC3R_AD3MC4_Pos)         /*!< 0x00000008 */
#define HRTIM_ADC3R_AD3MC4            HRTIM_ADC3R_AD3MC4_Msk                   /*!< ADC Trigger 3 on master compare 4 */
#define HRTIM_ADC3R_AD3MPER_Pos       (4U)                                     
#define HRTIM_ADC3R_AD3MPER_Msk       (0x1U << HRTIM_ADC3R_AD3MPER_Pos)        /*!< 0x00000010 */
#define HRTIM_ADC3R_AD3MPER           HRTIM_ADC3R_AD3MPER_Msk                  /*!< ADC Trigger 3 on master period */
#define HRTIM_ADC3R_AD3EEV1_Pos       (5U)                                     
#define HRTIM_ADC3R_AD3EEV1_Msk       (0x1U << HRTIM_ADC3R_AD3EEV1_Pos)        /*!< 0x00000020 */
#define HRTIM_ADC3R_AD3EEV1           HRTIM_ADC3R_AD3EEV1_Msk                  /*!< ADC Trigger 3 on external event 1 */
#define HRTIM_ADC3R_AD3EEV2_Pos       (6U)                                     
#define HRTIM_ADC3R_AD3EEV2_Msk       (0x1U << HRTIM_ADC3R_AD3EEV2_Pos)        /*!< 0x00000040 */
#define HRTIM_ADC3R_AD3EEV2           HRTIM_ADC3R_AD3EEV2_Msk                  /*!< ADC Trigger 3 on external event 2 */
#define HRTIM_ADC3R_AD3EEV3_Pos       (7U)                                     
#define HRTIM_ADC3R_AD3EEV3_Msk       (0x1U << HRTIM_ADC3R_AD3EEV3_Pos)        /*!< 0x00000080 */
#define HRTIM_ADC3R_AD3EEV3           HRTIM_ADC3R_AD3EEV3_Msk                  /*!< ADC Trigger 3 on external event 3 */
#define HRTIM_ADC3R_AD3EEV4_Pos       (8U)                                     
#define HRTIM_ADC3R_AD3EEV4_Msk       (0x1U << HRTIM_ADC3R_AD3EEV4_Pos)        /*!< 0x00000100 */
#define HRTIM_ADC3R_AD3EEV4           HRTIM_ADC3R_AD3EEV4_Msk                  /*!< ADC Trigger 3 on external event 4 */
#define HRTIM_ADC3R_AD3EEV5_Pos       (9U)                                     
#define HRTIM_ADC3R_AD3EEV5_Msk       (0x1U << HRTIM_ADC3R_AD3EEV5_Pos)        /*!< 0x00000200 */
#define HRTIM_ADC3R_AD3EEV5           HRTIM_ADC3R_AD3EEV5_Msk                  /*!< ADC Trigger 3 on external event 5 */
#define HRTIM_ADC3R_AD3TAC2_Pos       (10U)                                    
#define HRTIM_ADC3R_AD3TAC2_Msk       (0x1U << HRTIM_ADC3R_AD3TAC2_Pos)        /*!< 0x00000400 */
#define HRTIM_ADC3R_AD3TAC2           HRTIM_ADC3R_AD3TAC2_Msk                  /*!< ADC Trigger 3 on Timer A compare 2 */
#define HRTIM_ADC3R_AD3TAC3_Pos       (11U)                                    
#define HRTIM_ADC3R_AD3TAC3_Msk       (0x1U << HRTIM_ADC3R_AD3TAC3_Pos)        /*!< 0x00000800 */
#define HRTIM_ADC3R_AD3TAC3           HRTIM_ADC3R_AD3TAC3_Msk                  /*!< ADC Trigger 3 on Timer A compare 3 */
#define HRTIM_ADC3R_AD3TAC4_Pos       (12U)                                    
#define HRTIM_ADC3R_AD3TAC4_Msk       (0x1U << HRTIM_ADC3R_AD3TAC4_Pos)        /*!< 0x00001000 */
#define HRTIM_ADC3R_AD3TAC4           HRTIM_ADC3R_AD3TAC4_Msk                  /*!< ADC Trigger 3 on Timer A compare 4 */
#define HRTIM_ADC3R_AD3TAPER_Pos      (13U)                                    
#define HRTIM_ADC3R_AD3TAPER_Msk      (0x1U << HRTIM_ADC3R_AD3TAPER_Pos)       /*!< 0x00002000 */
#define HRTIM_ADC3R_AD3TAPER          HRTIM_ADC3R_AD3TAPER_Msk                 /*!< ADC Trigger 3 on Timer A period */
#define HRTIM_ADC3R_AD3TARST_Pos      (14U)                                    
#define HRTIM_ADC3R_AD3TARST_Msk      (0x1U << HRTIM_ADC3R_AD3TARST_Pos)       /*!< 0x00004000 */
#define HRTIM_ADC3R_AD3TARST          HRTIM_ADC3R_AD3TARST_Msk                 /*!< ADC Trigger 3 on Timer A reset */
#define HRTIM_ADC3R_AD3TBC2_Pos       (15U)                                    
#define HRTIM_ADC3R_AD3TBC2_Msk       (0x1U << HRTIM_ADC3R_AD3TBC2_Pos)        /*!< 0x00008000 */
#define HRTIM_ADC3R_AD3TBC2           HRTIM_ADC3R_AD3TBC2_Msk                  /*!< ADC Trigger 3 on Timer B compare 2 */
#define HRTIM_ADC3R_AD3TBC3_Pos       (16U)                                    
#define HRTIM_ADC3R_AD3TBC3_Msk       (0x1U << HRTIM_ADC3R_AD3TBC3_Pos)        /*!< 0x00010000 */
#define HRTIM_ADC3R_AD3TBC3           HRTIM_ADC3R_AD3TBC3_Msk                  /*!< ADC Trigger 3 on Timer B compare 3 */
#define HRTIM_ADC3R_AD3TBC4_Pos       (17U)                                    
#define HRTIM_ADC3R_AD3TBC4_Msk       (0x1U << HRTIM_ADC3R_AD3TBC4_Pos)        /*!< 0x00020000 */
#define HRTIM_ADC3R_AD3TBC4           HRTIM_ADC3R_AD3TBC4_Msk                  /*!< ADC Trigger 3 on Timer B compare 4 */
#define HRTIM_ADC3R_AD3TBPER_Pos      (18U)                                    
#define HRTIM_ADC3R_AD3TBPER_Msk      (0x1U << HRTIM_ADC3R_AD3TBPER_Pos)       /*!< 0x00040000 */
#define HRTIM_ADC3R_AD3TBPER          HRTIM_ADC3R_AD3TBPER_Msk                 /*!< ADC Trigger 3 on Timer B period */
#define HRTIM_ADC3R_AD3TBRST_Pos      (19U)                                    
#define HRTIM_ADC3R_AD3TBRST_Msk      (0x1U << HRTIM_ADC3R_AD3TBRST_Pos)       /*!< 0x00080000 */
#define HRTIM_ADC3R_AD3TBRST          HRTIM_ADC3R_AD3TBRST_Msk                 /*!< ADC Trigger 3 on Timer B reset */
#define HRTIM_ADC3R_AD3TCC2_Pos       (20U)                                    
#define HRTIM_ADC3R_AD3TCC2_Msk       (0x1U << HRTIM_ADC3R_AD3TCC2_Pos)        /*!< 0x00100000 */
#define HRTIM_ADC3R_AD3TCC2           HRTIM_ADC3R_AD3TCC2_Msk                  /*!< ADC Trigger 3 on Timer C compare 2 */
#define HRTIM_ADC3R_AD3TCC3_Pos       (21U)                                    
#define HRTIM_ADC3R_AD3TCC3_Msk       (0x1U << HRTIM_ADC3R_AD3TCC3_Pos)        /*!< 0x00200000 */
#define HRTIM_ADC3R_AD3TCC3           HRTIM_ADC3R_AD3TCC3_Msk                  /*!< ADC Trigger 3 on Timer C compare 3 */
#define HRTIM_ADC3R_AD3TCC4_Pos       (22U)                                    
#define HRTIM_ADC3R_AD3TCC4_Msk       (0x1U << HRTIM_ADC3R_AD3TCC4_Pos)        /*!< 0x00400000 */
#define HRTIM_ADC3R_AD3TCC4           HRTIM_ADC3R_AD3TCC4_Msk                  /*!< ADC Trigger 3 on Timer C compare 4 */
#define HRTIM_ADC3R_AD3TCPER_Pos      (23U)                                    
#define HRTIM_ADC3R_AD3TCPER_Msk      (0x1U << HRTIM_ADC3R_AD3TCPER_Pos)       /*!< 0x00800000 */
#define HRTIM_ADC3R_AD3TCPER          HRTIM_ADC3R_AD3TCPER_Msk                 /*!< ADC Trigger 3 on Timer C period */
#define HRTIM_ADC3R_AD3TDC2_Pos       (24U)                                    
#define HRTIM_ADC3R_AD3TDC2_Msk       (0x1U << HRTIM_ADC3R_AD3TDC2_Pos)        /*!< 0x01000000 */
#define HRTIM_ADC3R_AD3TDC2           HRTIM_ADC3R_AD3TDC2_Msk                  /*!< ADC Trigger 3 on Timer D compare 2 */
#define HRTIM_ADC3R_AD3TDC3_Pos       (25U)                                    
#define HRTIM_ADC3R_AD3TDC3_Msk       (0x1U << HRTIM_ADC3R_AD3TDC3_Pos)        /*!< 0x02000000 */
#define HRTIM_ADC3R_AD3TDC3           HRTIM_ADC3R_AD3TDC3_Msk                  /*!< ADC Trigger 3 on Timer D compare 3 */
#define HRTIM_ADC3R_AD3TDC4_Pos       (26U)                                    
#define HRTIM_ADC3R_AD3TDC4_Msk       (0x1U << HRTIM_ADC3R_AD3TDC4_Pos)        /*!< 0x04000000 */
#define HRTIM_ADC3R_AD3TDC4           HRTIM_ADC3R_AD3TDC4_Msk                  /*!< ADC Trigger 3 on Timer D compare 4 */
#define HRTIM_ADC3R_AD3TDPER_Pos      (27U)                                    
#define HRTIM_ADC3R_AD3TDPER_Msk      (0x1U << HRTIM_ADC3R_AD3TDPER_Pos)       /*!< 0x08000000 */
#define HRTIM_ADC3R_AD3TDPER          HRTIM_ADC3R_AD3TDPER_Msk                 /*!< ADC Trigger 3 on Timer D period */
#define HRTIM_ADC3R_AD3TEC2_Pos       (28U)                                    
#define HRTIM_ADC3R_AD3TEC2_Msk       (0x1U << HRTIM_ADC3R_AD3TEC2_Pos)        /*!< 0x10000000 */
#define HRTIM_ADC3R_AD3TEC2           HRTIM_ADC3R_AD3TEC2_Msk                  /*!< ADC Trigger 3 on Timer E compare 2 */
#define HRTIM_ADC3R_AD3TEC3_Pos       (29U)                                    
#define HRTIM_ADC3R_AD3TEC3_Msk       (0x1U << HRTIM_ADC3R_AD3TEC3_Pos)        /*!< 0x20000000 */
#define HRTIM_ADC3R_AD3TEC3           HRTIM_ADC3R_AD3TEC3_Msk                  /*!< ADC Trigger 3 on Timer E compare 3 */
#define HRTIM_ADC3R_AD3TEC4_Pos       (30U)                                    
#define HRTIM_ADC3R_AD3TEC4_Msk       (0x1U << HRTIM_ADC3R_AD3TEC4_Pos)        /*!< 0x40000000 */
#define HRTIM_ADC3R_AD3TEC4           HRTIM_ADC3R_AD3TEC4_Msk                  /*!< ADC Trigger 3 on Timer E compare 4 */
#define HRTIM_ADC3R_AD3TEPER_Pos      (31U)                                    
#define HRTIM_ADC3R_AD3TEPER_Msk      (0x1U << HRTIM_ADC3R_AD3TEPER_Pos)       /*!< 0x80000000 */
#define HRTIM_ADC3R_AD3TEPER          HRTIM_ADC3R_AD3TEPER_Msk                 /*!< ADC Trigger 3 on Timer E period */

/*******************  Bit definition for HRTIM_ADC4R register  ****************/
#define HRTIM_ADC4R_AD4MC1_Pos        (0U)                                     
#define HRTIM_ADC4R_AD4MC1_Msk        (0x1U << HRTIM_ADC4R_AD4MC1_Pos)         /*!< 0x00000001 */
#define HRTIM_ADC4R_AD4MC1            HRTIM_ADC4R_AD4MC1_Msk                   /*!< ADC Trigger 4 on master compare 1 */
#define HRTIM_ADC4R_AD4MC2_Pos        (1U)                                     
#define HRTIM_ADC4R_AD4MC2_Msk        (0x1U << HRTIM_ADC4R_AD4MC2_Pos)         /*!< 0x00000002 */
#define HRTIM_ADC4R_AD4MC2            HRTIM_ADC4R_AD4MC2_Msk                   /*!< ADC Trigger 4 on master compare 2 */
#define HRTIM_ADC4R_AD4MC3_Pos        (2U)                                     
#define HRTIM_ADC4R_AD4MC3_Msk        (0x1U << HRTIM_ADC4R_AD4MC3_Pos)         /*!< 0x00000004 */
#define HRTIM_ADC4R_AD4MC3            HRTIM_ADC4R_AD4MC3_Msk                   /*!< ADC Trigger 4 on master compare 3 */
#define HRTIM_ADC4R_AD4MC4_Pos        (3U)                                     
#define HRTIM_ADC4R_AD4MC4_Msk        (0x1U << HRTIM_ADC4R_AD4MC4_Pos)         /*!< 0x00000008 */
#define HRTIM_ADC4R_AD4MC4            HRTIM_ADC4R_AD4MC4_Msk                   /*!< ADC Trigger 4 on master compare 4 */
#define HRTIM_ADC4R_AD4MPER_Pos       (4U)                                     
#define HRTIM_ADC4R_AD4MPER_Msk       (0x1U << HRTIM_ADC4R_AD4MPER_Pos)        /*!< 0x00000010 */
#define HRTIM_ADC4R_AD4MPER           HRTIM_ADC4R_AD4MPER_Msk                  /*!< ADC Trigger 4 on master period */
#define HRTIM_ADC4R_AD4EEV6_Pos       (5U)                                     
#define HRTIM_ADC4R_AD4EEV6_Msk       (0x1U << HRTIM_ADC4R_AD4EEV6_Pos)        /*!< 0x00000020 */
#define HRTIM_ADC4R_AD4EEV6           HRTIM_ADC4R_AD4EEV6_Msk                  /*!< ADC Trigger 4 on external event 6 */
#define HRTIM_ADC4R_AD4EEV7_Pos       (6U)                                     
#define HRTIM_ADC4R_AD4EEV7_Msk       (0x1U << HRTIM_ADC4R_AD4EEV7_Pos)        /*!< 0x00000040 */
#define HRTIM_ADC4R_AD4EEV7           HRTIM_ADC4R_AD4EEV7_Msk                  /*!< ADC Trigger 4 on external event 7 */
#define HRTIM_ADC4R_AD4EEV8_Pos       (7U)                                     
#define HRTIM_ADC4R_AD4EEV8_Msk       (0x1U << HRTIM_ADC4R_AD4EEV8_Pos)        /*!< 0x00000080 */
#define HRTIM_ADC4R_AD4EEV8           HRTIM_ADC4R_AD4EEV8_Msk                  /*!< ADC Trigger 4 on external event 8 */
#define HRTIM_ADC4R_AD4EEV9_Pos       (8U)                                     
#define HRTIM_ADC4R_AD4EEV9_Msk       (0x1U << HRTIM_ADC4R_AD4EEV9_Pos)        /*!< 0x00000100 */
#define HRTIM_ADC4R_AD4EEV9           HRTIM_ADC4R_AD4EEV9_Msk                  /*!< ADC Trigger 4 on external event 9 */
#define HRTIM_ADC4R_AD4EEV10_Pos      (9U)                                     
#define HRTIM_ADC4R_AD4EEV10_Msk      (0x1U << HRTIM_ADC4R_AD4EEV10_Pos)       /*!< 0x00000200 */
#define HRTIM_ADC4R_AD4EEV10          HRTIM_ADC4R_AD4EEV10_Msk                 /*!< ADC Trigger 4 on external event 10 */
#define HRTIM_ADC4R_AD4TAC2_Pos       (10U)                                    
#define HRTIM_ADC4R_AD4TAC2_Msk       (0x1U << HRTIM_ADC4R_AD4TAC2_Pos)        /*!< 0x00000400 */
#define HRTIM_ADC4R_AD4TAC2           HRTIM_ADC4R_AD4TAC2_Msk                  /*!< ADC Trigger 4 on Timer A compare 2 */
#define HRTIM_ADC4R_AD4TAC3_Pos       (11U)                                    
#define HRTIM_ADC4R_AD4TAC3_Msk       (0x1U << HRTIM_ADC4R_AD4TAC3_Pos)        /*!< 0x00000800 */
#define HRTIM_ADC4R_AD4TAC3           HRTIM_ADC4R_AD4TAC3_Msk                  /*!< ADC Trigger 4 on Timer A compare 3 */
#define HRTIM_ADC4R_AD4TAC4_Pos       (12U)                                    
#define HRTIM_ADC4R_AD4TAC4_Msk       (0x1U << HRTIM_ADC4R_AD4TAC4_Pos)        /*!< 0x00001000 */
#define HRTIM_ADC4R_AD4TAC4           HRTIM_ADC4R_AD4TAC4_Msk                  /*!< ADC Trigger 4 on Timer A compare 4*/
#define HRTIM_ADC4R_AD4TAPER_Pos      (13U)                                    
#define HRTIM_ADC4R_AD4TAPER_Msk      (0x1U << HRTIM_ADC4R_AD4TAPER_Pos)       /*!< 0x00002000 */
#define HRTIM_ADC4R_AD4TAPER          HRTIM_ADC4R_AD4TAPER_Msk                 /*!< ADC Trigger 4 on Timer A period */
#define HRTIM_ADC4R_AD4TBC2_Pos       (14U)                                    
#define HRTIM_ADC4R_AD4TBC2_Msk       (0x1U << HRTIM_ADC4R_AD4TBC2_Pos)        /*!< 0x00004000 */
#define HRTIM_ADC4R_AD4TBC2           HRTIM_ADC4R_AD4TBC2_Msk                  /*!< ADC Trigger 4 on Timer B compare 2 */
#define HRTIM_ADC4R_AD4TBC3_Pos       (15U)                                    
#define HRTIM_ADC4R_AD4TBC3_Msk       (0x1U << HRTIM_ADC4R_AD4TBC3_Pos)        /*!< 0x00008000 */
#define HRTIM_ADC4R_AD4TBC3           HRTIM_ADC4R_AD4TBC3_Msk                  /*!< ADC Trigger 4 on Timer B compare 3 */
#define HRTIM_ADC4R_AD4TBC4_Pos       (16U)                                    
#define HRTIM_ADC4R_AD4TBC4_Msk       (0x1U << HRTIM_ADC4R_AD4TBC4_Pos)        /*!< 0x00010000 */
#define HRTIM_ADC4R_AD4TBC4           HRTIM_ADC4R_AD4TBC4_Msk                  /*!< ADC Trigger 4 on Timer B compare 4 */
#define HRTIM_ADC4R_AD4TBPER_Pos      (17U)                                    
#define HRTIM_ADC4R_AD4TBPER_Msk      (0x1U << HRTIM_ADC4R_AD4TBPER_Pos)       /*!< 0x00020000 */
#define HRTIM_ADC4R_AD4TBPER          HRTIM_ADC4R_AD4TBPER_Msk                 /*!< ADC Trigger 4 on Timer B period */
#define HRTIM_ADC4R_AD4TCC2_Pos       (18U)                                    
#define HRTIM_ADC4R_AD4TCC2_Msk       (0x1U << HRTIM_ADC4R_AD4TCC2_Pos)        /*!< 0x00040000 */
#define HRTIM_ADC4R_AD4TCC2           HRTIM_ADC4R_AD4TCC2_Msk                  /*!< ADC Trigger 4 on Timer C compare 2 */
#define HRTIM_ADC4R_AD4TCC3_Pos       (19U)                                    
#define HRTIM_ADC4R_AD4TCC3_Msk       (0x1U << HRTIM_ADC4R_AD4TCC3_Pos)        /*!< 0x00080000 */
#define HRTIM_ADC4R_AD4TCC3           HRTIM_ADC4R_AD4TCC3_Msk                  /*!< ADC Trigger 4 on Timer C compare 3 */
#define HRTIM_ADC4R_AD4TCC4_Pos       (20U)                                    
#define HRTIM_ADC4R_AD4TCC4_Msk       (0x1U << HRTIM_ADC4R_AD4TCC4_Pos)        /*!< 0x00100000 */
#define HRTIM_ADC4R_AD4TCC4           HRTIM_ADC4R_AD4TCC4_Msk                  /*!< ADC Trigger 4 on Timer C compare 4 */
#define HRTIM_ADC4R_AD4TCPER_Pos      (21U)                                    
#define HRTIM_ADC4R_AD4TCPER_Msk      (0x1U << HRTIM_ADC4R_AD4TCPER_Pos)       /*!< 0x00200000 */
#define HRTIM_ADC4R_AD4TCPER          HRTIM_ADC4R_AD4TCPER_Msk                 /*!< ADC Trigger 4 on Timer C period */
#define HRTIM_ADC4R_AD4TCRST_Pos      (22U)                                    
#define HRTIM_ADC4R_AD4TCRST_Msk      (0x1U << HRTIM_ADC4R_AD4TCRST_Pos)       /*!< 0x00400000 */
#define HRTIM_ADC4R_AD4TCRST          HRTIM_ADC4R_AD4TCRST_Msk                 /*!< ADC Trigger 4 on Timer C reset */
#define HRTIM_ADC4R_AD4TDC2_Pos       (23U)                                    
#define HRTIM_ADC4R_AD4TDC2_Msk       (0x1U << HRTIM_ADC4R_AD4TDC2_Pos)        /*!< 0x00800000 */
#define HRTIM_ADC4R_AD4TDC2           HRTIM_ADC4R_AD4TDC2_Msk                  /*!< ADC Trigger 4 on Timer D compare 2 */
#define HRTIM_ADC4R_AD4TDC3_Pos       (24U)                                    
#define HRTIM_ADC4R_AD4TDC3_Msk       (0x1U << HRTIM_ADC4R_AD4TDC3_Pos)        /*!< 0x01000000 */
#define HRTIM_ADC4R_AD4TDC3           HRTIM_ADC4R_AD4TDC3_Msk                  /*!< ADC Trigger 4 on Timer D compare 3 */
#define HRTIM_ADC4R_AD4TDC4_Pos       (25U)                                    
#define HRTIM_ADC4R_AD4TDC4_Msk       (0x1U << HRTIM_ADC4R_AD4TDC4_Pos)        /*!< 0x02000000 */
#define HRTIM_ADC4R_AD4TDC4           HRTIM_ADC4R_AD4TDC4_Msk                  /*!< ADC Trigger 4 on Timer D compare 4*/
#define HRTIM_ADC4R_AD4TDPER_Pos      (26U)                                    
#define HRTIM_ADC4R_AD4TDPER_Msk      (0x1U << HRTIM_ADC4R_AD4TDPER_Pos)       /*!< 0x04000000 */
#define HRTIM_ADC4R_AD4TDPER          HRTIM_ADC4R_AD4TDPER_Msk                 /*!< ADC Trigger 4 on Timer D period */
#define HRTIM_ADC4R_AD4TDRST_Pos      (27U)                                    
#define HRTIM_ADC4R_AD4TDRST_Msk      (0x1U << HRTIM_ADC4R_AD4TDRST_Pos)       /*!< 0x08000000 */
#define HRTIM_ADC4R_AD4TDRST          HRTIM_ADC4R_AD4TDRST_Msk                 /*!< ADC Trigger 4 on Timer D reset */
#define HRTIM_ADC4R_AD4TEC2_Pos       (28U)                                    
#define HRTIM_ADC4R_AD4TEC2_Msk       (0x1U << HRTIM_ADC4R_AD4TEC2_Pos)        /*!< 0x10000000 */
#define HRTIM_ADC4R_AD4TEC2           HRTIM_ADC4R_AD4TEC2_Msk                  /*!< ADC Trigger 4 on Timer E compare 2 */
#define HRTIM_ADC4R_AD4TEC3_Pos       (29U)                                    
#define HRTIM_ADC4R_AD4TEC3_Msk       (0x1U << HRTIM_ADC4R_AD4TEC3_Pos)        /*!< 0x20000000 */
#define HRTIM_ADC4R_AD4TEC3           HRTIM_ADC4R_AD4TEC3_Msk                  /*!< ADC Trigger 4 on Timer E compare 3 */
#define HRTIM_ADC4R_AD4TEC4_Pos       (30U)                                    
#define HRTIM_ADC4R_AD4TEC4_Msk       (0x1U << HRTIM_ADC4R_AD4TEC4_Pos)        /*!< 0x40000000 */
#define HRTIM_ADC4R_AD4TEC4           HRTIM_ADC4R_AD4TEC4_Msk                  /*!< ADC Trigger 4 on Timer E compare 4 */
#define HRTIM_ADC4R_AD4TERST_Pos      (31U)                                    
#define HRTIM_ADC4R_AD4TERST_Msk      (0x1U << HRTIM_ADC4R_AD4TERST_Pos)       /*!< 0x80000000 */
#define HRTIM_ADC4R_AD4TERST          HRTIM_ADC4R_AD4TERST_Msk                 /*!< ADC Trigger 4 on Timer E reset */

/*******************  Bit definition for HRTIM_DLLCR register  ****************/
#define HRTIM_DLLCR_CAL_Pos           (0U)                                     
#define HRTIM_DLLCR_CAL_Msk           (0x1U << HRTIM_DLLCR_CAL_Pos)            /*!< 0x00000001 */
#define HRTIM_DLLCR_CAL               HRTIM_DLLCR_CAL_Msk                      /*!< DLL calibration start */ 
#define HRTIM_DLLCR_CALEN_Pos         (1U)                                     
#define HRTIM_DLLCR_CALEN_Msk         (0x1U << HRTIM_DLLCR_CALEN_Pos)          /*!< 0x00000002 */
#define HRTIM_DLLCR_CALEN             HRTIM_DLLCR_CALEN_Msk                    /*!< DLL calibration enable */  
#define HRTIM_DLLCR_CALRTE_Pos        (2U)                                     
#define HRTIM_DLLCR_CALRTE_Msk        (0x3U << HRTIM_DLLCR_CALRTE_Pos)         /*!< 0x0000000C */
#define HRTIM_DLLCR_CALRTE            HRTIM_DLLCR_CALRTE_Msk                   /*!< DLL calibration rate */
#define HRTIM_DLLCR_CALRTE_0          (0x1U << HRTIM_DLLCR_CALRTE_Pos)         /*!< 0x00000004 */
#define HRTIM_DLLCR_CALRTE_1          (0x2U << HRTIM_DLLCR_CALRTE_Pos)         /*!< 0x00000008 */

/*******************  Bit definition for HRTIM_FLTINR1 register  ***************/  
#define HRTIM_FLTINR1_FLT1E_Pos       (0U)                                     
#define HRTIM_FLTINR1_FLT1E_Msk       (0x1U << HRTIM_FLTINR1_FLT1E_Pos)        /*!< 0x00000001 */
#define HRTIM_FLTINR1_FLT1E           HRTIM_FLTINR1_FLT1E_Msk                  /*!< Fault 1 enable */ 
#define HRTIM_FLTINR1_FLT1P_Pos       (1U)                                     
#define HRTIM_FLTINR1_FLT1P_Msk       (0x1U << HRTIM_FLTINR1_FLT1P_Pos)        /*!< 0x00000002 */
#define HRTIM_FLTINR1_FLT1P           HRTIM_FLTINR1_FLT1P_Msk                  /*!< Fault 1 polarity */
#define HRTIM_FLTINR1_FLT1SRC_Pos     (2U)                                     
#define HRTIM_FLTINR1_FLT1SRC_Msk     (0x1U << HRTIM_FLTINR1_FLT1SRC_Pos)      /*!< 0x00000004 */
#define HRTIM_FLTINR1_FLT1SRC         HRTIM_FLTINR1_FLT1SRC_Msk                /*!< Fault 1 source */
#define HRTIM_FLTINR1_FLT1F_Pos       (3U)                                     
#define HRTIM_FLTINR1_FLT1F_Msk       (0xFU << HRTIM_FLTINR1_FLT1F_Pos)        /*!< 0x00000078 */
#define HRTIM_FLTINR1_FLT1F           HRTIM_FLTINR1_FLT1F_Msk                  /*!< Fault 1 filter */
#define HRTIM_FLTINR1_FLT1F_0         (0x1U << HRTIM_FLTINR1_FLT1F_Pos)        /*!< 0x00000008 */
#define HRTIM_FLTINR1_FLT1F_1         (0x2U << HRTIM_FLTINR1_FLT1F_Pos)        /*!< 0x00000010 */
#define HRTIM_FLTINR1_FLT1F_2         (0x4U << HRTIM_FLTINR1_FLT1F_Pos)        /*!< 0x00000020 */
#define HRTIM_FLTINR1_FLT1F_3         (0x8U << HRTIM_FLTINR1_FLT1F_Pos)        /*!< 0x00000040 */
#define HRTIM_FLTINR1_FLT1LCK_Pos     (7U)                                     
#define HRTIM_FLTINR1_FLT1LCK_Msk     (0x1U << HRTIM_FLTINR1_FLT1LCK_Pos)      /*!< 0x00000080 */
#define HRTIM_FLTINR1_FLT1LCK         HRTIM_FLTINR1_FLT1LCK_Msk                /*!< Fault 1 lock */ 

#define HRTIM_FLTINR1_FLT2E_Pos       (8U)                                     
#define HRTIM_FLTINR1_FLT2E_Msk       (0x1U << HRTIM_FLTINR1_FLT2E_Pos)        /*!< 0x00000100 */
#define HRTIM_FLTINR1_FLT2E           HRTIM_FLTINR1_FLT2E_Msk                  /*!< Fault 2 enable */ 
#define HRTIM_FLTINR1_FLT2P_Pos       (9U)                                     
#define HRTIM_FLTINR1_FLT2P_Msk       (0x1U << HRTIM_FLTINR1_FLT2P_Pos)        /*!< 0x00000200 */
#define HRTIM_FLTINR1_FLT2P           HRTIM_FLTINR1_FLT2P_Msk                  /*!< Fault 2 polarity */
#define HRTIM_FLTINR1_FLT2SRC_Pos     (10U)                                    
#define HRTIM_FLTINR1_FLT2SRC_Msk     (0x1U << HRTIM_FLTINR1_FLT2SRC_Pos)      /*!< 0x00000400 */
#define HRTIM_FLTINR1_FLT2SRC         HRTIM_FLTINR1_FLT2SRC_Msk                /*!< Fault 2 source */
#define HRTIM_FLTINR1_FLT2F_Pos       (11U)                                    
#define HRTIM_FLTINR1_FLT2F_Msk       (0xFU << HRTIM_FLTINR1_FLT2F_Pos)        /*!< 0x00007800 */
#define HRTIM_FLTINR1_FLT2F           HRTIM_FLTINR1_FLT2F_Msk                  /*!< Fault 2 filter */
#define HRTIM_FLTINR1_FLT2F_0         (0x1U << HRTIM_FLTINR1_FLT2F_Pos)        /*!< 0x00000800 */
#define HRTIM_FLTINR1_FLT2F_1         (0x2U << HRTIM_FLTINR1_FLT2F_Pos)        /*!< 0x00001000 */
#define HRTIM_FLTINR1_FLT2F_2         (0x4U << HRTIM_FLTINR1_FLT2F_Pos)        /*!< 0x00002000 */
#define HRTIM_FLTINR1_FLT2F_3         (0x8U << HRTIM_FLTINR1_FLT2F_Pos)        /*!< 0x00004000 */
#define HRTIM_FLTINR1_FLT2LCK_Pos     (15U)                                    
#define HRTIM_FLTINR1_FLT2LCK_Msk     (0x1U << HRTIM_FLTINR1_FLT2LCK_Pos)      /*!< 0x00008000 */
#define HRTIM_FLTINR1_FLT2LCK         HRTIM_FLTINR1_FLT2LCK_Msk                /*!< Fault 2 lock */ 

#define HRTIM_FLTINR1_FLT3E_Pos       (16U)                                    
#define HRTIM_FLTINR1_FLT3E_Msk       (0x1U << HRTIM_FLTINR1_FLT3E_Pos)        /*!< 0x00010000 */
#define HRTIM_FLTINR1_FLT3E           HRTIM_FLTINR1_FLT3E_Msk                  /*!< Fault 3 enable */ 
#define HRTIM_FLTINR1_FLT3P_Pos       (17U)                                    
#define HRTIM_FLTINR1_FLT3P_Msk       (0x1U << HRTIM_FLTINR1_FLT3P_Pos)        /*!< 0x00020000 */
#define HRTIM_FLTINR1_FLT3P           HRTIM_FLTINR1_FLT3P_Msk                  /*!< Fault 3 polarity */
#define HRTIM_FLTINR1_FLT3SRC_Pos     (18U)                                    
#define HRTIM_FLTINR1_FLT3SRC_Msk     (0x1U << HRTIM_FLTINR1_FLT3SRC_Pos)      /*!< 0x00040000 */
#define HRTIM_FLTINR1_FLT3SRC         HRTIM_FLTINR1_FLT3SRC_Msk                /*!< Fault 3 source */
#define HRTIM_FLTINR1_FLT3F_Pos       (19U)                                    
#define HRTIM_FLTINR1_FLT3F_Msk       (0xFU << HRTIM_FLTINR1_FLT3F_Pos)        /*!< 0x00780000 */
#define HRTIM_FLTINR1_FLT3F           HRTIM_FLTINR1_FLT3F_Msk                  /*!< Fault 3 filter */
#define HRTIM_FLTINR1_FLT3F_0         (0x1U << HRTIM_FLTINR1_FLT3F_Pos)        /*!< 0x00080000 */
#define HRTIM_FLTINR1_FLT3F_1         (0x2U << HRTIM_FLTINR1_FLT3F_Pos)        /*!< 0x00100000 */
#define HRTIM_FLTINR1_FLT3F_2         (0x4U << HRTIM_FLTINR1_FLT3F_Pos)        /*!< 0x00200000 */
#define HRTIM_FLTINR1_FLT3F_3         (0x8U << HRTIM_FLTINR1_FLT3F_Pos)        /*!< 0x00400000 */
#define HRTIM_FLTINR1_FLT3LCK_Pos     (23U)                                    
#define HRTIM_FLTINR1_FLT3LCK_Msk     (0x1U << HRTIM_FLTINR1_FLT3LCK_Pos)      /*!< 0x00800000 */
#define HRTIM_FLTINR1_FLT3LCK         HRTIM_FLTINR1_FLT3LCK_Msk                /*!< Fault 3 lock */ 

#define HRTIM_FLTINR1_FLT4E_Pos       (24U)                                    
#define HRTIM_FLTINR1_FLT4E_Msk       (0x1U << HRTIM_FLTINR1_FLT4E_Pos)        /*!< 0x01000000 */
#define HRTIM_FLTINR1_FLT4E           HRTIM_FLTINR1_FLT4E_Msk                  /*!< Fault 4 enable */ 
#define HRTIM_FLTINR1_FLT4P_Pos       (25U)                                    
#define HRTIM_FLTINR1_FLT4P_Msk       (0x1U << HRTIM_FLTINR1_FLT4P_Pos)        /*!< 0x02000000 */
#define HRTIM_FLTINR1_FLT4P           HRTIM_FLTINR1_FLT4P_Msk                  /*!< Fault 4 polarity */
#define HRTIM_FLTINR1_FLT4SRC_Pos     (26U)                                    
#define HRTIM_FLTINR1_FLT4SRC_Msk     (0x1U << HRTIM_FLTINR1_FLT4SRC_Pos)      /*!< 0x04000000 */
#define HRTIM_FLTINR1_FLT4SRC         HRTIM_FLTINR1_FLT4SRC_Msk                /*!< Fault 4 source */
#define HRTIM_FLTINR1_FLT4F_Pos       (27U)                                    
#define HRTIM_FLTINR1_FLT4F_Msk       (0xFU << HRTIM_FLTINR1_FLT4F_Pos)        /*!< 0x78000000 */
#define HRTIM_FLTINR1_FLT4F           HRTIM_FLTINR1_FLT4F_Msk                  /*!< Fault 4 filter */
#define HRTIM_FLTINR1_FLT4F_0         (0x1U << HRTIM_FLTINR1_FLT4F_Pos)        /*!< 0x08000000 */
#define HRTIM_FLTINR1_FLT4F_1         (0x2U << HRTIM_FLTINR1_FLT4F_Pos)        /*!< 0x10000000 */
#define HRTIM_FLTINR1_FLT4F_2         (0x4U << HRTIM_FLTINR1_FLT4F_Pos)        /*!< 0x20000000 */
#define HRTIM_FLTINR1_FLT4F_3         (0x8U << HRTIM_FLTINR1_FLT4F_Pos)        /*!< 0x40000000 */
#define HRTIM_FLTINR1_FLT4LCK_Pos     (31U)                                    
#define HRTIM_FLTINR1_FLT4LCK_Msk     (0x1U << HRTIM_FLTINR1_FLT4LCK_Pos)      /*!< 0x80000000 */
#define HRTIM_FLTINR1_FLT4LCK         HRTIM_FLTINR1_FLT4LCK_Msk                /*!< Fault 4 lock */

/*******************  Bit definition for HRTIM_FLTINR2 register  ***************/  
#define HRTIM_FLTINR2_FLT5E_Pos       (0U)                                     
#define HRTIM_FLTINR2_FLT5E_Msk       (0x1U << HRTIM_FLTINR2_FLT5E_Pos)        /*!< 0x00000001 */
#define HRTIM_FLTINR2_FLT5E           HRTIM_FLTINR2_FLT5E_Msk                  /*!< Fault 5 enable */ 
#define HRTIM_FLTINR2_FLT5P_Pos       (1U)                                     
#define HRTIM_FLTINR2_FLT5P_Msk       (0x1U << HRTIM_FLTINR2_FLT5P_Pos)        /*!< 0x00000002 */
#define HRTIM_FLTINR2_FLT5P           HRTIM_FLTINR2_FLT5P_Msk                  /*!< Fault 5 polarity */
#define HRTIM_FLTINR2_FLT5SRC_Pos     (2U)                                     
#define HRTIM_FLTINR2_FLT5SRC_Msk     (0x1U << HRTIM_FLTINR2_FLT5SRC_Pos)      /*!< 0x00000004 */
#define HRTIM_FLTINR2_FLT5SRC         HRTIM_FLTINR2_FLT5SRC_Msk                /*!< Fault 5 source */
#define HRTIM_FLTINR2_FLT5F_Pos       (3U)                                     
#define HRTIM_FLTINR2_FLT5F_Msk       (0xFU << HRTIM_FLTINR2_FLT5F_Pos)        /*!< 0x00000078 */
#define HRTIM_FLTINR2_FLT5F           HRTIM_FLTINR2_FLT5F_Msk                  /*!< Fault 5 filter */
#define HRTIM_FLTINR2_FLT5F_0         (0x1U << HRTIM_FLTINR2_FLT5F_Pos)        /*!< 0x00000008 */
#define HRTIM_FLTINR2_FLT5F_1         (0x2U << HRTIM_FLTINR2_FLT5F_Pos)        /*!< 0x00000010 */
#define HRTIM_FLTINR2_FLT5F_2         (0x4U << HRTIM_FLTINR2_FLT5F_Pos)        /*!< 0x00000020 */
#define HRTIM_FLTINR2_FLT5F_3         (0x8U << HRTIM_FLTINR2_FLT5F_Pos)        /*!< 0x00000040 */
#define HRTIM_FLTINR2_FLT5LCK_Pos     (7U)                                     
#define HRTIM_FLTINR2_FLT5LCK_Msk     (0x1U << HRTIM_FLTINR2_FLT5LCK_Pos)      /*!< 0x00000080 */
#define HRTIM_FLTINR2_FLT5LCK         HRTIM_FLTINR2_FLT5LCK_Msk                /*!< Fault 5 lock */
#define HRTIM_FLTINR2_FLTSD_Pos       (24U)                                    
#define HRTIM_FLTINR2_FLTSD_Msk       (0x3U << HRTIM_FLTINR2_FLTSD_Pos)        /*!< 0x03000000 */
#define HRTIM_FLTINR2_FLTSD           HRTIM_FLTINR2_FLTSD_Msk                  /*!< Fault sampling clock division */
#define HRTIM_FLTINR2_FLTSD_0         (0x1U << HRTIM_FLTINR2_FLTSD_Pos)        /*!< 0x01000000 */
#define HRTIM_FLTINR2_FLTSD_1         (0x2U << HRTIM_FLTINR2_FLTSD_Pos)        /*!< 0x02000000 */

/*******************  Bit definition for HRTIM_BDMUPR register  ***************/  
#define HRTIM_BDMUPR_MCR_Pos          (0U)                                     
#define HRTIM_BDMUPR_MCR_Msk          (0x1U << HRTIM_BDMUPR_MCR_Pos)           /*!< 0x00000001 */
#define HRTIM_BDMUPR_MCR              HRTIM_BDMUPR_MCR_Msk                     /*!< MCR register update enable */ 
#define HRTIM_BDMUPR_MICR_Pos         (1U)                                     
#define HRTIM_BDMUPR_MICR_Msk         (0x1U << HRTIM_BDMUPR_MICR_Pos)          /*!< 0x00000002 */
#define HRTIM_BDMUPR_MICR             HRTIM_BDMUPR_MICR_Msk                    /*!< MICR register update enable */ 
#define HRTIM_BDMUPR_MDIER_Pos        (2U)                                     
#define HRTIM_BDMUPR_MDIER_Msk        (0x1U << HRTIM_BDMUPR_MDIER_Pos)         /*!< 0x00000004 */
#define HRTIM_BDMUPR_MDIER            HRTIM_BDMUPR_MDIER_Msk                   /*!< MDIER register update enable */ 
#define HRTIM_BDMUPR_MCNT_Pos         (3U)                                     
#define HRTIM_BDMUPR_MCNT_Msk         (0x1U << HRTIM_BDMUPR_MCNT_Pos)          /*!< 0x00000008 */
#define HRTIM_BDMUPR_MCNT             HRTIM_BDMUPR_MCNT_Msk                    /*!< MCNT register update enable */ 
#define HRTIM_BDMUPR_MPER_Pos         (4U)                                     
#define HRTIM_BDMUPR_MPER_Msk         (0x1U << HRTIM_BDMUPR_MPER_Pos)          /*!< 0x00000010 */
#define HRTIM_BDMUPR_MPER             HRTIM_BDMUPR_MPER_Msk                    /*!< MPER register update enable */ 
#define HRTIM_BDMUPR_MREP_Pos         (5U)                                     
#define HRTIM_BDMUPR_MREP_Msk         (0x1U << HRTIM_BDMUPR_MREP_Pos)          /*!< 0x00000020 */
#define HRTIM_BDMUPR_MREP             HRTIM_BDMUPR_MREP_Msk                    /*!< MREP register update enable */ 
#define HRTIM_BDMUPR_MCMP1_Pos        (6U)                                     
#define HRTIM_BDMUPR_MCMP1_Msk        (0x1U << HRTIM_BDMUPR_MCMP1_Pos)         /*!< 0x00000040 */
#define HRTIM_BDMUPR_MCMP1            HRTIM_BDMUPR_MCMP1_Msk                   /*!< MCMP1 register update enable */ 
#define HRTIM_BDMUPR_MCMP2_Pos        (7U)                                     
#define HRTIM_BDMUPR_MCMP2_Msk        (0x1U << HRTIM_BDMUPR_MCMP2_Pos)         /*!< 0x00000080 */
#define HRTIM_BDMUPR_MCMP2            HRTIM_BDMUPR_MCMP2_Msk                   /*!< MCMP2 register update enable */ 
#define HRTIM_BDMUPR_MCMP3_Pos        (8U)                                     
#define HRTIM_BDMUPR_MCMP3_Msk        (0x1U << HRTIM_BDMUPR_MCMP3_Pos)         /*!< 0x00000100 */
#define HRTIM_BDMUPR_MCMP3            HRTIM_BDMUPR_MCMP3_Msk                   /*!< MCMP3 register update enable */ 
#define HRTIM_BDMUPR_MCMP4_Pos        (9U)                                     
#define HRTIM_BDMUPR_MCMP4_Msk        (0x1U << HRTIM_BDMUPR_MCMP4_Pos)         /*!< 0x00000200 */
#define HRTIM_BDMUPR_MCMP4            HRTIM_BDMUPR_MCMP4_Msk                   /*!< MPCMP4 register update enable */ 

/*******************  Bit definition for HRTIM_BDTUPR register  ***************/  
#define HRTIM_BDTUPR_TIMCR_Pos        (0U)                                     
#define HRTIM_BDTUPR_TIMCR_Msk        (0x1U << HRTIM_BDTUPR_TIMCR_Pos)         /*!< 0x00000001 */
#define HRTIM_BDTUPR_TIMCR            HRTIM_BDTUPR_TIMCR_Msk                   /*!<  TIMCR register update enable */ 
#define HRTIM_BDTUPR_TIMICR_Pos       (1U)                                     
#define HRTIM_BDTUPR_TIMICR_Msk       (0x1U << HRTIM_BDTUPR_TIMICR_Pos)        /*!< 0x00000002 */
#define HRTIM_BDTUPR_TIMICR           HRTIM_BDTUPR_TIMICR_Msk                  /*!<  TIMICR register update enable */ 
#define HRTIM_BDTUPR_TIMDIER_Pos      (2U)                                     
#define HRTIM_BDTUPR_TIMDIER_Msk      (0x1U << HRTIM_BDTUPR_TIMDIER_Pos)       /*!< 0x00000004 */
#define HRTIM_BDTUPR_TIMDIER          HRTIM_BDTUPR_TIMDIER_Msk                 /*!<  TIMDIER register update enable */ 
#define HRTIM_BDTUPR_TIMCNT_Pos       (3U)                                     
#define HRTIM_BDTUPR_TIMCNT_Msk       (0x1U << HRTIM_BDTUPR_TIMCNT_Pos)        /*!< 0x00000008 */
#define HRTIM_BDTUPR_TIMCNT           HRTIM_BDTUPR_TIMCNT_Msk                  /*!<  TIMCNT register update enable */ 
#define HRTIM_BDTUPR_TIMPER_Pos       (4U)                                     
#define HRTIM_BDTUPR_TIMPER_Msk       (0x1U << HRTIM_BDTUPR_TIMPER_Pos)        /*!< 0x00000010 */
#define HRTIM_BDTUPR_TIMPER           HRTIM_BDTUPR_TIMPER_Msk                  /*!<  TIMPER register update enable */ 
#define HRTIM_BDTUPR_TIMREP_Pos       (5U)                                     
#define HRTIM_BDTUPR_TIMREP_Msk       (0x1U << HRTIM_BDTUPR_TIMREP_Pos)        /*!< 0x00000020 */
#define HRTIM_BDTUPR_TIMREP           HRTIM_BDTUPR_TIMREP_Msk                  /*!<  TIMREP register update enable */ 
#define HRTIM_BDTUPR_TIMCMP1_Pos      (6U)                                     
#define HRTIM_BDTUPR_TIMCMP1_Msk      (0x1U << HRTIM_BDTUPR_TIMCMP1_Pos)       /*!< 0x00000040 */
#define HRTIM_BDTUPR_TIMCMP1          HRTIM_BDTUPR_TIMCMP1_Msk                 /*!<  TIMCMP1 register update enable */ 
#define HRTIM_BDTUPR_TIMCMP2_Pos      (7U)                                     
#define HRTIM_BDTUPR_TIMCMP2_Msk      (0x1U << HRTIM_BDTUPR_TIMCMP2_Pos)       /*!< 0x00000080 */
#define HRTIM_BDTUPR_TIMCMP2          HRTIM_BDTUPR_TIMCMP2_Msk                 /*!<  TIMCMP2 register update enable */ 
#define HRTIM_BDTUPR_TIMCMP3_Pos      (8U)                                     
#define HRTIM_BDTUPR_TIMCMP3_Msk      (0x1U << HRTIM_BDTUPR_TIMCMP3_Pos)       /*!< 0x00000100 */
#define HRTIM_BDTUPR_TIMCMP3          HRTIM_BDTUPR_TIMCMP3_Msk                 /*!<  TIMCMP3 register update enable */ 
#define HRTIM_BDTUPR_TIMCMP4_Pos      (9U)                                     
#define HRTIM_BDTUPR_TIMCMP4_Msk      (0x1U << HRTIM_BDTUPR_TIMCMP4_Pos)       /*!< 0x00000200 */
#define HRTIM_BDTUPR_TIMCMP4          HRTIM_BDTUPR_TIMCMP4_Msk                 /*!<  TIMCMP4 register update enable */ 
#define HRTIM_BDTUPR_TIMDTR_Pos       (10U)                                    
#define HRTIM_BDTUPR_TIMDTR_Msk       (0x1U << HRTIM_BDTUPR_TIMDTR_Pos)        /*!< 0x00000400 */
#define HRTIM_BDTUPR_TIMDTR           HRTIM_BDTUPR_TIMDTR_Msk                  /*!<  TIMDTR register update enable */ 
#define HRTIM_BDTUPR_TIMSET1R_Pos     (11U)                                    
#define HRTIM_BDTUPR_TIMSET1R_Msk     (0x1U << HRTIM_BDTUPR_TIMSET1R_Pos)      /*!< 0x00000800 */
#define HRTIM_BDTUPR_TIMSET1R         HRTIM_BDTUPR_TIMSET1R_Msk                /*!<  TIMSET1R register update enable */ 
#define HRTIM_BDTUPR_TIMRST1R_Pos     (12U)                                    
#define HRTIM_BDTUPR_TIMRST1R_Msk     (0x1U << HRTIM_BDTUPR_TIMRST1R_Pos)      /*!< 0x00001000 */
#define HRTIM_BDTUPR_TIMRST1R         HRTIM_BDTUPR_TIMRST1R_Msk                /*!<  TIMRST1R register update enable */ 
#define HRTIM_BDTUPR_TIMSET2R_Pos     (13U)                                    
#define HRTIM_BDTUPR_TIMSET2R_Msk     (0x1U << HRTIM_BDTUPR_TIMSET2R_Pos)      /*!< 0x00002000 */
#define HRTIM_BDTUPR_TIMSET2R         HRTIM_BDTUPR_TIMSET2R_Msk                /*!<  TIMSET2R register update enable */ 
#define HRTIM_BDTUPR_TIMRST2R_Pos     (14U)                                    
#define HRTIM_BDTUPR_TIMRST2R_Msk     (0x1U << HRTIM_BDTUPR_TIMRST2R_Pos)      /*!< 0x00004000 */
#define HRTIM_BDTUPR_TIMRST2R         HRTIM_BDTUPR_TIMRST2R_Msk                /*!<  TIMRST2R register update enable */ 
#define HRTIM_BDTUPR_TIMEEFR1_Pos     (15U)                                    
#define HRTIM_BDTUPR_TIMEEFR1_Msk     (0x1U << HRTIM_BDTUPR_TIMEEFR1_Pos)      /*!< 0x00008000 */
#define HRTIM_BDTUPR_TIMEEFR1         HRTIM_BDTUPR_TIMEEFR1_Msk                /*!<  TIMEEFR1 register update enable */ 
#define HRTIM_BDTUPR_TIMEEFR2_Pos     (16U)                                    
#define HRTIM_BDTUPR_TIMEEFR2_Msk     (0x1U << HRTIM_BDTUPR_TIMEEFR2_Pos)      /*!< 0x00010000 */
#define HRTIM_BDTUPR_TIMEEFR2         HRTIM_BDTUPR_TIMEEFR2_Msk                /*!<  TIMEEFR2 register update enable */ 
#define HRTIM_BDTUPR_TIMRSTR_Pos      (17U)                                    
#define HRTIM_BDTUPR_TIMRSTR_Msk      (0x1U << HRTIM_BDTUPR_TIMRSTR_Pos)       /*!< 0x00020000 */
#define HRTIM_BDTUPR_TIMRSTR          HRTIM_BDTUPR_TIMRSTR_Msk                 /*!<  TIMRSTR register update enable */ 
#define HRTIM_BDTUPR_TIMCHPR_Pos      (18U)                                    
#define HRTIM_BDTUPR_TIMCHPR_Msk      (0x1U << HRTIM_BDTUPR_TIMCHPR_Pos)       /*!< 0x00040000 */
#define HRTIM_BDTUPR_TIMCHPR          HRTIM_BDTUPR_TIMCHPR_Msk                 /*!<  TIMCHPR register update enable */ 
#define HRTIM_BDTUPR_TIMOUTR_Pos      (19U)                                    
#define HRTIM_BDTUPR_TIMOUTR_Msk      (0x1U << HRTIM_BDTUPR_TIMOUTR_Pos)       /*!< 0x00080000 */
#define HRTIM_BDTUPR_TIMOUTR          HRTIM_BDTUPR_TIMOUTR_Msk                 /*!<  TIMOUTR register update enable */ 
#define HRTIM_BDTUPR_TIMFLTR_Pos      (20U)                                    
#define HRTIM_BDTUPR_TIMFLTR_Msk      (0x1U << HRTIM_BDTUPR_TIMFLTR_Pos)       /*!< 0x00100000 */
#define HRTIM_BDTUPR_TIMFLTR          HRTIM_BDTUPR_TIMFLTR_Msk                 /*!<  TIMFLTR register update enable */ 

/*******************  Bit definition for HRTIM_BDMADR register  ***************/  
#define HRTIM_BDMADR_BDMADR_Pos       (0U)                                     
#define HRTIM_BDMADR_BDMADR_Msk       (0xFFFFFFFFU << HRTIM_BDMADR_BDMADR_Pos) /*!< 0xFFFFFFFF */
#define HRTIM_BDMADR_BDMADR           HRTIM_BDMADR_BDMADR_Msk                  /*!<  Burst DMA Data register */ 

/******************************************************************************/
/*                                                                            */
/*                      Inter-integrated Circuit Interface (I2C)              */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for I2C_CR1 register  *******************/
#define I2C_CR1_PE_Pos               (0U)                                      
#define I2C_CR1_PE_Msk               (0x1U << I2C_CR1_PE_Pos)                  /*!< 0x00000001 */
#define I2C_CR1_PE                   I2C_CR1_PE_Msk                            /*!< Peripheral enable */
#define I2C_CR1_TXIE_Pos             (1U)                                      
#define I2C_CR1_TXIE_Msk             (0x1U << I2C_CR1_TXIE_Pos)                /*!< 0x00000002 */
#define I2C_CR1_TXIE                 I2C_CR1_TXIE_Msk                          /*!< TX interrupt enable */
#define I2C_CR1_RXIE_Pos             (2U)                                      
#define I2C_CR1_RXIE_Msk             (0x1U << I2C_CR1_RXIE_Pos)                /*!< 0x00000004 */
#define I2C_CR1_RXIE                 I2C_CR1_RXIE_Msk                          /*!< RX interrupt enable */
#define I2C_CR1_ADDRIE_Pos           (3U)                                      
#define I2C_CR1_ADDRIE_Msk           (0x1U << I2C_CR1_ADDRIE_Pos)              /*!< 0x00000008 */
#define I2C_CR1_ADDRIE               I2C_CR1_ADDRIE_Msk                        /*!< Address match interrupt enable */
#define I2C_CR1_NACKIE_Pos           (4U)                                      
#define I2C_CR1_NACKIE_Msk           (0x1U << I2C_CR1_NACKIE_Pos)              /*!< 0x00000010 */
#define I2C_CR1_NACKIE               I2C_CR1_NACKIE_Msk                        /*!< NACK received interrupt enable */
#define I2C_CR1_STOPIE_Pos           (5U)                                      
#define I2C_CR1_STOPIE_Msk           (0x1U << I2C_CR1_STOPIE_Pos)              /*!< 0x00000020 */
#define I2C_CR1_STOPIE               I2C_CR1_STOPIE_Msk                        /*!< STOP detection interrupt enable */
#define I2C_CR1_TCIE_Pos             (6U)                                      
#define I2C_CR1_TCIE_Msk             (0x1U << I2C_CR1_TCIE_Pos)                /*!< 0x00000040 */
#define I2C_CR1_TCIE                 I2C_CR1_TCIE_Msk                          /*!< Transfer complete interrupt enable */
#define I2C_CR1_ERRIE_Pos            (7U)                                      
#define I2C_CR1_ERRIE_Msk            (0x1U << I2C_CR1_ERRIE_Pos)               /*!< 0x00000080 */
#define I2C_CR1_ERRIE                I2C_CR1_ERRIE_Msk                         /*!< Errors interrupt enable */
#define I2C_CR1_DNF_Pos              (8U)                                      
#define I2C_CR1_DNF_Msk              (0xFU << I2C_CR1_DNF_Pos)                 /*!< 0x00000F00 */
#define I2C_CR1_DNF                  I2C_CR1_DNF_Msk                           /*!< Digital noise filter */
#define I2C_CR1_ANFOFF_Pos           (12U)                                     
#define I2C_CR1_ANFOFF_Msk           (0x1U << I2C_CR1_ANFOFF_Pos)              /*!< 0x00001000 */
#define I2C_CR1_ANFOFF               I2C_CR1_ANFOFF_Msk                        /*!< Analog noise filter OFF */
#define I2C_CR1_SWRST_Pos            (13U)                                     
#define I2C_CR1_SWRST_Msk            (0x1U << I2C_CR1_SWRST_Pos)               /*!< 0x00002000 */
#define I2C_CR1_SWRST                I2C_CR1_SWRST_Msk                         /*!< Software reset */
#define I2C_CR1_TXDMAEN_Pos          (14U)                                     
#define I2C_CR1_TXDMAEN_Msk          (0x1U << I2C_CR1_TXDMAEN_Pos)             /*!< 0x00004000 */
#define I2C_CR1_TXDMAEN              I2C_CR1_TXDMAEN_Msk                       /*!< DMA transmission requests enable */
#define I2C_CR1_RXDMAEN_Pos          (15U)                                     
#define I2C_CR1_RXDMAEN_Msk          (0x1U << I2C_CR1_RXDMAEN_Pos)             /*!< 0x00008000 */
#define I2C_CR1_RXDMAEN              I2C_CR1_RXDMAEN_Msk                       /*!< DMA reception requests enable */
#define I2C_CR1_SBC_Pos              (16U)                                     
#define I2C_CR1_SBC_Msk              (0x1U << I2C_CR1_SBC_Pos)                 /*!< 0x00010000 */
#define I2C_CR1_SBC                  I2C_CR1_SBC_Msk                           /*!< Slave byte control */
#define I2C_CR1_NOSTRETCH_Pos        (17U)                                     
#define I2C_CR1_NOSTRETCH_Msk        (0x1U << I2C_CR1_NOSTRETCH_Pos)           /*!< 0x00020000 */
#define I2C_CR1_NOSTRETCH            I2C_CR1_NOSTRETCH_Msk                     /*!< Clock stretching disable */
#define I2C_CR1_WUPEN_Pos            (18U)                                     
#define I2C_CR1_WUPEN_Msk            (0x1U << I2C_CR1_WUPEN_Pos)               /*!< 0x00040000 */
#define I2C_CR1_WUPEN                I2C_CR1_WUPEN_Msk                         /*!< Wakeup from STOP enable */
#define I2C_CR1_GCEN_Pos             (19U)                                     
#define I2C_CR1_GCEN_Msk             (0x1U << I2C_CR1_GCEN_Pos)                /*!< 0x00080000 */
#define I2C_CR1_GCEN                 I2C_CR1_GCEN_Msk                          /*!< General call enable */
#define I2C_CR1_SMBHEN_Pos           (20U)                                     
#define I2C_CR1_SMBHEN_Msk           (0x1U << I2C_CR1_SMBHEN_Pos)              /*!< 0x00100000 */
#define I2C_CR1_SMBHEN               I2C_CR1_SMBHEN_Msk                        /*!< SMBus host address enable */
#define I2C_CR1_SMBDEN_Pos           (21U)                                     
#define I2C_CR1_SMBDEN_Msk           (0x1U << I2C_CR1_SMBDEN_Pos)              /*!< 0x00200000 */
#define I2C_CR1_SMBDEN               I2C_CR1_SMBDEN_Msk                        /*!< SMBus device default address enable */
#define I2C_CR1_ALERTEN_Pos          (22U)                                     
#define I2C_CR1_ALERTEN_Msk          (0x1U << I2C_CR1_ALERTEN_Pos)             /*!< 0x00400000 */
#define I2C_CR1_ALERTEN              I2C_CR1_ALERTEN_Msk                       /*!< SMBus alert enable */
#define I2C_CR1_PECEN_Pos            (23U)                                     
#define I2C_CR1_PECEN_Msk            (0x1U << I2C_CR1_PECEN_Pos)               /*!< 0x00800000 */
#define I2C_CR1_PECEN                I2C_CR1_PECEN_Msk                         /*!< PEC enable */

/* Legacy defines */
#define I2C_CR1_DFN I2C_CR1_DNF

/******************  Bit definition for I2C_CR2 register  ********************/
#define I2C_CR2_SADD_Pos             (0U)                                      
#define I2C_CR2_SADD_Msk             (0x3FFU << I2C_CR2_SADD_Pos)              /*!< 0x000003FF */
#define I2C_CR2_SADD                 I2C_CR2_SADD_Msk                          /*!< Slave address (master mode) */
#define I2C_CR2_RD_WRN_Pos           (10U)                                     
#define I2C_CR2_RD_WRN_Msk           (0x1U << I2C_CR2_RD_WRN_Pos)              /*!< 0x00000400 */
#define I2C_CR2_RD_WRN               I2C_CR2_RD_WRN_Msk                        /*!< Transfer direction (master mode) */
#define I2C_CR2_ADD10_Pos            (11U)                                     
#define I2C_CR2_ADD10_Msk            (0x1U << I2C_CR2_ADD10_Pos)               /*!< 0x00000800 */
#define I2C_CR2_ADD10                I2C_CR2_ADD10_Msk                         /*!< 10-bit addressing mode (master mode) */
#define I2C_CR2_HEAD10R_Pos          (12U)                                     
#define I2C_CR2_HEAD10R_Msk          (0x1U << I2C_CR2_HEAD10R_Pos)             /*!< 0x00001000 */
#define I2C_CR2_HEAD10R              I2C_CR2_HEAD10R_Msk                       /*!< 10-bit address header only read direction (master mode) */
#define I2C_CR2_START_Pos            (13U)                                     
#define I2C_CR2_START_Msk            (0x1U << I2C_CR2_START_Pos)               /*!< 0x00002000 */
#define I2C_CR2_START                I2C_CR2_START_Msk                         /*!< START generation */
#define I2C_CR2_STOP_Pos             (14U)                                     
#define I2C_CR2_STOP_Msk             (0x1U << I2C_CR2_STOP_Pos)                /*!< 0x00004000 */
#define I2C_CR2_STOP                 I2C_CR2_STOP_Msk                          /*!< STOP generation (master mode) */
#define I2C_CR2_NACK_Pos             (15U)                                     
#define I2C_CR2_NACK_Msk             (0x1U << I2C_CR2_NACK_Pos)                /*!< 0x00008000 */
#define I2C_CR2_NACK                 I2C_CR2_NACK_Msk                          /*!< NACK generation (slave mode) */
#define I2C_CR2_NBYTES_Pos           (16U)                                     
#define I2C_CR2_NBYTES_Msk           (0xFFU << I2C_CR2_NBYTES_Pos)             /*!< 0x00FF0000 */
#define I2C_CR2_NBYTES               I2C_CR2_NBYTES_Msk                        /*!< Number of bytes */
#define I2C_CR2_RELOAD_Pos           (24U)                                     
#define I2C_CR2_RELOAD_Msk           (0x1U << I2C_CR2_RELOAD_Pos)              /*!< 0x01000000 */
#define I2C_CR2_RELOAD               I2C_CR2_RELOAD_Msk                        /*!< NBYTES reload mode */
#define I2C_CR2_AUTOEND_Pos          (25U)                                     
#define I2C_CR2_AUTOEND_Msk          (0x1U << I2C_CR2_AUTOEND_Pos)             /*!< 0x02000000 */
#define I2C_CR2_AUTOEND              I2C_CR2_AUTOEND_Msk                       /*!< Automatic end mode (master mode) */
#define I2C_CR2_PECBYTE_Pos          (26U)                                     
#define I2C_CR2_PECBYTE_Msk          (0x1U << I2C_CR2_PECBYTE_Pos)             /*!< 0x04000000 */
#define I2C_CR2_PECBYTE              I2C_CR2_PECBYTE_Msk                       /*!< Packet error checking byte */

/*******************  Bit definition for I2C_OAR1 register  ******************/
#define I2C_OAR1_OA1_Pos             (0U)                                      
#define I2C_OAR1_OA1_Msk             (0x3FFU << I2C_OAR1_OA1_Pos)              /*!< 0x000003FF */
#define I2C_OAR1_OA1                 I2C_OAR1_OA1_Msk                          /*!< Interface own address 1 */
#define I2C_OAR1_OA1MODE_Pos         (10U)                                     
#define I2C_OAR1_OA1MODE_Msk         (0x1U << I2C_OAR1_OA1MODE_Pos)            /*!< 0x00000400 */
#define I2C_OAR1_OA1MODE             I2C_OAR1_OA1MODE_Msk                      /*!< Own address 1 10-bit mode */
#define I2C_OAR1_OA1EN_Pos           (15U)                                     
#define I2C_OAR1_OA1EN_Msk           (0x1U << I2C_OAR1_OA1EN_Pos)              /*!< 0x00008000 */
#define I2C_OAR1_OA1EN               I2C_OAR1_OA1EN_Msk                        /*!< Own address 1 enable */

/*******************  Bit definition for I2C_OAR2 register  *******************/
#define I2C_OAR2_OA2_Pos             (1U)                                      
#define I2C_OAR2_OA2_Msk             (0x7FU << I2C_OAR2_OA2_Pos)               /*!< 0x000000FE */
#define I2C_OAR2_OA2                 I2C_OAR2_OA2_Msk                          /*!< Interface own address 2                        */
#define I2C_OAR2_OA2MSK_Pos          (8U)                                      
#define I2C_OAR2_OA2MSK_Msk          (0x7U << I2C_OAR2_OA2MSK_Pos)             /*!< 0x00000700 */
#define I2C_OAR2_OA2MSK              I2C_OAR2_OA2MSK_Msk                       /*!< Own address 2 masks                            */
#define I2C_OAR2_OA2NOMASK           (0x00000000U)                             /*!< No mask                                        */
#define I2C_OAR2_OA2MASK01_Pos       (8U)                                      
#define I2C_OAR2_OA2MASK01_Msk       (0x1U << I2C_OAR2_OA2MASK01_Pos)          /*!< 0x00000100 */
#define I2C_OAR2_OA2MASK01           I2C_OAR2_OA2MASK01_Msk                    /*!< OA2[1] is masked, Only OA2[7:2] are compared   */
#define I2C_OAR2_OA2MASK02_Pos       (9U)                                      
#define I2C_OAR2_OA2MASK02_Msk       (0x1U << I2C_OAR2_OA2MASK02_Pos)          /*!< 0x00000200 */
#define I2C_OAR2_OA2MASK02           I2C_OAR2_OA2MASK02_Msk                    /*!< OA2[2:1] is masked, Only OA2[7:3] are compared */
#define I2C_OAR2_OA2MASK03_Pos       (8U)                                      
#define I2C_OAR2_OA2MASK03_Msk       (0x3U << I2C_OAR2_OA2MASK03_Pos)          /*!< 0x00000300 */
#define I2C_OAR2_OA2MASK03           I2C_OAR2_OA2MASK03_Msk                    /*!< OA2[3:1] is masked, Only OA2[7:4] are compared */
#define I2C_OAR2_OA2MASK04_Pos       (10U)                                     
#define I2C_OAR2_OA2MASK04_Msk       (0x1U << I2C_OAR2_OA2MASK04_Pos)          /*!< 0x00000400 */
#define I2C_OAR2_OA2MASK04           I2C_OAR2_OA2MASK04_Msk                    /*!< OA2[4:1] is masked, Only OA2[7:5] are compared */
#define I2C_OAR2_OA2MASK05_Pos       (8U)                                      
#define I2C_OAR2_OA2MASK05_Msk       (0x5U << I2C_OAR2_OA2MASK05_Pos)          /*!< 0x00000500 */
#define I2C_OAR2_OA2MASK05           I2C_OAR2_OA2MASK05_Msk                    /*!< OA2[5:1] is masked, Only OA2[7:6] are compared */
#define I2C_OAR2_OA2MASK06_Pos       (9U)                                      
#define I2C_OAR2_OA2MASK06_Msk       (0x3U << I2C_OAR2_OA2MASK06_Pos)          /*!< 0x00000600 */
#define I2C_OAR2_OA2MASK06           I2C_OAR2_OA2MASK06_Msk                    /*!< OA2[6:1] is masked, Only OA2[7] are compared   */
#define I2C_OAR2_OA2MASK07_Pos       (8U)                                      
#define I2C_OAR2_OA2MASK07_Msk       (0x7U << I2C_OAR2_OA2MASK07_Pos)          /*!< 0x00000700 */
#define I2C_OAR2_OA2MASK07           I2C_OAR2_OA2MASK07_Msk                    /*!< OA2[7:1] is masked, No comparison is done      */
#define I2C_OAR2_OA2EN_Pos           (15U)                                     
#define I2C_OAR2_OA2EN_Msk           (0x1U << I2C_OAR2_OA2EN_Pos)              /*!< 0x00008000 */
#define I2C_OAR2_OA2EN               I2C_OAR2_OA2EN_Msk                        /*!< Own address 2 enable                           */

/*******************  Bit definition for I2C_TIMINGR register *****************/
#define I2C_TIMINGR_SCLL_Pos         (0U)                                      
#define I2C_TIMINGR_SCLL_Msk         (0xFFU << I2C_TIMINGR_SCLL_Pos)           /*!< 0x000000FF */
#define I2C_TIMINGR_SCLL             I2C_TIMINGR_SCLL_Msk                      /*!< SCL low period (master mode) */
#define I2C_TIMINGR_SCLH_Pos         (8U)                                      
#define I2C_TIMINGR_SCLH_Msk         (0xFFU << I2C_TIMINGR_SCLH_Pos)           /*!< 0x0000FF00 */
#define I2C_TIMINGR_SCLH             I2C_TIMINGR_SCLH_Msk                      /*!< SCL high period (master mode) */
#define I2C_TIMINGR_SDADEL_Pos       (16U)                                     
#define I2C_TIMINGR_SDADEL_Msk       (0xFU << I2C_TIMINGR_SDADEL_Pos)          /*!< 0x000F0000 */
#define I2C_TIMINGR_SDADEL           I2C_TIMINGR_SDADEL_Msk                    /*!< Data hold time */
#define I2C_TIMINGR_SCLDEL_Pos       (20U)                                     
#define I2C_TIMINGR_SCLDEL_Msk       (0xFU << I2C_TIMINGR_SCLDEL_Pos)          /*!< 0x00F00000 */
#define I2C_TIMINGR_SCLDEL           I2C_TIMINGR_SCLDEL_Msk                    /*!< Data setup time */
#define I2C_TIMINGR_PRESC_Pos        (28U)                                     
#define I2C_TIMINGR_PRESC_Msk        (0xFU << I2C_TIMINGR_PRESC_Pos)           /*!< 0xF0000000 */
#define I2C_TIMINGR_PRESC            I2C_TIMINGR_PRESC_Msk                     /*!< Timings prescaler */

/******************* Bit definition for I2C_TIMEOUTR register *****************/
#define I2C_TIMEOUTR_TIMEOUTA_Pos    (0U)                                      
#define I2C_TIMEOUTR_TIMEOUTA_Msk    (0xFFFU << I2C_TIMEOUTR_TIMEOUTA_Pos)     /*!< 0x00000FFF */
#define I2C_TIMEOUTR_TIMEOUTA        I2C_TIMEOUTR_TIMEOUTA_Msk                 /*!< Bus timeout A */
#define I2C_TIMEOUTR_TIDLE_Pos       (12U)                                     
#define I2C_TIMEOUTR_TIDLE_Msk       (0x1U << I2C_TIMEOUTR_TIDLE_Pos)          /*!< 0x00001000 */
#define I2C_TIMEOUTR_TIDLE           I2C_TIMEOUTR_TIDLE_Msk                    /*!< Idle clock timeout detection */
#define I2C_TIMEOUTR_TIMOUTEN_Pos    (15U)                                     
#define I2C_TIMEOUTR_TIMOUTEN_Msk    (0x1U << I2C_TIMEOUTR_TIMOUTEN_Pos)       /*!< 0x00008000 */
#define I2C_TIMEOUTR_TIMOUTEN        I2C_TIMEOUTR_TIMOUTEN_Msk                 /*!< Clock timeout enable */
#define I2C_TIMEOUTR_TIMEOUTB_Pos    (16U)                                     
#define I2C_TIMEOUTR_TIMEOUTB_Msk    (0xFFFU << I2C_TIMEOUTR_TIMEOUTB_Pos)     /*!< 0x0FFF0000 */
#define I2C_TIMEOUTR_TIMEOUTB        I2C_TIMEOUTR_TIMEOUTB_Msk                 /*!< Bus timeout B*/
#define I2C_TIMEOUTR_TEXTEN_Pos      (31U)                                     
#define I2C_TIMEOUTR_TEXTEN_Msk      (0x1U << I2C_TIMEOUTR_TEXTEN_Pos)         /*!< 0x80000000 */
#define I2C_TIMEOUTR_TEXTEN          I2C_TIMEOUTR_TEXTEN_Msk                   /*!< Extended clock timeout enable */

/******************  Bit definition for I2C_ISR register  *********************/
#define I2C_ISR_TXE_Pos              (0U)                                      
#define I2C_ISR_TXE_Msk              (0x1U << I2C_ISR_TXE_Pos)                 /*!< 0x00000001 */
#define I2C_ISR_TXE                  I2C_ISR_TXE_Msk                           /*!< Transmit data register empty */
#define I2C_ISR_TXIS_Pos             (1U)                                      
#define I2C_ISR_TXIS_Msk             (0x1U << I2C_ISR_TXIS_Pos)                /*!< 0x00000002 */
#define I2C_ISR_TXIS                 I2C_ISR_TXIS_Msk                          /*!< Transmit interrupt status */
#define I2C_ISR_RXNE_Pos             (2U)                                      
#define I2C_ISR_RXNE_Msk             (0x1U << I2C_ISR_RXNE_Pos)                /*!< 0x00000004 */
#define I2C_ISR_RXNE                 I2C_ISR_RXNE_Msk                          /*!< Receive data register not empty */
#define I2C_ISR_ADDR_Pos             (3U)                                      
#define I2C_ISR_ADDR_Msk             (0x1U << I2C_ISR_ADDR_Pos)                /*!< 0x00000008 */
#define I2C_ISR_ADDR                 I2C_ISR_ADDR_Msk                          /*!< Address matched (slave mode)*/
#define I2C_ISR_NACKF_Pos            (4U)                                      
#define I2C_ISR_NACKF_Msk            (0x1U << I2C_ISR_NACKF_Pos)               /*!< 0x00000010 */
#define I2C_ISR_NACKF                I2C_ISR_NACKF_Msk                         /*!< NACK received flag */
#define I2C_ISR_STOPF_Pos            (5U)                                      
#define I2C_ISR_STOPF_Msk            (0x1U << I2C_ISR_STOPF_Pos)               /*!< 0x00000020 */
#define I2C_ISR_STOPF                I2C_ISR_STOPF_Msk                         /*!< STOP detection flag */
#define I2C_ISR_TC_Pos               (6U)                                      
#define I2C_ISR_TC_Msk               (0x1U << I2C_ISR_TC_Pos)                  /*!< 0x00000040 */
#define I2C_ISR_TC                   I2C_ISR_TC_Msk                            /*!< Transfer complete (master mode) */
#define I2C_ISR_TCR_Pos              (7U)                                      
#define I2C_ISR_TCR_Msk              (0x1U << I2C_ISR_TCR_Pos)                 /*!< 0x00000080 */
#define I2C_ISR_TCR                  I2C_ISR_TCR_Msk                           /*!< Transfer complete reload */
#define I2C_ISR_BERR_Pos             (8U)                                      
#define I2C_ISR_BERR_Msk             (0x1U << I2C_ISR_BERR_Pos)                /*!< 0x00000100 */
#define I2C_ISR_BERR                 I2C_ISR_BERR_Msk                          /*!< Bus error */
#define I2C_ISR_ARLO_Pos             (9U)                                      
#define I2C_ISR_ARLO_Msk             (0x1U << I2C_ISR_ARLO_Pos)                /*!< 0x00000200 */
#define I2C_ISR_ARLO                 I2C_ISR_ARLO_Msk                          /*!< Arbitration lost */
#define I2C_ISR_OVR_Pos              (10U)                                     
#define I2C_ISR_OVR_Msk              (0x1U << I2C_ISR_OVR_Pos)                 /*!< 0x00000400 */
#define I2C_ISR_OVR                  I2C_ISR_OVR_Msk                           /*!< Overrun/Underrun */
#define I2C_ISR_PECERR_Pos           (11U)                                     
#define I2C_ISR_PECERR_Msk           (0x1U << I2C_ISR_PECERR_Pos)              /*!< 0x00000800 */
#define I2C_ISR_PECERR               I2C_ISR_PECERR_Msk                        /*!< PEC error in reception */
#define I2C_ISR_TIMEOUT_Pos          (12U)                                     
#define I2C_ISR_TIMEOUT_Msk          (0x1U << I2C_ISR_TIMEOUT_Pos)             /*!< 0x00001000 */
#define I2C_ISR_TIMEOUT              I2C_ISR_TIMEOUT_Msk                       /*!< Timeout or Tlow detection flag */
#define I2C_ISR_ALERT_Pos            (13U)                                     
#define I2C_ISR_ALERT_Msk            (0x1U << I2C_ISR_ALERT_Pos)               /*!< 0x00002000 */
#define I2C_ISR_ALERT                I2C_ISR_ALERT_Msk                         /*!< SMBus alert */
#define I2C_ISR_BUSY_Pos             (15U)                                     
#define I2C_ISR_BUSY_Msk             (0x1U << I2C_ISR_BUSY_Pos)                /*!< 0x00008000 */
#define I2C_ISR_BUSY                 I2C_ISR_BUSY_Msk                          /*!< Bus busy */
#define I2C_ISR_DIR_Pos              (16U)                                     
#define I2C_ISR_DIR_Msk              (0x1U << I2C_ISR_DIR_Pos)                 /*!< 0x00010000 */
#define I2C_ISR_DIR                  I2C_ISR_DIR_Msk                           /*!< Transfer direction (slave mode) */
#define I2C_ISR_ADDCODE_Pos          (17U)                                     
#define I2C_ISR_ADDCODE_Msk          (0x7FU << I2C_ISR_ADDCODE_Pos)            /*!< 0x00FE0000 */
#define I2C_ISR_ADDCODE              I2C_ISR_ADDCODE_Msk                       /*!< Address match code (slave mode) */

/******************  Bit definition for I2C_ICR register  *********************/
#define I2C_ICR_ADDRCF_Pos           (3U)                                      
#define I2C_ICR_ADDRCF_Msk           (0x1U << I2C_ICR_ADDRCF_Pos)              /*!< 0x00000008 */
#define I2C_ICR_ADDRCF               I2C_ICR_ADDRCF_Msk                        /*!< Address matched clear flag */
#define I2C_ICR_NACKCF_Pos           (4U)                                      
#define I2C_ICR_NACKCF_Msk           (0x1U << I2C_ICR_NACKCF_Pos)              /*!< 0x00000010 */
#define I2C_ICR_NACKCF               I2C_ICR_NACKCF_Msk                        /*!< NACK clear flag */
#define I2C_ICR_STOPCF_Pos           (5U)                                      
#define I2C_ICR_STOPCF_Msk           (0x1U << I2C_ICR_STOPCF_Pos)              /*!< 0x00000020 */
#define I2C_ICR_STOPCF               I2C_ICR_STOPCF_Msk                        /*!< STOP detection clear flag */
#define I2C_ICR_BERRCF_Pos           (8U)                                      
#define I2C_ICR_BERRCF_Msk           (0x1U << I2C_ICR_BERRCF_Pos)              /*!< 0x00000100 */
#define I2C_ICR_BERRCF               I2C_ICR_BERRCF_Msk                        /*!< Bus error clear flag */
#define I2C_ICR_ARLOCF_Pos           (9U)                                      
#define I2C_ICR_ARLOCF_Msk           (0x1U << I2C_ICR_ARLOCF_Pos)              /*!< 0x00000200 */
#define I2C_ICR_ARLOCF               I2C_ICR_ARLOCF_Msk                        /*!< Arbitration lost clear flag */
#define I2C_ICR_OVRCF_Pos            (10U)                                     
#define I2C_ICR_OVRCF_Msk            (0x1U << I2C_ICR_OVRCF_Pos)               /*!< 0x00000400 */
#define I2C_ICR_OVRCF                I2C_ICR_OVRCF_Msk                         /*!< Overrun/Underrun clear flag */
#define I2C_ICR_PECCF_Pos            (11U)                                     
#define I2C_ICR_PECCF_Msk            (0x1U << I2C_ICR_PECCF_Pos)               /*!< 0x00000800 */
#define I2C_ICR_PECCF                I2C_ICR_PECCF_Msk                         /*!< PAC error clear flag */
#define I2C_ICR_TIMOUTCF_Pos         (12U)                                     
#define I2C_ICR_TIMOUTCF_Msk         (0x1U << I2C_ICR_TIMOUTCF_Pos)            /*!< 0x00001000 */
#define I2C_ICR_TIMOUTCF             I2C_ICR_TIMOUTCF_Msk                      /*!< Timeout clear flag */
#define I2C_ICR_ALERTCF_Pos          (13U)                                     
#define I2C_ICR_ALERTCF_Msk          (0x1U << I2C_ICR_ALERTCF_Pos)             /*!< 0x00002000 */
#define I2C_ICR_ALERTCF              I2C_ICR_ALERTCF_Msk                       /*!< Alert clear flag */

/******************  Bit definition for I2C_PECR register  ********************/
#define I2C_PECR_PEC_Pos             (0U)                                      
#define I2C_PECR_PEC_Msk             (0xFFU << I2C_PECR_PEC_Pos)               /*!< 0x000000FF */
#define I2C_PECR_PEC                 I2C_PECR_PEC_Msk                          /*!< PEC register */

/******************  Bit definition for I2C_RXDR register  *********************/
#define I2C_RXDR_RXDATA_Pos          (0U)                                      
#define I2C_RXDR_RXDATA_Msk          (0xFFU << I2C_RXDR_RXDATA_Pos)            /*!< 0x000000FF */
#define I2C_RXDR_RXDATA              I2C_RXDR_RXDATA_Msk                       /*!< 8-bit receive data */

/******************  Bit definition for I2C_TXDR register  *********************/
#define I2C_TXDR_TXDATA_Pos          (0U)                                      
#define I2C_TXDR_TXDATA_Msk          (0xFFU << I2C_TXDR_TXDATA_Pos)            /*!< 0x000000FF */
#define I2C_TXDR_TXDATA              I2C_TXDR_TXDATA_Msk                       /*!< 8-bit transmit data */


/******************************************************************************/
/*                                                                            */
/*                           Independent WATCHDOG (IWDG)                      */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for IWDG_KR register  ********************/
#define IWDG_KR_KEY_Pos      (0U)                                              
#define IWDG_KR_KEY_Msk      (0xFFFFU << IWDG_KR_KEY_Pos)                      /*!< 0x0000FFFF */
#define IWDG_KR_KEY          IWDG_KR_KEY_Msk                                   /*!< Key value (write only, read 0000h) */

/*******************  Bit definition for IWDG_PR register  ********************/
#define IWDG_PR_PR_Pos       (0U)                                              
#define IWDG_PR_PR_Msk       (0x7U << IWDG_PR_PR_Pos)                          /*!< 0x00000007 */
#define IWDG_PR_PR           IWDG_PR_PR_Msk                                    /*!< PR[2:0] (Prescaler divider) */
#define IWDG_PR_PR_0         (0x1U << IWDG_PR_PR_Pos)                          /*!< 0x00000001 */
#define IWDG_PR_PR_1         (0x2U << IWDG_PR_PR_Pos)                          /*!< 0x00000002 */
#define IWDG_PR_PR_2         (0x4U << IWDG_PR_PR_Pos)                          /*!< 0x00000004 */

/*******************  Bit definition for IWDG_RLR register  *******************/
#define IWDG_RLR_RL_Pos      (0U)                                              
#define IWDG_RLR_RL_Msk      (0xFFFU << IWDG_RLR_RL_Pos)                       /*!< 0x00000FFF */
#define IWDG_RLR_RL          IWDG_RLR_RL_Msk                                   /*!< Watchdog counter reload value */

/*******************  Bit definition for IWDG_SR register  ********************/
#define IWDG_SR_PVU_Pos      (0U)                                              
#define IWDG_SR_PVU_Msk      (0x1U << IWDG_SR_PVU_Pos)                         /*!< 0x00000001 */
#define IWDG_SR_PVU          IWDG_SR_PVU_Msk                                   /*!< Watchdog prescaler value update */
#define IWDG_SR_RVU_Pos      (1U)                                              
#define IWDG_SR_RVU_Msk      (0x1U << IWDG_SR_RVU_Pos)                         /*!< 0x00000002 */
#define IWDG_SR_RVU          IWDG_SR_RVU_Msk                                   /*!< Watchdog counter reload value update */
#define IWDG_SR_WVU_Pos      (2U)                                              
#define IWDG_SR_WVU_Msk      (0x1U << IWDG_SR_WVU_Pos)                         /*!< 0x00000004 */
#define IWDG_SR_WVU          IWDG_SR_WVU_Msk                                   /*!< Watchdog counter window value update */

/*******************  Bit definition for IWDG_KR register  ********************/
#define IWDG_WINR_WIN_Pos    (0U)                                              
#define IWDG_WINR_WIN_Msk    (0xFFFU << IWDG_WINR_WIN_Pos)                     /*!< 0x00000FFF */
#define IWDG_WINR_WIN        IWDG_WINR_WIN_Msk                                 /*!< Watchdog counter window value */

/******************************************************************************/
/*                                                                            */
/*                             Power Control                                  */
/*                                                                            */
/******************************************************************************/
#define PWR_PVD_SUPPORT                       /*!< PWR feature available only on specific devices: Power Voltage Detection feature */
/********************  Bit definition for PWR_CR register  ********************/
#define PWR_CR_LPDS_Pos            (0U)                                        
#define PWR_CR_LPDS_Msk            (0x1U << PWR_CR_LPDS_Pos)                   /*!< 0x00000001 */
#define PWR_CR_LPDS                PWR_CR_LPDS_Msk                             /*!< Low-power Deepsleep */
#define PWR_CR_PDDS_Pos            (1U)                                        
#define PWR_CR_PDDS_Msk            (0x1U << PWR_CR_PDDS_Pos)                   /*!< 0x00000002 */
#define PWR_CR_PDDS                PWR_CR_PDDS_Msk                             /*!< Power Down Deepsleep */
#define PWR_CR_CWUF_Pos            (2U)                                        
#define PWR_CR_CWUF_Msk            (0x1U << PWR_CR_CWUF_Pos)                   /*!< 0x00000004 */
#define PWR_CR_CWUF                PWR_CR_CWUF_Msk                             /*!< Clear Wakeup Flag */
#define PWR_CR_CSBF_Pos            (3U)                                        
#define PWR_CR_CSBF_Msk            (0x1U << PWR_CR_CSBF_Pos)                   /*!< 0x00000008 */
#define PWR_CR_CSBF                PWR_CR_CSBF_Msk                             /*!< Clear Standby Flag */
#define PWR_CR_PVDE_Pos            (4U)                                        
#define PWR_CR_PVDE_Msk            (0x1U << PWR_CR_PVDE_Pos)                   /*!< 0x00000010 */
#define PWR_CR_PVDE                PWR_CR_PVDE_Msk                             /*!< Power Voltage Detector Enable */

#define PWR_CR_PLS_Pos             (5U)                                        
#define PWR_CR_PLS_Msk             (0x7U << PWR_CR_PLS_Pos)                    /*!< 0x000000E0 */
#define PWR_CR_PLS                 PWR_CR_PLS_Msk                              /*!< PLS[2:0] bits (PVD Level Selection) */
#define PWR_CR_PLS_0               (0x1U << PWR_CR_PLS_Pos)                    /*!< 0x00000020 */
#define PWR_CR_PLS_1               (0x2U << PWR_CR_PLS_Pos)                    /*!< 0x00000040 */
#define PWR_CR_PLS_2               (0x4U << PWR_CR_PLS_Pos)                    /*!< 0x00000080 */

/*!< PVD level configuration */
#define PWR_CR_PLS_LEV0            (0x00000000U)                               /*!< PVD level 0 */
#define PWR_CR_PLS_LEV1            (0x00000020U)                               /*!< PVD level 1 */
#define PWR_CR_PLS_LEV2            (0x00000040U)                               /*!< PVD level 2 */
#define PWR_CR_PLS_LEV3            (0x00000060U)                               /*!< PVD level 3 */
#define PWR_CR_PLS_LEV4            (0x00000080U)                               /*!< PVD level 4 */
#define PWR_CR_PLS_LEV5            (0x000000A0U)                               /*!< PVD level 5 */
#define PWR_CR_PLS_LEV6            (0x000000C0U)                               /*!< PVD level 6 */
#define PWR_CR_PLS_LEV7            (0x000000E0U)                               /*!< PVD level 7 */

#define PWR_CR_DBP_Pos             (8U)                                        
#define PWR_CR_DBP_Msk             (0x1U << PWR_CR_DBP_Pos)                    /*!< 0x00000100 */
#define PWR_CR_DBP                 PWR_CR_DBP_Msk                              /*!< Disable Backup Domain write protection */

/*******************  Bit definition for PWR_CSR register  ********************/
#define PWR_CSR_WUF_Pos            (0U)                                        
#define PWR_CSR_WUF_Msk            (0x1U << PWR_CSR_WUF_Pos)                   /*!< 0x00000001 */
#define PWR_CSR_WUF                PWR_CSR_WUF_Msk                             /*!< Wakeup Flag */
#define PWR_CSR_SBF_Pos            (1U)                                        
#define PWR_CSR_SBF_Msk            (0x1U << PWR_CSR_SBF_Pos)                   /*!< 0x00000002 */
#define PWR_CSR_SBF                PWR_CSR_SBF_Msk                             /*!< Standby Flag */
#define PWR_CSR_PVDO_Pos           (2U)                                        
#define PWR_CSR_PVDO_Msk           (0x1U << PWR_CSR_PVDO_Pos)                  /*!< 0x00000004 */
#define PWR_CSR_PVDO               PWR_CSR_PVDO_Msk                            /*!< PVD Output */

#define PWR_CSR_EWUP1_Pos          (8U)                                        
#define PWR_CSR_EWUP1_Msk          (0x1U << PWR_CSR_EWUP1_Pos)                 /*!< 0x00000100 */
#define PWR_CSR_EWUP1              PWR_CSR_EWUP1_Msk                           /*!< Enable WKUP pin 1 */
#define PWR_CSR_EWUP2_Pos          (9U)                                        
#define PWR_CSR_EWUP2_Msk          (0x1U << PWR_CSR_EWUP2_Pos)                 /*!< 0x00000200 */
#define PWR_CSR_EWUP2              PWR_CSR_EWUP2_Msk                           /*!< Enable WKUP pin 2 */
#define PWR_CSR_EWUP3_Pos          (10U)                                       
#define PWR_CSR_EWUP3_Msk          (0x1U << PWR_CSR_EWUP3_Pos)                 /*!< 0x00000400 */
#define PWR_CSR_EWUP3              PWR_CSR_EWUP3_Msk                           /*!< Enable WKUP pin 3 */

/******************************************************************************/
/*                                                                            */
/*                         Reset and Clock Control                            */
/*                                                                            */
/******************************************************************************/
/*
* @brief Specific device feature definitions  (not present on all devices in the STM32F3 serie)
*/

/********************  Bit definition for RCC_CR register  ********************/
#define RCC_CR_HSION_Pos                         (0U)                          
#define RCC_CR_HSION_Msk                         (0x1U << RCC_CR_HSION_Pos)    /*!< 0x00000001 */
#define RCC_CR_HSION                             RCC_CR_HSION_Msk              
#define RCC_CR_HSIRDY_Pos                        (1U)                          
#define RCC_CR_HSIRDY_Msk                        (0x1U << RCC_CR_HSIRDY_Pos)   /*!< 0x00000002 */
#define RCC_CR_HSIRDY                            RCC_CR_HSIRDY_Msk             

#define RCC_CR_HSITRIM_Pos                       (3U)                          
#define RCC_CR_HSITRIM_Msk                       (0x1FU << RCC_CR_HSITRIM_Pos) /*!< 0x000000F8 */
#define RCC_CR_HSITRIM                           RCC_CR_HSITRIM_Msk            
#define RCC_CR_HSITRIM_0                         (0x01U << RCC_CR_HSITRIM_Pos) /*!< 0x00000008 */
#define RCC_CR_HSITRIM_1                         (0x02U << RCC_CR_HSITRIM_Pos) /*!< 0x00000010 */
#define RCC_CR_HSITRIM_2                         (0x04U << RCC_CR_HSITRIM_Pos) /*!< 0x00000020 */
#define RCC_CR_HSITRIM_3                         (0x08U << RCC_CR_HSITRIM_Pos) /*!< 0x00000040 */
#define RCC_CR_HSITRIM_4                         (0x10U << RCC_CR_HSITRIM_Pos) /*!< 0x00000080 */

#define RCC_CR_HSICAL_Pos                        (8U)                          
#define RCC_CR_HSICAL_Msk                        (0xFFU << RCC_CR_HSICAL_Pos)  /*!< 0x0000FF00 */
#define RCC_CR_HSICAL                            RCC_CR_HSICAL_Msk             
#define RCC_CR_HSICAL_0                          (0x01U << RCC_CR_HSICAL_Pos)  /*!< 0x00000100 */
#define RCC_CR_HSICAL_1                          (0x02U << RCC_CR_HSICAL_Pos)  /*!< 0x00000200 */
#define RCC_CR_HSICAL_2                          (0x04U << RCC_CR_HSICAL_Pos)  /*!< 0x00000400 */
#define RCC_CR_HSICAL_3                          (0x08U << RCC_CR_HSICAL_Pos)  /*!< 0x00000800 */
#define RCC_CR_HSICAL_4                          (0x10U << RCC_CR_HSICAL_Pos)  /*!< 0x00001000 */
#define RCC_CR_HSICAL_5                          (0x20U << RCC_CR_HSICAL_Pos)  /*!< 0x00002000 */
#define RCC_CR_HSICAL_6                          (0x40U << RCC_CR_HSICAL_Pos)  /*!< 0x00004000 */
#define RCC_CR_HSICAL_7                          (0x80U << RCC_CR_HSICAL_Pos)  /*!< 0x00008000 */

#define RCC_CR_HSEON_Pos                         (16U)                         
#define RCC_CR_HSEON_Msk                         (0x1U << RCC_CR_HSEON_Pos)    /*!< 0x00010000 */
#define RCC_CR_HSEON                             RCC_CR_HSEON_Msk              
#define RCC_CR_HSERDY_Pos                        (17U)                         
#define RCC_CR_HSERDY_Msk                        (0x1U << RCC_CR_HSERDY_Pos)   /*!< 0x00020000 */
#define RCC_CR_HSERDY                            RCC_CR_HSERDY_Msk             
#define RCC_CR_HSEBYP_Pos                        (18U)                         
#define RCC_CR_HSEBYP_Msk                        (0x1U << RCC_CR_HSEBYP_Pos)   /*!< 0x00040000 */
#define RCC_CR_HSEBYP                            RCC_CR_HSEBYP_Msk             
#define RCC_CR_CSSON_Pos                         (19U)                         
#define RCC_CR_CSSON_Msk                         (0x1U << RCC_CR_CSSON_Pos)    /*!< 0x00080000 */
#define RCC_CR_CSSON                             RCC_CR_CSSON_Msk              
#define RCC_CR_PLLON_Pos                         (24U)                         
#define RCC_CR_PLLON_Msk                         (0x1U << RCC_CR_PLLON_Pos)    /*!< 0x01000000 */
#define RCC_CR_PLLON                             RCC_CR_PLLON_Msk              
#define RCC_CR_PLLRDY_Pos                        (25U)                         
#define RCC_CR_PLLRDY_Msk                        (0x1U << RCC_CR_PLLRDY_Pos)   /*!< 0x02000000 */
#define RCC_CR_PLLRDY                            RCC_CR_PLLRDY_Msk             

/********************  Bit definition for RCC_CFGR register  ******************/
/*!< SW configuration */
#define RCC_CFGR_SW_Pos                          (0U)                          
#define RCC_CFGR_SW_Msk                          (0x3U << RCC_CFGR_SW_Pos)     /*!< 0x00000003 */
#define RCC_CFGR_SW                              RCC_CFGR_SW_Msk               /*!< SW[1:0] bits (System clock Switch) */
#define RCC_CFGR_SW_0                            (0x1U << RCC_CFGR_SW_Pos)     /*!< 0x00000001 */
#define RCC_CFGR_SW_1                            (0x2U << RCC_CFGR_SW_Pos)     /*!< 0x00000002 */

#define RCC_CFGR_SW_HSI                          (0x00000000U)                 /*!< HSI selected as system clock */
#define RCC_CFGR_SW_HSE                          (0x00000001U)                 /*!< HSE selected as system clock */
#define RCC_CFGR_SW_PLL                          (0x00000002U)                 /*!< PLL selected as system clock */

/*!< SWS configuration */
#define RCC_CFGR_SWS_Pos                         (2U)                          
#define RCC_CFGR_SWS_Msk                         (0x3U << RCC_CFGR_SWS_Pos)    /*!< 0x0000000C */
#define RCC_CFGR_SWS                             RCC_CFGR_SWS_Msk              /*!< SWS[1:0] bits (System Clock Switch Status) */
#define RCC_CFGR_SWS_0                           (0x1U << RCC_CFGR_SWS_Pos)    /*!< 0x00000004 */
#define RCC_CFGR_SWS_1                           (0x2U << RCC_CFGR_SWS_Pos)    /*!< 0x00000008 */

#define RCC_CFGR_SWS_HSI                         (0x00000000U)                 /*!< HSI oscillator used as system clock */
#define RCC_CFGR_SWS_HSE                         (0x00000004U)                 /*!< HSE oscillator used as system clock */
#define RCC_CFGR_SWS_PLL                         (0x00000008U)                 /*!< PLL used as system clock */

/*!< HPRE configuration */
#define RCC_CFGR_HPRE_Pos                        (4U)                          
#define RCC_CFGR_HPRE_Msk                        (0xFU << RCC_CFGR_HPRE_Pos)   /*!< 0x000000F0 */
#define RCC_CFGR_HPRE                            RCC_CFGR_HPRE_Msk             /*!< HPRE[3:0] bits (AHB prescaler) */
#define RCC_CFGR_HPRE_0                          (0x1U << RCC_CFGR_HPRE_Pos)   /*!< 0x00000010 */
#define RCC_CFGR_HPRE_1                          (0x2U << RCC_CFGR_HPRE_Pos)   /*!< 0x00000020 */
#define RCC_CFGR_HPRE_2                          (0x4U << RCC_CFGR_HPRE_Pos)   /*!< 0x00000040 */
#define RCC_CFGR_HPRE_3                          (0x8U << RCC_CFGR_HPRE_Pos)   /*!< 0x00000080 */

#define RCC_CFGR_HPRE_DIV1                       (0x00000000U)                 /*!< SYSCLK not divided */
#define RCC_CFGR_HPRE_DIV2                       (0x00000080U)                 /*!< SYSCLK divided by 2 */
#define RCC_CFGR_HPRE_DIV4                       (0x00000090U)                 /*!< SYSCLK divided by 4 */
#define RCC_CFGR_HPRE_DIV8                       (0x000000A0U)                 /*!< SYSCLK divided by 8 */
#define RCC_CFGR_HPRE_DIV16                      (0x000000B0U)                 /*!< SYSCLK divided by 16 */
#define RCC_CFGR_HPRE_DIV64                      (0x000000C0U)                 /*!< SYSCLK divided by 64 */
#define RCC_CFGR_HPRE_DIV128                     (0x000000D0U)                 /*!< SYSCLK divided by 128 */
#define RCC_CFGR_HPRE_DIV256                     (0x000000E0U)                 /*!< SYSCLK divided by 256 */
#define RCC_CFGR_HPRE_DIV512                     (0x000000F0U)                 /*!< SYSCLK divided by 512 */

/*!< PPRE1 configuration */
#define RCC_CFGR_PPRE1_Pos                       (8U)                          
#define RCC_CFGR_PPRE1_Msk                       (0x7U << RCC_CFGR_PPRE1_Pos)  /*!< 0x00000700 */
#define RCC_CFGR_PPRE1                           RCC_CFGR_PPRE1_Msk            /*!< PRE1[2:0] bits (APB1 prescaler) */
#define RCC_CFGR_PPRE1_0                         (0x1U << RCC_CFGR_PPRE1_Pos)  /*!< 0x00000100 */
#define RCC_CFGR_PPRE1_1                         (0x2U << RCC_CFGR_PPRE1_Pos)  /*!< 0x00000200 */
#define RCC_CFGR_PPRE1_2                         (0x4U << RCC_CFGR_PPRE1_Pos)  /*!< 0x00000400 */

#define RCC_CFGR_PPRE1_DIV1                      (0x00000000U)                 /*!< HCLK not divided */
#define RCC_CFGR_PPRE1_DIV2                      (0x00000400U)                 /*!< HCLK divided by 2 */
#define RCC_CFGR_PPRE1_DIV4                      (0x00000500U)                 /*!< HCLK divided by 4 */
#define RCC_CFGR_PPRE1_DIV8                      (0x00000600U)                 /*!< HCLK divided by 8 */
#define RCC_CFGR_PPRE1_DIV16                     (0x00000700U)                 /*!< HCLK divided by 16 */

/*!< PPRE2 configuration */
#define RCC_CFGR_PPRE2_Pos                       (11U)                         
#define RCC_CFGR_PPRE2_Msk                       (0x7U << RCC_CFGR_PPRE2_Pos)  /*!< 0x00003800 */
#define RCC_CFGR_PPRE2                           RCC_CFGR_PPRE2_Msk            /*!< PRE2[2:0] bits (APB2 prescaler) */
#define RCC_CFGR_PPRE2_0                         (0x1U << RCC_CFGR_PPRE2_Pos)  /*!< 0x00000800 */
#define RCC_CFGR_PPRE2_1                         (0x2U << RCC_CFGR_PPRE2_Pos)  /*!< 0x00001000 */
#define RCC_CFGR_PPRE2_2                         (0x4U << RCC_CFGR_PPRE2_Pos)  /*!< 0x00002000 */

#define RCC_CFGR_PPRE2_DIV1                      (0x00000000U)                 /*!< HCLK not divided */
#define RCC_CFGR_PPRE2_DIV2                      (0x00002000U)                 /*!< HCLK divided by 2 */
#define RCC_CFGR_PPRE2_DIV4                      (0x00002800U)                 /*!< HCLK divided by 4 */
#define RCC_CFGR_PPRE2_DIV8                      (0x00003000U)                 /*!< HCLK divided by 8 */
#define RCC_CFGR_PPRE2_DIV16                     (0x00003800U)                 /*!< HCLK divided by 16 */

#define RCC_CFGR_PLLSRC_Pos                      (16U)                         
#define RCC_CFGR_PLLSRC_Msk                      (0x1U << RCC_CFGR_PLLSRC_Pos) /*!< 0x00010000 */
#define RCC_CFGR_PLLSRC                          RCC_CFGR_PLLSRC_Msk           /*!< PLL entry clock source */
#define RCC_CFGR_PLLSRC_HSI_DIV2                 (0x00000000U)                 /*!< HSI clock divided by 2 selected as PLL entry clock source */
#define RCC_CFGR_PLLSRC_HSE_PREDIV               (0x00010000U)                 /*!< HSE/PREDIV clock selected as PLL entry clock source */

#define RCC_CFGR_PLLXTPRE_Pos                    (17U)                         
#define RCC_CFGR_PLLXTPRE_Msk                    (0x1U << RCC_CFGR_PLLXTPRE_Pos) /*!< 0x00020000 */
#define RCC_CFGR_PLLXTPRE                        RCC_CFGR_PLLXTPRE_Msk         /*!< HSE divider for PLL entry */
#define RCC_CFGR_PLLXTPRE_HSE_PREDIV_DIV1        (0x00000000U)                 /*!< HSE/PREDIV clock not divided for PLL entry */
#define RCC_CFGR_PLLXTPRE_HSE_PREDIV_DIV2        (0x00020000U)                 /*!< HSE/PREDIV clock divided by 2 for PLL entry */

/*!< PLLMUL configuration */
#define RCC_CFGR_PLLMUL_Pos                      (18U)                         
#define RCC_CFGR_PLLMUL_Msk                      (0xFU << RCC_CFGR_PLLMUL_Pos) /*!< 0x003C0000 */
#define RCC_CFGR_PLLMUL                          RCC_CFGR_PLLMUL_Msk           /*!< PLLMUL[3:0] bits (PLL multiplication factor) */
#define RCC_CFGR_PLLMUL_0                        (0x1U << RCC_CFGR_PLLMUL_Pos) /*!< 0x00040000 */
#define RCC_CFGR_PLLMUL_1                        (0x2U << RCC_CFGR_PLLMUL_Pos) /*!< 0x00080000 */
#define RCC_CFGR_PLLMUL_2                        (0x4U << RCC_CFGR_PLLMUL_Pos) /*!< 0x00100000 */
#define RCC_CFGR_PLLMUL_3                        (0x8U << RCC_CFGR_PLLMUL_Pos) /*!< 0x00200000 */

#define RCC_CFGR_PLLMUL2                         (0x00000000U)                 /*!< PLL input clock*2 */
#define RCC_CFGR_PLLMUL3                         (0x00040000U)                 /*!< PLL input clock*3 */
#define RCC_CFGR_PLLMUL4                         (0x00080000U)                 /*!< PLL input clock*4 */
#define RCC_CFGR_PLLMUL5                         (0x000C0000U)                 /*!< PLL input clock*5 */
#define RCC_CFGR_PLLMUL6                         (0x00100000U)                 /*!< PLL input clock*6 */
#define RCC_CFGR_PLLMUL7                         (0x00140000U)                 /*!< PLL input clock*7 */
#define RCC_CFGR_PLLMUL8                         (0x00180000U)                 /*!< PLL input clock*8 */
#define RCC_CFGR_PLLMUL9                         (0x001C0000U)                 /*!< PLL input clock*9 */
#define RCC_CFGR_PLLMUL10                        (0x00200000U)                 /*!< PLL input clock10 */
#define RCC_CFGR_PLLMUL11                        (0x00240000U)                 /*!< PLL input clock*11 */
#define RCC_CFGR_PLLMUL12                        (0x00280000U)                 /*!< PLL input clock*12 */
#define RCC_CFGR_PLLMUL13                        (0x002C0000U)                 /*!< PLL input clock*13 */
#define RCC_CFGR_PLLMUL14                        (0x00300000U)                 /*!< PLL input clock*14 */
#define RCC_CFGR_PLLMUL15                        (0x00340000U)                 /*!< PLL input clock*15 */
#define RCC_CFGR_PLLMUL16                        (0x00380000U)                 /*!< PLL input clock*16 */

/*!< MCO configuration */
#define RCC_CFGR_MCO_Pos                         (24U)                         
#define RCC_CFGR_MCO_Msk                         (0x7U << RCC_CFGR_MCO_Pos)    /*!< 0x07000000 */
#define RCC_CFGR_MCO                             RCC_CFGR_MCO_Msk              /*!< MCO[2:0] bits (Microcontroller Clock Output) */
#define RCC_CFGR_MCO_0                           (0x1U << RCC_CFGR_MCO_Pos)    /*!< 0x01000000 */
#define RCC_CFGR_MCO_1                           (0x2U << RCC_CFGR_MCO_Pos)    /*!< 0x02000000 */
#define RCC_CFGR_MCO_2                           (0x4U << RCC_CFGR_MCO_Pos)    /*!< 0x04000000 */

#define RCC_CFGR_MCO_NOCLOCK                     (0x00000000U)                 /*!< No clock */
#define RCC_CFGR_MCO_LSI                         (0x02000000U)                 /*!< LSI clock selected as MCO source */
#define RCC_CFGR_MCO_LSE                         (0x03000000U)                 /*!< LSE clock selected as MCO source */
#define RCC_CFGR_MCO_SYSCLK                      (0x04000000U)                 /*!< System clock selected as MCO source */
#define RCC_CFGR_MCO_HSI                         (0x05000000U)                 /*!< HSI clock selected as MCO source */
#define RCC_CFGR_MCO_HSE                         (0x06000000U)                 /*!< HSE clock selected as MCO source  */
#define RCC_CFGR_MCO_PLL                         (0x07000000U)                 /*!< PLL clock divided by 2 selected as MCO source */

#define RCC_CFGR_MCOPRE_Pos                      (28U)                         
#define RCC_CFGR_MCOPRE_Msk                      (0x7U << RCC_CFGR_MCOPRE_Pos) /*!< 0x70000000 */
#define RCC_CFGR_MCOPRE                          RCC_CFGR_MCOPRE_Msk           /*!< MCOPRE[3:0] bits (Microcontroller Clock Output Prescaler) */
#define RCC_CFGR_MCOPRE_0                        (0x1U << RCC_CFGR_MCOPRE_Pos) /*!< 0x10000000 */
#define RCC_CFGR_MCOPRE_1                        (0x2U << RCC_CFGR_MCOPRE_Pos) /*!< 0x20000000 */
#define RCC_CFGR_MCOPRE_2                        (0x4U << RCC_CFGR_MCOPRE_Pos) /*!< 0x40000000 */

#define RCC_CFGR_MCOPRE_DIV1                     (0x00000000U)                 /*!< MCO is divided by 1 */
#define RCC_CFGR_MCOPRE_DIV2                     (0x10000000U)                 /*!< MCO is divided by 2 */
#define RCC_CFGR_MCOPRE_DIV4                     (0x20000000U)                 /*!< MCO is divided by 4 */
#define RCC_CFGR_MCOPRE_DIV8                     (0x30000000U)                 /*!< MCO is divided by 8 */
#define RCC_CFGR_MCOPRE_DIV16                    (0x40000000U)                 /*!< MCO is divided by 16 */
#define RCC_CFGR_MCOPRE_DIV32                    (0x50000000U)                 /*!< MCO is divided by 32 */
#define RCC_CFGR_MCOPRE_DIV64                    (0x60000000U)                 /*!< MCO is divided by 64 */
#define RCC_CFGR_MCOPRE_DIV128                   (0x70000000U)                 /*!< MCO is divided by 128 */

#define RCC_CFGR_PLLNODIV_Pos                    (31U)                         
#define RCC_CFGR_PLLNODIV_Msk                    (0x1U << RCC_CFGR_PLLNODIV_Pos) /*!< 0x80000000 */
#define RCC_CFGR_PLLNODIV                        RCC_CFGR_PLLNODIV_Msk         /*!< Do not divide PLL to MCO */

/* Reference defines */
#define RCC_CFGR_MCOSEL                      RCC_CFGR_MCO
#define RCC_CFGR_MCOSEL_0                    RCC_CFGR_MCO_0
#define RCC_CFGR_MCOSEL_1                    RCC_CFGR_MCO_1
#define RCC_CFGR_MCOSEL_2                    RCC_CFGR_MCO_2
#define RCC_CFGR_MCOSEL_NOCLOCK              RCC_CFGR_MCO_NOCLOCK
#define RCC_CFGR_MCOSEL_LSI                  RCC_CFGR_MCO_LSI
#define RCC_CFGR_MCOSEL_LSE                  RCC_CFGR_MCO_LSE
#define RCC_CFGR_MCOSEL_SYSCLK               RCC_CFGR_MCO_SYSCLK
#define RCC_CFGR_MCOSEL_HSI                  RCC_CFGR_MCO_HSI
#define RCC_CFGR_MCOSEL_HSE                  RCC_CFGR_MCO_HSE
#define RCC_CFGR_MCOSEL_PLL_DIV2             RCC_CFGR_MCO_PLL

/*********************  Bit definition for RCC_CIR register  ********************/
#define RCC_CIR_LSIRDYF_Pos                      (0U)                          
#define RCC_CIR_LSIRDYF_Msk                      (0x1U << RCC_CIR_LSIRDYF_Pos) /*!< 0x00000001 */
#define RCC_CIR_LSIRDYF                          RCC_CIR_LSIRDYF_Msk           /*!< LSI Ready Interrupt flag */
#define RCC_CIR_LSERDYF_Pos                      (1U)                          
#define RCC_CIR_LSERDYF_Msk                      (0x1U << RCC_CIR_LSERDYF_Pos) /*!< 0x00000002 */
#define RCC_CIR_LSERDYF                          RCC_CIR_LSERDYF_Msk           /*!< LSE Ready Interrupt flag */
#define RCC_CIR_HSIRDYF_Pos                      (2U)                          
#define RCC_CIR_HSIRDYF_Msk                      (0x1U << RCC_CIR_HSIRDYF_Pos) /*!< 0x00000004 */
#define RCC_CIR_HSIRDYF                          RCC_CIR_HSIRDYF_Msk           /*!< HSI Ready Interrupt flag */
#define RCC_CIR_HSERDYF_Pos                      (3U)                          
#define RCC_CIR_HSERDYF_Msk                      (0x1U << RCC_CIR_HSERDYF_Pos) /*!< 0x00000008 */
#define RCC_CIR_HSERDYF                          RCC_CIR_HSERDYF_Msk           /*!< HSE Ready Interrupt flag */
#define RCC_CIR_PLLRDYF_Pos                      (4U)                          
#define RCC_CIR_PLLRDYF_Msk                      (0x1U << RCC_CIR_PLLRDYF_Pos) /*!< 0x00000010 */
#define RCC_CIR_PLLRDYF                          RCC_CIR_PLLRDYF_Msk           /*!< PLL Ready Interrupt flag */
#define RCC_CIR_CSSF_Pos                         (7U)                          
#define RCC_CIR_CSSF_Msk                         (0x1U << RCC_CIR_CSSF_Pos)    /*!< 0x00000080 */
#define RCC_CIR_CSSF                             RCC_CIR_CSSF_Msk              /*!< Clock Security System Interrupt flag */
#define RCC_CIR_LSIRDYIE_Pos                     (8U)                          
#define RCC_CIR_LSIRDYIE_Msk                     (0x1U << RCC_CIR_LSIRDYIE_Pos) /*!< 0x00000100 */
#define RCC_CIR_LSIRDYIE                         RCC_CIR_LSIRDYIE_Msk          /*!< LSI Ready Interrupt Enable */
#define RCC_CIR_LSERDYIE_Pos                     (9U)                          
#define RCC_CIR_LSERDYIE_Msk                     (0x1U << RCC_CIR_LSERDYIE_Pos) /*!< 0x00000200 */
#define RCC_CIR_LSERDYIE                         RCC_CIR_LSERDYIE_Msk          /*!< LSE Ready Interrupt Enable */
#define RCC_CIR_HSIRDYIE_Pos                     (10U)                         
#define RCC_CIR_HSIRDYIE_Msk                     (0x1U << RCC_CIR_HSIRDYIE_Pos) /*!< 0x00000400 */
#define RCC_CIR_HSIRDYIE                         RCC_CIR_HSIRDYIE_Msk          /*!< HSI Ready Interrupt Enable */
#define RCC_CIR_HSERDYIE_Pos                     (11U)                         
#define