// test code, this demonstrates working motor drivers. 
// full reverse to full stop, dynamicaly brake and switch off.
#include "mbed.h"
#include "Motor.h"
Motor A(p22, p6, p5); // pwm, fwd, rev, can brake 
Motor B(p21, p7, p8); // pwm, fwd, rev, can brake


//End Device Setup for XBEE End Device
Serial xbee2(p9,p10);
DigitalOut rst1(p11);

//Movement Indicators
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED2);
DigitalOut myled4(LED2);

// Default Value for command to wait
char command = 'W';

int main() {
    rst1 = 0;   //Set reset pin to 0
    myled1 = 0;
    myled2 = 0;
    myled3 = 0;
    myled4 = 0;
    wait_ms(1);
    rst1 = 1;   //Set reset pin to 1
    wait_ms(1);
    
    while (1){
        if(xbee2.readable()) {//if new command readable
            command = xbee2.getc();
            //pc.printf("Command: %c\n\r",command);
        }
        
        switch (command){
            case 'A': // Move back speed 1
                A.speed(-0.5);
                B.speed(-0.5);
                
                myled1 = 1;
                myled2 = 0;
                myled3 = 0;
                myled4 = 0;
                
                wait(0.5);
                break;
            case 'B': // Move back speed 2
                A.speed(-1);
                B.speed(-1);
                
                myled1 = 1;
                myled2 = 0;
                myled3 = 0;
                myled4 = 0;
                
                wait(0.5);
                break;
            case 'C': // Move right speed 1
                A.speed(0.5);
                B.speed(0);
                
                myled1 = 0;
                myled2 = 1;
                myled3 = 0;
                myled4 = 0;
                
                wait(0.5);
                break;
            case 'D': // Move right speed 2
                A.speed(1);
                B.speed(0);
                
                myled1 = 0;
                myled2 = 1;
                myled3 = 0;
                myled4 = 0;
                
                wait(0.5);
                break;
            case 'E': // Move forward speed 1
                A.speed(0.5);
                B.speed(0.5);
                
                myled1 = 0;
                myled2 = 0;
                myled3 = 1;
                myled4 = 0;
                
                wait(0.5);
                break;
            case 'F': // Move forward speed 2
                A.speed(1);
                B.speed(1);
                
                myled1 = 0;
                myled2 = 0;
                myled3 = 1;
                myled4 = 0;
                
                wait(0.5);
                break;
            case 'G': // Move left speed 1
                A.speed(0);
                B.speed(0.5);
                
                myled1 = 0;
                myled2 = 0;
                myled3 = 0;
                myled4 = 1;
                
                wait(0.5);
                break;
            case 'H': // Move left speed 2
                A.speed(0);
                B.speed(1);
                
                myled1 = 0;
                myled2 = 0;
                myled3 = 0;
                myled4 = 1;
                
                wait(0.5);
                break;
            case 'I': // Stop
                A.speed(-0.5);
                B.speed(-0.5);
                
                myled1 = 1;
                myled2 = 1;
                myled3 = 1;
                myled4 = 1;
                
                wait(0.5);
                
            case 'W': // Stop if nothing else is coming in 
                A.speed(0);
                B.speed(0);
                
                myled1 = 0;
                myled2 = 0;
                myled3 = 0;
                myled4 = 0;
                
                wait(0.5);

            }
        }
}