/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
 
#include "mbed.h"
#include "BLEDevice.h"
#include "DeviceInformationService.h"
#include "UARTService.h"
#include "Utils.h"

const static char     DEVICE_NAME[]        = "BlueNRG_UART";
uint8_t c = 'A';

extern bool user_button_pressed;
bool connected = false;
bool UpdatedEnabled = false;

BLEDevice  ble;
UARTService *uartServicePtr;

/* Callback called when the device is disconnected */
void disconnectionCallback(Gap::Handle_t handle, Gap::DisconnectionReason_t reason)
{
  DEBUG("Disconnected!\n\r");
  DEBUG("Restarting the advertising process\n\r");

  ble.startAdvertising();
  connected = false;
}

/* Callback called when the device is connected */
void connectionCallback(Gap::Handle_t handle, const Gap::ConnectionParams_t *reason)
{
  DEBUG("Connected\r\n");

  connected = true;
}

/* Not working */
void onDataSent(unsigned count)
{
  DEBUG("onDataSent\r\n");
}

/* Not working */
void onDataWritten(const GattCharacteristicWriteCBParams *params)
{
  DEBUG("--onDataWritten\r\n");
  DEBUG("---charHandle               : %d\r\n", params->charHandle);
  DEBUG("---getTXCharacteristicHandle: %d\r\n", uartServicePtr->getTXCharacteristicHandle());
  DEBUG("---len: %d\r\n", params->len);
    
  if ((uartServicePtr != NULL) && (params->charHandle == uartServicePtr->getTXCharacteristicHandle())) 
  {
    DEBUG("received %u bytes\n\r", params->len);
             
    if(params->data[0] == 0x00)
    {
      //Do something
    }
    else
    {
      //Do something else
    }
  }
}

/* Callback called when the client enables updates */
void onUpdatesEnabled(uint16_t attributeHandle)
{
  DEBUG("**onUpdatesEnabled**\r\n");
  UpdatedEnabled = true;
}

/* Callback called when the client disable updates */
void onUpdatesDisabled(uint16_t attributeHandle)
{
  DEBUG("**onUpdatesDisabled**\r\n");
  UpdatedEnabled = false;
}
 
/* Main */
int main(void)
{
  DEBUG("Initialising \n\r");
  ble.init();
#if 1
/* Set callback functions */
  ble.onDisconnection(disconnectionCallback);
  ble.onConnection(connectionCallback);
  ble.onDataWritten(onDataWritten);
  ble.onDataSent(onDataSent);
  ble.onUpdatesEnabled(onUpdatesEnabled);
  ble.onUpdatesDisabled(onUpdatesDisabled);
 
  DeviceInformationService deviceInfo(ble, "ST", "Nucleo", "SN1", "hw-rev1", "fw-rev1", "soft-rev1");
  /* setup advertising */
  ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED);
  ble.setAdvertisingType          (GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    
  ble.accumulateAdvertisingPayload(GapAdvertisingData::SHORTENED_LOCAL_NAME            , (const uint8_t *)"BlueNRG_UART"          , sizeof("BlueNRG_UART") - 1);
  ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_128BIT_SERVICE_IDS, (const uint8_t *)UARTServiceUUID_reversed, sizeof(UARTServiceUUID_reversed));
  ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME             , (uint8_t *)DEVICE_NAME                   , sizeof(DEVICE_NAME));

  /* Start advertising */
  ble.setAdvertisingInterval(160);
  ble.startAdvertising();
 
  UARTService uartService(ble);
  uartServicePtr = &uartService;


  while (true) 
  {
    ble.waitForEvent();
        
    if(connected == true)
    {
      if ((user_button_pressed == true) && (UpdatedEnabled == true))
      {
        user_button_pressed = false;
        DEBUG("Current Char: %c\r\n",c);
        ble.updateCharacteristicValue(uartServicePtr->getRXCharacteristicHandle(), &c, 1);
                
        c++;
                
        if(c == ('Z'+1))
        {
          c = 'A';
        }
      }
    }
  }
#else
  while (true) 
  {
    if (user_button_pressed == true)
    {
      user_button_pressed = false;
      DEBUG("Current Char: %c\r\n",c);
                
      c++;
                
      if(c == ('Z'+1))
      {
        c = 'A';
      }
    }
  }
#endif
}
