/* University of York Robotics Laboratory PsiSwarm Library: Sensor Functions Header File
 * 
 * Copyright 2016 University of York
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and limitations under the License.
 *
 * File: sensors.h
 *
 * (C) Dept. Electronics & Computer Science, University of York
 * James Hilder, Alan Millard, Alexander Horsfield, Homero Elizondo, Jon Timmis
 *
 * PsiSwarm Library Version: 0.7
 *
 * October 2016
 *
 */
 
#ifndef SENSORS_H
#define SENSORS_H

float get_battery_voltage ( void );
float get_current ( void );
float get_dc_voltage ( void );

float get_temperature ( void );
void enable_ultrasonic_ticker( void );
void disable_ultrasonic_ticker( void );
void update_ultrasonic_measure ( void );
void IF_read_ultrasonic_measure ( void );
float read_reflected_ir_distance ( char index );
float get_reflected_ir_distance ( char index );
unsigned short get_background_raw_ir_value ( char index );
unsigned short get_illuminated_raw_ir_value ( char index );
void store_reflected_ir_distances ( void );
void store_background_raw_ir_values ( void );
void store_illuminated_raw_ir_values ( void );
float calculate_reflected_distance ( unsigned short background_value, unsigned short illuminated_value );
unsigned short read_illuminated_raw_ir_value ( char index ) ;
 
unsigned short get_background_base_ir_value ( char index );
unsigned short get_illuminated_base_ir_value ( char index );
unsigned short calculate_base_ir_value ( char index );
unsigned short calculate_side_ir_value ( char index );

int get_bearing_from_ir_array ( unsigned short * ir_sensor_readings);
void store_ir_values ( void );
void store_base_ir_values ( void );
void store_background_base_ir_values ( void );
void store_illuminated_base_ir_values ( void );

void store_line_position ( void );
void calibrate_base_ir_sensors ( void );

#endif