/* University of York Robotics Laboratory PsiSwarm Library: LED Functions Header File
 * 
 * Copyright 2016 University of York
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and limitations under the License.
 *
 * File: led.h
 *
 * (C) Dept. Electronics & Computer Science, University of York
 * James Hilder, Alan Millard, Alexander Horsfield, Homero Elizondo, Jon Timmis
 *
 * PsiSwarm Library Version: 0.7
 *
 * October 2016
 *
 *
 */ 


#ifndef LED_H
#define LED_H

unsigned short get_led_states(void);
void set_leds(char green, char red);
void set_green_leds(char green);
void set_red_leds(char red);
void set_led(char led, char state);
void set_base_led(char state);
void blink_leds(float timeout);
void set_center_led(char state);
void set_center_led(char state, float brightness);
void set_center_led_brightness(float brightness);
void save_led_states(void);
void restore_led_states(void);
void IF_init_leds(void);
void IF_update_leds(void);

#endif