/* University of York Robotics Laboratory PsiSwarm Library: Motor Functions Header File
 * 
 * Copyright 2016 University of York
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and limitations under the License.
 *
 * File: motors.h
 *
 * (C) Dept. Electronics & Computer Science, University of York
 * James Hilder, Alan Millard, Alexander Horsfield, Homero Elizondo, Jon Timmis
 *
 * PsiSwarm Library Version: 0.7
 *
 * October 2016
 *
 *
 */ 

#ifndef MOTORS_H
#define MOTORS_H

void set_left_motor_speed(float speed);
void set_right_motor_speed(float speed);
void brake_left_motor(void);
void brake_right_motor(void);
void brake(void);
void stop(void);
void forward(float speed);
void backward(float speed);
void turn(float speed);

// New time based functions (library v0.3)
void time_based_forward(float speed, int microseconds, char brake);
void time_based_turn(float speed, int microseconds, char brake);
int time_based_turn_degrees(float speed, float degrees, char brake);
float get_maximum_turn_angle(int microseconds);
int get_time_based_turn_time(float speed, float degrees);
void IF_check_time_for_existing_time_based_action();
void IF_end_time_based_action();

void IF_update_motors();
float IF_calibrated_left_speed(float speed);
float IF_calibrated_right_speed(float speed);
float IF_calibrated_speed(float speed);
void IF_init_motors(void);

#endif