#ifndef SERIAL_H
#define SERIAL_H


/**
 *  The SerialComms class contains the functions to read from the robots sensors
 */
class SerialComms
{
public:

    /**
     * Setup the serial interfaces (pc, bt) at the correct baud rate and attach listeners
     */
    void setup_serial_interfaces( void );

    void handle_command_serial_message(char message [3], char interface);
    void handle_user_serial_message(char * message, char length, char interface);
    float decode_float(char byte0, char byte1);
    float decode_float(char byte0);
    float decode_unsigned_float(char byte0, char byte1);
    float decode_unsigned_float(char byte0);
    
    // Private functions
    private:


    char * _nibble_to_binary_char(char in);
    char * _char_to_binary_char(char in);
    void _pc_rx_callback( void );
    void _pc_rx_command_timeout( void );

    void _bt_rx_callback( void );

};


#endif

