#ifndef SENSORS_H
#define SENSORS_H

/**
 *  The Sensors class contains the functions to read from the robots sensors
 */
class Sensors
{
public:


    /**
     *  Reads and stores a value from the ADS7830 i2c ADC used for the Sharp distance sensors
     *
     * @param channel - The channel to read from (0 to 7)
     * @return The 8-bit value returned by the ADC
     */
    char read_adc_value(char channel);

    /**
     *  Returns the stored value from the last call of read_adc_value
     *
     * @param channel - The channel to read from (0 to 7)
     * @return The stored 8-bit value 
     */
    char get_adc_value(char channel);

   /**
    *  Starts a ticker which reads and stores the value for each distance sensor at a 
    * frequency defined by SENSOR_TICKER_PERIOD (eg 10Hz)
    */
   void start_sensor_ticker(void);

   /**
    * Reads the next sensor
    */
    void sensor_ticker_routine(void);
};


#endif
