#include "robot.h"

char adc_data_messages [8] = {0x84,0xC4,0x94,0xD4,0xA4,0xE4,0xB4,0xF4};

char adc_stored_values [8];

char sensor_ticker_current_sensor = 0;
Ticker sensor_ticker;

void Sensors::start_sensor_ticker(){
    sensor_ticker.attach(this,&Sensors::sensor_ticker_routine,SENSOR_TICKER_PERIOD);
}

void Sensors::sensor_ticker_routine(){
     read_adc_value(sensor_ticker_current_sensor);
     sensor_ticker_current_sensor ++;
     if(sensor_ticker_current_sensor == 8) sensor_ticker_current_sensor = 0;
}

char Sensors::get_adc_value(char channel){
    return adc_stored_values[channel];   
}

char Sensors::read_adc_value(char channel){
    char return_value = 0;
    if(channel < 8 && i2c_lock == 0){
    char command[1];
    char ret_data[1];
    command[0] =  adc_data_messages[channel];
    i2c_lock = 1;
    primary_i2c.write(ADC_ADDRESS,command,1);
    primary_i2c.read(ADC_ADDRESS,ret_data,1);
    i2c_lock = 0;
    return_value = ret_data[0];
    adc_stored_values[channel]=return_value;
    }
    return return_value;
}