#include "mbed.h"
#include "hcsr04.h"
#include "Adafruit_SSD1306.h"


class I2CPreInit : public I2C
{
public:
    I2CPreInit(PinName sda, PinName scl) : I2C(sda, scl)
    {
        frequency(100000);
        start();
    };
};

I2CPreInit gI2C(PB_9,PB_8);
Adafruit_SSD1306_I2c gOled(gI2C,NC,0x78,64,128);

Serial pc(USBTX, USBRX); // tx, rx
Serial bt(A5, A4); // tx, rx
Ticker repeticion;

DigitalOut led(LED1);
DigitalOut step(D13);
DigitalOut dir(D12);
DigitalOut enable(D11);
DigitalOut dirAMotor(D4);
PwmOut     dirBMotor(A3);
InterruptIn encoderA(A2);
DigitalOut rele(D3);
HCSR04  usensor(D7,D8);
DigitalIn final1(D9);
DigitalIn final2(D10);
AnalogIn Vout(A0);
AnalogIn Aout(A1);

enum estados {inicio,movder,calentar,movizq1,centro,movizq2,soplado};
estados estado;


void medir_corriente()
{

    float corriente=((Aout.read()*5)-2.5)/0.185;

    bt.printf("Intensidad medida = %.4f A \n", corriente);

}

int dato=0;

void estadoinicio()
{
    {
        if(bt.readable()) { //Mira si hay algun dato pendiente en el bt
            dato=bt.getc();  //Lee un caracter del bt

        }
        if (dato=='1') {            //Si el dato es un 1 comienza el proceso

            estado = movder;
            bt.printf("Transportando a calentador\n");


        } else {   
        }
    }
}


void estadomovderecha()
{
    if(final1==0) {
        enable=1; //activar el motor
        dir=1; //direccion hacia la derecha
        //step=1; // avanzar
        step=1;
        wait_us(100);
        step=0;
        wait_us(900);
    } else {
        enable=0;
        estado=calentar;
       
        bt.printf("Calentando\n");
        
    }
}

void estadocalentar()
{
    float tension=Vout.read()*3.3;

    float resistencia= ((3.3*100000.0)/tension)-100000.0;

    float temp= (3950.0/(log(resistencia/100000.0)+(3950.0/298.0))-273.0);
    bt.printf("Calentando a: %.4f\n",temp);


    if (temp<35.0) {
        rele=1;

    } else {
        rele=0;
        estado=movizq1;
        
        bt.printf("Transportando a revision\n");
    }
}

void estadomovizq1()
{
    usensor.start();
    wait(0.01);
    dist=0.9*dist +0.1*usensor.get_dist_cm();

    if(dist>20) {
        enable=1; //activar el motor
        dir=0; //direccion hacia la derecha
        step=1; // avanzar
        wait_us(100);
        step=0;
        wait_us(900);

    } else {
        enable=0;
        estado=centro;
        
        bt.printf("Revisando\n");
    }
}


void estadocentro()
{
    {
        if(bt.readable()) { //Mira si hay algun dato pendiente en el bt
            dato=bt.getc();  //Lee un caracter del bt

        }
        if (dato=='2') {            //Si el dato es un 1 comienza el proceso

            estado = movder;
            
            bt.printf("Pieza incorrecta\n");
            bt.printf("Transportando a calentador\n");
            

        } else if(dato=='3') {      //Si el dato es una b enciende el led

            estado = movizq2;
            
            bt.printf("Pieza correcta\n");
            bt.printf("Transportando a soplador\n");
            wait(0.01);
        }
    }
}

void estadomovizq2()
{
    if(final2==0) {
        enable=1; //activar el motor
        dir=0; //direccion hacia la derecha
        step=1; // avanzar
        wait_us(100);
        step=0;
        wait_us(900);
    } else {
        enable=0;
        estado=soplado;
        
        bt.printf("Soplando\n");
    }
}

void estadosoplado()
{
    dirAMotor=0;
    dirBMotor=1;
    wait(7);
    dirAMotor=0;
    dirBMotor=0;
    estado=inicio;
    piezas= piezas+1;

    bt.printf("Reposo\n");
    gOled.printf("Nº de piezas:%d\n",piezas);
    gOled.display();
    gOled.setTextCursor(0,0);
    

}



int main()
{
    int piezas=0;
    float dist;
    pc.baud(115200);
    estado = inicio;
    gOled.begin();
    gOled.clearDisplay();

    repeticion.attach(&medir_corriente, 10.0); //Medir la intensidad cada tres segundos


    while(1) {
        switch (estado) {
            case inicio:
                estadoinicio();
                break;
            case movder:
                estadomovderecha();
                break;
            case calentar:
                estadocalentar();
                break;
            case movizq1:
                estadomovizq1();
                break;
            case centro:
                estadocentro();
                break;
            case movizq2:
                estadomovizq2();
                break;
            case soplado:
                estadosoplado();
                break;
            default:
                break;

        }
    }
}

