/*
    Header for MCP3201 Analog SAR Converter with SPI interface 
    Version: 1.0
    Julio S.
*/

// SPI clock freq. in HZ
// Limits from MCP3201 datasheet are:
// 1500000Hz when vdd=5V
// 800000Hz when vdd=2.7V
// 1MHz should work and is the default value.
#define MCP3201_CLK_FREQ    1000000

// MCP3201 SPI channel pinout
// p5 not wired, there are no commands to send for MCP3201 device
SPI MCP3201(p5,p6,p7);
// take control from CS pin to avoid transition changes between write commands
DigitalOut cs(p8); 


// Read the analog value from MCP3201.
// return 12bit interger (0...4095)
int ReadAnalogMCP3201(void)
{
 //uncommente below line only if the MCP3201_CLK_FREQ is diferrent of 1MHz
 //MCP3201.frequency(MCP3201_CLK_FREQ);
 
 cs=0;
 int high_byte = MCP3201.write(0x00);
 int low_byte = MCP3201.write(0x00);
 cs=1;
 int conv_result = ((high_byte & 0x1f) << 7) | ((low_byte >> 1) & 0x7f);  

 return conv_result;
}