/* 
    Read analog channel from MCP3201 with SPI interface and send it to the serial interface.
    Matlab can be used to evaluate the sampled wave.
*/


#include "mbed.h"

#define VOLTAGE_SAMPLES         255

// for samples serial dumping 
int samples[255];

#include "mcp3201.h"
#include "VoltageRead.h"

Serial pc(USBTX, USBRX); // tx, rx

int main() 
{
    pc.baud(115200);
    pc.printf("Ola Sr. Matlab!");
    
    while(1) 
    {  
        float rms_value=get_voltage_rms();
        for(int i=0;i<VOLTAGE_SAMPLES;i++) pc.printf("%i\r\n", samples[i]);
        //end of com
        pc.printf(" ");
        
        //run Matlab script again to get new sample
        char c = pc.getc();
    }
}

/*
s=serial('COM6','BAUD',115200,'Terminator',' ','InputBufferSize', 8096,'OutputBufferSize',1024);
fopen(s);
fprintf(s,'c','async');
x=fscanf(s);
y=str2num(x);

ADC_OFFSET=floor(1.7*(4096/3.3));
ADC_SCALE=(2110*sqrt(2))/4096; %Valor de Tensao no pino 3.3/4096
VOLTAGE_SAMPLES=256;

t=linspace(0,inv(60)*VOLTAGE_SAMPLES/256,VOLTAGE_SAMPLES-1);

figure(1);
subplot(2,1,1)
%stem(y.*(3.3/4096),'x.'); grid;
stem(y+ADC_OFFSET,'.'); grid;
title('Sampled Wave from MCP3201');
xlabel('Sample Number [0...255]');
ylabel('Sampled Value [0...4095)');

subplot(2,1,2)
stem(y,'.','b'); grid;
title('Offset Adjustment to RMS calculation');
xlabel('Sample Number [0...255]');
ylabel('Sampled Value [-2048...2047)');

figure(2);
stairs(t,y.*(ADC_SCALE)); grid;
title('Reconstructed wave');
xlabel('time [s]');
ylabel('Voltage [Volts)');
%hold on
%plot(y.*(ADC_SCALE),'--');
%hold off

rms=sqrt(mean((y.^2)))*ADC_SCALE;
disp('  Valor RMS')
disp(rms)

fclose(s);
clear s;
% sometimes the channel remains open, use this
% fclose(instrfind)
*/


    

