
#include <math.h>

#define VOLTAGE_SCALE_FACTOR    3.3/4096
#define CHANNEL_OFFSET          1.72*(4096/3.3)//2048


DigitalOut flag(p9);

float get_voltage_rms(void)
{
  
  int sum=0;
  int voltage[VOLTAGE_SAMPLES];

  
  // loop takes 7.3ms
  // with wait_us(1) loop takes 7.65ms. diff = 0.35ms
  // with wait_us(2) loop takes 7.91ms. diff = 0,61ms
  // with wait_us(3) loop takes 8.15ms. diff = 0,85ms
  flag=1;
  for(int i=0;i<VOLTAGE_SAMPLES;i++)
  {
    voltage[i]=(float)ReadAnalogMCP3201() - CHANNEL_OFFSET;
    sum+=(voltage[i]*voltage[i]);
    wait_us(36);
  }  
  flag=0;   
  
  //dump the AD samples to global variable "samples"
  for(int i=0;i<VOLTAGE_SAMPLES;i++) samples[i]=voltage[i];
  
  //calculate RMS
  return (float)sqrt((double)(((float)sum / VOLTAGE_SAMPLES)))*VOLTAGE_SCALE_FACTOR;
      
}