#include "mbed.h"
#include <cmath>
#include "Sensor_auslesen.h"


IRSensor::IRSensor(AnalogIn* distance, DigitalOut* bit0, DigitalOut* bit1, DigitalOut* bit2, int number)
{
    init(distance, bit0, bit1, bit2, number);
}


IRSensor::IRSensor()
{
}

void IRSensor::init(AnalogIn* distance, DigitalOut* bit0, DigitalOut* bit1, DigitalOut* bit2, int number)
{

    this->distance = distance;  // set local references to objects
    this->bit0 = bit0;
    this->bit1 = bit1;
    this->bit2 = bit2;

    this->number = number;
}


/**
 * Deletes the IRSensor object.
 */
IRSensor::~IRSensor() {}

/**
 * Gets the distance measured with the IR sensor in [m].
 * @return the distance, given in [m].
 */
float IRSensor::read()
{
    *bit0 = (number >> 0) & 1;
    *bit1 = (number >> 1) & 1;
    *bit2 = (number >> 2) & 1;

    float d = -0.58f*sqrt(distance->read())+0.58f;  // calculate the distance in [m]
    return d;
}

/**
 * The empty operator is a shorthand notation of the <code>read()</code> method.
 */
IRSensor::operator float()
{

    return read();
}


    
    